/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.teletrain;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.TeletrainExchangeDocument;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import com.gridnine.xtrip.server.parsers2.test.common.ParsersTestUtils;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.test.RailwayTestBase;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class XTR5448Test
extends RailwayTestBase {
    @Test
    public void testProduct() throws Exception {
        TeletrainExchangeDocument exchangeDocument = (TeletrainExchangeDocument)((EntityContainer)ParsersTestUtils.parse(TeletrainExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/XTR-5448.xml")).get(0)).getEntity();
        ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get("com.gridnine.xtrip.common.parsers.model.TeletrainExchangeDocument");
        processor.processExchangeFile((BaseExchangeDocument)exchangeDocument);
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("23.05.2017 11:11:25");
        BlankTypeReference blankType = new BlankTypeReference("\u0420\u0416\u0414 \u042d\u0411");
        RailwayStationReference departureLocation = new RailwayStationReference("2024900");
        RailwayStationReference arriveLocation = new RailwayStationReference("2060150");
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("26.05.2017 13:48:00");
        Date arriveDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("27.05.2017 04:08:00");
        RailwayProduct product = BookingDao.getProduct("73670409783231");
        if (product == null) {
            throw new Exception("product not found!");
        }
        Assert.assertEquals((Object)"URAL", (Object)product.getCarrier().getCode());
        Assert.assertTrue((boolean)CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)product.getReservation(), (String)"248267934", (GdsName)GdsName.TELETRAIN));
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)product.getStatus());
        Assert.assertEquals((Object)TicketType.OWN, (Object)product.getTicketType());
        Assert.assertEquals((Object)blankType, (Object)product.getBlankType());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
        Assert.assertEquals((long)1L, (long)product.getPassengers().size());
        Traveller traveller = (Traveller)product.getPassengers().get(0);
        Assert.assertEquals((Object)"\u0436\u0430\u0440\u0438\u043a\u043e\u0432 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0438\u043d \u0441\u0435\u0440\u0433\u0435\u0435\u0432\u0438\u0447", (Object)traveller.getName());
        Assert.assertEquals((Object)"\u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0438\u043d", (Object)traveller.getPassport().getFirstName());
        Assert.assertEquals((Object)"\u0441\u0435\u0440\u0433\u0435\u0435\u0432\u0438\u0447", (Object)traveller.getPassport().getMiddleName());
        Assert.assertEquals((Object)"\u0436\u0430\u0440\u0438\u043a\u043e\u0432", (Object)traveller.getPassport().getLastName());
        Assert.assertEquals((Object)PassportType.INTERNAL, (Object)traveller.getPassport().getType());
        Assert.assertEquals((Object)"9405659782", (Object)traveller.getPassport().getNumber());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((Object)departureLocation, (Object)segment.getDepartureStation());
        Assert.assertEquals((Object)arriveLocation, (Object)segment.getArriveStation());
        Assert.assertEquals((Object)departureDate, (Object)segment.getDepartureDate());
        Assert.assertEquals((Object)arriveDate, (Object)segment.getArriveDate());
        Assert.assertEquals((Object)"354", (Object)segment.getTrainNumber());
        Assert.assertEquals((Object)"\u0421", (Object)segment.getSlot());
        Assert.assertEquals((Object)"13", (Object)segment.getCarriageNumber());
        Assert.assertEquals((Object)CarriageType.K, (Object)segment.getCarriageType());
        Assert.assertEquals((Object)CompartmentType.COMMON, (Object)segment.getCompartmentType());
        Assert.assertEquals((Object)ServiceClass.K2, (Object)segment.getServiceClass());
        Assert.assertEquals((long)1L, (long)segment.getPlaces().size());
        Assert.assertEquals((Object)"27", segment.getPlaces().get(0));
        Assert.assertEquals((double)2211.0, (double)product.getTotalEquivalentFare().doubleValue(), (double)0.001);
        Assert.assertEquals((double)22.58, (double)product.getTotalEquivalentVAT().doubleValue(), (double)0.001);
    }
}

