/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AeroexpressClassOfService;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.server.parsers2.test.common.ParsersTestUtils;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.BaseUfsAeroexpressTest;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class AeroexpressTest
extends BaseUfsAeroexpressTest {
    @Test
    public void businessTicketTest() throws Exception {
        this.processDocument((UFSExchangeDocument)((EntityContainer)ParsersTestUtils.parse(UFSExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/business.xml"), (boolean)false).get(0)).getEntity());
        AeroexpressTicket product = this.getProduct("671531");
        Assert.assertEquals((Object)"671531", (Object)product.getSystemNumber());
        Assert.assertEquals((Object)"MOW", (Object)product.getDepartureLocation().getCode());
        Assert.assertEquals((Object)"airport DME", (Object)product.getArrivalLocation().getCode());
        Assert.assertEquals((Object)AeroexpressClassOfService.BUSINESS, (Object)product.getClassOfService());
        Assert.assertEquals((Object)new BigDecimal("1000.00"), (Object)product.getEquivalentFare());
        ArrayList fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("1000.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(0)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((GeneralProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("1000.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(1)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((GeneralProductContractRelationData)fops.get(1)).getDescription().getUid());
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("16.06.2017 07:30:00");
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("04.05.2017 16:55:47");
        Assert.assertEquals((Object)departureDate, (Object)product.getDepartureDate());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
    }

    @Test
    public void childTicketTest() throws Exception {
        this.processDocument((UFSExchangeDocument)((EntityContainer)ParsersTestUtils.parse(UFSExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/child.xml"), (boolean)false).get(0)).getEntity());
        AeroexpressTicket product = this.getProduct("671533");
        Assert.assertEquals((Object)"671533", (Object)product.getSystemNumber());
        Assert.assertNull((Object)product.getDepartureLocation());
        Assert.assertNull((Object)product.getArrivalLocation());
        Assert.assertEquals((Object)AeroexpressClassOfService.CHILD, (Object)product.getClassOfService());
        Assert.assertEquals((Object)new BigDecimal("130.00"), (Object)product.getEquivalentFare());
        ArrayList fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("130.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(0)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((GeneralProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("130.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(1)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((GeneralProductContractRelationData)fops.get(1)).getDescription().getUid());
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("05.05.2017 00:00:00");
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("04.05.2017 16:56:29");
        Assert.assertEquals((Object)departureDate, (Object)product.getDepartureDate());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
    }

    @Test
    public void roundtripTicketTest() throws Exception {
        this.processDocument((UFSExchangeDocument)((EntityContainer)ParsersTestUtils.parse(UFSExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/roundtrip.xml"), (boolean)false).get(0)).getEntity());
        AeroexpressTicket product = this.getProduct("671532");
        Assert.assertEquals((Object)"671532", (Object)product.getSystemNumber());
        Assert.assertNull((Object)product.getDepartureLocation());
        Assert.assertNull((Object)product.getArrivalLocation());
        Assert.assertEquals((Object)AeroexpressClassOfService.ROUNDTRIP, (Object)product.getClassOfService());
        Assert.assertEquals((Object)new BigDecimal("800.00"), (Object)product.getEquivalentFare());
        ArrayList fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("800.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(0)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((GeneralProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("800.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(1)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((GeneralProductContractRelationData)fops.get(1)).getDescription().getUid());
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("19.07.2017 00:00:00");
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("04.05.2017 16:56:10");
        Assert.assertEquals((Object)departureDate, (Object)product.getDepartureDate());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
    }

    @Test
    public void commonTicketTest() throws Exception {
        this.processDocument((UFSExchangeDocument)((EntityContainer)ParsersTestUtils.parse(UFSExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/common.xml"), (boolean)false).get(0)).getEntity());
        AeroexpressTicket product = this.getProduct("1000000063799846");
        Assert.assertEquals((Object)"1000000063799846", (Object)product.getSystemNumber());
        Assert.assertNull((Object)product.getDepartureLocation());
        Assert.assertNull((Object)product.getArrivalLocation());
        Assert.assertEquals((Object)AeroexpressClassOfService.COMMON, (Object)product.getClassOfService());
        Assert.assertEquals((Object)new BigDecimal("470.00"), (Object)product.getEquivalentFare());
        ArrayList fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("470.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(0)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((GeneralProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("470.00"), (Object)((GeneralProductFop)((GeneralProductContractRelationData)fops.get(1)).getFops().get(0)).getEquivalentAmount());
        Assert.assertEquals((long)1L, (long)((GeneralProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((GeneralProductContractRelationData)fops.get(1)).getDescription().getUid());
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("13.04.2017 00:00:00");
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("10.04.2017 15:44:03");
        Assert.assertEquals((Object)departureDate, (Object)product.getDepartureDate());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
    }
}

