/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UFSAeroexpressTicketDataTargetProvider
extends BaseTargetsProvider<Document> {
    public static final String EXCHANGE_FILE_ENCODING = "utf8";

    public Collection<Document> getTargets(MessageContext ctx) throws Exception {
        ExchangeFile file = (ExchangeFile)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        return this.createDocumentList(file);
    }

    private List<Document> createDocumentList(ExchangeFile file) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(file.getContent()), (String)EXCHANGE_FILE_ENCODING));
        Element root = document.getDocumentElement();
        ArrayList<TicketInfo> ticketInfos = new ArrayList<TicketInfo>();
        Element[] tickets = XmlUtil.getElements((Element)root, (String)"Ticket").length > 0 ? XmlUtil.getElements((Element)root, (String)"Ticket") : XmlUtil.getElements((Element)root, (String)"ticket");
        for (Element ticketElement : tickets) {
            String id = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"Id")).orElse(XHelper.readString((Element)ticketElement, (String)"id"));
            if (id == null) continue;
            TicketInfo ticketInfo = new TicketInfo();
            ticketInfo.setTicketElement(ticketElement);
            ticketInfos.add(ticketInfo);
        }
        for (TicketInfo ticketInfo : ticketInfos) {
            for (Element ticketElement : tickets) {
                root.removeChild(ticketElement);
            }
            root.appendChild(ticketInfo.getTicketElement());
            Document newDocument = documentBuilder.newDocument();
            newDocument.appendChild(newDocument.importNode(root, true));
            documents.add(newDocument);
        }
        return documents;
    }

    private static class TicketInfo {
        private Element ticketElement;

        private TicketInfo() {
        }

        public void setTicketElement(Element ticketElement) {
            this.ticketElement = ticketElement;
        }

        public Element getTicketElement() {
            return this.ticketElement;
        }
    }
}

