/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MultiThread;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class UFSExchangeFileChangeTypeTask
extends BaseLongRunningTask<Serializable> {
    Set<String> uids = null;
    AtomicInteger n = new AtomicInteger(0);

    public void fromXML(Element elm) throws Exception {
        this.uids = ConcurrentHashMap.newKeySet();
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.uids.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        if (this.uids != null) {
            for (String item : this.uids) {
                Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
                itemElement.setAttribute("uid", item.trim());
            }
        }
    }

    public void configure(Serializable configuration) throws Exception {
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.updateUFSExhcangeFileChangeTypeTaskHandlerName, (Object[])new Object[0]);
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        List uidsList;
        EntityStorage storage = EntityStorage.get();
        if (this.uids == null || this.uids.size() == 0) {
            this.uids = ConcurrentHashMap.newKeySet();
            uidsList = LogicalStorage.get().getEntityStorage().getEntityUids(UFSExchangeDocument.class, null, null, false, true, SortOrder.DESC, null);
            uidsList.parallelStream().forEach(uid -> this.uids.add((String)uid));
        } else {
            uidsList = this.uids.stream().collect(Collectors.toList());
        }
        int count = uidsList.size();
        MultiThread.execute((String)((Object)((Object)this)).getClass().getName(), (int)4, (int)100, (Collection)uidsList, argSubset -> argSubset.stream().forEach(uid -> {
            try {
                LogicalStorage.get().authorizeAsSystem();
                EntityContainer container = storage.load(UFSExchangeDocument.class, uid);
                UFSExchangeDocument entity = (UFSExchangeDocument)container.getEntity();
                if (entity.getType() != UFSExchangeDocument.class.getName()) {
                    entity.setType(UFSExchangeDocument.class.getName());
                    storage.save(container, true);
                    this.uids.remove(uid);
                }
                byte progress = (byte)(100 * this.n.get() / count);
                if (this.n.get() % 100 == 0) {
                    callback.updateProgress(progress);
                }
            }
            catch (Exception e) {
                this.log.error(String.format("unable to update ufs document %s", uid), (Throwable)e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 {0}", (Throwable)e, (Object[])new Object[]{uid}));
            }
        }));
        callback.taskFinished();
    }
}

