/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class UFSHandleRegisterExchangeDocumentAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (ExceptionUtil.isInterruptedError((Throwable)e)) {
            this.log.warn("interrupted exception occurred", e);
            ctx.putObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED, (Object)Boolean.TRUE);
        }
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.UFSExchangeProcessor_importFailed, (Throwable)e, (Object[])new Object[]{e.getMessage()}));
        return true;
    }

    public void after(MessageContext context) throws Exception {
        Collection messages = context.getMessagesReadOnly();
        Boolean interruptedExceptionOccurred = (Boolean)context.getObject((Enum)IBusParsersContextKeys.INTERRUPTED_EXCEPTION_OCCURRED);
        if (MessageHelper.hasMessages((Collection)messages, (MessageType)MessageType.ERROR)) {
            ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
            String checkSum = (String)context.getMandatoryObject((Enum)IBusParsersContextKeys.CHECK_SUM);
            UFSExchangeDocument exchangeDocument = new UFSExchangeDocument();
            exchangeDocument.setContentType(ContentType.XML);
            exchangeDocument.setContent(new String(file.getContent(), "utf-8").getBytes("utf-8"));
            exchangeDocument.setLocation(file.getLocation());
            exchangeDocument.setCreated(file.getCreated());
            exchangeDocument.setType(file.getType());
            exchangeDocument.setCheckSum(checkSum);
            exchangeDocument.setStatus(Boolean.TRUE.equals(interruptedExceptionOccurred) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
            exchangeDocument.getMessages().clear();
            exchangeDocument.getMessages().addAll(messages);
            EntityStorage.get().save(EntityContainer.create((BaseEntity)exchangeDocument), true);
        }
    }
}

