/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UFSHelper {
    public static final String SOURCE_ENCODING = "utf-8";
    public static final String STORE_ENCODING = "utf-8";
    public static final String EXCHANGE_FILE_ENCODING = "utf-8";

    public static SimpleDateFormat getDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public static SimpleDateFormat getBirthdayDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public static PassportType getPassportType(String passportTypeCode) {
        if (TextUtil.nonBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u041c")) {
                return PassportType.SEAMANSID;
            }
            if (passportTypeCode.equals("\u0412\u0411")) {
                return PassportType.MILITARYID;
            }
        }
        return null;
    }

    public static boolean compareTravellers(Traveller traveller01, Traveller traveller02) {
        String fullName02;
        String fullName01;
        if (traveller01 == null && traveller02 == null) {
            return true;
        }
        if (traveller01 == null || traveller02 == null) {
            return false;
        }
        if (traveller01.getPassport() != null && traveller02.getPassport() != null) {
            fullName01 = TextUtil.buildFullName((PersonalName)traveller01.getPassport());
            fullName02 = TextUtil.buildFullName((PersonalName)traveller02.getPassport());
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        if (traveller01.getName() != null && traveller02.getName() != null) {
            fullName01 = traveller01.getName();
            fullName02 = traveller02.getName();
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        return false;
    }

    static BigDecimal getAmount(List<UFSRailwayData.FareComponent> fareComponents, String name) {
        return UFSHelper.getFareComponentsValue(fareComponents, name, UFSRailwayData.FareComponent::getAmount);
    }

    static BigDecimal getVatValue(List<UFSRailwayData.FareComponent> fareComponents, String name) {
        BigDecimal vatValue = UFSHelper.getFareComponentsValue(fareComponents, name, UFSRailwayData.FareComponent::getVat);
        boolean vatApplicable = UFSHelper.getFareComponents(fareComponents, name).stream().map(UFSRailwayData.FareComponent::getVatRateType).anyMatch(CommonRailwayParsersHelper::isVatApplicable);
        return vatValue != null ? vatValue : (vatApplicable ? BigDecimal.ZERO : null);
    }

    private static BigDecimal getFareComponentsValue(List<UFSRailwayData.FareComponent> fareComponents, String name, Function<UFSRailwayData.FareComponent, BigDecimal> function) {
        return UFSHelper.getFareComponents(fareComponents, name).stream().map(function).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    private static List<UFSRailwayData.FareComponent> getFareComponents(List<UFSRailwayData.FareComponent> fareComponents, String name) {
        return fareComponents.stream().filter(c -> c.getName() != null).filter(c -> c.getName().toUpperCase().startsWith(name)).collect(Collectors.toList());
    }

    static Double calculateRate(BigDecimal basis, BigDecimal vat) {
        if (vat == null) {
            return null;
        }
        return vat.multiply(BigDecimal.valueOf(100L)).divide(basis.subtract(vat), 0, 4).doubleValue();
    }

    public static ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    public static CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    public static DictionaryReference<PassengerType> getPassengerType(String string) {
        if (TextUtil.isBlank((String)string)) {
            return null;
        }
        if (TextUtil.isSame((String)string, (String)"\u041f\u041b", (boolean)true)) {
            return DictHelper.getAdultPassengerType();
        }
        if (TextUtil.isSame((String)string, (String)"\u0414\u0422", (boolean)true)) {
            return DictHelper.getChildPassengerType();
        }
        if (TextUtil.isSame((String)string, (String)"\u0411\u0421", (boolean)true)) {
            return DictHelper.getInfantPassengerType();
        }
        return null;
    }

    public static List<String> parsePlaces(String placesData) {
        ArrayList<String> places = new ArrayList<String>();
        if (!TextUtil.isBlank((String)placesData)) {
            for (String place : placesData.trim().split(",")) {
                if (place.contains("-")) {
                    String[] values = place.split("-");
                    if (values.length != 2) continue;
                    Integer startPlace = Integer.valueOf(values[0].trim());
                    Integer endPlace = Integer.valueOf(values[1].trim());
                    if (startPlace > endPlace) continue;
                    for (int i = startPlace.intValue(); i <= endPlace; ++i) {
                        places.add(String.valueOf(i));
                    }
                    continue;
                }
                places.add(place);
            }
        }
        return places;
    }
}

