/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSAeroexpressData;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UFSParseAeroexpressTicketCommonExchangeDataProcessor
extends BaseProcessor {
    public static final String BLANK_OWNER_CODE = "\u0423\u0424\u0421";

    public void process(MessageContext context) throws Exception {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        UFSAeroexpressData data = (UFSAeroexpressData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        this.parse(document, data);
    }

    public void parse(Document document, UFSAeroexpressData data) throws Exception {
        HashSet<Message> messages = new HashSet<Message>();
        Element root = document.getDocumentElement();
        data.setContent(XUtil.toString((Element)root, (String)"utf-8"));
        String pnr = Optional.ofNullable(XHelper.readString((Element)root, (String)"IdTrans")).orElse(XHelper.readString((Element)root, (String)"idtrans"));
        data.setPnr(pnr);
        String terminal = Optional.ofNullable(XHelper.readString((Element)root, (String)"Terminal")).orElse(XHelper.readString((Element)root, (String)"terminal"));
        data.setTerminal(terminal);
        String direction = Optional.ofNullable(XHelper.readString((Element)root, (String)"Direction")).orElse(XHelper.readString((Element)root, (String)"direction"));
        data.setDirectionCode(direction);
        String airportCode = Optional.ofNullable(XHelper.readString((Element)root, (String)"Airport")).orElse(XHelper.readString((Element)root, (String)"airport"));
        data.setAirportCode(airportCode);
        BigDecimal amount = Optional.ofNullable(XHelper.readBigDecimal((Element)root, (String)"Amount")).orElse(XHelper.readBigDecimal((Element)root, (String)"amount"));
        data.setAmount(amount);
        String departDateString = Optional.ofNullable(XHelper.readString((Element)root, (String)"DepartDate")).orElse(XHelper.readString((Element)root, (String)"departdate"));
        Date departDate = UFSHelper.getDateTimeFormat().parse(departDateString);
        data.setDepartureDate(departDate);
        Element ticketElement = Optional.ofNullable(XmlUtil.getElement((Element)root, (String)"Ticket")).orElse(XmlUtil.getElement((Element)root, (String)"ticket"));
        BigDecimal ticketPrice = Optional.ofNullable(XHelper.readBigDecimal((Element)ticketElement, (String)"Price")).orElse(XHelper.readBigDecimal((Element)ticketElement, (String)"price"));
        data.setTicketPrice(ticketPrice);
        String ticketId = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"Id")).orElse(XHelper.readString((Element)ticketElement, (String)"id"));
        data.setTicketId(ticketId);
        String tariff = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"Tariff")).orElse(XHelper.readString((Element)ticketElement, (String)"tariff"));
        data.setTariff(tariff);
        String issueDateString = Optional.ofNullable(XHelper.readString((Element)root, (String)"CurTime")).orElse(XHelper.readString((Element)root, (String)"curtime"));
        Date issueDate = UFSHelper.getDateTimeFormat().parse(issueDateString);
        data.setIssueDate(issueDate);
        String classCode = Optional.ofNullable(XHelper.readString((Element)root, (String)"Class")).orElse(XHelper.readString((Element)root, (String)"class"));
        data.setClassCode(classCode);
        String travellerName = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"PassengerFio")).orElse(XHelper.readString((Element)ticketElement, (String)"passengerfio"));
        if (TextUtil.nonBlank((String)travellerName)) {
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            String passportNumber = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"PassengerDocNumber")).orElse(XHelper.readString((Element)ticketElement, (String)"passengerdocnumber"));
            travellerName = travellerName.replaceAll("[\\d-]", "");
            PassportType passportType = null;
            String passportTypeCode = Optional.ofNullable(XHelper.readString((Element)ticketElement, (String)"PassengerDocType")).orElse(XHelper.readString((Element)ticketElement, (String)"passengerdoctype"));
            if (!TextUtil.isBlank((String)passportTypeCode) && (passportType = UFSHelper.getPassportType(passportTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_travellerPassportTypeDefineFailed, (Object[])new Object[]{travellerName}), (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
            }
            passport.setType(passportType);
            passport.setNumber(passportNumber);
            TextUtil.splitFullName((String)travellerName, (PersonalName)passport);
            traveller.setName(travellerName);
            traveller.setCyrillicName(TextUtil.translit((String)travellerName, (boolean)false));
            traveller.setPassport(passport);
            data.setTraveller(traveller);
        }
        TicketType ticketType = TicketType.OWN;
        String transactionTypeCode = Optional.ofNullable(XHelper.readString((Element)root, (String)"Type")).orElse(XHelper.readString((Element)root, (String)"type"));
        data.setTransactionType(this.getTransactionType(transactionTypeCode));
        data.setTicketType(ticketType);
        data.setBlankTypeCode("AE_ETKT");
        data.setBlankOwnerCode(BLANK_OWNER_CODE);
        data.getMessages().clear();
        data.getMessages().addAll(messages);
    }

    private TransactionType getTransactionType(String transactionTypeCode) {
        if (!TextUtil.isBlank((String)transactionTypeCode)) {
            switch (transactionTypeCode) {
                case "1": {
                    return TransactionType.SELL;
                }
                case "14": {
                    return TransactionType.REFUND;
                }
                case "13": {
                    return TransactionType.CANCEL;
                }
            }
            return null;
        }
        return null;
    }
}

