/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UFSParseRailwayProductCommonExchangeDataProcessor
extends BaseProcessor {
    public static final String BLANK_TYPE_CODE = "\u0423\u0424\u0421 ETKT";
    public static final String BLANK_OWNER_CODE = "\u0423\u0424\u0421";

    public void process(MessageContext context) throws Exception {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        UFSRailwayData data = (UFSRailwayData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        Boolean registrationPhase = (Boolean)context.getObject((Enum)IBusParsersContextKeys.REGISTRATION_PHASE);
        boolean registration = registrationPhase != null && registrationPhase != false;
        this.parse(document.getDocumentElement(), data);
    }

    private void parse(Element element, UFSRailwayData ufsData) throws Exception {
        CompartmentType compartmentType;
        Iterator arriveStationsIterator;
        RailwayStation arriveLocation;
        Iterator departureStationsIterator;
        RailwayStation departureLocation;
        List carrierNames;
        HashSet<Message> messages = new HashSet<Message>();
        TransactionType transactionType = null;
        ufsData.setContent(XUtil.toString((Element)element, (String)"utf-8"));
        String transactionTypeCode = XHelper.readString((Element)element, (String)"Type");
        if (!TextUtil.isBlank((String)transactionTypeCode) && (transactionType = this.getTransactionType(transactionTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_transactionTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_transactionTypeWithCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
        }
        String pnr = null;
        if (transactionType == TransactionType.SELL) {
            pnr = XHelper.readString((Element)element, (String)"TransID");
        } else if (transactionType == TransactionType.REFUND) {
            pnr = XHelper.readString((Element)element, (String)"PrevTransID");
        }
        String carrierInn = XHelper.readString((Element)element, (String)"CarrierInn");
        String carrierNamesString = XHelper.readString((Element)element, (String)"Carrier");
        String brandString = XHelper.readString((Element)element, (String)"Brand");
        DictionaryReference carrier = null;
        if (TextUtil.nonBlank((String)carrierNamesString) && (carrier = (DictionaryReference)(carrierNames = Arrays.stream(carrierNamesString.split("/")).filter(TextUtil::nonBlank).map(String::trim).distinct().collect(Collectors.toList())).stream().flatMap(name -> DictionaryCache.get().lookup(RailwayCarrier.class, name, new String[0]).stream()).distinct().map(RailwayCarrier::toReference).findFirst().orElse(null)) == null) {
            for (String carrierName : carrierNames) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UFSExchangeProcessor_carrierNotFound, (Object[])new Object[]{carrierName}));
            }
        }
        RailwayStationReference departureStation = null;
        String departureStationCode = XHelper.readString((Element)element, (String)"StationFrom@Code");
        Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)departureStationCode);
        if (departureLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
        if (departureLocation != null) {
            departureStation = departureLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{departureStationCode}), (Object[])new Object[0]));
        }
        if (departureStation == null) {
            String departureStationShortName = XHelper.readString((Element)element, (String)"StationFrom");
            departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationShortName);
            if (departureLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameMultipleFound, (Object[])new Object[]{departureStationShortName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation2 = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
            if (departureLocation != null) {
                departureStation = departureLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameNotFound, (Object[])new Object[]{departureStationShortName}), (Object[])new Object[0]));
            }
        }
        RailwayStationReference arriveStation = null;
        String arriveStationCode = XHelper.readString((Element)element, (String)"StationTo@Code");
        Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arriveStationCode);
        if (arriveLocations.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeMultipleFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        RailwayStation railwayStation3 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
        if (arriveLocation != null) {
            arriveStation = arriveLocation.toReference();
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithCodeNotFound, (Object[])new Object[]{arriveStationCode}), (Object[])new Object[0]));
        }
        if (arriveLocation == null) {
            String arriveStationShortName = XHelper.readString((Element)element, (String)"StationTo");
            arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationShortName);
            if (arriveLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameMultipleFound, (Object[])new Object[]{arriveStationShortName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation4 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
            if (arriveLocation != null) {
                arriveStation = arriveLocation.toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_stationWithShortNameNotFound, (Object[])new Object[]{arriveStationShortName}), (Object[])new Object[0]));
            }
        }
        Date issueDate = null;
        String issueDateString = XHelper.readString((Element)element, (String)"ConfirmTime");
        if (!TextUtil.isBlank((String)issueDateString)) {
            try {
                issueDate = UFSHelper.getDateTimeFormat().parse(issueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_issueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date departureDate = null;
        String departureDateString = XHelper.readString((Element)element, (String)"DepartTime");
        if (!TextUtil.isBlank((String)departureDateString)) {
            try {
                departureDate = UFSHelper.getDateTimeFormat().parse(departureDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_departureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date arriveDate = null;
        String arriveDateString = XHelper.readString((Element)element, (String)"ArrivalTime");
        if (!TextUtil.isBlank((String)arriveDateString)) {
            try {
                arriveDate = UFSHelper.getDateTimeFormat().parse(arriveDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_arriveDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        String trainData = XHelper.readString((Element)element, (String)"TrainNum");
        String pattern = "^([\\d]+)([\\D]*)$";
        Matcher matcher = Pattern.compile(pattern).matcher(trainData);
        String trainNumber = null;
        String slot = null;
        if (matcher.matches()) {
            trainNumber = matcher.group(1);
            slot = matcher.group(2);
        } else {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_trainDataDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dataHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
        }
        String carriageNumber = XHelper.readString((Element)element, (String)"CarNum");
        CarriageType carriageType = null;
        String carriageTypeCode = XHelper.readString((Element)element, (String)"CarType");
        if (!TextUtil.isBlank((String)carriageTypeCode) && (carriageType = UFSHelper.getCarriageType(carriageTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_carriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_carriageTypeWithCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
        }
        String agentCode = XHelper.readString((Element)element, (String)"Terminal");
        String pccCode = XHelper.readString((Element)element, (String)"Terminal");
        String compartmentTypeCode = XHelper.readString((Element)element, (String)"GenderClass");
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            compartmentType = this.getCompartmentType(compartmentTypeCode);
            if (compartmentType == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_compartmentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_compartmentTypeWithCodeNotSupported, (Object[])new Object[]{compartmentTypeCode}), (Object[])new Object[0]));
            }
        } else {
            compartmentType = CompartmentType.COMMON;
        }
        ServiceClass serviceClass = null;
        String serviceClassCode = XHelper.readString((Element)element, (String)"ServiceClass");
        if (!TextUtil.isBlank((String)serviceClassCode) && (serviceClass = UFSHelper.getServiceClass(serviceClassCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_serviceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
        }
        String systemNumber = null;
        String krsNumber = null;
        BigDecimal totalAmount = null;
        BigDecimal tariffAmount = null;
        BigDecimal serviceAmount = null;
        BigDecimal totalVatAmount = null;
        BigDecimal tariffVatAmount = null;
        BigDecimal serviceVatAmount = null;
        BigDecimal segmentAmount = null;
        BigDecimal reservedSeatAmount = null;
        ArrayList<UFSRailwayData.FareComponent> fareComponents = new ArrayList<UFSRailwayData.FareComponent>();
        Element blankElement = XmlUtil.getElement((Element)element, (String)"Blank");
        if (blankElement != null) {
            String reservedSeatAmountString;
            String segmentAmountAmountString;
            String string;
            String tariffVatAmountString;
            systemNumber = XHelper.readString((Element)blankElement, (String)"TicketNum");
            krsNumber = XHelper.readString((Element)blankElement, (String)"RefundReceiptNum");
            String totalAmountString = XHelper.readString((Element)blankElement, (String)"Amount");
            if (!TextUtil.isBlank((String)totalAmountString)) {
                try {
                    totalAmount = new BigDecimal(totalAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankTotalAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(tariffVatAmountString = XHelper.readString((Element)blankElement, (String)"AmountNDS")))) {
                try {
                    tariffVatAmount = new BigDecimal(tariffVatAmountString);
                }
                catch (NumberFormatException numberFormatException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankTariffVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (!TextUtil.isBlank((String)(string = XHelper.readString((Element)blankElement, (String)"ServiceNDS")))) {
                try {
                    serviceVatAmount = new BigDecimal(string);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankServiceVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (tariffVatAmount != null || serviceVatAmount != null) {
                totalVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffVatAmount, serviceVatAmount});
            }
            double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate);
            if (totalAmount != null && serviceVatAmount != null && vatRate != 0.0) {
                serviceAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVatAmount.doubleValue() / vatRate * (100.0 + vatRate)), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, MiscUtil.negate((BigDecimal)serviceAmount)});
            }
            if (!TextUtil.isBlank((String)(segmentAmountAmountString = XHelper.readString((Element)blankElement, (String)"TicketAmount")))) {
                try {
                    segmentAmount = new BigDecimal(segmentAmountAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankSegmentAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if ((reservedSeatAmountString = XHelper.readString((Element)blankElement, (String)"ReservedSeatAmount")) == null) {
                reservedSeatAmountString = XHelper.readString((Element)blankElement, (String)"ResevedSeatAmount");
            }
            if (!TextUtil.isBlank((String)reservedSeatAmountString)) {
                try {
                    reservedSeatAmount = new BigDecimal(reservedSeatAmountString);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.UFSExchangeProcessor_blankReservedSeatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            for (Element fareComponentElement : XmlUtil.getElements((Element)blankElement, (String)"FareInfo/Component")) {
                String vatString;
                UFSRailwayData.FareComponent fareComponent = new UFSRailwayData.FareComponent();
                fareComponent.setName(XHelper.readString((Element)fareComponentElement, (String)"ComponentName"));
                String amountString = XHelper.readString((Element)fareComponentElement, (String)"ComponentCost");
                if (TextUtil.nonBlank((String)amountString)) {
                    try {
                        fareComponent.setAmount(new BigDecimal(amountString));
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UFSExchangeProcessor_fareComponentFareDefineFailed, (Throwable)e, (Object[])new Object[]{amountString}));
                    }
                }
                if (TextUtil.nonBlank((String)(vatString = XHelper.readString((Element)fareComponentElement, (String)"Vat")))) {
                    try {
                        fareComponent.setVat(new BigDecimal(vatString));
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UFSExchangeProcessor_fareComponentFareDefineFailed, (Throwable)e, (Object[])new Object[]{vatString}));
                    }
                }
                fareComponent.setVatRateType(XHelper.readString((Element)fareComponentElement, (String)"VatRateType"));
                fareComponents.add(fareComponent);
            }
        }
        ArrayList<UFSRailwayData.TravellerData> travellers = new ArrayList<UFSRailwayData.TravellerData>();
        ArrayList<String> places = new ArrayList<String>();
        for (Element passengerElement : XmlUtil.getElements((Element)element, (String)"Passenger")) {
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            String passportNumber = XHelper.readString((Element)passengerElement, (String)"DocNum");
            String name2 = XHelper.readString((Element)passengerElement, (String)"Name");
            String passengerTypeCode = XHelper.readString((Element)passengerElement, (String)"Type");
            DictionaryReference<PassengerType> passengerType = UFSHelper.getPassengerType(passengerTypeCode);
            if (passengerType == null) {
                messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_PassengerTypeNotFound, (Object[])new Object[]{passengerTypeCode}), (Object[])new Object[0]));
            }
            if (!TextUtil.isBlank((String)name2)) {
                name2 = name2.replaceAll("[\\d-]", "");
            }
            PassportType passportType = null;
            String passportTypeCode = XHelper.readString((Element)passengerElement, (String)"DocType");
            if (!TextUtil.isBlank((String)passportTypeCode) && (passportType = UFSHelper.getPassportType(passportTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_travellerPassportTypeDefineFailed, (Object[])new Object[]{name2}), (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
            }
            Gender gender = null;
            String genderCode = XHelper.readString((Element)passengerElement, (String)"R");
            if (!TextUtil.isBlank((String)genderCode) && (gender = this.getGender(genderCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_genderDefineFailed, (Object[])new Object[]{name2}), (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_genderWithCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
            }
            Date birthday = null;
            String birthdayString = XHelper.readString((Element)passengerElement, (String)"BirthDay");
            if (!TextUtil.isBlank((String)birthdayString)) {
                try {
                    birthday = UFSHelper.getBirthdayDateFormat().parse(birthdayString);
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_birthdayDateDefineFailed, (Object[])new Object[]{name2}), (String)L10nResourcesManager.getStr((String)Messages.UFSExchangeProcessor_dateHasWrongFormat, (Object[])new Object[]{birthdayString}), (Object[])new Object[0]));
                }
            }
            String placesData = XHelper.readString((Element)passengerElement, (String)"Place");
            try {
                places.addAll(UFSHelper.parsePlaces(placesData));
            }
            catch (NumberFormatException e) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.UFSExchangeProcessor_railwayProductPlaceDefineFailed, (Throwable)e, (Object[])new Object[0]));
            }
            passport.setType(passportType);
            passport.setNumber(passportNumber);
            passport.setBirthday(birthday);
            passport.setGender(gender);
            TextUtil.splitFullName((String)name2, (PersonalName)passport);
            traveller.setName(name2);
            traveller.setCyrillicName(TextUtil.translit((String)name2, (boolean)false));
            traveller.setBirthday(birthday);
            traveller.setGender(gender);
            traveller.setPassport(passport);
            UFSRailwayData.TravellerData travellerData = new UFSRailwayData.TravellerData();
            travellerData.setTraveller(traveller);
            travellerData.setPassengerType(passengerType);
            travellers.add(travellerData);
        }
        String string = BLANK_TYPE_CODE;
        String blankOwnerCode = BLANK_OWNER_CODE;
        TicketType ticketType = TicketType.OWN;
        ufsData.setContent(XUtil.toString((Element)element, (String)"utf-8"));
        ufsData.setTransactionType(transactionType);
        ufsData.setPnr(pnr);
        ufsData.setCarrierInn(carrierInn);
        ufsData.setBrand(brandString);
        ufsData.setCarrier((DictionaryReference<RailwayCarrier>)carrier);
        ufsData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
        ufsData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
        ufsData.setSystemNumber(systemNumber);
        ufsData.setKrsNumber(krsNumber);
        ufsData.setIssueDate(issueDate);
        ufsData.setDepartureDate(departureDate);
        ufsData.setArriveDate(arriveDate);
        ufsData.setTrainNumber(trainNumber);
        ufsData.setSlot(slot);
        ufsData.setCarriageNumber(carriageNumber);
        ufsData.setCarriageType(carriageType);
        ufsData.setAgentCode(agentCode);
        ufsData.setPccCode(pccCode);
        ufsData.setTotalAmount(totalAmount);
        ufsData.setTariffAmount(tariffAmount);
        ufsData.setServiceAmount(serviceAmount);
        ufsData.setTotalVatAmount(totalVatAmount);
        ufsData.setTariffVatAmount(tariffVatAmount);
        ufsData.setServiceVatAmount(serviceVatAmount);
        ufsData.setSegmentAmount(segmentAmount);
        ufsData.setReservedSeatAmount(reservedSeatAmount);
        ufsData.setCompartmentType(compartmentType);
        ufsData.setServiceClass(serviceClass);
        ufsData.setBlankTypeCode(string);
        ufsData.setBlankOwnerCode(blankOwnerCode);
        ufsData.setTicketType(ticketType);
        ufsData.getTravellers().clear();
        ufsData.getTravellers().addAll(travellers);
        ufsData.getPlaces().clear();
        ufsData.getPlaces().addAll(places);
        ufsData.getFareComponents().clear();
        ufsData.getFareComponents().addAll(fareComponents);
        ufsData.getMessages().clear();
        ufsData.getMessages().addAll(messages);
    }

    private TransactionType getTransactionType(String transactionTypeCode) {
        if (!TextUtil.isBlank((String)transactionTypeCode)) {
            if (transactionTypeCode.equals("1")) {
                return TransactionType.SELL;
            }
            if (transactionTypeCode.equals("14")) {
                return TransactionType.REFUND;
            }
            if (transactionTypeCode.equals("13")) {
                return TransactionType.CANCEL;
            }
        }
        return null;
    }

    private CompartmentType getCompartmentType(String compartmentTypeCode) {
        if (!TextUtil.isBlank((String)compartmentTypeCode)) {
            if (compartmentTypeCode.equals("0")) {
                return CompartmentType.COMMON;
            }
            if (compartmentTypeCode.equals("1")) {
                return CompartmentType.MEN;
            }
            if (compartmentTypeCode.equals("2")) {
                return CompartmentType.WOMEN;
            }
        }
        return null;
    }

    private Gender getGender(String genderCode) {
        if (!TextUtil.isBlank((String)genderCode)) {
            if (genderCode.equals("\u041c\u0423\u0416")) {
                return Gender.MALE;
            }
            if (genderCode.equals("\u0416\u0415\u041d")) {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTrace(Exception e) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            String string = baos.toString("utf-8");
            return string;
        }
    }
}

