/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;

public class UFSProductTypeRoutingKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext context) throws Exception {
        if (context.hasObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE)) {
            return this.getRoutingKeyByExchangeFile(context);
        }
        return this.getRoutingKeyByExchangeDocumentEntity(context);
    }

    private String getRoutingKeyByExchangeFile(MessageContext context) throws XMLStreamException {
        ExchangeFile file = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        XMLStreamReader streamReader = XSUtil.getXMLInputFactory().createXMLStreamReader(new ByteArrayInputStream(file.getContent()));
        while (streamReader.hasNext()) {
            if (streamReader.next() != 1) continue;
            return this.getRoutingKeyByString(streamReader.getLocalName());
        }
        return "UNKNOWN_PRODUCT";
    }

    private String getRoutingKeyByExchangeDocumentEntity(MessageContext context) throws XMLStreamException {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        return this.getRoutingKeyByString(document.getDocumentElement().getNodeName());
    }

    private String getRoutingKeyByString(String value) {
        switch (value) {
            case "UFS_RZhD_Gate": {
                return "RAILWAY_PRODUCT";
            }
            case "UFS_AE_Gate": 
            case "ufs_ae_gate": {
                return "AEROEXPRESS_TICKET";
            }
        }
        return "UNKNOWN_PRODUCT";
    }
}

