/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import java.util.List;

public class UFSRailwayProductCreateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        UFSRailwayData data = (UFSRailwayData)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        String checkSum = (String)context.getMandatoryObject((Enum)IBusParsersContextKeys.CHECK_SUM);
        ExchangeFile exchangeFile = (ExchangeFile)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_FILE);
        List exchangeDocumentsList = (List)context.getMandatoryObject((Enum)IBusParsersContextKeys.REGISTRING_DOCUMENTS_LIST);
        UFSExchangeDocument ufsExchangeDocument = new UFSExchangeDocument();
        ufsExchangeDocument.setCreated(exchangeFile.getCreated());
        ufsExchangeDocument.setCheckSum(checkSum);
        ufsExchangeDocument.setTitle(exchangeFile.getLocation());
        ufsExchangeDocument.setLocation(exchangeFile.getLocation());
        ufsExchangeDocument.setContent(data.getContent().getBytes("utf-8"));
        ufsExchangeDocument.setType(UFSExchangeDocument.class.getName());
        ufsExchangeDocument.setContentType(ContentType.XML);
        ufsExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
        ufsExchangeDocument.getMessages().clear();
        ufsExchangeDocument.setProductType(ProductType.RAILWAY_PRODUCT);
        this.updateDocumentData(ufsExchangeDocument, data);
        exchangeDocumentsList.add(ufsExchangeDocument);
    }

    private void updateDocumentData(UFSExchangeDocument index, UFSRailwayData ufsData) {
        index.setSystemNumber(ufsData.getSystemNumber());
        index.setTransactionType(ufsData.getTransactionType());
        index.setIssued(ufsData.getIssueDate());
        index.getTravellers().clear();
        for (UFSRailwayData.TravellerData travellerData : ufsData.getTravellers()) {
            Traveller traveller = travellerData.getTraveller();
            index.getTravellers().add(traveller.getName());
        }
    }
}

