/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressClassOfService;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSAeroexpressData;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class UFSUpdateAeroexpressTicketCommonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UFSAeroexpressData data = (UFSAeroexpressData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult productSearchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        AeroexpressTicket product = (AeroexpressTicket)productSearchResult.getProduct();
        EntityContainer bookingFileContainer = productSearchResult.getBookingFile();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        if (this.log.isDebugEnabled()) {
            this.log.debug("ufs parse data -> \n\n" + data);
        }
        this.update(ctx, product, bookingFile, data);
    }

    private void update(MessageContext context, AeroexpressTicket product, BookingFile bookingFile, UFSAeroexpressData data) throws Exception {
        String pcc = data.getTerminal();
        String agentCode = data.getTerminal();
        ArrayList messages = new ArrayList();
        String blankOwnerUid = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.AEROEXPRESS_PROFILE_UID, null);
        if (blankOwnerUid != null) {
            EntityReference blankOwner = new EntityReference(blankOwnerUid, Organization.class, null);
            EntityStorage.get().actualize(blankOwner, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
            product.setBlankOwner(blankOwner);
        }
        ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)data.getBlankOwnerCode(), null, null, (String)agentCode, null, (String)pcc, (GdsName)GdsName.UFS, (Date)data.getIssueDate(), messages);
        EntityReference provider = salesContextData.getProvider();
        AeroexpressTicketHelper.setSupplier((AeroexpressTicket)product, (EntityReference)salesContextData.getSupplier());
        EntityReference agency = salesContextData.getAgency();
        AeroexpressTicketHelper.setAgency((AeroexpressTicket)product, (EntityReference)agency);
        AeroexpressTicketHelper.setSubagency((AeroexpressTicket)product, (EntityReference)salesContextData.getSubagency());
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        String pccCode = salesContextData.getPccCode();
        context.addMessages(messages);
        context.addMessages(data.getMessages());
        product.setProvider(provider);
        product.setAgent(agent);
        product.setBlankType(AeroexpressTicketHelper.findBlankType((String)data.getBlankTypeCode()));
        product.setDepartureDate(data.getDepartureDate());
        product.setPcc(pccCode);
        product.setSalesPoint(salesPoint);
        product.setIssueDate(data.getIssueDate());
        product.setSystemNumber(data.getTicketId());
        product.setStatus(ProductStatus.SELL);
        product.setArrivalLocation(this.getArrivalLocation(data.getAirportCode(), data.getDirectionCode()));
        product.setDepartureLocation(this.getDepartureLocation(data.getAirportCode(), data.getDirectionCode()));
        product.setClassOfService(this.getClassOfService(data.getClassCode()));
        Traveller productTraveller = data.getTraveller();
        if (productTraveller != null) {
            Object reservationTraveller = (Traveller)CollectionUtil.find((Collection)product.getReservation().getBookingFile().getTravellers(), (Object)productTraveller, UFSHelper::compareTravellers);
            if (reservationTraveller != null) {
                ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, (Traveller)reservationTraveller);
            } else {
                ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, productTraveller);
            }
        }
        product.setContractRulesApplied(false);
        product.setEquivalentFare(data.getTicketPrice());
        switch (data.getClassCode()) {
            case "1": {
                product.setClassOfService(AeroexpressClassOfService.COMMON);
                break;
            }
        }
        AeroexpressTicketHelper.createProductFops((AeroexpressTicket)product, (boolean)true);
        AeroexpressTicketHelper.getClientFops((AeroexpressTicket)product).forEach(fop -> fop.setEquivalentAmount(product.getEquivalentFare()));
        AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)product).forEach(fop -> fop.setEquivalentAmount(product.getEquivalentFare()));
        AeroexpressTicketHelper.getSubagentFops((AeroexpressTicket)product, (boolean)false).forEach(fop -> fop.setEquivalentAmount(product.getEquivalentFare()));
        Reservation reservation = product.getReservation();
        if (reservation.getBookingAgent() == null) {
            reservation.setBookingAgent(agent);
        }
        if (reservation.getSalesPoint() == null) {
            reservation.setSalesPoint(salesPoint);
        }
        if (reservation.getResDate() == null) {
            reservation.setResDate(data.getIssueDate());
        }
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.UFS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)data.getPnr());
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(data.getIssueDate());
        }
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(agency);
        }
        if (product.getTraveller() != null && !bookingFile.getTravellers().contains(product.getTraveller())) {
            bookingFile.getTravellers().add(product.getTraveller());
        }
    }

    private DictionaryReference<GeoLocation> getArrivalLocation(String airport, String direction) {
        switch (direction) {
            case "1": {
                return this.getAirport(airport);
            }
            case "2": {
                return this.getRailwayStation();
            }
            case "3": {
                return null;
            }
            case "4": {
                return null;
            }
        }
        return null;
    }

    private DictionaryReference<GeoLocation> getDepartureLocation(String airport, String direction) {
        switch (direction) {
            case "1": {
                return this.getRailwayStation();
            }
            case "2": {
                return this.getAirport(airport);
            }
            case "3": {
                return null;
            }
            case "4": {
                return null;
            }
        }
        return null;
    }

    private DictionaryReference<GeoLocation> getAirport(String airport) {
        GeoLocation result;
        if (!Environment.isPublished(DictionaryCache.class)) {
            return null;
        }
        if (airport == null) {
            return null;
        }
        String airportCode = null;
        switch (airport) {
            case "1": {
                airportCode = "airport VKO";
                break;
            }
            case "2": {
                airportCode = "airport DME";
                break;
            }
            case "3": {
                airportCode = "airport SVO";
            }
        }
        if (airportCode != null && (result = (GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, airportCode)) != null) {
            return result.toReference();
        }
        return null;
    }

    private DictionaryReference<GeoLocation> getRailwayStation() {
        if (!Environment.isPublished(DictionaryCache.class)) {
            return null;
        }
        GeoLocation result = (GeoLocation)DictionaryCache.get().findByCode(GeoLocation.class, "MOW");
        if (result != null) {
            return result.toReference();
        }
        return null;
    }

    private AeroexpressClassOfService getClassOfService(String classOfServiceCode) {
        switch (classOfServiceCode) {
            case "1": {
                return AeroexpressClassOfService.COMMON;
            }
            case "2": {
                return AeroexpressClassOfService.BUSINESS;
            }
            case "3": {
                return AeroexpressClassOfService.CHILD;
            }
            case "4": {
                return AeroexpressClassOfService.ROUNDTRIP;
            }
        }
        return null;
    }
}

