/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;

public class UFSUpdateExchangeDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        UFSExchangeDocument exchangeDocument = (UFSExchangeDocument)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT);
        ProductSearchResult searchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        exchangeDocument.setOwner(searchResult.getBookingFile().toReference());
        exchangeDocument.setRelatedBookingFile(searchResult.getBookingFile().toReference());
        exchangeDocument.getMessages().clear();
        exchangeDocument.getMessages().addAll(context.getMessagesReadOnly());
        if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.ERROR)) {
            exchangeDocument.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages((Collection)exchangeDocument.getMessages(), (MessageType)MessageType.WARNING)) {
            exchangeDocument.setStatus(ProcessingStatus.WARNING);
        } else {
            exchangeDocument.setStatus(ProcessingStatus.OK);
        }
    }
}

