/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UFSUpdateRailwayProductCommonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UFSRailwayData data = (UFSRailwayData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult productSearchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        EntityContainer bookingFileContainer = productSearchResult.getBookingFile();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        if (this.log.isDebugEnabled()) {
            this.log.debug("ufs parse data -> \n\n" + data);
        }
        this.update(ctx, product, bookingFile, data);
    }

    private void update(MessageContext context, RailwayProduct product, BookingFile bookingFile, UFSRailwayData ufsData) throws Exception {
        BigDecimal serviceVatAmount;
        BigDecimal serviceAmount;
        BigDecimal equivalentReservedSeatVatAmount;
        BigDecimal equivalentReservedSeatAmount;
        BigDecimal equivalentSegmentVatAmount;
        BigDecimal equivalentSegmentAmount;
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)ufsData.getTransactionType());
        String systemNumber = ufsData.getSystemNumber();
        Date issueDate = ufsData.getIssueDate();
        String blankTypeCode = ufsData.getBlankTypeCode();
        TicketType ticketType = ufsData.getTicketType();
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        product.setCarrier(CommonRailwayParsersHelper.getCarrier(ufsData.getCarrierInn(), context));
        ArrayList messages = new ArrayList();
        String agentCode = ufsData.getAgentCode();
        String invoicePccCode = ufsData.getPccCode();
        ParsersHelper.SalesContextData salesContextData = ParsersHelper.getSalesContextData((String)ufsData.getBlankOwnerCode(), null, null, (String)agentCode, null, (String)invoicePccCode, (GdsName)GdsName.UFS, (Date)ufsData.getIssueDate(), messages);
        EntityReference blankOwner = salesContextData.getBlankOwner();
        EntityReference provider = salesContextData.getProvider();
        EntityReference supplier = salesContextData.getSupplier();
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        String validatorCode = salesContextData.getValidatorCode();
        String pccCode = salesContextData.getPccCode();
        context.addMessages(ufsData.getMessages());
        context.addMessages(messages);
        int number = 1;
        DictionaryReference<RailwayStation> departureStation = ufsData.getDepartureStation();
        DictionaryReference<RailwayStation> arriveStation = ufsData.getArriveStation();
        String trainNumber = ufsData.getTrainNumber();
        String slot = ufsData.getSlot();
        String carriageNumber = ufsData.getCarriageNumber();
        CarriageType carriageType = ufsData.getCarriageType();
        CompartmentType compartmentType = ufsData.getCompartmentType();
        ServiceClass serviceClass = ufsData.getServiceClass();
        DictionaryReference<RailwayCarrier> carrier = ufsData.getCarrier();
        List<String> places = ufsData.getPlaces();
        Date departureDate = ufsData.getDepartureDate();
        Date arriveDate = ufsData.getArriveDate();
        if (!ufsData.getFareComponents().isEmpty()) {
            equivalentSegmentAmount = UFSHelper.getAmount(ufsData.getFareComponents(), "\u0422\u0410\u0420\u0418\u0424 \u0411\u0418\u041b\u0415\u0422\u0410");
            equivalentSegmentVatAmount = UFSHelper.getVatValue(ufsData.getFareComponents(), "\u0422\u0410\u0420\u0418\u0424 \u0411\u0418\u041b\u0415\u0422\u0410");
        } else {
            equivalentSegmentAmount = ufsData.getSegmentAmount();
            equivalentSegmentVatAmount = null;
        }
        Money segmentFare = null;
        if (equivalentSegmentAmount != null) {
            segmentFare = new Money();
            segmentFare.setValue(equivalentSegmentAmount);
            segmentFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(number);
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.setCompartmentType(compartmentType);
        segment.setServiceClass(serviceClass);
        segment.setCarrier(carrier);
        segment.setBrand(ufsData.getBrand());
        segment.getPlaces().clear();
        segment.getPlaces().addAll(places);
        segment.setDepartureDate(departureDate);
        segment.setArriveDate(arriveDate);
        segment.setFare(segmentFare);
        segment.setEquivalentFare(equivalentSegmentAmount);
        segment.setEquivalentVAT(equivalentSegmentVatAmount);
        if (!ufsData.getFareComponents().isEmpty()) {
            equivalentReservedSeatAmount = UFSHelper.getAmount(ufsData.getFareComponents(), "\u0422\u0410\u0420\u0418\u0424 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b");
            equivalentReservedSeatVatAmount = UFSHelper.getVatValue(ufsData.getFareComponents(), "\u0422\u0410\u0420\u0418\u0424 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b");
        } else {
            equivalentReservedSeatAmount = ufsData.getReservedSeatAmount();
            equivalentReservedSeatVatAmount = null;
        }
        Money reservedSeatAmount = null;
        if (equivalentReservedSeatAmount != null) {
            reservedSeatAmount = new Money();
            reservedSeatAmount.setValue(equivalentReservedSeatAmount);
            reservedSeatAmount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        ReservedSeat reservedSeat = new ReservedSeat();
        reservedSeat.setSegment(segment);
        reservedSeat.setFare(reservedSeatAmount);
        reservedSeat.setEquivalentFare(equivalentReservedSeatAmount);
        reservedSeat.setEquivalentVAT(equivalentReservedSeatVatAmount);
        if (!ufsData.getFareComponents().isEmpty()) {
            serviceAmount = UFSHelper.getAmount(ufsData.getFareComponents(), "\u0421\u0415\u0420\u0412\u0418\u0421");
            serviceVatAmount = UFSHelper.getVatValue(ufsData.getFareComponents(), "\u0421\u0415\u0420\u0412\u0418\u0421");
        } else {
            serviceAmount = ufsData.getServiceAmount();
            serviceVatAmount = ufsData.getServiceVatAmount();
        }
        BigDecimal totalEquivalentFare = ufsData.getTotalAmount();
        BigDecimal totalEquivalentVAT = ufsData.getTotalVatAmount();
        BigDecimal tariffAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivalentSegmentAmount, equivalentReservedSeatAmount});
        BigDecimal tariffVatAmount = !ufsData.getFareComponents().isEmpty() ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivalentSegmentVatAmount, equivalentReservedSeatVatAmount}) : ufsData.getTariffVatAmount();
        VatDetalization vendorVatDetalization = new VatDetalization();
        if (!ufsData.getFareComponents().isEmpty() || tariffVatAmount != null || serviceVatAmount != null) {
            VatComponent vatComponent;
            Double vatRate;
            vendorVatDetalization.setDetalized(true);
            product.setDontRecalculateVAT(!ufsData.getFareComponents().isEmpty());
            vendorVatDetalization.getComponents().clear();
            if (!(MiscUtil.isZero((BigDecimal)tariffAmount, (boolean)true) || ufsData.getFareComponents().isEmpty() && tariffVatAmount == null)) {
                vatRate = !ufsData.getFareComponents().isEmpty() ? UFSHelper.calculateRate(tariffAmount, tariffVatAmount) : Double.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)issueDate));
                vatComponent = new VatComponent();
                vatComponent.setBasis(tariffAmount);
                vatComponent.setSum(tariffVatAmount);
                vatComponent.setRate(vatRate);
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (!(MiscUtil.isZero((BigDecimal)serviceAmount, (boolean)true) || ufsData.getFareComponents().isEmpty() && serviceVatAmount == null)) {
                vatRate = !ufsData.getFareComponents().isEmpty() ? UFSHelper.calculateRate(serviceAmount, serviceVatAmount) : Double.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate));
                vatComponent = new VatComponent();
                vatComponent.setBasis(serviceAmount);
                vatComponent.setSum(serviceVatAmount);
                vatComponent.setRate(vatRate);
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
        }
        ArrayList<RailwayProductFop> vendorFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            vendorFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> subagentFOPs = new ArrayList<RailwayProductFop>();
        if (agency != null && subagency != null && !agency.equals((Object)subagency) && totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            subagentFOPs.add(fop);
        }
        ArrayList<RailwayProductFop> clientFOPs = new ArrayList<RailwayProductFop>();
        if (totalEquivalentFare != null) {
            Money amount = new Money();
            amount.setValue(totalEquivalentFare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        product.setStatus(status);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(issueDate);
        product.setValidatorCode(validatorCode);
        product.setPcc(pccCode);
        product.setEquivalentFare(tariffAmount);
        product.setEquivalentVAT(tariffVatAmount);
        product.setServiceFare(serviceAmount);
        product.setServiceVAT(serviceVatAmount);
        product.setTotalEquivalentFare(totalEquivalentFare);
        product.setTotalEquivalentVAT(totalEquivalentVAT);
        product.setVendorVatDetalization(vendorVatDetalization);
        product.setContractRulesApplied(false);
        product.setBlankType(blankType);
        product.setBlankOwnerRef(blankOwner);
        product.setProvider(provider);
        product.getSegments().clear();
        product.getSegments().add(segment);
        product.getReservedSeats().clear();
        product.getReservedSeats().add(reservedSeat);
        for (Object item : RailwayProductHelper.getContractRelations((RailwayProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    item.getFops().clear();
                    item.getFops().addAll(vendorFOPs);
                    break;
                }
                case SUBAGENCY: {
                    item.getFops().clear();
                    item.getFops().addAll(subagentFOPs);
                    break;
                }
                case CLIENT: {
                    item.getFops().clear();
                    item.getFops().addAll(clientFOPs);
                }
            }
        }
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)supplier);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
        if (product.getSalesPoint() == null) {
            product.setSalesPoint(salesPoint);
        }
        if (product.getCashier() == null) {
            product.setCashier(agent);
        }
        product.setTicketType(ticketType);
        boolean updatedProduct = false;
        block6: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(product.getUid())) continue;
                updatedProduct = true;
                continue block6;
            }
        }
        boolean bookingFileContainsNonFakeSell = false;
        boolean bookingFileContainsNonFakeRefund = false;
        block8: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        bookingFileContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        bookingFileContainsNonFakeRefund = true;
                    }
                }
                if (!bookingFileContainsNonFakeSell || !bookingFileContainsNonFakeRefund) continue;
                continue block8;
            }
        }
        if (!bookingFileContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !bookingFileContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
            bookingFile.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
            bookingFile.setCreateDate(product.getIssueDate());
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            DictionaryReference passengerType;
            Traveller traveller;
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)ufsData.getPnr())) continue;
            boolean reservationContainsNonFakeSell = false;
            boolean reservationContainsNonFakeRefund = false;
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        reservationContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        reservationContainsNonFakeRefund = true;
                    }
                }
                if (!reservationContainsNonFakeSell || !reservationContainsNonFakeRefund) continue;
                break;
            }
            if (!reservationContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !reservationContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
                reservation.setBookingAgent(product.getCashier());
                reservation.setSalesPoint(product.getSalesPoint());
                reservation.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
                reservation.setResDate(product.getIssueDate());
                product.getReservation().getGdsNameInfo().getSystemInfos().stream().filter(s -> s.getRecordLocators().stream().anyMatch(rl -> ufsData.getPnr().equals(rl.getRecordLocator()))).findFirst().ifPresent(rsi -> rsi.setGdsName(GdsName.UFS));
            }
            HashMap<Traveller, DictionaryReference> travellers = new HashMap<Traveller, DictionaryReference>();
            List bookingTravellers = bookingFile.getTravellers();
            for (UFSRailwayData.TravellerData travellerData : ufsData.getTravellers()) {
                traveller = travellerData.getTraveller();
                passengerType = travellerData.getPassengerType();
                boolean contains = false;
                for (Traveller bookingTraveller : bookingTravellers) {
                    if (!UFSHelper.compareTravellers(traveller, bookingTraveller)) continue;
                    contains = true;
                    travellers.put(bookingTraveller, passengerType);
                    break;
                }
                if (contains) continue;
                travellers.put(traveller, passengerType);
                bookingTravellers.add(traveller);
            }
            product.getPassengers().clear();
            product.getPassengerTypes().clear();
            for (Map.Entry entry : travellers.entrySet()) {
                traveller = (Traveller)entry.getKey();
                passengerType = (DictionaryReference)entry.getValue();
                product.getPassengers().add(traveller);
                RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)passengerType);
            }
            if (updatedProduct) break;
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            break;
        }
    }

    private DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }
}

