/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UFSRailwayData;
import java.math.BigDecimal;
import java.util.Date;

public class UFSUpdateRailwayProductRefundProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UFSRailwayData data = (UFSRailwayData)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult searchResult = (ProductSearchResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.SEARCH_RESULT);
        RailwayProduct refundProduct = (RailwayProduct)searchResult.getProduct();
        RailwayProduct sellProduct = refundProduct.getPreviousProduct();
        refundProduct.setKrsNumber(data.getKrsNumber());
        if (sellProduct.getTicketType() != TicketType.FAKE) {
            this.synchronizeSellAndRefundData(sellProduct, refundProduct, data);
        }
    }

    private void synchronizeSellAndRefundData(RailwayProduct sellProduct, RailwayProduct refundProduct, UFSRailwayData data) throws Exception {
        VatDetalization vendorVatDetalization;
        BigDecimal penaltyVat;
        int refundProductSegmentNumber;
        for (RailwaySegment sellProductSegment : sellProduct.getSegments()) {
            int sellProductSegmentNumber = sellProductSegment.getNumber();
            for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                int refundProductSegmentNumber2 = refundProductSegment.getNumber();
                if (refundProductSegmentNumber2 != sellProductSegmentNumber) continue;
                refundProductSegment.setFare(sellProductSegment.getFare());
                refundProductSegment.setEquivalentFare(sellProductSegment.getEquivalentFare());
                refundProductSegment.setEquivalentVAT(sellProductSegment.getEquivalentVAT());
            }
        }
        refundProduct.getReservedSeats().clear();
        for (ReservedSeat sellProductReservedSeat : sellProduct.getReservedSeats()) {
            ReservedSeat refundProductReservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)sellProductReservedSeat, (boolean)true);
            refundProductReservedSeat.setSegment(null);
            RailwaySegment sellProductReservedSeatSegment = sellProductReservedSeat.getSegment();
            if (sellProductReservedSeatSegment != null) {
                int sellProductReservedSeatSegmentNumber = sellProductReservedSeatSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductReservedSeatSegmentNumber) continue;
                    refundProductReservedSeat.setSegment(refundProductSegment);
                }
            }
            refundProduct.getReservedSeats().add(refundProductReservedSeat);
        }
        refundProduct.getTaxes().clear();
        for (RailwayTax sellProductTax : sellProduct.getTaxes()) {
            RailwayTax refundProductTax = (RailwayTax)XCloneHelper.clone((XCloneable)sellProductTax);
            refundProductTax.setSegment(null);
            RailwaySegment sellProductTaxSegment = sellProductTax.getSegment();
            if (sellProductTaxSegment != null) {
                int sellProductTaxSegmentNumber = sellProductTaxSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductTaxSegmentNumber) continue;
                    refundProductTax.setSegment(refundProductSegment);
                }
            }
            refundProduct.getTaxes().add(refundProductTax);
        }
        refundProduct.setEquivalentFare(sellProduct.getEquivalentFare());
        refundProduct.setEquivalentVAT(sellProduct.getEquivalentVAT());
        refundProduct.setServiceFare(sellProduct.getServiceFare());
        refundProduct.setServiceVAT(sellProduct.getServiceVAT());
        BigDecimal sellTotalEquivalentFare = sellProduct.getTotalEquivalentFare();
        BigDecimal refundTotalEquivalentFare = refundProduct.getTotalEquivalentFare();
        BigDecimal penaltyAmount = data.getFareComponents().isEmpty() ? (sellTotalEquivalentFare != null && refundTotalEquivalentFare != null ? sellTotalEquivalentFare.subtract(refundTotalEquivalentFare) : null) : UFSHelper.getAmount(data.getFareComponents(), "\u0421\u0411\u041e\u0420 \u0417\u0410 \u0412\u041e\u0417\u0412\u0420\u0410\u0422");
        if (!MiscUtil.isZero((BigDecimal)penaltyAmount, (boolean)true)) {
            if (!data.getFareComponents().isEmpty()) {
                penaltyVat = UFSHelper.getVatValue(data.getFareComponents(), "\u0421\u0411\u041e\u0420 \u0417\u0410 \u0412\u041e\u0417\u0412\u0420\u0410\u0422");
            } else {
                double vatRate = RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.PENALTY, (Date)refundProduct.getIssueDate());
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(penaltyAmount, vatRate);
                penaltyVat = vatAmount.getVatAmount();
            }
        } else {
            penaltyVat = null;
        }
        BigDecimal reservedSeatsDeduction = UFSHelper.getAmount(data.getFareComponents(), "\u0423\u0414\u0415\u0420\u0416\u0410\u041d\u0418\u0415 \u0427\u0410\u0421\u0422\u0418 \u0422\u0410\u0420\u0418\u0424\u0410 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b");
        BigDecimal reservedSeatsDeductionVat = !MiscUtil.isZero((BigDecimal)reservedSeatsDeduction, (boolean)true) ? UFSHelper.getVatValue(data.getFareComponents(), "\u0423\u0414\u0415\u0420\u0416\u0410\u041d\u0418\u0415 \u0427\u0410\u0421\u0422\u0418 \u0422\u0410\u0420\u0418\u0424\u0410 \u041f\u041b\u0410\u0426\u041a\u0410\u0420\u0422\u042b") : null;
        refundProduct.setPenalty(penaltyAmount);
        refundProduct.setPenaltyVAT(penaltyVat);
        if (reservedSeatsDeduction != null) {
            ReservedSeat reservedSeat = (ReservedSeat)CollectionUtil.head((Iterable)refundProduct.getReservedSeats());
            if (reservedSeat != null) {
                reservedSeat.setEquivalentDeduction(reservedSeatsDeduction);
                reservedSeat.setEquivalentDeductionVAT(reservedSeatsDeductionVat);
            }
            if (refundProduct.getEquivalentFare() != null) {
                refundProduct.setEquivalentFare(refundProduct.getEquivalentFare().subtract(reservedSeatsDeduction));
            }
            if (reservedSeatsDeductionVat != null && refundProduct.getEquivalentVAT() != null) {
                refundProduct.setEquivalentVAT(refundProduct.getEquivalentVAT().subtract(reservedSeatsDeductionVat));
            }
        }
        if ((vendorVatDetalization = refundProduct.getVendorVatDetalization()) != null) {
            if (!MiscUtil.isZero((BigDecimal)penaltyAmount, (boolean)true)) {
                VatComponent vatComponent = new VatComponent();
                vatComponent.setBasis(MiscUtil.negate((BigDecimal)penaltyAmount));
                vatComponent.setSum(MiscUtil.negate((BigDecimal)penaltyVat));
                vatComponent.setRate(UFSHelper.calculateRate(penaltyAmount, penaltyVat));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.PENALTY);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (!MiscUtil.isZero((BigDecimal)reservedSeatsDeduction, (boolean)true)) {
                VatComponent vatComponent = new VatComponent();
                vatComponent.setBasis(MiscUtil.negate((BigDecimal)reservedSeatsDeduction));
                vatComponent.setSum(MiscUtil.negate((BigDecimal)reservedSeatsDeductionVat));
                vatComponent.setRate(UFSHelper.calculateRate(reservedSeatsDeduction, reservedSeatsDeductionVat));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.DEDUCTION);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
        }
        BigDecimal sellTotalEquivalentVat = sellProduct.getTotalEquivalentVAT();
        BigDecimal refundTotalEquivalentVat = null;
        if (sellTotalEquivalentVat != null) {
            refundTotalEquivalentVat = sellTotalEquivalentVat;
        }
        if (penaltyVat != null) {
            refundTotalEquivalentVat = refundTotalEquivalentVat == null ? penaltyVat.negate() : refundTotalEquivalentVat.subtract(penaltyVat);
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
    }
}

