/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UfsRailwayTestBase;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class XTR10043Test
extends UfsRailwayTestBase {
    @Test
    public void testPassengerType() throws Exception {
        this.testProduct();
    }

    private void testProduct() throws Exception {
        this.parseFile("testdata/ufs_online_20190718152847105.xml");
        Collection reservationsByPnr = BookingDao.getReservationsByPnr((String)"126076292", (GdsName)GdsName.UFS);
        Reservation reservation = (Reservation)reservationsByPnr.iterator().next();
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> "75396880523801".equals(p.getSystemNumber())).findFirst().orElse(null);
        Assert.assertNotNull((Object)product);
        this.assertHaveTraveller(product, "\u0412\u0418\u041d\u041e\u0413\u0420\u0410\u0414\u041e\u0412\u0410 \u0415\u041b\u0418\u0417\u0410\u0412\u0415\u0422\u0410 \u0412\u041b\u0410\u0414\u0418\u0421\u041b\u0410\u0412\u041e\u0412\u041d\u0410", (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType());
    }

    private void assertHaveTraveller(RailwayProduct product, String name, DictionaryReference<PassengerType> passengerType) {
        Traveller traveller = product.getPassengers().stream().filter(t -> name.equals(t.getName())).findFirst().orElseThrow(() -> new RuntimeException("Traveller not found with name " + name));
        DictionaryReference foundPassengerType = product.getPassengerTypes().stream().filter(type -> traveller.equals((Object)type.getTraveller())).map(PassengerTypeReference::getPassengerType).findFirst().orElseThrow(() -> new RuntimeException("Passenger type not found for traveller " + name));
        Assert.assertEquals(passengerType, (Object)foundPassengerType);
    }
}

