/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UfsRailwayTestBase;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XTR10949Test
extends UfsRailwayTestBase {
    @Test
    public void testUfsSellUfsRefundIurRefund() throws Exception {
        this.parseFile("testdata/XTR10949Sell.xml");
        this.parseFile("testdata/XTR10949Refund.xml");
        RailwayProduct refundProduct = BookingDao.getProduct("74316797345413", ProductStatus.REFUND);
        Assert.assertNotNull((Object)refundProduct);
        Assert.assertEquals((long)1L, (long)refundProduct.getReservedSeats().size());
        ReservedSeat reservedSeat = (ReservedSeat)refundProduct.getReservedSeats().get(0);
        this.assertBigDecimal(new BigDecimal("2424.40"), reservedSeat.getEquivalentFare());
        this.assertBigDecimal(BigDecimal.ZERO, reservedSeat.getEquivalentVAT());
        this.assertBigDecimal(new BigDecimal("1212.20"), reservedSeat.getEquivalentDeduction());
        this.assertBigDecimal(null, reservedSeat.getEquivalentDeductionVAT());
        this.assertBigDecimal(new BigDecimal("2343.80"), refundProduct.getEquivalentFare());
        this.assertBigDecimal(new BigDecimal("2442.30"), refundProduct.getTotalEquivalentFare());
        List clientFops = RailwayProductHelper.getClientFops((RailwayProduct)refundProduct);
        Assert.assertEquals((long)1L, (long)clientFops.size());
        this.assertBigDecimal(new BigDecimal("2442.30"), ((RailwayProductFop)clientFops.get(0)).getAmount().getValue());
        RailwayProduct sellProduct = refundProduct.getPreviousProduct();
        Assert.assertNotNull((Object)sellProduct);
        Assert.assertEquals((long)1L, (long)sellProduct.getReservedSeats().size());
        Assert.assertNull((Object)((ReservedSeat)sellProduct.getReservedSeats().get(0)).getEquivalentDeduction());
    }

    private void assertBigDecimal(BigDecimal expected, BigDecimal actual) {
        Assert.assertTrue((String)String.format("expected: %s, actual: %s", expected, actual), (boolean)MiscUtil.equals((Object)expected, (Object)actual));
    }
}

