/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import com.gridnine.xtrip.server.parsers2.test.common.ParsersTestUtils;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.test.RailwayTestBase;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class XTR2842Test
extends RailwayTestBase {
    @Test
    public void testProduct() throws Exception {
        UFSExchangeDocument exchangeDocument = (UFSExchangeDocument)((EntityContainer)ParsersTestUtils.parse(UFSExchangeDocument.class, (URL)((Object)((Object)this)).getClass().getResource("testdata/xtr2842.xml")).get(0)).getEntity();
        ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get("com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument");
        processor.processExchangeFile((BaseExchangeDocument)exchangeDocument);
        Date issueDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("10.01.2014 19:05:29");
        BlankTypeReference blankType = new BlankTypeReference("\u0423\u0424\u0421 ETKT");
        RailwayStationReference departureLocation = new RailwayStationReference("2000002");
        RailwayStationReference arriveLocation = new RailwayStationReference("2034130");
        Date departureDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("31.01.2014 17:08:00");
        Date arriveDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse("01.02.2014 19:00:00");
        RailwayProduct product = BookingDao.getProduct("37752527348901");
        if (product == null) {
            throw new Exception("product not found!");
        }
        Assert.assertTrue((boolean)CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)product.getReservation(), (String)"61873802", (GdsName)GdsName.UFS));
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)product.getStatus());
        Assert.assertEquals((Object)TicketType.OWN, (Object)product.getTicketType());
        Assert.assertEquals((Object)blankType, (Object)product.getBlankType());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
        Assert.assertEquals((long)1L, (long)product.getPassengers().size());
        Traveller traveller = (Traveller)product.getPassengers().get(0);
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d\u041e\u0412 \u0418\u0412\u0410\u041d \u0418\u0412\u0410\u041d\u041e\u0412\u0418\u0427", (Object)traveller.getName());
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d", (Object)traveller.getPassport().getFirstName());
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d\u041e\u0412\u0418\u0427", (Object)traveller.getPassport().getMiddleName());
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d\u041e\u0412", (Object)traveller.getPassport().getLastName());
        Assert.assertEquals((Object)PassportType.INTERNAL, (Object)traveller.getPassport().getType());
        Assert.assertEquals((Object)"4125852456", (Object)traveller.getPassport().getNumber());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((Object)departureLocation, (Object)segment.getDepartureStation());
        Assert.assertEquals((Object)arriveLocation, (Object)segment.getArriveStation());
        Assert.assertEquals((Object)departureDate, (Object)segment.getDepartureDate());
        Assert.assertEquals((Object)arriveDate, (Object)segment.getArriveDate());
        Assert.assertEquals((Object)"032", (Object)segment.getTrainNumber());
        Assert.assertEquals((Object)"\u0415", (Object)segment.getSlot());
        Assert.assertEquals((Object)"15", (Object)segment.getCarriageNumber());
        Assert.assertEquals((Object)CarriageType.P, (Object)segment.getCarriageType());
        Assert.assertEquals((Object)CompartmentType.COMMON, (Object)segment.getCompartmentType());
        Assert.assertEquals((long)1L, (long)segment.getPlaces().size());
        Assert.assertEquals((Object)"001", segment.getPlaces().get(0));
        Assert.assertEquals((double)2941.8, (double)product.getTotalEquivalentFare().doubleValue(), (double)0.001);
        Assert.assertEquals((double)448.33, (double)product.getTotalEquivalentVAT().doubleValue(), (double)0.001);
        ArrayList fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("2941.80"), (Object)((RailwayProductFop)((RailwayProductContractRelationData)fops.get(0)).getFops().get(0)).getAmount().getValue().setScale(2, 7));
        Assert.assertEquals((long)1L, (long)((RailwayProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((RailwayProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("2941.80"), (Object)((RailwayProductFop)((RailwayProductContractRelationData)fops.get(1)).getFops().get(0)).getAmount().getValue().setScale(2, 7));
        Assert.assertEquals((long)1L, (long)((RailwayProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((RailwayProductContractRelationData)fops.get(1)).getDescription().getUid());
        product = BookingDao.getProduct("37752527348902");
        if (product == null) {
            throw new Exception("product not found!");
        }
        Assert.assertTrue((boolean)CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)product.getReservation(), (String)"61873802", (GdsName)GdsName.UFS));
        Assert.assertEquals((Object)ProductStatus.SELL, (Object)product.getStatus());
        Assert.assertEquals((Object)TicketType.OWN, (Object)product.getTicketType());
        Assert.assertEquals((Object)blankType, (Object)product.getBlankType());
        Assert.assertEquals((Object)issueDate, (Object)product.getIssueDate());
        Assert.assertEquals((long)1L, (long)product.getPassengers().size());
        traveller = (Traveller)product.getPassengers().get(0);
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d\u041e\u0412\u0410 \u0418\u0420\u0418\u041d\u0410 \u041f\u0415\u0422\u0420\u041e\u0412\u041d\u0410", (Object)traveller.getName());
        Assert.assertEquals((Object)"\u0418\u0420\u0418\u041d\u0410", (Object)traveller.getPassport().getFirstName());
        Assert.assertEquals((Object)"\u041f\u0415\u0422\u0420\u041e\u0412\u041d\u0410", (Object)traveller.getPassport().getMiddleName());
        Assert.assertEquals((Object)"\u0418\u0412\u0410\u041d\u041e\u0412\u0410", (Object)traveller.getPassport().getLastName());
        Assert.assertEquals((Object)PassportType.INTERNAL, (Object)traveller.getPassport().getType());
        Assert.assertEquals((Object)"4501258569", (Object)traveller.getPassport().getNumber());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        segment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertEquals((Object)departureLocation, (Object)segment.getDepartureStation());
        Assert.assertEquals((Object)arriveLocation, (Object)segment.getArriveStation());
        Assert.assertEquals((Object)departureDate, (Object)segment.getDepartureDate());
        Assert.assertEquals((Object)arriveDate, (Object)segment.getArriveDate());
        Assert.assertEquals((Object)"032", (Object)segment.getTrainNumber());
        Assert.assertEquals((Object)"\u0415", (Object)segment.getSlot());
        Assert.assertEquals((Object)"15", (Object)segment.getCarriageNumber());
        Assert.assertEquals((Object)CarriageType.P, (Object)segment.getCarriageType());
        Assert.assertEquals((Object)CompartmentType.COMMON, (Object)segment.getCompartmentType());
        Assert.assertEquals((Object)ServiceClass.EE3, (Object)segment.getServiceClass());
        Assert.assertEquals((long)1L, (long)segment.getPlaces().size());
        Assert.assertEquals((Object)"002", segment.getPlaces().get(0));
        Assert.assertEquals((double)2841.8, (double)product.getTotalEquivalentFare().doubleValue(), (double)0.001);
        Assert.assertEquals((double)438.33, (double)product.getTotalEquivalentVAT().doubleValue(), (double)0.001);
        fops = (ArrayList)product.getValue("contractRelations");
        Assert.assertEquals((long)2L, (long)fops.size());
        Assert.assertEquals((Object)new BigDecimal("2841.80"), (Object)((RailwayProductFop)((RailwayProductContractRelationData)fops.get(0)).getFops().get(0)).getAmount().getValue().setScale(2, 7));
        Assert.assertEquals((long)1L, (long)((RailwayProductContractRelationData)fops.get(0)).getFops().size());
        Assert.assertEquals((Object)"relation-SUPPLIER_TO_AGENCY", (Object)((RailwayProductContractRelationData)fops.get(0)).getDescription().getUid());
        Assert.assertEquals((Object)new BigDecimal("2841.80"), (Object)((RailwayProductFop)((RailwayProductContractRelationData)fops.get(1)).getFops().get(0)).getAmount().getValue().setScale(2, 7));
        Assert.assertEquals((long)1L, (long)((RailwayProductContractRelationData)fops.get(1)).getFops().size());
        Assert.assertEquals((Object)"relation-AGENCY_TO_CLIENT", (Object)((RailwayProductContractRelationData)fops.get(1)).getDescription().getUid());
    }
}

