/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UfsRailwayTestBase;
import java.math.BigDecimal;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class XTR8395Test
extends UfsRailwayTestBase {
    @Test
    public void testSell() throws Exception {
        this.parseFile("testdata/74546860021475-sell.xml");
        this.testProduct("125361961", "74546860021475", ProductStatus.SELL, new BigDecimal("543"), BigDecimal.ZERO, new BigDecimal("381.80"), BigDecimal.ZERO, new BigDecimal("924.80"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), null, null, new BigDecimal("1070.70"), new BigDecimal("24.32"));
    }

    @Test
    public void testSellAndRefund1() throws Exception {
        this.parseFile("testdata/74546860021464-sell.xml");
        this.parseFile("testdata/74546860021464-refund.xml");
        this.parseFile("testdata/74546860021475-sell.xml");
        this.parseFile("testdata/74546860021475-refund.xml");
        this.testProduct("125361961", "74546860021475", ProductStatus.SELL, new BigDecimal("543"), BigDecimal.ZERO, new BigDecimal("381.80"), BigDecimal.ZERO, new BigDecimal("924.80"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), null, null, new BigDecimal("1070.70"), new BigDecimal("24.32"));
        this.testProduct("125361961", "74546860021475", ProductStatus.REFUND, new BigDecimal("543"), BigDecimal.ZERO, new BigDecimal("381.80"), BigDecimal.ZERO, new BigDecimal("924.80"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), new BigDecimal("203.50"), new BigDecimal("33.92"), new BigDecimal("867.20"), new BigDecimal("-9.60"));
        this.testProduct("125361961", "74546860021464", ProductStatus.SELL, new BigDecimal("543"), BigDecimal.ZERO, new BigDecimal("381.80"), BigDecimal.ZERO, new BigDecimal("924.80"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), null, null, new BigDecimal("1070.70"), new BigDecimal("24.32"));
        this.testProduct("125361961", "74546860021464", ProductStatus.REFUND, new BigDecimal("543"), BigDecimal.ZERO, new BigDecimal("381.80"), BigDecimal.ZERO, new BigDecimal("924.80"), BigDecimal.ZERO, new BigDecimal("145.90"), new BigDecimal("24.32"), new BigDecimal("203.50"), new BigDecimal("33.92"), new BigDecimal("867.20"), new BigDecimal("-9.60"));
    }

    private void testProduct(String pnr, String number, ProductStatus status, BigDecimal segmentFare, BigDecimal segmentVat, BigDecimal reservedSeatFare, BigDecimal reservedSeatVat, BigDecimal equivalentFare, BigDecimal equivalentVat, BigDecimal serviceFare, BigDecimal serviceVat, BigDecimal penaltyFare, BigDecimal penaltyVat, BigDecimal totalEquivalentFare, BigDecimal totalEquivalentVat) throws Exception {
        Collection reservationsByPnr = BookingDao.getReservationsByPnr((String)pnr, (GdsName)GdsName.UFS);
        Assert.assertEquals((long)1L, (long)reservationsByPnr.size());
        Reservation reservation = (Reservation)reservationsByPnr.iterator().next();
        RailwayProduct product = RailwayProductHelper.getRailwayProductStream((Reservation)reservation).filter(p -> number.equals(p.getSystemNumber())).filter(p -> status == p.getStatus()).findFirst().orElse(null);
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        RailwaySegment railwaySegment = (RailwaySegment)product.getSegments().get(0);
        Assert.assertNotNull((Object)railwaySegment.getFare());
        this.assertBigDecimals(segmentFare, railwaySegment.getFare().getValue());
        Assert.assertEquals((Object)"RUB", (Object)railwaySegment.getFare().getCurrency());
        this.assertBigDecimals(segmentFare, railwaySegment.getEquivalentFare());
        this.assertBigDecimals(segmentVat, railwaySegment.getEquivalentVAT());
        Assert.assertEquals((long)1L, (long)product.getReservedSeats().size());
        ReservedSeat reservedSeat = (ReservedSeat)product.getReservedSeats().get(0);
        Assert.assertNotNull((Object)reservedSeat.getFare());
        this.assertBigDecimals(reservedSeatFare, reservedSeat.getFare().getValue());
        Assert.assertEquals((Object)"RUB", (Object)reservedSeat.getFare().getCurrency());
        this.assertBigDecimals(reservedSeatFare, reservedSeat.getEquivalentFare());
        this.assertBigDecimals(reservedSeatVat, reservedSeat.getEquivalentVAT());
        this.assertBigDecimals(equivalentFare, product.getEquivalentFare());
        this.assertBigDecimals(equivalentVat, product.getEquivalentVAT());
        this.assertBigDecimals(serviceFare, product.getServiceFare());
        this.assertBigDecimals(serviceVat, product.getServiceVAT());
        this.assertBigDecimals(penaltyFare, product.getPenalty());
        this.assertBigDecimals(penaltyVat, product.getPenaltyVAT());
        this.assertBigDecimals(totalEquivalentFare, product.getTotalEquivalentFare());
        this.assertBigDecimals(totalEquivalentVat, product.getTotalEquivalentVAT());
    }

    private void assertBigDecimals(BigDecimal expected, BigDecimal actual) {
        Assert.assertTrue((String)("Expected: " + expected + ", actual: " + actual), (boolean)MiscUtil.equals((Object)expected, (Object)actual));
    }
}

