/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UfsRailwayTestBase;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.test.parsers.iur.IurRailwayTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class XTR8522Test
extends UfsRailwayTestBase {
    @Test
    public void testUfsSellUfsRefundIurRefund() throws Exception {
        this.parseUfsSell();
        this.parseUfsRefund();
        this.parseIurRefund();
        this.testProducts();
    }

    @Test
    public void testUfsSellIurRefundUfsRefund() throws Exception {
        this.parseUfsSell();
        this.parseIurRefund();
        this.parseUfsRefund();
        this.testProducts();
    }

    @Test
    public void testIurRefundUfsSellIurRefund() throws Exception {
        this.parseIurRefund();
        this.parseUfsSell();
        this.parseUfsRefund();
        this.testProducts();
    }

    private void parseUfsSell() throws Exception {
        this.parseFile("testdata/ufs_online_20190718152847105.xml");
    }

    private void parseUfsRefund() throws Exception {
        this.parseFile("testdata/ufs_online_20190724170418736.xml");
    }

    private void parseIurRefund() throws Exception {
        IurRailwayTestUtils utils = new IurRailwayTestUtils();
        utils.parseFile("testdata/AVWBZV.FIL");
    }

    private void testProducts() throws Exception {
        RailwayProduct sellProduct = BookingDao.getProduct("75396880523801", ProductStatus.SELL);
        Assert.assertNotNull((Object)sellProduct);
        this.testProduct(sellProduct, ProductStatus.SELL);
        RailwayProduct refundProduct = sellProduct.getNextProduct();
        Assert.assertNotNull((Object)refundProduct);
        this.testProduct(refundProduct, ProductStatus.REFUND);
    }

    private void testProduct(RailwayProduct product, ProductStatus status) {
        Assert.assertEquals((Object)"75396880523801", (Object)product.getSystemNumber());
        Assert.assertEquals((long)1L, (long)product.getSegments().size());
        Assert.assertEquals((long)1L, (long)product.getReservedSeats().size());
        Assert.assertNotNull((Object)product.getEquivalentFare());
        Assert.assertEquals((Object)ufs, (Object)product.getBlankOwnerRef());
        Assert.assertNotNull((Object)product.getSalesPoint());
        Assert.assertEquals((Object)"59e27d71-9c80-4755-b202-a851d25a4fb1", (Object)product.getSalesPoint().getUid());
        Assert.assertEquals((Object)"54276", (Object)product.getValidatorCode());
        if (status == ProductStatus.REFUND) {
            Assert.assertNotNull((Object)product.getCashier());
            Assert.assertEquals((Object)"0d5cdafe-c691-42eb-af5f-adfebc94d985", (Object)product.getCashier().getUid());
        } else {
            Assert.assertNull((Object)product.getCashier());
        }
        Reservation reservation = product.getReservation();
        Assert.assertNotNull((Object)reservation);
        Assert.assertTrue((boolean)CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)"126076292", (GdsName)GdsName.UFS));
    }
}

