/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.ibus.parsers.ufs;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.railway.ibus.parsers.ufs.UfsRailwayTestBase;
import com.gridnine.xtrip.server.railway.model.helpers.BookingDao;
import com.gridnine.xtrip.server.railway.test.parsers.iur.IurRailwayTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class XTR8987Test
extends UfsRailwayTestBase {
    @Test
    public void testUfsIur() throws Exception {
        this.parseUfs();
        this.parseIur();
        this.testProducts(true);
    }

    @Test
    public void testIurUfs() throws Exception {
        this.parseIur();
        this.parseUfs();
        this.testProducts(true);
    }

    @Test
    public void testIur() throws Exception {
        this.parseIur();
        this.testProducts(false);
    }

    private void parseUfs() throws Exception {
        this.parseFile("testdata/ufs_online_20191220073317475.xml");
    }

    private void parseIur() throws Exception {
        IurRailwayTestUtils utils = new IurRailwayTestUtils();
        utils.parseFile("testdata/YVIKII00.FIL");
    }

    private void testProducts(boolean ufsProcessed) throws Exception {
        RailwayProduct product = BookingDao.getProduct("70256995142840", ProductStatus.SELL);
        Assert.assertNotNull((Object)product);
        if (ufsProcessed) {
            Assert.assertTrue((!product.getSegments().isEmpty() ? 1 : 0) != 0);
        }
        Assert.assertNotNull((Object)product.getSalesPoint());
        Assert.assertEquals((Object)"30f3d46f-e6e2-483d-b479-e6c71aeae911", (Object)product.getSalesPoint().getUid());
        Assert.assertEquals((Object)product.getSalesPoint(), (Object)product.getReservation().getSalesPoint());
        Assert.assertNotNull((Object)product.getCashier());
        Assert.assertEquals((Object)"2263b786-b320-4b06-885d-ab918db4e728", (Object)product.getCashier().getUid());
        Assert.assertEquals((Object)product.getCashier(), (Object)product.getReservation().getBookingAgent());
    }
}

