/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductFopIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayCommonProductFopIndexHandler
extends BaseCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayProduct product;
                if (baseProduct instanceof RailwayProduct) {
                    product = (RailwayProduct)baseProduct;
                    if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                    this.updateData(datas, product);
                    continue;
                }
                if (baseProduct instanceof RailwayCrimeaMco) {
                    product = (RailwayCrimeaMco)baseProduct;
                    if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                    this.updateData(datas, (RailwayCrimeaMco)product);
                    continue;
                }
                if (!(baseProduct instanceof RailwayMcoProduct)) continue;
                product = (RailwayMcoProduct)baseProduct;
                if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                super.updateData(datas, (BaseProduct)product);
            }
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, RailwayProduct product) {
        CommonProductFopIndexData data;
        DataAggregator aggregator = new DataAggregator();
        for (RailwayProductFop fop : RailwayProductHelper.getVendorFops((RailwayProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.VENDOR);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (RailwayProductFop fop : RailwayProductHelper.getSubagentFops((RailwayProduct)product, (boolean)false)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.SUBAGENCY);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.CLIENT);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setRefuse(Boolean.valueOf(fop.isRefused()));
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateData(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, RailwayCrimeaMco product) {
        CommonProductFopIndexData data;
        DataAggregator aggregator = new DataAggregator();
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getVendorFops((RailwayCrimeaMco)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.VENDOR);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getSubagentFops((RailwayCrimeaMco)product, (boolean)false)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.SUBAGENCY);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getClientFops((RailwayCrimeaMco)product)) {
            data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            data.setContractType(ContractType.CLIENT);
            this.updateFopData(data, aggregator, fop, product.getStatus());
            data.setRefuse(Boolean.valueOf(fop.isRefused()));
            data.setAggregatedData(aggregator.toString());
            aggregator.reset();
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, RailwayCrimeaMco product) {
        RailwaySegment lastTravelSegment;
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.RAILWAY_CRIMEA_MCO);
        aggregator.aggregate((Enum)ProductType.RAILWAY_CRIMEA_MCO);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        data.setSupplier(RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product));
        data.setAgency(RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product));
        data.setSubagency(RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        IndexBuilderHelper.updateReservationGdsNameInfo((Reservation)product.getReservation(), (CommonProductFopIndexData)data, (DataAggregator)aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        if (product.getBlankOwner() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwner());
                if (blankOwnerContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        String routeLine = RailwayCrimeaMcoHelper.getRouteString((RailwayCrimeaMco)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        HashSet<String> travellersNames = new HashSet<String>();
        for (Traveller traveller : product.getPassengers()) {
            if (traveller.getName() == null) continue;
            travellersNames.add(traveller.getName());
        }
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        RailwaySegment firstTravelSegment = product.getSegments().size() > 0 ? (RailwaySegment)product.getSegments().get(0) : null;
        RailwaySegment railwaySegment = lastTravelSegment = product.getSegments().size() > 0 ? (RailwaySegment)product.getSegments().get(0) : null;
        if (firstTravelSegment != null) {
            data.setFirstTravelDate(firstTravelSegment.getDepartureDate());
            aggregator.aggregate(firstTravelSegment.getDepartureDate());
        }
        if (lastTravelSegment != null) {
            data.setLastTravelDate(lastTravelSegment.getDepartureDate());
            aggregator.aggregate(lastTravelSegment.getDepartureDate());
        }
        data.setServiceLocationType(product.getServiceLocationType());
        aggregator.aggregate((Enum)product.getServiceLocationType());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, RailwayProduct product) {
        RailwaySegment lastTravelSegment;
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.RAILWAY_PRODUCT);
        aggregator.aggregate((Enum)ProductType.RAILWAY_PRODUCT);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        data.setSupplier(RailwayProductHelper.getSupplier((BaseProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getSupplier((BaseProduct)product));
        data.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getAgency((RailwayProduct)product));
        data.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getSubagency((RailwayProduct)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        IndexBuilderHelper.updateReservationGdsNameInfo((Reservation)product.getReservation(), (CommonProductFopIndexData)data, (DataAggregator)aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        if (product.getBlankOwnerRef() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwnerRef());
                if (blankOwnerContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        String routeLine = RailwayProductHelper.getRouteString((RailwayProduct)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        HashSet<String> travellersNames = new HashSet<String>();
        for (Traveller traveller : product.getPassengers()) {
            if (traveller.getName() == null) continue;
            travellersNames.add(traveller.getName());
        }
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        RailwaySegment firstTravelSegment = product.getSegments().size() > 0 ? (RailwaySegment)product.getSegments().get(0) : null;
        RailwaySegment railwaySegment = lastTravelSegment = product.getSegments().size() > 0 ? (RailwaySegment)product.getSegments().get(0) : null;
        if (firstTravelSegment != null) {
            data.setFirstTravelDate(firstTravelSegment.getDepartureDate());
            aggregator.aggregate(firstTravelSegment.getDepartureDate());
        }
        if (lastTravelSegment != null) {
            data.setLastTravelDate(lastTravelSegment.getDepartureDate());
            aggregator.aggregate(lastTravelSegment.getDepartureDate());
        }
        data.setServiceLocationType(product.getServiceLocationType());
        aggregator.aggregate((Enum)product.getServiceLocationType());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, RailwayProductFop fop, ProductStatus status) {
        BigDecimal amount;
        data.setFopUid(fop.getUid());
        FopType fopType = RailwayProductHelper.getFopType((RailwayProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal bigDecimal = amount = fop.getAmount() != null ? fop.getAmount().getValue() : null;
        if (amount != null && (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE)) {
            amount = amount.negate();
        }
        data.setAmount(amount);
        String currency = fop.getAmount() != null ? fop.getAmount().getCurrency() : null;
        data.setCurrency(currency);
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setPassengerStatus(fop.getPassengerStatus());
        aggregator.aggregate((Enum)fop.getPassengerStatus());
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
    }
}

