/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.index.CommonIndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.BaseCommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayCommonProductIndexHandler
extends BaseCommonProductIndexHandler
implements IndexHandler<BookingFile, CommonProductIndex> {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductIndex>> getDataClass() {
        return CommonProductIndexData.class;
    }

    public Class<CommonProductIndex> getIndexClass() {
        return CommonProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, CommonProductIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof RailwayReferenceMCO) && !(baseProduct instanceof RailwayCrimeaMco) && !(baseProduct instanceof RailwayProduct) && !(baseProduct instanceof RailwayMcoProduct)) continue;
                aggregator.reset();
                try {
                    CommonProductIndexData data = new CommonProductIndexData();
                    List handlers = ServerHandlersRegistry.get().findCommonIndexHandlers(this.getIndexClass());
                    for (CommonIndexHandler handler : handlers) {
                        handler.updateData((BaseIndexData)data, aggregator, etc, (BaseEntity)baseProduct);
                    }
                    if (baseProduct instanceof RailwayReferenceMCO) {
                        this.updateData(data, aggregator, etc, (RailwayReferenceMCO)baseProduct);
                    } else if (baseProduct instanceof RailwayCrimeaMco) {
                        this.updateData(data, aggregator, etc, (RailwayCrimeaMco)baseProduct);
                    } else if (baseProduct instanceof RailwayProduct) {
                        this.updateData(data, aggregator, etc, (RailwayProduct)baseProduct);
                    } else if (baseProduct instanceof RailwayMcoProduct) {
                        data.setAggregator(aggregator);
                        data.setReservationType(baseProduct.getReservation().getType());
                        super.updateData(data, baseProduct);
                    }
                    data.setAggregatedData(aggregator.toString());
                    indexes.add((BaseIndexData<BookingFile, CommonProductIndex>)data);
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                }
            }
        }
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, RailwayReferenceMCO product) {
        data.setNavigationKey(product.getUid());
        data.setReservationType(product.getReservation().getType());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        ArrayList<String> scns = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getScn())) {
            scns.add(product.getScn());
        }
        data.setSncs(scns);
        aggregator.aggregate(scns);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setServiceLocationType(ServiceLocationType.DOMESTIC);
        aggregator.aggregate((Enum)ServiceLocationType.DOMESTIC);
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
        data.setAgentPenaltyForCommissions(null);
        data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        data.setTaxesSum(BigDecimal.ZERO);
        data.setTaxesForBlankSum(BigDecimal.ZERO);
        data.setOtherTaxesSum(BigDecimal.ZERO);
        String sortingNumber = product.getSystemNumber();
        OperationBatch batch = OperationBatch.SELL;
        if (product.getRelatedProduct() != null) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct());
            data.setAgency(GeneralProductHelper.getAgency((BaseProduct)product.getRelatedProduct()));
            aggregator.aggregate((Object)GeneralProductHelper.getAgency((BaseProduct)product.getRelatedProduct()));
            data.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product.getRelatedProduct()));
            aggregator.aggregate((Object)GeneralProductHelper.getSupplier((BaseProduct)product.getRelatedProduct()));
            if (handler.getStatus(product.getRelatedProduct()) == ProductStatus.REFUND) {
                batch = OperationBatch.REFUND;
            }
            List numbers = handler.getProductNumbers(product.getRelatedProduct());
            sortingNumber = (numbers.size() > 0 ? (String)numbers.get(0) : null) + "9" + product.getSystemNumber();
            HashSet<String> passportNumbers = new HashSet<String>();
            HashSet<String> travellersNames = new HashSet<String>();
            HashSet<EntityReference> passengers = new HashSet<EntityReference>();
            for (Traveller trav : handler.getTravellers(product.getRelatedProduct())) {
                if (trav.getPassport() != null && trav.getPassport().getNumber() != null) {
                    passportNumbers.add(trav.getPassport().getNumber());
                }
                if (trav.getName() != null) {
                    travellersNames.add(trav.getName());
                }
                if (trav.getPassenger() == null) continue;
                passengers.add(trav.getPassenger());
            }
            data.setTravellersPassportsNumbers(passportNumbers);
            data.setTravellersNames(travellersNames);
            data.setPassengers(passengers);
            aggregator.aggregate(passportNumbers);
            aggregator.aggregate(travellersNames);
            data.setAgent(handler.findIssuingAgent(product.getRelatedProduct()));
            aggregator.aggregate((Object)handler.findIssuingAgent(product.getRelatedProduct()));
            String validatorCode = handler.getValidatorNumber(product.getRelatedProduct());
            data.setValidatorCode(validatorCode);
            aggregator.aggregate((Object)validatorCode);
            data.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)product.getRelatedProduct()));
            aggregator.aggregate((Object)GeneralProductHelper.getSubagency((BaseProduct)product.getRelatedProduct()));
            EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (clientContainer != null) {
                data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
                aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
            }
            data.setBranch(handler.getBranch(product.getRelatedProduct()));
            aggregator.aggregate((Object)handler.getBranch(product.getRelatedProduct()));
            data.setSalesPoint(handler.findSalesPoint(product.getRelatedProduct()));
            aggregator.aggregate((Object)handler.findSalesPoint(product.getRelatedProduct()));
            data.setEticket(Boolean.valueOf(BookingHelper.isEticket((DictionaryReference)product.getBlankType())));
            Date refuseDate = null;
            Date date = null;
            EntityReference agent = null;
            handler.getUnmodifiableContractRelations(product.getRelatedProduct());
            for (Object fop : GeneralProductHelper.getClientFops((BaseProduct)product.getRelatedProduct())) {
                if (fop.isRefused() && fop.getOperationDate() != null && (refuseDate == null || refuseDate.after(fop.getOperationDate()))) {
                    refuseDate = fop.getOperationDate();
                }
                if (date != null && (fop.getOperationDate() == null || !date.before(fop.getOperationDate()))) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (refuseDate != null) {
                data.setCancellationDate(refuseDate);
                aggregator.aggregate(refuseDate);
            }
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            HashSet<EntityReference> payers = new HashSet<EntityReference>();
            for (GeneralProductFop fop : GeneralProductHelper.getClientFops((BaseProduct)product)) {
                payers.add(fop.getPayer());
            }
            data.setPayers(payers);
            date = null;
            for (GeneralProductFop fop : GeneralProductHelper.getVendorFops((BaseProduct)product.getRelatedProduct())) {
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            data.setDateOfVendorPayment(date);
            aggregator.aggregate(date);
            data.setBlankOwner(handler.getBlankOwner(product.getRelatedProduct()));
            aggregator.aggregate((Object)handler.getBlankOwner(product.getRelatedProduct()));
            if (handler.getBlankOwner(product.getRelatedProduct()) != null) {
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(handler.getBlankOwner(product.getRelatedProduct()));
                    if (ctr != null) {
                        Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)ctr.getEntity()).getAirline());
                        if (airline != null) {
                            data.setBlankOwnerAirlineNumber(airline.getAirlineNumber());
                        }
                        data.setBlankOwnerCode(((Organization)ctr.getEntity()).getCode());
                        data.setProviderCode(((Organization)ctr.getEntity()).getCode());
                        data.setProviderName(handler.getBlankOwner(product.getRelatedProduct()).toString());
                    }
                }
                catch (Exception e) {
                    this.log.error("unable to resolve blank owner", (Throwable)e);
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.RAILWAY);
        aggregator.aggregate((Enum)ProductType.RAILWAY_REFERENCE_MCO);
        data.setProductType(ProductType.RAILWAY_REFERENCE_MCO);
        data.setDescription(TravelSubject.RAILWAY.toString());
        data.setValid(Boolean.valueOf(true));
        data.setHasWarnings(Boolean.valueOf(false));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasStockControlErrors(Boolean.valueOf(false));
        data.setHasRulesErrors(Boolean.valueOf(false));
        data.setHasShipmentErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasUserErrors(Boolean.valueOf(true));
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                data.setHasShipmentErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setValid(Boolean.valueOf(false));
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                data.setHasStockControlErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.RULES) continue;
            data.setHasRulesErrors(Boolean.valueOf(true));
        }
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, RailwayCrimeaMco product) {
        boolean exchange;
        BigDecimal equivalentFare;
        data.setReservationType(product.getReservation().getType());
        data.setNavigationKey(product.getUid());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        data.setAgency(RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product));
        data.setSupplier(RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product));
        CardVendor creditCardVendor = RailwayProductHelper.getCreditCardVendor((Collection)RailwayCrimeaMcoHelper.getClientFops((RailwayCrimeaMco)product));
        data.setClientCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        creditCardVendor = RailwayProductHelper.getCreditCardVendor((Collection)RailwayCrimeaMcoHelper.getVendorFops((RailwayCrimeaMco)product));
        data.setSupplierCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        if (product.getSegments().size() > 0) {
            List segments = product.getSegments();
            data.setFirstDepartureDate(((RailwaySegment)segments.get(0)).getDepartureDate());
            data.setLastArrivalDate(((RailwaySegment)segments.get(segments.size() - 1)).getArriveDate());
        }
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        String providerCode = null;
        String providerName = null;
        if (product.getBlankOwner() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwner());
                if (blankOwnerContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                    providerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                    providerName = blankOwnerContainer.toReference().toString();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        data.setProviderCode(providerCode);
        aggregator.aggregate(providerCode);
        data.setProviderName(providerName);
        aggregator.aggregate(providerName);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        ArrayList<String> scns = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getScn())) {
            scns.add(product.getScn());
        }
        data.setSncs(scns);
        aggregator.aggregate(scns);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference subagencyRef = RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product);
        if (subagencyRef != null) {
            try {
                EntityContainer subagency = EntityStorage.get().resolve(subagencyRef);
                ArrayList<ProfileGroupReference> subagencyGroups = new ArrayList<ProfileGroupReference>();
                for (Object metadata : ((Organization)subagency.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    subagencyGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setSubagencyGroups(subagencyGroups);
                aggregator.aggregate(subagencyGroups);
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + subagencyRef, e);
            }
        }
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)product.getValidator(), (EntityStorageContext)EntityStorageHelper.createContext());
        String validatorCode = validator != null ? validator.getNumber() : null;
        data.setValidatorCode(validatorCode);
        aggregator.aggregate((Object)validatorCode);
        data.setSubagency(RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product));
        aggregator.aggregate((Object)RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setEticket(Boolean.valueOf(product.isEticket()));
        Date refuseDate = null;
        List clientFops = RailwayCrimeaMcoHelper.getClientFops((RailwayCrimeaMco)product);
        for (RailwayProductFop fop : clientFops) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        if ((equivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getEquivalentFare()})) == null) {
            equivalentFare = BigDecimal.ZERO;
        }
        aggregator.aggregate((Object)equivalentFare);
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        for (Traveller trav : product.getPassengers()) {
            if (trav == null) continue;
            if (trav.getPassport() != null && trav.getPassport().getNumber() != null) {
                passportNumbers.add(trav.getPassport().getNumber());
            }
            if (trav.getName() != null) {
                travellersNames.add(trav.getName());
            }
            if (trav.getPassenger() == null) continue;
            passengers.add(trav.getPassenger());
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        String sortingNumber = product.getSystemNumber();
        OperationBatch batch = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case BOOKING: 
                case VOID: 
                case VOID_BOOKING: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case REFUND: {
                    batch = OperationBatch.REFUND;
                    sortingNumber = product.getSystemNumber() + "3";
                    break;
                }
                case SELL: {
                    if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                        sortingNumber = product.getSystemNumber() + "4";
                        batch = OperationBatch.EXCHANGE;
                        break;
                    }
                    batch = OperationBatch.SELL;
                    break;
                }
                case EXCHANGE: {
                    batch = OperationBatch.EXCHANGE;
                    if (product.getNextProduct() == null || product.getNextProduct().getStatus() != ProductStatus.SELL) break;
                    sortingNumber = product.getNextProduct().getSystemNumber() + "3";
                    break;
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.RAILWAY);
        aggregator.aggregate((Enum)ProductType.RAILWAY_CRIMEA_MCO);
        data.setProductType(ProductType.RAILWAY_CRIMEA_MCO);
        data.setDescription(TravelSubject.RAILWAY.toString());
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        boolean bl = exchange = product.getStatus() == ProductStatus.EXCHANGE;
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            String routeLine;
            if (refund && product.getPreviousProduct() != null) {
                EntityReference sellAgent = product.getPreviousProduct().getAgent();
                data.setSellAgent(sellAgent);
                aggregator.aggregate((Object)sellAgent);
            }
            for (RailwayProduct related : product.getRelatedProducts()) {
                String relatedTicketNo = related.getSystemNumber();
                if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                aggregator.aggregate((Object)relatedTicketNo);
                data.setRelatedTicketNo(relatedTicketNo);
                break;
            }
            routeLine = !TextUtil.isBlank((String)(routeLine = RailwayCrimeaMcoHelper.getRouteString((RailwayCrimeaMco)product))) && routeLine.length() > 255 ? "???" : routeLine;
            data.setRouteLine(routeLine);
            aggregator.aggregate((Object)routeLine);
            data.setServiceLocationType(product.getServiceLocationType());
            aggregator.aggregate((Enum)product.getServiceLocationType());
            data.setIncludeVat(Boolean.valueOf(product.getEquivalentVat() != null && BigDecimal.ZERO.compareTo(product.getEquivalentVat()) != 0));
            BigDecimal penalty = product.getPenalty();
            if (penalty == null) {
                penalty = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)equivalentFare);
            aggregator.aggregate((Object)penalty);
            data.setPenalty(penalty);
            data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasShipmentErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            if (!product.getSegments().isEmpty()) {
                if (((RailwaySegment)product.getSegments().get(0)).getDepartureDate() != null) {
                    data.setFirstTravelDate(((RailwaySegment)product.getSegments().get(0)).getDepartureDate());
                    aggregator.aggregate(((RailwaySegment)product.getSegments().get(0)).getDepartureDate());
                }
                if (((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate() != null) {
                    data.setLastTravelDate(((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate());
                    aggregator.aggregate(((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate());
                }
            }
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            if (product.getEquivalentVat() == null) {
                data.setVatRate(price.getVat());
                data.setVatValue(price.getVatAmount());
            } else if (product.getEquivalentVat().compareTo(BigDecimal.ZERO) == 0) {
                data.setVatRate(Double.valueOf(0.0));
                data.setVatValue(BigDecimal.ZERO);
            } else {
                data.setVatRate(Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue()));
                data.setVatValue(totalSum.compareTo(BigDecimal.ZERO) >= 0 ? product.getTotalEquivalentVat() : product.getTotalEquivalentVat().negate());
            }
            try {
                data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
                data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
                data.setAgentPenaltyForCommissions(null);
                data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (Object fop : clientFops) {
                BigDecimal fopAmount;
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && GeneralProductHelper.productFopTypes.contains(RailwayProductHelper.getFopType((RailwayProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && !GeneralProductHelper.discountFopTypes.contains(RailwayProductHelper.getFopType((RailwayProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    if (fop.getCommissions().isEmpty()) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate((Object)clientFOPAmount);
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            HashSet<EntityReference> payers = new HashSet<EntityReference>();
            for (GeneralProductFop fop : GeneralProductHelper.getClientFops((BaseProduct)product)) {
                payers.add(fop.getPayer());
            }
            data.setPayers(payers);
            date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getVendorFops((RailwayCrimeaMco)product)) {
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            aggregator.aggregate((Object)vendorFOPAmount);
            data.setDateOfVendorPayment(date);
            aggregator.aggregate(date);
            data.setVendorFopTypes(vendorFopTypes);
            aggregator.aggregate(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getSubagentFops((RailwayCrimeaMco)product, (boolean)false)) {
                if (fop.getType() == null) continue;
                if (fop.getCommissions().isEmpty()) {
                    subagentFopTypes.add(fop.getType());
                    continue;
                }
                subagentFeesFopTypes.add(fop.getType());
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            RailwayProductContractRelationData subagentContractRelation = RailwayCrimeaMcoHelper.getSubagentContractRelation((RailwayCrimeaMco)product, (boolean)false);
            if (subagentContractRelation != null) {
                BigDecimal subagencyContractFare = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getFare());
                BigDecimal subagencyContractPenalty = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getPenalty());
                data.setSubagencyContractFare(refund ? subagencyContractFare.negate() : subagencyContractFare);
                data.setSubagencyContractPenalty(subagencyContractPenalty);
                data.setSubagencyContractTaxesForBlankSum(BigDecimal.ZERO);
                data.setSubagencyContractOtherTaxesSum(BigDecimal.ZERO);
                data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
            }
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            BaseCommonProductIndexHandler.setVoidFees((CommonProductIndexData)data, (BaseProduct)product);
        }
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
    }

    protected void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, RailwayProduct product) {
        boolean exchange;
        data.setReservationType(product.getReservation().getType());
        data.setNavigationKey(product.getUid());
        data.setNextProductUid(product.getNextProduct() == null ? null : product.getNextProduct().getUid());
        data.setTimeLimit(product.getReservation().getTimeLimit());
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setBookingCreateDate(product.getReservation().getBookingFile().getCreateDate());
        aggregator.aggregate(product.getReservation().getBookingFile().getCreateDate());
        data.setBlankOwner(product.getBlankOwnerRef());
        aggregator.aggregate((Object)product.getBlankOwnerRef());
        data.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getAgency((RailwayProduct)product));
        data.setSupplier(RailwayProductHelper.getSupplier((BaseProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getSupplier((BaseProduct)product));
        CardVendor creditCardVendor = RailwayProductHelper.getCreditCardVendor((Collection)RailwayProductHelper.getClientFops((RailwayProduct)product));
        data.setClientCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        creditCardVendor = RailwayProductHelper.getCreditCardVendor((Collection)RailwayProductHelper.getVendorFops((RailwayProduct)product));
        data.setSupplierCardVendor(creditCardVendor);
        aggregator.aggregate((Enum)creditCardVendor);
        if (product.getSegments().size() > 0) {
            List segments = product.getSegments();
            data.setFirstDepartureDate(((RailwaySegment)segments.get(0)).getDepartureDate());
            data.setLastArrivalDate(((RailwaySegment)segments.get(segments.size() - 1)).getArriveDate());
        }
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        String providerCode = null;
        String providerName = null;
        if (product.getBlankOwnerRef() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwnerRef());
                if (blankOwnerContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                    providerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                    providerName = blankOwnerContainer.toReference().toString();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        data.setProviderCode(providerCode);
        aggregator.aggregate(providerCode);
        data.setProviderName(providerName);
        aggregator.aggregate(providerName);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        String militaryClaimNumber = GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product);
        data.setMilitaryClaimNumber(militaryClaimNumber);
        aggregator.aggregate((Object)militaryClaimNumber);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setLocalIssueDate(product.getLocalIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        data.setFirstSystemNumber((String)CollectionUtil.head(systemNumbers));
        data.setSystemNumberPrefix(product.getCarrierNumber());
        aggregator.aggregate((Object)product.getCarrierNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        ArrayList<String> scns = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getScn())) {
            scns.add(product.getScn());
        }
        data.setSncs(scns);
        aggregator.aggregate(scns);
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setAgent(product.getCashier());
        aggregator.aggregate((Object)product.getCashier());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        EntityReference subagencyRef = RailwayProductHelper.getSubagency((RailwayProduct)product);
        if (subagencyRef != null) {
            try {
                EntityContainer subagency = EntityStorage.get().resolve(subagencyRef);
                if (subagency != null) {
                    ArrayList<ProfileGroupReference> subagencyGroups = new ArrayList<ProfileGroupReference>();
                    for (Object metadata : ((Organization)subagency.getEntity()).getMetadata()) {
                        if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                        subagencyGroups.add((ProfileGroupReference)metadata.getValue());
                    }
                    data.setSubagencyGroups(subagencyGroups);
                    aggregator.aggregate(subagencyGroups);
                }
            }
            catch (Throwable e) {
                this.log.error("unable to load profile " + subagencyRef, e);
            }
        }
        try {
            EntityContainer client = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (client != null) {
                String code = SystemHelper.findMetadataAsString((Collection)((Organization)client.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_ACCOUNTING_SYSTEM_CODE);
                code = code != null ? code : ((Organization)client.getEntity()).getCode();
                data.setClientAccountingCode(code);
                aggregator.aggregate((Object)code);
                ArrayList<ProfileGroupReference> clientGroups = new ArrayList<ProfileGroupReference>();
                for (Metadata metadata : ((Organization)client.getEntity()).getMetadata()) {
                    if (metadata.getKey() == null || !metadata.getKey().getCode().equals(MetadataKey.KEY_ORGANIZATION_PROFILE_GROUP.name()) || metadata.getValue() == null) continue;
                    clientGroups.add((ProfileGroupReference)metadata.getValue());
                }
                data.setClientGroups(clientGroups);
                aggregator.aggregate(clientGroups);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to load profile " + product.getReservation().getBookingFile().getCustomerProfile(), e);
        }
        String validatorCode = product.getValidatorCode();
        data.setValidatorCode(validatorCode);
        aggregator.aggregate((Object)validatorCode);
        data.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
        aggregator.aggregate((Object)RailwayProductHelper.getSubagency((RailwayProduct)product));
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        data.setEticket(Boolean.valueOf(product.isEticket()));
        Date refuseDate = null;
        List clientFops = RailwayProductHelper.getClientFops((RailwayProduct)product);
        List subagentFops = RailwayProductHelper.getSubagentFops((RailwayProduct)product, (boolean)false);
        for (RailwayProductFop fop : clientFops) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        HashSet<String> passportNumbers = new HashSet<String>();
        HashSet<String> travellersNames = new HashSet<String>();
        HashSet<EntityReference> passengers = new HashSet<EntityReference>();
        for (Traveller trav : product.getPassengers()) {
            if (trav == null) continue;
            if (trav.getPassport() != null && trav.getPassport().getNumber() != null) {
                passportNumbers.add(trav.getPassport().getNumber());
            }
            if (trav.getName() != null) {
                travellersNames.add(trav.getName());
            }
            if (trav.getPassenger() == null) continue;
            passengers.add(trav.getPassenger());
        }
        data.setTravellersPassportsNumbers(passportNumbers);
        data.setTravellersNames(travellersNames);
        data.setPassengers(passengers);
        aggregator.aggregate(passportNumbers);
        aggregator.aggregate(travellersNames);
        String sortingNumber = product.getSystemNumber();
        OperationBatch batch = null;
        if (product.getStatus() != null) {
            switch (product.getStatus()) {
                case BOOKING: 
                case VOID: 
                case VOID_BOOKING: {
                    batch = OperationBatch.VOID;
                    break;
                }
                case REFUND: {
                    batch = OperationBatch.REFUND;
                    sortingNumber = product.getSystemNumber() + "3";
                    break;
                }
                case SELL: {
                    if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                        sortingNumber = product.getSystemNumber() + "4";
                        batch = OperationBatch.EXCHANGE;
                        break;
                    }
                    batch = OperationBatch.SELL;
                    break;
                }
                case EXCHANGE: {
                    batch = OperationBatch.EXCHANGE;
                    if (product.getNextProduct() == null || product.getNextProduct().getStatus() != ProductStatus.SELL) break;
                    sortingNumber = product.getNextProduct().getSystemNumber() + "3";
                    break;
                }
            }
        }
        data.setOperationBatch(batch);
        aggregator.aggregate((Object)sortingNumber);
        data.setSortingTicketNumber(sortingNumber);
        aggregator.aggregate((Enum)batch);
        data.setWorkflowStatus(product.getReservation().getBookingFile().getWorkflowStatus());
        aggregator.aggregate((Enum)product.getReservation().getBookingFile().getWorkflowStatus());
        data.setReservationStatus(product.getReservation().getStatus());
        aggregator.aggregate((Enum)product.getReservation().getStatus());
        data.setTravelSubject(TravelSubject.RAILWAY);
        aggregator.aggregate((Enum)ProductType.RAILWAY_PRODUCT);
        data.setProductType(ProductType.RAILWAY_PRODUCT);
        data.setDescription(TravelSubject.RAILWAY.toString());
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        boolean bl = exchange = product.getStatus() == ProductStatus.EXCHANGE;
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            BigDecimal taxesSum;
            String routeLine;
            if (refund && product.getPreviousProduct() != null) {
                EntityReference sellAgent = product.getPreviousProduct().getCashier();
                data.setSellAgent(sellAgent);
                aggregator.aggregate((Object)sellAgent);
            }
            for (RailwayProduct related : product.getRelatedProducts()) {
                String relatedTicketNo = related.getSystemNumber();
                if (TextUtil.isBlank((String)relatedTicketNo)) continue;
                aggregator.aggregate((Object)relatedTicketNo);
                data.setRelatedTicketNo(relatedTicketNo);
                break;
            }
            routeLine = !TextUtil.isBlank((String)(routeLine = RailwayProductHelper.getRouteString((RailwayProduct)product))) && routeLine.length() > 255 ? "???" : routeLine;
            data.setRouteLine(routeLine);
            aggregator.aggregate((Object)routeLine);
            data.setServiceLocationType(product.getServiceLocationType());
            aggregator.aggregate((Enum)product.getServiceLocationType());
            data.setIncludeVat(Boolean.valueOf(product.getEquivalentVAT() != null && BigDecimal.ZERO.compareTo(product.getEquivalentVAT()) != 0));
            BigDecimal equivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getEquivalentFare(), product.getServiceFare()});
            if (equivalentFare == null) {
                equivalentFare = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)equivalentFare);
            data.setEquivalentFare(refund ? equivalentFare.negate() : equivalentFare);
            data.setEquivalentFareCurrency(product.getGdsCurrency());
            BigDecimal penalty = product.getPenalty();
            if (penalty == null) {
                penalty = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)penalty);
            data.setPenalty(penalty);
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasStockControlErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            data.setHasRulesErrors(Boolean.valueOf(false));
            data.setHasShipmentErrors(Boolean.valueOf(false));
            for (ValidationMessage message : product.getValidationMessages()) {
                if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                    data.setHasWarnings(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                    data.setHasUserErrors(Boolean.valueOf(true));
                    data.setHasErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() == ValidationMessageSeverity.SHIPMENT_ERROR) {
                    data.setHasShipmentErrors(Boolean.valueOf(true));
                }
                if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
                data.setHasErrors(Boolean.valueOf(true));
                if (message.getCategory() == ValidationMessageCategory.OTHER) {
                    data.setValid(Boolean.valueOf(false));
                    data.setHasOtherErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() == ValidationMessageCategory.STOCK_CONTROL) {
                    data.setHasStockControlErrors(Boolean.valueOf(true));
                }
                if (message.getCategory() != ValidationMessageCategory.RULES) continue;
                data.setHasRulesErrors(Boolean.valueOf(true));
            }
            if (!product.getSegments().isEmpty()) {
                if (((RailwaySegment)product.getSegments().get(0)).getDepartureDate() != null) {
                    data.setFirstTravelDate(((RailwaySegment)product.getSegments().get(0)).getDepartureDate());
                    aggregator.aggregate(((RailwaySegment)product.getSegments().get(0)).getDepartureDate());
                }
                if (((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate() != null) {
                    data.setLastTravelDate(((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate());
                    aggregator.aggregate(((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getDepartureDate());
                }
            }
            if ((taxesSum = RailwayProductHelper.calculateTaxesFare((RailwayProduct)product)) == null) {
                taxesSum = BigDecimal.ZERO;
            }
            aggregator.aggregate((Object)taxesSum);
            taxesSum = refund ? taxesSum.negate() : taxesSum;
            data.setTaxesSum(taxesSum);
            data.setTaxesForBlankSum(BigDecimal.ZERO);
            data.setOtherTaxesSum(taxesSum);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            aggregator.aggregate((Object)totalSum);
            if (product.getEquivalentVAT() == null) {
                data.setVatRate(price.getVat());
                data.setVatValue(price.getVatAmount());
            } else if (product.getEquivalentVAT().compareTo(BigDecimal.ZERO) == 0) {
                data.setVatRate(Double.valueOf(0.0));
                data.setVatValue(BigDecimal.ZERO);
            } else {
                data.setVatRate(Double.valueOf(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue()));
                data.setVatValue(totalSum.compareTo(BigDecimal.ZERO) >= 0 ? product.getTotalEquivalentVAT() : product.getTotalEquivalentVAT().negate());
            }
            try {
                data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setSubagencyHiddenFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories)), (boolean)refund));
                data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
                data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
                data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
                data.setClientServiceFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientPaymentFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.paymentFeePropertyTypes, null, null)), (boolean)refund));
                data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
                data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
                data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
                data.setAgentPenaltyForService(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
                data.setAgentPenaltyForCommissions(null);
                data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            }
            catch (Exception e) {
                this.log.error("failed calculating commissions ", (Throwable)e);
            }
            Date date = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = null;
            BigDecimal clientFOPAddAmount = null;
            BigDecimal clientFOPTotalAddAmount = null;
            EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
            addPaymentTypes.remove(PaymentType.TICKET);
            addPaymentTypes.remove(PaymentType.VOUCHER);
            addPaymentTypes.remove(PaymentType.MTD);
            addPaymentTypes.remove(PaymentType.MTD_AGENCY);
            addPaymentTypes.remove(PaymentType.CREDIT);
            addPaymentTypes.remove(PaymentType.CREDIT_CARD);
            for (Object fop : clientFops) {
                BigDecimal fopAmount;
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && GeneralProductHelper.productFopTypes.contains(RailwayProductHelper.getFopType((RailwayProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPAddAmount = clientFOPAddAmount != null ? clientFOPAddAmount.add(fopAmount) : fopAmount;
                }
                if (!exchange && fop.getAmount() != null && fop.getAmount().getValue() != null && addPaymentTypes.contains(fop.getType()) && !GeneralProductHelper.discountFopTypes.contains(RailwayProductHelper.getFopType((RailwayProductFop)fop))) {
                    fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = clientFOPTotalAddAmount = clientFOPTotalAddAmount != null ? clientFOPTotalAddAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    if (fop.getCommissions().isEmpty()) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
                agent = fop.getAgent();
            }
            if (refund && clientFOPAmount != null) {
                clientFOPAmount = clientFOPAmount.negate();
            }
            data.setClientFopAmount(clientFOPAmount);
            aggregator.aggregate((Object)clientFOPAmount);
            if (refund && clientFOPAddAmount != null) {
                clientFOPAddAmount = clientFOPAddAmount.negate();
            }
            data.setClientFopAddAmount(clientFOPAddAmount);
            aggregator.aggregate((Object)clientFOPAddAmount);
            if (refund && clientFOPTotalAddAmount != null) {
                clientFOPTotalAddAmount = clientFOPTotalAddAmount.negate();
            }
            data.setClientFopTotalAddAmount(clientFOPTotalAddAmount);
            aggregator.aggregate((Object)clientFOPTotalAddAmount);
            data.setClientFopTypes(clientFopTypes);
            aggregator.aggregate(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            aggregator.aggregate(clientFeesFopTypes);
            data.setDateOfClientPayment(date);
            aggregator.aggregate(date);
            data.setClientFopAgent(agent);
            aggregator.aggregate((Object)agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            HashSet<EntityReference> payers = new HashSet<EntityReference>();
            for (GeneralProductFop fop : GeneralProductHelper.getClientFops((BaseProduct)product)) {
                payers.add(fop.getPayer());
            }
            data.setPayers(payers);
            date = null;
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            for (RailwayProductFop fop : RailwayProductHelper.getVendorFops((RailwayProduct)product)) {
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
                date = fop.getOperationDate();
            }
            if (refund && vendorFOPAmount != null) {
                vendorFOPAmount = vendorFOPAmount.negate();
            }
            data.setVendorFopAmount(vendorFOPAmount);
            aggregator.aggregate((Object)vendorFOPAmount);
            data.setDateOfVendorPayment(date);
            aggregator.aggregate(date);
            data.setVendorFopTypes(vendorFopTypes);
            aggregator.aggregate(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            if (subagentFops != null) {
                for (RailwayProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (fop.getCommissions().isEmpty()) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
            if (subagentContractRelation != null) {
                BigDecimal subagencyContractFare = MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{subagentContractRelation.getServiceData().getDetalization().getFare(), subagentContractRelation.getServiceData().getDetalization().getAdditionalFee()}));
                BigDecimal subagencyContractPenalty = MiscUtil.guarded((BigDecimal)subagentContractRelation.getServiceData().getDetalization().getPenalty());
                BigDecimal subagencyContractTaxesSum = subagentContractRelation.getServiceData().getDetalization().getTaxes().stream().map(SimpleTax::getAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
                data.setSubagencyContractFare(refund ? subagencyContractFare.negate() : subagencyContractFare);
                data.setSubagencyContractPenalty(subagencyContractPenalty);
                data.setSubagencyContractTaxesForBlankSum(BigDecimal.ZERO);
                data.setSubagencyContractOtherTaxesSum(refund ? subagencyContractTaxesSum.negate() : subagencyContractTaxesSum);
                data.setSubagencyContractTotalSum(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.SUBAGENCY).getTotal());
            }
        } else {
            data.setValid(Boolean.valueOf(true));
            data.setHasOtherErrors(Boolean.valueOf(false));
            data.setHasErrors(Boolean.valueOf(false));
            BaseCommonProductIndexHandler.setVoidFees((CommonProductIndexData)data, (BaseProduct)product);
        }
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        data.setAggregator(aggregator);
        this.updateStatisticalData(data, product.getStatisticalData(), product.getReservation().getBookingFile().getCustomerProfile());
        data.setAggregator(null);
        Set shipments = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).filter(item -> item.getShipment() != null).map(item -> item.getShipment()).collect(Collectors.toSet());
        data.setShipments(shipments);
        aggregator.aggregate(shipments);
        data.setShipmentsDate(product.getShipmentsDate());
        data.setShipmentsDateSubagent(product.getShipmentsDateSubagent());
        data.setFopComponentsAllUsed(Boolean.valueOf(product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).allMatch(item -> item.getShipment() != null)));
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
        Set receipts = product.getFopDetalizations().values().stream().flatMap(fopDetalization -> fopDetalization.getComponents().stream()).map(FopComponent::getReceipt).collect(Collectors.toSet());
        data.setReceipts(receipts);
        Set travellersGroups = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setTravellersGroups(travellersGroups);
        aggregator.aggregate(travellersGroups);
        Set agentsGroups = Optional.ofNullable(EntityStorage.get().resolve(GeneralProductHelper.getHandler((BaseProduct)product).findIssuingAgent((BaseProduct)product))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet());
        data.setAgentsGroups(agentsGroups);
        aggregator.aggregate(agentsGroups);
    }
}

