/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndexData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonMetadata;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayProductIndexHandler
implements IndexHandler<BookingFile, RailwayProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, RailwayProductIndex>> getDataClass() {
        return RailwayProductIndexData.class;
    }

    public Class<RailwayProductIndex> getIndexClass() {
        return RailwayProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, RailwayProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof RailwayReferenceMCO).map(x -> (RailwayReferenceMCO)x).forEach(x -> this.processRailwayReferenceMCO(indexes, aggregator, (RailwayReferenceMCO)x));
            reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof RailwayCrimeaMco).map(x -> (RailwayCrimeaMco)x).forEach(x -> this.processRailwayCrimeaMco(indexes, aggregator, (RailwayCrimeaMco)x));
            reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof RailwayProduct).map(x -> (RailwayProduct)x).forEach(x -> this.processRailwayProduct(indexes, aggregator, (RailwayProduct)x));
            reservation.getProducts().stream().filter(baseProduct -> baseProduct instanceof RailwayMcoProduct).map(x -> (RailwayMcoProduct)x).forEach(x -> this.processRailwayMcoProduct(indexes, aggregator, (RailwayMcoProduct)x));
        }
    }

    protected void processRailwayProduct(Collection<BaseIndexData<BookingFile, RailwayProductIndex>> indexes, DataAggregator aggregator, RailwayProduct baseProduct) {
        RailwayProduct product = baseProduct;
        RailwayProductIndexData data = new RailwayProductIndexData();
        this.updateReservationGdsNameInfo(data, aggregator, baseProduct.getReservation());
        this.updateFromProduct(data, aggregator, product);
        data.setAggregatedData(aggregator.toString());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        indexes.add((BaseIndexData<BookingFile, RailwayProductIndex>)data);
        aggregator.reset();
    }

    protected void processRailwayMcoProduct(Collection<BaseIndexData<BookingFile, RailwayProductIndex>> indexes, DataAggregator aggregator, RailwayMcoProduct product) {
        RailwayProductIndexData data = new RailwayProductIndexData();
        this.updateReservationGdsNameInfo(data, aggregator, product.getReservation());
        this.updateFromRailwayMco(data, aggregator, product);
        data.setAggregatedData(aggregator.toString());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        indexes.add((BaseIndexData<BookingFile, RailwayProductIndex>)data);
        aggregator.reset();
    }

    protected void processRailwayCrimeaMco(Collection<BaseIndexData<BookingFile, RailwayProductIndex>> indexes, DataAggregator aggregator, RailwayCrimeaMco baseProduct) {
        RailwayCrimeaMco product = baseProduct;
        RailwayProductIndexData data = new RailwayProductIndexData();
        this.updateReservationGdsNameInfo(data, aggregator, baseProduct.getReservation());
        this.updateFromCrimeaMco(data, aggregator, product);
        data.setAggregatedData(aggregator.toString());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        indexes.add((BaseIndexData<BookingFile, RailwayProductIndex>)data);
        aggregator.reset();
    }

    protected void processRailwayReferenceMCO(Collection<BaseIndexData<BookingFile, RailwayProductIndex>> indexes, DataAggregator aggregator, RailwayReferenceMCO baseProduct) {
        RailwayReferenceMCO product = baseProduct;
        RailwayProductIndexData data = new RailwayProductIndexData();
        this.updateReservationGdsNameInfo(data, aggregator, baseProduct.getReservation());
        this.updateFromReferenceMCO(data, aggregator, product);
        data.setAggregatedData(aggregator.toString());
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        indexes.add((BaseIndexData<BookingFile, RailwayProductIndex>)data);
        aggregator.reset();
    }

    protected void updateFromReferenceMCO(RailwayProductIndexData data, DataAggregator aggregator, RailwayReferenceMCO mco) {
        List costCodes;
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)mco.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        Reservation reservation = mco.getReservation();
        data.setNavigationKey(mco.getUid());
        data.setProductType(ProductType.RAILWAY_REFERENCE_MCO);
        this.aggregate(aggregator, ProductType.RAILWAY_REFERENCE_MCO);
        data.setBlankType(mco.getBlankType());
        aggregator.aggregate((Object)mco.getBlankType());
        data.setStatus(mco.getStatus());
        aggregator.aggregate((Enum)mco.getStatus());
        data.setChecked(Boolean.valueOf(mco.isChecked()));
        data.setCompleted(Boolean.valueOf(mco.isCompleted()));
        data.setClient(reservation.getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)reservation.getBookingFile().getCustomerProfile());
        data.setEticket(Boolean.valueOf(BookingHelper.isEticket((DictionaryReference)mco.getBlankType())));
        data.setIssueDate(mco.getIssueDate());
        data.setIssueDateTime(mco.getIssueDate());
        if (mco.getScn() != null) {
            data.setSncs(Collections.singletonList(mco.getScn()));
        }
        data.setSystemNumber(mco.getSystemNumber());
        aggregator.aggregate((Object)mco.getSystemNumber());
        data.setTicketType(mco.getTicketType());
        boolean hasOtherErrors = false;
        boolean hasStockControlErrors = false;
        for (ValidationMessage message : mco.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.TRUE);
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                hasOtherErrors = true;
            }
            if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            hasStockControlErrors = true;
        }
        data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)mco));
        data.setAgentPenaltyForCommissions(null);
        data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)mco));
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        data.setHasStockControlErrors(Boolean.valueOf(hasStockControlErrors));
        BaseProduct product = mco.getRelatedProduct();
        if (product != null) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
            data.setAgency(GeneralProductHelper.getAgency((BaseProduct)product));
            aggregator.aggregate((Object)GeneralProductHelper.getAgency((BaseProduct)product));
            data.setSubagency(GeneralProductHelper.getSubagency((BaseProduct)product));
            aggregator.aggregate((Object)GeneralProductHelper.getSubagency((BaseProduct)product));
            EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            if (clientContainer != null) {
                data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
                aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
            }
            data.setBranch(handler.getBranch(product));
            aggregator.aggregate((Object)handler.getBranch(product));
            data.setSalesPoint(handler.findSalesPoint(product));
            aggregator.aggregate((Object)handler.findSalesPoint(product));
            data.setAgent(handler.findIssuingAgent(product));
            aggregator.aggregate((Object)handler.findIssuingAgent(product));
            data.setSupplier(GeneralProductHelper.getSupplier((BaseProduct)product));
            aggregator.aggregate((Object)GeneralProductHelper.getSupplier((BaseProduct)product));
            data.setValidatorCode(handler.getValidatorNumber(product));
            aggregator.aggregate((Object)handler.getValidatorNumber(product));
            data.setBlankOwner(handler.getBlankOwner(product));
            aggregator.aggregate((Object)handler.getBlankOwner(product));
            if (product instanceof RailwayProduct) {
                RailwayProduct railwayProduct = (RailwayProduct)product;
                data.setProvider(railwayProduct.getProvider());
                aggregator.aggregate((Object)railwayProduct.getProvider());
                List travellers = RailwayProductHelper.getTravellersNames((RailwayProduct)railwayProduct);
                data.setTravellers((Collection)travellers);
                aggregator.aggregate((Iterable)travellers);
                Date departureDate = RailwayProductHelper.getFirstDepartureDate((RailwayProduct)railwayProduct);
                data.setDepartureDate(departureDate);
            }
            boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
            data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
            boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
            data.setInDelivery(Boolean.valueOf(inDelivery));
        }
        if (!(costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)mco.getStatisticalData(), (EntityReference)mco.getReservation().getBookingFile().getCustomerProfile())).isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList((Collection)IndexBuilderHelper.getCostCodeValues((List)costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList((Collection)IndexBuilderHelper.getCostCodeValues((List)costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList((Collection)IndexBuilderHelper.getCostCodeValues((List)costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)mco.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }

    protected void aggregate(DataAggregator aggregator, ProductType railwayReferenceMco) {
        aggregator.aggregate((Enum)railwayReferenceMco);
    }

    protected void updateFromCrimeaMco(RailwayProductIndexData data, DataAggregator aggregator, RailwayCrimeaMco product) {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        String uid = product.getUid();
        data.setProductType(ProductType.RAILWAY_CRIMEA_MCO);
        this.aggregate(aggregator, ProductType.RAILWAY_CRIMEA_MCO);
        String systemNumber = product.getSystemNumber();
        String providerSystemNumber = product.getProviderSystemNumber();
        EntityReference agency = RailwayCrimeaMcoHelper.getAgency((RailwayCrimeaMco)product);
        EntityReference blankOwner = product.getBlankOwner();
        EntityReference agent = product.getAgent();
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        Date refuseDate = null;
        String relatedTicketNo = null;
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getClientFops((RailwayCrimeaMco)product)) {
            if (fop.isRefused() && fop.getOperationDate() != null && (refuseDate == null || refuseDate.after(fop.getOperationDate()))) {
                refuseDate = fop.getOperationDate();
            }
            if (relatedTicketNo != null || TextUtil.isBlank((String)fop.getRelatedTicketNumber())) continue;
            relatedTicketNo = fop.getRelatedTicketNumber();
        }
        DictionaryReference blankType = product.getBlankType();
        boolean checked = product.isChecked();
        boolean completed = product.isCompleted();
        Reservation reservation = product.getReservation();
        BookingFile bookingFile = reservation.getBookingFile();
        EntityReference client = bookingFile.getCustomerProfile();
        String blankOwnerCode = null;
        try {
            EntityContainer blankOwnerOrganizationContainer = EntityStorage.get().resolve(blankOwner);
            if (blankOwnerOrganizationContainer != null) {
                blankOwnerCode = ((Organization)blankOwnerOrganizationContainer.getEntity()).getCode();
            }
        }
        catch (Exception e) {
            this.log.error("failed retrieving blank owner code", (Throwable)e);
        }
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Double clientBonusRate = null;
        try {
            clientBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus rate", (Throwable)e);
        }
        BigDecimal clientBonusValue = null;
        try {
            clientBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus value", (Throwable)e);
        }
        Double clientCommissionRate = null;
        try {
            clientCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission rate", (Throwable)e);
        }
        BigDecimal clientCommissionValue = null;
        try {
            clientCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission value", (Throwable)e);
        }
        Double clientFeeRate = null;
        try {
            clientFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee rate", (Throwable)e);
        }
        BigDecimal clientFeeValue = null;
        try {
            clientFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee value", (Throwable)e);
        }
        HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
        BigDecimal clientFOPAmount = null;
        EntityReference clientFOPAgent = null;
        Date dateOfClientPayment = null;
        boolean hasClientDebt = false;
        for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getClientFops((RailwayCrimeaMco)product)) {
            if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                BigDecimal fopAmount = fop.getAmount().getValue();
                BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
            }
            if (fop.getType() != null) {
                if (fop.getCommissions().isEmpty()) {
                    clientFopTypes.add(fop.getType());
                } else {
                    clientFeesFopTypes.add(fop.getType());
                }
            }
            if (fop.getOperationDate() == null) {
                hasClientDebt = true;
                continue;
            }
            if (dateOfClientPayment != null && !dateOfClientPayment.before(fop.getOperationDate())) continue;
            dateOfClientPayment = fop.getOperationDate();
            clientFOPAgent = fop.getAgent();
        }
        BigDecimal equivalentTotalFare = product.getTotalEquivalentFare();
        BigDecimal equivalentTotalVAT = product.getTotalEquivalentVat();
        if (product.getStatus() == ProductStatus.REFUND) {
            if (equivalentTotalFare != null) {
                equivalentTotalFare = equivalentTotalFare.negate();
            }
            if (equivalentTotalVAT != null) {
                equivalentTotalVAT = equivalentTotalVAT.negate();
            }
        }
        boolean eticket = product.isEticket();
        Date issueDate = product.getIssueDate();
        Date issueDateTime = product.getIssueDate();
        List passengerTypes = Collections.emptyList();
        BigDecimal penalty = product.getPenalty();
        String routeLine = RailwayCrimeaMcoHelper.getRouteString((RailwayCrimeaMco)product);
        EntityReference branch = product.getBranch();
        EntityReference salesPoint = product.getSalesPoint();
        EntityReference sellAgent = null;
        List scns = RailwayCrimeaMcoHelper.getSCNs((RailwayCrimeaMco)product);
        ServiceLocationType serviceLocationType = product.getServiceLocationType();
        ProductStatus status = product.getStatus();
        EntityReference subagency = RailwayCrimeaMcoHelper.getSubagency((RailwayCrimeaMco)product);
        Double subagencyBonusRate = null;
        try {
            subagencyBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus rate", (Throwable)e);
        }
        BigDecimal subagencyBonusValue = null;
        try {
            subagencyBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus value", (Throwable)e);
        }
        Double subagencyCommissionRate = null;
        try {
            subagencyCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission rate", (Throwable)e);
        }
        BigDecimal subagencyCommissionValue = null;
        try {
            subagencyCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission value", (Throwable)e);
        }
        Double subagencyFeeRate = null;
        try {
            subagencyFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee rate", (Throwable)e);
        }
        BigDecimal subagencyFeeValue = null;
        try {
            subagencyFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee value", (Throwable)e);
        }
        EntityReference vendor = RailwayCrimeaMcoHelper.getSupplier((RailwayCrimeaMco)product);
        data.setProvider(product.getProvider());
        aggregator.aggregate((Object)product.getProvider());
        TicketType ticketType = product.getTicketType();
        List travellers = RailwayCrimeaMcoHelper.getTravellersNames((RailwayCrimeaMco)product);
        ArrayList<String> travellerDocNumbers = new ArrayList<String>();
        for (Traveller tr : product.getPassengers()) {
            if (tr.getPassport() == null || tr.getPassport().getNumber() == null) continue;
            travellerDocNumbers.add(tr.getPassport().getNumber());
        }
        boolean hasOtherErrors = false;
        boolean hasStockControlErrors = false;
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.TRUE);
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                hasOtherErrors = true;
            }
            if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            hasStockControlErrors = true;
        }
        Validator validator = (Validator)EntityStorageHelper.resolve((NestedEntityReference)product.getValidator(), (EntityStorageContext)EntityStorageHelper.createContext());
        String validatorCode = validator != null ? validator.getNumber() : null;
        Date departureDate = null;
        ArrayList<CarriageType> carriageTypes = new ArrayList<CarriageType>();
        ArrayList<CompartmentType> compartmentTypes = new ArrayList<CompartmentType>();
        ArrayList<ServiceClass> serviceClasses = new ArrayList<ServiceClass>();
        ArrayList<String> trainNumbers = new ArrayList<String>();
        for (RailwaySegment segment : product.getSegments()) {
            if (departureDate == null || segment.getDepartureDate() != null && departureDate.after(segment.getDepartureDate())) {
                departureDate = segment.getDepartureDate();
            }
            if (segment.getCarriageType() != null && !carriageTypes.contains(segment.getCarriageType())) {
                carriageTypes.add(segment.getCarriageType());
            }
            if (segment.getCompartmentType() != null && !compartmentTypes.contains(segment.getCompartmentType())) {
                compartmentTypes.add(segment.getCompartmentType());
            }
            if (segment.getServiceClass() != null && !serviceClasses.contains(segment.getServiceClass())) {
                serviceClasses.add(segment.getServiceClass());
            }
            if (segment.getTrainNumber() == null || trainNumbers.contains(segment.getTrainNumber())) continue;
            trainNumbers.add(segment.getTrainNumber());
        }
        BigDecimal segmentsEquivalentFare = RailwayProductHelper.calculateSegmentsFare((Collection)product.getSegments());
        BigDecimal reservedSeatsEquivalentFare = null;
        BigDecimal taxesEquivalentFare = null;
        if (product.getStatus() == ProductStatus.REFUND) {
            if (segmentsEquivalentFare != null) {
                segmentsEquivalentFare = segmentsEquivalentFare.negate();
            }
            if (reservedSeatsEquivalentFare != null) {
                reservedSeatsEquivalentFare = reservedSeatsEquivalentFare.negate();
            }
            if (taxesEquivalentFare != null) {
                taxesEquivalentFare = taxesEquivalentFare.negate();
            }
        }
        Double vendorBonusRate = null;
        try {
            vendorBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus rate", (Throwable)e);
        }
        BigDecimal vendorBonusValue = null;
        try {
            vendorBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus value", (Throwable)e);
        }
        Double vendorCommissionRate = null;
        try {
            vendorCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission rate", (Throwable)e);
        }
        BigDecimal vendorCommissionValue = null;
        try {
            vendorCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission value", (Throwable)e);
        }
        Double vendorFeeRate = null;
        try {
            vendorFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee rate", (Throwable)e);
        }
        BigDecimal vendorFeeValue = null;
        try {
            vendorFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayCrimeaMcoHelper.getUnmodifiableCommissions((RailwayCrimeaMco)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee value", (Throwable)e);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            Object dateOfVendorPayment = null;
            for (RailwayProductFop fop : RailwayCrimeaMcoHelper.getVendorFops((RailwayCrimeaMco)product)) {
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || dateOfVendorPayment != null && !((Date)dateOfVendorPayment).before(fop.getOperationDate())) continue;
                dateOfVendorPayment = fop.getOperationDate();
            }
            data.setVendorFopAmount(ProductStatus.REFUND != product.getStatus() ? vendorFOPAmount : (vendorFOPAmount != null ? vendorFOPAmount.negate() : null));
            data.setVendorFopTypes(vendorFopTypes);
            data.setDateOfVendorPayment(dateOfVendorPayment);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = RailwayCrimeaMcoHelper.getSubagentFops((RailwayCrimeaMco)product, (boolean)false);
            if (subagentFops != null) {
                for (RailwayProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (fop.getCommissions().isEmpty()) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            aggregator.aggregate(vendorFopTypes);
            aggregator.aggregate((Date)dateOfVendorPayment);
        }
        data.setNavigationKey(uid);
        data.setSystemNumber(systemNumber);
        data.setProviderSystemNumber(providerSystemNumber);
        data.setAgency(agency);
        data.setBlankOwner(blankOwner);
        data.setBlankOwnerCode(blankOwnerCode);
        data.setAgent(agent);
        data.setCancellationDate(refuseDate);
        data.setBlankType(blankType);
        data.setChecked(Boolean.valueOf(checked));
        data.setCompleted(Boolean.valueOf(completed));
        data.setClient(client);
        data.setTimeLimit(reservation.getTimeLimit());
        if (product.getNextProduct() != null) {
            data.setNextProductUid(product.getNextProduct().getUid());
        }
        data.setTrainNumbers(trainNumbers);
        data.setTravellerDocNumbers(travellerDocNumbers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setClientBonusRate(clientBonusRate);
            data.setClientBonusValue(clientBonusValue);
            data.setClientCommissionRate(clientCommissionRate);
            data.setClientCommissionValue(clientCommissionValue);
            data.setClientFeeRate(clientFeeRate);
            data.setClientFeeValue(clientFeeValue);
            data.setClientFopAmount(ProductStatus.REFUND != product.getStatus() ? clientFOPAmount : (clientFOPAmount != null ? clientFOPAmount.negate() : null));
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setClientFopAgent(clientFOPAgent);
            data.setDateOfClientPayment(dateOfClientPayment);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            data.setEquivalentTotalFare(equivalentTotalFare);
            data.setEquivalentTotalVAT(equivalentTotalVAT);
        } else {
            vendorFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.CLIENT);
            vendorFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.CLIENT);
            data.setVendorFeeValue(vendorFeeValue);
            data.setSubagencyFeeValue(subagencyFeeValue);
            data.setClientFeeValue(clientFeeValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setClientFeeRate(clientFeeRate);
            data.setVendorFopAmount(vendorFeeValue);
            data.setSubagentFopAmount(subagencyFeeValue);
            data.setClientFopAmount(clientFeeValue);
        }
        data.setEticket(Boolean.valueOf(eticket));
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDateTime);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setPassengerTypes(passengerTypes);
            data.setPenalty(penalty);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setRelatedTicketNo(relatedTicketNo);
            data.setRouteLine(routeLine);
        }
        data.setBranch(branch);
        data.setSalesPoint(salesPoint);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSellAgent(sellAgent);
        }
        data.setSncs((Collection)scns);
        data.setServiceLocationType(serviceLocationType);
        data.setStatus(status);
        data.setSubagency(subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSubagencyBonusRate(subagencyBonusRate);
            data.setSubagencyBonusValue(subagencyBonusValue);
            data.setSubagencyCommissionRate(subagencyCommissionRate);
            data.setSubagencyCommissionValue(subagencyCommissionValue);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setSubagencyFeeValue(subagencyFeeValue);
        }
        data.setSupplier(vendor);
        data.setTicketType(ticketType);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setTravellers((Collection)travellers);
        }
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        data.setHasStockControlErrors(Boolean.valueOf(hasStockControlErrors));
        data.setValidatorCode(validatorCode);
        ArrayList<DictionaryReference> carriers = new ArrayList<DictionaryReference>();
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.getCarrier() == null) continue;
            carriers.add(segment.getCarrier());
        }
        data.setCarriers(carriers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setDepartureDate(departureDate);
            data.setCarriageTypes(carriageTypes);
            data.setCompartmentTypes(compartmentTypes);
            data.setServiceClasses(serviceClasses);
            data.setSegmentsEquivalentFare(segmentsEquivalentFare);
            data.setReservedSeatsEquivalentFare(reservedSeatsEquivalentFare);
            data.setTaxesEquivalentFare(taxesEquivalentFare);
            data.setVendorBonusRate(vendorBonusRate);
            data.setVendorBonusValue(vendorBonusValue);
            data.setVendorCommissionRate(vendorCommissionRate);
            data.setVendorCommissionValue(vendorCommissionValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setVendorFeeValue(vendorFeeValue);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        aggregator.aggregate((Object)bookingNumber);
        aggregator.aggregate((Object)uid);
        aggregator.aggregate((Object)systemNumber);
        aggregator.aggregate((Object)providerSystemNumber);
        aggregator.aggregate((Object)agency);
        aggregator.aggregate((Object)blankOwner);
        aggregator.aggregate((Object)blankOwnerCode);
        aggregator.aggregate((Object)agent);
        aggregator.aggregate(refuseDate);
        aggregator.aggregate((Object)blankType);
        aggregator.aggregate((Object)client);
        aggregator.aggregate((Object)clientBonusRate);
        aggregator.aggregate((Object)clientBonusValue);
        aggregator.aggregate((Object)clientCommissionRate);
        aggregator.aggregate((Object)clientCommissionValue);
        aggregator.aggregate((Object)clientFeeRate);
        aggregator.aggregate((Object)clientFeeValue);
        aggregator.aggregate(clientFopTypes);
        aggregator.aggregate(clientFeesFopTypes);
        aggregator.aggregate((Object)clientFOPAgent);
        aggregator.aggregate(dateOfClientPayment);
        aggregator.aggregate((Object)equivalentTotalFare);
        aggregator.aggregate((Object)equivalentTotalVAT);
        aggregator.aggregate(issueDate);
        aggregator.aggregate(passengerTypes);
        aggregator.aggregate((Object)penalty);
        aggregator.aggregate((Object)relatedTicketNo);
        aggregator.aggregate((Object)routeLine);
        aggregator.aggregate((Object)branch);
        aggregator.aggregate((Object)salesPoint);
        aggregator.aggregate(sellAgent);
        aggregator.aggregate((Iterable)scns);
        aggregator.aggregate((Enum)status);
        aggregator.aggregate((Object)subagency);
        aggregator.aggregate((Object)subagencyBonusRate);
        aggregator.aggregate((Object)subagencyBonusValue);
        aggregator.aggregate((Object)subagencyCommissionRate);
        aggregator.aggregate((Object)subagencyCommissionValue);
        aggregator.aggregate((Object)subagencyFeeRate);
        aggregator.aggregate((Object)subagencyFeeValue);
        aggregator.aggregate((Object)vendor);
        aggregator.aggregate((Enum)ticketType);
        aggregator.aggregate((Iterable)travellers);
        aggregator.aggregate((Object)validatorCode);
        aggregator.aggregate(carriageTypes);
        aggregator.aggregate(compartmentTypes);
        aggregator.aggregate(serviceClasses);
        aggregator.aggregate((Object)vendorBonusRate);
        aggregator.aggregate((Object)vendorBonusValue);
        aggregator.aggregate((Object)vendorCommissionRate);
        aggregator.aggregate((Object)vendorCommissionValue);
        aggregator.aggregate((Object)vendorFeeRate);
        aggregator.aggregate((Object)vendorFeeValue);
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        EntityReference cashierRef = null;
        try {
            cashierRef = agent;
            EntityContainer cashierCtr = EntityStorage.get().resolve(cashierRef);
            if (cashierCtr != null) {
                Person cashier = (Person)cashierCtr.getEntity();
                for (PersonMetadata meta : cashier.getMetadata()) {
                    if (!MetadataKey.KEY_PERSON_PROFILE_GROUP.name().equals(meta.getKey().getCode())) continue;
                    DictionaryReference pgRef = (DictionaryReference)meta.getValue();
                    if (pgRef != null) {
                        aggregator.aggregate((Object)pgRef);
                    }
                    data.setProfileGroup(pgRef);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
        }
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }

    protected void updateFromProduct(RailwayProductIndexData data, DataAggregator aggregator, RailwayProduct product) {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        String uid = product.getUid();
        data.setProductType(ProductType.RAILWAY_PRODUCT);
        this.aggregate(aggregator, ProductType.RAILWAY_PRODUCT);
        String systemNumber = product.getSystemNumber();
        String providerSystemNumber = product.getProviderSystemNumber();
        EntityReference agency = RailwayProductHelper.getAgency((RailwayProduct)product);
        EntityReference blankOwner = product.getBlankOwnerRef();
        EntityReference agent = product.getCashier();
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        Date refuseDate = null;
        String relatedTicketNo = null;
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
            if (fop.isRefused() && fop.getOperationDate() != null && (refuseDate == null || refuseDate.after(fop.getOperationDate()))) {
                refuseDate = fop.getOperationDate();
            }
            if (relatedTicketNo != null || TextUtil.isBlank((String)fop.getRelatedTicketNumber())) continue;
            relatedTicketNo = fop.getRelatedTicketNumber();
        }
        DictionaryReference blankType = product.getBlankType();
        boolean checked = product.isChecked();
        boolean completed = product.isCompleted();
        Reservation reservation = product.getReservation();
        BookingFile bookingFile = reservation.getBookingFile();
        EntityReference client = bookingFile.getCustomerProfile();
        String blankOwnerCode = null;
        try {
            EntityContainer blankOwnerOrganizationContainer = EntityStorage.get().resolve(blankOwner);
            if (blankOwnerOrganizationContainer != null) {
                blankOwnerCode = ((Organization)blankOwnerOrganizationContainer.getEntity()).getCode();
            }
        }
        catch (Exception e) {
            this.log.error("failed retrieving blank owner code", (Throwable)e);
        }
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Double clientBonusRate = null;
        try {
            clientBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus rate", (Throwable)e);
        }
        BigDecimal clientBonusValue = null;
        try {
            clientBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus value", (Throwable)e);
        }
        Double clientCommissionRate = null;
        try {
            clientCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission rate", (Throwable)e);
        }
        BigDecimal clientCommissionValue = null;
        try {
            clientCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission value", (Throwable)e);
        }
        Double clientFeeRate = null;
        try {
            clientFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee rate", (Throwable)e);
        }
        BigDecimal clientFeeValue = null;
        try {
            clientFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee value", (Throwable)e);
        }
        HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
        BigDecimal clientFOPAmount = null;
        EntityReference clientFOPAgent = null;
        Date dateOfClientPayment = null;
        boolean hasClientDebt = false;
        for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
            if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                BigDecimal fopAmount = fop.getAmount().getValue();
                BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fopAmount) : fopAmount;
            }
            if (fop.getType() != null) {
                if (fop.getCommissions().isEmpty()) {
                    clientFopTypes.add(fop.getType());
                } else {
                    clientFeesFopTypes.add(fop.getType());
                }
            }
            if (fop.getOperationDate() == null) {
                hasClientDebt = true;
                continue;
            }
            if (dateOfClientPayment != null && !dateOfClientPayment.before(fop.getOperationDate())) continue;
            dateOfClientPayment = fop.getOperationDate();
            clientFOPAgent = fop.getAgent();
        }
        BigDecimal equivalentTotalFare = product.getTotalEquivalentFare();
        BigDecimal equivalentTotalVAT = product.getTotalEquivalentVAT();
        if (product.getStatus() == ProductStatus.REFUND) {
            if (equivalentTotalFare != null) {
                equivalentTotalFare = equivalentTotalFare.negate();
            }
            if (equivalentTotalVAT != null) {
                equivalentTotalVAT = equivalentTotalVAT.negate();
            }
        }
        boolean eticket = product.isEticket();
        Date issueDate = product.getIssueDate();
        Date issueDateTime = product.getIssueDate();
        List passengerTypes = RailwayProductHelper.getPassengerTypes((RailwayProduct)product);
        BigDecimal penalty = product.getPenalty();
        String routeLine = RailwayProductHelper.getRouteString((RailwayProduct)product);
        EntityReference branch = product.getBranch();
        EntityReference salesPoint = product.getSalesPoint();
        EntityReference sellAgent = null;
        List scns = RailwayProductHelper.getSCNs((RailwayProduct)product);
        ServiceLocationType serviceLocationType = product.getServiceLocationType();
        ProductStatus status = product.getStatus();
        EntityReference subagency = RailwayProductHelper.getSubagency((RailwayProduct)product);
        Double subagencyBonusRate = null;
        try {
            subagencyBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus rate", (Throwable)e);
        }
        BigDecimal subagencyBonusValue = null;
        try {
            subagencyBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus value", (Throwable)e);
        }
        Double subagencyCommissionRate = null;
        try {
            subagencyCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission rate", (Throwable)e);
        }
        BigDecimal subagencyCommissionValue = null;
        try {
            subagencyCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission value", (Throwable)e);
        }
        Double subagencyFeeRate = null;
        try {
            subagencyFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee rate", (Throwable)e);
        }
        BigDecimal subagencyFeeValue = null;
        try {
            subagencyFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee value", (Throwable)e);
        }
        EntityReference vendor = RailwayProductHelper.getSupplier((BaseProduct)product);
        data.setProvider(product.getProvider());
        aggregator.aggregate((Object)product.getProvider());
        TicketType ticketType = product.getTicketType();
        List travellers = RailwayProductHelper.getTravellersNames((RailwayProduct)product);
        ArrayList<String> travellerDocNumbers = new ArrayList<String>();
        for (Traveller tr : product.getPassengers()) {
            if (tr.getPassport() == null || tr.getPassport().getNumber() == null) continue;
            travellerDocNumbers.add(tr.getPassport().getNumber());
        }
        boolean hasOtherErrors = false;
        boolean hasStockControlErrors = false;
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.TRUE);
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                hasOtherErrors = true;
            }
            if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            hasStockControlErrors = true;
        }
        String validatorCode = product.getValidatorCode();
        Date departureDate = null;
        ArrayList<CarriageType> carriageTypes = new ArrayList<CarriageType>();
        ArrayList<CompartmentType> compartmentTypes = new ArrayList<CompartmentType>();
        ArrayList<ServiceClass> serviceClasses = new ArrayList<ServiceClass>();
        ArrayList<String> trainNumbers = new ArrayList<String>();
        for (RailwaySegment segment : product.getSegments()) {
            if (departureDate == null || segment.getDepartureDate() != null && departureDate.after(segment.getDepartureDate())) {
                departureDate = segment.getDepartureDate();
            }
            if (segment.getCarriageType() != null && !carriageTypes.contains(segment.getCarriageType())) {
                carriageTypes.add(segment.getCarriageType());
            }
            if (segment.getCompartmentType() != null && !compartmentTypes.contains(segment.getCompartmentType())) {
                compartmentTypes.add(segment.getCompartmentType());
            }
            if (segment.getServiceClass() != null && !serviceClasses.contains(segment.getServiceClass())) {
                serviceClasses.add(segment.getServiceClass());
            }
            if (segment.getTrainNumber() == null || trainNumbers.contains(segment.getTrainNumber())) continue;
            trainNumbers.add(segment.getTrainNumber());
        }
        BigDecimal segmentsEquivalentFare = RailwayProductHelper.calculateSegmentsFare((Collection)product.getSegments());
        BigDecimal reservedSeatsEquivalentFare = RailwayProductHelper.calculateReservedSeatsFare((Collection)product.getReservedSeats());
        BigDecimal taxesEquivalentFare = RailwayProductHelper.calculateTaxesFare((Collection)product.getTaxes());
        if (product.getStatus() == ProductStatus.REFUND) {
            if (segmentsEquivalentFare != null) {
                segmentsEquivalentFare = segmentsEquivalentFare.negate();
            }
            if (reservedSeatsEquivalentFare != null) {
                reservedSeatsEquivalentFare = reservedSeatsEquivalentFare.negate();
            }
            if (taxesEquivalentFare != null) {
                taxesEquivalentFare = taxesEquivalentFare.negate();
            }
        }
        Double vendorBonusRate = null;
        try {
            vendorBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus rate", (Throwable)e);
        }
        BigDecimal vendorBonusValue = null;
        try {
            vendorBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus value", (Throwable)e);
        }
        Double vendorCommissionRate = null;
        try {
            vendorCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission rate", (Throwable)e);
        }
        BigDecimal vendorCommissionValue = null;
        try {
            vendorCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission value", (Throwable)e);
        }
        Double vendorFeeRate = null;
        try {
            vendorFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee rate", (Throwable)e);
        }
        BigDecimal vendorFeeValue = null;
        try {
            vendorFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayProductHelper.getUnmodifiableCommissions((RailwayProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee value", (Throwable)e);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            Object dateOfVendorPayment = null;
            for (RailwayProductFop fop : RailwayProductHelper.getVendorFops((RailwayProduct)product)) {
                if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                    BigDecimal fopAmount = fop.getAmount().getValue();
                    BigDecimal bigDecimal = vendorFOPAmount = vendorFOPAmount != null ? vendorFOPAmount.add(fopAmount) : fopAmount;
                }
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || dateOfVendorPayment != null && !((Date)dateOfVendorPayment).before(fop.getOperationDate())) continue;
                dateOfVendorPayment = fop.getOperationDate();
            }
            data.setVendorFopAmount(ProductStatus.REFUND != product.getStatus() ? vendorFOPAmount : (vendorFOPAmount != null ? vendorFOPAmount.negate() : null));
            data.setVendorFopTypes(vendorFopTypes);
            data.setDateOfVendorPayment(dateOfVendorPayment);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = RailwayProductHelper.getSubagentFops((RailwayProduct)product, (boolean)false);
            if (subagentFops != null) {
                for (RailwayProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (fop.getCommissions().isEmpty()) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopAmount(GeneralProductHelper.getSubagentFopAmount((BaseProduct)product));
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            aggregator.aggregate(vendorFopTypes);
            aggregator.aggregate((Date)dateOfVendorPayment);
        }
        data.setNavigationKey(uid);
        data.setSystemNumber(systemNumber);
        data.setProviderSystemNumber(providerSystemNumber);
        data.setAgency(agency);
        data.setBlankOwner(blankOwner);
        data.setBlankOwnerCode(blankOwnerCode);
        data.setAgent(agent);
        data.setCancellationDate(refuseDate);
        data.setBlankType(blankType);
        data.setChecked(Boolean.valueOf(checked));
        data.setCompleted(Boolean.valueOf(completed));
        data.setClient(client);
        data.setTimeLimit(reservation.getTimeLimit());
        if (product.getNextProduct() != null) {
            data.setNextProductUid(product.getNextProduct().getUid());
        }
        data.setTrainNumbers(trainNumbers);
        data.setTravellerDocNumbers(travellerDocNumbers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setClientBonusRate(clientBonusRate);
            data.setClientBonusValue(clientBonusValue);
            data.setClientCommissionRate(clientCommissionRate);
            data.setClientCommissionValue(clientCommissionValue);
            data.setClientFeeRate(clientFeeRate);
            data.setClientFeeValue(clientFeeValue);
            data.setClientFopAmount(ProductStatus.REFUND != product.getStatus() ? clientFOPAmount : (clientFOPAmount != null ? clientFOPAmount.negate() : null));
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setClientFopAgent(clientFOPAgent);
            data.setDateOfClientPayment(dateOfClientPayment);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            data.setEquivalentTotalFare(equivalentTotalFare);
            data.setEquivalentTotalVAT(equivalentTotalVAT);
            data.setEquivalentFareCurrency(product.getGdsCurrency());
        } else {
            vendorFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.CLIENT);
            vendorFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.CLIENT);
            data.setVendorFeeValue(vendorFeeValue);
            data.setSubagencyFeeValue(subagencyFeeValue);
            data.setClientFeeValue(clientFeeValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setClientFeeRate(clientFeeRate);
            data.setVendorFopAmount(vendorFeeValue);
            data.setSubagentFopAmount(subagencyFeeValue);
            data.setClientFopAmount(clientFeeValue);
        }
        data.setEticket(Boolean.valueOf(eticket));
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDateTime);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setPassengerTypes((Collection)passengerTypes);
            data.setPenalty(penalty);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setRelatedTicketNo(relatedTicketNo);
            data.setRouteLine(routeLine);
        }
        data.setBranch(branch);
        data.setSalesPoint(salesPoint);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSellAgent(sellAgent);
        }
        data.setSncs((Collection)scns);
        data.setServiceLocationType(serviceLocationType);
        data.setStatus(status);
        data.setSubagency(subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSubagencyBonusRate(subagencyBonusRate);
            data.setSubagencyBonusValue(subagencyBonusValue);
            data.setSubagencyCommissionRate(subagencyCommissionRate);
            data.setSubagencyCommissionValue(subagencyCommissionValue);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setSubagencyFeeValue(subagencyFeeValue);
        }
        data.setSupplier(vendor);
        data.setTicketType(ticketType);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setTravellers((Collection)travellers);
        }
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        data.setHasStockControlErrors(Boolean.valueOf(hasStockControlErrors));
        data.setValidatorCode(validatorCode);
        data.setCarrier(product.getCarrier());
        ArrayList<DictionaryReference> carriers = new ArrayList<DictionaryReference>();
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.getCarrier() == null) continue;
            carriers.add(segment.getCarrier());
        }
        data.setCarriers(carriers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setDepartureDate(departureDate);
            data.setCarriageTypes(carriageTypes);
            data.setCompartmentTypes(compartmentTypes);
            data.setServiceClasses(serviceClasses);
            data.setSegmentsEquivalentFare(segmentsEquivalentFare);
            data.setReservedSeatsEquivalentFare(reservedSeatsEquivalentFare);
            data.setTaxesEquivalentFare(taxesEquivalentFare);
            data.setVendorBonusRate(vendorBonusRate);
            data.setVendorBonusValue(vendorBonusValue);
            data.setVendorCommissionRate(vendorCommissionRate);
            data.setVendorCommissionValue(vendorCommissionValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setVendorFeeValue(vendorFeeValue);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        aggregator.aggregate((Object)bookingNumber);
        aggregator.aggregate((Object)uid);
        aggregator.aggregate((Object)systemNumber);
        aggregator.aggregate((Object)providerSystemNumber);
        aggregator.aggregate((Object)agency);
        aggregator.aggregate((Object)blankOwner);
        aggregator.aggregate((Object)blankOwnerCode);
        aggregator.aggregate((Object)agent);
        aggregator.aggregate(refuseDate);
        aggregator.aggregate((Object)blankType);
        aggregator.aggregate((Object)client);
        aggregator.aggregate((Object)clientBonusRate);
        aggregator.aggregate((Object)clientBonusValue);
        aggregator.aggregate((Object)clientCommissionRate);
        aggregator.aggregate((Object)clientCommissionValue);
        aggregator.aggregate((Object)clientFeeRate);
        aggregator.aggregate((Object)clientFeeValue);
        aggregator.aggregate(clientFopTypes);
        aggregator.aggregate(clientFeesFopTypes);
        aggregator.aggregate((Object)clientFOPAgent);
        aggregator.aggregate(dateOfClientPayment);
        aggregator.aggregate((Object)equivalentTotalFare);
        aggregator.aggregate((Object)equivalentTotalVAT);
        aggregator.aggregate(issueDate);
        aggregator.aggregate((Iterable)passengerTypes);
        aggregator.aggregate((Object)penalty);
        aggregator.aggregate((Object)relatedTicketNo);
        aggregator.aggregate((Object)routeLine);
        aggregator.aggregate((Object)branch);
        aggregator.aggregate((Object)salesPoint);
        aggregator.aggregate(sellAgent);
        aggregator.aggregate((Iterable)scns);
        aggregator.aggregate((Enum)status);
        aggregator.aggregate((Object)subagency);
        aggregator.aggregate((Object)subagencyBonusRate);
        aggregator.aggregate((Object)subagencyBonusValue);
        aggregator.aggregate((Object)subagencyCommissionRate);
        aggregator.aggregate((Object)subagencyCommissionValue);
        aggregator.aggregate((Object)subagencyFeeRate);
        aggregator.aggregate((Object)subagencyFeeValue);
        aggregator.aggregate((Object)vendor);
        aggregator.aggregate((Enum)ticketType);
        aggregator.aggregate((Iterable)travellers);
        aggregator.aggregate((Object)validatorCode);
        aggregator.aggregate(carriageTypes);
        aggregator.aggregate(compartmentTypes);
        aggregator.aggregate(serviceClasses);
        aggregator.aggregate((Object)vendorBonusRate);
        aggregator.aggregate((Object)vendorBonusValue);
        aggregator.aggregate((Object)vendorCommissionRate);
        aggregator.aggregate((Object)vendorCommissionValue);
        aggregator.aggregate((Object)vendorFeeRate);
        aggregator.aggregate((Object)vendorFeeValue);
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        EntityReference cashierRef = null;
        try {
            cashierRef = agent;
            EntityContainer cashierCtr = EntityStorage.get().resolve(cashierRef);
            if (cashierCtr != null) {
                Person cashier = (Person)cashierCtr.getEntity();
                for (PersonMetadata meta : cashier.getMetadata()) {
                    if (meta.getKey() == null || !MetadataKey.KEY_PERSON_PROFILE_GROUP.name().equals(meta.getKey().getCode())) continue;
                    DictionaryReference pgRef = (DictionaryReference)meta.getValue();
                    if (pgRef != null) {
                        aggregator.aggregate((Object)pgRef);
                    }
                    data.setProfileGroup(pgRef);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
        }
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }

    protected void updateFromRailwayMco(RailwayProductIndexData data, DataAggregator aggregator, RailwayMcoProduct product) {
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        String uid = product.getUid();
        data.setProductType(ProductType.RAILWAY_CRIMEA_MCO);
        this.aggregate(aggregator, ProductType.RAILWAY_CRIMEA_MCO);
        String systemNumber = product.getSystemNumber();
        String providerSystemNumber = product.getProviderSystemNumber();
        EntityReference agency = RailwayMcoProductHelper.getAgency((RailwayMcoProduct)product);
        EntityReference blankOwner = product.getBlankOwnerRef();
        EntityReference agent = product.getCashier();
        EntityReference clientRelationMediator = GeneralProductHelper.getClientRelationMediator((BaseProduct)product);
        data.setMediator(clientRelationMediator);
        aggregator.aggregate((Object)clientRelationMediator);
        Date refuseDate = null;
        String relatedTicketNo = null;
        for (GeneralProductFop fop : RailwayMcoProductHelper.getClientFops((RailwayMcoProduct)product)) {
            if (fop.isRefused() && fop.getOperationDate() != null && (refuseDate == null || refuseDate.after(fop.getOperationDate()))) {
                refuseDate = fop.getOperationDate();
            }
            if (relatedTicketNo != null || TextUtil.isBlank((String)fop.getRelatedTicketNumber())) continue;
            relatedTicketNo = fop.getRelatedTicketNumber();
        }
        DictionaryReference blankType = product.getBlankType();
        boolean checked = product.isChecked();
        boolean completed = product.isCompleted();
        Reservation reservation = product.getReservation();
        BookingFile bookingFile = reservation.getBookingFile();
        EntityReference client = bookingFile.getCustomerProfile();
        String blankOwnerCode = null;
        try {
            EntityContainer blankOwnerOrganizationContainer = EntityStorage.get().resolve(blankOwner);
            if (blankOwnerOrganizationContainer != null) {
                blankOwnerCode = ((Organization)blankOwnerOrganizationContainer.getEntity()).getCode();
            }
        }
        catch (Exception e) {
            this.log.error("failed retrieving blank owner code", (Throwable)e);
        }
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Double clientBonusRate = null;
        try {
            clientBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus rate", (Throwable)e);
        }
        BigDecimal clientBonusValue = null;
        try {
            clientBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client bonus value", (Throwable)e);
        }
        Double clientCommissionRate = null;
        try {
            clientCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission rate", (Throwable)e);
        }
        BigDecimal clientCommissionValue = null;
        try {
            clientCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client commission value", (Throwable)e);
        }
        Double clientFeeRate = null;
        try {
            clientFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee rate", (Throwable)e);
        }
        BigDecimal clientFeeValue = null;
        try {
            clientFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating client fee value", (Throwable)e);
        }
        HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
        HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
        BigDecimal clientFOPAmount = null;
        EntityReference clientFOPAgent = null;
        Date dateOfClientPayment = null;
        boolean hasClientDebt = false;
        boolean exchange = product.getStatus() == ProductStatus.EXCHANGE;
        EnumSet<PaymentType> addPaymentTypes = EnumSet.allOf(PaymentType.class);
        addPaymentTypes.remove(PaymentType.TICKET);
        addPaymentTypes.remove(PaymentType.VOUCHER);
        addPaymentTypes.remove(PaymentType.MTD);
        addPaymentTypes.remove(PaymentType.MTD_AGENCY);
        addPaymentTypes.remove(PaymentType.CREDIT);
        addPaymentTypes.remove(PaymentType.CREDIT_CARD);
        Date date = null;
        for (GeneralProductFop fop : RailwayMcoProductHelper.getClientFops((RailwayMcoProduct)product)) {
            if (fop.getEquivalentAmount() != null) {
                BigDecimal bigDecimal = clientFOPAmount = clientFOPAmount != null ? clientFOPAmount.add(fop.getEquivalentAmount()) : fop.getEquivalentAmount();
            }
            if (fop.getType() != null) {
                if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                    clientFopTypes.add(fop.getType());
                } else {
                    clientFeesFopTypes.add(fop.getType());
                }
            }
            if (fop.getOperationDate() == null) {
                hasClientDebt = true;
                continue;
            }
            if (date != null && !date.before(fop.getOperationDate())) continue;
            date = fop.getOperationDate();
            agent = fop.getAgent();
        }
        if (refund && clientFOPAmount != null) {
            clientFOPAmount = clientFOPAmount.negate();
        }
        boolean eticket = product.isEticket();
        Date issueDate = product.getIssueDate();
        Date issueDateTime = product.getIssueDate();
        List passengerTypes = Collections.emptyList();
        BigDecimal penalty = product.getPenaltyFare();
        String routeLine = RailwayMcoProductHelper.getRouteString((RailwayMcoProduct)product);
        EntityReference branch = product.getBranch();
        EntityReference salesPoint = product.getSalesPoint();
        EntityReference sellAgent = null;
        ProductStatus status = product.getStatus();
        EntityReference subagency = RailwayMcoProductHelper.getSubagency((RailwayMcoProduct)product);
        Double subagencyBonusRate = null;
        try {
            subagencyBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus rate", (Throwable)e);
        }
        BigDecimal subagencyBonusValue = null;
        try {
            subagencyBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency bonus value", (Throwable)e);
        }
        Double subagencyCommissionRate = null;
        try {
            subagencyCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission rate", (Throwable)e);
        }
        BigDecimal subagencyCommissionValue = null;
        try {
            subagencyCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency commission value", (Throwable)e);
        }
        Double subagencyFeeRate = null;
        try {
            subagencyFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee rate", (Throwable)e);
        }
        BigDecimal subagencyFeeValue = null;
        try {
            subagencyFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating subagency fee value", (Throwable)e);
        }
        EntityReference vendor = RailwayMcoProductHelper.getSupplier((RailwayMcoProduct)product);
        data.setProvider(product.getProvider());
        aggregator.aggregate((Object)product.getProvider());
        TicketType ticketType = product.getTicketType();
        List travellers = RailwayMcoProductHelper.getTravellersNames((RailwayMcoProduct)product);
        ArrayList<String> travellerDocNumbers = new ArrayList<String>();
        for (Traveller tr : product.getPassengers()) {
            if (tr.getPassport() == null || tr.getPassport().getNumber() == null) continue;
            travellerDocNumbers.add(tr.getPassport().getNumber());
        }
        boolean hasOtherErrors = false;
        boolean hasStockControlErrors = false;
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.TRUE);
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.TRUE);
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                hasOtherErrors = true;
            }
            if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            hasStockControlErrors = true;
        }
        Date departureDate = null;
        ArrayList<CarriageType> carriageTypes = new ArrayList<CarriageType>();
        ArrayList<CompartmentType> compartmentTypes = new ArrayList<CompartmentType>();
        ArrayList<ServiceClass> serviceClasses = new ArrayList<ServiceClass>();
        ArrayList<String> trainNumbers = new ArrayList<String>();
        for (RailwaySegment segment : product.getSegments()) {
            if (departureDate == null || segment.getDepartureDate() != null && departureDate.after(segment.getDepartureDate())) {
                departureDate = segment.getDepartureDate();
            }
            if (segment.getCarriageType() != null && !carriageTypes.contains(segment.getCarriageType())) {
                carriageTypes.add(segment.getCarriageType());
            }
            if (segment.getCompartmentType() != null && !compartmentTypes.contains(segment.getCompartmentType())) {
                compartmentTypes.add(segment.getCompartmentType());
            }
            if (segment.getServiceClass() != null && !serviceClasses.contains(segment.getServiceClass())) {
                serviceClasses.add(segment.getServiceClass());
            }
            if (segment.getTrainNumber() == null || trainNumbers.contains(segment.getTrainNumber())) continue;
            trainNumbers.add(segment.getTrainNumber());
        }
        BigDecimal segmentsEquivalentFare = RailwayProductHelper.calculateSegmentsFare((Collection)product.getSegments());
        BigDecimal reservedSeatsEquivalentFare = null;
        BigDecimal taxesEquivalentFare = null;
        if (product.getStatus() == ProductStatus.REFUND) {
            if (segmentsEquivalentFare != null) {
                segmentsEquivalentFare = segmentsEquivalentFare.negate();
            }
            if (reservedSeatsEquivalentFare != null) {
                reservedSeatsEquivalentFare = reservedSeatsEquivalentFare.negate();
            }
            if (taxesEquivalentFare != null) {
                taxesEquivalentFare = taxesEquivalentFare.negate();
            }
        }
        Double vendorBonusRate = null;
        try {
            vendorBonusRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus rate", (Throwable)e);
        }
        BigDecimal vendorBonusValue = null;
        try {
            vendorBonusValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor bonus value", (Throwable)e);
        }
        Double vendorCommissionRate = null;
        try {
            vendorCommissionRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission rate", (Throwable)e);
        }
        BigDecimal vendorCommissionValue = null;
        try {
            vendorCommissionValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor commission value", (Throwable)e);
        }
        Double vendorFeeRate = null;
        try {
            vendorFeeRate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee rate", (Throwable)e);
        }
        BigDecimal vendorFeeValue = null;
        try {
            vendorFeeValue = BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)RailwayMcoProductHelper.getUnmodifiableCommissions((RailwayMcoProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund);
        }
        catch (Exception e) {
            this.log.error("failed calculating vendor fee value", (Throwable)e);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = null;
            Object dateOfVendorPayment = null;
            for (GeneralProductFop fop : RailwayMcoProductHelper.getVendorFops((RailwayMcoProduct)product)) {
                if (fop.getType() != null) {
                    vendorFopTypes.add(fop.getType());
                }
                if (fop.getOperationDate() == null || dateOfVendorPayment != null && !((Date)dateOfVendorPayment).before(fop.getOperationDate())) continue;
                dateOfVendorPayment = fop.getOperationDate();
            }
            data.setVendorFopAmount(ProductStatus.REFUND != product.getStatus() ? vendorFOPAmount : (vendorFOPAmount != null ? vendorFOPAmount.negate() : null));
            data.setVendorFopTypes(vendorFopTypes);
            data.setDateOfVendorPayment(dateOfVendorPayment);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = RailwayMcoProductHelper.getSubagentFops((RailwayMcoProduct)product, (boolean)false);
            if (subagentFops != null) {
                for (GeneralProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (fop.getCommissions().isEmpty()) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            aggregator.aggregate(vendorFopTypes);
            aggregator.aggregate((Date)dateOfVendorPayment);
        }
        data.setClientFopAmount(clientFOPAmount);
        data.setNavigationKey(uid);
        data.setSystemNumber(systemNumber);
        data.setProviderSystemNumber(providerSystemNumber);
        data.setAgency(agency);
        data.setBlankOwner(blankOwner);
        data.setBlankOwnerCode(blankOwnerCode);
        data.setAgent(agent);
        data.setCancellationDate(refuseDate);
        data.setBlankType(blankType);
        data.setChecked(Boolean.valueOf(checked));
        data.setCompleted(Boolean.valueOf(completed));
        data.setClient(client);
        data.setTimeLimit(reservation.getTimeLimit());
        if (product.getNextProduct() != null) {
            data.setNextProductUid(product.getNextProduct().getUid());
        }
        data.setTrainNumbers(trainNumbers);
        data.setTravellerDocNumbers(travellerDocNumbers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setClientBonusRate(clientBonusRate);
            data.setClientBonusValue(clientBonusValue);
            data.setClientCommissionRate(clientCommissionRate);
            data.setClientCommissionValue(clientCommissionValue);
            data.setClientFeeRate(clientFeeRate);
            data.setClientFeeValue(clientFeeValue);
            data.setClientFopAmount(ProductStatus.REFUND != product.getStatus() ? clientFOPAmount : (clientFOPAmount != null ? clientFOPAmount.negate() : null));
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setClientFopAgent(clientFOPAgent);
            data.setDateOfClientPayment(dateOfClientPayment);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        }
        data.setEticket(Boolean.valueOf(eticket));
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDateTime);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setPassengerTypes(passengerTypes);
            data.setPenalty(penalty);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setRelatedTicketNo(relatedTicketNo);
            data.setRouteLine(routeLine);
        }
        data.setBranch(branch);
        data.setSalesPoint(salesPoint);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSellAgent(sellAgent);
        }
        data.setStatus(status);
        data.setSubagency(subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setSubagencyBonusRate(subagencyBonusRate);
            data.setSubagencyBonusValue(subagencyBonusValue);
            data.setSubagencyCommissionRate(subagencyCommissionRate);
            data.setSubagencyCommissionValue(subagencyCommissionValue);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setSubagencyFeeValue(subagencyFeeValue);
        }
        data.setSupplier(vendor);
        data.setTicketType(ticketType);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setTravellers((Collection)travellers);
        }
        data.setHasOtherErrors(Boolean.valueOf(hasOtherErrors));
        data.setHasStockControlErrors(Boolean.valueOf(hasStockControlErrors));
        ArrayList<DictionaryReference> carriers = new ArrayList<DictionaryReference>();
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.getCarrier() == null) continue;
            carriers.add(segment.getCarrier());
        }
        data.setCarriers(carriers);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setDepartureDate(departureDate);
            data.setCarriageTypes(carriageTypes);
            data.setCompartmentTypes(compartmentTypes);
            data.setServiceClasses(serviceClasses);
            data.setSegmentsEquivalentFare(segmentsEquivalentFare);
            data.setReservedSeatsEquivalentFare(reservedSeatsEquivalentFare);
            data.setTaxesEquivalentFare(taxesEquivalentFare);
            data.setVendorBonusRate(vendorBonusRate);
            data.setVendorBonusValue(vendorBonusValue);
            data.setVendorCommissionRate(vendorCommissionRate);
            data.setVendorCommissionValue(vendorCommissionValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setVendorFeeValue(vendorFeeValue);
        } else {
            vendorFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeValue = IndexBuilderHelper.getVoidFeeValue((BaseProduct)product, (ContractType)ContractType.CLIENT);
            vendorFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.VENDOR);
            subagencyFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
            clientFeeRate = IndexBuilderHelper.getVoidFeeRate((BaseProduct)product, (ContractType)ContractType.CLIENT);
            data.setVendorFeeValue(vendorFeeValue);
            data.setSubagencyFeeValue(subagencyFeeValue);
            data.setClientFeeValue(clientFeeValue);
            data.setVendorFeeRate(vendorFeeRate);
            data.setSubagencyFeeRate(subagencyFeeRate);
            data.setClientFeeRate(clientFeeRate);
            data.setVendorFopAmount(vendorFeeValue);
            data.setSubagentFopAmount(subagencyFeeValue);
            data.setClientFopAmount(clientFeeValue);
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) {
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
        }
        aggregator.aggregate((Object)bookingNumber);
        aggregator.aggregate((Object)uid);
        aggregator.aggregate((Object)systemNumber);
        aggregator.aggregate((Object)providerSystemNumber);
        aggregator.aggregate((Object)agency);
        aggregator.aggregate((Object)blankOwner);
        aggregator.aggregate((Object)blankOwnerCode);
        aggregator.aggregate((Object)agent);
        aggregator.aggregate(refuseDate);
        aggregator.aggregate((Object)blankType);
        aggregator.aggregate((Object)client);
        aggregator.aggregate((Object)clientBonusRate);
        aggregator.aggregate((Object)clientBonusValue);
        aggregator.aggregate((Object)clientCommissionRate);
        aggregator.aggregate((Object)clientCommissionValue);
        aggregator.aggregate((Object)clientFeeRate);
        aggregator.aggregate((Object)clientFeeValue);
        aggregator.aggregate(clientFopTypes);
        aggregator.aggregate(clientFeesFopTypes);
        aggregator.aggregate(clientFOPAgent);
        aggregator.aggregate(dateOfClientPayment);
        aggregator.aggregate(issueDate);
        aggregator.aggregate(passengerTypes);
        aggregator.aggregate((Object)penalty);
        aggregator.aggregate((Object)relatedTicketNo);
        aggregator.aggregate((Object)routeLine);
        aggregator.aggregate((Object)branch);
        aggregator.aggregate((Object)salesPoint);
        aggregator.aggregate(sellAgent);
        aggregator.aggregate((Enum)status);
        aggregator.aggregate((Object)subagency);
        aggregator.aggregate((Object)subagencyBonusRate);
        aggregator.aggregate((Object)subagencyBonusValue);
        aggregator.aggregate((Object)subagencyCommissionRate);
        aggregator.aggregate((Object)subagencyCommissionValue);
        aggregator.aggregate((Object)subagencyFeeRate);
        aggregator.aggregate((Object)subagencyFeeValue);
        aggregator.aggregate((Object)vendor);
        aggregator.aggregate((Enum)ticketType);
        aggregator.aggregate((Iterable)travellers);
        aggregator.aggregate(carriageTypes);
        aggregator.aggregate(compartmentTypes);
        aggregator.aggregate(serviceClasses);
        aggregator.aggregate((Object)vendorBonusRate);
        aggregator.aggregate((Object)vendorBonusValue);
        aggregator.aggregate((Object)vendorCommissionRate);
        aggregator.aggregate((Object)vendorCommissionValue);
        aggregator.aggregate((Object)vendorFeeRate);
        aggregator.aggregate((Object)vendorFeeValue);
        String notes = product.getReservation().getBookingFile().getNotes();
        data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
        data.setInDelivery(Boolean.valueOf(inDelivery));
        EntityReference cashierRef = null;
        try {
            cashierRef = agent;
            EntityContainer cashierCtr = EntityStorage.get().resolve(cashierRef);
            if (cashierCtr != null) {
                Person cashier = (Person)cashierCtr.getEntity();
                for (PersonMetadata meta : cashier.getMetadata()) {
                    if (!MetadataKey.KEY_PERSON_PROFILE_GROUP.name().equals(meta.getKey().getCode())) continue;
                    DictionaryReference pgRef = (DictionaryReference)meta.getValue();
                    if (pgRef != null) {
                        aggregator.aggregate((Object)pgRef);
                    }
                    data.setProfileGroup(pgRef);
                }
            }
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
        }
        List costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        if (!costCodes.isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue((List)costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }

    private void updateReservationGdsNameInfo(RailwayProductIndexData data, DataAggregator aggregator, Reservation reservation) {
        List gdsNames = IndexBuilderHelper.getGdsNames((Reservation)reservation);
        data.setGdsNames((Collection)gdsNames);
        List recordLocators = IndexBuilderHelper.getRecordLocators((Reservation)reservation);
        data.setRecordLocators((Collection)recordLocators);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        data.setDisplayedGdsName(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation));
        aggregator.aggregate((Iterable)gdsNames);
        aggregator.aggregate((Iterable)recordLocators);
    }
}

