/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPGDArchiveExchangeDocumentIndexHandler
implements IndexHandler<SPGDArchiveExchangeDocument, SPGDArchiveExchangeDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void create(EntityContainer<SPGDArchiveExchangeDocument> etc, Collection<BaseIndexData<SPGDArchiveExchangeDocument, SPGDArchiveExchangeDocumentIndex>> indexes) {
        SPGDArchiveExchangeDocument document = (SPGDArchiveExchangeDocument)etc.getEntity();
        SPGDArchiveExchangeDocumentIndexData indexData = new SPGDArchiveExchangeDocumentIndexData();
        indexes.add((BaseIndexData<SPGDArchiveExchangeDocument, SPGDArchiveExchangeDocumentIndex>)indexData);
        indexData.setCreated(document.getCreated());
        indexData.setCheckSum(document.getCheckSum());
        indexData.setLocation(document.getLocation());
        indexData.setStatus(document.getStatus());
        indexData.setIssueDate(document.getIssueDate());
        indexData.setSystemNumber(document.getSystemNumber());
        indexData.setTransactionType(document.getTransactionType());
        indexData.setAgency(document.getAgency());
        indexData.setSize(document.getContent() == null ? 0 : document.getContent().length);
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        aggregator.aggregate((Object)document.getLocation());
        aggregator.aggregate((Enum)document.getStatus());
        aggregator.aggregate(document.getIssueDate());
        aggregator.aggregate((Object)document.getSystemNumber());
        aggregator.aggregate((Enum)document.getTransactionType());
        aggregator.aggregate((Object)document.getAgency());
        indexData.setAggregatedData(aggregator.toString());
    }

    public Class<? extends BaseIndexData<SPGDArchiveExchangeDocument, SPGDArchiveExchangeDocumentIndex>> getDataClass() {
        return SPGDArchiveExchangeDocumentIndexData.class;
    }

    public Class<SPGDArchiveExchangeDocument> getEntityType() {
        return SPGDArchiveExchangeDocument.class;
    }

    public Class<SPGDArchiveExchangeDocumentIndex> getIndexClass() {
        return SPGDArchiveExchangeDocumentIndex.class;
    }
}

