/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPGDExchangeDocumentIndexHandler
implements IndexHandler<SPGDExchangeDocument, SPGDExchangeDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void create(EntityContainer<SPGDExchangeDocument> etc, Collection<BaseIndexData<SPGDExchangeDocument, SPGDExchangeDocumentIndex>> indexes) {
        SPGDExchangeDocument document = (SPGDExchangeDocument)etc.getEntity();
        SPGDExchangeDocumentIndexData indexData = new SPGDExchangeDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        aggregator.aggregate((Object)document.getLocation());
        aggregator.aggregate((Enum)document.getStatus());
        aggregator.aggregate(document.getIssued());
        aggregator.aggregate((Object)document.getSystemNumber());
        aggregator.aggregate((Iterable)document.getTravellers());
        aggregator.aggregate((Enum)document.getTransactionType());
        aggregator.aggregate((Object)document.getRelatedBookingFile());
        indexData.setCreated(document.getCreated());
        indexData.setCheckSum(document.getCheckSum());
        indexData.setLocation(document.getLocation());
        indexData.setStatus(document.getStatus());
        indexData.setIssued(document.getIssued());
        indexData.setSystemNumber(document.getSystemNumber());
        indexData.setTravellers((Collection)document.getTravellers());
        indexData.setTransactionType(document.getTransactionType());
        indexData.setSize(document.getContent() == null ? 0 : document.getContent().length);
        indexData.setRelatedBookingFile(document.getRelatedBookingFile());
        indexData.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<SPGDExchangeDocument, SPGDExchangeDocumentIndex>)indexData);
    }

    public Class<? extends BaseIndexData<SPGDExchangeDocument, SPGDExchangeDocumentIndex>> getDataClass() {
        return SPGDExchangeDocumentIndexData.class;
    }

    public Class<SPGDExchangeDocument> getEntityType() {
        return SPGDExchangeDocument.class;
    }

    public Class<SPGDExchangeDocumentIndex> getIndexClass() {
        return SPGDExchangeDocumentIndex.class;
    }
}

