/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UFSExchangeDocumentIndexHandler
implements IndexHandler<UFSExchangeDocument, UFSExchangeDocumentIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void create(EntityContainer<UFSExchangeDocument> etc, Collection<BaseIndexData<UFSExchangeDocument, UFSExchangeDocumentIndex>> indexes) {
        UFSExchangeDocument document = (UFSExchangeDocument)etc.getEntity();
        UFSExchangeDocumentIndexData indexData = new UFSExchangeDocumentIndexData();
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(document.getCreated());
        aggregator.aggregate((Object)document.getLocation());
        aggregator.aggregate((Enum)document.getStatus());
        aggregator.aggregate(document.getIssued());
        aggregator.aggregate((Object)document.getSystemNumber());
        aggregator.aggregate((Iterable)document.getTravellers());
        aggregator.aggregate((Enum)document.getTransactionType());
        aggregator.aggregate((Object)document.getRelatedBookingFile());
        indexData.setCreated(document.getCreated());
        indexData.setCheckSum(document.getCheckSum());
        indexData.setLocation(document.getLocation());
        indexData.setStatus(document.getStatus());
        indexData.setIssued(document.getIssued());
        indexData.setSystemNumber(document.getSystemNumber());
        indexData.setTravellers((Collection)document.getTravellers());
        indexData.setTransactionType(document.getTransactionType());
        indexData.setSize(document.getContent() == null ? 0 : document.getContent().length);
        indexData.setRelatedBookingFile(document.getRelatedBookingFile());
        indexData.setAggregatedData(aggregator.toString());
        indexData.setProductType(document.getProductType());
        indexes.add((BaseIndexData<UFSExchangeDocument, UFSExchangeDocumentIndex>)indexData);
    }

    public Class<? extends BaseIndexData<UFSExchangeDocument, UFSExchangeDocumentIndex>> getDataClass() {
        return UFSExchangeDocumentIndexData.class;
    }

    public Class<UFSExchangeDocument> getEntityType() {
        return UFSExchangeDocument.class;
    }

    public Class<UFSExchangeDocumentIndex> getIndexClass() {
        return UFSExchangeDocumentIndex.class;
    }
}

