/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class RailwayMcoProductInterceptor
implements EntityInterceptor {
    private static final double PRIORITY = 2.01;

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof RailwayMcoProduct)) continue;
                RailwayMcoProduct product = (RailwayMcoProduct)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 2.01;
    }

    private void updateProduct(RailwayMcoProduct product, boolean isNewProduct) {
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (isNewProduct) {
            this.updateFops(product);
        }
    }

    private void updateFops(RailwayMcoProduct product) {
        List<Object> vendorFops = new ArrayList<GeneralProductFop>();
        List<Object> clientFops = new ArrayList<GeneralProductFop>();
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (GeneralProductContractRelationData item : RailwayMcoProductHelper.getContractRelations((RailwayMcoProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                }
            }
        }
        this.updateFops(clientFops, vendorFops);
        for (List sf : subagentFops) {
            this.updateFops(sf, clientFops);
        }
    }

    private void updateFops(List<GeneralProductFop> targetFops, List<GeneralProductFop> sourceFops) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (GeneralProductFop pf : sourceFops) {
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)pf)) continue;
            try {
                GeneralProductFop fop = (GeneralProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                targetFops.add(fop);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to clone a fop", (Throwable)e);
            }
        }
    }
}

