/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.interceptors;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RailwayProductVatCalculator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class RailwayProductInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof RailwayProduct)) continue;
                RailwayProduct product = (RailwayProduct)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
            }
        }
        if (oldBookingFileContainer == null) {
            return;
        }
        List uids = BookingHelper.getProductsStream((BookingFile)((BookingFile)oldBookingFileContainer.getEntity()), RailwayProduct.class).map(BaseIdentity::getUid).filter(uid -> BookingHelper.getProductsStream((BookingFile)bookingFile, RailwayProduct.class).noneMatch(rp -> TextUtil.equals((String)uid, (String)rp.getUid(), (boolean)false))).collect(Collectors.toList());
        if (uids.isEmpty()) {
            return;
        }
        BookingHelper.getProductsStream((BookingFile)bookingFile, RailwayReferenceMCO.class).forEach(mco -> {
            if (mco.getRelatedProduct() != null && uids.contains(mco.getRelatedProduct().getUid())) {
                mco.setRelatedProduct(null);
            }
        });
    }

    private void updateProduct(RailwayProduct product, boolean isNewProduct) throws Exception {
        this.updateBranch(product);
        product.setServiceLocationType(RailwayProductHelper.getServiceLocationType((RailwayProduct)product));
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (product.getTicketType() == TicketType.FAKE || product.isChecked()) {
            return;
        }
        this.updateScnAndEticketFlag(product);
        RailwayProductVatCalculator.updateVat(product);
        if (isNewProduct) {
            this.updateFops(product);
        }
    }

    private void updateBranch(RailwayProduct product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private void updateScnAndEticketFlag(RailwayProduct product) {
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        product.setEticket(blankType != null && blankType.getBlankCategory() == BlankCategory.ETICKET);
        if (blankType != null) {
            if (blankType.getBlankCategory() != BlankCategory.ETICKET && blankType.getBlankCategory() != BlankCategory.GENERATED_NUMBER) {
                product.setScn(product.getSystemNumber());
            } else if (blankType.getBlankCategory() != BlankCategory.GENERATED_NUMBER) {
                product.setScn(null);
            }
        }
    }

    private void updateFops(RailwayProduct product) {
        List vendorFops = null;
        List clientFops = null;
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations((RailwayProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                }
            }
        }
        EntityReference salesPointRef = product.getSalesPoint();
        Date operationDate = product.getIssueDate();
        EntityReference agent = product.getCashier();
        if (agent == null) {
            try {
                agent = ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        operationDate = null;
        agent = null;
        this.updateFops(clientFops, vendorFops, (EntityReference<SalesPoint>)salesPointRef, operationDate, (EntityReference<Person>)agent);
        for (List sf : subagentFops) {
            this.updateFops(sf, clientFops, (EntityReference<SalesPoint>)salesPointRef, operationDate, null);
        }
    }

    private void updateFops(List<RailwayProductFop> targetFops, List<RailwayProductFop> sourceFops, EntityReference<SalesPoint> salesPointRef, Date operationDate, EntityReference<Person> agent) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (RailwayProductFop pf : sourceFops) {
            if (!RailwayProductHelper.isServiceFop((RailwayProductFop)pf)) continue;
            try {
                RailwayProductFop fop = (RailwayProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                targetFops.add(fop);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to clone a fop", (Throwable)e);
            }
        }
    }
}

