/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RailwayReferenceMCOInterceptor
implements EntityInterceptor {
    static final Logger log = LoggerFactory.getLogger(RailwayReferenceMCOInterceptor.class);

    public double getPriority() {
        return 2.02;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        BookingFile bookingFile = (BookingFile)container.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : res.getProducts()) {
                if (!(baseProduct instanceof RailwayReferenceMCO)) continue;
                final RailwayReferenceMCO mco = (RailwayReferenceMCO)baseProduct;
                ProductsHelper.updateScnAndEticketFlag((ProductsHelper.BlankTypeHandler)new ProductsHelper.BlankTypeHandler(){

                    public void setEticket(boolean value) {
                    }

                    public String getSystemNumber() {
                        return mco.getSystemNumber();
                    }

                    public int getConjunctionsCount() {
                        return 0;
                    }

                    public DictionaryReference<BlankType> getBlankType() {
                        return mco.getBlankType();
                    }

                    public void clearSCN() {
                        mco.setScn(null);
                    }

                    public void addSCN(String value) {
                        mco.setScn(value);
                    }
                });
                if (mco.getLocalIssueDate() != null) continue;
                mco.setLocalIssueDate(mco.getIssueDate());
            }
        }
    }
}

