/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.dict;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DictionaryDataProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RailwayStationsDataProvider
implements DictionaryDataProvider {
    private static final transient Logger log = LoggerFactory.getLogger(RailwayStationsDataProvider.class);
    private static final Map<String, CountryReference> countries = new HashMap<String, CountryReference>();
    private static final Map<String, RailwayStation> stationsMap;

    private static void put(String code, String expressCode, String shortName, String name, String route, String country) {
        if (code == null) {
            throw new IllegalArgumentException("code can't be null!");
        }
        RailwayStation station = new RailwayStation();
        station.setCode(code);
        station.getCodeVariants().put(CodeSystem.EXPRESS.name(), expressCode);
        station.setShortName(shortName);
        station.getTranslations().put(new Locale("ru", "RU"), name);
        if (!TextUtil.isBlank((String)expressCode) && expressCode.length() > 1) {
            String countryCode = expressCode.substring(0, 2);
            if (countries.containsKey(countryCode)) {
                station.setCountry((DictionaryReference)countries.get(countryCode));
            } else {
                log.warn(String.format("no country defined for railway station %s", expressCode));
            }
        }
        stationsMap.put(code, station);
    }

    public String getId() {
        return "railway-stations-data-provider";
    }

    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        return modifiedSince != null || ignoredTypes.contains(RailwayStation.class.getName()) ? Collections.emptyList() : stationsMap.values();
    }

    public <D extends BaseDictionary> D load(Class<D> cls, String code) throws Exception {
        return (D)((BaseDictionary)stationsMap.get(code));
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> save(D dict, boolean ignoreInterceptors) throws Exception {
        return new DictionaryDataProvider.DictionaryUpdateResult();
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> delete(D dict, boolean ignoreInterceptors) throws Exception {
        return new DictionaryDataProvider.DictionaryUpdateResult();
    }

    public Collection<? extends DictionaryReference<?>> getDeleted(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        return Collections.emptyList();
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> update(Collection<D> dictionaries, Class<D> cls, boolean ignoreInterceptors) throws Exception {
        throw new UnsupportedOperationException("bulk update is not supported");
    }

    public Collection<String> getResetTypes(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        return Collections.emptySet();
    }

    static {
        countries.put("26", new CountryReference("EE"));
        countries.put("80", new CountryReference("DE"));
        countries.put("20", new CountryReference("RU"));
        countries.put("29", new CountryReference("UZ"));
        countries.put("67", new CountryReference("TM"));
        countries.put("22", new CountryReference("UA"));
        countries.put("27", new CountryReference("KZ"));
        countries.put("23", new CountryReference("MD"));
        countries.put("28", new CountryReference("GE"));
        countries.put("58", new CountryReference("AM"));
        countries.put("25", new CountryReference("LV"));
        countries.put("21", new CountryReference("BY"));
        countries.put("57", new CountryReference("AZ"));
        countries.put("53", new CountryReference("RO"));
        countries.put("24", new CountryReference("LT"));
        countries.put("66", new CountryReference("TJ"));
        countries.put("55", new CountryReference("HU"));
        countries.put("75", new CountryReference("TR"));
        countries.put("33", new CountryReference("CN"));
        countries.put("51", new CountryReference("PL"));
        countries.put("84", new CountryReference("NL"));
        countries.put("87", new CountryReference("FR"));
        countries.put("88", new CountryReference("BE"));
        countries.put("81", new CountryReference("AT"));
        countries.put("73", new CountryReference("GR"));
        countries.put("31", new CountryReference("MN"));
        countries.put("59", new CountryReference("KG"));
        countries.put("85", new CountryReference("CH"));
        countries.put("56", new CountryReference("SK"));
        countries.put("72", new CountryReference("RS"));
        countries.put("54", new CountryReference("CZ"));
        countries.put("83", new CountryReference("IT"));
        countries.put("52", new CountryReference("BG"));
        countries.put("10", new CountryReference("FI"));
        countries.put("78", new CountryReference("HR"));
        countries.put("86", new CountryReference("DK"));
        countries.put("70", new CountryReference("GB"));
        countries.put("65", new CountryReference("MK"));
        countries.put("74", new CountryReference("SE"));
        countries.put("96", new CountryReference("IR"));
        countries.put("79", new CountryReference("SI"));
        countries.put("71", new CountryReference("ES"));
        countries.put("30", new CountryReference("KP"));
        countries.put("76", new CountryReference("NO"));
        countries.put("42", new CountryReference("AB"));
        stationsMap = new HashMap<String, RailwayStation>();
        RailwayStationInitializer01.init();
        RailwayStationInitializer02.init();
        RailwayStationInitializer03.init();
        RailwayStationInitializer04.init();
        RailwayStationInitializer05.init();
        RailwayStationInitializer06.init();
        RailwayStationInitializer07.init();
        RailwayStationInitializer08.init();
        RailwayStationInitializer09.init();
    }

    private static final class RailwayStationInitializer09 {
        private RailwayStationInitializer09() {
        }

        public static void init() {
            RailwayStationsDataProvider.put("2024555", "2024555", "\u0416\u0415\u041b\u041e\u0411\u041e\u0412\u041e", "\u0416\u0415\u041b\u041e\u0411\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024913", "2024913", "\u041c\u0410\u041b\u042e\u0422\u0418\u041d\u041e", "\u041c\u0410\u041b\u042e\u0422\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024556", "2024556", "\u0412\u0415\u0420\u0414\u0410", "\u0412\u0415\u0420\u0414\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024908", "2024908", "\u041a\u0420\u0418\u0412\u0421\u041a\u0418\u0419", "\u041a\u0420\u0418\u0412\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024557", "2024557", "\u0420\u0415\u041c\u0418\u0417\u041e\u0412\u041e", "\u0420\u0415\u041c\u0418\u0417\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024558", "2024558", "\u041c\u0423\u0420\u0410\u0412\u041b\u042f\u041d\u041a\u0410", "\u041c\u0423\u0420\u0410\u0412\u041b\u042f\u041d\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024559", "2024559", "\u042f\u0413\u041e\u0414\u041d\u041e\u0415", "\u042f\u0413\u041e\u0414\u041d\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024561", "2024561", "\u0425\u041b\u0423\u0414\u041e\u0412\u041e", "\u0425\u041b\u0423\u0414\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024562", "2024562", "\u0420\u0410\u041a\u0428\u0410", "\u0420\u0410\u041a\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024879", "2024879", "\u0411\u0410\u0417\u0415\u0412\u041e", "\u0411\u0410\u0417\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024570", "2024570", "\u041c\u041e\u0420\u0428\u0410\u041d\u0421\u041a", "\u041c\u041e\u0420\u0428\u0410\u041d\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2025882", "2025882", "\u041e\u041f 448 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 448 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024802", "2024802", "\u041a\u041e\u0420\u0428\u0423\u041d\u041e\u0412\u041a\u0410", "\u041a\u041e\u0420\u0428\u0423\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024904", "2024904", "\u041a\u0410\u0428\u041c\u0410", "\u041a\u0410\u0428\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024564", "2024564", "\u0412\u042f\u0416\u041b\u0418", "\u0412\u042f\u0416\u041b\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024565", "2024565", "\u0424\u0418\u0422\u0418\u041d\u0413\u041e\u0424", "\u0424\u0418\u0422\u0418\u041d\u0413\u041e\u0424", "\u0419", null);
            RailwayStationsDataProvider.put("2024566", "2024566", "\u0414\u0410\u0428\u041a\u041e\u0412\u041e", "\u0414\u0410\u0428\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024922", "2024922", "\u041f\u041e\u041c\u0418\u041d\u0410\u0415\u0412\u041a\u0410", "\u041f\u041e\u041c\u0418\u041d\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024571", "2024571", "\u0421\u041e\u0421\u0415\u0414\u041a\u0410", "\u0421\u041e\u0421\u0415\u0414\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024580", "2024580", "\u0425\u0423\u0422\u041e\u0420", "\u0425\u0423\u0422\u041e\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024572", "2024572", "\u041a\u0410\u041d\u0414\u0418\u0415\u0412\u041a\u0410", "\u041a\u0410\u041d\u0414\u0418\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024881", "2024881", "\u0411\u0410\u0428\u041c\u0410\u041a\u041e\u0412\u041e", "\u0411\u0410\u0428\u041c\u0410\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024573", "2024573", "\u0413\u041b\u0415\u0411\u041e\u0412\u041a\u0410", "\u0413\u041b\u0415\u0411\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024924", "2024924", "\u041f\u042f\u0422\u041d\u0418\u0426\u041a\u041e\u0415", "\u041f\u042f\u0422\u041d\u0418\u0426\u041a\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024574", "2024574", "\u041f\u0410\u0427\u0415\u041b\u041c\u0410", "\u041f\u0410\u0427\u0415\u041b\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025952", "2025952", "\u0422\u041e\u041b\u041a\u041e\u0412\u041a\u0410", "\u0422\u041e\u041b\u041a\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024576", "2024576", "\u0412\u041e\u0414\u0415\u041d\u042f\u041f\u0418\u041d\u041e", "\u0412\u041e\u0414\u0415\u041d\u042f\u041f\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024577", "2024577", "\u0422\u0418\u0422\u041e\u0412\u041e", "\u0422\u0418\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024887", "2024887", "\u0412\u0410\u0420\u0415\u0416\u041a\u0410", "\u0412\u0410\u0420\u0415\u0416\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024578", "2024578", "\u0410\u0414\u0418\u041a\u0410\u0415\u0412\u041a\u0410", "\u0410\u0414\u0418\u041a\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024905", "2024905", "\u041a\u0415\u0412\u0414\u0410", "\u041a\u0415\u0412\u0414\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025802", "2025802", "\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024579", "2024579", "\u0411\u0415\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0411\u0415\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2025900", "2025900", "\u041b\u0415\u0420\u041c\u041e\u041d\u0422\u041e\u0412\u0421", "\u041b\u0415\u0420\u041c\u041e\u041d\u0422\u041e\u0412\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024581", "2024581", "\u0421\u0422\u0423\u0414\u0415\u041d\u0415\u0426", "\u0421\u0422\u0423\u0414\u0415\u041d\u0415\u0426", "\u0419", null);
            RailwayStationsDataProvider.put("2024917", "2024917", "\u041f\u0410\u041d\u0427\u0423\u041b\u0418\u0414\u0417\u0418", "\u041f\u0410\u041d\u0427\u0423\u041b\u0418\u0414\u0417\u0418\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024796", "2024796", "\u0421\u0418\u041c\u0410\u041d\u0429\u0418\u041d\u0410", "\u0421\u0418\u041c\u0410\u041d\u0429\u0418\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024923", "2024923", "\u041f\u041e\u0421\u041b\u041e\u0412\u041a\u0410", "\u041f\u041e\u0421\u041b\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024582", "2024582", "\u0420\u0410\u041c\u0417\u0410\u0419", "\u0420\u0410\u041c\u0417\u0410\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024925", "2024925", "\u041f\u042f\u0428\u0410", "\u041f\u042f\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024781", "2024781", "\u0410\u0420\u0411\u0415\u041a\u041e\u0412\u041e", "\u0410\u0420\u0411\u0415\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024120", "2024120", "\u041f\u0415\u041d\u0417\u0410 1", "\u041f\u0415\u041d\u0417\u0410 1", "\u0419", null);
            RailwayStationsDataProvider.put("2024546", "2024546", "\u041f\u0415\u041d\u0417\u0410 2", "\u041f\u0415\u041d\u0417\u0410 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024583", "2024583", "\u0421\u0415\u041b\u0418\u041a\u0421\u0410", "\u0421\u0415\u041b\u0418\u041a\u0421\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024584", "2024584", "\u041b\u0415\u041e\u041d\u0418\u0414\u041e\u0412\u041a\u0410", "\u041b\u0415\u041e\u041d\u0418\u0414\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024585", "2024585", "\u0428\u041d\u0410\u0415\u0412\u041e", "\u0428\u041d\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024966", "2024966", "\u041a\u0410\u041d\u0410\u0415\u0412\u041a\u0410", "\u041a\u0410\u041d\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024586", "2024586", "\u0410\u0421\u0415\u0415\u0412\u0421\u041a\u0410\u042f", "\u0410\u0421\u0415\u0415\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024587", "2024587", "\u0427\u0410\u0410\u0414\u0410\u0415\u0412\u041a\u0410", "\u0427\u0410\u0410\u0414\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024588", "2024588", "\u041a\u041e\u0414\u0410\u0414\u0410", "\u041a\u041e\u0414\u0410\u0414\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024589", "2024589", "\u0415\u041b\u042e\u0417\u0410\u041d\u042c", "\u0415\u041b\u042e\u0417\u0410\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2024591", "2024591", "\u0421\u042e\u0417\u042e\u041c", "\u0421\u042e\u0417\u042e\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024590", "2024590", "\u041a\u0423\u0417\u041d\u0415\u0426\u041a", "\u041a\u0423\u0417\u041d\u0415\u0426\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024592", "2024592", "\u0415\u0412\u041b\u0410\u0428\u0415\u0412\u041e", "\u0415\u0412\u041b\u0410\u0428\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024593", "2024593", "\u041d\u0418\u041a\u0423\u041b\u0418\u041d\u041e", "\u041d\u0418\u041a\u0423\u041b\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024594", "2024594", "\u041a\u041b\u042e\u0427\u0418\u041a\u0418", "\u041a\u041b\u042e\u0427\u0418\u041a\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024595", "2024595", "\u041f\u0420\u0410\u0421\u041a\u041e\u0412\u042c\u0418\u041d", "\u041f\u0420\u0410\u0421\u041a\u041e\u0412\u042c\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024804", "2024804", "\u041a\u0410\u041d\u0410\u0414\u0415\u0419", "\u041a\u0410\u041d\u0410\u0414\u0415\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024596", "2024596", "\u041d\u041e\u0412\u041e\u0421\u041f\u0410\u0421\u0421\u041a", "\u041d\u041e\u0412\u041e\u0421\u041f\u0410\u0421\u0421\u041a\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024597", "2024597", "\u041a\u041e\u041f\u0422\u0415\u0412\u041a\u0410", "\u041a\u041e\u041f\u0422\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024598", "2024598", "\u0420\u0415\u041f\u042c\u0415\u0412\u041a\u0410", "\u0420\u0415\u041f\u042c\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024601", "2024601", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c 2", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024603", "2024603", "\u041e\u041a\u0422\u042f\u0411\u0420\u042c\u0421\u041a", "\u041e\u041a\u0422\u042f\u0411\u0420\u042c\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024969", "2024969", "\u041f\u0420\u0410\u0412 \u0412\u041e\u041b\u0413\u0410", "\u041f\u0420\u0410\u0412\u0410\u042f \u0412\u041e\u041b\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024604", "2024604", "\u041e\u0411\u0428\u0410\u0420\u041e\u0412\u041a\u0410", "\u041e\u0411\u0428\u0410\u0420\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2026951", "2026951", "\u041e\u041f 1004 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1004 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024605", "2024605", "\u041c\u042b\u041b\u042c\u041d\u0410\u042f", "\u041c\u042b\u041b\u042c\u041d\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2025898", "2025898", "\u0411\u0410\u0428\u041a\u0418\u0420\u0421\u041a\u041e\u0415", "\u0411\u0410\u0428\u041a\u0418\u0420\u0421\u041a\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024606", "2024606", "\u041c\u0410\u0419\u0422\u0423\u0413\u0410", "\u041c\u0410\u0419\u0422\u0423\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024607", "2024607", "\u0411\u0415\u0417\u0415\u041d\u0427\u0423\u041a", "\u0411\u0415\u0417\u0415\u041d\u0427\u0423\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2025908", "2025908", "\u0412\u041e\u0421\u0422\u041e\u041a", "\u0412\u041e\u0421\u0422\u041e\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024609", "2024609", "\u0427\u0410\u041f\u0410\u0415\u0412\u0421\u041a", "\u0427\u0410\u041f\u0410\u0415\u0412\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024611", "2024611", "\u0422\u041e\u041c\u042b\u041b\u041e\u0412\u041e", "\u0422\u041e\u041c\u042b\u041b\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024893", "2024893", "\u0416\u0418\u0413\u0423\u041b\u0418", "\u0416\u0418\u0413\u0423\u041b\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024612", "2024612", "\u041d\u041e\u0412\u041e\u041a\u0423\u0419\u0411\u042b\u0428", "\u041d\u041e\u0412\u041e\u041a\u0423\u0419\u0411\u042b\u0428\u0415\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024613", "2024613", "\u041b\u0418\u041f\u042f\u0413\u0418", "\u041b\u0418\u041f\u042f\u0413\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024614", "2024614", "\u041a\u0420\u042f\u0416", "\u041a\u0420\u042f\u0416", "\u0419", null);
            RailwayStationsDataProvider.put("2024000", "2024000", "\u0421\u0410\u041c\u0410\u0420\u0410", "\u0421\u0410\u041c\u0410\u0420\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024779", "2024779", "\u0410\u041b\u0415\u041a\u0421\u0415\u0415\u0412\u0421\u041a", "\u0410\u041b\u0415\u041a\u0421\u0415\u0415\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024770", "2024770", "\u041a\u0410\u0420\u041b\u0410\u041c\u0410\u041d", "\u041a\u0410\u0420\u041b\u0410\u041c\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2026952", "2026952", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026953", "2026953", "\u041e\u041f 15 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 15 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026954", "2026954", "\u041e\u041f 22 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 22 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024965", "2024965", "\u041f\u0420\u0418\u0423\u0420\u0410\u041b\u042c\u0415", "\u041f\u0420\u0418\u0423\u0420\u0410\u041b\u042c\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024816", "2024816", "\u041e\u041f 36 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 36 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026955", "2026955", "\u041e\u041f 40 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 40 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026956", "2026956", "\u041e\u041f 44 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 44 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026957", "2026957", "\u041e\u041f 50\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 50\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024971", "2024971", "\u0420\u0410\u0412\u0422\u0410\u0423", "\u0420\u0410\u0412\u0422\u0410\u0423", "\u0419", null);
            RailwayStationsDataProvider.put("2026958", "2026958", "\u041e\u041f 71 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 71 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026959", "2026959", "\u041e\u041f 73 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 73 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024967", "2024967", "\u0417\u0423\u042f\u041a\u041e\u0412\u041e", "\u0417\u0423\u042f\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025960", "2025960", "\u041e\u041f 95 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 95 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2026961", "2026961", "\u041e\u041f 102 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 102 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024973", "2024973", "\u0422\u042e\u041b\u042c\u041c\u0410", "\u0422\u042e\u041b\u042c\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2026962", "2026962", "\u041e\u041f 115 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 115 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024964", "2024964", "\u0418\u041d\u0417\u0415\u0420", "\u0418\u041d\u0417\u0415\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024960", "2024960", "\u0410\u0419\u0413\u0418\u0420", "\u0410\u0419\u0413\u0418\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024976", "2024976", "\u042e\u0428\u0410", "\u042e\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024975", "2024975", "\u0423\u041b\u0423 \u0415\u041b\u0413\u0410", "\u0423\u041b\u0423-\u0415\u041b\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024972", "2024972", "\u0421\u0415\u0420\u041c\u0415\u041d\u041e\u0412\u041e", "\u0421\u0415\u0420\u041c\u0415\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024811", "2024811", "\u0411\u0415\u041b\u041e\u0420\u0415\u0426\u041a", "\u0411\u0415\u041b\u041e\u0420\u0415\u0426\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024817", "2024817", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024756", "2024756", "\u041d\u0418\u0416\u0415\u0413\u041e\u0420\u041e\u0414\u041a", "\u041d\u0418\u0416\u0415\u0413\u041e\u0420\u041e\u0414\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024807", "2024807", "\u0423\u0420\u0428\u0410\u041a", "\u0423\u0420\u0428\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2025919", "2025919", "\u041e\u041f 24 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 24 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024787", "2024787", "\u041a\u0410\u0411\u0410\u041a\u041e\u0412\u041e", "\u041a\u0410\u0411\u0410\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025920", "2025920", "\u041e\u041f 34 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 34 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024757", "2024757", "\u0418\u0411\u0420\u0410\u0413\u0418\u041c\u041e\u0412\u0421", "\u0418\u0411\u0420\u0410\u0413\u0418\u041c\u041e\u0412\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2025921", "2025921", "\u041e\u041f 42 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 42 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024758", "2024758", "\u0421\u0410\u0425\u0410\u0420\u041e\u0417\u0410\u0412", "\u0421\u0410\u0425\u0410\u0420\u041e\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024759", "2024759", "\u0422\u0410\u0417\u041b\u0410\u0420\u041e\u0412\u041e", "\u0422\u0410\u0417\u041b\u0410\u0420\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025922", "2025922", "\u041e\u041f 74 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 74 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024761", "2024761", "\u0422\u042e\u041a\u0423\u041d\u042c", "\u0422\u042e\u041a\u0423\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2025923", "2025923", "\u041e\u041f 84 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 84 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024762", "2024762", "\u041d\u0410\u0413\u0410\u0414\u0410\u041a", "\u041d\u0410\u0413\u0410\u0414\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2025924", "2025924", "\u041e\u041f 95 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 95 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024884", "2024884", "\u0411\u0415\u041b\u041e\u0415 \u041e\u0417", "\u0411\u0415\u041b\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024763", "2024763", "\u0414\u0410\u0420\u042c\u0418\u041d\u041e", "\u0414\u0410\u0420\u042c\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025906", "2025906", "\u041e\u041f 114 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 114 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024764", "2024764", "\u0423\u0421\u0422\u042c \u0417\u0418\u0413\u0410\u041d", "\u0423\u0421\u0422\u042c-\u0417\u0418\u0413\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024765", "2024765", "\u041a\u0423\u0413\u0410\u041d\u0410\u041a", "\u041a\u0423\u0413\u0410\u041d\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2025926", "2025926", "\u041e\u041f 132 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 132 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024766", "2024766", "\u041a\u041e\u0421\u042f\u041a\u041e\u0412\u041a\u0410", "\u041a\u041e\u0421\u042f\u041a\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024780", "2024780", "\u0421\u0422\u0415\u0420\u041b\u0418\u0422\u0410\u041c", "\u0421\u0422\u0415\u0420\u041b\u0418\u0422\u0410\u041c\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2026963", "2026963", "\u041e\u041f 150 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 150 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024878", "2024878", "\u0410\u0428\u041a\u0410\u0414\u0410\u0420", "\u0410\u0428\u041a\u0410\u0414\u0410\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2025964", "2025964", "\u041e\u041f 158 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 158 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024790", "2024790", "\u0421\u0410\u041b\u0410\u0412\u0410\u0422", "\u0421\u0410\u041b\u0410\u0412\u0410\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2025965", "2025965", "\u041e\u041f 184 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 184 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024769", "2024769", "\u0417\u0418\u0420\u0413\u0410\u041d", "\u0417\u0418\u0420\u0413\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2025966", "2025966", "\u041e\u041f 197 \u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 197 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024818", "2024818", "\u041e\u041f 199 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 199 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024771", "2024771", "\u041f\u0420\u0418\u0411\u0415\u041b\u042c\u0421\u041a\u0418", "\u041f\u0420\u0418\u0411\u0415\u041b\u042c\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2025967", "2025967", "\u041e\u041f 219 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 219 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024772", "2024772", "\u041c\u0415\u041b\u0415\u0423\u0417", "\u041c\u0415\u041b\u0415\u0423\u0417", "\u0419", null);
            RailwayStationsDataProvider.put("2024801", "2024801", "\u041a\u0410\u0420\u0410\u041d", "\u041a\u0410\u0420\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2025968", "2025968", "\u041e\u041f 237 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 237 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025969", "2025969", "\u041e\u041f 240 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 240 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024902", "2024902", "\u041a\u0410\u0420\u0410\u0413\u0410\u0419\u041a\u0410", "\u041a\u0410\u0420\u0410\u0413\u0410\u0419\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024773", "2024773", "\u041a\u0423\u041c\u0415\u0420\u0422\u0410\u0423", "\u041a\u0423\u041c\u0415\u0420\u0422\u0410\u0423", "\u0419", null);
            RailwayStationsDataProvider.put("2025970", "2025970", "\u041e\u041f 264 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 264 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024774", "2024774", "\u0415\u0420\u041c\u041e\u041b\u0410\u0415\u0412\u041e", "\u0415\u0420\u041c\u041e\u041b\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024775", "2024775", "\u041e\u0422\u0420 \u0411\u0410\u0428\u041a\u0418\u0420", "\u041e\u0422\u0420\u0410\u0414\u0410-\u0411\u0410\u0428\u041a\u0418\u0420\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2025927", "2025927", "\u041e\u041f 278 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 278 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025928", "2025928", "\u041e\u041f 290 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 290 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024776", "2024776", "\u041c\u0423\u0420\u0410\u041f\u0422\u0410\u041b\u041e\u0412", "\u041c\u0423\u0420\u0410\u041f\u0422\u0410\u041b\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025929", "2025929", "\u041e\u041f 306 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 306 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025930", "2025930", "\u041e\u041f 313 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 313 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024777", "2024777", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u041e\u0412", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024618", "2024618", "\u0422\u042e\u041b\u042c\u0413\u0410\u041d", "\u0422\u042e\u041b\u042c\u0413\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024985", "2024985", "\u041f\u0415\u041d\u0417\u0410 \u0417", "\u041f\u0415\u041d\u0417\u0410 \u0417", "\u0419", null);
            RailwayStationsDataProvider.put("2024548", "2024548", "\u041f\u0415\u041d\u0417\u0410 4", "\u041f\u0415\u041d\u0417\u0410 4", "\u0419", null);
            RailwayStationsDataProvider.put("2025971", "2025971", "\u041e\u041f 135\u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 135\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024545", "2024545", "\u0411\u0415\u0421\u0421\u041e\u041d\u041e\u0412\u041a\u0410", "\u0411\u0415\u0421\u0421\u041e\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025972", "2025972", "\u041e\u041f 125 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 125 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024544", "2024544", "\u0413\u0420\u0410\u0411\u041e\u0412\u041e", "\u0413\u0420\u0410\u0411\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025973", "2025973", "\u0412\u0410\u0417\u0415\u0420\u041a\u0418", "\u0412\u0410\u0417\u0415\u0420\u041a\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024938", "2024938", "\u0420\u0417\u0414 109 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 109 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025974", "2025974", "\u041e\u041f 106\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 106 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024543", "2024543", "\u041f\u0420\u041e\u041a\u0410\u0417\u041d\u0410", "\u041f\u0420\u041e\u041a\u0410\u0417\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025975", "2025975", "\u041e\u041f 97 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 97 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024542", "2024542", "\u041b\u0423\u041d\u0418\u041d\u041e", "\u041b\u0423\u041d\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024937", "2024937", "\u0420\u0417\u0414 86 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 86 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025976", "2025976", "\u041e\u041f 82 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 82 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024541", "2024541", "\u0413\u041e\u041b\u042c\u0426\u041e\u0412\u041a\u0410", "\u0413\u041e\u041b\u042c\u0426\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024936", "2024936", "\u0420\u0417\u0414 71 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 71 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024539", "2024539", "\u0422\u0410\u041d\u0415\u0415\u0412\u041a\u0410", "\u0422\u0410\u041d\u0415\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024935", "2024935", "\u0420\u0417\u0414 54 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 54 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024538", "2024538", "\u0410\u041d\u0423\u0427\u0418\u041d\u041e", "\u0410\u041d\u0423\u0427\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024933", "2024933", "\u0420\u0417\u0414 37 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 37 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024537", "2024537", "\u0411\u0423\u041b\u042b\u0427\u0415\u0412\u041e", "\u0411\u0423\u041b\u042b\u0427\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024536", "2024536", "\u041c\u0415\u0414\u0412\u0415\u0414\u041e\u0412\u041a\u0410", "\u041c\u0415\u0414\u0412\u0415\u0414\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024930", "2024930", "\u0420\u0417\u0414 9 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 9 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024931", "2024931", "\u0420\u0417\u0414 11 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 11 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024986", "2024986", "\u041c\u041e\u041d\u0410\u0421\u0422\u042b\u0420\u0421\u041a", "\u041c\u041e\u041d\u0410\u0421\u0422\u042b\u0420\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024535", "2024535", "\u042f\u041b\u0413\u0410", "\u042f\u041b\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024987", "2024987", "\u041f\u041e\u0421\u041e\u041f", "\u041f\u041e\u0421\u041e\u041f", "\u0419", null);
            RailwayStationsDataProvider.put("2024700", "2024700", "\u0421\u0410\u0420\u0410\u041d\u0421\u041a", "\u0421\u0410\u0420\u0410\u041d\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024988", "2024988", "\u0421\u0410\u0420\u0410\u041d\u0421\u041a 2", "\u0421\u0410\u0420\u0410\u041d\u0421\u041a 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024989", "2024989", "\u041e\u041f 30 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 30 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024534", "2024534", "\u0415\u041b\u041e\u0425\u041e\u0412\u041a\u0410", "\u0415\u041b\u041e\u0425\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024990", "2024990", "\u041e\u041f 43 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 43 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024934", "2024934", "\u0420\u0417\u0414 46 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 46 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024992", "2024992", "\u041e\u041f 52 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 52 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025796", "2025796", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024886", "2024886", "\u041d \u041f\u041e\u041b\u042f\u041d\u041a\u0418", "\u041d\u041e\u0412\u042b\u0415 \u041f\u041e\u041b\u042f\u041d\u041a\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024741", "2024741", "\u0421\u041e\u0411\u041e\u041b\u0415\u041a\u041e\u0412\u041e", "\u0421\u041e\u0411\u041e\u041b\u0415\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024793", "2024793", "\u041d\u0418\u0416\u041d\u0415\u041a\u0410\u041c\u0421\u041a", "\u041d\u0418\u0416\u041d\u0415\u041a\u0410\u041c\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024901", "2024901", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421 \u0413", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a \u0413\u041e\u0420\u041e\u0414", "\u0419", null);
            RailwayStationsDataProvider.put("2024739", "2024739", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2709931", "2709931", "\u0422\u041e\u0413\u0423\u0417\u0410\u041a", "\u0422\u041e\u0413\u0423\u0417\u0410\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2709933", "2709933", "\u0414\u0416\u0410\u0420\u041a\u0423\u041b\u042c", "\u0414\u0416\u0410\u0420\u041a\u0423\u041b\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2708700", "2708700", "\u041a\u0423\u0421\u0422\u0410\u041d\u0410\u0419", "\u041a\u0423\u0421\u0422\u0410\u041d\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2709936", "2709936", "\u0416\u0415\u041b\u0415\u0417\u041e\u0420\u0423\u0414\u041d", "\u0416\u0415\u041b\u0415\u0417\u041e\u0420\u0423\u0414\u041d\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("2708806", "2708806", "\u0423\u0412\u0410\u041b\u042c\u041d\u0415\u041d\u0421\u041a", "\u0423\u0412\u0410\u041b\u042c\u041d\u0415\u041d\u0421\u041a\u0418\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2709980", "2709980", "\u0422\u041e\u0411\u041e\u041b", "\u0422\u041e\u0411\u041e\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("2709942", "2709942", "\u0410\u041c\u0410\u041d\u041a\u0410\u0420\u0413\u0410\u0419", "\u0410\u041c\u0410\u041d\u041a\u0410\u0420\u0410\u0413\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2708945", "2708945", "\u041a\u0423\u0428\u041c\u0423\u0420\u0423\u041d", "\u041a\u0423\u0428\u041c\u0423\u0420\u0423\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2709946", "2709946", "\u041a\u041e\u0419\u0411\u0410\u0413\u0410\u0420", "\u041a\u041e\u0419\u0411\u0410\u0413\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2709950", "2709950", "\u0427\u0415\u041b\u0413\u0410\u0428\u0418", "\u0427\u0415\u041b\u0413\u0410\u0428\u0418", "\u0426", null);
            RailwayStationsDataProvider.put("2708920", "2708920", "\u0415\u0421\u0418\u041b\u042c", "\u0415\u0421\u0418\u041b\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2708890", "2708890", "\u0416\u0410\u041a\u0421\u042b", "\u0416\u0410\u041a\u0421\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2708880", "2708880", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2708910", "2708910", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2708099", "2708099", "\u041e\u0411\u041f N96", "\u041e\u0411\u0413\u041e\u041d\u041d\u042b\u0419 \u041f\u0423\u041d\u041a\u0422 N96", "\u0426", null);
            RailwayStationsDataProvider.put("2708000", "2708000", "\u0410\u0421\u0422\u0410\u041d\u0410", "\u0410\u0421\u0422\u0410\u041d\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2708622", "2708622", "\u0420\u0417\u0414 N1", "\u0420\u0410\u0417'\u0415\u0417\u0414 N1", "\u0426", null);
            RailwayStationsDataProvider.put("2709979", "2709979", "\u0415\u0420\u041c\u0415\u041d\u0422\u0410\u0423", "\u0415\u0420\u041c\u0415\u041d\u0422\u0410\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2708984", "2708984", "\u0428\u0418\u0414\u0415\u0420\u0422\u042b", "\u0428\u0418\u0414\u0415\u0420\u0422\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2708990", "2708990", "\u0415\u041a\u0418\u0411\u0410\u0421\u0422 1", "\u0415\u041a\u0418\u0411\u0410\u0421\u0422\u0423\u0417 1", "\u0426", null);
            RailwayStationsDataProvider.put("2708900", "2708900", "\u041f\u0410\u0412\u041b\u041e\u0414\u0410\u0420", "\u041f\u0410\u0412\u041b\u041e\u0414\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2044855", "2044855", "\u041a\u0423\u041b\u0423\u041d\u0414\u0410", "\u041a\u0423\u041b\u0423\u041d\u0414\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2708634", "2708634", "\u0416\u0410\u041d\u0410\u0422\u0423\u0420\u041c\u042b\u0421", "\u0416\u0410\u041d\u0410\u0422\u0423\u0420\u041c\u042b\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2708866", "2708866", "\u0421\u041c\u0418\u0420\u041d\u041e\u0412\u041e", "\u0421\u041c\u0418\u0420\u041d\u041e\u0412\u041e", "\u0426", null);
            RailwayStationsDataProvider.put("2708635", "2708635", "\u0411\u041e\u0417\u0410\u0420\u0410\u041b", "\u0411\u041e\u0417\u0410\u0420\u0410\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("2708867", "2708867", "\u041a\u0418\u042f\u041b\u042b", "\u041a\u0418\u042f\u041b\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2708086", "2708086", "\u0422\u0415\u041d\u0418\u0417", "\u0422\u0415\u041d\u0418\u0417", "\u0426", null);
            RailwayStationsDataProvider.put("2708870", "2708870", "\u0422\u0410\u0419\u041d\u0427\u0410", "\u0422\u0410\u0419\u041d\u0427\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2708800", "2708800", "\u041a\u041e\u041a\u0428\u0415\u0422\u0410\u0423 1", "\u041a\u041e\u041a\u0428\u0415\u0422\u0410\u0423 1", "\u0426", null);
            RailwayStationsDataProvider.put("2708642", "2708642", "\u0420\u0417\u0414 N17", "\u0420\u0410\u0417'\u0415\u0417\u0414 N17", "\u0426", null);
            RailwayStationsDataProvider.put("2708872", "2708872", "\u0414\u0416\u0415\u041c\u0410\u041d\u0422\u0423\u0417", "\u0414\u0416\u0415\u041c\u0410\u041d\u0422\u0423\u0417", "\u0426", null);
            RailwayStationsDataProvider.put("2708850", "2708850", "\u041a\u0423\u0420\u041e\u0420\u0422 \u0411\u041e\u0420", "\u041a\u0423\u0420\u041e\u0420\u0422-\u0411\u041e\u0420\u041e\u0412\u041e\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2708860", "2708860", "\u041c\u0410\u041a\u0418\u041d\u041a\u0410", "\u041c\u0410\u041a\u0418\u041d\u041a\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2708876", "2708876", "\u0415\u041b\u042c\u0422\u0410\u0419", "\u0415\u041b\u042c\u0422\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2708840", "2708840", "\u0410\u041a \u041a\u0423\u041b\u042c", "\u0410\u041a-\u041a\u0423\u041b\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2708897", "2708897", "\u0428\u041e\u0420\u0422\u0410\u041d\u0414\u042b", "\u0428\u041e\u0420\u0422\u0410\u041d\u0414\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2708655", "2708655", "\u0420\u0417\u0414 N39", "\u0420\u0410\u0417'\u0415\u0417\u0414 N39", "\u0426", null);
            RailwayStationsDataProvider.put("2708865", "2708865", "\u0422\u0420\u041e\u0424\u0418\u041c\u041e\u0412\u041a\u0410", "\u0422\u0420\u041e\u0424\u0418\u041c\u041e\u0412\u041a\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2708970", "2708970", "\u041c\u041e\u0419\u042b\u041d\u0422\u042b", "\u041c\u041e\u0419\u042b\u041d\u0422\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2708921", "2708921", "\u0410\u041a\u0410\u0414\u042b\u0420", "\u0410\u041a\u0410\u0414\u042b\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2708940", "2708940", "\u0416\u0410\u0420\u042b\u041a", "\u0416\u0410\u0420\u042b\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2708950", "2708950", "\u041a\u0410\u0420\u0410\u0413\u0410\u041d\u0414 \u041f", "\u041a\u0410\u0420\u0410\u0413\u0410\u041d\u0414\u042b \u041f\u0410\u0421\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2708928", "2708928", "\u0410\u0421\u0422\u0410\u0425\u041e\u0412\u041a\u0410", "\u0410\u0421\u0422\u0410\u0425\u041e\u0412\u041a\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2708980", "2708980", "\u041e\u0421\u0410\u041a\u0410\u0420\u041e\u0412\u041a\u0410", "\u041e\u0421\u0410\u041a\u0410\u0420\u041e\u0412\u041a\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2704817", "2704817", "\u0411\u0415\u0419\u041d\u0415\u0423", "\u0411\u0415\u0419\u041d\u0415\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2700110", "2700110", "\u041a\u041e\u041a-\u0411\u0415\u041a\u0422\u042b", "\u041a\u041e\u041a-\u0411\u0415\u041a\u0422\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2700111", "2700111", "\u041a\u0417\u042b\u041b-\u0410\u0421\u041a\u0415\u0420", "\u041a\u0417\u042b\u041b-\u0410\u0421\u041a\u0415\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2700113", "2700113", "\u041e\u0410\u0417\u0418\u0421", "\u041e\u0410\u0417\u0418\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2704810", "2704810", "\u0423\u0420\u0410\u041b\u042c\u0421\u041a", "\u0423\u0420\u0410\u041b\u042c\u0421\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2704890", "2704890", "\u041a\u0410\u0417\u0410\u0425\u0421\u0422\u0410\u041d", "\u041a\u0410\u0417\u0410\u0425\u0421\u0422\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2704820", "2704820", "\u0418\u041b\u0415\u0426\u041a 1", "\u0418\u041b\u0415\u0426\u041a 1", "\u0426", null);
            RailwayStationsDataProvider.put("2704850", "2704850", "\u0410\u041a \u0411\u0423\u041b\u0410\u041a", "\u0410\u041a-\u0411\u0423\u041b\u0410\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2704834", "2704834", "\u0416\u0410\u0419\u0421\u0410\u041d", "\u0416\u0410\u0419\u0421\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2705791", "2705791", "\u0420\u0417\u0414 N33", "\u0420\u0410\u0417'\u0415\u0417\u0414 N33", "\u0426", null);
            RailwayStationsDataProvider.put("2704600", "2704600", "\u0410\u041a\u0422\u041e\u0411\u0415", "\u0410\u041a\u0422\u041e\u0411\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2704870", "2704870", "\u041a\u0410\u041d\u0414\u042b\u0410\u0413\u0410\u0428", "\u041a\u0410\u041d\u0414\u042b\u0410\u0413\u0410\u0428", "\u0426", null);
            RailwayStationsDataProvider.put("2704860", "2704860", "\u0416\u0415\u041c", "\u0416\u0415\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705790", "2705790", "\u041a\u0423\u041b\u0410\u041c\u0410", "\u041a\u0423\u041b\u0410\u041c\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2704840", "2704840", "\u0428\u0410\u041b\u041a\u0410\u0420", "\u0428\u0410\u041b\u041a\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2704704", "2704704", "\u0423\u0428\u041a\u0423\u0420\u0410\u0419", "\u0423\u0428\u041a\u0423\u0420\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2704888", "2704888", "\u0421\u0410\u041a\u0421\u0410\u0423\u041b\u042c\u0421\u041a", "\u0421\u0410\u041a\u0421\u0410\u0423\u041b\u042c\u0421\u041a\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("2705804", "2705804", "\u0422\u0415\u0420\u0411\u0415\u041d\u0411\u0415\u0421", "\u0422\u0415\u0420\u0411\u0415\u041d\u0411\u0415\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2704950", "2704950", "\u0410\u0420\u0410\u041b \u041c\u041e\u0420\u0415", "\u0410\u0420\u0410\u041b\u042c\u0421\u041a\u041e\u0415 \u041c\u041e\u0420\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2704910", "2704910", "\u041a\u0410\u0417\u0410\u041b\u0418\u041d\u0421\u041a", "\u041a\u0410\u0417\u0410\u041b\u0418\u041d\u0421\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2705815", "2705815", "\u0415\u041d\u0411\u0415\u041a\u0428\u0418\u041a\u0410\u0417", "\u0415\u041d\u0411\u0415\u041a\u0428\u0418\u041a\u0410\u0417\u0410\u0425", "\u0426", null);
            RailwayStationsDataProvider.put("2705816", "2705816", "\u0422\u0423\u0411\u0415\u041a", "\u0422\u0423\u0411\u0415\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2705817", "2705817", "\u0411\u041e\u0421\u0422\u0410\u041d\u0414\u042b\u041a", "\u0411\u041e\u0421\u0422\u0410\u041d\u0414\u042b\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2704909", "2704909", "\u0410\u041d\u0410 \u041a\u0423\u041b\u042c", "\u0410\u041d\u0410-\u041a\u0423\u041b\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2704916", "2704916", "\u0414\u0416\u0410\u041b\u0410\u0413\u0410\u0428", "\u0414\u0416\u0410\u041b\u0410\u0413\u0410\u0428", "\u0426", null);
            RailwayStationsDataProvider.put("2704999", "2704999", "\u041a\u0417\u042b\u041b \u041e\u0420\u0414\u0410", "\u041a\u0417\u042b\u041b-\u041e\u0420\u0414\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2705828", "2705828", "\u0411\u0423\u0420\u0415\u0411\u0410\u0419", "\u0411\u0423\u0420\u0415\u0411\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2704920", "2704920", "\u0427\u0418\u0418\u041b\u0418", "\u0427\u0418\u0418\u041b\u0418", "\u0426", null);
            RailwayStationsDataProvider.put("2704970", "2704970", "\u042f\u041d\u042b \u041a\u0423\u0420\u0413\u0410\u041d", "\u042f\u041d\u042b-\u041a\u0423\u0420\u0413\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2700860", "2700860", "\u0422\u0423\u0420\u041a\u0415\u0421\u0422\u0410\u041d", "\u0422\u0423\u0420\u041a\u0415\u0421\u0422\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2700680", "2700680", "\u0410\u0420\u042b\u0421\u042c 1", "\u0410\u0420\u042b\u0421\u042c 1", "\u0426", null);
            RailwayStationsDataProvider.put("2700877", "2700877", "\u0410\u0420\u042b\u0421\u042c 2", "\u0410\u0420\u042b\u0421\u042c 2", "\u0426", null);
            RailwayStationsDataProvider.put("2700770", "2700770", "\u0427\u0418\u041c\u041a\u0415\u041d\u0422", "\u0427\u0418\u041c\u041a\u0415\u041d\u0422", "\u0426", null);
            RailwayStationsDataProvider.put("2700880", "2700880", "\u0422\u042e\u041b\u042c\u041a\u0423\u0411\u0410\u0421", "\u0422\u042e\u041b\u042c\u041a\u0423\u0411\u0410\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2700710", "2700710", "\u0414\u0416\u0410\u041c\u0411\u0423\u041b", "\u0414\u0416\u0410\u041c\u0411\u0423\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("2700850", "2700850", "\u041b\u0423\u0413\u041e\u0412\u0410\u042f", "\u041b\u0423\u0413\u041e\u0412\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("2700780", "2700780", "\u0427\u0423", "\u0427\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2700825", "2700825", "\u0411\u0415\u0420\u041b\u0418\u041a 1", "\u0411\u0415\u0420\u041b\u0418\u041a 1", "\u0426", null);
            RailwayStationsDataProvider.put("2700750", "2700750", "\u041e\u0422\u0410\u0420", "\u041e\u0422\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2700002", "2700002", "\u0410\u041b\u041c\u0410 \u0410\u0422\u0410 1", "\u0410\u041b\u041c\u0410-\u0410\u0422\u0410 1", "\u0426", null);
            RailwayStationsDataProvider.put("2700831", "2700831", "\u0427\u0418\u0413\u0410\u041d\u0410\u041a", "\u0427\u0418\u0413\u0410\u041d\u0410\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700917", "2700917", "\u0421\u0410\u0420\u042b \u0428\u0410\u0413\u0410\u041d", "\u0421\u0410\u0420\u042b-\u0428\u0410\u0413\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2700670", "2700670", "\u0410\u041a\u0422\u041e\u0413\u0410\u0419", "\u0410\u041a\u0422\u041e\u0413\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2700104", "2700104", "\u0420\u0417\u0414 6 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 6 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705839", "2705839", "\u0420\u0417\u0414 174 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 174 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705841", "2705841", "\u0420\u0417\u0414 236 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 236 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705842", "2705842", "\u0420\u0417\u0414 265 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 265 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705845", "2705845", "\u0420\u0417\u0414 377 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 377 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2704980", "2704980", "\u041c\u0410\u041a\u0410\u0422", "\u041c\u0410\u041a\u0410\u0422", "\u0426", null);
            RailwayStationsDataProvider.put("2705846", "2705846", "\u0420\u0417\u0414 402 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 402 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705847", "2705847", "\u0420\u0417\u0414 414 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 414 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705848", "2705848", "\u0420\u0417\u0414 441 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 441 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2705861", "2705861", "\u0420\u0417\u0414 496 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 496 \u041a\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2704830", "2704830", "\u0410\u0422\u042b\u0420\u0410\u0423", "\u0410\u0422\u042b\u0420\u0410\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2705864", "2705864", "\u0420\u0417\u0414 N15", "\u0420\u0410\u0417'\u0415\u0417\u0414 N15", "\u0426", null);
            RailwayStationsDataProvider.put("2705866", "2705866", "\u0421\u0410\u0417\u0410\u041d\u041a\u0423\u0420\u0410\u041a", "\u0421\u0410\u0417\u0410\u041d\u041a\u0423\u0420\u0410\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2705867", "2705867", "\u0420\u0417\u0414 N11", "\u0420\u0410\u0417'\u0415\u0417\u0414 N11", "\u0426", null);
            RailwayStationsDataProvider.put("2705868", "2705868", "\u0420\u0417\u0414 N10", "\u0420\u0410\u0417'\u0415\u0417\u0414 N10", "\u0426", null);
            RailwayStationsDataProvider.put("2705869", "2705869", "\u0420\u0417\u0414 N9", "\u0420\u0410\u0417'\u0415\u0417\u0414 N9", "\u0426", null);
            RailwayStationsDataProvider.put("2705870", "2705870", "\u0420\u0417\u0414 N7", "\u0420\u0410\u0417'\u0415\u0417\u0414 N7", "\u0426", null);
            RailwayStationsDataProvider.put("2705871", "2705871", "\u0420\u0417\u0414 N6", "\u0420\u0410\u0417'\u0415\u0417\u0414 N6", "\u0426", null);
            RailwayStationsDataProvider.put("2705849", "2705849", "\u0420\u0417\u0414 N472", "\u0420\u0410\u0417'\u0415\u0417\u0414 N472", "\u0426", null);
            RailwayStationsDataProvider.put("2705850", "2705850", "\u0420\u0417\u0414 N470", "\u0420\u0410\u0417'\u0415\u0417\u0414 N470", "\u0426", null);
            RailwayStationsDataProvider.put("2705851", "2705851", "\u0420\u0417\u0414 N469", "\u0420\u0410\u0417'\u0415\u0417\u0414 N469", "\u0426", null);
            RailwayStationsDataProvider.put("2705852", "2705852", "\u0420\u0417\u0414 N468", "\u0420\u0410\u0417'\u0415\u0417\u0414 N468", "\u0426", null);
            RailwayStationsDataProvider.put("2705853", "2705853", "\u0420\u0417\u0414 N467", "\u0420\u0410\u0417'\u0415\u0417\u0414 N467", "\u0426", null);
            RailwayStationsDataProvider.put("2705854", "2705854", "\u0420\u0417\u0414 N465", "\u0420\u0410\u0417'\u0415\u0417\u0414 N465", "\u0426", null);
            RailwayStationsDataProvider.put("2705855", "2705855", "\u0420\u0417\u0414 N464", "\u0420\u0410\u0417'\u0415\u0417\u0414 N464", "\u0426", null);
            RailwayStationsDataProvider.put("2705856", "2705856", "\u0420\u0417\u0414 N463", "\u0420\u0410\u0417'\u0415\u0417\u0414 N463", "\u0426", null);
            RailwayStationsDataProvider.put("2705857", "2705857", "\u0420\u0417\u0414 N461", "\u0420\u0410\u0417'\u0415\u0417\u0414 N461", "\u0426", null);
            RailwayStationsDataProvider.put("2705881", "2705881", "\u0420\u0417\u0414 N460", "\u0420\u0410\u0417'\u0415\u0417\u0414 N460", "\u0426", null);
            RailwayStationsDataProvider.put("2700891", "2700891", "\u0427\u0415\u041d\u0413\u0415\u041b\u042c\u0414\u042b", "\u0427\u0415\u041d\u0413\u0415\u041b\u042c\u0414\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2700796", "2700796", "\u0421\u0410\u0420\u042b \u041e\u0417\u0415\u041a", "\u0421\u0410\u0420\u042b-\u041e\u0417\u0415\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700792", "2700792", "\u0411\u0410\u0425\u0428\u0410", "\u0411\u0410\u0425\u0428\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2700785", "2700785", "\u041a\u041e\u041a\u0421\u0423", "\u041a\u041e\u041a\u0421\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2700760", "2700760", "\u0423\u0428 \u0422\u041e\u0411\u0415", "\u0423\u0428-\u0422\u041e\u0411\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2700782", "2700782", "\u041a\u0420\u0423\u0428\u0414\u0410\u041b\u0410\u0421\u042b", "\u041a\u0420\u0423\u0428\u0414\u0410\u041b\u0410\u0421\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2700774", "2700774", "\u0410\u041a \u0423\u0417\u042f\u041a", "\u0410\u041a-\u0423\u0417\u042f\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700773", "2700773", "\u041c\u0410\u0422\u0410\u0419", "\u041c\u0410\u0422\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2700690", "2700690", "\u0410\u042f\u0413\u041e\u0417", "\u0410\u042f\u0413\u041e\u0417", "\u0426", null);
            RailwayStationsDataProvider.put("2700722", "2700722", "\u0428\u0410\u0420", "\u0428\u0410\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2700900", "2700900", "\u0421\u0415\u041c\u0418\u041f\u0410\u041b\u0410\u0422", "\u0421\u0415\u041c\u0418\u041f\u0410\u041b\u0410\u0422\u0418\u041d\u0421\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700740", "2700740", "\u041b\u041e\u041a\u041e\u0422\u042c \u0413\u0420", "\u041b\u041e\u041a\u041e\u0422\u042c \u0413\u0420.", "\u0426", null);
            RailwayStationsDataProvider.put("2700672", "2700672", "\u041d\u0415\u0412\u0415\u0420\u041e\u0412\u0421\u041a", "\u041d\u0415\u0412\u0415\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("2700730", "2700730", "\u0417\u0410\u0429\u0418\u0422\u0410", "\u0417\u0410\u0429\u0418\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2700820", "2700820", "\u0417\u042b\u0420\u042f\u041d\u041e\u0412\u0421\u041a", "\u0417\u042b\u0420\u042f\u041d\u041e\u0412\u0421\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700840", "2700840", "\u041b\u0415\u041d\u0418\u041d\u041e\u0413\u041e\u0420\u0421", "\u041b\u0415\u041d\u0418\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700102", "2700102", "\u0410\u041a\u0422\u041e\u0413\u0410\u0419 \u0412", "\u0410\u041a\u0422\u041e\u0413\u0410\u0419 \u0412\u041e\u0421\u0422\u041e\u0427\u041d\u042b\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2700752", "2700752", "\u0420\u0417\u0414 N5", "\u0420\u0410\u0417'\u0415\u0417\u0414 N5", "\u0426", null);
            RailwayStationsDataProvider.put("2700393", "2700393", "\u0414\u041e\u0421\u0422\u042b\u041a", "\u0414\u041e\u0421\u0422\u042b\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2700001", "2700001", "\u0410\u041b\u041c\u0410 \u0410\u0422\u0410 2", "\u0410\u041b\u041c\u0410-\u0410\u0422\u0410 2", "\u0426", null);
            RailwayStationsDataProvider.put("5900898", "5900898", "\u0411\u0418\u0428\u041a\u0415\u041a 1", "\u0411\u0418\u0428\u041a\u0415\u041a 1", "Y", null);
            RailwayStationsDataProvider.put("5900000", "5900000", "\u0411\u0418\u0428\u041a\u0415\u041a 2", "\u0411\u0418\u0428\u041a\u0415\u041a 2", "Y", null);
            RailwayStationsDataProvider.put("5900905", "5900905", "\u0420\u042b\u0411\u0410\u0427\u042c\u0415", "\u0420\u042b\u0411\u0410\u0427\u042c\u0415", "Y", null);
            RailwayStationsDataProvider.put("2900001", "2900001", "\u0422\u0410\u0428\u041a\u0415\u041d\u0422 \u0426", "\u0422\u0410\u0428\u041a\u0415\u041d\u0422 \u041f\u0410\u0421\u0421 \u0426\u0415\u041d\u0422\u0420.", "\u0424", null);
            RailwayStationsDataProvider.put("2900820", "2900820", "\u0425\u0410\u0412\u0410\u0421\u0422", "\u0425\u0410\u0412\u0410\u0421\u0422", "\u0424", null);
            RailwayStationsDataProvider.put("2900720", "2900720", "\u0414\u0416\u0418\u0417\u0410\u041a", "\u0414\u0416\u0418\u0417\u0410\u041a", "\u0424", null);
            RailwayStationsDataProvider.put("2900700", "2900700", "\u0421\u0410\u041c\u0410\u0420\u041a\u0410\u041d\u0414", "\u0421\u0410\u041c\u0410\u0420\u041a\u0410\u041d\u0414", "\u0424", null);
            RailwayStationsDataProvider.put("2900930", "2900930", "\u041d\u0410\u0412\u041e\u0418", "\u041d\u0410\u0412\u041e\u0418", "\u0424", null);
            RailwayStationsDataProvider.put("2900800", "2900800", "\u0411\u0423\u0425\u0410\u0420\u0410 1", "\u0411\u0423\u0425\u0410\u0420\u0410 1", "\u0424", null);
            RailwayStationsDataProvider.put("2900750", "2900750", "\u041a\u0410\u0420\u0428\u0418", "\u041a\u0410\u0420\u0428\u0418", "\u0424", null);
            RailwayStationsDataProvider.put("2900880", "2900880", "\u041a\u041e\u041a\u0410\u041d\u0414 1", "\u041a\u041e\u041a\u0410\u041d\u0414 1", "\u0424", null);
            RailwayStationsDataProvider.put("2900830", "2900830", "\u0425\u041e\u0414\u0416\u0415\u0419\u041b\u0418", "\u0425\u041e\u0414\u0416\u0415\u0419\u041b\u0418", "\u0424", null);
            RailwayStationsDataProvider.put("2900885", "2900885", "\u041a\u0423\u041d\u0413\u0420\u0410\u0414", "\u041a\u0423\u041d\u0413\u0420\u0410\u0414", "\u0424", null);
            RailwayStationsDataProvider.put("2900884", "2900884", "\u0420\u0410\u0423\u0428\u0410\u041d", "\u0420\u0410\u0423\u0428\u0410\u041d", "\u0424", null);
            RailwayStationsDataProvider.put("2900883", "2900883", "\u041a\u0423\u041d\u0425\u041e\u0414\u0416\u0410", "\u041a\u0423\u041d\u0425\u041e\u0414\u0416\u0410", "\u0424", null);
            RailwayStationsDataProvider.put("2900882", "2900882", "\u0410\u0411\u0410\u0414\u0410\u041d", "\u0410\u0411\u0410\u0414\u0410\u041d", "\u0424", null);
            RailwayStationsDataProvider.put("2900740", "2900740", "\u0416\u0410\u0421\u041b\u042b\u041a", "\u0416\u0410\u0421\u041b\u042b\u041a", "\u0424", null);
            RailwayStationsDataProvider.put("2900881", "2900881", "\u0411\u041e\u0421\u0422\u0410\u041d", "\u0411\u041e\u0421\u0422\u0410\u041d", "\u0424", null);
            RailwayStationsDataProvider.put("2900255", "2900255", "\u0422\u0415\u0420\u041c\u0415\u0417", "\u0422\u0415\u0420\u041c\u0415\u0417", "\u0424", null);
            RailwayStationsDataProvider.put("2900721", "2900721", "\u0411\u041e\u0421\u0422\u0410\u041d\u041b\u042b\u041a", "\u0411\u041e\u0421\u0422\u0410\u041d\u041b\u042b\u041a", "\u0424", null);
            RailwayStationsDataProvider.put("2900790", "2900790", "\u0423\u0420\u0413\u0415\u041d\u0427", "\u0423\u0420\u0413\u0415\u041d\u0427", "\u0424", null);
            RailwayStationsDataProvider.put("6600910", "6600910", "\u0425\u0423\u0414\u0416\u0410\u041d\u0414", "\u0425\u0423\u0414\u0416\u0410\u041d\u0414", "N", null);
            RailwayStationsDataProvider.put("6700840", "6700840", "\u0422\u0423\u0420\u041a\u041c\u0415\u041d\u0410\u04111", "\u0422\u0423\u0420\u041a\u041c\u0415\u041d\u0410\u0411\u0410\u0414 1", "U", null);
            RailwayStationsDataProvider.put("6700710", "6700710", "\u0411\u0418\u0420\u0410\u0422\u0410", "\u0411\u0418\u0420\u0410\u0422\u0410", "U", null);
            RailwayStationsDataProvider.put("6700770", "6700770", "\u0414\u0410\u0428\u041e\u0413\u0423\u0417", "\u0414\u0410\u0428\u041e\u0413\u0423\u0417", "U", null);
            RailwayStationsDataProvider.put("6700730", "6700730", "\u041c\u0410\u0420\u042b", "\u041c\u0410\u0420\u042b", "U", null);
            RailwayStationsDataProvider.put("6700279", "6700279", "\u0414\u0423\u0428\u0410\u041a    *", "\u0414\u0423\u0428\u0410\u041a *", "U", null);
            RailwayStationsDataProvider.put("6700000", "6700000", "\u0410\u0428\u0413\u0410\u0411\u0410\u0414", "\u0410\u0428\u0413\u0410\u0411\u0410\u0414", "U", null);
            RailwayStationsDataProvider.put("6700870", "6700870", "\u0421\u0415\u0420\u0414\u0410\u0420", "\u0421\u0415\u0420\u0414\u0410\u0420", "U", null);
            RailwayStationsDataProvider.put("6700950", "6700950", "\u0411\u0410\u041b\u041a\u0410\u041d\u0410\u0411\u0410\u0422", "\u0411\u0410\u041b\u041a\u0410\u041d\u0410\u0411\u0410\u0422", "U", null);
            RailwayStationsDataProvider.put("2030010", "2030010", "\u0412\u0415\u0420\u0415\u0429\u0410\u0413\u0418\u041d\u041e", "\u0412\u0415\u0420\u0415\u0429\u0410\u0413\u0418\u041d\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030005", "2030005", "\u041c\u0415\u041d\u0414\u0415\u041b\u0415\u0415\u0412\u041e", "\u041c\u0415\u041d\u0414\u0415\u041b\u0415\u0415\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030400", "2030400", "\u041f\u0415\u0420\u041c\u042c 2", "\u041f\u0415\u0420\u041c\u042c 2", "\u0415", null);
            RailwayStationsDataProvider.put("2030020", "2030020", "\u041a\u0423\u041d\u0413\u0423\u0420", "\u041a\u0423\u041d\u0413\u0423\u0420", "\u0415", null);
            RailwayStationsDataProvider.put("2030037", "2030037", "\u0428\u0410\u041b\u042f", "\u0428\u0410\u041b\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2030046", "2030046", "\u041f\u0415\u0420\u0412\u041e\u0423\u0420\u0410\u041b", "\u041f\u0415\u0420\u0412\u041e\u0423\u0420\u0410\u041b\u042c\u0421\u041a", "\u0415", null);
            RailwayStationsDataProvider.put("2030000", "2030000", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u0411 \u041f", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u0411\u0423\u0420\u0413-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421", "\u0415", null);
            RailwayStationsDataProvider.put("2030232", "2030232", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u0418\u0427", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u0418\u0427", "\u0415", null);
            RailwayStationsDataProvider.put("2030290", "2030290", "\u041a\u0410\u041c\u042b\u0428\u041b\u041e\u0412", "\u041a\u0410\u041c\u042b\u0428\u041b\u041e\u0412", "\u0415", null);
            RailwayStationsDataProvider.put("2030250", "2030250", "\u0422\u0410\u041b\u0418\u0426\u0410", "\u0422\u0410\u041b\u0418\u0426\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030100", "2030100", "\u0422\u042e\u041c\u0415\u041d\u042c", "\u0422\u042e\u041c\u0415\u041d\u042c", "\u0415", null);
            RailwayStationsDataProvider.put("2031256", "2031256", "\u041e\u041f 2181 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2181 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031282", "2031282", "\u0422\u0423\u0413\u0410\u0420\u0421\u041a\u0418\u0419", "\u0422\u0423\u0413\u0410\u0420\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2031445", "2031445", "\u041a\u0410\u0412\u0414\u042b\u041a", "\u041a\u0410\u0412\u0414\u042b\u041a", "\u0415", null);
            RailwayStationsDataProvider.put("2030263", "2030263", "\u042f\u041b\u0423\u0422\u041e\u0420\u041e\u0412\u0421\u041a", "\u042f\u041b\u0423\u0422\u041e\u0420\u041e\u0412\u0421\u041a", "\u0415", null);
            RailwayStationsDataProvider.put("2030264", "2030264", "\u0417\u0410\u0412\u041e\u0414\u041e\u0423\u041a\u041e\u0412", "\u0417\u0410\u0412\u041e\u0414\u041e\u0423\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2031446", "2031446", "\u0423\u041a\u041e\u0412\u041e", "\u0423\u041a\u041e\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030270", "2030270", "\u0413\u041e\u041b\u042b\u0428\u041c\u0410\u041d\u041e\u0412", "\u0413\u041e\u041b\u042b\u0428\u041c\u0410\u041d\u041e\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030502", "2030502", "\u041e\u041f 2354 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2354 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031211", "2031211", "\u0413\u041b\u0410\u0414\u0418\u041b\u041e\u0412\u041e", "\u0413\u041b\u0410\u0414\u0418\u041b\u041e\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030364", "2030364", "\u041e\u041f\u0415\u041d\u041e\u0412\u041a\u0410", "\u041e\u041f\u0415\u041d\u041e\u0412\u041a\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030280", "2030280", "\u0418\u0428\u0418\u041c", "\u0418\u0428\u0418\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030503", "2030503", "\u041e\u041f 2436 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2436 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030506", "2030506", "\u041e\u041f 2522 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2522 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030507", "2030507", "\u041e\u041f 2546 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2546 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2044990", "2044990", "\u041d\u0410\u0417\u042b\u0412\u0410\u0415\u0412\u0421\u041a", "\u041d\u0410\u0417\u042b\u0412\u0410\u0415\u0412\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2031523", "2031523", "\u0428\u0410\u0414\u0420\u0418\u0425\u0410", "\u0428\u0410\u0414\u0420\u0418\u0425\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030354", "2030354", "\u0410\u0420\u0410\u041a\u0410\u0415\u0412\u041e", "\u0410\u0420\u0410\u041a\u0410\u0415\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2030030", "2030030", "\u0420\u0415\u0412\u0414\u0410", "\u0420\u0415\u0412\u0414\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030071", "2030071", "\u041f\u041e\u041b\u0415\u0412\u0421\u041a\u041e\u0419", "\u041f\u041e\u041b\u0415\u0412\u0421\u041a\u041e\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030510", "2030510", "\u041f\u041e\u0421\u0422 49 \u041a\u041c", "\u041f\u041e\u0421\u0422 49 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030240", "2030240", "\u041a\u0410\u041c\u0415\u041d\u0421\u041a \u0423\u0420", "\u041a\u0410\u041c\u0415\u041d\u0421\u041a-\u0423\u0420\u0410\u041b\u042c\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2031292", "2031292", "\u0422\u0420\u0410\u0412\u042f\u041d\u042b", "\u0422\u0420\u0410\u0412\u042f\u041d\u042b", "\u0415", null);
            RailwayStationsDataProvider.put("2031507", "2031507", "\u0411\u041e\u0415\u0412\u0421\u041a\u0418\u0419", "\u0411\u041e\u0415\u0412\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030428", "2030428", "\u041e\u041f 256 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 256 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030426", "2030426", "\u041e\u041f 262 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 262 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030345", "2030345", "\u041e\u041f 269 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 269 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030324", "2030324", "\u041e\u041f 279 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 279 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030344", "2030344", "\u041e\u041f 281 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 281 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030425", "2030425", "\u041e\u041f 288 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 288 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030427", "2030427", "\u041e\u041f 292 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 292 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031188", "2031188", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031510", "2031510", "\u0411\u0410\u0420\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u0411\u0410\u0420\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2031509", "2031509", "\u041e\u041f 35 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 35 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030398", "2030398", "\u041e\u041f 24 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 24 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030405", "2030405", "\u041e\u041f 28 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 28 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030406", "2030406", "\u041e\u041f 34 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 34 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031228", "2031228", "\u041e\u041f 42 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 42 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030352", "2030352", "\u041e\u041f 47 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 47 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031249", "2031249", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030401", "2030401", "\u041e\u041f 72 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 72 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031266", "2031266", "\u041e\u041f 77 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 77 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031529", "2031529", "\u0428\u041f\u0410\u041b\u042c\u041d\u0410\u042f", "\u0428\u041f\u0410\u041b\u042c\u041d\u0410\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2031252", "2031252", "\u041e\u041f 204 \u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 204 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031530", "2031530", "\u041f\u041b\u042e\u0421\u041d\u0418\u0425\u0410", "\u041f\u041b\u042e\u0421\u041d\u0418\u0425\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2031223", "2031223", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030385", "2030385", "\u041e\u041f 13 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 13 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031191", "2031191", "\u0413\u0420\u0423\u0417\u0414\u0418", "\u0413\u0420\u0423\u0417\u0414\u0418", "\u0415", null);
            RailwayStationsDataProvider.put("2030384", "2030384", "\u041c\u0410\u0425\u041e\u0412\u0410\u0422\u041d\u042f", "\u041c\u0410\u0425\u041e\u0412\u0410\u0422\u041d\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2030383", "2030383", "\u041e\u041f 65 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 65 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030511", "2030511", "\u0412 \u0413\u0423\u0411\u0410\u0425\u0410", "\u0412\u0415\u0420\u0425\u041d\u042f\u042f \u0413\u0423\u0411\u0410\u0425\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030382", "2030382", "\u041d\u0410\u041a\u041b\u041e\u041d\u041d\u042b\u0419", "\u041d\u0410\u041a\u041b\u041e\u041d\u041d\u042b\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030379", "2030379", "\u041e\u041f 116 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 116 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030381", "2030381", "\u041e\u041f 127 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 127 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031197", "2031197", "\u041e\u041f 148 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 148 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030373", "2030373", "\u041e\u041f 174 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 174 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031177", "2031177", "\u041b\u042e\u0417\u0415\u041d\u042c", "\u041b\u042e\u0417\u0415\u041d\u042c", "\u0415", null);
            RailwayStationsDataProvider.put("2031218", "2031218", "\u0414\u0423\u0420\u042b\u041c\u0410\u041d\u042b", "\u0414\u0423\u0420\u042b\u041c\u0410\u041d\u042b", "\u0415", null);
            RailwayStationsDataProvider.put("2031196", "2031196", "\u0427\u0410\u0428\u041a\u0418\u041d\u041e", "\u0427\u0410\u0428\u041a\u0418\u041d\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2031215", "2031215", "\u041e\u041f 20 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 20 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031535", "2031535", "\u041e\u041f 52 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 52 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031534", "2031534", "\u041e\u041f 67 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 67 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031532", "2031532", "\u0420\u0417\u0414 99 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 99 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031284", "2031284", "\u0420\u0417\u0414 136 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 136 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030322", "2030322", "\u041a\u041e\u041f\u0422\u042f\u041a\u0418", "\u041a\u041e\u041f\u0422\u042f\u041a\u0418", "\u0415", null);
            RailwayStationsDataProvider.put("2030366", "2030366", "\u0420\u0417\u0414 160 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 160 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031288", "2031288", "\u041f\u041e\u041f\u0415\u0420\u0415\u0427\u041d\u042b\u0419", "\u041f\u041e\u041f\u0415\u0420\u0415\u0427\u041d\u042b\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030320", "2030320", "\u0421\u0415\u0420\u041e\u0412 \u0417\u0410\u0412", "\u0421\u0415\u0420\u041e\u0412 \u0417\u0410\u0412\u041e\u0414", "\u0415", null);
            RailwayStationsDataProvider.put("2031261", "2031261", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u042f\u0420", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u042f\u0420", "\u0415", null);
            RailwayStationsDataProvider.put("2030333", "2030333", "\u041e\u041f 107 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 107 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030176", "2030176", "\u0418\u0412\u0414\u0415\u041b\u042c 1", "\u0418\u0412\u0414\u0415\u041b\u042c 1", "\u0415", null);
            RailwayStationsDataProvider.put("2031550", "2031550", "\u0423\u041b\u042b\u041c \u0421\u041e\u0421", "\u0423\u041b\u042b\u041c-\u0421\u041e\u0421", "\u0415", null);
            RailwayStationsDataProvider.put("2030165", "2030165", "\u0412\u0415\u0420\u0425\u041d\u0415\u041a\u041e\u041d\u0414", "\u0412\u0415\u0420\u0425\u041d\u0415\u041a\u041e\u041d\u0414\u0418\u041d\u0421\u041a\u0410\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2030526", "2030526", "\u041d\u042f\u0413\u0410\u041d\u042c", "\u041d\u042f\u0413\u0410\u041d\u042c", "\u0415", null);
            RailwayStationsDataProvider.put("2030548", "2030548", "\u0427\u0423\u041b\u042c\u0427\u0410\u041c\u042b", "\u0427\u0423\u041b\u042c\u0427\u0410\u041c\u042b", "\u0415", null);
            RailwayStationsDataProvider.put("2030190", "2030190", "\u0415\u0413\u041e\u0420\u0428\u0418\u041d\u041e", "\u0415\u0413\u041e\u0420\u0428\u0418\u041d\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2031473", "2031473", "\u041e\u041f 152 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 152 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031472", "2031472", "\u041e\u041f 166 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 166 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030513", "2030513", "\u041e\u041f 179 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 179 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031471", "2031471", "\u041e\u041f 185 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 185 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030180", "2030180", "\u0418\u0420\u0411\u0418\u0422", "\u0418\u0420\u0411\u0418\u0422", "\u0415", null);
            RailwayStationsDataProvider.put("2031468", "2031468", "\u041e\u041f 213 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 213 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031466", "2031466", "\u041e\u041f 228 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 228 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030222", "2030222", "\u0422\u0423\u0420\u0418\u041d\u0421\u041a \u0423\u0420", "\u0422\u0423\u0420\u0418\u041d\u0421\u041a-\u0423\u0420\u0410\u041b\u042c\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2031213", "2031213", "\u041e\u041f 260 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422  260 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031465", "2031465", "\u041e\u041f 284 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 284 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030516", "2030516", "\u041e\u041f 309 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 309 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2031307", "2031307", "\u041a\u0410\u0420\u042c\u0415\u0420", "\u041a\u0410\u0420\u042c\u0415\u0420", "\u0415", null);
            RailwayStationsDataProvider.put("2030170", "2030170", "\u0422\u0410\u0412\u0414\u0410", "\u0422\u0410\u0412\u0414\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030422", "2030422", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030517", "2030517", "\u041e\u041f 375 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 375 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030423", "2030423", "\u041a\u0423\u041c\u0410\u041b\u042c\u0421\u041a\u0418\u0419", "\u041a\u0423\u041c\u0410\u041b\u042c\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030217", "2030217", "\u0423\u0421\u0422\u042c\u0415 \u0410\u0425\u0410", "\u0423\u0421\u0422\u042c\u0415-\u0410\u0425\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030432", "2030432", "\u0411\u041f 17 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 17 \u041a\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030284", "2030284", "\u0422\u041e\u0411\u041e\u041b\u042c\u0421\u041a", "\u0422\u041e\u0411\u041e\u041b\u042c\u0421\u041a", "\u0415", null);
            RailwayStationsDataProvider.put("2030307", "2030307", "\u042e\u041d \u041a\u041e\u041c\u0421\u041e\u041c", "\u042e\u041d\u041e\u0421\u0422\u042c-\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u0415", null);
            RailwayStationsDataProvider.put("2030588", "2030588", "\u0414\u0415\u041c\u042c\u042f\u041d\u041a\u0410", "\u0414\u0415\u041c\u042c\u042f\u041d\u041a\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2030606", "2030606", "\u0421\u0410\u041b\u042b\u041c", "\u0421\u0410\u041b\u042b\u041c", "\u0415", null);
            RailwayStationsDataProvider.put("2030597", "2030597", "\u041a\u0423\u0422\u042c \u042f\u0425", "\u041a\u0423\u0422\u042c-\u042f\u0425", "\u0415", null);
            RailwayStationsDataProvider.put("2030607", "2030607", "\u041f\u042b\u0422\u042c \u042f\u0425", "\u041f\u042b\u0422\u042c-\u042f\u0425", "\u0415", null);
            RailwayStationsDataProvider.put("2030600", "2030600", "\u0421\u0423\u0420\u0413\u0423\u0422", "\u0421\u0423\u0420\u0413\u0423\u0422", "\u0415", null);
            RailwayStationsDataProvider.put("2030555", "2030555", "\u0421\u0418\u041b\u0418\u041d\u0421\u041a\u0418\u0419", "\u0421\u0418\u041b\u0418\u041d\u0421\u041a\u0418\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2030640", "2030640", "\u041c\u0415\u0413\u0418\u041e\u041d", "\u041c\u0415\u0413\u0418\u041e\u041d", "\u0415", null);
            RailwayStationsDataProvider.put("2030308", "2030308", "\u041d\u0418\u0416\u041d\u0415\u0412\u0410\u0420 1", "\u041d\u0418\u0416\u041d\u0415\u0412\u0410\u0420\u0422\u041e\u0412\u0421\u041a 1", "\u0415", null);
            RailwayStationsDataProvider.put("2040553", "2040553", "\u041f \u0417\u0410\u0412\u041e\u0414", "\u041f\u041e\u0421\u0422-\u0417\u0410\u0412\u041e\u0414", "\u0423", null);
            RailwayStationsDataProvider.put("2040453", "2040453", "\u0423\u0421\u0422\u042c \u041a\u0410\u0422\u0410\u0412", "\u0423\u0421\u0422\u042c-\u041a\u0410\u0422\u0410\u0412", "\u0423", null);
            RailwayStationsDataProvider.put("2040570", "2040570", "\u0412\u042f\u0417\u041e\u0412\u0410\u042f", "\u0412\u042f\u0417\u041e\u0412\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040560", "2040560", "\u0421\u0423\u041b\u0415\u042f", "\u0421\u0423\u041b\u0415\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040438", "2040438", "\u0411\u0415\u0420\u0414\u042f\u0423\u0428", "\u0411\u0415\u0420\u0414\u042f\u0423\u0428", "\u0423", null);
            RailwayStationsDataProvider.put("2040550", "2040550", "\u0417\u041b\u0410\u0422\u041e\u0423\u0421\u0422", "\u0417\u041b\u0410\u0422\u041e\u0423\u0421\u0422", "\u0423", null);
            RailwayStationsDataProvider.put("2040530", "2040530", "\u041c\u0418\u0410\u0421\u0421 1", "\u041c\u0418\u0410\u0421\u0421 1", "\u0423", null);
            RailwayStationsDataProvider.put("2040425", "2040425", "\u0427\u0415\u0411\u0410\u0420\u041a\u0423\u041b\u042c", "\u0427\u0415\u0411\u0410\u0420\u041a\u0423\u041b\u042c", "\u0423", null);
            RailwayStationsDataProvider.put("2040000", "2040000", "\u0427\u0415\u041b\u042f\u0411\u0418\u041d\u0421\u041a", "\u0427\u0415\u041b\u042f\u0411\u0418\u041d\u0421\u041a-\u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u0423", null);
            RailwayStationsDataProvider.put("2041503", "2041503", "\u0427\u0415\u0421\u041b\u0410\u0412\u041a\u0410", "\u0427\u0415\u0421\u041b\u0410\u0412\u041a\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040457", "2040457", "\u0410\u0417\u042f\u041c", "\u0410\u0417\u042f\u041c", "\u0423", null);
            RailwayStationsDataProvider.put("2040476", "2040476", "\u0410\u0420\u0413\u0410\u042f\u0428", "\u0410\u0420\u0413\u0410\u042f\u0428", "\u0423", null);
            RailwayStationsDataProvider.put("2040610", "2040610", "\u041a\u042b\u0428\u0422\u042b\u041c", "\u041a\u042b\u0428\u0422\u042b\u041c", "\u0423", null);
            RailwayStationsDataProvider.put("2040484", "2040484", "\u0412\u0415\u0420 \u0423\u0424\u0410\u041b\u0415\u0419", "\u0412\u0415\u0420\u0425\u041d\u0418\u0419 \u0423\u0424\u0410\u041b\u0415\u0419", "\u0423", null);
            RailwayStationsDataProvider.put("2040496", "2040496", "\u0429\u0423\u0427\u042c\u0415", "\u0429\u0423\u0427\u042c\u0415", "\u0423", null);
            RailwayStationsDataProvider.put("2040498", "2040498", "\u0428\u0423\u041c\u0418\u0425\u0410", "\u0428\u0423\u041c\u0418\u0425\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040501", "2040501", "\u041c\u0418\u0428\u041a\u0418\u041d\u041e", "\u041c\u0418\u0428\u041a\u0418\u041d\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040503", "2040503", "\u042e\u0420\u0413\u0410\u041c\u042b\u0428", "\u042e\u0420\u0413\u0410\u041c\u042b\u0428", "\u0423", null);
            RailwayStationsDataProvider.put("2040600", "2040600", "\u041a\u0423\u0420\u0413\u0410\u041d", "\u041a\u0423\u0420\u0413\u0410\u041d", "\u0423", null);
            RailwayStationsDataProvider.put("2040524", "2040524", "\u0412\u0410\u0420\u0413\u0410\u0428\u0418", "\u0412\u0410\u0420\u0413\u0410\u0428\u0418", "\u0423", null);
            RailwayStationsDataProvider.put("2040525", "2040525", "\u041b\u0415\u0411 \u0421\u0418\u0411\u0418\u0420", "\u041b\u0415\u0411\u042f\u0416\u042c\u042f-\u0421\u0418\u0411\u0418\u0420\u0421\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040527", "2040527", "\u041c\u0410\u041a\u0423\u0428\u0418\u041d\u041e", "\u041c\u0410\u041a\u0423\u0428\u0418\u041d\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040529", "2040529", "\u041f\u0415\u0422\u0423\u0425\u041e\u0412\u041e", "\u041f\u0415\u0422\u0423\u0425\u041e\u0412\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040532", "2040532", "\u041c\u0410\u041c\u041b\u042e\u0422\u041a\u0410", "\u041c\u0410\u041c\u041b\u042e\u0422\u041a\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040500", "2040500", "\u041f\u0415\u0422\u0420\u041e\u041f\u0410\u0412\u041b", "\u041f\u0415\u0422\u0420\u041e\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040539", "2040539", "\u0411\u0423\u041b\u0410\u0415\u0412\u041e 1", "\u0411\u0423\u041b\u0410\u0415\u0412\u041e 1", "\u0423", null);
            RailwayStationsDataProvider.put("2044920", "2044920", "\u0418\u0421\u0418\u041b\u042c\u041a\u0423\u041b\u042c", "\u0418\u0421\u0418\u041b\u042c\u041a\u0423\u041b\u042c", "\u041d", null);
            RailwayStationsDataProvider.put("2040509", "2040509", "\u041a\u0410\u0422\u0410\u0419\u0421\u041a", "\u041a\u0410\u0422\u0410\u0419\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040511", "2040511", "\u0414\u0410\u041b\u041c\u0410\u0422\u041e\u0412\u041e", "\u0414\u0410\u041b\u041c\u0410\u0422\u041e\u0412\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040620", "2040620", "\u0428\u0410\u0414\u0420\u0418\u041d\u0421\u041a", "\u0428\u0410\u0414\u0420\u0418\u041d\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040518", "2040518", "\u041a\u041e\u0421\u041e\u0411\u0420\u041e\u0414\u0421\u041a", "\u041a\u041e\u0421\u041e\u0411\u0420\u041e\u0414\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2041551", "2041551", "\u041c\u0410\u0420\u041a\u041e\u0412\u041e", "\u041c\u0410\u0420\u041a\u041e\u0412\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040416", "2040416", "\u0415\u041c\u0410\u041d\u0416\u0415\u041b\u0418\u041d\u0421", "\u0415\u041c\u0410\u041d\u0416\u0415\u041b\u0418\u041d\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040430", "2040430", "\u0421\u0410\u0420\u0410\u041a\u0422\u0410\u0428", "\u0421\u0410\u0420\u0410\u041a\u0422\u0410\u0428", "\u0423", null);
            RailwayStationsDataProvider.put("2040440", "2040440", "\u041a\u0423\u0412\u0410\u041d\u0414\u042b\u041a", "\u041a\u0423\u0412\u0410\u041d\u0414\u042b\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040450", "2040450", "\u041c\u0415\u0414\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u041c\u0415\u0414\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040470", "2040470", "\u041d\u0418\u041a\u0415\u041b\u042c", "\u041d\u0418\u041a\u0415\u041b\u042c", "\u0423", null);
            RailwayStationsDataProvider.put("2040480", "2040480", "\u041e\u0420\u0421\u041a", "\u041e\u0420\u0421\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040552", "2040552", "\u0428\u0418\u041b\u042c\u0414\u0410", "\u0428\u0418\u041b\u042c\u0414\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040383", "2040383", "\u0410\u0419\u0414\u042b\u0420\u041b\u042f", "\u0410\u0419\u0414\u042b\u0420\u041b\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040384", "2040384", "\u0411\u0410\u0419\u0422\u0423\u041a", "\u0411\u0410\u0419\u0422\u0423\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040490", "2040490", "\u0411\u0420\u0415\u0414\u042b", "\u0411\u0420\u0415\u0414\u042b", "\u0423", null);
            RailwayStationsDataProvider.put("2040388", "2040388", "\u041a\u0410\u0420\u0422\u0410\u041b\u042b 1", "\u041a\u0410\u0420\u0422\u0410\u041b\u042b 1", "\u0423", null);
            RailwayStationsDataProvider.put("2040404", "2040404", "\u0422\u0410\u041c\u0415\u0420\u041b\u0410\u041d", "\u0422\u0410\u041c\u0415\u0420\u041b\u0410\u041d", "\u0423", null);
            RailwayStationsDataProvider.put("2040406", "2040406", "\u0411\u0423\u0421\u041a\u0423\u041b\u042c", "\u0411\u0423\u0421\u041a\u0423\u041b\u042c", "\u0423", null);
            RailwayStationsDataProvider.put("2040520", "2040520", "\u0422\u0420\u041e\u0418\u0426\u041a", "\u0422\u0420\u041e\u0418\u0426\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040411", "2040411", "\u041d\u0418\u0416\u041d\u0415\u0423\u0412\u0415\u041b", "\u041d\u0418\u0416\u041d\u0415\u0423\u0412\u0415\u041b\u042c\u0421\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2041586", "2041586", "\u041d\u041e\u0412\u0410\u042f \u041f\u041b\u0410\u0422", "\u041d\u041e\u0412\u0410\u042f \u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040551", "2040551", "\u041d\u041e\u0412\u041e\u0410\u0411\u0417\u0410\u041a", "\u041d\u041e\u0412\u041e\u0410\u0411\u0417\u0410\u041a\u041e\u0412\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2040402", "2040402", "\u0423\u0420\u0410\u041b \u0422\u0410\u0423", "\u0423\u0420\u0410\u041b-\u0422\u0410\u0423", "\u0423", null);
            RailwayStationsDataProvider.put("2040510", "2040510", "\u041c\u0410\u0413\u041d\u0418\u0422 \u041f\u0410\u0421", "\u041c\u0410\u0413\u041d\u0418\u0422\u041e\u0413\u041e\u0420\u0421\u041a \u041f\u0410\u0421\u0421", "\u0423", null);
            RailwayStationsDataProvider.put("2040401", "2040401", "\u0421\u0418\u0411\u0410\u0419", "\u0421\u0418\u0411\u0410\u0419", "\u0423", null);
            RailwayStationsDataProvider.put("2040460", "2040460", "\u041d\u041e\u0412\u041e\u0422\u0420\u041e\u0418\u0426\u041a", "\u041d\u041e\u0412\u041e\u0422\u0420\u041e\u0418\u0426\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040344", "2040344", "\u0411\u041e\u0413\u0410\u0422\u041e\u0415", "\u0411\u041e\u0413\u0410\u0422\u041e\u0415", "\u0423", null);
            RailwayStationsDataProvider.put("2040345", "2040345", "\u0417\u0410\u041b\u0418\u0412\u041d\u0410\u042f", "\u0417\u0410\u041b\u0418\u0412\u041d\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040346", "2040346", "\u041d\u0415\u041f\u0420\u0418\u041a", "\u041d\u0415\u041f\u0420\u0418\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040347", "2040347", "\u041a\u041e\u041b\u0422\u0423\u0411\u0410\u041d\u041a\u0410", "\u041a\u041e\u041b\u0422\u0423\u0411\u0410\u041d\u041a\u0410", "\u0423", null);
            RailwayStationsDataProvider.put("2040360", "2040360", "\u0411\u0423\u0417\u0423\u041b\u0423\u041a", "\u0411\u0423\u0417\u0423\u041b\u0423\u041a", "\u0423", null);
            RailwayStationsDataProvider.put("2040349", "2040349", "\u041f\u041e\u0413\u0420\u041e\u041c\u041d\u041e\u0415", "\u041f\u041e\u0413\u0420\u041e\u041c\u041d\u041e\u0415", "\u0423", null);
            RailwayStationsDataProvider.put("2040370", "2040370", "\u0422\u041e\u0426\u041a\u0410\u042f", "\u0422\u041e\u0426\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040380", "2040380", "\u0421\u041e\u0420\u041e\u0427\u0418\u041d\u0421\u041a", "\u0421\u041e\u0420\u041e\u0427\u0418\u041d\u0421\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040390", "2040390", "\u041d\u041e\u0412\u041e\u0421\u0415\u0420\u0413", "\u041d\u041e\u0412\u041e\u0421\u0415\u0420\u0413\u0418\u0415\u0412\u0421\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2042674", "2042674", "\u041e\u041f 1413 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1413 \u041a\u041c", "\u0423", null);
            RailwayStationsDataProvider.put("2040353", "2040353", "\u041f\u0415\u0420\u0415\u0412\u041e\u041b\u041e\u0426\u041a", "\u041f\u0415\u0420\u0415\u0412\u041e\u041b\u041e\u0426\u041a\u0410\u042f", "\u0423", null);
            RailwayStationsDataProvider.put("2040210", "2040210", "\u041e\u0420\u0415\u041d\u0411\u0423\u0420\u0413", "\u041e\u0420\u0415\u041d\u0411\u0423\u0420\u0413", "\u0423", null);
            RailwayStationsDataProvider.put("2041603", "2041603", "\u041e\u0420\u0421\u041a \u0413\u041e\u0420\u041e\u0414", "\u041e\u0420\u0421\u041a \u0413\u041e\u0420\u041e\u0414", "\u0423", null);
            RailwayStationsDataProvider.put("2044677", "2044677", "\u041b\u042e\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u041b\u042e\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044700", "2044700", "\u041e\u041c\u0421\u041a-\u041f\u0410\u0421\u0421", "\u041e\u041c\u0421\u041a-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u041d", null);
            RailwayStationsDataProvider.put("2044740", "2044740", "\u041a\u0410\u041b\u0410\u0427\u0418\u041d\u0421\u041a", "\u041a\u0410\u041b\u0410\u0427\u0418\u041d\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044693", "2044693", "\u041a\u041e\u041b\u041e\u041d\u0418\u042f", "\u041a\u041e\u041b\u041e\u041d\u0418\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044820", "2044820", "\u0422\u0410\u0422\u0410\u0420\u0421\u041a\u0410\u042f", "\u0422\u0410\u0422\u0410\u0420\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044850", "2044850", "\u0427\u0410\u041d\u042b", "\u0427\u0410\u041d\u042b", "\u041d", null);
            RailwayStationsDataProvider.put("2044758", "2044758", "\u041e\u0417 \u041a\u0410\u0420\u0410\u0427\u0418\u041d", "\u041e\u0417\u0415\u0420\u041e-\u041a\u0410\u0420\u0410\u0427\u0418\u041d\u0421\u041a\u041e\u0415", "\u041d", null);
            RailwayStationsDataProvider.put("2044690", "2044690", "\u0411\u0410\u0420\u0410\u0411\u0418\u041d\u0421\u041a", "\u0411\u0410\u0420\u0410\u0411\u0418\u041d\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2044763", "2044763", "\u041a\u041e\u0416\u0423\u0420\u041b\u0410", "\u041a\u041e\u0416\u0423\u0420\u041b\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044840", "2044840", "\u0423\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u0423\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044770", "2044770", "\u041a\u0410\u0420\u0413\u0410\u0422", "\u041a\u0410\u0420\u0413\u0410\u0422", "\u041d", null);
            RailwayStationsDataProvider.put("2044766", "2044766", "\u041a\u041e\u041a\u041e\u0428\u0418\u041d\u041e", "\u041a\u041e\u041a\u041e\u0428\u0418\u041d\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044880", "2044880", "\u0427\u0423\u041b\u042b\u041c\u0421\u041a\u0410\u042f", "\u0427\u0423\u041b\u042b\u041c\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044001", "2044001", "\u041d\u041e\u0412\u041e\u0421\u0418\u0411 \u0413\u041b", "\u041d\u041e\u0412\u041e\u0421\u0418\u0411\u0418\u0420\u0421\u041a-\u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u041d", null);
            RailwayStationsDataProvider.put("2044930", "2044930", "\u0411\u041e\u041b\u041e\u0422\u041d\u0410\u042f", "\u0411\u041e\u041b\u041e\u0422\u041d\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044686", "2044686", "\u041c\u0410\u0420\u0418\u0410\u041d\u041e\u0412\u041a\u0410", "\u041c\u0410\u0420\u0418\u0410\u041d\u041e\u0412\u041a\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044707", "2044707", "\u0412\u0410\u041b\u0418\u0425\u0410\u041d\u041e\u0412\u041e", "\u0412\u0410\u041b\u0418\u0425\u0410\u041d\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044711", "2044711", "\u041c\u042b\u041d\u041a\u0423\u041b\u042c", "\u041c\u042b\u041d\u041a\u0423\u041b\u042c", "\u041d", null);
            RailwayStationsDataProvider.put("2044760", "2044760", "\u041a\u0410\u0420\u0410\u0421\u0423\u041a 1", "\u041a\u0410\u0420\u0410\u0421\u0423\u041a 1", "\u041d", null);
            RailwayStationsDataProvider.put("2044739", "2044739", "\u0417\u0423\u0411\u041a\u041e\u0412\u041e", "\u0417\u0423\u0411\u041a\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044742", "2044742", "\u041a\u0420\u0410\u0421\u041d\u041e\u0417\u0415\u0420\u0421", "\u041a\u0420\u0410\u0421\u041d\u041e\u0417\u0415\u0420\u0421\u041a\u041e\u0415", "\u041d", null);
            RailwayStationsDataProvider.put("2044743", "2044743", "\u0425\u0410\u0411\u0410\u0420\u042b", "\u0425\u0410\u0411\u0410\u0420\u042b", "\u041d", null);
            RailwayStationsDataProvider.put("2044744", "2044744", "\u0423\u0420\u042b\u0412\u0410\u0415\u0412\u041e", "\u0423\u0420\u042b\u0412\u0410\u0415\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044745", "2044745", "\u041f\u0410\u041d\u041a\u0420\u0423\u0428\u0418\u0425\u0410", "\u041f\u0410\u041d\u041a\u0420\u0423\u0428\u0418\u0425\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044746", "2044746", "\u0421\u0412\u0415\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421\u0412\u0415\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044750", "2044750", "\u041a\u0410\u041c \u041d\u0410 \u041e\u0411\u0418", "\u041a\u0410\u041c\u0415\u041d\u042c-\u041d\u0410-\u041e\u0411\u0418", "\u041d", null);
            RailwayStationsDataProvider.put("2044749", "2044749", "\u041f\u041b\u041e\u0422\u0418\u041d\u041d\u0410\u042f", "\u041f\u041b\u041e\u0422\u0418\u041d\u041d\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044980", "2044980", "\u0421\u0423\u0417\u0423\u041d", "\u0421\u0423\u0417\u0423\u041d", "\u041d", null);
            RailwayStationsDataProvider.put("2044870", "2044870", "\u0427\u0418\u0421\u0422\u041e\u041e\u0417\u0415\u0420\u041d", "\u0427\u0418\u0421\u0422\u041e\u041e\u0417\u0415\u0420\u041d\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044780", "2044780", "\u041a\u0423\u041f\u0418\u041d\u041e", "\u041a\u0423\u041f\u0418\u041d\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044725", "2044725", "\u0411\u0410\u0413\u0410\u041d", "\u0411\u0410\u0413\u0410\u041d", "\u041d", null);
            RailwayStationsDataProvider.put("2045843", "2045843", "\u041e\u0417 \u041f\u0420\u0418\u0412\u041e\u041b", "\u041e\u0417\u0415\u0420\u041d\u041e\u0415 \u041f\u0420\u0418\u0412\u041e\u041b\u042c\u0415", "\u041d", null);
            RailwayStationsDataProvider.put("2044732", "2044732", "\u0411\u0423\u0420\u041b\u0410", "\u0411\u0423\u0420\u041b\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044735", "2044735", "\u0421\u041b\u0410\u0412\u0413\u041e\u0420\u041e\u0414", "\u0421\u041b\u0410\u0412\u0413\u041e\u0420\u041e\u0414", "\u041d", null);
            RailwayStationsDataProvider.put("2044737", "2044737", "\u0422\u0410\u0411\u0423\u041d\u042b", "\u0422\u0410\u0411\u0423\u041d\u042b", "\u041d", null);
            RailwayStationsDataProvider.put("2044790", "2044790", "\u041d\u041e\u0412\u041e\u0411\u041b\u0410\u0413\u041e\u0412", "\u041d\u041e\u0412\u041e\u0411\u041b\u0410\u0413\u041e\u0412\u0415\u0429\u0415\u041d\u041a\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044846", "2044846", "\u041b\u0415\u041d\u042c\u041a\u0418", "\u041b\u0415\u041d\u042c\u041a\u0418", "\u041d", null);
            RailwayStationsDataProvider.put("2044950", "2044950", "\u0413\u0418\u041b\u0415\u0412\u041a\u0410", "\u0413\u0418\u041b\u0415\u0412\u041a\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044843", "2044843", "\u041e\u0412\u0415\u0427\u041a\u0418\u041d\u041e", "\u041e\u0412\u0415\u0427\u041a\u0418\u041d\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044841", "2044841", "\u041a\u041e\u0420\u0427\u0418\u041d\u041e", "\u041a\u041e\u0420\u0427\u0418\u041d\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044836", "2044836", "\u0420\u0415\u0411\u0420\u0418\u0425\u0410", "\u0420\u0415\u0411\u0420\u0418\u0425\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044787", "2044787", "\u0421\u0415\u042f\u0422\u0415\u041b\u042c", "\u0421\u0415\u042f\u0422\u0415\u041b\u042c", "\u041d", null);
            RailwayStationsDataProvider.put("2044788", "2044788", "\u0420\u0415\u0427\u041a\u0423\u041d\u041e\u0412\u041a\u0410", "\u0420\u0415\u0427\u041a\u0423\u041d\u041e\u0412\u041a\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044710", "2044710", "\u0411\u0415\u0420\u0414\u0421\u041a", "\u0411\u0415\u0420\u0414\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2044970", "2044970", "\u0418\u0421\u041a\u0418\u0422\u0418\u041c", "\u0418\u0421\u041a\u0418\u0422\u0418\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2044860", "2044860", "\u0427\u0415\u0420\u0415\u041f\u0410\u041d\u041e\u0412\u041e", "\u0427\u0415\u0420\u0415\u041f\u0410\u041d\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044910", "2044910", "\u0423\u0421\u0422\u042c \u0422\u0410\u041b\u042c\u041c", "\u0423\u0421\u0422\u042c-\u0422\u0410\u041b\u042c\u041c\u0415\u041d\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044799", "2044799", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041d", null);
            RailwayStationsDataProvider.put("2044802", "2044802", "\u0410\u041b\u0422\u0410\u0419\u0421\u041a\u0410\u042f", "\u0410\u041b\u0422\u0410\u0419\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044800", "2044800", "\u0411\u0410\u0420\u041d\u0410\u0423\u041b", "\u0411\u0410\u0420\u041d\u0410\u0423\u041b", "\u041d", null);
            RailwayStationsDataProvider.put("2044946", "2044946", "\u041a\u0410\u041b\u041c\u0410\u041d\u041a\u0410", "\u041a\u0410\u041b\u041c\u0410\u041d\u041a\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044861", "2044861", "\u0422\u041e\u041f\u0427\u0418\u0425\u0410", "\u0422\u041e\u041f\u0427\u0418\u0425\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044680", "2044680", "\u0410\u041b\u0415\u0419\u0421\u041a\u0410\u042f", "\u0410\u041b\u0415\u0419\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044890", "2044890", "\u0428\u0418\u041f\u0423\u041d\u041e\u0412\u041e", "\u0428\u0418\u041f\u0423\u041d\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2044865", "2044865", "\u041f\u041e\u0421\u041f\u0415\u041b\u0418\u0425\u0410", "\u041f\u041e\u0421\u041f\u0415\u041b\u0418\u0425\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2044810", "2044810", "\u0420\u0423\u0411\u0426\u041e\u0412\u0421\u041a", "\u0420\u0423\u0411\u0426\u041e\u0412\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2044776", "2044776", "\u0418\u041d\u0421\u041a\u0410\u042f", "\u0418\u041d\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2044786", "2044786", "\u0422\u041e\u0413\u0423\u0427\u0418\u041d", "\u0422\u041e\u0413\u0423\u0427\u0418\u041d", "\u041d", null);
            RailwayStationsDataProvider.put("2045889", "2045889", "\u041e\u041f 15 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 15 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2044918", "2044918", "\u041e\u041f 56 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 56 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2044921", "2044921", "\u041e\u041f 69 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 69 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2044856", "2044856", "\u041d\u0418\u041a\u041e\u041b \u0410\u041b\u0422", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041a\u0410-\u0410\u041b\u0422\u0410\u0419\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2045769", "2045769", "\u041e\u041f 93 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 93 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2044933", "2044933", "\u041a\u0410\u0420\u0410\u0421\u0423\u041a 3", "\u041a\u0410\u0420\u0410\u0421\u0423\u041a 3", "\u041d", null);
            RailwayStationsDataProvider.put("2044953", "2044953", "\u0413\u0410\u0413\u0410\u0420\u042c\u0415", "\u0413\u0410\u0413\u0410\u0420\u042c\u0415", "\u041d", null);
            RailwayStationsDataProvider.put("2044954", "2044954", "\u041d\u041e\u0412\u041e\u0423\u0413\u041b\u041e\u0412\u041a", "\u041d\u041e\u0412\u041e\u0423\u0413\u041b\u041e\u0412\u0421\u041a\u041e\u0415", "\u041d", null);
            RailwayStationsDataProvider.put("2044956", "2044956", "\u0410\u0420\u042b\u041a", "\u0410\u0420\u042b\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2028190", "2028190", "\u042e\u0420\u0413\u0410 1", "\u042e\u0420\u0413\u0410 1", "\u041d", null);
            RailwayStationsDataProvider.put("2028028", "2028028", "\u042f\u0428\u041a\u0418\u041d\u041e", "\u042f\u0428\u041a\u0418\u041d\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2028180", "2028180", "\u0422\u0410\u0419\u0413\u0410", "\u0422\u0410\u0419\u0413\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2028010", "2028010", "\u0410\u041d\u0416\u0415\u0420\u0421\u041a\u0410\u042f", "\u0410\u041d\u0416\u0415\u0420\u0421\u041a\u0410\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2028022", "2028022", "\u042f\u042f", "\u042f\u042f", "\u041d", null);
            RailwayStationsDataProvider.put("2038060", "2038060", "\u041c\u0410\u0420\u0418\u0418\u041d\u0421\u041a", "\u041c\u0410\u0420\u0418\u0418\u041d\u0421\u041a", "\u042b", null);
            RailwayStationsDataProvider.put("2038155", "2038155", "\u0411\u041e\u0413\u041e\u0422\u041e\u041b", "\u0411\u041e\u0413\u041e\u0422\u041e\u041b", "\u042b", null);
            RailwayStationsDataProvider.put("2038210", "2038210", "\u0410\u0427\u0418\u041d\u0421\u041a 1", "\u0410\u0427\u0418\u041d\u0421\u041a 1", "\u042b", null);
            RailwayStationsDataProvider.put("2038001", "2038001", "\u041a\u0420\u0410\u0421\u041d\u041e\u042f\u0420 \u041f", "\u041a\u0420\u0410\u0421\u041d\u041e\u042f\u0420\u0421\u041a \u041f\u0410\u0421\u0421", "\u042b", null);
            RailwayStationsDataProvider.put("2038195", "2038195", "\u0418\u041b\u0410\u041d\u0421\u041a\u0410\u042f", "\u0418\u041b\u0410\u041d\u0421\u041a\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038765", "2038765", "\u041a\u0410\u0421\u041f\u0410", "\u041a\u0410\u0421\u041f\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2054120", "2054120", "\u0422\u0410\u0419\u0428\u0415\u0422", "\u0422\u0410\u0419\u0428\u0415\u0422", "\u0418", null);
            RailwayStationsDataProvider.put("2038723", "2038723", "\u041a\u0415\u041c\u0421\u041a\u0418\u0419", "\u041a\u0415\u041c\u0421\u041a\u0418\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038324", "2038324", "\u0412\u041e\u0420\u041e\u0428\u0418\u041b\u041e\u0412\u041e", "\u0412\u041e\u0420\u041e\u0428\u0418\u041b\u041e\u0412\u041e", "\u042b", null);
            RailwayStationsDataProvider.put("2048090", "2048090", "\u041d\u0415\u0420\u042e\u041d\u0413\u0420 \u041f*", "\u041d\u0415\u0420\u042e\u041d\u0413\u0420\u0418 \u041f\u0410\u0421\u0421.*", "\u042d", null);
            RailwayStationsDataProvider.put("2018011", "2018011", "\u0425\u0410\u0422\u042b\u041c\u0418", "\u0425\u0410\u0422\u042b\u041c\u0418", "\u0422", null);
            RailwayStationsDataProvider.put("2018012", "2018012", "\u0421\u0415\u041b\u0418\u0413\u0414\u0410\u0420", "\u0421\u0415\u041b\u0418\u0413\u0414\u0410\u0420", "\u0422", null);
            RailwayStationsDataProvider.put("2054280", "2054280", "\u0417\u0418\u041c\u0410", "\u0417\u0418\u041c\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054001", "2054001", "\u0418\u0420\u041a\u0423\u0422 \u041f\u0410\u0421\u0421", "\u0418\u0420\u041a\u0423\u0422\u0421\u041a \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054320", "2054320", "\u0421\u041b\u042e\u0414\u042f\u041d\u041a\u0410 1", "\u0421\u041b\u042e\u0414\u042f\u041d\u041a\u0410 1", "\u0418", null);
            RailwayStationsDataProvider.put("2054785", "2054785", "\u0423\u041b\u0410\u041d \u0423\u0414\u042d \u041f", "\u0423\u041b\u0410\u041d-\u0423\u0414\u042d \u041f\u0410\u0421\u0421", "\u0418", null);
            RailwayStationsDataProvider.put("2050410", "2050410", "\u041f\u0415\u0422\u0420 \u0417\u0410\u0412\u041e\u0414", "\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a\u0418\u0419 \u0417\u0410\u0412\u041e\u0414", "\u0427", null);
            RailwayStationsDataProvider.put("2054183", "2054183", "\u041e\u041f 123 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 123 \u041a\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054295", "2054295", "\u0412\u0418\u0425\u041e\u0420\u0415\u0412\u041a\u0410", "\u0412\u0418\u0425\u041e\u0420\u0415\u0412\u041a\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054184", "2054184", "\u041f\u041e\u0414\u0412\u042b\u0415\u0417\u0414\u041d", "\u041f\u041e\u0414\u0412\u042b\u0415\u0417\u0414\u041d\u042b\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054185", "2054185", "\u0421\u0418\u0411\u0418\u0420\u0418\u0428\u041d\u0410\u042f", "\u0421\u0418\u0411\u0418\u0420\u0418\u0428\u041d\u0410\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054186", "2054186", "\u041a\u0410\u0420\u0421\u0422\u041e\u0412\u0410\u042f", "\u041a\u0410\u0420\u0421\u0422\u041e\u0412\u0410\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054187", "2054187", "\u041a\u0410\u0419\u041c\u0410\u041d\u041e\u0412\u041e", "\u041a\u0410\u0419\u041c\u0410\u041d\u041e\u0412\u041e", "\u0418", null);
            RailwayStationsDataProvider.put("2054188", "2054188", "\u041a\u0423\u0422\u0410", "\u041a\u0423\u0422\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054044", "2054044", "\u0427\u0423\u0414\u041d\u0418\u0427\u041d\u042b\u0419", "\u0427\u0423\u0414\u041d\u0418\u0427\u041d\u042b\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054045", "2054045", "\u0417\u0412\u0415\u0417\u0414\u041d\u0410\u042f", "\u0417\u0412\u0415\u0417\u0414\u041d\u0410\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054046", "2054046", "\u041d\u0418\u042f", "\u041d\u0418\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054047", "2054047", "\u041d\u0415\u0411\u0415\u041b\u042c", "\u041d\u0415\u0411\u0415\u041b\u042c", "\u0418", null);
            RailwayStationsDataProvider.put("2054048", "2054048", "\u041a\u0418\u0420\u0415\u041d\u0413\u0410", "\u041a\u0418\u0420\u0415\u041d\u0413\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054049", "2054049", "\u0423\u041b\u042c\u041a\u0410\u041d", "\u0423\u041b\u042c\u041a\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054050", "2054050", "\u041a\u0423\u041d\u0415\u0420\u041c\u0410", "\u041a\u0423\u041d\u0415\u0420\u041c\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054051", "2054051", "\u0414\u0415\u041b\u042c\u0411\u0418\u0427\u0418\u041d\u0414", "\u0414\u0415\u041b\u042c\u0411\u0418\u0427\u0418\u041d\u0414\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054026", "2054026", "\u0414\u0410\u0411\u0410\u041d", "\u0414\u0410\u0411\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054103", "2054103", "\u0413\u041e\u0423\u0414\u0416\u0415\u041a\u0418\u0422", "\u0413\u041e\u0423\u0414\u0416\u0415\u041a\u0418\u0422", "\u0418", null);
            RailwayStationsDataProvider.put("2054104", "2054104", "\u0422\u042b\u042f", "\u0422\u042b\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054052", "2054052", "\u0421\u0415\u0412\u0415\u0420\u041e\u0411\u0410\u0419\u041a", "\u0421\u0415\u0412\u0415\u0420\u041e\u0411\u0410\u0419\u041a\u0410\u041b\u042c\u0421\u041a", "\u0418", null);
            RailwayStationsDataProvider.put("2054105", "2054105", "\u041e\u041f 360 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 360 \u041a\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054106", "2054106", "\u041e\u041f 362 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 362 \u041a\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054107", "2054107", "\u041d\u0418\u0416\u041d\u0415\u0410\u041d\u0413\u0410\u0420", "\u041d\u0418\u0416\u041d\u0415\u0410\u041d\u0413\u0410\u0420\u0421\u041a", "\u0418", null);
            RailwayStationsDataProvider.put("2054108", "2054108", "\u041e\u041f 373 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 373 \u041a\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054109", "2054109", "\u0425\u041e\u041b\u041e\u0414\u041d\u0410\u042f", "\u0425\u041e\u041b\u041e\u0414\u041d\u0410\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054110", "2054110", "\u041a\u0418\u0427\u0415\u0420\u0410", "\u041a\u0418\u0427\u0415\u0420\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054039", "2054039", "\u0414\u0417\u0415\u041b\u0418\u041d\u0414\u0410", "\u0414\u0417\u0415\u041b\u0418\u041d\u0414\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054111", "2054111", "\u041a\u0418\u0420\u041e\u041d", "\u041a\u0418\u0420\u041e\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054112", "2054112", "\u0410\u041d\u0413\u041e\u042f", "\u0410\u041d\u0413\u041e\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054113", "2054113", "\u041e\u0413\u0414\u042b\u041d\u0414\u0410", "\u041e\u0413\u0414\u042b\u041d\u0414\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054114", "2054114", "\u041e\u0413\u041d\u0415\u0419", "\u041e\u0413\u041d\u0415\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054115", "2054115", "\u0410\u041d\u0410\u041c\u0410\u041a\u0418\u0422", "\u0410\u041d\u0410\u041c\u0410\u041a\u0418\u0422", "\u0418", null);
            RailwayStationsDataProvider.put("2055120", "2055120", "\u041d\u041e\u0412 \u0423\u041e\u042f\u041d", "\u041d\u041e\u0412\u042b\u0419 \u0423\u041e\u042f\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054121", "2054121", "\u0411\u0410\u041a\u0410\u041d\u042b", "\u0411\u0410\u041a\u0410\u041d\u042b", "\u0418", null);
            RailwayStationsDataProvider.put("2054122", "2054122", "\u042f\u041d\u0427\u0423\u0419", "\u042f\u041d\u0427\u0423\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054123", "2054123", "\u0427\u0423\u0420\u041e", "\u0427\u0423\u0420\u041e", "\u0418", null);
            RailwayStationsDataProvider.put("2054124", "2054124", "\u041a\u042e\u0425\u0415\u041b\u042c\u0411\u0415\u041a", "\u041a\u042e\u0425\u0415\u041b\u042c\u0411\u0415\u041a\u0415\u0420", "\u0418", null);
            RailwayStationsDataProvider.put("2054125", "2054125", "\u041a\u041e\u0412\u041e\u041a\u0422\u0410", "\u041a\u041e\u0412\u041e\u041a\u0422\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054126", "2054126", "\u0410\u041d\u0413\u0410\u0420\u0410\u041a\u0410\u041d", "\u0410\u041d\u0413\u0410\u0420\u0410\u041a\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054008", "2054008", "\u041a\u0410\u0417\u0410\u041d\u041a\u0410\u041d", "\u041a\u0410\u0417\u0410\u041d\u041a\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054007", "2054007", "\u0421\u0415\u0412\u0415\u0420\u041e\u041c\u0423\u0419\u0421", "\u0421\u0415\u0412\u0415\u0420\u041e\u041c\u0423\u0419\u0421\u041a", "\u0418", null);
            RailwayStationsDataProvider.put("2054006", "2054006", "\u0410\u0420\u041a\u0423\u041c", "\u0410\u0420\u041a\u0423\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054005", "2054005", "\u0423\u041b\u042c\u0413\u0418", "\u0423\u041b\u042c\u0413\u0418", "\u0418", null);
            RailwayStationsDataProvider.put("2054133", "2054133", "\u041c\u0423\u042f\u041a\u0410\u041d", "\u041c\u0423\u042f\u041a\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054132", "2054132", "\u0423\u041b\u0410\u041d\u041c\u0410\u041a\u0418\u0422", "\u0423\u041b\u0410\u041d\u041c\u0410\u041a\u0418\u0422", "\u0418", null);
            RailwayStationsDataProvider.put("2055004", "2055004", "\u041e\u041f 1463 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1463 \u041a\u041c", "\u0418", null);
            RailwayStationsDataProvider.put("2054131", "2054131", "\u0422\u0410\u041a\u0421\u0418\u041c\u041e", "\u0422\u0410\u041a\u0421\u0418\u041c\u041e", "\u0418", null);
            RailwayStationsDataProvider.put("2054138", "2054138", "\u041b\u041e\u0414\u042c\u042f", "\u041b\u041e\u0414\u042c\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054139", "2054139", "\u0410\u041a\u0423", "\u0410\u041a\u0423", "\u0418", null);
            RailwayStationsDataProvider.put("2054129", "2054129", "\u0428\u0418\u0412\u0415\u0420\u042b", "\u0428\u0418\u0412\u0415\u0420\u042b", "\u0418", null);
            RailwayStationsDataProvider.put("2054140", "2054140", "\u041a\u041e\u0419\u0420\u0410", "\u041a\u041e\u0419\u0420\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054128", "2054128", "\u041a\u0423\u0410\u041d\u0414\u0410", "\u041a\u0423\u0410\u041d\u0414\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054141", "2054141", "\u0422\u0410\u041a\u0423", "\u0422\u0410\u041a\u0423", "\u0418", null);
            RailwayStationsDataProvider.put("2054142", "2054142", "\u0411\u0410\u041b\u0411\u0423\u0425\u0422\u0410", "\u0411\u0410\u041b\u0411\u0423\u0425\u0422\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054127", "2054127", "\u0421\u042e\u041b\u042c\u0411\u0410\u041d", "\u0421\u042e\u041b\u042c\u0411\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054119", "2054119", "\u041a\u041e\u0414\u0410\u0420", "\u041a\u041e\u0414\u0410\u0420", "\u0418", null);
            RailwayStationsDataProvider.put("2054118", "2054118", "\u041b\u0415\u041f\u0420\u0418\u041d\u0414\u041e", "\u041b\u0415\u041f\u0420\u0418\u041d\u0414\u041e", "\u0418", null);
            RailwayStationsDataProvider.put("2054102", "2054102", "\u041d\u041e\u0412\u0410\u042f \u0427\u0410\u0420\u0410", "\u041d\u041e\u0412\u0410\u042f \u0427\u0410\u0420\u0410", "\u0418", null);
            RailwayStationsDataProvider.put("2054101", "2054101", "\u041a\u0415\u041c\u0415\u041d", "\u041a\u0415\u041c\u0415\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054099", "2054099", "\u0418\u041a\u0410\u0411\u042c\u042f", "\u0418\u041a\u0410\u0411\u042c\u042f", "\u0418", null);
            RailwayStationsDataProvider.put("2054098", "2054098", "\u0418\u041a\u0410\u0411\u042c\u042f\u041a\u0410\u041d", "\u0418\u041a\u0410\u0411\u042c\u042f\u041a\u0410\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2054097", "2054097", "\u041c\u0423\u0420\u0423\u0420\u0418\u041d", "\u041c\u0423\u0420\u0423\u0420\u0418\u041d", "\u0418", null);
            RailwayStationsDataProvider.put("2048096", "2048096", "\u0425\u0410\u041d\u0418", "\u0425\u0410\u041d\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2054027", "2054027", "\u041e\u0421\u042b\u041f\u041d\u041e\u0419", "\u041e\u0421\u042b\u041f\u041d\u041e\u0419", "\u0418", null);
            RailwayStationsDataProvider.put("2054017", "2054017", "\u041f\u0415\u0420\u0415\u0412\u0410\u041b", "\u041f\u0415\u0420\u0415\u0412\u0410\u041b", "\u0418", null);
            RailwayStationsDataProvider.put("2054009", "2054009", "\u0413\u041e\u0420\u042f\u0427 \u041a\u041b\u042e\u0427", "\u0413\u041e\u0420\u042f\u0427\u0418\u0419 \u041a\u041b\u042e\u0427", "\u0418", null);
            RailwayStationsDataProvider.put("2050498", "2050498", "\u0411\u0410\u0414\u0410", "\u0411\u0410\u0414\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050490", "2050490", "\u0425\u0418\u041b\u041e\u041a", "\u0425\u0418\u041b\u041e\u041a", "\u0427", null);
            RailwayStationsDataProvider.put("2050341", "2050341", "\u041c\u041e\u0413\u0417\u041e\u041d", "\u041c\u041e\u0413\u0417\u041e\u041d", "\u0427", null);
            RailwayStationsDataProvider.put("2050001", "2050001", "\u0427\u0418\u0422\u0410 2", "\u0427\u0418\u0422\u0410 2", "\u0427", null);
            RailwayStationsDataProvider.put("2050480", "2050480", "\u041a\u0410\u0420\u042b\u041c\u0421\u041a\u0410\u042f", "\u041a\u0410\u0420\u042b\u041c\u0421\u041a\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050540", "2050540", "\u0421\u041e\u041b\u041d\u0426\u0415\u0412\u0410\u042f", "\u0421\u041e\u041b\u041d\u0426\u0415\u0412\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050440", "2050440", "\u0428\u0418\u041b\u041a\u0410 \u041f\u0410\u0421\u0421", "\u0428\u0418\u041b\u041a\u0410-\u041f\u0410\u0421\u0421.", "\u0427", null);
            RailwayStationsDataProvider.put("2050390", "2050390", "\u041f\u0420\u0418\u0418\u0421\u041a\u041e\u0412\u0410\u042f", "\u041f\u0420\u0418\u0418\u0421\u041a\u041e\u0412\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050338", "2050338", "\u041a\u0423\u042d\u041d\u0413\u0410", "\u041a\u0423\u042d\u041d\u0413\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050470", "2050470", "\u0427\u0415\u0420\u041d\u042b\u0428 \u0417\u0410\u0411", "\u0427\u0415\u0420\u041d\u042b\u0428\u0415\u0412\u0421\u041a-\u0417\u0410\u0411\u0410\u0419\u041a\u0410\u041b\u042c\u0421\u041a", "\u0427", null);
            RailwayStationsDataProvider.put("2050417", "2050417", "\u0417\u0418\u041b\u041e\u0412\u041e", "\u0417\u0418\u041b\u041e\u0412\u041e", "\u0427", null);
            RailwayStationsDataProvider.put("2050510", "2050510", "\u041c\u041e\u0413\u041e\u0427\u0410", "\u041c\u041e\u0413\u041e\u0427\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050337", "2050337", "\u0415\u0420 \u041f\u0410\u0412\u041b\u041e\u0412", "\u0415\u0420\u041e\u0424\u0415\u0419 \u041f\u0410\u0412\u041b\u041e\u0412\u0418\u0427", "\u0427", null);
            RailwayStationsDataProvider.put("2050335", "2050335", "\u0423\u0420\u0423\u0428\u0410", "\u0423\u0420\u0423\u0428\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050342", "2050342", "\u0422\u0410\u0425\u0422\u0410\u041c\u042b\u0413\u0414\u0410", "\u0422\u0410\u0425\u0422\u0410\u041c\u042b\u0413\u0414\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050346", "2050346", "\u0411\u0410\u041c\u041e\u0412\u0421\u041a\u0410\u042f", "\u0411\u0410\u041c\u041e\u0412\u0421\u041a\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050370", "2050370", "\u0421\u041a\u041e\u0412\u041e\u0420\u041e\u0414\u0418\u041d", "\u0421\u041a\u041e\u0412\u041e\u0420\u041e\u0414\u0418\u041d\u041e", "\u0427", null);
            RailwayStationsDataProvider.put("2050460", "2050460", "\u0411\u041e\u041b \u041d\u0415\u0412\u0415\u0420", "\u0411\u041e\u041b\u042c\u0428\u041e\u0419 \u041d\u0415\u0412\u0415\u0420", "\u0427", null);
            RailwayStationsDataProvider.put("2050333", "2050333", "\u0422\u0410\u041b\u0414\u0410\u041d", "\u0422\u0410\u041b\u0414\u0410\u041d", "\u0427", null);
            RailwayStationsDataProvider.put("2050457", "2050457", "\u0413\u041e\u041d\u0416\u0410", "\u0413\u041e\u041d\u0416\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050430", "2050430", "\u041c\u0410\u0413\u0414\u0410\u0413\u0410\u0427\u0418", "\u041c\u0410\u0413\u0414\u0410\u0413\u0410\u0427\u0418", "\u0427", null);
            RailwayStationsDataProvider.put("2050380", "2050380", "\u0422\u042b\u0413\u0414\u0410", "\u0422\u042b\u0413\u0414\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050332", "2050332", "\u0423\u0428\u0423\u041c\u0423\u041d", "\u0423\u0428\u0423\u041c\u0423\u041d", "\u0427", null);
            RailwayStationsDataProvider.put("2050464", "2050464", "\u0421\u0418\u0412\u0410\u041a\u0418", "\u0421\u0418\u0412\u0410\u041a\u0418", "\u0427", null);
            RailwayStationsDataProvider.put("2050450", "2050450", "\u0428\u0418\u041c\u0410\u041d\u041e\u0412\u0421\u041a", "\u0428\u0418\u041c\u0410\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050340", "2050340", "\u0421\u0412\u041e\u0411\u041e\u0414\u041d\u042b\u0419", "\u0421\u0412\u041e\u0411\u041e\u0414\u041d\u042b\u0419", "\u0427", null);
            RailwayStationsDataProvider.put("2050330", "2050330", "\u0411\u0415\u041b\u041e\u0413\u041e\u0420\u0421\u041a", "\u0411\u0415\u041b\u041e\u0413\u041e\u0420\u0421\u041a", "\u0427", null);
            RailwayStationsDataProvider.put("2050520", "2050520", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0421", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0421\u041b\u0410\u0412\u041a\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050334", "2050334", "\u0417\u0410\u0412\u0418\u0422\u0410\u042f", "\u0417\u0410\u0412\u0418\u0422\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050360", "2050360", "\u0411\u0423\u0420\u0415\u042f", "\u0411\u0423\u0420\u0415\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2034570", "2034570", "\u0410\u0420\u0425\u0410\u0420\u0410", "\u0410\u0420\u0425\u0410\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2050350", "2050350", "\u0411\u041e\u0420\u0417\u042f", "\u0411\u041e\u0420\u0417\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050392", "2050392", "\u0423\u0420\u0423\u041b\u042e\u041d\u0413\u0423\u0419", "\u0423\u0420\u0423\u041b\u042e\u041d\u0413\u0423\u0419", "\u0427", null);
            RailwayStationsDataProvider.put("2050616", "2050616", "\u041f\u0420\u0415\u0414\u0423\u0417\u041b\u041e\u0412", "\u041f\u0420\u0415\u0414\u0423\u0417\u041b\u041e\u0412\u0410\u042f", "\u0427", null);
            RailwayStationsDataProvider.put("2050617", "2050617", "\u041a\u0423\u041f\u0420\u0418\u042f\u041d\u041e\u0412\u041a", "\u041a\u0423\u041f\u0420\u0418\u042f\u041d\u041e\u0412\u041a\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2050000", "2050000", "\u0427\u0418\u0422\u0410", "\u0427\u0418\u0422\u0410", "\u0427", null);
            RailwayStationsDataProvider.put("2034640", "2034640", "\u041e\u0411\u041b\u0423\u0427\u042c\u0415", "\u041e\u0411\u041b\u0423\u0427\u042c\u0415", "\u042d", null);
            RailwayStationsDataProvider.put("2034690", "2034690", "\u0418\u0417\u0412\u0415\u0421\u0422\u041a\u041e\u0412", "\u0418\u0417\u0412\u0415\u0421\u0422\u041a\u041e\u0412\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2034590", "2034590", "\u0411\u0418\u0420\u0410", "\u0411\u0418\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034400", "2034400", "\u0411\u0418\u0420\u041e\u0411\u0418\u0414\u0416\u0410\u041d 1", "\u0411\u0418\u0420\u041e\u0411\u0418\u0414\u0416\u0410\u041d 1", "\u042d", null);
            RailwayStationsDataProvider.put("2034001", "2034001", "\u0425\u0410\u0411\u0410\u0420\u041e\u0412\u0421 1", "\u0425\u0410\u0411\u0410\u0420\u041e\u0412\u0421\u041a 1", "\u042d", null);
            RailwayStationsDataProvider.put("2034610", "2034610", "\u0412\u042f\u0417\u0415\u041c\u0421\u041a\u0410\u042f", "\u0412\u042f\u0417\u0415\u041c\u0421\u041a\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2034580", "2034580", "\u0411\u0418\u041a\u0418\u041d", "\u0411\u0418\u041a\u0418\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034620", "2034620", "\u0414\u0410\u041b\u042c\u041d\u0415\u0420 1", "\u0414\u0410\u041b\u042c\u041d\u0415\u0420\u0415\u0427\u0415\u041d\u0421\u041a 1", "\u042d", null);
            RailwayStationsDataProvider.put("2034650", "2034650", "\u0420\u0423\u0416\u0418\u041d\u041e", "\u0420\u0423\u0416\u0418\u041d\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2034670", "2034670", "\u0421\u041f\u0410\u0421\u0421 \u0414\u0410\u041b", "\u0421\u041f\u0410\u0421\u0421\u041a-\u0414\u0410\u041b\u042c\u041d\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034660", "2034660", "\u0421\u0418\u0411\u0418\u0420\u0426\u0415\u0412\u041e", "\u0421\u0418\u0411\u0418\u0420\u0426\u0415\u0412\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2034605", "2034605", "\u0429\u0423\u041a\u0418\u041d\u041a\u0410", "\u0429\u0423\u041a\u0418\u041d\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034603", "2034603", "\u0411\u0418\u0420\u0423\u0428\u041a\u0410", "\u0411\u0418\u0420\u0423\u0428\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2035633", "2035633", "\u041e\u0422\u041a\u041e\u0421\u041d\u0410\u042f", "\u041e\u0422\u041a\u041e\u0421\u041d\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2035649", "2035649", "\u041f\u041e\u0427\u0415\u041f\u0422\u0410", "\u041f\u041e\u0427\u0415\u041f\u0422\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2035653", "2035653", "\u0420\u0417\u0414 N21", "\u0420\u0410\u0417'\u0415\u0417\u0414 N21", "\u042d", null);
            RailwayStationsDataProvider.put("2035654", "2035654", "\u0420\u0417\u0414 N12", "\u0420\u0410\u0417'\u0415\u0417\u0414 N12", "\u042d", null);
            RailwayStationsDataProvider.put("2034518", "2034518", "\u0422\u0423\u0420\u0418\u0419 \u0420\u041e\u0413", "\u0422\u0423\u0420\u0418\u0419 \u0420\u041e\u0413", "\u042d", null);
            RailwayStationsDataProvider.put("2034078", "2034078", "\u0421\u0418\u041b\u0418\u041d\u041a\u0410", "\u0421\u0418\u041b\u0418\u041d\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048040", "2048040", "\u0428\u0422\u0423\u0420\u041c", "\u0428\u0422\u0423\u0420\u041c", "\u042d", null);
            RailwayStationsDataProvider.put("2048030", "2048030", "\u041c\u0423\u0420\u0422\u042b\u0413\u0418\u0422", "\u041c\u0423\u0420\u0422\u042b\u0413\u0418\u0422", "\u042d", null);
            RailwayStationsDataProvider.put("2048011", "2048011", "\u041f\u0423\u0420\u0418\u041a\u0410\u041d", "\u041f\u0423\u0420\u0418\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048010", "2048010", "\u0410\u041d\u041e\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u0410\u041d\u041e\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2048012", "2048012", "\u0421\u0418\u041b\u0418\u041f", "\u0421\u0418\u041b\u0418\u041f", "\u042d", null);
            RailwayStationsDataProvider.put("2048013", "2048013", "\u0417\u0410\u0411\u041e\u041b\u041e\u0422\u041d\u041e\u0415", "\u0417\u0410\u0411\u041e\u041b\u041e\u0422\u041d\u041e\u0415", "\u042d", null);
            RailwayStationsDataProvider.put("2048020", "2048020", "\u0411\u0415\u041b\u0415\u041d\u042c\u041a\u0410\u042f", "\u0411\u0415\u041b\u0415\u041d\u042c\u041a\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2048014", "2048014", "\u0421\u0415\u0422\u0418", "\u0421\u0415\u0422\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048000", "2048000", "\u0422\u042b\u041d\u0414\u0410", "\u0422\u042b\u041d\u0414\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048015", "2048015", "\u0428\u0410\u0425\u0422\u0410\u0423\u041c", "\u0428\u0410\u0425\u0422\u0410\u0423\u041c", "\u042d", null);
            RailwayStationsDataProvider.put("2048016", "2048016", "\u0411\u0415\u0421\u0422\u0423\u0416\u0415\u0412\u041e", "\u0411\u0415\u0421\u0422\u0423\u0416\u0415\u0412\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048083", "2048083", "\u0413\u0418\u041b\u042e\u0419", "\u0413\u0418\u041b\u042e\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048018", "2048018", "\u041c\u041e\u0413\u041e\u0422", "\u041c\u041e\u0413\u041e\u0422", "\u042d", null);
            RailwayStationsDataProvider.put("2048019", "2048019", "\u042f\u041a\u0423\u0422\u0421\u041a\u0418\u0419", "\u042f\u041a\u0423\u0422\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048025", "2048025", "\u041d\u0410\u0413\u041e\u0420\u041d\u0410\u042f \u042f", "\u041d\u0410\u0413\u041e\u0420\u041d\u0410\u042f \u042f\u041a\u0423\u0422\u0421\u041a\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2048021", "2048021", "\u0410\u042f\u041c", "\u0410\u042f\u041c", "\u042d", null);
            RailwayStationsDataProvider.put("2048022", "2048022", "\u0417\u041e\u041b\u041e\u0422\u0418\u041d\u041a\u0410", "\u0417\u041e\u041b\u041e\u0422\u0418\u041d\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048023", "2048023", "\u041e\u0411\u041e\u0420\u0427\u041e", "\u041e\u0411\u041e\u0420\u0427\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048024", "2048024", "\u0411\u0415\u0420\u041a\u0410\u041a\u0418\u0422", "\u0411\u0415\u0420\u041a\u0410\u041a\u0418\u0422", "\u042d", null);
            RailwayStationsDataProvider.put("2048041", "2048041", "\u0411\u0420\u0423\u0421\u0418\u0422", "\u0411\u0420\u0423\u0421\u0418\u0422", "\u042d", null);
            RailwayStationsDataProvider.put("2048592", "2048592", "\u041a\u0423\u041b\u042c\u0414\u0423\u0420", "\u041a\u0423\u041b\u042c\u0414\u0423\u0420", "\u042d", null);
            RailwayStationsDataProvider.put("2048591", "2048591", "\u041f\u0415\u0420\u0415\u0412\u0410\u041b\u042c\u041d", "\u041f\u0415\u0420\u0415\u0412\u0410\u041b\u042c\u041d\u042b\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048042", "2048042", "\u042f\u0423\u0420\u0418\u041d", "\u042f\u0423\u0420\u0418\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048589", "2048589", "\u0422\u0410\u041b\u0410\u041d\u0414\u0416\u0410", "\u0422\u0410\u041b\u0410\u041d\u0414\u0416\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048588", "2048588", "\u0417\u0418\u041c\u041e\u0412\u042c\u0415", "\u0417\u0418\u041c\u041e\u0412\u042c\u0415", "\u042d", null);
            RailwayStationsDataProvider.put("2048587", "2048587", "\u042d\u0425\u0418\u041b\u041a\u0410\u041d", "\u042d\u0425\u0418\u041b\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048586", "2048586", "\u0410\u041b\u0410\u041d\u0410\u041f", "\u0410\u041b\u0410\u041d\u0410\u041f", "\u042d", null);
            RailwayStationsDataProvider.put("2048585", "2048585", "\u0422\u042b\u0420\u041c\u0410", "\u0422\u042b\u0420\u041c\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048584", "2048584", "\u041c\u041e\u0428\u041a\u0410", "\u041c\u041e\u0428\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048583", "2048583", "\u0421\u041e\u0413\u0414\u0410", "\u0421\u041e\u0413\u0414\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048582", "2048582", "\u0423\u0428\u041c\u0410\u041d", "\u0423\u0428\u041c\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048581", "2048581", "\u042f\u0413\u0414\u042b\u041d\u042c\u042f", "\u042f\u0413\u0414\u042b\u041d\u042c\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2048579", "2048579", "\u042d\u041b\u042c\u0413\u0410", "\u042d\u041b\u042c\u0413\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048710", "2048710", "\u041d\u041e\u0412 \u0423\u0420\u0413\u0410\u041b", "\u041d\u041e\u0412\u042b\u0419 \u0423\u0420\u0413\u0410\u041b", "\u042d", null);
            RailwayStationsDataProvider.put("2048578", "2048578", "\u0423\u0420\u0413\u0410\u041b 1", "\u0423\u0420\u0413\u0410\u041b 1", "\u042d", null);
            RailwayStationsDataProvider.put("2048760", "2048760", "\u0427\u0415\u0413\u0414\u041e\u041c\u042b\u041d", "\u0427\u0415\u0413\u0414\u041e\u041c\u042b\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048077", "2048077", "\u0425\u0410\u041b\u042c\u0413\u0410\u0421\u041e", "\u0425\u0410\u041b\u042c\u0413\u0410\u0421\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048076", "2048076", "\u041b\u0418\u0410\u041d", "\u041b\u0418\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048069", "2048069", "\u0425\u0423\u0420\u041c\u0423\u041b\u0418", "\u0425\u0423\u0420\u041c\u0423\u041b\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048075", "2048075", "\u041c\u0410\u0412\u0420\u0418\u041d\u0421\u041a\u0418\u0419", "\u041c\u0410\u0412\u0420\u0418\u041d\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048074", "2048074", "\u0413\u041e\u0420\u0418\u041d", "\u0413\u041e\u0420\u0418\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048073", "2048073", "\u0425\u0410\u0420\u041f\u0418\u0427\u0410\u041d", "\u0425\u0410\u0420\u041f\u0418\u0427\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048072", "2048072", "\u042d\u0412\u041e\u0420\u041e\u041d", "\u042d\u0412\u041e\u0420\u041e\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048071", "2048071", "\u041c\u041e\u041d\u0418", "\u041c\u041e\u041d\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048070", "2048070", "\u0411\u041e\u041b\u0415\u041d", "\u0411\u041e\u041b\u0415\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048068", "2048068", "\u041f\u041e\u0421\u0422\u042b\u0428\u0415\u0412\u041e", "\u041f\u041e\u0421\u0422\u042b\u0428\u0415\u0412\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048067", "2048067", "\u042d\u0411\u0413\u0423\u041d\u042c", "\u042d\u0411\u0413\u0423\u041d\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2048066", "2048066", "\u0421\u041e\u041d\u0410\u0425", "\u0421\u041e\u041d\u0410\u0425", "\u042d", null);
            RailwayStationsDataProvider.put("2048065", "2048065", "\u0410\u041c\u0413\u0423\u041d\u042c", "\u0410\u041c\u0413\u0423\u041d\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2048064", "2048064", "\u042d\u0410\u041d\u0413\u0410", "\u042d\u0410\u041d\u0413\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048063", "2048063", "\u0414\u0416\u0410\u041c\u041a\u0423", "\u0414\u0416\u0410\u041c\u041a\u0423", "\u042d", null);
            RailwayStationsDataProvider.put("2048062", "2048062", "\u0423\u0420\u041a\u0410\u041b\u042c\u0422\u0423", "\u0423\u0420\u041a\u0410\u041b\u042c\u0422\u0423", "\u042d", null);
            RailwayStationsDataProvider.put("2048061", "2048061", "\u0413\u0415\u0420\u0411\u0418", "\u0413\u0415\u0420\u0411\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048084", "2048084", "\u041e\u0420\u041e\u041a\u041e\u0422", "\u041e\u0420\u041e\u041a\u041e\u0422", "\u042d", null);
            RailwayStationsDataProvider.put("2048060", "2048060", "\u041c\u041e\u0413\u0414\u042b", "\u041c\u041e\u0413\u0414\u042b", "\u042d", null);
            RailwayStationsDataProvider.put("2048059", "2048059", "\u0421\u0423\u041b\u0423\u041a", "\u0421\u0423\u041b\u0423\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048058", "2048058", "\u0414\u0423\u0421\u0421\u0415 \u0410\u041b\u0418\u041d", "\u0414\u0423\u0421\u0421\u0415-\u0410\u041b\u0418\u041d\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2048057", "2048057", "\u041d\u0410\u041b\u042c\u0414\u042b", "\u041d\u0410\u041b\u042c\u0414\u042b", "\u042d", null);
            RailwayStationsDataProvider.put("2048056", "2048056", "\u0421\u041e\u041b\u041e\u041d\u0418", "\u0421\u041e\u041b\u041e\u041d\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048055", "2048055", "\u041c\u0423\u041a\u0423\u041d\u0413\u0410", "\u041c\u0423\u041a\u0423\u041d\u0413\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048054", "2048054", "\u041c\u0423\u0413\u0423\u041b\u0415", "\u041c\u0423\u0413\u0423\u041b\u0415", "\u042d", null);
            RailwayStationsDataProvider.put("2048053", "2048053", "\u0427\u0415\u041c\u0427\u0423\u041a\u041e", "\u0427\u0415\u041c\u0427\u0423\u041a\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048095", "2048095", "\u041e\u041b\u0415\u041a\u041c\u0410", "\u041e\u041b\u0415\u041a\u041c\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048143", "2048143", "\u0422\u0410\u0421\u0421 \u042e\u0420\u042f\u0425", "\u0422\u0410\u0421\u0421-\u042e\u0420\u042f\u0425", "\u042d", null);
            RailwayStationsDataProvider.put("2048094", "2048094", "\u042e\u041a\u0422\u0410\u041b\u0418", "\u042e\u041a\u0422\u0410\u041b\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048093", "2048093", "\u0414\u042e\u0413\u0410\u0411\u0423\u041b\u042c", "\u0414\u042e\u0413\u0410\u0411\u0423\u041b\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2048092", "2048092", "\u0427\u0418\u041b\u042c\u0427\u0418", "\u0427\u0418\u041b\u042c\u0427\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048028", "2048028", "\u041b\u041e\u041f\u0427\u0410", "\u041b\u041e\u041f\u0427\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048091", "2048091", "\u042d\u041b\u042c\u0413\u0410\u041a\u0410\u041d", "\u042d\u041b\u042c\u0413\u0410\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048089", "2048089", "\u041b\u0410\u0420\u0411\u0410", "\u041b\u0410\u0420\u0411\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048088", "2048088", "\u041b\u0423\u041c\u0411\u0418\u0420", "\u041b\u0423\u041c\u0411\u0418\u0420", "\u042d", null);
            RailwayStationsDataProvider.put("2048087", "2048087", "\u0425\u041e\u0420\u041e\u0413\u041e\u0427\u0418", "\u0425\u041e\u0420\u041e\u0413\u041e\u0427\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2048085", "2048085", "\u041a\u0423\u0412\u042b\u041a\u0422\u0410", "\u041a\u0423\u0412\u042b\u041a\u0422\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048086", "2048086", "\u0411\u0423\u0420\u0415\u0418\u041d\u0421\u041a", "\u0411\u0423\u0420\u0415\u0418\u041d\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048101", "2048101", "\u0427\u0410\u0411\u042b\u0413\u0414\u0410", "\u0427\u0410\u0411\u042b\u0413\u0414\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048100", "2048100", "\u041a\u042b\u0427\u042b\u0420\u0410\u041d\u041a\u042b", "\u041a\u042b\u0427\u042b\u0420\u0410\u041d\u041a\u042b", "\u042d", null);
            RailwayStationsDataProvider.put("2048001", "2048001", "\u0410\u041b\u041e\u041d\u041a\u0410", "\u0410\u041b\u041e\u041d\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048044", "2048044", "\u0421\u0422\u041b\u0410\u041d\u041d\u0418\u041a", "\u0421\u0422\u041b\u0410\u041d\u041d\u0418\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048043", "2048043", "\u0422\u0423\u042e\u041d", "\u0422\u0423\u042e\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048039", "2048039", "\u0428\u0423\u0413\u0410\u0420\u0410", "\u0428\u0423\u0413\u0410\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048027", "2048027", "\u0410\u041c\u0413\u0410\u041d", "\u0410\u041c\u0413\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048002", "2048002", "\u042d\u0422\u042b\u0420\u041a\u042d\u041d", "\u042d\u0422\u042b\u0420\u041a\u042d\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048026", "2048026", "\u0423\u041b\u042c\u041c\u0410", "\u0423\u041b\u042c\u041c\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048017", "2048017", "\u041c\u0423\u0421\u0422\u0410\u041a", "\u041c\u0423\u0421\u0422\u0410\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048038", "2048038", "\u0413\u0412\u041e\u0417\u0414\u0415\u0412\u0421\u041a", "\u0413\u0412\u041e\u0417\u0414\u0415\u0412\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048003", "2048003", "\u0418\u0421\u0410", "\u0418\u0421\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048009", "2048009", "\u0418\u0421\u0410\u041a\u0410\u041d", "\u0418\u0421\u0410\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048008", "2048008", "\u0414\u0415\u041c\u0427\u0415\u041d\u041a\u041e", "\u0414\u0415\u041c\u0427\u0415\u041d\u041a\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048007", "2048007", "\u0417\u0412\u041e\u041d\u041a\u041e\u0415", "\u0417\u0412\u041e\u041d\u041a\u041e\u0415", "\u042d", null);
            RailwayStationsDataProvider.put("2048029", "2048029", "\u0424\u0415\u0412\u0420\u0410\u041b\u042c\u0421\u041a", "\u0424\u0415\u0412\u0420\u0410\u041b\u042c\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048006", "2048006", "\u0427\u0415\u0420\u0412\u0418\u041d\u041a\u0410", "\u0427\u0415\u0420\u0412\u0418\u041d\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048005", "2048005", "\u0421\u041a\u0410\u041b\u0418\u0421\u0422\u042b\u0419", "\u0421\u041a\u0410\u041b\u0418\u0421\u0422\u042b\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048135", "2048135", "\u0414\u0420\u041e\u0413\u041e\u0428\u0415\u0412\u0421\u041a", "\u0414\u0420\u041e\u0413\u041e\u0428\u0415\u0412\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048004", "2048004", "\u041c\u0415\u0423\u041d", "\u041c\u0415\u0423\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048149", "2048149", "\u041d\u041e\u0420\u0410", "\u041d\u041e\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048136", "2048136", "\u0414\u0423\u0413\u0414\u0410", "\u0414\u0423\u0413\u0414\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048148", "2048148", "\u0422\u0410\u041d\u0413\u041e\u041c\u0415\u041d", "\u0422\u0410\u041d\u0413\u041e\u041c\u0415\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048147", "2048147", "\u041a\u0410\u041c\u041d\u0415\u0413\u0410", "\u041a\u0410\u041c\u041d\u0415\u0413\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048137", "2048137", "\u0422\u0423\u041d\u0413\u0410\u041b\u0410", "\u0422\u0423\u041d\u0413\u0410\u041b\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048037", "2048037", "\u041c\u0418\u0420\u041e\u0428\u041d\u0418\u0427\u0415\u041d", "\u041c\u0418\u0420\u041e\u0428\u041d\u0418\u0427\u0415\u041d\u041a\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2048036", "2048036", "\u0423\u041b\u0410\u0413\u0418\u0420", "\u0423\u041b\u0410\u0413\u0418\u0420", "\u042d", null);
            RailwayStationsDataProvider.put("2048035", "2048035", "\u041c\u041e\u041b\u0414\u0410\u0412\u0421\u041a\u0418\u0419", "\u041c\u041e\u041b\u0414\u0410\u0412\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2048034", "2048034", "\u041e\u0413\u041e\u0420\u041e\u041d", "\u041e\u0413\u041e\u0420\u041e\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048033", "2048033", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412 \u0421\u0422", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a\u0418\u0419 \u0421\u0422\u0420\u041e\u0418\u0422\u0415\u041b\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2048032", "2048032", "\u0418\u0416\u0410\u041a", "\u0418\u0416\u0410\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048031", "2048031", "\u0410\u041f\u0415\u0422\u0415\u041d\u041e\u041a", "\u0410\u041f\u0415\u0422\u0415\u041d\u041e\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048130", "2048130", "\u0412\u0415\u0420\u0425\u041d\u0415\u0417\u0415\u0419\u0421", "\u0412\u0415\u0420\u0425\u041d\u0415\u0417\u0415\u0419\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2048117", "2048117", "\u0422\u0423\u0422\u0410\u0423\u041b", "\u0422\u0423\u0422\u0410\u0423\u041b", "\u042d", null);
            RailwayStationsDataProvider.put("2048116", "2048116", "\u0414\u0415\u0421\u0421", "\u0414\u0415\u0421\u0421", "\u042d", null);
            RailwayStationsDataProvider.put("2048079", "2048079", "\u0414\u0418\u041f\u041a\u0423\u041d", "\u0414\u0418\u041f\u041a\u0423\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048082", "2048082", "\u0423\u041d\u0410\u0425\u0410", "\u0423\u041d\u0410\u0425\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048081", "2048081", "\u041c\u0410\u0420\u0415\u0412\u0410\u042f", "\u041c\u0410\u0420\u0415\u0412\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2048141", "2048141", "\u0414\u0416\u0415\u041b\u0418\u041d\u0413\u0420\u0410", "\u0414\u0416\u0415\u041b\u0418\u041d\u0413\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034000", "2034000", "\u0425\u0410\u0411\u0410\u0420\u041e\u0412\u0421\u041a", "\u0425\u0410\u0411\u0410\u0420\u041e\u0412\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2068465", "2068465", "\u0421\u041e\u0412\u0415\u0422\u0421\u041a\u041e\u0415", "\u0421\u041e\u0412\u0415\u0422\u0421\u041a\u041e\u0415", "G", null);
            RailwayStationsDataProvider.put("2068478", "2068478", "\u0422\u0423\u041c\u0410\u041d\u041e\u0412\u041e", "\u0422\u0423\u041c\u0410\u041d\u041e\u0412\u041e", "G", null);
            RailwayStationsDataProvider.put("2068454", "2068454", "\u0410\u0414\u041e \u0422\u042b\u041c\u041e\u0412\u041e", "\u0410\u0414\u041e-\u0422\u042b\u041c\u041e\u0412\u041e", "G", null);
            RailwayStationsDataProvider.put("2500410", "2500410", "\u0414\u0410\u0423\u0413\u0410\u0412 \u041f\u0410\u0421", "\u0414\u0410\u0423\u0413\u0410\u0412\u041f\u0418\u041b\u0421-\u041f\u0410\u0421\u0421", "R", null);
            RailwayStationsDataProvider.put("2100195", "2100195", "\u0420\u0415\u0427\u0418\u0426\u0410", "\u0420\u0415\u0427\u0418\u0426\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100837", "2100837", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2200013", "2200013", "\u0422\u0415\u0420\u0415\u0429\u0415\u041d\u0421\u041a", "\u0422\u0415\u0420\u0415\u0429\u0415\u041d\u0421\u041a\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2200242", "2200242", "\u0413\u041d\u0418\u0412\u0410\u041d\u042c", "\u0413\u041d\u0418\u0412\u0410\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200130", "2200130", "\u041d\u041e\u0412\u041e\u0413\u0420 \u0412 1", "\u041d\u041e\u0412\u041e\u0413\u0420\u0410\u0414-\u0412\u041e\u041b\u042b\u041d\u0421\u041a\u0418\u0419 1", "\u041a", null);
            RailwayStationsDataProvider.put("2200238", "2200238", "\u0412\u0418\u041a\u0422\u041e\u0420\u0418\u042f", "\u0412\u0418\u041a\u0422\u041e\u0420\u0418\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2218202", "2218202", "\u0413\u041e\u0414\u042b \u0422\u0423\u0420\u041a\u0410", "\u0413\u041e\u0414\u042b-\u0422\u0423\u0420\u041a\u0410", "\u041b", null);
            RailwayStationsDataProvider.put("2218207", "2218207", "\u0415\u0417\u0423\u041f\u041e\u041b\u042c", "\u0415\u0417\u0423\u041f\u041e\u041b\u042c", "\u041b", null);
            RailwayStationsDataProvider.put("2218445", "2218445", "\u0411\u0423\u041a\u0410\u0427\u0415\u0412\u0426\u042b", "\u0411\u0423\u041a\u0410\u0427\u0415\u0412\u0426\u042b", "\u041b", null);
            RailwayStationsDataProvider.put("2208455", "2208455", "\u041f\u0415\u0420\u0415\u041a\u0420\u0415\u0421\u0422", "\u041f\u0415\u0420\u0415\u041a\u0420\u0415\u0421\u0422\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208395", "2208395", "\u0422\u0420\u0415\u041f\u041e\u0412\u041a\u0410", "\u0422\u0420\u0415\u041f\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208421", "2208421", "\u0411\u0410\u041d\u0414\u0423\u0420\u041a\u0410", "\u0411\u0410\u041d\u0414\u0423\u0420\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208447", "2208447", "\u0416\u0415\u0420\u0415\u0411\u041a\u041e\u0412\u041e", "\u0416\u0415\u0420\u0415\u0411\u041a\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208538", "2208538", "\u041a\u041e\u0422\u041b\u042f\u0420\u041e\u0412\u041e", "\u041a\u041e\u0422\u041b\u042f\u0420\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208489", "2208489", "\u041a\u0410\u041d\u0422\u0415\u041c\u0418\u0420", "\u041a\u0410\u041d\u0422\u0415\u041c\u0418\u0420", "\u0428", null);
            RailwayStationsDataProvider.put("2204536", "2204536", "\u0411\u041b\u041e\u0422\u041d\u0418\u0426\u0410", "\u0411\u041b\u041e\u0422\u041d\u0418\u0426\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2214480", "2214480", "\u041c\u041e\u0421\u041f\u0418\u041d\u041e", "\u041c\u041e\u0421\u041f\u0418\u041d\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("2214009", "2214009", "\u041f\u0420\u041e\u0421\u042f\u041d\u0410\u042f", "\u041f\u0420\u041e\u0421\u042f\u041d\u0410\u042f", "\u0414", null);
            RailwayStationsDataProvider.put("2214011", "2214011", "\u0414\u0415\u041c\u0423\u0420\u0418\u041d\u041e", "\u0414\u0415\u041c\u0423\u0420\u0418\u041d\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("2214013", "2214013", "\u041c\u0415\u0416\u0415\u0412\u0410\u042f", "\u041c\u0415\u0416\u0415\u0412\u0410\u042f", "\u0414", null);
            RailwayStationsDataProvider.put("2214275", "2214275", "\u0421\u0410\u0420\u0422\u0410\u041d\u0410", "\u0421\u0410\u0420\u0422\u0410\u041d\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2215239", "2215239", "\u041c\u0423\u0428\u041a\u0415\u0422\u041e\u0412\u041e", "\u041c\u0423\u0428\u041a\u0415\u0422\u041e\u0412\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("2214521", "2214521", "\u0421\u0415\u041b\u0418\u0414\u041e\u0412\u041a\u0410", "\u0421\u0415\u041b\u0418\u0414\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214222", "2214222", "\u0426\u0423\u041a\u0423\u0420\u0418\u0425\u0410", "\u0426\u0423\u041a\u0423\u0420\u0418\u0425\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214506", "2214506", "\u0420\u041e\u042f", "\u0420\u041e\u042f", "\u0414", null);
            RailwayStationsDataProvider.put("2215227", "2215227", "\u041e\u0421\u0422\u0420\u042b\u0419", "\u041e\u0421\u0422\u0420\u042b\u0419", "\u0414", null);
            RailwayStationsDataProvider.put("2214530", "2214530", "\u041a\u0420\u0410\u0421\u041d\u041e\u0413\u041e\u0420", "\u041a\u0420\u0410\u0421\u041d\u041e\u0413\u041e\u0420\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2020844", "2020844", "\u0413\u041d\u0418\u041b\u041e\u0410\u041a\u0421", "\u0413\u041d\u0418\u041b\u041e\u0410\u041a\u0421\u0410\u0419\u0421\u041a\u0410\u042f", "\u0416", null);
            RailwayStationsDataProvider.put("2708933", "2708933", "\u0420\u0417\u0414 N33", "\u0420\u0410\u0417'\u0415\u0417\u0414 N33", "\u0426", null);
            RailwayStationsDataProvider.put("2028099", "2028099", "\u0421\u041f\u0418\u0427\u0415\u041d\u041a\u041e\u0412\u041e", "\u0421\u041f\u0418\u0427\u0415\u041d\u041a\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2054165", "2054165", "\u041d\u0410\u0423\u0428\u041a\u0418 *", "\u041d\u0410\u0423\u0428\u041a\u0418 *", "\u0418", null);
            RailwayStationsDataProvider.put("5100206", "5100206", "\u0429\u0415\u0426\u0418\u041d \u0414\u0410\u0411\u0418", "\u0429\u0415\u0426\u0418\u041d \u0414\u0410\u0411\u0418", "W", null);
            RailwayStationsDataProvider.put("5100119", "5100119", "\u0429\u0415\u0426\u0418\u041d \u0413\u041b", "\u0429\u0415\u0426\u0418\u041d \u0413\u041b", "W", null);
            RailwayStationsDataProvider.put("5100207", "5100207", "\u0429\u0415\u0426\u0418\u041d \u0413\u0423\u041c\u0418", "\u0429\u0415\u0426\u0418\u041d \u0413\u0423\u041c\u0418\u041d\u0426\u0415", "W", null);
            RailwayStationsDataProvider.put("5100732", "5100732", "\u0412\u0415\u0419\u0413\u0415\u0420\u041e\u0412\u041e", "\u0412\u0415\u0419\u0413\u0415\u0420\u041e\u0412\u041e", "W", null);
            RailwayStationsDataProvider.put("5100172", "5100172", "\u041b\u0415\u0411\u041e\u0420\u041a", "\u041b\u0415\u0411\u041e\u0420\u041a", "W", null);
            RailwayStationsDataProvider.put("5100113", "5100113", "\u0421\u041b\u0423\u041f\u0421\u041a", "\u0421\u041b\u0423\u041f\u0421\u041a", "W", null);
            RailwayStationsDataProvider.put("5100181", "5100181", "\u0421\u041b\u0410\u0412\u041d\u041e", "\u0421\u041b\u0410\u0412\u041d\u041e", "W", null);
            RailwayStationsDataProvider.put("5100050", "5100050", "\u041a\u041e\u0428\u0410\u041b\u0418\u041d", "\u041a\u041e\u0428\u0410\u041b\u0418\u041d", "W", null);
            RailwayStationsDataProvider.put("5100209", "5100209", "\u0421\u0412\u0418\u0414\u0412\u0418\u041d", "\u0421\u0412\u0418\u0414\u0412\u0418\u041d", "W", null);
            RailwayStationsDataProvider.put("5100202", "5100202", "\u041b\u041e\u0411\u0415\u0417", "\u041b\u041e\u0411\u0415\u0417", "W", null);
            RailwayStationsDataProvider.put("5199119", "5199119", "\u0429\u0415\u0426\u0418\u041d", "\u0429\u0415\u0426\u0418\u041d", "W", null);
            RailwayStationsDataProvider.put("8010131", "8010131", "\u0411\u0415\u0420\u041b\u0418\u041d \u0428\u0410\u0420", "\u0411\u0415\u0420\u041b\u0418\u041d-\u0428\u0410\u0420\u041b", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2003930", "2003930", "\u0423\u0417\u041b\u041e\u0412\u0410\u042f", "\u0423\u0417\u041b\u041e\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2010000", "2010000", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041b\u042c", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041b\u042c", "\u042f", null);
            RailwayStationsDataProvider.put("2010041", "2010041", "\u0412\u041e\u041b\u041e\u0413\u0414\u0410", "\u0412\u041e\u041b\u041e\u0413\u0414\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010130", "2010130", "\u0418\u0412\u0410\u041d\u041e\u0412\u041e \u0413", "\u0418\u0412\u0410\u041d\u041e\u0412\u041e \u0413\u041e\u0420\u041e\u0414", "\u042f", null);
            RailwayStationsDataProvider.put("2010161", "2010161", "\u041a\u041e\u0422\u041b\u0410\u0421", "\u041a\u041e\u0422\u041b\u0410\u0421", "\u042f", null);
            RailwayStationsDataProvider.put("2010295", "2010295", "\u0420\u042b\u0411\u0418\u041d\u0421\u041a", "\u0420\u042b\u0411\u0418\u041d\u0421\u041a", "\u042f", null);
            RailwayStationsDataProvider.put("2010441", "2010441", "\u0410\u0420\u0425\u0410\u041d\u0413\u0415\u041b\u042c\u0421", "\u0410\u0420\u0425\u0410\u041d\u0413\u0415\u041b\u042c\u0421\u041a", "\u042f", null);
            RailwayStationsDataProvider.put("2200304", "2200304", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200305", "2200305", "\u041a\u041e\u0420\u041e\u0421\u0422 \u0413\u041e\u0420", "\u041a\u041e\u0420\u041e\u0421\u0422\u0415\u041d\u042c \u0413\u041e\u0420\u041e\u0414", "\u041a", null);
            RailwayStationsDataProvider.put("2200306", "2200306", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d\u0421\u0422", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0418\u041d\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2204000", "2204000", "\u0425\u0410\u0420\u042c\u041a\u041e\u0412", "\u0425\u0410\u0420\u042c\u041a\u041e\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204330", "2204330", "\u041f\u041e\u041b\u0422\u0410\u0412\u0410", "\u041f\u041e\u041b\u0422\u0410\u0412\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204352", "2204352", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2065580", "2065580", "\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u0421", null);
            RailwayStationsDataProvider.put("2020800", "2020800", "\u0418\u041b\u041e\u0412\u041b\u042f", "\u0418\u041b\u041e\u0412\u041b\u042f \u0413\u041e\u0420\u041e\u0414", "\u0416", null);
            RailwayStationsDataProvider.put("2700000", "2700000", "\u0410\u041b\u041c\u0410 \u0410\u0422\u0410", "\u0410\u041b\u041c\u0410-\u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2700685", "2700685", "\u0410\u0420\u042b\u0421\u042c", "\u0410\u0420\u042b\u0421\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2708803", "2708803", "\u041a\u041e\u041a\u0428\u0415\u0422\u0410\u0423", "\u041a\u041e\u041a\u0428\u0415\u0422\u0410\u0423", "\u0426", null);
            RailwayStationsDataProvider.put("2708952", "2708952", "\u041a\u0410\u0420\u0410\u0413\u0410\u041d\u0414\u042b", "\u041a\u0410\u0420\u0410\u0413\u0410\u041d\u0414\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2028000", "2028000", "\u041a\u0415\u041c\u0415\u0420\u041e\u0412\u041e", "\u041a\u0415\u041c\u0415\u0420\u041e\u0412\u041e", "\u041d", null);
            RailwayStationsDataProvider.put("2028039", "2028039", "\u042e\u0420\u0413\u0410", "\u042e\u0420\u0413\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2028042", "2028042", "\u041a\u0418\u0421\u0415\u041b\u0415\u0412\u0421\u041a", "\u041a\u0418\u0421\u0415\u041b\u0415\u0412\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2028052", "2028052", "\u041b\u0415\u041d\u0418\u041d\u0421\u041a \u041a", "\u041b\u0415\u041d\u0418\u041d\u0421\u041a \u041a\u0423\u0417\u041d\u0415\u0426\u041a\u0418\u0419", "\u041d", null);
            RailwayStationsDataProvider.put("2028055", "2028055", "\u0410\u0420\u0422\u042b\u0428\u0422\u0410", "\u0410\u0420\u0422\u042b\u0428\u0422\u0410", "\u041d", null);
            RailwayStationsDataProvider.put("2028093", "2028093", "\u041f\u0420\u041e\u041a\u041e\u041f\u042c\u0415\u0412\u0421", "\u041f\u0420\u041e\u041a\u041e\u041f\u042c\u0415\u0412\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2028124", "2028124", "\u041d\u041e\u0412\u041e\u041a\u0423\u0417\u041d \u0413", "\u041d\u041e\u0412\u041e\u041a\u0423\u0417\u041d\u0415\u0426\u041a \u0413\u041e\u0420\u041e\u0414", "\u041d", null);
            RailwayStationsDataProvider.put("2028125", "2028125", "\u0422\u0410\u0428\u0422\u0410\u0413\u041e\u041b", "\u0422\u0410\u0428\u0422\u0410\u0413\u041e\u041b", "\u041d", null);
            RailwayStationsDataProvider.put("2028133", "2028133", "\u041e\u0421\u0418\u041d\u041d\u0418\u041a\u0418", "\u041e\u0421\u0418\u041d\u041d\u0418\u041a\u0418", "\u041d", null);
            RailwayStationsDataProvider.put("2028145", "2028145", "\u041c\u042b\u0421\u041a\u0418", "\u041c\u042b\u0421\u041a\u0418", "\u041d", null);
            RailwayStationsDataProvider.put("2028156", "2028156", "\u0422\u041e\u041c\u0421\u041a", "\u0422\u041e\u041c\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2044000", "2044000", "\u041d\u041e\u0412\u041e\u0421\u0418\u0411\u0418\u0420\u0421", "\u041d\u041e\u0412\u041e\u0421\u0418\u0411\u0418\u0420\u0421\u041a", "\u041d", null);
            RailwayStationsDataProvider.put("2038000", "2038000", "\u041a\u0420\u0410\u0421\u041d\u041e\u042f\u0420\u0421\u041a", "\u041a\u0420\u0410\u0421\u041d\u041e\u042f\u0420\u0421\u041a", "\u042b", null);
            RailwayStationsDataProvider.put("2054000", "2054000", "\u0418\u0420\u041a\u0423\u0422\u0421\u041a", "\u0418\u0420\u041a\u0423\u0422\u0421\u041a", "\u0418", null);
            RailwayStationsDataProvider.put("2054555", "2054555", "\u0423\u041b\u0410\u041d \u0423\u0414\u042d", "\u0423\u041b\u0410\u041d-\u0423\u0414\u042d", "\u0418", null);
            RailwayStationsDataProvider.put("2054775", "2054775", "\u0411\u0420\u0410\u0422\u0421\u041a", "\u0411\u0420\u0410\u0422\u0421\u041a", "\u0418", null);
            RailwayStationsDataProvider.put("8016544", "8016544", "\u0410\u041d\u0413\u0415\u0420\u041c\u042e\u041d\u0414\u0415", "\u0410\u041d\u0413\u0415\u0420\u041c\u042e\u041d\u0414\u0415", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2005480", "2005480", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0422\u041e\u0412", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0422\u041e\u0412\u0410\u0420\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2101154", "2101154", "\u041a\u0423\u0422\u041e\u041a *", "\u041a\u0423\u0422\u041e\u041a *", "\u0411", null);
            RailwayStationsDataProvider.put("2100212", "2100212", "\u0422\u0415\u0420\u0415\u0425\u041e\u0412\u041a\u0410*", "\u0422\u0415\u0420\u0415\u0425\u041e\u0412\u041a\u0410*", "\u0411", null);
            RailwayStationsDataProvider.put("2100802", "2100802", "\u041d\u041e\u0412 \u0420\u0423\u0414\u041d\u042f*", "\u041d\u041e\u0412 \u0420\u0423\u0414\u041d\u042f*", "\u0411", null);
            RailwayStationsDataProvider.put("2100259", "2100259", "\u0421\u041b\u041e\u0412\u0415\u0427\u041d\u041e *", "\u0421\u041b\u041e\u0412\u0415\u0427\u041d\u041e *", "\u0411", null);
            RailwayStationsDataProvider.put("2100213", "2100213", "\u041a\u0420\u0423\u0413\u041e\u0412\u0415\u0426 *", "\u041a\u0420\u0423\u0413\u041e\u0412\u0415\u0426 *", "\u0411", null);
            RailwayStationsDataProvider.put("2100555", "2100555", "\u0425\u041e\u0422\u0418\u0421\u041b\u0410\u0412 *", "\u0425\u041e\u0422\u0418\u0421\u041b\u0410\u0412 *", "\u0411", null);
            RailwayStationsDataProvider.put("2101314", "2101314", "\u0411\u0423\u0425\u041b\u0418\u0427\u0418 *", "\u0411\u0423\u0425\u041b\u0418\u0427\u0418 *", "\u0411", null);
            RailwayStationsDataProvider.put("2100919", "2100919", "\u0413\u0420\u0410\u0411\u041e\u0412\u041a\u0410 *", "\u0413\u0420\u0410\u0411\u041e\u0412\u041a\u0410 *", "\u0411", null);
            RailwayStationsDataProvider.put("2101227", "2101227", "\u041a\u0420\u0410\u0412\u0426\u041e\u0412\u041a\u0410*", "\u041a\u0420\u0410\u0412\u0426\u041e\u0412\u041a\u0410*", "\u0411", null);
            RailwayStationsDataProvider.put("2200719", "2200719", "\u041a\u0410\u0428\u041f\u0415\u0420\u041e\u0412\u041a\u0410", "\u041a\u0410\u0428\u041f\u0415\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201147", "2201147", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a\u041e\u04122", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a\u041e\u0412 2", "\u041a", null);
            RailwayStationsDataProvider.put("5700709", "5700709", "\u0413\u0410\u0414\u0416\u0418 \u0417\u0415\u0419\u041d", "\u0413\u0410\u0414\u0416\u0418 \u0417\u0415\u0419\u041d\u0410\u041b\u0410\u0411\u0414\u0418\u041d", "\u0410", null);
            RailwayStationsDataProvider.put("5700720", "5700720", "\u0413\u0410\u0414\u0416\u0418\u0413\u0410\u0411\u0423\u041b", "\u0413\u0410\u0414\u0416\u0418\u0413\u0410\u0411\u0423\u041b", "\u0410", null);
            RailwayStationsDataProvider.put("5700719", "5700719", "\u0413\u041e\u0411\u0423\u0421\u0422\u0410\u041d", "\u0413\u041e\u0411\u0423\u0421\u0422\u0410\u041d", "\u0410", null);
            RailwayStationsDataProvider.put("5700854", "5700854", "\u0413\u0410\u0421\u042b\u041c\u041e\u0412  *", "\u0413\u0410\u0421\u042b\u041c\u041e\u0412 \u041c\u0410\u0413\u041e\u041c\u0415\u0414 \u0418\u0421\u0410 *", "\u0410", null);
            RailwayStationsDataProvider.put("5700857", "5700857", "\u0421\u0423\u041c\u0413\u0410\u0418\u0422 \u041f", "\u0421\u0423\u041c\u0413\u0410\u0418\u0422 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0410", null);
            RailwayStationsDataProvider.put("2050121", "2050121", "\u0425\u0410\u0420\u0410\u041d\u041e\u0420 *", "\u0425\u0410\u0420\u0410\u041d\u041e\u0420 *", "\u0427", null);
            RailwayStationsDataProvider.put("2050120", "2050120", "\u0414\u0410\u0423\u0420\u0418\u042f *", "\u0414\u0410\u0423\u0420\u0418\u042f *", "\u0427", null);
            RailwayStationsDataProvider.put("2050605", "2050605", "\u0414\u0423\u0420\u0411\u0410\u0427\u0418 *", "\u0414\u0423\u0420\u0411\u0410\u0427\u0418 *", "\u0427", null);
            RailwayStationsDataProvider.put("2000652", "2000652", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041a\u0410", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2100857", "2100857", "\u0410\u041f\u041e\u041b\u041b\u041e\u041d\u041e\u0412\u041a", "\u0410\u041f\u041e\u041b\u041b\u041e\u041d\u041e\u0412\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100850", "2100850", "\u041a\u0420\u0410\u0415\u0412\u0410", "\u041a\u0420\u0410\u0415\u0412\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100882", "2100882", "\u041e\u041b\u042c\u0425\u041e\u0412\u041a\u0410", "\u041e\u041b\u042c\u0425\u041e\u0412\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2200044", "2200044", "\u0411 \u041e\u041b\u0415\u0419\u041d\u0418\u041a\u0410", "\u0418\u041c\u0415\u041d\u0418 \u0411\u041e\u0420\u0418\u0421\u0410 \u041e\u041b\u0415\u0419\u041d\u0418\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200045", "2200045", "\u0412\u0415\u0420\u0415\u0421\u041e\u0427\u042c", "\u0412\u0415\u0420\u0415\u0421\u041e\u0427\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200046", "2200046", "\u0412\u0415\u0420\u0422\u0415\u0415\u0412\u041a\u0410", "\u0412\u0415\u0420\u0422\u0415\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200146", "2200146", "\u0420\u0410\u041a\u0418\u0422\u041d\u041e", "\u0420\u0410\u041a\u0418\u0422\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200750", "2200750", "\u041e\u041b\u042c\u0428\u0410\u041d\u0418\u0426\u0410", "\u041e\u041b\u042c\u0428\u0410\u041d\u0418\u0426\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200075", "2200075", "\u0422\u0415\u0422\u0415\u0420\u0415\u0412", "\u0422\u0415\u0422\u0415\u0420\u0415\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2200247", "2200247", "\u0411\u0410\u0420", "\u0411\u0410\u0420", "\u041a", null);
            RailwayStationsDataProvider.put("2200268", "2200268", "\u0412\u041e\u041b\u041e\u0427\u0418\u0421\u041a", "\u0412\u041e\u041b\u041e\u0427\u0418\u0421\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200230", "2200230", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d 2", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0418\u041d\u041e\u0412 2", "\u041a", null);
            RailwayStationsDataProvider.put("2200218", "2200218", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d 1", "\u0421\u0422\u0410\u0420\u041e\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0418\u041d\u041e\u0412 1", "\u041a", null);
            RailwayStationsDataProvider.put("2200225", "2200225", "\u041a\u0420\u0410\u0421\u0418\u041b\u041e\u0412", "\u041a\u0420\u0410\u0421\u0418\u041b\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2200231", "2200231", "\u042f\u0420\u041c\u041e\u041b\u0418\u041d\u0426\u042b", "\u042f\u0420\u041c\u041e\u041b\u0418\u041d\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200213", "2200213", "\u0413\u0410\u0419\u0421\u0418\u041d", "\u0413\u0410\u0419\u0421\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200188", "2200188", "\u0418\u0417\u042f\u0421\u041b\u0410\u0412\u041b\u042c", "\u0418\u0417\u042f\u0421\u041b\u0410\u0412\u041b\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200148", "2200148", "\u0411\u0415\u041b\u0413\u041e\u0420\u041e\u0414\u041a\u0410", "\u0411\u0415\u041b\u0413\u041e\u0420\u041e\u0414\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2208011", "2208011", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208010", "2208010", "\u0421\u041b\u0410\u0412\u0423\u0422\u0418\u0427", "\u0421\u041b\u0410\u0412\u0423\u0422\u0418\u0427", "\u0428", null);
            RailwayStationsDataProvider.put("2210074", "2210074", "\u0421\u0415\u041c\u0418\u0421\u041e\u0422\u041a\u0410", "\u0421\u0415\u041c\u0418\u0421\u041e\u0422\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210950", "2210950", "\u0412\u041b\u0410\u0414\u0418\u0421\u041b\u0410\u0412", "\u0412\u041b\u0410\u0414\u0418\u0421\u041b\u0410\u0412\u041e\u0412\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2050125", "2050125", "\u041c\u0410\u0426\u0418\u0415\u0412\u0421\u041a *", "\u041c\u0410\u0426\u0418\u0415\u0412\u0421\u041a\u0410\u042f *", "\u0427", null);
            RailwayStationsDataProvider.put("2050175", "2050175", "\u0421\u041e\u041b\u041e\u0412\u042c\u0415\u0412 *", "\u0421\u041e\u041b\u041e\u0412\u042c\u0415\u0412\u0421\u041a *", "\u0427", null);
            RailwayStationsDataProvider.put("2050129", "2050129", "\u041f\u0420\u0418\u0410\u0420\u0413\u0423\u041d *", "\u041f\u0420\u0418\u0410\u0420\u0413\u0423\u041d\u0421\u041a *", "\u0427", null);
            RailwayStationsDataProvider.put("2006200", "2006200", "\u041a\u0420\u042e\u041a\u041e\u0412\u041e", "\u041a\u0420\u042e\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2010187", "2010187", "\u0411\u0410\u041a\u041b\u0410\u041d\u041a\u0410", "\u0411\u0410\u041a\u041b\u0410\u041d\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2038568", "2038568", "\u041a\u0410\u0420\u0410\u0419", "\u041a\u0410\u0420\u0410\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038567", "2038567", "\u0421\u0422\u0423\u0414 \u041f\u041b\u0415\u0421", "\u0421\u0422\u0423\u0414\u0415\u041d\u042b\u0419 \u041f\u041b\u0415\u0421", "\u042b", null);
            RailwayStationsDataProvider.put("2038569", "2038569", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412\u041a\u0410", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412\u041a\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2038570", "2038570", "\u0418\u0421\u0422\u041e\u0420\u0418\u0427\u0415\u0421\u041a", "\u0418\u0421\u0422\u041e\u0420\u0418\u0427\u0415\u0421\u041a\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038571", "2038571", "\u0412\u0415\u0420\u0425 \u0410\u0421\u041a\u0418\u0417", "\u0412\u0415\u0420\u0425\u041d\u0418\u0419 \u0410\u0421\u041a\u0418\u0417", "\u042b", null);
            RailwayStationsDataProvider.put("2038576", "2038576", "\u041a\u0418\u0417\u041b\u0410\u0421", "\u041a\u0418\u0417\u041b\u0410\u0421", "\u042b", null);
            RailwayStationsDataProvider.put("2038572", "2038572", "\u0420\u0410\u0417\u0414\u041e\u041b\u042c\u041d\u0410\u042f", "\u0420\u0410\u0417\u0414\u041e\u041b\u042c\u041d\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038573", "2038573", "\u0427\u0410\u0420\u0422\u042b\u041a\u041e\u0412\u0421\u041a", "\u0427\u0410\u0420\u0422\u042b\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038574", "2038574", "\u0423\u0419\u0422\u0410\u041a", "\u0423\u0419\u0422\u0410\u041a", "\u042b", null);
            RailwayStationsDataProvider.put("2038575", "2038575", "\u0423\u0422\u0418\u041d \u041e\u0417\u0415\u0420\u041e", "\u0423\u0422\u0418\u041d\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u042b", null);
            RailwayStationsDataProvider.put("2038577", "2038577", "\u041a\u0418\u0420\u0411\u0410", "\u041a\u0418\u0420\u0411\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2038596", "2038596", "\u041e\u041f 219 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 219 \u041a\u041c", "\u042b", null);
            RailwayStationsDataProvider.put("2038597", "2038597", "\u041e\u041f 227 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 227 \u041a\u041c", "\u042b", null);
            RailwayStationsDataProvider.put("2038579", "2038579", "\u041f\u0420\u041e\u0425\u041b\u0410\u0414\u041d\u0410\u042f", "\u041f\u0420\u041e\u0425\u041b\u0410\u0414\u041d\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038580", "2038580", "\u041a\u0410\u041d\u0418\u0424\u041e\u041b\u042c\u041d", "\u041a\u0410\u041d\u0418\u0424\u041e\u041b\u042c\u041d\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038595", "2038595", "\u0420\u0415\u0412\u0423\u0427\u0418\u0419", "\u0420\u0415\u0412\u0423\u0427\u0418\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038581", "2038581", "\u0422\u0410\u0411\u0410\u0413\u0410\u0428\u0415\u0422", "\u0422\u0410\u0411\u0410\u0413\u0410\u0428\u0415\u0422", "\u042b", null);
            RailwayStationsDataProvider.put("2038582", "2038582", "\u042e\u0416 \u0422\u0423\u041d\u0413\u0423\u0421\u041a", "\u042e\u0416\u041d\u0410\u042f \u0422\u0423\u041d\u0413\u0423\u0421\u041a\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2038583", "2038583", "\u041f\u041e\u041a\u0410\u041d\u0410\u0415\u0412\u041a\u0410", "\u041f\u041e\u041a\u0410\u041d\u0410\u0415\u0412\u041a\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2038584", "2038584", "\u041a\u041e\u041b\u042e\u0427\u0418\u0419", "\u041a\u041e\u041b\u042e\u0427\u0418\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038585", "2038585", "\u0422\u0418\u041b\u0418\u0427\u0415\u0422", "\u0422\u0418\u041b\u0418\u0427\u0415\u0422", "\u042b", null);
            RailwayStationsDataProvider.put("2038586", "2038586", "\u041f\u041b\u0410\u0428\u0415\u0427\u041d\u0410\u042f", "\u041f\u041b\u0410\u0428\u0415\u0427\u041d\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038587", "2038587", "\u0427\u0415\u0420\u041c\u0410\u041d\u0427\u0415\u0422", "\u0427\u0415\u0420\u041c\u0410\u041d\u0427\u0415\u0422", "\u042b", null);
            RailwayStationsDataProvider.put("2038588", "2038588", "\u041d\u041e\u0412\u041e\u0411\u0418\u0420\u042e\u0421", "\u041d\u041e\u0412\u041e\u0411\u0418\u0420\u042e\u0421\u0418\u041d\u0421\u041a\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038589", "2038589", "\u0413\u0410\u0420\u0415\u0412\u041e\u0419", "\u0413\u0410\u0420\u0415\u0412\u041e\u0419", "\u042b", null);
            RailwayStationsDataProvider.put("2038590", "2038590", "\u0422\u0410\u041c\u0422\u0410\u0427\u0415\u0422", "\u0422\u0410\u041c\u0422\u0410\u0427\u0415\u0422", "\u042b", null);
            RailwayStationsDataProvider.put("2038591", "2038591", "\u0427\u0423\u041d\u041e\u042f\u0420", "\u0427\u0423\u041d\u041e\u042f\u0420", "\u042b", null);
            RailwayStationsDataProvider.put("2038592", "2038592", "\u041a\u0410\u041c \u0420\u0415\u0427\u041a\u0410", "\u041a\u0410\u041c\u0415\u041d\u041d\u0410\u042f \u0420\u0415\u0427\u041a\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("2038593", "2038593", "\u041d\u041e\u0412\u041e\u0425\u0410\u0419\u0421\u041a", "\u041d\u041e\u0412\u041e\u0425\u0410\u0419\u0421\u041a\u0410\u042f", "\u042b", null);
            RailwayStationsDataProvider.put("2038594", "2038594", "\u041a\u0423\u0427\u0415\u0422\u041a\u0410\u041d", "\u041a\u0423\u0427\u0415\u0422\u041a\u0410\u041d", "\u042b", null);
            RailwayStationsDataProvider.put("2038598", "2038598", "\u041a\u0420\u0410\u0421 \u0421\u0422\u041e\u041b\u0411", "\u041a\u0420\u0410\u0421\u041d\u041e\u042f\u0420\u0421\u041a\u0418\u0415 \u0421\u0422\u041e\u041b\u0411\u042b", "\u042b", null);
            RailwayStationsDataProvider.put("2038578", "2038578", "\u0423\u0421\u0422\u042c \u041c\u0410\u041d\u0410", "\u0423\u0421\u0422\u042c-\u041c\u0410\u041d\u0410", "\u042b", null);
            RailwayStationsDataProvider.put("8020401", "8020401", "\u0413\u0410\u041c\u0411\u0423\u0420\u0413 \u0425", "\u0413\u0410\u041c\u0411\u0423\u0420\u0413 \u0425\u0410\u0420\u0411.", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8300266", "8300266", "\u0412\u0415\u0420\u041e\u041d\u0410", "\u0412\u0415\u0420\u041e\u041d\u0410 \u041f \u041d\u0423\u041e\u0412\u0410", "1", "\u0418\u0442\u0430\u043b\u0438\u044f");
            RailwayStationsDataProvider.put("2038787", "2038787", "\u0414.\u041a\u0410\u0420\u0410\u0411\u0423\u041b\u0410", "\u0414\u0415\u0420\u0415\u0412\u041d\u042f \u041a\u0410\u0420\u0410\u0411\u0423\u041b\u0410", "\u042b", null);
        }
    }

    private static final class RailwayStationInitializer08 {
        private RailwayStationInitializer08() {
        }

        /*
         * Opcode count of 17509 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        public static void init() {
            RailwayStationsDataProvider.put("2005115", "2005115", "\u0421\u0415\u0421\u0422\u0420\u041e\u0420\u0415\u0426\u041a", "\u0421\u0415\u0421\u0422\u0420\u041e\u0420\u0415\u0426\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2005360", "2005360", "\u041a\u0423\u0420\u041e\u0420\u0422", "\u041a\u0423\u0420\u041e\u0420\u0422", "\u041e", null);
            RailwayStationsDataProvider.put("2005124", "2005124", "\u041c\u041e\u041b\u041e\u0414\u0415\u0416\u041d\u0410\u042f", "\u041c\u041e\u041b\u041e\u0414\u0415\u0416\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005364", "2005364", "\u041f\u0420\u0418\u0412\u0415\u0422\u041d\u0415\u041d*", "\u041f\u0420\u0418\u0412\u0415\u0422\u041d\u0415\u041d\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005473", "2005473", "\u041e\u041f 71 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 71 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005289", "2005289", "\u041c\u0415\u0421\u0422\u0415\u0420\u042c\u042f\u0420*", "\u041c\u0415\u0421\u0422\u0415\u0420\u042c\u042f\u0420\u0412\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005332", "2005332", "\u042f\u041f\u041f\u0418\u041b\u042f   *", "\u042f\u041f\u041f\u0418\u041b\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2005056", "2005056", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u0421\u041a*", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u0421\u041a\u0410\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2005137", "2005137", "\u041a\u0423\u041e\u041b\u0415\u041c\u0410\u042f\u0420*", "\u041a\u0423\u041e\u041b\u0415\u041c\u0410\u042f\u0420\u0412\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005297", "2005297", "\u0415\u0420\u041c\u0418\u041b\u041e\u0412\u041e *", "\u0415\u0420\u041c\u0418\u041b\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005176", "2005176", "\u041f\u0420\u0418\u041c\u041e\u0420\u0421\u041a *", "\u041f\u0420\u0418\u041c\u041e\u0420\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005047", "2005047", "\u0411\u041e\u0420      *", "\u0411\u041e\u0420 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005264", "2005264", "\u041f\u0420\u0418\u0411\u042b\u041b\u041e\u0412\u041e*", "\u041f\u0420\u0418\u0411\u042b\u041b\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005322", "2005322", "\u0421\u041e\u0412\u0415\u0422\u0421\u041a\u0418\u0419", "\u0421\u041e\u0412\u0415\u0422\u0421\u041a\u0418\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2005474", "2005474", "\u041f\u041e\u041f\u041e\u0412\u041e   *", "\u041f\u041e\u041f\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005475", "2005475", "\u041c\u0410\u0422\u0420\u041e\u0421\u041e\u0412\u041e*", "\u041c\u0410\u0422\u0420\u041e\u0421\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005198", "2005198", "\u0421\u041e\u041a\u041e\u041b\u0418\u041d\u0421\u041a*", "\u0421\u041e\u041a\u041e\u041b\u0418\u041d\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005328", "2005328", "\u041a\u0410\u0420\u0425\u0423\u0421\u0423\u041e", "\u041a\u0410\u0420\u0425\u0423\u0421\u0423\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005228", "2005228", "\u041f\u0415\u0420\u041e\u0412\u041e", "\u041f\u0415\u0420\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005181", "2005181", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005291", "2005291", "\u0412\u0415\u0429\u0415\u0412\u041e", "\u0412\u0415\u0429\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005159", "2005159", "\u0416\u0418\u0422\u041a\u041e\u0412\u041e", "\u0416\u0418\u0422\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005476", "2005476", "\u041e\u041f 2 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005139", "2005139", "\u0422\u0410\u041c\u041c\u0418\u0421\u0423\u041e", "\u0422\u0410\u041c\u041c\u0418\u0421\u0423\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005352", "2005352", "\u041f\u0410\u041b\u042c\u0426\u0415\u0412\u041e *", "\u041f\u0410\u041b\u042c\u0426\u0415\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005016", "2005016", "\u0413\u0412\u0410\u0420\u0414\u0415\u0419\u0421\u041a*", "\u0413\u0412\u0410\u0420\u0414\u0415\u0419\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005477", "2005477", "\u041f\u0418\u041e\u041d\u0415\u0420\u041b\u0410\u0413*", "\u041f\u0418\u041e\u041d\u0415\u0420\u041b\u0410\u0413\u0415\u0420\u042c *", "\u041e", null);
            RailwayStationsDataProvider.put("2005111", "2005111", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005395", "2005395", "\u0412\u041e\u0417\u0420\u041e\u0416\u0414\u0415\u041d*", "\u0412\u041e\u0417\u0420\u041e\u0416\u0414\u0415\u041d\u0418\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005397", "2005397", "\u0425\u0410\u041d\u041d\u0418\u041b\u0410  *", "\u0425\u0410\u041d\u041d\u0418\u041b\u0410 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005133", "2005133", "\u041d\u0418\u041a\u0418\u0424\u041e\u0420\u041e\u0412*", "\u041d\u0418\u041a\u0418\u0424\u041e\u0420\u041e\u0412\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005127", "2005127", "\u041e\u041f 38 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 38 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005478", "2005478", "\u041a\u0423\u041e\u0420\u0415\u041a\u041e\u0421\u041a\u0418", "\u041a\u0423\u041e\u0420\u0415\u041a\u041e\u0421\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005351", "2005351", "\u041a\u0410\u041c\u0415\u041d\u041d\u041e\u0413 *", "\u041a\u0410\u041c\u0415\u041d\u041d\u041e\u0413\u041e\u0420\u0421\u041a *", "\u041e", null);
            RailwayStationsDataProvider.put("2004736", "2004736", "\u0411\u041e\u0420\u041e\u0412\u0418\u041d\u041a\u0410*", "\u0411\u041e\u0420\u041e\u0412\u0418\u041d\u041a\u0410 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004786", "2004786", "\u041a\u0420\u0410\u0421 \u0421\u041e\u041a\u041e\u041b", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u0421\u041e\u041a\u041e\u041b", "\u041e", null);
            RailwayStationsDataProvider.put("2004737", "2004737", "\u041b\u0415\u041d\u0418\u042f\u0420\u0412\u0418 *", "\u041b\u0415\u041d\u0418\u042f\u0420\u0412\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005252", "2005252", "\u0411\u041e\u0420\u041e\u0414\u0418\u041d\u0421\u041a*", "\u0411\u041e\u0420\u041e\u0414\u0418\u041d\u0421\u041a\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005349", "2005349", "\u0418\u041d\u041a\u0418\u041b\u042f   *", "\u0418\u041d\u041a\u0418\u041b\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2004738", "2004738", "\u0425\u0410\u041a\u041e\u041b\u0410\u0425\u0422\u0418*", "\u0425\u0410\u041a\u041e\u041b\u0410\u0425\u0422\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005209", "2005209", "\u041e\u042f\u042f\u0420\u0412\u0418   *", "\u041e\u042f\u042f\u0420\u0412\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004739", "2004739", "\u041f\u0423\u041a\u0418\u041d\u041d\u0418\u0415\u041c\u0418", "\u041f\u0423\u041a\u0418\u041d\u041d\u0418\u0415\u041c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005087", "2005087", "\u041e\u041f 5 \u041a\u041c  *", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c *", "\u041e", null);
            RailwayStationsDataProvider.put("2005257", "2005257", "\u041f\u0420\u0423\u0414\u042b    *", "\u041f\u0420\u0423\u0414\u042b *", "\u041e", null);
            RailwayStationsDataProvider.put("2005299", "2005299", "\u041b\u0415\u0421\u041e\u0413\u041e\u0420\u0421\u041a*", "\u041b\u0415\u0421\u041e\u0413\u041e\u0420\u0421\u041a\u0418\u0419 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005171", "2005171", "\u041a\u0418\u0412\u0418\u041e\u042f   *", "\u041a\u0418\u0412\u0418\u041e\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2005006", "2005006", "\u0421\u0412\u0415\u0422\u041e\u0413\u041e\u0420\u0421*", "\u0421\u0412\u0415\u0422\u041e\u0413\u041e\u0420\u0421\u041a *", "\u041e", null);
            RailwayStationsDataProvider.put("2005231", "2005231", "\u0429\u0415\u0420\u0411\u0410\u041a\u041e\u0412\u041e*", "\u0429\u0415\u0420\u0411\u0410\u041a\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2005058", "2005058", "\u041f\u0418\u0425\u0422\u041e\u0412\u041e\u0415 *", "\u041f\u0418\u0425\u0422\u041e\u0412\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005254", "2005254", "\u0412\u042b\u0421\u041e\u0426\u041a   *", "\u0412\u042b\u0421\u041e\u0426\u041a *", "\u041e", null);
            RailwayStationsDataProvider.put("2005479", "2005479", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005218", "2005218", "\u0421\u041e\u0420\u0419\u041e", "\u0421\u041e\u0420\u0419\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005123", "2005123", "\u0421\u042e\u0412\u042f\u041e\u0420\u041e", "\u0421\u042e\u0412\u042f\u041e\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004741", "2004741", "\u041f\u042f\u041b\u042c\u041a\u0421\u0410\u0410\u0420*", "\u041f\u042f\u041b\u042c\u041a\u0421\u0410\u0410\u0420\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004742", "2004742", "\u041f\u042f\u041b\u042c\u041a'\u042f\u0420\u0412*", "\u041f\u042f\u041b\u042c\u041a'\u042f\u0420\u0412\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005203", "2005203", "\u0412\u042f\u0420\u0422\u0421\u0418\u041b\u042f *", "\u0412\u042f\u0420\u0422\u0421\u0418\u041b\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2005316", "2005316", "\u041f \u041a\u041e\u0412\u0410\u041b\u0415\u0412\u041e", "\u041f\u041e\u0421\u0422 \u041a\u041e\u0412\u0410\u041b\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005398", "2005398", "\u041a\u041e\u0412\u0410\u041b\u0415\u0412\u041e", "\u041a\u041e\u0412\u0410\u041b\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005015", "2005015", "\u0411\u0415\u0420\u041d\u0413\u0410\u0420\u0414\u041e\u0412", "\u0411\u0415\u0420\u041d\u0413\u0410\u0420\u0414\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005075", "2005075", "\u0412\u0421\u0415\u0412\u041e\u041b\u041e\u0416\u0421\u041a", "\u0412\u0421\u0415\u0412\u041e\u041b\u0416\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005050", "2005050", "\u041c \u0420\u0423\u0427\u0415\u0419", "\u041c\u0415\u041b\u042c\u041d\u0418\u0427\u041d\u042b\u0419 \u0420\u0423\u0427\u0415\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2005336", "2005336", "\u0429\u0415\u0413\u041b\u041e\u0412\u041e", "\u0429\u0415\u0413\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005354", "2005354", "\u041a\u0418\u0420\u041f \u0417\u0410\u0412\u041e\u0414", "\u041a\u0418\u0420\u041f\u0418\u0427\u041d\u042b\u0419 \u0417\u0410\u0412\u041e\u0414", "\u041e", null);
            RailwayStationsDataProvider.put("2005024", "2005024", "\u0420\u0410\u0414\u0427\u0415\u041d\u041a\u041e", "\u0420\u0410\u0414\u0427\u0415\u041d\u041a\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005265", "2005265", "\u0414\u0423\u041d\u0410\u0419", "\u0414\u0423\u041d\u0410\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2005018", "2005018", "\u041e\u041f 19 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 19 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005379", "2005379", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005008", "2005008", "\u041f\u0415\u0422\u0420\u041e\u041a\u0420\u0415\u041f", "\u041f\u0415\u0422\u0420\u041e\u041a\u0420\u0415\u041f\u041e\u0421\u0422\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2005396", "2005396", "\u0421\u0410\u0414\u042b", "\u0421\u0410\u0414\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004743", "2004743", "\u0427\u0415\u0420\u041d \u0420\u0415\u0427\u041a\u0410", "\u0427\u0415\u0420\u041d\u0410\u042f \u0420\u0415\u0427\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004744", "2004744", "\u0422\u0415\u041f\u041b\u041e\u0411\u0415\u0422\u041e\u041d", "\u0422\u0415\u041f\u041b\u041e\u0411\u0415\u0422\u041e\u041d\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005277", "2005277", "\u041e\u041f 37 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 37 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2006104", "2006104", "\u041d\u0415\u0412 \u0414\u0423\u0411\u0420\u041e\u0412", "\u041d\u0415\u0412\u0421\u041a\u0410\u042f \u0414\u0423\u0411\u0420\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005293", "2005293", "\u0420\u041e\u041c\u0410\u041d\u041e\u0412\u041a\u0410", "\u0420\u041e\u041c\u0410\u041d\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005325", "2005325", "\u041a\u041e\u0420\u041d\u0415\u0412\u041e", "\u041a\u041e\u0420\u041d\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005353", "2005353", "\u041f\u0420\u041e\u0411\u0410", "\u041f\u0420\u041e\u0411\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005136", "2005136", "\u0420\u0410\u0425\u042c\u042f", "\u0420\u0410\u0425\u042c\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005270", "2005270", "\u0418\u0420\u0418\u041d\u041e\u0412\u041a\u0410", "\u0418\u0420\u0418\u041d\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2007004", "2007004", "\u0411\u041e\u0420 \u0413\u0420\u0418\u0412\u0410", "\u0411\u041e\u0420 \u0413\u0420\u0418\u0412\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005256", "2005256", "\u0412\u0410\u0413\u0410\u041d\u041e\u0412\u041e", "\u0412\u0410\u0413\u0410\u041d\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004746", "2004746", "\u041e\u041f 44 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 44 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005290", "2005290", "\u041b\u0410\u0414 \u041e\u0417\u0415\u0420\u041e", "\u041b\u0410\u0414\u041e\u0416\u0421\u041a\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004005", "2004005", "\u0421-\u041f\u0415\u0422-\u0411\u0410\u041b\u0422", "\u0421\u0410\u041d\u041a\u0422-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420\u0413-\u0411\u0410\u041b\u0422", "\u041e", null);
            RailwayStationsDataProvider.put("2004438", "2004438", "\u0420\u041e\u0416\u0414\u0415\u0421\u0422\u0412\u0415\u041d", "\u0420\u041e\u0416\u0414\u0415\u0421\u0422\u0412\u0415\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004502", "2004502", "\u041e\u0421\u0423\u0413\u0410", "\u041e\u0421\u0423\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005386", "2005386", "\u0421\u0420\u0415\u0414\u041d\u0415\u0420\u041e\u0413", "\u0421\u0420\u0415\u0414\u041d\u0415\u0420\u041e\u0413\u0410\u0422\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004006", "2004006", "\u0421-\u041f\u0415\u0422-\u041b\u0410\u0414", "\u0421\u0410\u041d\u041a\u0422-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420\u0413 \u041b\u0410\u0414\u041e\u0416.", "\u041e", null);
            RailwayStationsDataProvider.put("2005162", "2005162", "\u041f\u0423\u0420\u0412\u041c\u0410\u041b\u0410", "\u041f\u0423\u0420\u0412\u041c\u0410\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004792", "2004792", "\u041e\u041f 147 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 147 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004735", "2004735", "\u041d\u0415\u0412\u0415\u041b\u042c", "\u041d\u0415\u0412\u0415\u041b\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2004000", "2004000", "\u0421-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420", "\u0421\u0410\u041d\u041a\u0422-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420\u0413", "\u041e", null);
            RailwayStationsDataProvider.put("2500366", "2500366", "\u0420\u0415\u0417\u0415\u041a\u041d\u0415 2", "\u0420\u0415\u0417\u0415\u041a\u041d\u0415 2", "R", null);
            RailwayStationsDataProvider.put("2500368", "2500368", "\u041a\u0420\u0423\u0421\u0422\u041f\u0418\u041b\u0421", "\u041a\u0420\u0423\u0421\u0422\u041f\u0418\u041b\u0421", "R", null);
            RailwayStationsDataProvider.put("2500001", "2500001", "\u0420\u0418\u0413\u0410 \u041f\u0410\u0421", "\u0420\u0418\u0413\u0410-\u041f\u0410\u0421\u0410\u0416\u0418\u0415\u0420\u0423", "R", null);
            RailwayStationsDataProvider.put("2500335", "2500335", "\u0415\u041b\u0413\u0410\u0412\u0410", "\u0415\u041b\u0413\u0410\u0412\u0410", "R", null);
            RailwayStationsDataProvider.put("2500458", "2500458", "\u0417\u0410\u0421\u0423\u041b\u0410\u0423\u041a\u0421", "\u0417\u0410\u0421\u0423\u041b\u0410\u0423\u041a\u0421", "R", null);
            RailwayStationsDataProvider.put("2500364", "2500364", "\u041b\u0418\u0415\u041b\u0423\u041f\u0415", "\u041b\u0418\u0415\u041b\u0423\u041f\u0415", "R", null);
            RailwayStationsDataProvider.put("2500005", "2500005", "\u0411\u0423\u041b\u0414\u0423\u0420\u0418", "\u0411\u0423\u041b\u0414\u0423\u0420\u0418", "R", null);
            RailwayStationsDataProvider.put("2500020", "2500020", "\u0414\u0417\u0418\u041d\u0422\u0410\u0420\u0418", "\u0414\u0417\u0418\u041d\u0422\u0410\u0420\u0418", "R", null);
            RailwayStationsDataProvider.put("2500466", "2500466", "\u041c\u0410\u0419\u041e\u0420\u0418", "\u041c\u0410\u0419\u041e\u0420\u0418", "R", null);
            RailwayStationsDataProvider.put("2500428", "2500428", "\u0414\u0423\u0411\u0423\u041b\u0422\u0418", "\u0414\u0423\u0411\u0423\u041b\u0422\u0418", "R", null);
            RailwayStationsDataProvider.put("2500462", "2500462", "\u0421\u041b\u041e\u041a\u0410", "\u0421\u041b\u041e\u041a\u0410", "R", null);
            RailwayStationsDataProvider.put("2500359", "2500359", "\u041a\u0415\u041c\u0415\u0420\u0418", "\u041a\u0415\u041c\u0415\u0420\u0418", "R", null);
            RailwayStationsDataProvider.put("2500378", "2500378", "\u0422\u0423\u041a\u0423\u041c\u0421 1", "\u0422\u0423\u041a\u0423\u041c\u0421 1", "R", null);
            RailwayStationsDataProvider.put("2500694", "2500694", "\u0421\u041a\u0423\u041b\u0422\u0415", "\u0421\u041a\u0423\u041b\u0422\u0415", "R", null);
            RailwayStationsDataProvider.put("2500480", "2500480", "\u0420\u0415\u0417\u0415\u041a\u041d\u0415", "\u0420\u0415\u0417\u0415\u041a\u041d\u0415", "R", null);
            RailwayStationsDataProvider.put("2058434", "2058434", "\u041d\u0415\u0421\u0422\u0415\u0420\u041e\u0412", "\u041d\u0415\u0421\u0422\u0415\u0420\u041e\u0412", "9", "\u041a\u0416\u0414");
            RailwayStationsDataProvider.put("2058450", "2058450", "\u0427\u0415\u0420\u041d\u042f\u0425\u041e\u0412\u0421\u041a", "\u0427\u0415\u0420\u041d\u042f\u0425\u041e\u0412\u0421\u041a", "9", "\u041a\u0416\u0414");
            RailwayStationsDataProvider.put("2058000", "2058000", "\u041a\u0410\u041b\u0418\u041d\u0418\u041d\u0413\u0420", "\u041a\u0410\u041b\u0418\u041d\u0418\u041d\u0413\u0420\u0410\u0414", "9", "\u041a\u0416\u0414");
            RailwayStationsDataProvider.put("2400454", "2400454", "\u0419\u041e\u041d\u0418\u0428\u041a\u0418\u0421", "\u0419\u041e\u041d\u0418\u0428\u041a\u0418\u0421", "L", null);
            RailwayStationsDataProvider.put("2400420", "2400420", "\u0428\u042f\u0423\u041b\u042f\u0419", "\u0428\u042f\u0423\u041b\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2400398", "2400398", "\u0420\u0410\u0414\u0412\u0418\u041b\u0418\u0428\u041a", "\u0420\u0410\u0414\u0412\u0418\u041b\u0418\u0428\u041a\u0418\u0421", "L", null);
            RailwayStationsDataProvider.put("2400413", "2400413", "\u041a\u0415\u0414\u0410\u0419\u041d\u042f\u0419", "\u041a\u0415\u0414\u0410\u0419\u041d\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2400414", "2400414", "\u0418\u041e\u041d\u0410\u0412\u0410", "\u0418\u041e\u041d\u0410\u0412\u0410", "L", null);
            RailwayStationsDataProvider.put("2400416", "2400416", "\u041a\u0410\u0419\u0428\u042f\u0414\u041e\u0420\u0418\u0421", "\u041a\u0410\u0419\u0428\u042f\u0414\u041e\u0420\u0418\u0421", "L", null);
            RailwayStationsDataProvider.put("2400000", "2400000", "\u0412\u0418\u041b\u042c\u041d\u042e\u0421", "\u0412\u0418\u041b\u042c\u041d\u042e\u0421", "L", null);
            RailwayStationsDataProvider.put("2401391", "2401391", "\u0422\u0410\u0420\u0412\u0410\u0419\u041d\u042f\u0419", "\u0422\u0410\u0420\u0412\u0410\u0419\u041d\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2400001", "2400001", "\u0412\u0418\u041b\u042c\u041d\u042e\u0421 \u0426", "\u0412\u0418\u041b\u042c\u041d\u042e\u0421 \u0426\u0415\u041d\u0422\u0420", "L", null);
            RailwayStationsDataProvider.put("2100100", "2100100", "\u0413\u041e\u041c\u0415\u041b\u042c \u041f\u0410\u0421", "\u0413\u041e\u041c\u0415\u041b\u042c-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2100080", "2100080", "\u0416\u041b\u041e\u0411\u0418\u041d", "\u0416\u041b\u041e\u0411\u0418\u041d", "\u0411", null);
            RailwayStationsDataProvider.put("2100270", "2100270", "\u041e\u0421\u0418\u041f\u041e\u0412\u0418\u0427 1", "\u041e\u0421\u0418\u041f\u041e\u0412\u0418\u0427\u0418 1", "\u0411", null);
            RailwayStationsDataProvider.put("2100001", "2100001", "\u041c\u0418\u041d\u0421\u041a \u041f\u0410\u0421\u0421", "\u041c\u0418\u041d\u0421\u041a-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2100170", "2100170", "\u041e\u0420\u0428\u0410 \u0426\u0415\u041d\u0422", "\u041e\u0420\u0428\u0410-\u0426\u0415\u041d\u0422\u0420\u0410\u041b\u042c\u041d\u0410\u042f", "\u0411", null);
            RailwayStationsDataProvider.put("2100150", "2100150", "\u041c\u041e\u0413\u0418\u041b\u0415\u0412 1", "\u041c\u041e\u0413\u0418\u041b\u0415\u0412 1", "\u0411", null);
            RailwayStationsDataProvider.put("2100090", "2100090", "\u041a\u0410\u041b\u0418\u041d\u041a\u041e\u0412\u0418\u0427", "\u041a\u0410\u041b\u0418\u041d\u041a\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100140", "2100140", "\u041a\u0420\u0418\u0427\u0415\u0412 1", "\u041a\u0420\u0418\u0427\u0415\u0412 1", "\u0411", null);
            RailwayStationsDataProvider.put("2100305", "2100305", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412", "\u0411", null);
            RailwayStationsDataProvider.put("2101010", "2101010", "\u041c\u0418\u041d\u0421\u041a \u0412\u041e\u0421\u0422", "\u041c\u0418\u041d\u0421\u041a \u0412\u041e\u0421\u0422\u041e\u0427\u041d\u042b\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2101042", "2101042", "\u0411\u0420\u0415\u0421\u0422 \u042e\u0416\u041d", "\u0411\u0420\u0415\u0421\u0422 \u042e\u0416\u041d\u042b\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2100035", "2100035", "\u0411\u0420\u0415\u0421\u0422 \u0426\u0415\u041d", "\u0411\u0420\u0415\u0421\u0422-\u0426\u0415\u041d\u0422\u0420\u0410\u041b\u042c\u041d\u042b\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2100291", "2100291", "\u041b\u0423\u041d\u0418\u041d\u0415\u0426", "\u041b\u0423\u041d\u0418\u041d\u0415\u0426", "\u0411", null);
            RailwayStationsDataProvider.put("2100010", "2100010", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412 \u041f", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412\u0418\u0427\u0418-\u041f\u041e\u041b\u0415\u0421\u0421\u041a\u0418\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100250", "2100250", "\u041b\u0418\u0414\u0410", "\u041b\u0418\u0414\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100190", "2100190", "\u041f\u041e\u041b\u041e\u0426\u041a", "\u041f\u041e\u041b\u041e\u0426\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2100285", "2100285", "\u041a\u0420\u0423\u041b\u0415\u0412\u0429\u0418\u0417\u041d", "\u041a\u0420\u0423\u041b\u0415\u0412\u0429\u0418\u0417\u041d\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100280", "2100280", "\u041c\u041e\u041b\u041e\u0414\u0415\u0427\u041d\u041e", "\u041c\u041e\u041b\u041e\u0414\u0415\u0427\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100070", "2100070", "\u0413\u0420\u041e\u0414\u041d\u041e", "\u0413\u0420\u041e\u0414\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100115", "2100115", "\u0412\u041e\u041b\u041a\u041e\u0412\u042b\u0421 \u0426", "\u0412\u041e\u041b\u041a\u041e\u0412\u042b\u0421\u041a-\u0426\u0415\u041d\u0422\u0420\u0410\u041b\u042c\u041d\u042b\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2100020", "2100020", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412 \u0426", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412\u0418\u0427\u0418-\u0426\u0415\u041d\u0422\u0420\u0410\u041b\u042c\u041d\u042b\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100024", "2100024", "\u0413\u0423\u0414\u041e\u0413\u0410\u0419  *", "\u0413\u0423\u0414\u041e\u0413\u0410\u0419 *", "\u0411", null);
            RailwayStationsDataProvider.put("2100050", "2100050", "\u0412\u0418\u0422\u0415\u0411\u0421\u041a", "\u0412\u0418\u0422\u0415\u0411\u0421\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2000036", "2000036", "\u0422\u041e\u041b\u0421\u0422\u041e\u041f", "\u0422\u041e\u041b\u0421\u0422\u041e\u041f\u0410\u041b\u042c\u0426\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000525", "2000525", "\u041a\u041e\u041a\u041e\u0428\u041a\u0418\u041d\u041e", "\u041a\u041e\u041a\u041e\u0428\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2002088", "2002088", "\u041a\u0420\u0415\u041a\u0428\u0418\u041d\u041e", "\u041a\u0420\u0415\u041a\u0428\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001119", "2001119", "\u041f\u041e\u0411\u0415\u0414\u0410", "\u041f\u041e\u0411\u0415\u0414\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000440", "2000440", "\u0410\u041f\u0420\u0415\u041b\u0415\u0412\u041a\u0410", "\u0410\u041f\u0420\u0415\u041b\u0415\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2002996", "2002996", "\u0414\u0410\u0427\u041d\u0410\u042f", "\u0414\u0410\u0427\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001063", "2001063", "\u0410\u041b\u0410\u0411\u0418\u041d\u041e", "\u0410\u041b\u0410\u0411\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000745", "2000745", "\u0421\u0415\u041b\u042f\u0422\u0418\u041d\u041e", "\u0421\u0415\u041b\u042f\u0422\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001043", "2001043", "\u0420\u0410\u0421\u0421\u0423\u0414\u041e\u0412\u041e", "\u0420\u0410\u0421\u0421\u0423\u0414\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000350", "2000350", "\u041a\u0410\u041b\u0423\u0413\u0410 2", "\u041a\u0410\u041b\u0423\u0413\u0410 2", "\u041c", null);
            RailwayStationsDataProvider.put("2000360", "2000360", "\u0421\u0423\u0425\u0418\u041d\u0418\u0427\u0418 \u0423", "\u0421\u0423\u0425\u0418\u041d\u0418\u0427\u0418 \u0423\u0417\u041b\u041e\u0412\u042b\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2000370", "2000370", "\u0421\u0423\u0425\u0418\u041d\u0418\u0427\u0418 \u0413", "\u0421\u0423\u0425\u0418\u041d\u0418\u0427\u0418-\u0413\u041b\u0410\u0412\u041d\u042b\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2000356", "2000356", "\u0414\u0423\u041c\u0418\u041d\u0418\u0427\u0418", "\u0414\u0423\u041c\u0418\u041d\u0418\u0427\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000357", "2000357", "\u041f\u0410\u041b\u0418\u041a\u0418", "\u041f\u0410\u041b\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000380", "2000380", "\u0417\u0418\u041a\u0415\u0415\u0412\u041e", "\u0417\u0418\u041a\u0415\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000359", "2000359", "\u0421\u0423\u0414\u0418\u041c\u0418\u0420", "\u0421\u0423\u0414\u0418\u041c\u0418\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2000160", "2000160", "\u0411\u0420\u042f\u041d\u0421\u041a \u041e\u0420\u041b", "\u0411\u0420\u042f\u041d\u0421\u041a \u041e\u0420\u041b\u041e\u0412\u0421\u041a\u0418\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000820", "2000820", "\u041d\u0410\u0412\u041b\u042f", "\u041d\u0410\u0412\u041b\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000813", "2000813", "\u0410\u041b\u0422\u0423\u0425\u041e\u0412\u041e", "\u0410\u041b\u0422\u0423\u0425\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000809", "2000809", "\u041d\u0415\u0420\u0423\u0421\u0421\u0410", "\u041d\u0415\u0420\u0423\u0421\u0421\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000808", "2000808", "\u0421\u0423\u0417\u0415\u041c\u041a\u0410", "\u0421\u0423\u0417\u0415\u041c\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2003969", "2003969", "\u041e\u041f 76 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 76 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000354", "2000354", "\u041e\u041f 90 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 90 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003971", "2003971", "\u041e\u041f 99 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 99 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001916", "2001916", "\u041e\u041f 187 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 187 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001914", "2001914", "\u041e\u041f 202 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 202 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000001", "2000001", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0423\u0420", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0423\u0420\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000595", "2000595", "\u041f\u041e\u041a\u0420\u041e\u0412\u0421\u041a\u041e\u0415", "\u041f\u041e\u041a\u0420\u041e\u0412\u0421\u041a\u041e\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2001420", "2001420", "\u041a\u0420 \u0421\u0422\u0420\u041e\u0418\u0422", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u0421\u0422\u0420\u041e\u0418\u0422\u0415\u041b\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2000037", "2000037", "\u0411\u0418\u0422\u0426\u0410", "\u0411\u0418\u0422\u0426\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000630", "2000630", "\u0411\u0423\u0422\u041e\u0412\u041e", "\u0411\u0423\u0422\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000285", "2000285", "\u0429\u0415\u0420\u0411\u0418\u041d\u041a\u0410", "\u0429\u0415\u0420\u0411\u0418\u041d\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2002952", "2002952", "\u0421\u0418\u041b\u0418\u041a\u0410\u0422\u041d\u0410\u042f", "\u0421\u0418\u041b\u0418\u041a\u0410\u0422\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000065", "2000065", "\u041f\u041e\u0414\u041e\u041b\u042c\u0421\u041a", "\u041f\u041e\u0414\u041e\u041b\u042c\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2001246", "2001246", "\u0428\u0415\u041c\u0415\u0422\u041e\u0412\u041e", "\u0428\u0415\u041c\u0415\u0422\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001232", "2001232", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412\u041e", "\u0411\u0410\u0420\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001046", "2001046", "\u0420\u0415\u0412\u042f\u041a\u0418\u041d\u041e", "\u0420\u0415\u0412\u042f\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001262", "2001262", "\u0411\u0410\u0419\u0414\u0418\u041a\u0418", "\u0411\u0410\u0419\u0414\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001214", "2001214", "\u0425\u041e\u041c\u042f\u041a\u041e\u0412\u041e", "\u0425\u041e\u041c\u042f\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000278", "2000278", "\u041f\u041b 191 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 191 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000880", "2000880", "\u0422\u0423\u041b\u0410 1 \u041a\u0423\u0420", "\u0422\u0423\u041b\u0410 1 \u041a\u0423\u0420\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000140", "2000140", "\u041e\u0420\u0415\u041b", "\u041e\u0420\u0415\u041b", "\u041c", null);
            RailwayStationsDataProvider.put("2000150", "2000150", "\u041a\u0423\u0420\u0421\u041a", "\u041a\u0423\u0420\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2003991", "2003991", "\u041e\u041f 9 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 9 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001764", "2001764", "\u041e\u041f 12 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000330", "2000330", "\u041a\u0428\u0415\u041d\u042c", "\u041a\u0428\u0415\u041d\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2000332", "2000332", "\u041b\u0410\u0427\u0418\u041d\u041e\u0412\u041e", "\u041b\u0410\u0427\u0418\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000953", "2000953", "\u041e\u041f 146 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 146 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2015360", "2015360", "\u0415\u041b\u0415\u0426", "\u0415\u041b\u0415\u0426", "\u0412", null);
            RailwayStationsDataProvider.put("2001801", "2001801", "\u041e\u041f 11 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 11 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001022", "2001022", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003976", "2003976", "\u041e\u041f 36 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 36 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000023", "2000023", "\u041e\u041f 43 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 43 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003994", "2003994", "\u041e\u041f 49 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 49 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001352", "2001352", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003995", "2003995", "\u041e\u041f 69 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 69 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001889", "2001889", "\u041e\u041f 81 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 81 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000606", "2000606", "\u041e\u041f 84 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 84 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001959", "2001959", "\u041e\u041f 100 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 100 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003996", "2003996", "\u041e\u041f 125 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 125 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003997", "2003997", "\u041e\u041f 160 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 160 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001434", "2001434", "\u041e\u041f 309 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 309 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001094", "2001094", "\u041e\u041f 313 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 313 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000095", "2000095", "\u041e\u041f 318 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 318 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001861", "2001861", "\u041f\u041b 81 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 81 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2002930", "2002930", "\u0411\u0410\u041b\u0415\u0412\u041e", "\u0411\u0410\u041b\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000470", "2000470", "\u041f\u041b 88 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 88 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000300", "2000300", "\u0420\u0423\u0414\u041d\u0415\u0412\u041e", "\u0420\u0423\u0414\u041d\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001096", "2001096", "\u0412\u041e\u0414\u0411\u041e\u041b\u042c\u0421\u041a\u041e", "\u0412\u041e\u0414\u0411\u041e\u041b\u042c\u0421\u041a\u041e\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2001097", "2001097", "\u041e\u041f 393 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 393 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001252", "2001252", "\u041c\u0418\u041b\u041b\u0418\u041e\u041d\u041d\u0410\u042f", "\u041c\u0418\u041b\u041b\u0418\u041e\u041d\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000345", "2000345", "\u041a\u0410\u041b\u0423\u0413\u0410 1", "\u041a\u0410\u041b\u0423\u0413\u0410 1", "\u041c", null);
            RailwayStationsDataProvider.put("2000170", "2000170", "\u0421\u041c\u041e\u041b\u0415\u041d\u0421\u041a \u0426", "\u0421\u041c\u041e\u041b\u0415\u041d\u0421\u041a \u0426\u0415\u041d\u0422\u0420\u0410\u041b\u042c\u041d\u042b\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2001758", "2001758", "\u041a\u0420\u041e\u041c\u0421\u041a\u0410\u042f", "\u041a\u0420\u041e\u041c\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001223", "2001223", "\u0426\u041e\u041d", "\u0426\u041e\u041d", "\u041c", null);
            RailwayStationsDataProvider.put("2001928", "2001928", "\u041e\u041f 24 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 24 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001752", "2001752", "\u0421\u0415\u041b\u0418\u0425\u041e\u0412\u041e", "\u0421\u0415\u041b\u0418\u0425\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000950", "2000950", "\u041e\u041f 53 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 53 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000990", "2000990", "\u041e\u041f 69 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 69 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001860", "2001860", "\u041e\u041f 73 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 73 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2003970", "2003970", "\u041e\u041f 81 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 81 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000588", "2000588", "\u041e\u041f 109 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 109 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001113", "2001113", "\u0411\u0415\u041b \u0411\u0415\u0420\u0415\u0413", "\u0411\u0415\u041b\u042b\u0415 \u0411\u0415\u0420\u0415\u0413\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000628", "2000628", "\u0411\u0415\u041b\u041e\u0411\u0415\u0420\u0415\u0416", "\u0411\u0415\u041b\u041e\u0411\u0415\u0420\u0415\u0416\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2003980", "2003980", "\u041e\u041f 126 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 126 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001342", "2001342", "\u0411\u0420\u042f\u041d \u0412\u041e\u0421\u0422", "\u0411\u0420\u042f\u041d\u0421\u041a-\u0412\u041e\u0421\u0422\u041e\u0427\u041d\u042b\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000641", "2000641", "\u041e\u041f 180 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 180 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000521", "2000521", "\u041e\u041b\u042c\u0425\u041e\u0412\u041a\u0410", "\u041e\u041b\u042c\u0425\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000572", "2000572", "\u041e\u041f 193 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 193 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001891", "2001891", "\u041f 205 \u041a\u041c", "\u041f\u041e\u0421\u0422 205 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001937", "2001937", "\u041f 210 \u041a\u041c", "\u041f\u041e\u0421\u0422 210 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000477", "2000477", "\u0411\u041f 217 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 217 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001054", "2001054", "\u0421\u0415\u0412\u0415\u0420\u041d\u0410\u042f", "\u0421\u0415\u0412\u0415\u0420\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000565", "2000565", "\u0417\u0410\u0412\u041e\u0414 \u041f\u0410\u0420\u041a", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u041e\u0419 \u041f\u0410\u0420\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000485", "2000485", "\u0425\u0418\u041c\u041a\u041e\u041c\u0411\u0418\u041d", "\u0425\u0418\u041c\u041a\u041e\u041c\u0411\u0418\u041d\u0410\u0422", "\u041c", null);
            RailwayStationsDataProvider.put("2000657", "2000657", "\u0413\u0420\u042d\u0421", "\u0413\u0420\u042d\u0421", "\u041c", null);
            RailwayStationsDataProvider.put("2001168", "2001168", "\u041a\u041b\u042e\u0427\u0415\u0412\u041a\u0410", "\u041a\u041b\u042e\u0427\u0415\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2002090", "2002090", "\u041e\u0422\u0414\u042b\u0425", "\u041e\u0422\u0414\u042b\u0425", "\u041c", null);
            RailwayStationsDataProvider.put("2000805", "2000805", "\u041a\u0420\u0410\u0422\u041e\u0412\u041e", "\u041a\u0420\u0410\u0422\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000875", "2000875", "\u041f\u041b 42 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 42 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000295", "2000295", "\u0424\u0410\u0411\u0420\u0418\u0427\u041d\u0410\u042f", "\u0424\u0410\u0411\u0420\u0418\u0427\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000347", "2000347", "\u0421\u041b\u0415\u041c\u042b", "\u0421\u041b\u0415\u041c\u042b", "\u041c", null);
            RailwayStationsDataProvider.put("2001189", "2001189", "\u0418\u0421\u0422\u041e\u0414\u041d\u0418\u041a\u0418", "\u0418\u0421\u0422\u041e\u0414\u041d\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000024", "2000024", "\u0425\u041e\u0414\u042b\u041d\u0418\u041d\u041e", "\u0425\u041e\u0414\u042b\u041d\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001244", "2001244", "\u0420\u042f\u0417\u0410\u041d\u042c \u0421\u041e\u0420", "\u0420\u042f\u0417\u0410\u041d\u042c-\u0421\u041e\u0420\u0422.", "\u041c", null);
            RailwayStationsDataProvider.put("2001249", "2001249", "\u0411\u041f 187 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 187 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000581", "2000581", "\u041d\u0415\u0414\u041e\u0421\u0422\u041e\u0415\u0412\u041e", "\u041d\u0415\u0414\u041e\u0421\u0422\u041e\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001273", "2001273", "\u0413\u0423\u0421\u0415\u0412\u0421\u041a\u0410\u042f", "\u0413\u0423\u0421\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001064", "2001064", "\u041b\u0410\u0413\u0415\u0420\u041d\u042b\u0419", "\u041b\u0410\u0413\u0415\u0420\u041d\u042b\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000622", "2000622", "\u041f\u0410\u0412\u041b  \u041f\u041e\u0421\u0422", "\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a\u0418\u0419 \u041f\u041e\u0421\u0422", "\u041c", null);
            RailwayStationsDataProvider.put("2001323", "2001323", "\u0411\u041f 204 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 204 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001308", "2001308", "\u041f\u041b 210 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 210 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001328", "2001328", "\u041e\u041f 216 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 216 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000459", "2000459", "\u041f\u041b 226 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 226 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2002968", "2002968", "\u041e\u041f 282 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 282 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000559", "2000559", "\u041f\u041b 293 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 293 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001402", "2001402", "\u041e\u041f 303 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 303 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001329", "2001329", "\u041f\u041b 308 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 308 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001092", "2001092", "\u041f 315\u041a\u041c", "\u041f\u041e\u0421\u0422 315 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001182", "2001182", "\u041b\u042e\u0411\u0415\u0420\u0426\u042b 2", "\u041b\u042e\u0411\u0415\u0420\u0426\u042b 2", "\u041c", null);
            RailwayStationsDataProvider.put("2001193", "2001193", "\u041e\u0412\u0420\u0410\u0416\u041a\u0418", "\u041e\u0412\u0420\u0410\u0416\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2002092", "2002092", "\u0420\u041e\u0414\u041d\u0418\u041a\u0418", "\u0420\u041e\u0414\u041d\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001227", "2001227", "\u0412\u042f\u041b\u041a\u0418", "\u0412\u042f\u041b\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001236", "2001236", "\u0425\u0420\u0418\u041f\u0410\u041d\u042c", "\u0425\u0420\u0418\u041f\u0410\u041d\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2000333", "2000333", "\u041e\u041f 41 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 41 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001284", "2001284", "\u0414\u041e\u041d\u0418\u041d\u041e", "\u0414\u041e\u041d\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001184", "2001184", "\u041f\u041b 49 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 49 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001056", "2001056", "\u041f\u041b 203 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 203 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001902", "2001902", "\u041e\u041f 210 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 210 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001178", "2001178", "\u0422\u0423\u0420\u041b\u0410\u0422\u041e\u0412\u041e", "\u0422\u0423\u0420\u041b\u0410\u0422\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000318", "2000318", "\u0417\u0415\u041b\u0415\u041d\u041e\u0412\u041e", "\u0417\u0415\u041b\u0415\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000903", "2000903", "\u041e\u041f 227 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 227 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001904", "2001904", "\u041e\u041f 231 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 231 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000562", "2000562", "\u041f\u0410\u0425\u041e\u0422\u0418\u041d\u041e", "\u041f\u0410\u0425\u041e\u0422\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001351", "2001351", "\u041f\u0415\u0420\u041a\u0418\u041d\u041e", "\u041f\u0415\u0420\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001349", "2001349", "\u041e\u041f 270 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 270 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001927", "2001927", "\u041a\u0420\u0423\u0422\u0418\u0426\u042b", "\u041a\u0420\u0423\u0422\u0418\u0426\u042b", "\u041c", null);
            RailwayStationsDataProvider.put("2000277", "2000277", "\u0411\u041e\u0420\u041e\u041a", "\u0411\u041e\u0420\u041e\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2001382", "2001382", "\u0412\u0410\u041d\u0427\u0423\u0420", "\u0412\u0410\u041d\u0427\u0423\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2000587", "2000587", "\u041e\u041f 322 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 322 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000743", "2000743", "\u041e\u041f 331 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 331 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001905", "2001905", "\u041e\u041f 350 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 350 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001906", "2001906", "\u041e\u041f 365 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 365 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001907", "2001907", "\u041e\u041f 376 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 376 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001908", "2001908", "\u041e\u041f 379 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 379 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001313", "2001313", "\u041f\u041b 383 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 383 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001909", "2001909", "\u0411\u041f 384 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 384 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000632", "2000632", "\u041f\u041b 386 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 386 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000518", "2000518", "\u041f\u041b 391 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 391 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001911", "2001911", "\u041f\u041b 395 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 395 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000742", "2000742", "\u041e\u041f 404 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 404 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000519", "2000519", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001772", "2001772", "\u041e\u041f 25 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 25 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2024082", "2024082", "\u041c\u041e\u0420\u0421\u041e\u0412\u041e", "\u041c\u041e\u0420\u0421\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2000734", "2000734", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000900", "2000900", "\u041d\u0415\u041a\u0420\u0410\u0421\u041e\u0412\u041a\u0410", "\u041d\u0415\u041a\u0420\u0410\u0421\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000736", "2000736", "\u041e\u0420\u0415\u0425\u041e\u0412\u041a\u0410", "\u041e\u0420\u0415\u0425\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001910", "2001910", "\u0418\u041b\u0415\u0411\u041d\u0418\u041a\u0418", "\u0418\u041b\u0415\u0411\u041d\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001912", "2001912", "\u041f\u041e\u0427\u0418\u041d\u041a\u0418", "\u041f\u041e\u0427\u0418\u041d\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000217", "2000217", "\u0428\u0415\u041c\u042f\u041a\u0418\u041d\u041e", "\u0428\u0415\u041c\u042f\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000737", "2000737", "\u0428\u041e\u0421\u0422\u042c\u0415", "\u0428\u041e\u0421\u0422\u042c\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2000738", "2000738", "\u0427\u0418\u041d\u0423\u0420", "\u0427\u0418\u041d\u0423\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2001913", "2001913", "\u041b\u041e\u041c", "\u041b\u041e\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001350", "2001350", "\u0421\u0422\u0420\u041e\u0418\u0422\u0415\u041b\u042c", "\u0421\u0422\u0420\u041e\u0418\u0422\u0415\u041b\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2002960", "2002960", "\u0427\u0415\u041b\u042e\u0421\u041a\u0418\u041d\u0421\u041a", "\u0427\u0415\u041b\u042e\u0421\u041a\u0418\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001435", "2001435", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u0421\u041a", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000585", "2000585", "\u041a\u041b\u042f\u0417\u042c\u041c\u0410", "\u041a\u041b\u042f\u0417\u042c\u041c\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000580", "2000580", "\u041c\u0410\u041c\u041e\u041d\u0422\u041e\u0412\u0421\u041a", "\u041c\u0410\u041c\u041e\u041d\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000035", "2000035", "\u041f\u0423\u0428\u041a\u0418\u041d\u041e", "\u041f\u0423\u0428\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000800", "2000800", "\u0417\u0410\u0412 \u0418\u041b\u042c\u0418\u0427\u0410", "\u0417\u0410\u0412\u0415\u0422\u042b \u0418\u041b\u042c\u0418\u0427\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000025", "2000025", "\u041f\u041e\u0414\u041b\u0418\u041f\u041a\u0418 \u0414", "\u041f\u041e\u0414\u041b\u0418\u041f\u041a\u0418 \u0414\u0410\u0427\u041d", "\u041c", null);
            RailwayStationsDataProvider.put("2002080", "2002080", "\u0411\u041e\u041b\u0428\u0415\u0412\u041e", "\u0411\u041e\u041b\u0428\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000012", "2000012", "\u0412\u0410\u041b\u0415\u041d\u0422\u0418\u041d\u041e\u0412", "\u0412\u0410\u041b\u0415\u041d\u0422\u0418\u041d\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000635", "2000635", "\u0417\u0410\u0413\u041e\u0420\u042f\u041d\u0421\u041a", "\u0417\u0410\u0413\u041e\u0420\u042f\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001880", "2001880", "\u0421\u041e\u041a\u041e\u041b\u041e\u0412\u0421\u041a", "\u0421\u041e\u041a\u041e\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000195", "2000195", "\u0412\u041e\u0420\u041e\u041d\u041e\u041a", "\u0412\u041e\u0420\u041e\u041d\u041e\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2001360", "2001360", "\u0429\u0415\u041b\u041a\u041e\u0412\u041e", "\u0429\u0415\u041b\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000914", "2000914", "\u0413\u0410\u0413\u0410\u0420\u0418\u041d\u0421\u041a", "\u0413\u0410\u0413\u0410\u0420\u0418\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001380", "2001380", "\u0427\u041a\u0410\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0427\u041a\u0410\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000740", "2000740", "\u0411\u0410\u0425\u0427\u0418\u0412\u0410\u041d\u0414", "\u0411\u0410\u0425\u0427\u0418\u0412\u0410\u041d\u0414\u0416\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000016", "2000016", "\u0426\u0418\u041e\u041b\u041a\u041e\u0412\u0421\u041a", "\u0426\u0418\u041e\u041b\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001148", "2001148", "\u041e\u0421\u0415\u0415\u0412\u0421\u041a\u0410\u042f", "\u041e\u0421\u0415\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001320", "2001320", "\u041c\u041e\u041d\u0418\u041d\u041e", "\u041c\u041e\u041d\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001942", "2001942", "\u041a\u0410\u0428\u0418\u041d\u041e", "\u041a\u0410\u0428\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000544", "2000544", "\u041a\u041e\u041b\u041e\u041d\u0422\u0410\u0415\u0412\u041e", "\u041a\u041e\u041b\u041e\u041d\u0422\u0410\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001915", "2001915", "\u041e\u041f 64 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 64 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000055", "2000055", "\u041e\u0414\u0418\u041d\u0426\u041e\u0412\u041e", "\u041e\u0414\u0418\u041d\u0426\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000570", "2000570", "\u041e\u0422\u0420\u0410\u0414\u041d \u0421\u041c", "\u041e\u0422\u0420\u0410\u0414\u041d\u041e\u0415 \u0421\u041c\u041e\u041b.", "\u041c", null);
            RailwayStationsDataProvider.put("2001029", "2001029", "\u041f\u0418\u041e\u041d\u0415\u0420\u0421\u041a\u0410\u042f", "\u041f\u0418\u041e\u041d\u0415\u0420\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000510", "2000510", "\u041f\u0415\u0420\u0425\u0423\u0428\u041a\u041e\u0412\u041e", "\u041f\u0415\u0420\u0425\u0423\u0428\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2002097", "2002097", "\u0417\u0414\u0420\u0410\u0412\u041d\u0418\u0426\u0410", "\u0417\u0414\u0420\u0410\u0412\u041d\u0418\u0426\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000830", "2000830", "\u0412\u042f\u0417\u042c\u041c\u0410", "\u0412\u042f\u0417\u042c\u041c\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000857", "2000857", "\u0421\u0410\u0424\u041e\u041d\u041e\u0412\u041e", "\u0421\u0410\u0424\u041e\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000840", "2000840", "\u042f\u0420\u0426\u0415\u0412\u041e", "\u042f\u0420\u0426\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001932", "2001932", "\u041e\u041f 232 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 232 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000469", "2000469", "\u041c\u0415\u0420\u041a\u0423\u0427\u0415\u0412\u041e", "\u041c\u0415\u0420\u041a\u0423\u0427\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001381", "2001381", "\u041d\u041e\u0412\u041e\u0415 \u0421\u0415\u041b\u041e", "\u041d\u041e\u0412\u041e\u0415 \u0421\u0415\u041b\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000626", "2000626", "\u041a\u041e\u041a\u041e\u0420\u0415\u0412\u041e", "\u041a\u041e\u041a\u041e\u0420\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001930", "2001930", "\u0412\u042f\u0417\u042c\u041c\u0410 \u041d\u041e\u0412", "\u0412\u042f\u0417\u042c\u041c\u0410-\u041d\u041e\u0412\u041e\u0422\u041e\u0420\u0416\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001769", "2001769", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001219", "2001219", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000938", "2000938", "\u041e\u041f 207 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 207 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000939", "2000939", "\u041e\u041f 214 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 214 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000941", "2000941", "\u041e\u041f 225 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 225 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001085", "2001085", "\u041b\u0415\u041d\u0418\u041d\u0413\u0420\u0410\u0414\u0421", "\u041b\u0415\u041d\u0418\u041d\u0413\u0420\u0410\u0414\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000720", "2000720", "\u041e\u041f\u0410\u041b\u0418\u0425\u0410", "\u041e\u041f\u0410\u041b\u0418\u0425\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001194", "2001194", "\u0410\u041d\u0418\u041a\u0415\u0415\u0412\u041a\u0410", "\u0410\u041d\u0418\u041a\u0415\u0415\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000460", "2000460", "\u041d\u0410\u0425\u0410\u0411\u0418\u041d\u041e", "\u041d\u0410\u0425\u0410\u0411\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001164", "2001164", "\u041c\u0410\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041c\u0410\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000205", "2000205", "\u0414\u0415\u0414\u041e\u0412\u0421\u041a", "\u0414\u0415\u0414\u041e\u0412\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000004", "2000004", "\u041c\u0418\u0418\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c\u0418\u0418\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000810", "2000810", "\u0421\u041d\u0415\u0413\u0418\u0420\u0418", "\u0421\u041d\u0418\u0413\u0418\u0420\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001824", "2001824", "\u041e\u041f 50 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 50 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001044", "2001044", "\u041c\u0410\u041d\u0418\u0425\u0418\u041d\u041e 1", "\u041c\u0410\u041d\u0418\u0425\u0418\u041d\u041e 1", "\u041c", null);
            RailwayStationsDataProvider.put("2001186", "2001186", "\u0422\u0420\u041e\u0418\u0426\u041a\u0410\u042f", "\u0422\u0420\u041e\u0418\u0426\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000620", "2000620", "\u0425\u041b\u0415\u0411\u041d\u0418\u041a\u041e\u0412", "\u0425\u041b\u0415\u0411\u041d\u0418\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001775", "2001775", "\u0428\u0415\u0420\u0415\u041c\u0415\u0422\u042c\u0415\u0412", "\u0428\u0415\u0420\u0415\u041c\u0415\u0422\u042c\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000115", "2000115", "\u041b\u041e\u0411\u041d\u042f", "\u041b\u041e\u0411\u041d\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2003966", "2003966", "\u0414\u0415\u041f\u041e", "\u0414\u0415\u041f\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001885", "2001885", "\u041b\u0423\u0413\u041e\u0412\u0410\u042f", "\u041b\u0423\u0413\u041e\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001179", "2001179", "\u041d\u0415\u041a\u0420\u0410\u0421\u041e\u0412\u0421\u041a", "\u041d\u0415\u041a\u0420\u0410\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000610", "2000610", "\u041a\u0410\u0422\u0423\u0410\u0420", "\u041a\u0410\u0422\u0423\u0410\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2000013", "2000013", "\u0422\u0420\u0423\u0414\u041e\u0412\u0410\u042f", "\u0422\u0420\u0423\u0414\u041e\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001068", "2001068", "\u041c\u041e\u0420\u041e\u0417\u041a\u0418", "\u041c\u041e\u0420\u041e\u0417\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2014449", "2014449", "\u0413\u041e\u0422\u041d\u042f", "\u0413\u041e\u0422\u041d\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2001982", "2001982", "\u0421\u0423\u0413\u0420\u041e\u0412", "\u0421\u0423\u0413\u0420\u041e\u0412", "\u041c", null);
            RailwayStationsDataProvider.put("2000452", "2000452", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2002906", "2002906", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000942", "2000942", "\u041e\u041f 585 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 585 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000943", "2000943", "\u041e\u041f 575 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 575 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000946", "2000946", "\u041e\u041f 463 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 463 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000457", "2000457", "\u041e\u041f 439 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 439 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000947", "2000947", "\u041e\u041f 427 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 427 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000631", "2000631", "\u041f\u041e\u0412\u0410\u0420\u041e\u0412\u041e 3", "\u041f\u041e\u0412\u0410\u0420\u041e\u0412\u041e 3", "\u041c", null);
            RailwayStationsDataProvider.put("2001956", "2001956", "\u0414\u0415\u041f\u041e", "\u0414\u0415\u041f\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000940", "2000940", "\u0416\u0418\u041b\u0418\u041d\u041e", "\u0416\u0418\u041b\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001957", "2001957", "\u041e\u041f 155 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 155 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000948", "2000948", "\u041e\u041f 159 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 159 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001864", "2001864", "\u041c\u0410\u041d\u0418\u0425\u0418\u041d\u041e 2", "\u041c\u0410\u041d\u0418\u0425\u0418\u041d\u041e 2", "\u041c", null);
            RailwayStationsDataProvider.put("2001849", "2001849", "\u041e\u041f 165 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 165 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001903", "2001903", "\u041b\u0423\u041a\u0418\u041d\u041e", "\u041b\u0423\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2002029", "2002029", "\u041e\u041f 174 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 174 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001958", "2001958", "\u041e\u041f 178 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 178 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001321", "2001321", "\u041e\u041f 183 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 183 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001922", "2001922", "\u0414\u042e\u0414\u042c\u041a\u041e\u0412\u041e", "\u0414\u042e\u0414\u042c\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000712", "2000712", "\u041e\u041f 189 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 189 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001961", "2001961", "\u041e\u041f 191 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 191 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001884", "2001884", "\u042f\u0421\u0422\u0420\u0415\u0411\u041a\u0418", "\u042f\u0421\u0422\u0420\u0415\u0411\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001962", "2001962", "\u041e\u041f 198 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 198 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001963", "2001963", "\u041e\u041f 214 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 214 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001118", "2001118", "\u0410\u041a\u0423\u041b\u041e\u0412\u041e", "\u0410\u041a\u0423\u041b\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2060336", "2060336", "\u041f\u0415\u0422\u0423\u0428\u041a\u0418", "\u041f\u0415\u0422\u0423\u0428\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2001406", "2001406", "\u041e\u041f 136 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 136 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001939", "2001939", "\u041e\u041f 128 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 128 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000716", "2000716", "\u0411\u0423\u0425\u0410\u0420\u041e\u0412\u041e", "\u0411\u0423\u0425\u0410\u0420\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001975", "2001975", "\u041e\u041f 120 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 120 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2002969", "2002969", "\u041e\u041f 115 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 115 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000502", "2000502", "\u0411\u0415\u041b\u042b\u0419 \u0420\u0410\u0421\u0422", "\u0411\u0415\u041b\u042b\u0419 \u0420\u0410\u0421\u0422", "\u041c", null);
            RailwayStationsDataProvider.put("2000642", "2000642", "\u041e\u041f 109 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 109 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001854", "2001854", "\u0421\u041d\u0418\u0416\u0410", "\u0421\u041d\u0418\u0416\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001007", "2001007", "\u0421\u0410\u041c\u0410\u0420\u0410 \u0420\u0410\u0414", "\u0421\u0410\u041c\u0410\u0420\u0410 \u0420\u0410\u0414\u0418\u0426\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000034", "2000034", "\u041a\u0420\u0410\u0421\u041d \u041f\u0420\u041e\u0424", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u041f\u0420\u041e\u0424\u0418\u041d\u0422\u0415\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2000520", "2000520", "\u0424\u0410\u0421\u041e\u041d\u041e\u041b\u0418\u0422", "\u0424\u0410\u0421\u041e\u041d\u041e\u041b\u0418\u0422\u0415\u0419\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001949", "2001949", "\u041e\u041f 147 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 147 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000017", "2000017", "\u0411\u041e\u0420\u0414\u0410\u0412\u0418\u0427\u0418", "\u0411\u041e\u0420\u0414\u0410\u0412\u0418\u0427\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001072", "2001072", "\u0425\u041e\u0422\u042b\u041b\u0415\u0412\u041e", "\u0425\u041e\u0422\u042b\u041b\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000358", "2000358", "\u041e\u041f 142 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 142 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001122", "2001122", "\u0414\u0418\u041d\u0410\u041c\u041e", "\u0414\u0418\u041d\u0410\u041c\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000556", "2000556", "\u041f\u041e\u0411\u0415\u0414\u0410", "\u041f\u041e\u0411\u0415\u0414\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001114", "2001114", "\u041f\u0418\u0420\u041e\u0413\u041e\u0412\u041e", "\u041f\u0418\u0420\u041e\u0413\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2002929", "2002929", "\u0421\u041e\u0424\u0420\u0418\u041d\u041e 2", "\u0421\u041e\u0424\u0420\u0418\u041d\u041e 2", "\u041c", null);
            RailwayStationsDataProvider.put("2001943", "2001943", "\u0420\u0410\u0425\u041c\u0410\u041d\u041e\u0412\u041e", "\u0420\u0410\u0425\u041c\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000497", "2000497", "\u0424\u0415\u0414\u041e\u0420\u041e\u0412\u0421\u041a", "\u0424\u0415\u0414\u041e\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000894", "2000894", "\u041f\u0423\u0422\u0418\u041b\u041e\u0412\u041e", "\u041f\u0423\u0422\u0418\u041b\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001326", "2001326", "\u041a\u0420\u0410\u0421\u041d\u041e\u0410\u0420\u041c", "\u041a\u0420\u0410\u0421\u041d\u041e\u0410\u0420\u041c\u0415\u0419\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000593", "2000593", "\u041e\u0421\u0410\u041d\u041e\u0412\u041e", "\u041e\u0421\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001876", "2001876", "\u041f\u041e\u0416\u041e\u0413\u0410", "\u041f\u041e\u0416\u041e\u0413\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001309", "2001309", "\u041e\u041f 29 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 29 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001879", "2001879", "\u0411\u0410\u0420\u041c\u0418\u041d\u041e", "\u0411\u0410\u0420\u041c\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001848", "2001848", "\u0421\u0410\u0417\u041e\u041d\u041e\u0412\u041e", "\u0421\u0410\u0417\u041e\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001422", "2001422", "\u041e\u041f 47 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 47 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2002974", "2002974", "\u0420\u042f\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u0420\u042f\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001759", "2001759", "\u041e\u041f 30 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 30 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001762", "2001762", "\u041e\u041f 38 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 38 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000482", "2000482", "\u041e\u0417\u0415\u0420\u042b", "\u041e\u0417\u0415\u0420\u042b", "\u041c", null);
            RailwayStationsDataProvider.put("2001071", "2001071", "\u0413\u0418\u041f\u0421\u041e\u0412\u042b\u0419", "\u0413\u0418\u041f\u0421\u041e\u0412\u042b\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2001136", "2001136", "\u0410\u042d\u0420\u041e\u0417\u041e\u041b\u042c\u041d", "\u0410\u042d\u0420\u041e\u0417\u041e\u041b\u042c\u041d\u042b\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2001895", "2001895", "\u0410\u041d\u0418\u041b\u0418\u041d\u041e\u0412\u0410\u042f", "\u0410\u041d\u0418\u041b\u0418\u041d\u041e\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000210", "2000210", "\u041c\u041e\u0421\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c\u041e\u0421\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001970", "2001970", "\u0420\u0423\u0411\u041b\u0415\u0412\u041e", "\u0420\u0423\u0411\u041b\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001990", "2001990", "\u041e\u0412\u0421\u042f\u041d\u0410\u042f", "\u041e\u0412\u0421\u042f\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001158", "2001158", "\u0414\u0415\u0412\u042f\u0422\u041e\u0415 \u042f\u041d", "\u0414\u0415\u0412\u042f\u0422\u041e\u0415 \u042f\u041d\u0412\u0410\u0420\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2002093", "2002093", "\u041e\u041f 12 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000583", "2000583", "\u0422\u0415\u0420\u0415\u0411\u0423\u0416", "\u0422\u0415\u0420\u0415\u0411\u0423\u0416", "\u041c", null);
            RailwayStationsDataProvider.put("2000561", "2000561", "\u041a\u041e\u0421\u041e\u0420\u0416\u0410", "\u041a\u041e\u0421\u041e\u0420\u0416\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000851", "2000851", "\u041e\u041f 42 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 42 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000629", "2000629", "\u041d\u0415\u0422\u0420\u0423\u0411\u0415\u0416", "\u041d\u0415\u0422\u0420\u0423\u0411\u0415\u0416", "\u041c", null);
            RailwayStationsDataProvider.put("2001997", "2001997", "\u041e\u041f 50 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 50 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001433", "2001433", "\u041a\u041e\u041b\u041f\u041d\u042b", "\u041a\u041e\u041b\u041f\u041d\u042b", "\u041c", null);
            RailwayStationsDataProvider.put("2001787", "2001787", "\u0421\u0415\u0419\u041c\u0421\u041a\u0410\u042f", "\u0421\u0415\u0419\u041c\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001324", "2001324", "\u041e\u041f 7 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 7 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001311", "2001311", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000627", "2000627", "\u0411\u0415\u041b\u041e\u0413\u041b\u0410\u0412\u0410\u042f", "\u0411\u0415\u041b\u041e\u0413\u041b\u0410\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000872", "2000872", "\u041e\u041f 26 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 26 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000579", "2000579", "\u0410\u041a\u0423\u041b\u0418\u0427\u0418", "\u0410\u041a\u0423\u041b\u0418\u0427\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000422", "2000422", "\u041a\u041b\u0415\u0422\u041d\u042f", "\u041a\u041b\u0415\u0422\u041d\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001204", "2001204", "\u041e\u041f 18 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 18 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000706", "2000706", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001853", "2001853", "\u041e\u041f 24 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 24 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001238", "2001238", "\u0421\u0422\u0410\u0420\u041e\u0414\u0423\u0411", "\u0421\u0422\u0410\u0420\u041e\u0414\u0423\u0411", "\u041c", null);
            RailwayStationsDataProvider.put("2000102", "2000102", "\u041e\u041f 14 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 14 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000464", "2000464", "\u0412\u0410\u0414\u0418\u041d\u041e", "\u0412\u0410\u0414\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000676", "2000676", "\u0418\u0412\u0410\u041d\u0418\u0421\u0418\u041d\u041e", "\u0418\u0412\u0410\u041d\u0418\u0421\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000542", "2000542", "\u042f\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u042f\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000279", "2000279", "\u0418\u0413\u041e\u0420\u0415\u0412\u0421\u041a\u0410\u042f", "\u0418\u0413\u041e\u0420\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000468", "2000468", "\u041a\u0410\u041d\u042e\u0422\u0418\u041d\u041e", "\u041a\u0410\u041d\u042e\u0422\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001444", "2001444", "\u041d\u0418\u041a\u0418\u0422\u0418\u041d\u041a\u0410", "\u041d\u0418\u041a\u0418\u0422\u0418\u041d\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000533", "2000533", "\u041e\u041f 67 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 67 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001412", "2001412", "\u0412\u041b\u0410\u0414 \u0422\u0423\u041f\u0418\u041a", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u0421\u041a\u0418\u0419 \u0422\u0423\u041f\u0418\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000658", "2000658", "\u0421\u0422\u0420\u0423\u041a\u041e\u0412\u041e", "\u0421\u0422\u0420\u0423\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000659", "2000659", "\u0414\u041e\u0420\u041e\u0413\u041e\u0411\u0423\u0416", "\u0414\u041e\u0420\u041e\u0413\u041e\u0411\u0423\u0416", "\u041c", null);
            RailwayStationsDataProvider.put("2001441", "2001441", "\u0410\u0417\u041e\u0422\u041d\u0410\u042f", "\u0410\u0417\u041e\u0422\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000472", "2000472", "\u041d\u041e\u0412\u041e\u0421\u041c\u041e\u041b\u0415\u041d", "\u041d\u041e\u0412\u041e\u0421\u041c\u041e\u041b\u0415\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001041", "2001041", "\u041f\u0410\u0420\u041a\u041e\u0412\u0410\u042f", "\u041f\u0410\u0420\u041a\u041e\u0412\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001348", "2001348", "\u0418\u0421\u0410\u041a\u041e\u0412\u041e", "\u0418\u0421\u0410\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001403", "2001403", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2002980", "2002980", "\u0424\u0410\u0411 1 \u041c\u0410\u042f", "\u0424\u0410\u0411\u0420\u0418\u041a\u0410 1 \u041c\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001117", "2001117", "\u0417\u0415\u041b\u0415\u041d \u0411\u041e\u0420", "\u0417\u0415\u041b\u0415\u041d\u042b\u0419 \u0411\u041e\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2001346", "2001346", "\u0418\u0412\u0410\u041d\u0422\u0415\u0415\u0412 2", "\u0418\u0412\u0410\u041d\u0422\u0415\u0415\u0412\u041a\u0410 2", "\u041c", null);
            RailwayStationsDataProvider.put("2001008", "2001008", "\u0418\u0412\u0410\u041d\u0422\u0415\u0415\u0412\u041a\u0410", "\u0418\u0412\u0410\u041d\u0422\u0415\u0415\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2001001", "2001001", "\u0414\u0415\u0422\u0421\u041a\u0410\u042f", "\u0414\u0415\u0422\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001935", "2001935", "\u0424\u0420\u042f\u0417\u0418\u041d\u041e", "\u0424\u0420\u042f\u0417\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000715", "2000715", "\u0424\u0420\u042f\u0417 \u041f\u0410\u0421\u0421", "\u0424\u0420\u042f\u0417\u0418\u041d\u041e \u041f\u0410\u0421\u0421", "\u041c", null);
            RailwayStationsDataProvider.put("2001269", "2001269", "\u0415\u0413\u041e\u0420\u042c\u0415\u0412\u0421\u041a1", "\u0415\u0413\u041e\u0420\u042c\u0415\u0412\u0421\u041a 1", "\u041c", null);
            RailwayStationsDataProvider.put("2000668", "2000668", "\u0421\u041e\u0420\u041e\u041a \u0411\u041e\u0420", "\u0421\u041e\u0420\u041e\u041a\u041e\u0412\u041e\u0419 \u0411\u041e\u0420", "\u041c", null);
            RailwayStationsDataProvider.put("2000683", "2000683", "\u041f\u0418\u041b\u0415\u0412\u041e", "\u041f\u0418\u041b\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2001777", "2001777", "\u041e\u041f 252 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 252 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000286", "2000286", "\u042f\u0421\u0410\u041a\u041e\u0412\u041e", "\u042f\u0421\u0410\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000806", "2000806", "\u041c\u041e\u041b\u041e\u0414\u0415\u0416\u041d\u0410\u042f", "\u041c\u041e\u041b\u041e\u0414\u0415\u0416\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001413", "2001413", "\u0417\u0410\u0414\u041e\u041d\u0421\u041a\u0410\u042f", "\u0417\u0410\u0414\u041e\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2001811", "2001811", "\u0421\u041e\u041a\u041e\u041b\u042c\u041d\u0418\u041a\u0418", "\u0421\u041e\u041a\u041e\u041b\u042c\u041d\u0418\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2001005", "2001005", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0410\u041b", "\u041c\u041e\u0421\u041a\u0412\u0410-\u041a\u0410\u041b\u0410\u041d\u0427\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000000", "2000000", "\u041c\u041e\u0421\u041a\u0412\u0410", "\u041c\u041e\u0421\u041a\u0412\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000174", "2000174", "\u0422\u0423\u041b\u0410", "\u0422\u0423\u041b\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000125", "2000125", "\u0420\u042f\u0417\u0410\u041d\u042c", "\u0420\u042f\u0417\u0410\u041d\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2000921", "2000921", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e\u0412", "\u041c", null);
            RailwayStationsDataProvider.put("2000427", "2000427", "\u0411\u0420\u042f\u041d\u0421\u041a", "\u0411\u0420\u042f\u041d\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2002905", "2002905", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001170", "2001170", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001888", "2001888", "\u041e\u0412\u0427\u0410\u0420\u041e\u0412\u041a\u0410", "\u041e\u0412\u0427\u0410\u0420\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2002977", "2002977", "\u041e\u041f 131 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 131 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2001161", "2001161", "\u0421\u0422\u0415\u041d\u042c\u041a\u0418\u041d\u041e2", "\u0421\u0422\u0415\u041d\u042c\u041a\u0418\u041d\u041e 2", "\u041c", null);
            RailwayStationsDataProvider.put("2001124", "2001124", "\u0422\u0423\u041b\u0410 \u041b\u0418\u0425\u0412", "\u0422\u0423\u041b\u0410-\u041b\u0418\u0425\u0412\u0418\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000281", "2000281", "\u0420\u0412\u042b", "\u0420\u0412\u042b", "\u041c", null);
            RailwayStationsDataProvider.put("2002979", "2002979", "\u0422\u0420\u0423\u0424\u0410\u041d\u041e\u0412\u041e", "\u0422\u0420\u0423\u0424\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000651", "2000651", "\u041c\u041e\u0421\u041a 2 \u041c\u0418\u0422", "\u041c\u041e\u0421\u041a\u0412\u0410 2 \u041c\u0418\u0422\u042c\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000841", "2000841", "\u0420\u042f\u0417 \u041e\u041a\u0410 \u041f\u0420", "\u0420\u042f\u0417\u0410\u041d\u042c-\u041e\u041a\u0410-\u041f\u0420\u0418\u0421\u0422\u0410\u041d\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2002009", "2002009", "\u0422\u0415\u0422\u041a\u0418\u041d\u041e", "\u0422\u0415\u0422\u041a\u0418\u041d\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2002007", "2002007", "\u041d\u0415\u041e\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u041d\u0415\u041e\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2002006", "2002006", "\u041a\u0420\u0423\u041f\u0415\u0426", "\u041a\u0420\u0423\u041f\u0415\u0426", "\u041c", null);
            RailwayStationsDataProvider.put("2002005", "2002005", "\u041b\u041e\u041a\u041e\u0422\u042c", "\u041b\u041e\u041a\u041e\u0422\u042c", "\u041c", null);
            RailwayStationsDataProvider.put("2030042", "2030042", "\u0414\u0420\u0423\u0416\u0418\u041d\u0418\u041d\u041e", "\u0414\u0420\u0423\u0416\u0418\u041d\u0418\u041d\u041e", "\u0415", null);
            RailwayStationsDataProvider.put("2061639", "2061639", "\u0421\u041e\u041b\u0414\u0410\u0422\u041a\u0410", "\u0421\u041e\u041b\u0414\u0410\u0422\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060061", "2060061", "\u0427\u0415\u0411\u041e\u0422\u0410\u0415\u0412\u041e", "\u0427\u0415\u0411\u041e\u0422\u0410\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060005", "2060005", "\u041a\u0418\u0420\u0413\u0418\u0428\u0410\u041d\u042b", "\u041a\u0418\u0420\u0413\u0418\u0428\u0410\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060562", "2060562", "\u0411\u0418\u0421\u0415\u0420\u0422 \u0417\u0410\u0412", "\u0411\u0418\u0421\u0415\u0420\u0422\u0421\u041a\u0418\u0419 \u0417\u0410\u0412\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060743", "2060743", "\u0428\u0410\u041d\u0413\u0418\u041d", "\u0428\u0410\u041d\u0413\u0418\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060561", "2060561", "\u041a\u041e\u041d\u0422\u0423\u0413\u0410\u041d\u041e\u0412", "\u041a\u041e\u041d\u0422\u0423\u0413\u0410\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060559", "2060559", "\u041a\u041b\u0415\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u041a\u041b\u0415\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060558", "2060558", "\u041a\u041b\u042e\u0427\u0415\u0412\u0410\u042f", "\u041a\u041b\u042e\u0427\u0415\u0412\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060557", "2060557", "\u0410\u0424\u0410\u041d\u0410\u0421\u042c\u0415\u0412", "\u0410\u0424\u0410\u041d\u0410\u0421\u042c\u0415\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060979", "2060979", "\u041e\u041f 1478 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1478 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060556", "2060556", "\u041e\u0421\u042b\u041f\u041b\u042f\u041d\u0421\u041a", "\u041e\u0421\u042b\u041f\u041b\u042f\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060555", "2060555", "\u0423\u0424\u0418\u041c\u041a\u0410", "\u0423\u0424\u0418\u041c\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060554", "2060554", "\u0417\u042e\u0420\u0417\u042f", "\u0417\u042e\u0420\u0417\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060741", "2060741", "\u0420\u0417\u0414 1441\u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 1441 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060610", "2060610", "\u041a\u0420\u0410\u0421\u041d\u041e\u0423\u0424\u0418\u041c", "\u041a\u0420\u0410\u0421\u041d\u041e\u0423\u0424\u0418\u041c\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060742", "2060742", "\u041a\u0410\u041c\u0415\u041d\u041d\u042b\u0419", "\u041a\u0410\u041c\u0415\u041d\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060553", "2060553", "\u0421\u0410\u0420\u0410\u041d \u0417\u0410\u0412", "\u0421\u0410\u0420\u0410\u041d\u0418\u041d\u0421\u041a\u0418\u0419 \u0417\u0410\u0412\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060552", "2060552", "\u041f\u0423\u0414\u041b\u0418\u041d\u0413\u041e\u0412", "\u041f\u0423\u0414\u041b\u0418\u041d\u0413\u041e\u0412\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060551", "2060551", "\u0427\u0415\u0420\u041d \u0420\u0415\u0427\u041a\u0410", "\u0427\u0415\u0420\u041d\u0410\u042f \u0420\u0415\u0427\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060549", "2060549", "\u041d\u0415\u041d\u0410\u0421\u0422\u042c\u0415", "\u041d\u0415\u041d\u0410\u0421\u0422\u042c\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060590", "2060590", "\u0427\u0410\u0414", "\u0427\u0410\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060548", "2060548", "\u0421\u0410\u0420\u0421", "\u0421\u0410\u0420\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060547", "2060547", "\u0411\u0410\u0420\u0422\u042b\u041c", "\u0411\u0410\u0420\u0422\u042b\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060546", "2060546", "\u0410\u0422\u0415\u0420", "\u0410\u0422\u0415\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060545", "2060545", "\u0429\u0423\u0427\u042c\u0415 \u041e\u0417\u0415\u0420", "\u0429\u0423\u0427\u042c\u0415 \u041e\u0417\u0415\u0420\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060544", "2060544", "\u0410\u0413\u0410\u0420\u0417\u042f", "\u0410\u0413\u0410\u0420\u0417\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060978", "2060978", "\u041e\u041f 1331 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1331 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060053", "2060053", "\u0422\u0420\u0423\u041d", "\u0422\u0420\u0423\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060739", "2060739", "\u0423\u041b\u042b\u041a", "\u0423\u041b\u042b\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060580", "2060580", "\u0427\u0415\u0420\u041d\u0423\u0428\u041a\u0410", "\u0427\u0415\u0420\u041d\u0423\u0428\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060698", "2060698", "\u0421\u0422\u0420\u0415\u0416", "\u0421\u0422\u0420\u0415\u0416", "\u0413", null);
            RailwayStationsDataProvider.put("2060031", "2060031", "\u041e\u0421\u0418\u041d \u0413\u041e\u0420\u0410", "\u041e\u0421\u0418\u041d\u041e\u0412\u0410\u042f \u0413\u041e\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061632", "2061632", "\u0411\u0418\u041a\u0411\u0410\u0420\u0414\u0418\u041d", "\u0411\u0418\u041a\u0411\u0410\u0420\u0414\u0418\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060570", "2060570", "\u041a\u0423\u0415\u0414\u0410", "\u041a\u0423\u0415\u0414\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060004", "2060004", "\u041a\u0418\u041d\u0427\u0410\u041a", "\u041a\u0418\u041d\u0427\u0410\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060977", "2060977", "\u041e\u041f 1253 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1253\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060543", "2060543", "\u0420\u0410\u0411\u0410\u041a", "\u0420\u0410\u0411\u0410\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061601", "2061601", "\u041a\u0423\u042e\u041a", "\u041a\u0423\u042e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060542", "2060542", "\u042f\u041d\u0410\u0423\u041b", "\u042f\u041d\u0410\u0423\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060735", "2060735", "\u0411\u0410\u0414\u0420\u042f\u0428", "\u0411\u0410\u0414\u0420\u042f\u0428", "\u0413", null);
            RailwayStationsDataProvider.put("2060649", "2060649", "\u042d\u041d\u0415\u0420\u0413\u0415\u0422\u0418\u041a", "\u042d\u041d\u0415\u0420\u0413\u0415\u0422\u0418\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060541", "2060541", "\u041a\u0410\u0420\u041c\u0410\u041d\u041e\u0412\u041e", "\u041a\u0410\u0420\u041c\u0410\u041d\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060539", "2060539", "\u0410\u041c\u0417\u042f", "\u0410\u041c\u0417\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061407", "2061407", "\u041a\u0410\u041c\u0411\u0410\u0420\u041a\u0410", "\u041a\u0410\u041c\u0411\u0410\u0420\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061427", "2061427", "\u041a\u0410\u041c\u0410", "\u041a\u0410\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060536", "2060536", "\u0428\u041e\u041b\u042c\u042f", "\u0428\u041e\u041b\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060535", "2060535", "\u0410\u0420\u041c\u042f\u0417\u042c", "\u0410\u0420\u041c\u042f\u0417\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060560", "2060560", "\u0421\u0410\u0420\u0410\u041f\u0423\u041b", "\u0421\u0410\u0420\u0410\u041f\u0423\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2061561", "2061561", "\u0428\u0415\u0412\u042b\u0420\u042f\u041b\u041e\u0412\u041e", "\u0428\u0415\u0412\u042b\u0420\u042f\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061473", "2061473", "\u0421 \u0417 \u0423\u0414\u041c\u0423\u0420\u0422", "\u0421-\u0417 \u0423\u0414\u041c\u0423\u0420\u0422\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061412", "2061412", "\u0411\u0423\u0413\u0420\u042b\u0428", "\u0411\u0423\u0413\u0420\u042b\u0428", "\u0413", null);
            RailwayStationsDataProvider.put("2061488", "2061488", "\u0421\u0423\u041d\u0414\u0423\u041a\u041e\u0412\u041e", "\u0421\u0423\u041d\u0414\u0423\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060534", "2060534", "\u041a\u0418\u0427\u0415\u0412\u041e", "\u041a\u0418\u0427\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061503", "2061503", "\u0423\u0421\u041f\u042c\u042f\u041d", "\u0423\u0421\u041f\u042c\u042f\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060533", "2060533", "\u0410\u0413\u0420\u042b\u0417", "\u0410\u0413\u0420\u042b\u0417", "\u0413", null);
            RailwayStationsDataProvider.put("2060950", "2060950", "\u041e\u041f 1079 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1079 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061516", "2061516", "\u0413\u041e\u0416\u041d\u042f", "\u0413\u041e\u0416\u041d\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060532", "2060532", "\u0423\u0420\u041e\u041c", "\u0423\u0420\u041e\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060100", "2060100", "\u041a\u0410\u0420\u0410\u041c\u0411\u0410\u0419", "\u041a\u0410\u0420\u0410\u041c\u0411\u0410\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060970", "2060970", "\u041e\u041f 1050 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1050 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060531", "2060531", "\u041f\u042b\u0427\u0410\u0421", "\u041f\u042b\u0427\u0410\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2061559", "2061559", "\u0427\u0423\u041c\u0410\u0419\u0422\u041b\u041e", "\u0427\u0423\u041c\u0410\u0419\u0422\u041b\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060550", "2060550", "\u041c\u041e\u0416\u0413\u0410", "\u041c\u041e\u0416\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060050", "2060050", "\u0421\u042e\u0413\u0410\u0418\u041b", "\u0421\u042e\u0413\u0410\u0418\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060529", "2060529", "\u041b\u042e\u0413\u0410", "\u041b\u042e\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061558", "2061558", "\u041c\u0423\u041b\u0422\u0410\u041d", "\u041c\u0423\u041b\u0422\u0410\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060528", "2060528", "\u0421\u0410\u0420\u041a\u0423\u0417", "\u0421\u0410\u0420\u041a\u0423\u0417", "\u0413", null);
            RailwayStationsDataProvider.put("2060527", "2060527", "\u042f\u0413\u0423\u041b", "\u042f\u0413\u0423\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060526", "2060526", "\u041a\u0418\u0417\u041d\u0415\u0420", "\u041a\u0418\u0417\u041d\u0415\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060701", "2060701", "\u041a\u041e\u0427\u0415\u0422\u041b\u041e", "\u041a\u041e\u0427\u0415\u0422\u041b\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061603", "2061603", "\u041e\u041f 962 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 962 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060629", "2060629", "\u0421\u041e\u0421\u041d\u041e\u0412\u041a\u0410", "\u0421\u041e\u0421\u041d\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060628", "2060628", "\u0417\u0410\u0421\u0422\u0420\u0423\u0413", "\u0417\u0410\u0421\u0422\u0420\u0423\u0413", "\u0413", null);
            RailwayStationsDataProvider.put("2060627", "2060627", "\u042f\u041c\u041d\u041e\u0415", "\u042f\u041c\u041d\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060907", "2060907", "\u041f\u041b 942 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 942 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060365", "2060365", "\u0412\u042f\u0422 \u041f\u041e\u041b\u042f\u041d\u042b", "\u0412\u042f\u0422\u0421\u041a\u0418\u0415 \u041f\u041e\u041b\u042f\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061579", "2061579", "\u0420\u0417\u0414 934 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 934 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060626", "2060626", "\u041a\u0423\u041a\u041c\u041e\u0420", "\u041a\u0423\u041a\u041c\u041e\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2061650", "2061650", "\u0411\u0420 \u041a\u041e\u041c\u0410\u0420\u041e\u0412", "\u0411\u0420\u0410\u0422\u042c\u042f \u041a\u041e\u041c\u0410\u0420\u041e\u0412\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061476", "2061476", "\u0421\u041e\u0421\u0422\u0410\u041c\u0410\u041a", "\u0421\u041e\u0421\u0422\u041e\u041c\u0410\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060969", "2060969", "\u041e\u041f 915 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 915 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061418", "2061418", "\u041a\u041e\u0418\u041d\u0421\u0410\u0420", "\u041a\u041e\u0418\u041d\u0421\u0410\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2061422", "2061422", "\u0418\u0428\u0422\u0423\u0413\u0410\u041d", "\u0418\u0428\u0422\u0423\u0413\u0410\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060625", "2060625", "\u0428\u0415\u041c\u041e\u0420\u0414\u0410\u041d", "\u0428\u0415\u041c\u041e\u0420\u0414\u0410\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2061537", "2061537", "\u041c\u0418\u041d\u0414\u042e\u0428", "\u041c\u0418\u041d\u0414\u042e\u0428", "\u0413", null);
            RailwayStationsDataProvider.put("2060968", "2060968", "\u041e\u041f 880 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 880\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060624", "2060624", "\u041a\u041e\u0420\u0421\u0410", "\u041a\u041e\u0420\u0421\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060967", "2060967", "\u041e\u041f 871 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 871 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061622", "2061622", "\u0427\u0415\u041a\u0423\u0420\u0427\u0410", "\u0427\u0415\u041a\u0423\u0420\u0427\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060623", "2060623", "\u0410\u0420\u0421\u041a", "\u0410\u0420\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060966", "2060966", "\u041f\u041b 849 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 849 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061471", "2061471", "\u0427\u0423\u041b\u041f\u0410\u041d\u041e\u0412\u041e", "\u0427\u0423\u041b\u041f\u0410\u041d\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061434", "2061434", "\u0427\u0423\u0420\u0418\u041b\u0418\u041d\u041e", "\u0427\u0423\u0420\u0418\u041b\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061436", "2061436", "\u041a\u0410\u041c\u0410\u0415\u0412\u041e", "\u041a\u0410\u041c\u0410\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060965", "2060965", "\u041e\u041f 835 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 835 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060622", "2060622", "\u041a\u0423\u0420\u041a\u0410\u0427\u0418", "\u041a\u0423\u0420\u041a\u0410\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060648", "2060648", "\u0427\u0415\u041f\u0427\u0423\u0413\u0418", "\u0427\u0415\u041f\u0427\u0423\u0413\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060964", "2060964", "\u041e\u041f 823 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 823\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060621", "2060621", "\u0411\u0418\u0420\u042e\u041b\u0418", "\u0411\u0418\u0420\u042e\u041b\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060647", "2060647", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410 \u0421", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410 \u0421\u0410\u041d\u0410\u0422\u041e\u0420\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060619", "2060619", "\u0412\u042b\u0421\u041e\u041a \u0413\u041e\u0420\u0410", "\u0412\u042b\u0421\u041e\u041a\u0410\u042f \u0413\u041e\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060618", "2060618", "\u041a\u0415\u041d\u0414\u0415\u0420\u0418", "\u041a\u0415\u041d\u0414\u0415\u0420\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060963", "2060963", "\u041e\u041f 807 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 807 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061430", "2061430", "\u041e\u041f 804 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 804 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060617", "2060617", "\u0414\u0415\u0420\u0411\u042b\u0428\u041a\u0418", "\u0414\u0415\u0420\u0411\u042b\u0428\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2062435", "2062435", "\u041a\u041e\u041c\u041f\u0420\u0415\u0421\u0421\u041e\u0420", "\u041a\u041e\u041c\u041f\u0420\u0415\u0421\u0421\u041e\u0420\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061555", "2061555", "\u041d\u041e\u0412\u0410\u0422\u041e\u0420\u041e\u0412", "\u041d\u041e\u0412\u0410\u0422\u041e\u0420\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2061402", "2061402", "\u041e\u041c\u0415\u0422\u042c\u0415\u0412\u041e", "\u041e\u041c\u0415\u0422\u042c\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061419", "2061419", "\u041e\u041c\u0415\u0422\u042c\u0415\u0412\u041e-2", "\u041e\u041c\u0415\u0422\u042c\u0415\u0412\u041e-2", "\u0413", null);
            RailwayStationsDataProvider.put("2061401", "2061401", "\u0412\u0410\u0425\u0418\u0422\u041e\u0412\u041e", "\u0412\u0410\u0425\u0418\u0422\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060500", "2060500", "\u041a\u0410\u0417\u0410\u041d\u042c \u041f\u0410\u0421", "\u041a\u0410\u0417\u0410\u041d\u042c \u041f\u0410\u0421\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060062", "2060062", "\u0410\u0414\u041c \u0421\u041b\u041e\u0411\u041e\u0414", "\u0410\u0414\u041c\u0418\u0420\u0410\u041b\u0422\u0415\u0419\u0421\u041a\u0410\u042f \u0421\u041b\u041e\u0411\u041e\u0414\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060753", "2060753", "\u041b\u0410\u0413\u0415\u0420\u041d\u0410\u042f", "\u041b\u0410\u0413\u0415\u0420\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060633", "2060633", "\u041b\u0410\u0413\u0415\u0420\u041d\u0410\u042f", "\u041b\u0410\u0413\u0415\u0420\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060059", "2060059", "\u0421\u0422\u0410\u0420 \u0410\u0420\u0410\u041a\u0427", "\u0421\u0422\u0410\u0420\u041e\u0415 \u0410\u0420\u0410\u041a\u0427\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060056", "2060056", "\u041d\u041e\u0412 \u0410\u0420\u0410\u041a\u0427", "\u041d\u041e\u0412\u041e\u0415 \u0410\u0420\u0410\u041a\u0427\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060616", "2060616", "\u042e\u0414\u0418\u041d\u041e", "\u042e\u0414\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062442", "2062442", "\u0412\u0420\u0414", "\u0412\u0420\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2061610", "2061610", "\u0417\u0410\u0419\u041c\u0418\u0429\u0415", "\u0417\u0410\u0419\u041c\u0418\u0429\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061585", "2061585", "\u041e\u0411\u0421\u0415\u0420\u0412\u0410\u0422\u041e\u0420", "\u041e\u0411\u0421\u0415\u0420\u0412\u0410\u0422\u041e\u0420\u0418\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060959", "2060959", "\u041f\u041b 774 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 774\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060958", "2060958", "\u041e\u041f 771 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 771\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061423", "2061423", "\u0412\u0410\u0421\u0418\u041b\u042c\u0415\u0412\u041e", "\u0412\u0410\u0421\u0418\u041b\u042c\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060913", "2060913", "\u041e\u041f 766 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 766 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061550", "2061550", "\u0410\u0422\u041b\u0410\u0428\u041a\u0418\u041d\u041e", "\u0410\u0422\u041b\u0410\u0428\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060345", "2060345", "\u0417\u0415\u041b\u0415\u041d \u0414\u041e\u041b", "\u0417\u0415\u041b\u0415\u041d\u042b\u0419 \u0414\u041e\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060646", "2060646", "\u0412\u041e\u041b\u0413\u0410 \u041f\u041e\u0421\u0422", "\u0412\u041e\u041b\u0413\u0410 \u041f\u041e\u0421\u0422", "\u0413", null);
            RailwayStationsDataProvider.put("2060957", "2060957", "\u041e\u041f 753 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 753\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060587", "2060587", "\u0421\u0412\u0418\u042f\u0416\u0421\u041a", "\u0421\u0412\u0418\u042f\u0416\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060956", "2060956", "\u041f\u041b 746 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 746 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061522", "2061522", "\u0428\u0418\u0420\u0414\u0410\u041d\u042b", "\u0428\u0418\u0420\u0414\u0410\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061647", "2061647", "\u0412\u041e\u0420\u041e\u0411\u042c\u0415\u0412\u0421\u041a", "\u0412\u041e\u0420\u041e\u0411\u042c\u0415\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060586", "2060586", "\u0422\u042e\u0420\u041b\u0415\u041c\u0410", "\u0422\u042e\u0420\u041b\u0415\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061607", "2061607", "\u041e\u041f 722 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 722 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061481", "2061481", "\u0427\u0415\u0428\u041b\u0410\u041c\u0410", "\u0427\u0415\u0428\u041b\u0410\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061551", "2061551", "\u0422\u0410\u041d\u0421\u0410\u0420\u0418\u041d\u041e", "\u0422\u0410\u041d\u0421\u0410\u0420\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060585", "2060585", "\u0423\u0420\u041c\u0410\u0420\u042b", "\u0423\u0420\u041c\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061514", "2061514", "\u0427\u0423\u0411\u0410\u0415\u0412\u041e", "\u0427\u0423\u0411\u0410\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060645", "2060645", "\u0411\u0410\u0422\u0415\u0415\u0412\u041e", "\u0411\u0410\u0422\u0415\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060584", "2060584", "\u0428\u041e\u0420\u041a\u0418\u0421\u0422\u0420\u042b", "\u0428\u041e\u0420\u041a\u0418\u0421\u0422\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061536", "2061536", "\u041f\u041b 684 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 684 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061557", "2061557", "\u041a\u0418\u0411\u0415\u0427\u0418", "\u041a\u0418\u0411\u0415\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060671", "2060671", "\u0410\u041b\u0415\u0428\u0415\u0412\u041e", "\u0410\u041b\u0415\u0428\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060630", "2060630", "\u041a\u0410\u041d\u0410\u0428", "\u041a\u0410\u041d\u0410\u0428", "\u0413", null);
            RailwayStationsDataProvider.put("2060954", "2060954", "\u041e\u041f 661 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 661 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061498", "2061498", "\u041c\u041e\u041a\u0420\u042b", "\u041c\u041e\u041a\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060953", "2060953", "\u041e\u041f 652 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 652 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060437", "2060437", "\u0410\u0427\u0410\u041a\u0421", "\u0410\u0427\u0410\u041a\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060952", "2060952", "\u041e\u041f 645 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 645 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060436", "2060436", "\u0410\u041f\u041d\u0415\u0420\u041a\u0410", "\u0410\u041f\u041d\u0415\u0420\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060951", "2060951", "\u041e\u041f 632 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 632\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060435", "2060435", "\u0412\u0423\u0420\u041d\u0410\u0420\u042b", "\u0412\u0423\u0420\u041d\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2062599", "2062599", "\u041e\u041f 623 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 623 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060434", "2060434", "\u0427\u0410\u0420\u041a\u041b\u0418", "\u0427\u0410\u0420\u041a\u041b\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061598", "2061598", "\u041e\u041f 614 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 614 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060433", "2060433", "\u041f\u0418\u041d\u0415\u0420", "\u041f\u0418\u041d\u0415\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2062597", "2062597", "\u041e\u041f 604 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 604 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060432", "2060432", "\u041c\u042b\u0421\u041b\u0415\u0426", "\u041c\u042b\u0421\u041b\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2060431", "2060431", "\u0428\u0423\u041c\u0415\u0420\u041b\u042f", "\u0428\u0423\u041c\u0415\u0420\u041b\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060014", "2060014", "\u041a\u0423\u041c\u0410\u0428\u041a\u0410", "\u041a\u0423\u041c\u0410\u0428\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060429", "2060429", "\u041a\u041d\u042f\u0416\u0418\u0425\u0410", "\u041a\u041d\u042f\u0416\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060428", "2060428", "\u041f\u0418\u041b\u042c\u041d\u0410", "\u041f\u0418\u041b\u042c\u041d\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060699", "2060699", "\u042e\u041c\u041e\u0420\u0413\u0410", "\u042e\u041c\u041e\u0420\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061404", "2061404", "\u0410\u041d\u0414\u041e\u0421\u041e\u0412\u041e", "\u0410\u041d\u0414\u041e\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062596", "2062596", "\u041e\u041f 538 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 538 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060427", "2060427", "\u0410\u0427\u041a\u0410", "\u0410\u0427\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060410", "2060410", "\u0421\u0415\u0420\u0413\u0410\u0427", "\u0421\u0415\u0420\u0413\u0410\u0427", "\u0413", null);
            RailwayStationsDataProvider.put("2060426", "2060426", "\u0422\u0410\u0420\u0422\u0410\u041b\u0415\u0419", "\u0422\u0410\u0420\u0422\u0410\u041b\u0415\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061577", "2061577", "\u041a\u0410\u041c\u041a\u0418\u041d\u041e", "\u041a\u0410\u041c\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060425", "2060425", "\u041a\u0410\u041c\u0415\u041d\u0418\u0429\u0415", "\u041a\u0410\u041c\u0415\u041d\u0418\u0429\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060424", "2060424", "\u0421\u041c\u0410\u0413\u0418\u041d\u041e", "\u0421\u041c\u0410\u0413\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061003", "2061003", "\u041a\u0415\u041c\u0410\u0420\u042b", "\u041a\u0415\u041c\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060423", "2060423", "\u041f\u0415\u0420\u0415\u0412\u041e\u0417\u0421\u041a\u0410", "\u041f\u0415\u0420\u0415\u0412\u041e\u0417\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061646", "2061646", "\u0420\u0415\u0412\u0415\u0417\u0415\u041d\u042c", "\u0420\u0415\u0412\u0415\u0417\u0415\u041d\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060422", "2060422", "\u0412\u0410\u0414\u041e\u041a", "\u0412\u0410\u0414\u041e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060421", "2060421", "\u0411\u041e\u0411\u042b\u041b\u042c\u0421\u041a\u0410\u042f", "\u0411\u041e\u0411\u042b\u041b\u042c\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061656", "2061656", "\u0429\u0415\u0414\u0420\u041e\u0412\u041a\u0410", "\u0429\u0415\u0414\u0420\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060052", "2060052", "\u0422\u0420\u0410\u041a\u0422 \u0410\u0420\u0417", "\u0422\u0420\u0410\u041a\u0422\u041e\u0412\u042b\u0419-\u0410\u0420\u0417\u0410\u041c\u0410\u0421\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060390", "2060390", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421 2", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421 2", "\u0413", null);
            RailwayStationsDataProvider.put("2061623", "2061623", "\u041e\u041f 409 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 409 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2062595", "2062595", "\u041e\u041f 408 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 408 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060673", "2060673", "\u0421\u041b\u0415\u0417\u0410\u0412\u041a\u0410", "\u0421\u041b\u0415\u0417\u0410\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061542", "2061542", "\u0428\u0423\u041c\u041b\u0415\u0419\u041a\u0410", "\u0428\u0423\u041c\u041b\u0415\u0419\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060395", "2060395", "\u041a\u041e\u0421\u0422\u042b\u041b\u0418\u0425\u0410", "\u041a\u041e\u0421\u0422\u042b\u041b\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061594", "2061594", "\u041e\u041f 386 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 386\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060747", "2060747", "\u041c\u0410\u042f\u041a", "\u041c\u0410\u042f\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060394", "2060394", "\u0411\u0410\u041b\u0410\u0425\u041e\u041d\u0418\u0425\u0410", "\u0411\u0410\u041b\u0410\u0425\u041e\u041d\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061599", "2061599", "\u041b\u0418\u0427\u0410\u0414\u0415\u0415\u0412\u041e", "\u041b\u0418\u0427\u0410\u0414\u0415\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060393", "2060393", "\u041c\u0423\u0425\u0422\u041e\u041b\u041e\u0412\u041e", "\u041c\u0423\u0425\u0422\u041e\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061491", "2061491", "\u0421\u0410\u041a\u041e\u041d\u042b", "\u0421\u0410\u041a\u041e\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060392", "2060392", "\u0412\u0415\u041d\u0415\u0426", "\u0412\u0415\u041d\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2060702", "2060702", "\u0412\u0415\u0420\u0414\u0415\u0415\u0412\u041a\u0410", "\u0412\u0415\u0420\u0414\u0415\u0415\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060391", "2060391", "\u0422\u0415\u0428\u0410", "\u0422\u0415\u0428\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061405", "2061405", "\u0421\u0422\u0415\u041f\u0423\u0420\u0418\u041d\u041e", "\u0421\u0422\u0415\u041f\u0423\u0420\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060643", "2060643", "\u0412\u0410\u041b\u0422\u041e\u0412\u041e", "\u0412\u0410\u041b\u0422\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062593", "2062593", "\u041e\u041f 324 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 324 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060685", "2060685", "\u0420\u041e\u0414\u042f\u041a\u041e\u0412\u041e", "\u0420\u041e\u0414\u042f\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061556", "2061556", "\u0421\u041e\u041d\u0418\u041d\u041e", "\u0421\u041e\u041d\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060389", "2060389", "\u0412\u0415\u041b\u0415\u0422\u042c\u041c\u0410", "\u0412\u0415\u041b\u0415\u0422\u042c\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2062592", "2062592", "\u041f\u041b 306 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 306 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060380", "2060380", "\u041d\u0410\u0412\u0410\u0428\u0418\u041d\u041e", "\u041d\u0410\u0412\u0410\u0428\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060783", "2060783", "\u041f\u0420\u0418\u041e\u041a\u0421\u041a\u0418\u0419", "\u041f\u0420\u0418\u041e\u041a\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061520", "2061520", "\u0413\u041e\u0420\u041e\u0414\u0421\u041a\u0410\u042f", "\u0413\u041e\u0420\u041e\u0414\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060370", "2060370", "\u041c\u0423\u0420\u041e\u041c 1", "\u041c\u0423\u0420\u041e\u041c 1", "\u0413", null);
            RailwayStationsDataProvider.put("2061724", "2061724", "\u041f\u041b 284 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 284 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061444", "2061444", "\u041a\u041e\u041b\u042c\u0414\u0418\u041d\u041e", "\u041a\u041e\u041b\u042c\u0414\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060710", "2060710", "\u0421\u0422\u0420\u0418\u0413\u0418\u041d\u041e", "\u0421\u0422\u0420\u0418\u0413\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060642", "2060642", "\u041f\u0420\u041e\u0421\u0418\u041d\u0421\u041a\u041e\u0415", "\u041f\u0420\u041e\u0421\u0418\u041d\u0421\u041a\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061403", "2061403", "\u0410\u041c\u041e\u0421\u041e\u0412\u041e", "\u0410\u041c\u041e\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061528", "2061528", "\u041f\u0410\u041f\u0423\u041b\u0418\u041d\u041e", "\u041f\u0410\u041f\u0423\u041b\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061479", "2061479", "\u041a\u041e\u041d\u0414\u0410\u041a\u041e\u0412\u041e", "\u041a\u041e\u041d\u0414\u0410\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060775", "2060775", "\u041b\u0415\u0412\u0418\u041d\u041e", "\u041b\u0415\u0412\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061421", "2061421", "\u0417\u0418\u041c\u041d\u0418\u0426\u042b", "\u0417\u0418\u041c\u041d\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060385", "2060385", "\u0411\u0423\u0422\u042b\u041b\u0418\u0426\u042b", "\u0411\u0423\u0422\u042b\u041b\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061451", "2061451", "\u041c\u0410\u041a\u0421\u0418\u041c\u041e\u0412\u0421\u041a", "\u041c\u0410\u041a\u0421\u0418\u041c\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060384", "2060384", "\u0414\u041e\u0411\u0420\u042f\u0422\u0418\u041d\u041e", "\u0414\u041e\u0411\u0420\u042f\u0422\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060383", "2060383", "\u0410\u041b\u0424\u0415\u0420\u041e\u0412\u041e", "\u0410\u041b\u0424\u0415\u0420\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062591", "2062591", "\u041f\u041b 232 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 232 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060382", "2060382", "\u0417\u041e\u041b\u041e\u0422\u041a\u041e\u0412\u0421\u041a", "\u0417\u041e\u041b\u041e\u0422\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060381", "2060381", "\u0417\u0410\u041a\u041e\u041b\u041f\u042c\u0415", "\u0417\u0410\u041a\u041e\u041b\u041f\u042c\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060712", "2060712", "\u0412\u0415\u041a\u041e\u0412\u041a\u0410", "\u0412\u0415\u041a\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060374", "2060374", "\u041d\u0415\u0427\u0410\u0415\u0412\u0421\u041a\u0410\u042f", "\u041d\u0415\u0427\u0410\u0415\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060024", "2060024", "\u041c\u0418\u041b\u042c\u0426\u0415\u0412\u041e", "\u041c\u0418\u041b\u042c\u0426\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060376", "2060376", "\u0422\u041e\u0420\u0424\u041e\u041f\u0420\u041e\u0414", "\u0422\u041e\u0420\u0424\u041e\u041f\u0420\u041e\u0414\u0423\u041a\u0422", "\u0413", null);
            RailwayStationsDataProvider.put("2060375", "2060375", "\u0418\u041b\u042c\u0418\u0427\u0415\u0412", "\u0418\u041b\u042c\u0418\u0427\u0415\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2060748", "2060748", "\u0422\u0410\u0421\u0418\u041d", "\u0422\u0410\u0421\u0418\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060049", "2060049", "\u0421\u0422\u0420\u0423\u042f", "\u0421\u0422\u0420\u0423\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2030001", "2030001", "\u0427\u0415\u041f\u0426\u0410", "\u0427\u0415\u041f\u0426\u0410", "\u0415", null);
            RailwayStationsDataProvider.put("2060448", "2060448", "\u041f 1217 \u041a\u041c", "\u041f\u041e\u0421\u0422 1217 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060507", "2060507", "\u041f\u0418\u0411\u0410\u041d\u042c\u0428\u0423\u0420", "\u041f\u0418\u0411\u0410\u041d\u042c\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2061410", "2061410", "\u0428\u0423\u0420", "\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060762", "2060762", "\u0414\u0418\u041d\u042c\u0428\u0423\u0420", "\u0414\u0418\u041d\u042c\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060506", "2060506", "\u0411\u0410\u041b\u0415\u0417\u0418\u041d\u041e", "\u0411\u0410\u041b\u0415\u0417\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060906", "2060906", "\u041e\u041f 1185 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1185 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061511", "2061511", "\u0422\u0423\u041a\u0422\u042b\u041c", "\u0422\u0423\u041a\u0422\u042b\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060905", "2060905", "\u041e\u041f 1177 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1177 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061609", "2061609", "\u0411\u0415\u0417\u0423\u041c", "\u0411\u0415\u0417\u0423\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060904", "2060904", "\u041e\u041f 1169 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1169 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060530", "2060530", "\u0413\u041b\u0410\u0417\u041e\u0412", "\u0413\u041b\u0410\u0417\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2060668", "2060668", "\u0423\u0411\u042b\u0422\u042c", "\u0423\u0411\u042b\u0422\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060903", "2060903", "\u041e\u041f 1150\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1150 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060902", "2060902", "\u041e\u041f 1147 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1147 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060505", "2060505", "\u041a\u041e\u0416\u0418\u041b\u042c", "\u041a\u041e\u0416\u0418\u041b\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060674", "2060674", "\u0411\u0410\u041b\u042b\u0428\u0423\u0420", "\u0411\u0410\u041b\u042b\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060667", "2060667", "\u0414\u0418\u0417\u042c\u041c\u0418\u041d\u041e", "\u0414\u0418\u0417\u042c\u041c\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060490", "2060490", "\u042f\u0420", "\u042f\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060641", "2060641", "\u0411\u0410\u0427\u0423\u041c\u041e\u0412\u041e", "\u0411\u0410\u0427\u0423\u041c\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061541", "2061541", "\u0421\u0410\u0414\u0410", "\u0421\u0410\u0414\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060688", "2060688", "\u041a\u041d\u042f\u0417\u0418", "\u041a\u041d\u042f\u0417\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060502", "2060502", "\u0424\u0410\u041b\u0415\u041d\u041a\u0418", "\u0424\u0410\u041b\u0415\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061502", "2061502", "\u041b\u0415\u0412\u0410\u041d\u042b", "\u041b\u0415\u0412\u0410\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061662", "2061662", "\u0427\u0415\u0420\u041d\u041e\u0423\u0421", "\u0427\u0415\u0420\u041d\u041e\u0423\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060501", "2060501", "\u041a\u041e\u0421\u0410", "\u041a\u041e\u0421\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060480", "2060480", "\u0417\u0423\u0415\u0412\u041a\u0410", "\u0417\u0423\u0415\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061517", "2061517", "\u041a\u041e\u0420\u0414\u042f\u0413\u0410", "\u041a\u041e\u0420\u0414\u042f\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061461", "2061461", "\u0420\u0415\u0425\u0418\u041d\u041e", "\u0420\u0415\u0425\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061548", "2061548", "\u0411\u0415\u0420\u0415\u0413\u041e\u0412\u041e\u0419", "\u0411\u0415\u0420\u0415\u0413\u041e\u0412\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060499", "2060499", "\u0410\u0420\u0414\u0410\u0428\u0418", "\u0410\u0420\u0414\u0410\u0428\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061546", "2061546", "\u041e\u041f 1021 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1021 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061624", "2061624", "\u041b\u0423\u0413\u041e\u0412\u041e\u0419", "\u041b\u0423\u0413\u041e\u0412\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061574", "2061574", "\u041a\u041e\u041d\u042b\u041f", "\u041a\u041e\u041d\u042b\u041f", "\u0413", null);
            RailwayStationsDataProvider.put("2060498", "2060498", "\u041f\u0420\u041e\u0421\u041d\u0418\u0426\u0410", "\u041f\u0420\u041e\u0421\u041d\u0418\u0426\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060497", "2060497", "\u0411\u0423\u041c\u041a\u041e\u041c\u0411\u0418\u041d", "\u0411\u0423\u041c\u041a\u041e\u041c\u0411\u0418\u041d\u0410\u0422", "\u0413", null);
            RailwayStationsDataProvider.put("2060721", "2060721", "\u041c\u0423\u0422\u041d\u0418\u0426\u0410", "\u041c\u0423\u0422\u041d\u0418\u0426\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060037", "2060037", "\u041f\u041e\u041b\u041e\u0419", "\u041f\u041e\u041b\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060479", "2060479", "\u041f\u041e\u0417\u0414\u0418\u041d\u041e", "\u041f\u041e\u0417\u0414\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060764", "2060764", "\u041a\u0420\u0410\u0421\u041d\u041e\u0421\u0415\u041b", "\u041a\u0420\u0410\u0421\u041d\u041e\u0421\u0415\u041b\u042c\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060600", "2060600", "\u041a\u0418\u0420\u041e\u0412 \u041f\u0410\u0421\u0421", "\u041a\u0418\u0420\u041e\u0412 \u041f\u0410\u0421\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060887", "2060887", "\u041e\u041f 951 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 951 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2062428", "2062428", "\u0427\u0423\u0425\u041b\u041e\u041c\u0418\u041d\u0421\u041a", "\u0427\u0423\u0425\u041b\u041e\u041c\u0418\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060659", "2060659", "\u041b\u042f\u041d\u0413\u0410\u0421\u042b", "\u041b\u042f\u041d\u0413\u0410\u0421\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060478", "2060478", "\u041b\u042f\u041d\u0413\u0410\u0421\u041e\u0412\u041e", "\u041b\u042f\u041d\u0413\u0410\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062438", "2062438", "\u0426\u0410\u041f\u0415\u041b\u0418", "\u0426\u0410\u041f\u0415\u041b\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060477", "2060477", "\u0421\u0422\u0420\u0418\u0416\u0418", "\u0421\u0422\u0420\u0418\u0416\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061649", "2061649", "\u0421\u041e\u0426\u0418\u0410\u041b\u0418\u0421\u0422", "\u0421\u041e\u0426\u0418\u0410\u041b\u0418\u0421\u0422\u0418\u0427", "\u0413", null);
            RailwayStationsDataProvider.put("2060476", "2060476", "\u041e\u0420\u0418\u0427\u0418", "\u041e\u0420\u0418\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061620", "2061620", "\u041e\u041f 907 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 907 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060475", "2060475", "\u0428\u0410\u041b\u0415\u0413\u041e\u0412\u041e", "\u0428\u0410\u041b\u0415\u0413\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061619", "2061619", "\u041e\u041f 901 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 901 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060474", "2060474", "\u0411\u042b\u0421\u0422\u0420\u042f\u0413\u0418", "\u0411\u042b\u0421\u0422\u0420\u042f\u0413\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060473", "2060473", "\u041c\u0410\u0420\u0410\u0414\u042b\u041a\u041e\u0412", "\u041c\u0410\u0420\u0410\u0414\u042b\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060639", "2060639", "\u041c\u041e\u041a\u0420\u0418\u0426\u042b", "\u041e\u0411\u041f \u041c\u041e\u041a\u0420\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060450", "2060450", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u04271", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u0427 1", "\u0413", null);
            RailwayStationsDataProvider.put("2061614", "2061614", "\u0414\u0410\u0420\u041e\u0412\u0418\u0426\u0410", "\u0414\u0410\u0420\u041e\u0412\u0418\u0426\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061634", "2061634", "\u0420\u041e\u041d\u0416\u0418\u041d\u041e", "\u0420\u041e\u041d\u0416\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060472", "2060472", "\u0410\u0426\u0412\u0415\u0416", "\u0410\u0426\u0412\u0415\u0416", "\u0413", null);
            RailwayStationsDataProvider.put("2060120", "2060120", "\u041a\u0410\u041f\u0418\u0414\u0410\u041d\u0426\u042b", "\u041a\u0410\u041f\u0418\u0414\u0410\u041d\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060471", "2060471", "\u042e\u041c\u0410", "\u042e\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060388", "2060388", "\u0421\u0422\u0420\u041e\u0419\u0414\u0415\u0422\u0410\u041b", "\u0421\u0422\u0420\u041e\u0419\u0414\u0415\u0422\u0410\u041b\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061458", "2061458", "\u041f\u041b 10 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 10 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060725", "2060725", "\u0420\u0417\u0414 15 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 15 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2062429", "2062429", "\u0411\u0423\u0420\u0426\u0415\u0412\u0421\u041a\u0410\u042f", "\u0411\u0423\u0420\u0426\u0415\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061472", "2061472", "\u0421\u0423\u0421\u0410\u041d\u041e\u0412\u0421\u041a", "\u0421\u0423\u0421\u0410\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060387", "2060387", "\u0411\u0415\u0417\u041b\u0415\u0421\u041d\u0410\u042f", "\u0411\u0415\u0417\u041b\u0415\u0421\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061447", "2061447", "\u041f\u041b 32 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 32 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061567", "2061567", "\u041e\u041f 34 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 34 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061571", "2061571", "\u0412\u042b\u0421\u041e\u041a\u041e\u0412\u041e", "\u0412\u042b\u0421\u041e\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060367", "2060367", "\u0421\u0415\u041b\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u0421\u0415\u041b\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060366", "2060366", "\u0412\u041e\u041b\u041e\u0421\u0410\u0422\u0410\u042f", "\u0412\u041e\u041b\u041e\u0421\u0410\u0422\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061463", "2061463", "\u041f\u041b 67 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 67 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060363", "2060363", "\u0412\u041e\u0421\u0425\u041e\u0414", "\u0412\u041e\u0421\u0425\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2061596", "2061596", "\u041f\u041b 80 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 80 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060362", "2060362", "\u042d\u0421\u0418\u041d\u041e", "\u042d\u0421\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061591", "2061591", "\u041f\u041b 89 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 89 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060987", "2060987", "\u041e\u041f 92 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 92 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060361", "2060361", "\u041a\u041e\u0412\u0420\u041e\u0412 \u0413\u0420", "\u041a\u041e\u0412\u0420\u041e\u0412-\u0413\u0420\u0423\u0417\u041e\u0412\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060350", "2060350", "\u041a\u041e\u0412\u0420\u041e\u0412 1", "\u041a\u041e\u0412\u0420\u041e\u0412 1", "\u0413", null);
            RailwayStationsDataProvider.put("2060058", "2060058", "\u0425\u041e\u0414\u042f\u0429\u0415\u0412\u041e", "\u0425\u041e\u0414\u042f\u0429\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060908", "2060908", "\u0411\u0418\u0428\u0411\u0410\u0422\u041c\u0410\u041d", "\u0411\u0418\u0428\u0411\u0410\u0422\u041c\u0410\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060999", "2060999", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060605", "2060605", "\u0410\u041b\u0411\u0410\u0411\u0410", "\u0410\u041b\u0411\u0410\u0411\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060656", "2060656", "\u0423\u0422\u042f\u0428\u041a\u0418", "\u0423\u0422\u042f\u0428\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060606", "2060606", "\u041a\u0423\u0411\u041d\u042f", "\u041a\u0423\u0411\u041d\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061644", "2061644", "\u0428\u0423\u0428\u0415\u0420\u041c\u0410", "\u0428\u0423\u0428\u0415\u0420\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060607", "2060607", "\u041a\u0423\u041b\u0410\u041d\u0413\u0410", "\u041a\u0423\u041b\u0410\u041d\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060660", "2060660", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060608", "2060608", "\u041a\u041b\u042e\u0427\u0418", "\u041a\u041b\u042e\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060609", "2060609", "\u041a\u0410\u0420\u0410\u0422\u0423\u041d", "\u041a\u0410\u0420\u0410\u0422\u0423\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060611", "2060611", "\u041a\u0418\u041b\u042c\u0414\u0423\u0420\u0410\u0417\u042b", "\u041a\u0418\u041b\u042c\u0414\u0423\u0420\u0410\u0417\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061539", "2061539", "\u041f\u041b 95 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 95 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060612", "2060612", "\u041b\u041e\u0429\u0418", "\u041b\u041e\u0429\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060355", "2060355", "\u0411\u0423\u0410", "\u0411\u0423\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061564", "2061564", "\u0411\u042e\u0420\u0413\u0410\u041d\u042b", "\u0411\u042e\u0420\u0413\u0410\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060613", "2060613", "\u0411\u0423\u0420\u0423\u041d\u0414\u0423\u041a\u0418", "\u0411\u0423\u0420\u0423\u041d\u0414\u0423\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060614", "2060614", "\u0415\u041b\u0425\u041e\u0412\u041e", "\u0415\u041b\u0425\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2024616", "2024616", "\u0426\u0418\u041b\u042c\u041d\u0410", "\u0426\u0418\u041b\u042c\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2060396", "2060396", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421 1", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421 1", "\u0413", null);
            RailwayStationsDataProvider.put("2060404", "2060404", "\u041f\u0415\u0428\u0415\u041b\u0410\u041d\u042c", "\u041f\u0415\u0428\u0415\u041b\u0410\u041d\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060409", "2060409", "\u0428\u0410\u0422\u041a\u0418", "\u0428\u0410\u0422\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060411", "2060411", "\u041f\u041e\u042f", "\u041f\u041e\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060412", "2060412", "\u041b\u0423\u041a\u041e\u042f\u041d\u041e\u0412", "\u041b\u0423\u041a\u041e\u042f\u041d\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2061411", "2061411", "\u0412\u0415\u0421\u0415\u041b\u0415\u0419", "\u0412\u0415\u0421\u0415\u041b\u0415\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060413", "2060413", "\u041d\u0418\u041a\u041e\u041b\u0410\u0419 \u0414", "\u041d\u0418\u041a\u041e\u041b\u0410\u0419-\u0414\u0410\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060414", "2060414", "\u0410\u0420\u0417\u0418\u041d\u041a\u0410", "\u0410\u0420\u0417\u0418\u041d\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060415", "2060415", "\u0423\u0416\u041e\u0412\u041a\u0410", "\u0423\u0416\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060416", "2060416", "\u041a\u0415\u041d\u0414\u042f", "\u041a\u0415\u041d\u0414\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060993", "2060993", "\u041e\u041f 97 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 97 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060417", "2060417", "\u041a\u0415\u041c\u041b\u042f", "\u041a\u0415\u041c\u041b\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060994", "2060994", "\u041e\u041f 91 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 91 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060418", "2060418", "\u041e\u0411\u0420\u041e\u0427\u041d\u041e\u0415", "\u041e\u0411\u0420\u041e\u0427\u041d\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060995", "2060995", "\u041e\u041f 82 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 82 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060996", "2060996", "\u041e\u041f 76 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 76 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060419", "2060419", "\u0410\u0422\u042c\u041c\u0410", "\u0410\u0422\u042c\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061611", "2061611", "\u041f\u041b 67 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 67 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060997", "2060997", "\u041e\u041f 63 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 63 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060011", "2060011", "\u041a\u0420\u0410\u0421\u041d \u0423\u0417\u0415\u041b", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u0423\u0417\u0415\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060496", "2060496", "\u0421\u0423\u0421\u041e\u041b\u041e\u0412\u041a\u0410", "\u0421\u0423\u0421\u041e\u041b\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060886", "2060886", "\u041f\u041b 321 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 321 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060885", "2060885", "\u041f\u041b 316 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 316 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060495", "2060495", "\u0411\u0423\u041c\u0410\u0416\u041d\u042b\u0419", "\u0411\u0423\u041c\u0410\u0416\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060752", "2060752", "\u041f\u041b 309 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 309 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060949", "2060949", "\u041e\u041f 302 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 302 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060494", "2060494", "\u041b\u0423\u0417\u0410", "\u041b\u0423\u0417\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060657", "2060657", "\u041a\u0415\u041d\u0422\u0423\u0421", "\u041a\u0415\u041d\u0422\u0423\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060704", "2060704", "\u041c\u0410\u041a\u0423\u0425\u0410", "\u041c\u0410\u041a\u0423\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061593", "2061593", "\u041f\u041b 281 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 281 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060493", "2060493", "\u041b\u0423\u041d\u0414\u0410\u041d\u041a\u0410", "\u041b\u0423\u041d\u0414\u0410\u041d\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060492", "2060492", "\u041f\u0410\u041d\u0410\u0421\u042e\u041a", "\u041f\u0410\u041d\u0410\u0421\u042e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060948", "2060948", "\u041f\u041b 257 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 257 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060703", "2060703", "\u041e\u041a\u0422\u042f\u0411\u0420\u042c\u0421\u041a", "\u041e\u041a\u0422\u042f\u0411\u0420\u042c\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060491", "2060491", "\u041f\u0418\u041d\u042e\u0413", "\u041f\u0418\u041d\u042e\u0413", "\u0413", null);
            RailwayStationsDataProvider.put("2060947", "2060947", "\u041e\u041f 233 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 233 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060489", "2060489", "\u041d\u041e\u0412\u042b\u0419", "\u041d\u041e\u0412\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060946", "2060946", "\u041e\u041f 219 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 219 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060488", "2060488", "\u0410\u041b\u042c\u041c\u0415\u0416", "\u0410\u041b\u042c\u041c\u0415\u0416", "\u0413", null);
            RailwayStationsDataProvider.put("2060945", "2060945", "\u041e\u041f 204 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 204 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060016", "2060016", "\u041b\u0410\u0422\u042b\u0428\u0421\u041a\u0418\u0419", "\u041b\u0410\u0422\u042b\u0428\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060944", "2060944", "\u041e\u041f 192 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 192 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060470", "2060470", "\u041e\u041f\u0410\u0420\u0418\u041d\u041e", "\u041e\u041f\u0410\u0420\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060943", "2060943", "\u041e\u041f 173 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 173 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060749", "2060749", "\u041d\u0410\u0413\u0418\u0411\u0418\u041d\u041e", "\u041d\u0410\u0413\u0418\u0411\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060487", "2060487", "\u0412\u0410\u0417\u042e\u041a", "\u0412\u0410\u0417\u042e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060942", "2060942", "\u041e\u041f 157 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 157 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060486", "2060486", "\u0421\u0422\u0410\u0420\u041e\u0412\u0415\u0420\u0427", "\u0421\u0422\u0410\u0420\u041e\u0412\u0415\u0420\u0427\u0415\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060485", "2060485", "\u0420\u041e\u0413\u041e\u0417\u0418\u041d\u041e", "\u0420\u041e\u0413\u041e\u0417\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060941", "2060941", "\u041e\u041f 140 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 140 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060484", "2060484", "\u0411\u0415\u0417\u0411\u041e\u0416\u041d\u0418\u041a", "\u0411\u0415\u0417\u0411\u041e\u0416\u041d\u0418\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060940", "2060940", "\u041e\u041f 130 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 130 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060939", "2060939", "\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421", "\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060460", "2060460", "\u041c\u0423\u0420\u0410\u0428\u0418", "\u041c\u0423\u0420\u0410\u0428\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060754", "2060754", "\u0414\u041e\u041b\u0418\u041d\u0418\u0427\u0418", "\u0414\u041e\u041b\u0418\u041d\u0418\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060669", "2060669", "\u041f\u0410\u0425\u0410\u0420\u042c", "\u041f\u0410\u0425\u0410\u0420\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060938", "2060938", "\u041e\u041f 98 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 98 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060483", "2060483", "\u0412\u0415\u041b\u0418\u041a\u0410\u042f", "\u0412\u0415\u041b\u0418\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060027", "2060027", "\u041c\u041e\u0421\u0418\u041d\u0421\u041a\u0418\u0419", "\u041c\u041e\u0421\u0418\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060756", "2060756", "\u041e\u041f 79 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 79 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060757", "2060757", "\u041c\u0415\u0427\u041a\u0418\u041d\u041e", "\u041c\u0415\u0427\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060075", "2060075", "\u042e\u0420\u042c\u042f", "\u042e\u0420\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060937", "2060937", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060711", "2060711", "\u0427\u0410\u0429\u0418\u041d\u0421\u041a\u0418\u0419", "\u0427\u0410\u0429\u0418\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061626", "2061626", "\u041e\u041f 50 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 50 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060936", "2060936", "\u041e\u041f 46 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 46 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060910", "2060910", "\u041e\u041f 44 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 44 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060909", "2060909", "\u041e\u041f 41 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 41 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060481", "2060481", "\u041c\u0415\u0414\u042f\u041d\u041a\u0410", "\u041c\u0415\u0414\u042f\u041d\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060935", "2060935", "\u041e\u041f 32 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 32 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060482", "2060482", "\u0413\u0418\u0420\u0421\u041e\u0412\u041e", "\u0413\u0418\u0420\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060022", "2060022", "\u041c\u0410\u0422\u0410\u041d\u0426\u042b", "\u041c\u0410\u0422\u0410\u041d\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060443", "2060443", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u04272", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u0427 2", "\u0413", null);
            RailwayStationsDataProvider.put("2060686", "2060686", "\u0428\u0410\u041a\u0410\u041b\u0418", "\u0428\u0410\u041a\u0410\u041b\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060469", "2060469", "\u0418\u0413\u041e\u0422\u0418\u041d\u041e", "\u0418\u0413\u041e\u0422\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061617", "2061617", "\u041e\u041f 781 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 781 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060707", "2060707", "\u0415\u0416\u0423\u0420\u042b", "\u0415\u0416\u0423\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060468", "2060468", "\u0415\u0416\u0418\u0425\u0410", "\u0415\u0416\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061590", "2061590", "\u041f 747 \u041a\u041c", "\u041f\u041e\u0421\u0422 747 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060467", "2060467", "\u0428\u0415\u0420\u0421\u0422\u041a\u0418", "\u0428\u0415\u0420\u0421\u0422\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060466", "2060466", "\u0411\u0423\u0420\u0415\u041f\u041e\u041b\u041e\u041c", "\u0411\u0423\u0420\u0415\u041f\u041e\u041b\u041e\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060638", "2060638", "\u041e\u0414\u041e\u0428\u041d\u0423\u0420", "\u041e\u0414\u041e\u0428\u041d\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060465", "2060465", "\u041f\u0418\u0416\u041c\u0410", "\u041f\u0418\u0416\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060637", "2060637", "\u042f\u041d\u0413\u0410\u0420\u041a\u0410", "\u042f\u041d\u0413\u0410\u0420\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061615", "2061615", "\u041e\u041f 701 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 701 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060464", "2060464", "\u0422\u041e\u041d\u0428\u0410\u0415\u0412\u041e", "\u0422\u041e\u041d\u0428\u0410\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061573", "2061573", "\u0428\u0415\u0421\u0422\u0415\u0420\u0418\u041a\u041e\u0412", "\u0428\u0415\u0421\u0422\u0415\u0420\u0418\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060440", "2060440", "\u0428\u0410\u0425\u0423\u041d\u042c\u042f", "\u0428\u0410\u0425\u0423\u041d\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060463", "2060463", "\u0417\u0423\u0411\u0410\u041d\u042c\u042f", "\u0417\u0423\u0411\u0410\u041d\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060676", "2060676", "\u0411\u0423\u0420\u0415\u041d\u0418\u041d\u041e", "\u0411\u0423\u0420\u0415\u041d\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060029", "2060029", "\u041e\u0411\u0425\u041e\u0414", "\u041e\u0411\u0425\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060672", "2060672", "\u0428\u0410\u041b\u0415\u0413\u0410", "\u0428\u0410\u041b\u0415\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060462", "2060462", "\u0410\u0420\u042c\u042f", "\u0410\u0420\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060430", "2060430", "\u0423\u0420\u0415\u041d\u042c", "\u0423\u0420\u0415\u041d\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060461", "2060461", "\u0423\u0421\u0422\u0410", "\u0423\u0421\u0422\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061534", "2061534", "\u041c\u0418\u041d\u0415\u0415\u0412\u041a\u0410", "\u041c\u0418\u041d\u0415\u0415\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060459", "2060459", "\u0428\u0415\u041c\u0410\u041d\u0418\u0425\u0410", "\u0428\u0415\u041c\u0410\u041d\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061413", "2061413", "\u0411\u042b\u0421\u0422\u0420\u0423\u0425\u0410", "\u0411\u042b\u0421\u0422\u0420\u0423\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061625", "2061625", "\u0412\u0415\u0422\u041b\u0423\u0416\u0421\u041a\u0410\u042f", "\u0412\u0415\u0422\u041b\u0423\u0416\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061584", "2061584", "\u041f\u0415\u0420\u0415\u0425\u0412\u0410\u0422\u041a\u0410", "\u041f\u0415\u0420\u0415\u0425\u0412\u0410\u0422\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060458", "2060458", "\u0421\u0423\u0425\u041e\u0411\u0415\u0417\u0412\u041e\u0414", "\u0421\u0423\u0425\u041e\u0411\u0415\u0417\u0412\u041e\u0414\u041d\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061592", "2061592", "\u041a\u0410\u041c \u041e\u0412\u0420\u0410\u0413", "\u041a\u0410\u041c\u0415\u041d\u041d\u042b\u0419 \u041e\u0412\u0420\u0410\u0413", "\u0413", null);
            RailwayStationsDataProvider.put("2061526", "2061526", "\u041e\u0417\u0415\u0420\u041e", "\u041e\u0417\u0415\u0420\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060457", "2060457", "\u041a\u0415\u0420\u0416\u0415\u041d\u0415\u0426", "\u041a\u0415\u0420\u0416\u0415\u041d\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2061589", "2061589", "\u041f 75 \u041a\u041c", "\u041f\u041e\u0421\u0422 75 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060456", "2060456", "\u0421\u0415\u041c\u0415\u041d\u041e\u0412", "\u0421\u0415\u041c\u0415\u041d\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2060017", "2060017", "\u041e\u041f 506 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 506 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060455", "2060455", "\u041e\u0421\u0418\u041d\u041a\u0418", "\u041e\u0421\u0418\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060454", "2060454", "\u0422\u0410\u0420\u0410\u0421\u0418\u0425\u0410", "\u0422\u0410\u0420\u0410\u0421\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060734", "2060734", "\u041a\u0415\u0417\u0410", "\u041a\u0415\u0417\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060453", "2060453", "\u041b\u0418\u041d\u0414\u0410", "\u041b\u0418\u041d\u0414\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060452", "2060452", "\u041a\u0410\u041b\u0418\u041a\u0418\u041d\u041e", "\u041a\u0410\u041b\u0418\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060636", "2060636", "\u0428\u041f\u0410\u041b\u041e\u0417\u0410\u0412\u041e\u0414", "\u0428\u041f\u0410\u041b\u041e\u0417\u0410\u0412\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060451", "2060451", "\u041a\u0418\u0421\u0415\u041b\u0418\u0425\u0410", "\u041a\u0418\u0421\u0415\u041b\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061475", "2061475", "\u0420\u0415\u041a\u0428\u0418\u041d\u041e", "\u0420\u0415\u041a\u0428\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060449", "2060449", "\u0422\u041e\u041b\u041e\u041a\u041e\u041d\u0426\u0415\u0412", "\u0422\u041e\u041b\u041e\u041a\u041e\u041d\u0426\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060650", "2060650", "\u0412\u041e\u041b\u0413\u0410", "\u0412\u041e\u041b\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060001", "2060001", "\u041d.\u041d\u041e\u0412\u0413\u041e\u0420\u041e\u0414 \u041c", "\u041d\u0418\u0416\u041d\u0418\u0419 \u041d\u041e\u0412\u0413\u041e\u0420\u041e\u0414 \u041c\u041e\u0421\u041a\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2061588", "2061588", "\u041e\u041f 435 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 435 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060002", "2060002", "\u0413\u041e\u0420\u042c\u041a\u0418\u0419 \u0421", "\u0413\u041e\u0420\u042c\u041a\u0418\u0419 \u0421\u041e\u0420\u0422\u0418\u0420\u041e\u0412\u041e\u0427\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061587", "2061587", "\u041f\u041b 431 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 431 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061586", "2061586", "\u041e\u041f 429 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 429 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061450", "2061450", "\u0414\u041e\u0421\u041a\u0418\u041d\u041e", "\u0414\u041e\u0421\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061726", "2061726", "\u041e\u041f 421 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 421 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2062425", "2062425", "\u0412\u041e\u0420\u041e\u0428\u0418\u041b\u041e\u0412\u0421", "\u0412\u041e\u0420\u041e\u0428\u0418\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060444", "2060444", "\u0418\u0413\u0423\u041c\u041d\u041e\u0412\u041e", "\u0418\u0413\u0423\u041c\u041d\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061490", "2061490", "\u041a\u0410\u041b\u0418\u041d\u0418\u041d\u0421\u041a", "\u041a\u0410\u041b\u0418\u041d\u0418\u041d\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060420", "2060420", "\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a", "\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061480", "2061480", "\u041f\u0423\u0428\u041a\u0418\u041d\u041e", "\u041f\u0423\u0428\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060445", "2060445", "\u0416\u041e\u041b\u041d\u0418\u041d\u041e", "\u0416\u041e\u041b\u041d\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060111", "2060111", "\u0420\u0415\u0428\u0415\u0422\u0418\u0425\u0410", "\u0420\u0415\u0428\u0415\u0422\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2062585", "2062585", "\u041e\u041f 392 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 392 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060446", "2060446", "\u0421\u0415\u0419\u041c\u0410", "\u0421\u0415\u0419\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061570", "2061570", "\u0413\u041e\u0420\u0411\u0410\u0422\u041e\u0412\u041a\u0410", "\u0413\u041e\u0420\u0411\u0410\u0422\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061540", "2061540", "\u0418\u041b\u042c\u0418\u041d\u041e\u0413\u041e\u0420", "\u0418\u041b\u042c\u0418\u041d\u041e\u0413\u041e\u0420\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060447", "2060447", "\u0418\u041b\u042c\u0418\u041d\u041e", "\u0418\u041b\u042c\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060635", "2060635", "\u0413\u0410\u041b\u0418\u0426\u041a\u0410\u042f", "\u0413\u0410\u041b\u0418\u0426\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060356", "2060356", "\u0413\u041e\u0420\u041e\u0425\u041e\u0412\u0415\u0426", "\u0413\u041e\u0420\u041e\u0425\u041e\u0412\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2061467", "2061467", "\u041c\u041e\u041b\u041e\u0414\u041d\u0418\u041a\u0418", "\u041c\u041e\u041b\u041e\u0414\u041d\u0418\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060354", "2060354", "\u0427\u0423\u041b\u041a\u041e\u0412\u041e", "\u0427\u0423\u041b\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060634", "2060634", "\u0418\u041c \u0412\u041e\u0419\u041a\u041e\u0412\u0410", "\u0418\u041c\u0415\u041d\u0418 \u0412\u041e\u0419\u041a\u041e\u0412\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060353", "2060353", "\u0414\u0415\u041d\u0418\u0421\u041e\u0412\u041e", "\u0414\u0415\u041d\u0418\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2062584", "2062584", "\u041f\u041b 324 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 324 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060360", "2060360", "\u0412\u042f\u0417\u041d\u0418\u041a\u0418", "\u0412\u042f\u0417\u041d\u0418\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060352", "2060352", "\u0421\u0415\u041d\u042c\u041a\u041e\u0412\u041e", "\u0421\u0415\u041d\u042c\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060351", "2060351", "\u041c\u0421\u0422\u0415\u0420\u0410", "\u041c\u0421\u0422\u0415\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060799", "2060799", "\u041e\u041f 288 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 288 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060755", "2060755", "\u0421\u0410\u0420\u042b\u0415\u0412\u041e", "\u0421\u0410\u0420\u042b\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060715", "2060715", "\u041a\u0420\u0415\u0421\u0422\u041d\u0418\u041a\u041e\u0412", "\u041a\u0420\u0415\u0421\u0422\u041d\u0418\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060798", "2060798", "\u041e\u041f 273 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 273 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060589", "2060589", "\u041e\u0421\u0418\u041f\u041e\u0412\u041e", "\u041e\u0421\u0418\u041f\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060705", "2060705", "\u0413\u041e\u0421\u0422\u042e\u0425\u0418\u041d\u041e", "\u0413\u041e\u0421\u0422\u042e\u0425\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060797", "2060797", "\u041f 262 \u041a\u041c", "\u041f\u041e\u0421\u0422 262 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061512", "2061512", "\u041a\u041e\u0412\u0420\u041e\u0412 2", "\u041a\u041e\u0412\u0420\u041e\u0412 2", "\u0413", null);
            RailwayStationsDataProvider.put("2060796", "2060796", "\u041e\u041f 253 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 253 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060780", "2060780", "\u0424\u0415\u0414\u0423\u041b\u041e\u0412\u041e", "\u0424\u0415\u0414\u0423\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060770", "2060770", "\u0421\u0415\u0420\u0413\u0415\u0419\u0426\u0415\u0412\u041e", "\u0421\u0415\u0420\u0413\u0415\u0419\u0426\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060795", "2060795", "\u041e\u041f 243 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 243 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060347", "2060347", "\u041d\u041e\u0412\u041a\u0418 1", "\u041d\u041e\u0412\u041a\u0418 1", "\u0413", null);
            RailwayStationsDataProvider.put("2061510", "2061510", "\u041a\u0410\u041c\u0415\u0428\u041a\u041e\u0412\u041e", "\u041a\u0410\u041c\u0415\u0428\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060346", "2060346", "\u0422\u0415\u0420\u0415\u0425\u041e\u0412\u0418\u0426\u042b", "\u0422\u0415\u0420\u0415\u0425\u041e\u0412\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060730", "2060730", "\u041d\u041e\u0412 \u0416\u0418\u0417\u041d\u042c", "\u041d\u041e\u0412\u0410\u042f \u0416\u0418\u0417\u041d\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060344", "2060344", "\u0412\u0422\u041e\u0420\u041e\u0412\u041e", "\u0412\u0422\u041e\u0420\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060583", "2060583", "\u041a\u0410\u0420\u042f\u041a\u0418\u041d\u0421\u041a", "\u041a\u0410\u0420\u042f\u041a\u0418\u041d\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060568", "2060568", "\u0412\u042b\u0421\u0415\u041b\u041a\u0418", "\u0412\u042b\u0421\u0415\u041b\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061532", "2061532", "\u041b\u0415\u041c\u0415\u0428\u041a\u0418", "\u041b\u0415\u041c\u0415\u0428\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060343", "2060343", "\u0411\u041e\u0413\u041e\u041b\u042e\u0411\u041e\u0412\u041e", "\u0411\u041e\u0413\u041e\u041b\u042e\u0411\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060567", "2060567", "\u0410\u0412\u0422\u041e\u041f\u0420\u0418\u0411\u041e\u0420", "\u0410\u0412\u0422\u041e\u041f\u0420\u0418\u0411\u041e\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060340", "2060340", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420 \u041f", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420 \u041f\u0410\u0421\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060342", "2060342", "\u042e\u0420\u042c\u0415\u0412\u0415\u0426", "\u042e\u0420\u042c\u0415\u0412\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2060341", "2060341", "\u041a\u041e\u041b\u041e\u041a\u0428\u0410", "\u041a\u041e\u041b\u041e\u041a\u0428\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060794", "2060794", "\u041e\u041f 170 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 170 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060339", "2060339", "\u0423\u041d\u0414\u041e\u041b", "\u0423\u041d\u0414\u041e\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060684", "2060684", "\u041a\u0420 \u041e\u0425\u041e\u0422\u0410", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f \u041e\u0425\u041e\u0422\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061489", "2061489", "\u0421\u0423\u0428\u041d\u0415\u0412\u041e", "\u0421\u0423\u0428\u041d\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060338", "2060338", "\u0411\u041e\u041b\u0414\u0418\u041d\u041e", "\u0411\u041e\u041b\u0414\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060337", "2060337", "\u041a\u041e\u0421\u0422\u0415\u0420\u0415\u0412\u041e", "\u041a\u041e\u0421\u0422\u0415\u0420\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060786", "2060786", "\u041d\u0415\u0424\u0422\u0415\u041a\u0410\u041c \u041f", "\u041d\u0415\u0424\u0422\u0415\u041a\u0410\u041c\u0421\u041a \u041f\u0410\u0421\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060538", "2060538", "\u041d\u0415\u0424\u0422\u0415\u041a\u0410\u041c\u0421\u041a", "\u041d\u0415\u0424\u0422\u0415\u041a\u0410\u041c\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061547", "2061547", "\u042f\u0420\u0410\u041d\u0421\u041a", "\u042f\u0420\u0410\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060744", "2060744", "\u041e\u041f 171 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 171 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061745", "2061745", "\u041e\u041f 165 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 165 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060588", "2060588", "\u0422\u0410\u0411\u0410\u0428\u0418\u041d\u041e", "\u0422\u0410\u0411\u0410\u0428\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060716", "2060716", "\u041f\u041b 151 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 151 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060591", "2060591", "\u0422\u0423\u0420\u0428\u0410", "\u0422\u0423\u0420\u0428\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060746", "2060746", "\u041e\u041f 137 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 137 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060592", "2060592", "\u041d\u0423\u0416\u042c\u042f\u041b\u042b", "\u041d\u0423\u0416\u042c\u042f\u041b\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061747", "2061747", "\u041f\u041b 131 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 131 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061748", "2061748", "\u041f\u041b 126 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 126 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060594", "2060594", "\u041d\u041e\u041b\u042c\u041a\u0410", "\u041d\u041e\u041b\u042c\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060595", "2060595", "\u0410\u041a\u0421\u0410\u041c\u0410\u0422\u041e\u0412\u041e", "\u0410\u041a\u0421\u0410\u041c\u0410\u0422\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061749", "2061749", "\u041e\u041f 108 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 108 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060593", "2060593", "\u0419\u041e\u0428\u041a\u0410\u0420 \u041e\u041b\u0410", "\u0419\u041e\u0428\u041a\u0410\u0420-\u041e\u041b\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060598", "2060598", "\u0421\u0423\u0420\u041e\u041a", "\u0421\u0423\u0420\u041e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060599", "2060599", "\u041a\u0423\u041d\u0414\u042b\u0428", "\u041a\u0423\u041d\u0414\u042b\u0428", "\u0413", null);
            RailwayStationsDataProvider.put("2060601", "2060601", "\u0421\u0423\u0421\u041b\u041e\u041d\u0413\u0415\u0420", "\u0421\u0423\u0421\u041b\u041e\u041d\u0413\u0415\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060602", "2060602", "\u0428\u0415\u041b\u0410\u041d\u0413\u0415\u0420", "\u0428\u0415\u041b\u0410\u041d\u0413\u0415\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060603", "2060603", "\u0418\u041b\u0415\u0422\u042c", "\u0418\u041b\u0415\u0422\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060604", "2060604", "\u041f\u041e\u041c\u0410\u0420\u042b", "\u041f\u041e\u041c\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060620", "2060620", "\u0427\u0415\u0411\u041e\u041a\u0421\u0410\u0420\u042b", "\u0427\u0415\u0411\u041e\u041a\u0421\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060899", "2060899", "\u041f 9 \u041a\u041c", "\u041f\u041e\u0421\u0422 9 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060564", "2060564", "\u0418\u0428\u041b\u0415\u0419", "\u0418\u0428\u041b\u0415\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060441", "2060441", "\u041c\u0418\u0416\u0415\u0420\u0410", "\u041c\u0418\u0416\u0415\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061446", "2061446", "\u0428\u041e\u0420\u041a\u0418\u041d\u041e", "\u0428\u041e\u0420\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060898", "2060898", "\u041e\u041f 28 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 28 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060897", "2060897", "\u041e\u041f 32 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 32 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060727", "2060727", "\u0425\u041e\u0420\u041d\u0412\u0410\u0420\u042b", "\u0425\u041e\u0420\u041d\u0412\u0410\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060784", "2060784", "\u041f\u041b 38 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 38 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060728", "2060728", "\u042f\u041d\u041e\u0420\u0421\u041e\u0412\u041e", "\u042f\u041d\u041e\u0420\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060896", "2060896", "\u041e\u041f 46 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 46 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060565", "2060565", "\u0426\u0418\u0412\u0418\u041b\u042c\u0421\u041a", "\u0426\u0418\u0412\u0418\u041b\u042c\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060566", "2060566", "\u0422\u0420\u0410\u041a\u0418", "\u0422\u0420\u0410\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061507", "2061507", "\u041f\u041b 74 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 74 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061438", "2061438", "\u0410\u0422\u042b\u041a\u041e\u0412\u041e", "\u0410\u0422\u042b\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061437", "2061437", "\u041c\u0410\u041b \u0426\u0418\u0412\u0418\u041b\u042c", "\u041c\u0410\u041b\u042b\u0419 \u0426\u0418\u0412\u0418\u041b\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061506", "2061506", "\u041f\u041b 91 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 91 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060379", "2060379", "\u0422\u0423\u041c\u0421\u041a\u0410\u042f", "\u0422\u0423\u041c\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060985", "2060985", "\u041e\u041f 112 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 112 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061425", "2061425", "\u0412\u0415\u041b\u0418\u041a\u041e\u0414\u0412\u041e\u0420", "\u0412\u0415\u041b\u0418\u041a\u041e\u0414\u0412\u041e\u0420\u042c\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060779", "2060779", "\u0414\u0423\u0411\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u0414\u0423\u0411\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060377", "2060377", "\u041a\u0423\u0420\u041b\u041e\u0412\u041e", "\u041a\u0423\u0420\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060378", "2060378", "\u041e\u041a\u0410\u0422\u041e\u0412\u041e", "\u041e\u041a\u0410\u0422\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060984", "2060984", "\u041e\u041f 71 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 71 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060373", "2060373", "\u0413\u0423\u0421\u042c \u0425\u0420\u0423\u0421\u0422", "\u0413\u0423\u0421\u042c-\u0425\u0420\u0423\u0421\u0422\u0410\u041b\u042c\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060983", "2060983", "\u041e\u041f 56 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 56 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060372", "2060372", "\u041a\u041e\u041c\u0418\u0421\u0421\u0410\u0420\u041e\u0412", "\u041a\u041e\u041c\u0418\u0421\u0421\u0410\u0420\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061468", "2061468", "\u041f\u041b 46 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 46 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060982", "2060982", "\u041e\u041f 42 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 42 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060371", "2060371", "\u041d\u0415\u041a\u041b\u042e\u0414\u041e\u0412\u041e", "\u041d\u0415\u041a\u041b\u042e\u0414\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060981", "2060981", "\u041e\u041f 30 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 30 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061466", "2061466", "\u0413\u041e\u041b\u041e\u0412\u0418\u041d\u041e", "\u0413\u041e\u041b\u041e\u0412\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060980", "2060980", "\u041e\u041f 18 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 18 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060368", "2060368", "\u0423\u041b\u042b\u0411\u042b\u0428\u0415\u0412\u041e", "\u0423\u041b\u042b\u0411\u042b\u0428\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060729", "2060729", "\u041f\u041b 10 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 10 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060386", "2060386", "\u041b\u0415\u0421\u041d\u0410\u042f", "\u041b\u0415\u0421\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060520", "2060520", "\u0412\u0415\u0420\u0425\u041d\u0415\u041a\u0410\u041c", "\u0412\u0415\u0420\u0425\u041d\u0415\u041a\u0410\u041c\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061735", "2061735", "\u041e\u041f 173 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 173 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060057", "2060057", "\u0424\u041e\u0421\u0424\u041e\u0420\u0418\u0422\u041d", "\u0424\u041e\u0421\u0424\u041e\u0420\u0418\u0422\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061527", "2061527", "\u0421\u0412\u0415\u0422\u041b\u041e\u041f\u041e\u041b", "\u0421\u0412\u0415\u0422\u041b\u041e\u041f\u041e\u041b\u042f\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060504", "2060504", "\u041a\u0418\u0420\u0421", "\u041a\u0418\u0420\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060071", "2060071", "\u0413\u0410\u0420\u042c", "\u0413\u0410\u0420\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060035", "2060035", "\u041f\u0415\u0429\u0415\u0420\u0410", "\u041f\u0415\u0429\u0415\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060069", "2060069", "\u041a\u041e\u0422\u0427\u0418\u0425\u0410", "\u041a\u041e\u0422\u0427\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060503", "2060503", "\u0428\u041b\u0410\u041a\u041e\u0412\u0410\u042f", "\u0428\u041b\u0410\u041a\u041e\u0412\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061415", "2061415", "\u041b\u0415\u0421 \u041f\u041e\u041b\u042f\u041d\u042b", "\u041b\u0415\u0421\u041d\u042b\u0415 \u041f\u041e\u041b\u042f\u041d\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061736", "2061736", "\u041e\u041f 92 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 92 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061629", "2061629", "\u0422\u041e\u041d\u041a\u0418\u041d\u041e", "\u0422\u041e\u041d\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061521", "2061521", "\u041e\u0417\u0415\u0420\u041d\u0418\u0426\u0410 \u041a", "\u041e\u0417\u0415\u0420\u041d\u0418\u0426\u0410-\u041a\u0418\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060510", "2060510", "\u0421\u0422\u0410\u041b\u042c\u041d\u0410\u042f", "\u0421\u0422\u0410\u041b\u042c\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060070", "2060070", "\u0428\u0410\u0425\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u0428\u0410\u0425\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060048", "2060048", "\u0421\u0422\u0420\u0423\u0413\u041e\u0412\u0421\u041a", "\u0421\u0422\u0420\u0423\u0413\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060033", "2060033", "\u041f\u0415\u0420\u0415\u041b\u041e\u041c", "\u041f\u0415\u0420\u0415\u041b\u041e\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060737", "2060737", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060761", "2060761", "\u041f\u0423\u0414\u0415\u041c\u0421\u041a\u0418\u0419", "\u041f\u0423\u0414\u0415\u041c\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060738", "2060738", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061417", "2061417", "\u041b\u0410\u041f\u0428\u0410\u041d\u0413\u0410", "\u041b\u0410\u041f\u0428\u0410\u041d\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060895", "2060895", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061641", "2061641", "\u041a\u0410\u0419\u0421\u041a", "\u041a\u0410\u0419\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060768", "2060768", "\u041f\u041e\u0421\u0422\u041e\u0419", "\u041f\u041e\u0421\u0422\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060894", "2060894", "\u041e\u041f 27 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 27 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060766", "2060766", "\u041f\u0420\u0423\u0414\u042b", "\u041f\u0420\u0423\u0414\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060681", "2060681", "\u0427\u0418\u0411\u0418\u0420\u042c", "\u0427\u0418\u0411\u0418\u0420\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061531", "2061531", "\u0420\u0417\u0414 289 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 289 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060569", "2060569", "\u042f\u041d\u0413\u041b\u0418\u0427\u0418", "\u042f\u041d\u0413\u041b\u0418\u0427\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061569", "2061569", "\u0420\u0417\u0414 275 \u041a\u041c", "\u0420\u0417\u0414'\u0415\u0417\u0414 275 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060692", "2060692", "\u0420\u0417\u0414 265 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 265 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060571", "2060571", "\u0418\u0411\u0420\u0415\u0421\u0418", "\u0418\u0411\u0420\u0415\u0421\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061658", "2061658", "\u0420\u0417\u0414 252 \u041a\u041c", "\u0420\u0417\u0414'\u0415\u0417\u0414 252 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060572", "2060572", "\u0411\u0423\u0418\u041d\u0421\u041a", "\u0411\u0423\u0418\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060691", "2060691", "\u0420\u0417\u0414 235 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 235 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060573", "2060573", "\u041a\u0418\u0420\u042f", "\u041a\u0418\u0420\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060714", "2060714", "\u0420\u0417\u0414 215 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 215 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060574", "2060574", "\u0410\u0422\u0420\u0410\u0422", "\u0410\u0422\u0420\u0410\u0422", "\u0413", null);
            RailwayStationsDataProvider.put("2060677", "2060677", "\u0420\u0417\u0414 199 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 199 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060575", "2060575", "\u0410\u041b\u0422\u042b\u0428\u0415\u0412\u041e", "\u0410\u041b\u0422\u042b\u0428\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060335", "2060335", "\u0410\u041b\u0410\u0422\u042b\u0420\u042c", "\u0410\u041b\u0410\u0422\u042b\u0420\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061653", "2061653", "\u0411\u0410\u0421\u041e\u0412\u041e", "\u0411\u0410\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060576", "2060576", "\u0421\u0412\u0415\u0422\u041e\u0422\u0415\u0425\u041d", "\u0421\u0412\u0415\u0422\u041e\u0422\u0415\u0425\u041d\u0418\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060577", "2060577", "\u0410\u0420\u0414\u0410\u0422\u041e\u0412", "\u0410\u0420\u0414\u0410\u0422\u041e\u0412", "\u0413", null);
            RailwayStationsDataProvider.put("2060736", "2060736", "\u0420\u0417\u0414 148 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 148 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061409", "2061409", "\u0411\u041e\u0411\u041e\u0415\u0414\u041e\u0412\u041e", "\u0411\u041e\u0411\u041e\u0415\u0414\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060723", "2060723", "\u0420\u0417\u0414 133 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 133 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060578", "2060578", "\u0410\u0422\u042f\u0428\u0415\u0412\u041e", "\u0410\u0422\u042f\u0428\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061651", "2061651", "\u0420\u0417\u0414 118 \u041a\u041c", "\u0420\u0417\u0414'\u0415\u0417\u0414 118 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060693", "2060693", "\u041c\u0410\u0427\u041a\u0410\u0421\u0421\u042b", "\u041c\u0410\u0427\u041a\u0410\u0421\u0421\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060579", "2060579", "\u041d\u0423\u042f", "\u041d\u0423\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060998", "2060998", "\u041e\u041f 98 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 98 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060581", "2060581", "\u0427\u0410\u041c\u0417\u0418\u041d\u041a\u0410", "\u0427\u0410\u041c\u0417\u0418\u041d\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060582", "2060582", "\u041e\u0413\u0410\u0420\u0415\u0412\u041a\u0410", "\u041e\u0413\u0410\u0420\u0415\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061518", "2061518", "\u0420\u0415\u041c\u0415\u0417\u0415\u041d\u041a\u0418", "\u0420\u0415\u041c\u0415\u0417\u0415\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2061432", "2061432", "\u0420\u0415\u0419\u0422\u0410\u0420\u0421\u041a\u0418\u0419", "\u0420\u0415\u0419\u0422\u0410\u0420\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061568", "2061568", "\u041a\u041e\u0427\u0423\u041d\u041e\u0412\u041e", "\u041a\u041e\u0427\u0423\u041d\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060654", "2060654", "\u0420\u041e\u041c\u041e\u0414\u0410\u041d\u041e\u0412", "\u0420\u041e\u041c\u041e\u0414\u0410\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060655", "2060655", "\u0421\u0410\u0425 \u0417\u0410\u0412\u041e\u0414", "\u0421\u0410\u0425\u0410\u0420\u041d\u042b\u0419 \u0417\u0410\u0412\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060397", "2060397", "\u0421\u041e\u041b\u041e\u0412\u0415\u0419\u041a\u041e", "\u0421\u041e\u041b\u041e\u0412\u0415\u0419\u041a\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060398", "2060398", "\u041f\u041e\u041b\u041e\u0413\u041e\u0412\u041a\u0410", "\u041f\u041e\u041b\u041e\u0413\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061482", "2061482", "\u041b\u041e\u041c\u041e\u0412\u041a\u0410", "\u041b\u041e\u041c\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060399", "2060399", "\u0421\u0415\u0420\u0415\u0416\u0410", "\u0421\u0415\u0420\u0415\u0416\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060063", "2060063", "\u0427\u0415\u0420\u0415\u041c\u0410\u0421", "\u0427\u0415\u0420\u0415\u041c\u0410\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060401", "2060401", "\u0421\u0415\u0427\u0423\u0413\u0410", "\u0421\u0415\u0427\u0423\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060402", "2060402", "\u0421\u0423\u0420\u041e\u0412\u0410\u0422\u0418\u0425\u0410", "\u0421\u0423\u0420\u041e\u0412\u0410\u0422\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060992", "2060992", "\u0420\u0417\u0414 281 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 281 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060020", "2060020", "\u041e\u041f 284 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 284 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060403", "2060403", "\u0428\u041e\u041d\u0418\u0425\u0410", "\u0428\u041e\u041d\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060991", "2060991", "\u0420\u0417\u0414 296 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 296 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060019", "2060019", "\u041e\u041f 302 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 302 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060438", "2060438", "\u0417\u0418\u041c\u0415\u041d\u041a\u0418", "\u0417\u0418\u041c\u0415\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060990", "2060990", "\u0420\u0417\u0414 310 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 310 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060439", "2060439", "\u0427\u0410\u0413\u041b\u041e\u0412\u041e", "\u0427\u0410\u0413\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060018", "2060018", "\u041e\u041f 321 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 321 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060989", "2060989", "\u041f 323 \u041a\u041c", "\u041f\u041e\u0421\u0422 323 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060030", "2060030", "\u041e\u041a\u0421\u041a\u0410\u042f", "\u041e\u041a\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060651", "2060651", "\u0421\u0410\u0420\u0422\u0410\u041a\u041e\u0412\u041e", "\u0421\u0410\u0420\u0422\u0410\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061449", "2061449", "\u041f\u0415\u0422\u0420\u042f\u0415\u0412\u041a\u0410", "\u041f\u0415\u0422\u0420\u042f\u0415\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061408", "2061408", "\u041f\u041e\u0414\u041e\u0421\u0418\u041d\u041e\u0412", "\u041f\u041e\u0414\u041e\u0421\u0418\u041d\u041e\u0412\u0415\u0426", "\u0413", null);
            RailwayStationsDataProvider.put("2060658", "2060658", "\u041c\u0410\u042f\u041b\u041e\u0412\u041e", "\u041c\u0410\u042f\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061659", "2061659", "\u0420\u0417\u0414 15 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 15 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060406", "2060406", "\u041f\u0415\u0420\u0412\u041e\u041c \u0413\u041e\u0420", "\u041f\u0415\u0420\u0412\u041e\u041c\u0410\u0419\u0421\u041a-\u0413\u041e\u0420\u042c\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060408", "2060408", "\u0411\u0415\u0420\u0415\u0429\u0418\u041d\u041e", "\u0411\u0415\u0420\u0415\u0429\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060407", "2060407", "\u0421\u0410\u0422\u0418\u0421", "\u0421\u0410\u0422\u0418\u0421", "\u0413", null);
            RailwayStationsDataProvider.put("2060405", "2060405", "\u041b\u0415\u0421\u041e\u0413\u041e\u0420\u0421\u041a", "\u041b\u0415\u0421\u041e\u0413\u041e\u0420\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060364", "2060364", "\u0421\u0423\u0414\u041e\u0413\u0414\u0410", "\u0421\u0423\u0414\u041e\u0413\u0414\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060664", "2060664", "\u041f\u0415\u0420\u0415\u0414\u0415\u041b", "\u041f\u0415\u0420\u0415\u0414\u0415\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060663", "2060663", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041e", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060662", "2060662", "\u0422\u042e\u0420\u041c\u0415\u0420\u041e\u0412\u0421\u041a", "\u0422\u0420\u041c\u0415\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060028", "2060028", "\u041d\u0415\u0420\u0423\u0414\u041d\u0410\u042f", "\u041d\u0415\u0420\u0423\u0414\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060891", "2060891", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060537", "2060537", "\u0421\u0410\u0419\u0413\u0410\u0422\u041a\u0410", "\u0421\u0410\u0419\u0413\u0410\u0422\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061739", "2061739", "\u041e\u041f 27\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 27\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060054", "2060054", "\u0423\u0416\u0423\u0418\u0425\u0410", "\u0423\u0416\u0423\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060740", "2060740", "\u041e\u041f 12\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061741", "2061741", "\u041e\u041f 6\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060508", "2060508", "\u0417\u0418\u041b\u0410\u0419", "\u0417\u0418\u041b\u0410\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060509", "2060509", "\u0410\u041d\u0414\u0420\u0415\u0419\u0428\u0423\u0420", "\u0410\u041d\u0414\u0420\u0415\u0419\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060511", "2060511", "\u041b\u042e\u041a", "\u041b\u042e\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060512", "2060512", "\u041c\u0415\u041d\u042c\u0418\u041b", "\u041c\u0415\u041d\u042c\u0418\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060540", "2060540", "\u0418\u0413\u0420\u0410", "\u0418\u0413\u0420\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060513", "2060513", "\u041a\u0423\u0428\u042c\u042f", "\u041a\u0423\u0428\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060514", "2060514", "\u041b\u041e\u0417\u0410", "\u041b\u041e\u0417\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060661", "2060661", "\u041b\u042b\u041d\u0413\u0410", "\u041b\u042b\u041d\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060515", "2060515", "\u041f\u0410\u0421\u0422\u0423\u0425\u041e\u0412\u041e", "\u041f\u0410\u0421\u0422\u0423\u0425\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060516", "2060516", "\u041a\u0415\u041a\u041e\u0420\u0410\u041d", "\u041a\u0415\u041a\u041e\u0420\u0410\u041d", "\u0413", null);
            RailwayStationsDataProvider.put("2060517", "2060517", "\u0427\u0423\u0420", "\u0427\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060518", "2060518", "\u0423\u0413\u041b\u041e\u0412\u041e\u0419", "\u0423\u0413\u041b\u041e\u0412\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061606", "2061606", "\u041f\u0415\u0421\u0422\u041e\u0412\u041a\u0410", "\u041f\u0415\u0421\u0422\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060519", "2060519", "\u041b\u042e\u041a\u0428\u0423\u0414\u042c\u042f", "\u041b\u042e\u041a\u0428\u0423\u0414\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061664", "2061664", "\u0412\u041e\u041b\u041e\u0416\u041a\u0410", "\u0412\u041e\u041b\u041e\u0416\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060521", "2060521", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060150", "2060150", "\u0418\u0416\u0415\u0412\u0421\u041a", "\u0418\u0416\u0415\u0412\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061452", "2061452", "\u041f\u041b 27 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 27 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061441", "2061441", "\u041b\u0423\u0414\u0417\u042f", "\u041b\u0423\u0414\u0417\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060914", "2060914", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060890", "2060890", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061416", "2061416", "\u042e\u0421\u041a\u0418", "\u042e\u0421\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060889", "2060889", "\u0420\u0417\u0414 9 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 9 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060888", "2060888", "\u0420\u0417\u0414 4 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 4 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060563", "2060563", "\u0412\u041e\u0422\u041a\u0418\u041d\u0421\u041a", "\u0412\u041e\u0422\u041a\u0418\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061496", "2061496", "\u041a\u0412\u0410\u0420\u0421\u0410", "\u041a\u0412\u0410\u0420\u0421\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061613", "2061613", "\u0411\u041e\u041b\u0413\u0423\u0420\u042b", "\u0411\u041e\u041b\u0413\u0423\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061566", "2061566", "\u0418\u042e\u041b\u042c", "\u0418\u042e\u041b\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061478", "2061478", "\u041f\u041b 58 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 58 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061616", "2061616", "\u0412\u041e\u0416\u041e\u0419", "\u0412\u041e\u0416\u041e\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061439", "2061439", "\u041f\u041e\u0417\u0418\u041c\u042c", "\u041f\u041e\u0417\u0418\u041c\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2060522", "2060522", "\u041a\u0418\u041b\u042c\u041c\u0415\u0417\u042c", "\u041a\u0418\u041b\u042c\u041c\u0415\u0417\u042c", "\u0413", null);
            RailwayStationsDataProvider.put("2061742", "2061742", "\u041e\u041f 142 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 142 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060051", "2060051", "\u0421\u042e\u0420\u0415\u041a", "\u0421\u042e\u0420\u0415\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060732", "2060732", "\u041f\u0418\u0416\u0418\u041b", "\u041f\u0418\u0416\u0418\u041b", "\u0413", null);
            RailwayStationsDataProvider.put("2060678", "2060678", "\u0413\u0423\u041b\u042f\u0415\u0412\u041e", "\u0413\u0423\u041b\u042f\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060068", "2060068", "\u0418\u041d\u0413\u0410", "\u0418\u041d\u0413\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060007", "2060007", "\u041a\u041e\u041a\u041c\u041e\u0416", "\u041a\u041e\u041a\u041c\u041e\u0416", "\u0413", null);
            RailwayStationsDataProvider.put("2061414", "2061414", "\u0412\u0410\u0412\u041e\u0416", "\u0412\u0410\u0412\u041e\u0416", "\u0413", null);
            RailwayStationsDataProvider.put("2061743", "2061743", "\u041e\u041f 92 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 92 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061583", "2061583", "\u0422\u041e\u0420\u0424\u042f\u041d\u0418\u0426\u0410", "\u0422\u041e\u0420\u0424\u042f\u041d\u0418\u0426\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060523", "2060523", "\u0423\u0412\u0410 1", "\u0423\u0412\u0410 1", "\u0413", null);
            RailwayStationsDataProvider.put("2060893", "2060893", "\u0423\u0412\u0410 2", "\u0423\u0412\u0410 2", "\u0413", null);
            RailwayStationsDataProvider.put("2061002", "2061002", "\u041a\u0410\u0420\u041a\u0410\u041b\u0410\u0419", "\u041a\u0410\u0420\u041a\u0410\u041b\u0410\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060731", "2060731", "\u041a\u0412\u0410\u041a\u0410", "\u041a\u0412\u0410\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060524", "2060524", "\u041e\u0411\u041b\u0410\u0421\u0422\u041d\u0410\u042f", "\u041e\u0411\u041b\u0410\u0421\u0422\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060525", "2060525", "\u0410\u0417\u0418\u041d\u041e", "\u0410\u0417\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060067", "2060067", "\u041a\u0418\u042f\u0418\u041a", "\u041a\u0418\u042f\u0418\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061648", "2061648", "\u0421\u0418\u041d\u0422\u0415\u041a", "\u0421\u0418\u041d\u0422\u0415\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060348", "2060348", "\u041d\u041e\u0412\u041a\u0418 2", "\u041d\u041e\u0412\u041a\u0418 2", "\u0413", null);
            RailwayStationsDataProvider.put("2060357", "2060357", "\u0418\u0416\u0411\u041e\u0411\u042c\u042f", "\u0418\u0416\u0411\u041e\u0411\u042c\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060358", "2060358", "\u0422\u0415\u0420\u0421\u0418", "\u0422\u0415\u0420\u0421\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060359", "2060359", "\u041c\u0423\u041a\u0428\u0423\u0420", "\u041c\u0423\u041a\u0428\u0423\u0420", "\u0413", null);
            RailwayStationsDataProvider.put("2060369", "2060369", "\u0410\u041b\u041d\u0410\u0428\u0418", "\u0410\u041b\u041d\u0410\u0428\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060003", "2060003", "\u041a\u041e\u0421\u0422\u0410\u0420\u0418\u0425\u0410", "\u041a\u041e\u0421\u0422\u0410\u0420\u0418\u0425\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061605", "2061605", "\u0427\u0410\u0410\u0414\u0410\u0415\u0412\u041e", "\u0427\u0410\u0410\u0414\u0410\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061630", "2061630", "\u041a\u041e\u041e\u041f\u0415\u0420\u0410\u0422\u0418\u0412", "\u041a\u041e\u041e\u041f\u0415\u0420\u0410\u0422\u0418\u0412\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061440", "2061440", "\u041f\u041e\u0427\u0418\u041d\u041a\u0418", "\u041f\u041e\u0427\u0418\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060720", "2060720", "\u041a\u041e\u041f\u041e\u0421\u041e\u0412\u041e", "\u041a\u041e\u041f\u041e\u0421\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061505", "2061505", "\u041d\u0410\u0420\u041e\u0414\u041d\u0410\u042f", "\u041d\u0410\u0420\u0414\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061645", "2061645", "\u0412\u042b\u0421\u041e\u041a\u041e\u0415", "\u0412\u042b\u0421\u041e\u041a\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061600", "2061600", "\u0414\u0423\u0411\u0420\u0410\u0412\u041d\u0410\u042f", "\u0414\u0423\u0411\u0420\u0410\u0412\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061460", "2061460", "\u041a\u041e\u0417\u0418\u041d\u041e", "\u041a\u041e\u0417\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061575", "2061575", "\u0410\u041b\u0415\u0428\u0418\u041d\u041e", "\u0410\u041b\u0415\u0428\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061515", "2061515", "\u041b\u0423\u041a\u0418\u041d\u041e", "\u041b\u0423\u041a\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061406", "2061406", "\u0411\u0410\u041b\u0410\u0425\u041d\u0410", "\u0411\u0410\u041b\u0410\u0425\u041d\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061455", "2061455", "\u041f\u0420\u0410\u0412\u0414\u0418\u041d\u0421\u041a", "\u041f\u0420\u0410\u0412\u0414\u0418\u041d\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2062426", "2062426", "\u0412\u0410\u041d\u042f\u0422\u042b", "\u0412\u0410\u041d\u042f\u0422\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2061431", "2061431", "\u041c\u041e\u0413\u0418\u041b\u0418\u0426\u042b", "\u041c\u041e\u0413\u0418\u041b\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2062437", "2062437", "\u041b\u0418\u041f\u041e\u0412\u041a\u0410", "\u041b\u0418\u041f\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061469", "2061469", "\u0428\u0415\u041b\u042f\u0423\u0425\u041e\u0412\u041e", "\u0428\u0415\u041b\u042f\u0423\u0425\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061465", "2061465", "\u0417\u0410\u0412\u041e\u041b\u0416\u042c\u0415", "\u0417\u0410\u0412\u041e\u041b\u0416\u042c\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060006", "2060006", "\u041a\u0418\u0420\u041e\u0412 \u041a\u041e\u0422\u041b", "\u041a\u0418\u0420\u041e\u0412-\u041a\u041e\u0422\u041b\u0410\u0421\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2060911", "2060911", "\u041e\u041f 9 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 9 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060962", "2060962", "\u041e\u041f 795 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 795 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060961", "2060961", "\u0412\u041e\u0421\u0421\u0422\u0410\u041d \u041f", "\u0412\u041e\u0421\u0421\u0422\u0410\u041d\u0418\u0415 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060631", "2060631", "\u0412\u041e\u0421\u0421\u0422\u0410\u041d\u0418\u0415", "\u0412\u041e\u0421\u0421\u0422\u0410\u041d\u0418\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061730", "2061730", "\u041b\u0415\u0412\u0427\u0415\u041d\u041a\u041e", "\u041b\u0415\u0412\u0427\u0415\u041d\u041a\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060960", "2060960", "\u041e\u041f 787 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 787 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060632", "2060632", "\u0412\u041e\u041b\u0416\u0421\u041a", "\u0412\u041e\u041b\u0416\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060700", "2060700", "\u041c\u0410\u0420\u0411\u0423\u041c\u041a\u041e\u041c\u0411", "\u041c\u0410\u0420\u0411\u0423\u041c\u041a\u041e\u041c\u0411", "\u0413", null);
            RailwayStationsDataProvider.put("2061553", "2061553", "\u041a\u0420\u0410\u0421\u041d\u041e\u0417\u0410\u0420", "\u041a\u0420\u0410\u0421\u041d\u041e\u0417\u0410\u0420\u0418\u041d\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061525", "2061525", "\u041f\u0410\u0420\u0410\u0422\u0421\u041a", "\u041f\u0410\u0420\u0410\u0422\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2061500", "2061500", "\u041c\u042b\u0417\u0410", "\u041c\u042b\u0417\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061660", "2061660", "\u0410\u041d\u041a\u0423\u0414\u0418\u041d\u041e\u0412\u041a", "\u0410\u041d\u041a\u0423\u0414\u0418\u041d\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060653", "2060653", "\u0411 \u0415\u041b\u042c\u041d\u042f", "\u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0415\u041b\u042c\u041d\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060988", "2060988", "\u041f\u041b 341 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 341 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2061464", "2061464", "\u0420\u041e\u0419\u041a\u0410", "\u0420\u041e\u0419\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060652", "2060652", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412\u0421\u041a", "\u0411\u041e\u0420\u0418\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061519", "2061519", "\u041a\u0423\u0414\u042c\u041c\u0410", "\u041a\u0423\u0414\u042c\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061597", "2061597", "\u041f 325 \u041a\u041c", "\u041f\u041e\u0421\u0422 325 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060745", "2060745", "\u041c\u0415\u0422\u0410\u041b\u041b\u0418\u0421\u0422", "\u041c\u0415\u0422\u0410\u041b\u041b\u0418\u0421\u0422", "\u0413", null);
            RailwayStationsDataProvider.put("2061428", "2061428", "\u0410\u0411\u0410\u0411\u041a\u041e\u0412\u041e", "\u0410\u0411\u0410\u0411\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061604", "2061604", "\u0412\u041e\u0420\u0421\u041c\u0410", "\u0412\u041e\u0420\u0421\u041c\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061426", "2061426", "\u0423\u0411\u0415\u0416\u0418\u0426\u042b", "\u0423\u0411\u0415\u0416\u0418\u0426\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060708", "2060708", "\u0412\u042b\u0411\u041e\u041b\u041e\u0412\u041e", "\u0412\u042b\u0411\u041e\u041b\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061443", "2061443", "\u041a\u041e\u0416\u0415\u0412\u0415\u041d\u041d\u041e\u0415", "\u041a\u041e\u0416\u0415\u0412\u0415\u041d\u041d\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060709", "2060709", "\u0421\u0422\u0420\u0415\u041b\u041a\u041e\u0412\u041e", "\u0421\u0422\u0420\u0415\u041b\u041a\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060718", "2060718", "\u0415\u0424\u0418\u041c\u042c\u0415\u0412\u041e", "\u0415\u0424\u0418\u041c\u042c\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061608", "2061608", "\u041a\u041e\u041f\u041d\u0418\u041d\u041e", "\u041a\u041e\u041f\u041d\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061652", "2061652", "\u0411\u0423\u0420\u0415\u0412\u0415\u0421\u0422\u041d", "\u0411\u0423\u0420\u0415\u0412\u0415\u0421\u0422\u041d\u0418\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060771", "2060771", "\u0417\u0415\u041b\u0415\u0426\u0418\u041d\u041e", "\u0417\u0415\u041b\u0415\u0426\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060892", "2060892", "\u041e\u041f 12\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060644", "2060644", "\u041a\u0421\u0422\u041e\u0412\u041e", "\u041a\u0421\u0422\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061429", "2061429", "\u041f\u0418\u041e\u041d\u0415\u0420\u0421\u041a\u0418\u0419", "\u041f\u0418\u041e\u041d\u0415\u0420\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061535", "2061535", "\u0412\u0410\u0420\u042f", "\u0412\u0410\u0420\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061470", "2061470", "\u0421\u041e\u0420\u041c\u041e\u0412\u041e", "\u0421\u041e\u0420\u041c\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060682", "2060682", "\u0413\u041e\u041b\u041e\u0412 \u0414\u0410\u0427\u0410", "\u0413\u041e\u041b\u041e\u0412\u0410\u041d \u0414\u0410\u0427\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060788", "2060788", "\u041a\u0423\u0420\u0428\u0410", "\u041a\u0423\u0420\u0428\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061732", "2061732", "\u041f\u041b 14 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 14 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060733", "2060733", "\u041f\u041b 9\u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 9\u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060778", "2060778", "\u0413\u0423\u0420\u0415\u0415\u0412\u0421\u041a\u0418\u0419", "\u0413\u0423\u0420\u0415\u0415\u0412\u0421\u041a\u0418\u0419", "\u0413", null);
            RailwayStationsDataProvider.put("2061621", "2061621", "\u0425\u0420\u0418\u0421\u0422\u041e\u0424\u041e\u0420", "\u0425\u0420\u0418\u0421\u0422\u041e\u0424\u041e\u0420\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060912", "2060912", "\u041e\u041f 25 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 25 \u041a\u041c", "\u0413", null);
            RailwayStationsDataProvider.put("2060774", "2060774", "\u042e\u0420\u041e\u041c\u041a\u0410", "\u042e\u0420\u041e\u041c\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2061435", "2061435", "\u0420\u0410\u0417\u0418\u041d\u0421\u041a\u0410\u042f", "\u0420\u0410\u0417\u0418\u041d\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061442", "2061442", "\u041d \u0427\u0415\u0411\u041e\u041a\u0421\u0410\u0420", "\u041d\u041e\u0412\u041e\u0427\u0415\u0411\u041e\u041a\u0421\u0410\u0420\u0421\u041a", "\u0413", null);
            RailwayStationsDataProvider.put("2060064", "2060064", "\u0414\u041e\u041b\u0413\u0423\u0428\u0418\u041d\u041e", "\u0414\u041e\u041b\u0413\u0423\u0428\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060759", "2060759", "\u0412\u0410\u0425\u0420\u0423\u0428\u0415\u0412\u041e", "\u0412\u0410\u0425\u0420\u0423\u0428\u0415\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060065", "2060065", "\u0411\u0415\u041b\u041a\u0410 \u0421\u041b\u041e\u0411", "\u0411\u0415\u041b\u041a\u0410 \u0421\u041b\u041e\u0411\u041e\u0414\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060758", "2060758", "\u0421\u041b\u041e\u0411\u041e\u0414\u0421\u041a\u041e\u0415", "\u0421\u041b\u041e\u0411\u041e\u0414\u0421\u041a\u041e\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2060066", "2060066", "\u041a\u0418\u0420\u041e\u0412 \u0417\u0410\u0412", "\u041a\u0418\u0420\u041e\u0412 \u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060724", "2060724", "\u0412\u0415\u0420\u0425\u041e\u0423\u041d\u0416\u0410", "\u0412\u0415\u0420\u0425\u041e\u0423\u041d\u0416\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060726", "2060726", "\u0417\u041b\u041e\u0411\u0418\u041d\u041e", "\u0417\u041b\u041e\u0411\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061582", "2061582", "\u041c\u0415\u041b\u0415\u041d\u041a\u0418", "\u041c\u0415\u041b\u0415\u041d\u041a\u0418", "\u0413", null);
            RailwayStationsDataProvider.put("2060072", "2060072", "\u0427\u0418\u0427\u0415\u0420\u041e\u0412\u041e", "\u0427\u0418\u0427\u0415\u0420\u041e\u0412\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2060697", "2060697", "\u0418\u041d\u0416\u0415\u041d\u0415\u0420\u041d\u0410\u042f", "\u0418\u041d\u0416\u0415\u041d\u0415\u0420\u041d\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061501", "2061501", "\u0412\u0415\u041b \u041e\u0417\u0415\u0420\u041e", "\u0412\u0415\u041b\u0418\u041a\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061618", "2061618", "\u0417\u041e\u041b\u0418\u041d\u041e", "\u0417\u041e\u041b\u0418\u041d\u041e", "\u0413", null);
            RailwayStationsDataProvider.put("2061484", "2061484", "\u0424\u0420\u041e\u041b\u0418\u0429\u0418", "\u0424\u0420\u041e\u041b\u0418\u0429\u0415", "\u0413", null);
            RailwayStationsDataProvider.put("2061530", "2061530", "\u0410\u0412\u0422\u041e\u0417\u0410\u0412\u041e\u0414", "\u0410\u0412\u0422\u041e\u0417\u0410\u0412\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2060763", "2060763", "\u0427\u0415\u041f\u0415\u0426\u041a\u0410\u042f", "\u0427\u0415\u041f\u0415\u0426\u041a\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060665", "2060665", "\u041c\u0423\u0420\u041e\u041c 2", "\u041c\u0423\u0420\u041e\u041c 2", "\u0413", null);
            RailwayStationsDataProvider.put("2061731", "2061731", "\u041a\u0423\u0421\u0422\u041e\u0412\u0410\u042f", "\u041a\u0423\u0421\u0422\u041e\u0412\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061595", "2061595", "\u0421\u0427\u0410\u0421\u0422\u041b\u0418\u0412\u0410\u042f", "\u0421\u0427\u0410\u0421\u0422\u041b\u0418\u0412\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2061454", "2061454", "\u0421\u0410\u0414\u041e\u0412\u0410\u042f", "\u0421\u0410\u0414\u041e\u0412\u0410\u042f", "\u0413", null);
            RailwayStationsDataProvider.put("2060640", "2060640", "\u041e\u0420\u041b\u041e\u0412\u041a\u0410", "\u041e\u0420\u041b\u041e\u0412\u041a\u0410", "\u0413", null);
            RailwayStationsDataProvider.put("2060772", "2060772", "\u041c\u041e\u0425\u041e\u0412 \u0413\u041e\u0420\u042b", "\u041c\u041e\u0425\u041e\u0412\u042b\u0415 \u0413\u041e\u0420\u042b", "\u0413", null);
            RailwayStationsDataProvider.put("2060320", "2060320", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421", "\u0410\u0420\u0417\u0410\u041c\u0410\u0421 \u0413\u041e\u0420\u041e\u0414", "\u0413", null);
            RailwayStationsDataProvider.put("2010226", "2010226", "\u0420\u041e\u0421\u0422\u041e\u0412 \u042f\u0420", "\u0420\u041e\u0421\u0422\u041e\u0412-\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u0421\u041a\u0418\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010813", "2010813", "\u041a\u0423\u0414\u0420\u042f\u0412\u0426\u0415\u0412\u041e", "\u041a\u0423\u0414\u0420\u042f\u0412\u0426\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010804", "2010804", "\u0420\u0415\u041a\u0410", "\u0420\u0415\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010823", "2010823", "\u0425\u041e\u0416\u0410\u0415\u0412\u041e", "\u0425\u041e\u0416\u0410\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010001", "2010001", "\u042f\u0420\u041e\u0421\u041b \u0413\u041b\u0410\u0412", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041b\u042c-\u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010805", "2010805", "\u0421\u041e\u0421\u041d\u041e\u0412\u0426\u042b", "\u0421\u041e\u0421\u041d\u041e\u0412\u0426\u042b", "\u042f", null);
            RailwayStationsDataProvider.put("2010801", "2010801", "\u041a\u041e\u0427\u0415\u041d\u042f\u0422\u0418\u041d\u041e", "\u041a\u041e\u0427\u0415\u041d\u042f\u0422\u0418\u041d\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010819", "2010819", "\u041b\u0415\u0412\u0426\u041e\u0412\u041e", "\u041b\u0415\u0412\u0426\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010809", "2010809", "\u0414\u041e\u0413\u0410\u0414\u0426\u0415\u0412\u041e", "\u0414\u041e\u0413\u0410\u0414\u0426\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010860", "2010860", "\u0421\u041a\u041e\u041c\u041e\u0420\u041e\u0425\u041e\u0412", "\u0421\u041a\u041e\u041c\u041e\u0420\u041e\u0425\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010839", "2010839", "\u041c\u042f\u0421\u041d\u0418\u041a\u041e\u0412\u041a\u0410", "\u041c\u042f\u0421\u041d\u0418\u041a\u041e\u0412\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010829", "2010829", "\u0412\u041e\u041b\u041e\u0426\u041a\u041e\u0419", "\u0412\u041e\u041b\u041e\u0426\u041a\u041e\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010828", "2010828", "\u0411\u0423\u0420\u0414\u0423\u041a\u041e\u0412\u041e", "\u0411\u0423\u0420\u0414\u0423\u041a\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010824", "2010824", "\u0427\u0410\u0425\u041b\u041e\u0412\u041e", "\u0427\u0410\u0425\u041b\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010030", "2010030", "\u0412\u041e\u041b\u041e\u0413\u0414\u0410 1", "\u0412\u041e\u041b\u041e\u0413\u0414\u0410 1", "\u042f", null);
            RailwayStationsDataProvider.put("2010831", "2010831", "\u041f\u041b 497 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 497 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010848", "2010848", "\u0417\u0410\u0418\u041e\u041d\u0418\u041a\u0418\u0415\u0412", "\u0417\u0410\u0418\u041e\u041d\u0418\u041a\u0418\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010845", "2010845", "\u041e\u041b\u0410\u0420\u0415\u0412\u041e", "\u041e\u041b\u0410\u0420\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010867", "2010867", "\u041f\u0410\u041d\u041e\u0412\u041a\u0410", "\u041f\u0410\u041d\u041e\u0412\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010070", "2010070", "\u041a\u041e\u041d\u041e\u0428\u0410 1", "\u041a\u041e\u041d\u041e\u0428\u0410 1", "\u042f", null);
            RailwayStationsDataProvider.put("2010220", "2010220", "\u041d\u042f\u041d\u0414\u041e\u041c\u0410", "\u041d\u042f\u041d\u0414\u041e\u041c\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010032", "2010032", "\u041f\u041b\u0415\u0421\u0415\u0426\u041a\u0410\u042f", "\u041f\u041b\u0415\u0421\u0415\u0426\u041a\u0410\u042f", "\u042f", null);
            RailwayStationsDataProvider.put("2010009", "2010009", "\u041c\u0410\u041b\u042c\u041a\u0410", "\u041c\u0410\u041b\u042c\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010007", "2010007", "\u041b\u0418\u0421\u0422\u0412\u0415\u041d\u041d\u0418\u0427", "\u041b\u0418\u0421\u0422\u0412\u0415\u041d\u041d\u0418\u0427\u041d\u042b\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010806", "2010806", "\u0420\u0417\u0414 16 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 16 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010855", "2010855", "\u0420\u0417\u0414 28 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 28 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010207", "2010207", "\u041f\u0420\u0415\u0414\u0423\u0417\u041b\u041e\u0412", "\u041f\u0420\u0415\u0414\u0423\u0417\u041b\u041e\u0412\u041e\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010069", "2010069", "\u041e\u041f 300 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 300 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010090", "2010090", "\u041a\u041e\u0421\u0422\u0420\u041e\u041c\u0410 \u041d", "\u041a\u041e\u0421\u0422\u0420\u041e\u041c\u0410 \u041d\u041e\u0412\u0410\u042f", "\u042f", null);
            RailwayStationsDataProvider.put("2010269", "2010269", "\u0413\u0410\u041b\u0418\u0427", "\u0413\u0410\u041b\u0418\u0427", "\u042f", null);
            RailwayStationsDataProvider.put("2010010", "2010010", "\u0411\u0423\u0419", "\u0411\u0423\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010319", "2010319", "\u041a\u0418\u041f\u0420\u0415\u0412\u041e", "\u041a\u0418\u041f\u0420\u0415\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010317", "2010317", "\u041a\u041e\u041b\u042c\u0427\u0423\u0413\u0418\u041d\u041e", "\u041a\u041e\u041b\u042c\u0427\u0423\u0413\u0418\u041d\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010310", "2010310", "\u042e\u0420\u042c\u0415\u0412 \u041f\u041e\u041b\u042c", "\u042e\u0420\u042c\u0415\u0412-\u041f\u041e\u041b\u042c\u0421\u041a\u0418\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010313", "2010313", "\u0413\u0410\u0412\u0420 \u041f\u041e\u0421\u0410\u0414", "\u0413\u0410\u0412\u0420\u0418\u041b\u041e\u0412 \u041f\u041e\u0421\u0410\u0414", "\u042f", null);
            RailwayStationsDataProvider.put("2010312", "2010312", "\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u042f", null);
            RailwayStationsDataProvider.put("2010308", "2010308", "\u0422\u0415\u0419\u041a\u041e\u0412\u041e", "\u0422\u0415\u0419\u041a\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010050", "2010050", "\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010871", "2010871", "\u041f\u0410\u0427\u0415\u0412\u0421\u041a\u0418\u0419", "\u041f\u0410\u0427\u0415\u0412\u0421\u041a\u0418\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010173", "2010173", "\u041a\u0423\u0412\u0410\u0428", "\u041a\u0423\u0412\u0410\u0428", "\u042f", null);
            RailwayStationsDataProvider.put("2010020", "2010020", "\u0412\u0415\u041b\u042c\u0421\u041a", "\u0412\u0415\u041b\u042c\u0421\u041a", "\u042f", null);
            RailwayStationsDataProvider.put("2010160", "2010160", "\u041a\u041e\u0422\u041b\u0410\u0421 \u042e\u0416\u041d", "\u041a\u041e\u0422\u041b\u0410\u0421 \u042e\u0416\u041d\u042b\u0419", "\u042f", null);
            RailwayStationsDataProvider.put("2010838", "2010838", "\u0412\u0410\u0422\u0421\u0410", "\u0412\u0410\u0422\u0421\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010208", "2010208", "\u041f\u041e\u0421\u041d\u0410", "\u041f\u041e\u0421\u041d\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010210", "2010210", "\u041c\u0418\u041a\u0423\u041d\u042c", "\u041c\u0418\u041a\u0423\u041d\u042c", "\u042f", null);
            RailwayStationsDataProvider.put("2010209", "2010209", "\u0420\u041e\u041f\u0427\u0410", "\u0420\u041e\u041f\u0427\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010095", "2010095", "\u0423\u0425\u0422\u0410", "\u0423\u0425\u0422\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010270", "2010270", "\u0421\u041e\u0421\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u0421\u041e\u0421\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u042f", null);
            RailwayStationsDataProvider.put("2010240", "2010240", "\u041f\u0415\u0427\u041e\u0420\u0410", "\u041f\u0415\u0427\u041e\u0420\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010074", "2010074", "\u0418\u041d\u0422\u0410 1", "\u0418\u041d\u0422\u0410 1", "\u042f", null);
            RailwayStationsDataProvider.put("2011238", "2011238", "\u0422\u0423\u0420\u0423\u041d", "\u0422\u0423\u0420\u0423\u041d", "\u042f", null);
            RailwayStationsDataProvider.put("2011248", "2011248", "\u0422\u0410\u041b\u042c\u041d\u0418\u041a", "\u0422\u0410\u041b\u042c\u041d\u0418\u041a", "\u042f", null);
            RailwayStationsDataProvider.put("2010329", "2010329", "\u042d\u0416\u0412\u0410", "\u042d\u0416\u0412\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2010331", "2010331", "\u041f\u0420\u0418\u0412\u041e\u0414\u0418\u041d\u041e", "\u041f\u0420\u0418\u0412\u041e\u0414\u0418\u041d\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010861", "2010861", "\u041f\u041b 335 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 335 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010002", "2010002", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412 \u041f", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041b\u042c \u041f\u0410\u0421\u0421", "\u042f", null);
            RailwayStationsDataProvider.put("2011214", "2011214", "\u0420\u0417\u0414 30 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 30 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010332", "2010332", "\u042e\u041a\u041e\u0421\u0422", "\u042e\u041a\u041e\u0421\u0422", "\u042f", null);
            RailwayStationsDataProvider.put("2011221", "2011221", "\u0420\u0417\u0414 84 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 84 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010816", "2010816", "\u041e\u041f 707 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 707 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2010254", "2010254", "\u041c\u0410\u041d\u0422\u0423\u0420\u041e\u0412\u041e", "\u041c\u0410\u041d\u0422\u0423\u0420\u041e\u0412\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2010249", "2010249", "\u0428\u0410\u0420\u042c\u042f", "\u0428\u0410\u0420\u042c\u042f", "\u042f", null);
            RailwayStationsDataProvider.put("2010333", "2010333", "\u0411 \u0421\u041b\u041e\u0411\u041e\u0414\u041a\u0410", "\u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0421\u041b\u041e\u0411\u041e\u0414\u041a\u0410", "\u042f", null);
            RailwayStationsDataProvider.put("2201004", "2201004", "\u041a\u041b\u0415\u0412\u0410\u041d\u042c", "\u041a\u041b\u0415\u0412\u0410\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200298", "2200298", "\u042d\u0421\u041c\u0410\u041d\u042c", "\u042d\u0421\u041c\u0410\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200775", "2200775", "\u0425\u041e\u041b\u041c\u041e\u0412\u041a\u0410", "\u0425\u041e\u041b\u041c\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201002", "2201002", "\u0421\u0412\u0415\u0421\u0410", "\u0421\u0412\u0415\u0421\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200010", "2200010", "\u0425\u0423\u0422\u041e\u0420 \u041c\u0418\u0425", "\u0425\u0423\u0422\u041e\u0420-\u041c\u0418\u0425\u0410\u0419\u041b\u041e\u0412\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200050", "2200050", "\u0412\u041e\u0420\u041e\u0416\u0411\u0410", "\u0412\u041e\u0420\u041e\u0416\u0411\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201274", "2201274", "\u0412\u042f\u0417\u041e\u0412\u041e\u0415", "\u0412\u042f\u0417\u041e\u0412\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200287", "2200287", "\u0414\u0423\u0411\u041e\u0412\u042f\u0417\u041e\u0412\u041a", "\u0414\u0423\u0411\u041e\u0412\u042f\u0417\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201272", "2201272", "\u0414\u0416\u0418\u0413\u0410\u0415\u0412\u041a\u0410", "\u0414\u0416\u0418\u0413\u0410\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201226", "2201226", "\u041a \u041a\u041e\u041c\u041c\u0423\u041d\u0410", "\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421\u041a\u0410\u042f \u041a\u041e\u041c\u041c\u0423\u041d\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201183", "2201183", "\u0416 \u0411\u0415\u0422\u041e\u041d\u041d\u042b\u0419", "\u0416\u0415\u041b\u0415\u0417\u041e\u0411\u0415\u0422\u041e\u041d\u041d\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200040", "2200040", "\u041a\u041e\u041d\u041e\u0422\u041e\u041f", "\u041a\u041e\u041d\u041e\u0422\u041e\u041f", "\u041a", null);
            RailwayStationsDataProvider.put("2200600", "2200600", "\u0427\u0415\u0420\u041d\u0418\u0413\u041e\u0412", "\u0427\u0415\u0420\u041d\u0418\u0413\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201209", "2201209", "\u0414\u0420\u0415\u041c\u0410\u0419\u041b\u041e\u0412\u041a", "\u0414\u0420\u0415\u041c\u0410\u0419\u041b\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200070", "2200070", "\u041d\u0415\u0416\u0418\u041d", "\u041d\u0415\u0416\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200810", "2200810", "\u0417\u0415\u0420\u041d\u041e\u0412\u041e", "\u0417\u0415\u0420\u041d\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2202248", "2202248", "\u0420\u0415\u0422\u042c", "\u0420\u0415\u0422\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200020", "2200020", "\u041a\u0420\u041e\u041b\u0415\u0412\u0415\u0426", "\u041a\u0420\u041e\u041b\u0415\u0412\u0415\u0426", "\u041a", null);
            RailwayStationsDataProvider.put("2201257", "2201257", "\u041b\u0410\u041f\u0428\u0418\u041d", "\u041b\u0410\u041f\u0428\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2201293", "2201293", "\u041f\u0420\u0418\u0421\u0415\u0419\u041c\u041e\u0412", "\u041f\u0420\u0418\u0421\u0415\u0419\u041c\u041e\u0412\u042c\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200030", "2200030", "\u0411\u0410\u0425\u041c\u0410\u0427 \u041f\u0410\u0421", "\u0411\u0410\u0425\u041c\u0410\u0427-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2201244", "2201244", "\u0412 \u0417\u0410\u0413\u041e\u0420\u041e\u0412\u041a", "\u0412\u0415\u041b\u0418\u041a\u0410\u042f \u0417\u0410\u0413\u041e\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201239", "2201239", "\u0425 \u041e\u0417\u0415\u0420\u041e", "\u0425\u041e\u0420\u041e\u0428\u0415\u0415 \u041e\u0417\u0415\u0420\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201224", "2201224", "\u041f\u0420\u0418\u041e\u0421\u0422\u0415\u0420\u041d", "\u041f\u0420\u0418\u041e\u0421\u0422\u0415\u0420\u041d\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200308", "2200308", "\u041b\u042e\u0422\u041e\u0412\u041a\u0410", "\u041b\u042e\u0422\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201151", "2201151", "\u041f\u0415\u0420\u0415\u041f\u0418\u0421\u042c", "\u041f\u0415\u0420\u0415\u041f\u0418\u0421\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200309", "2200309", "\u041b\u0423\u041a\u041e\u0428\u041a\u041e", "\u041b\u0423\u041a\u041e\u0428\u041a\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201196", "2201196", "\u041a\u0420 \u041f\u0410\u0420\u0422\u0418\u0417", "\u041a\u0420\u0410\u0421\u041d\u042b\u0415 \u041f\u0410\u0420\u0422\u0418\u0417\u0410\u041d\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201179", "2201179", "\u041a\u041e\u0421\u041c\u0418\u0427\u0415\u0421\u041a", "\u041a\u041e\u0421\u041c\u0418\u0427\u0415\u0421\u041a\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2201163", "2201163", "\u041f\u041e\u041f\u0423\u0414\u0420\u0415\u041d\u041a\u041e", "\u041f\u041e\u041f\u0423\u0414\u0420\u0415\u041d\u041a\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201138", "2201138", "\u041c\u0410\u041a\u0410\u0420\u041e\u0412\u041a\u0410", "\u041c\u0410\u041a\u0410\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201192", "2201192", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041a\u0410", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201127", "2201127", "\u0421\u0415\u041c\u0418\u041f\u041e\u041b\u041a\u0418", "\u0421\u0415\u041c\u0418\u041f\u041e\u041b\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201235", "2201235", "\u0411\u041e\u0411\u0420\u0418\u041a", "\u0411\u041e\u0411\u0420\u0418\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2201129", "2201129", "\u0416\u0415\u0420\u0414\u041e\u0412\u041e", "\u0416\u0415\u0420\u0414\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201285", "2201285", "\u0414\u042b\u041c\u0415\u0420\u041a\u0410", "\u0414\u042b\u041c\u0415\u0420\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201245", "2201245", "\u041f\u0410\u0420\u041d\u0418\u041a\u041e\u0412\u0410\u042f", "\u041f\u0410\u0420\u041d\u0418\u041a\u041e\u0412\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2201164", "2201164", "\u041a\u0412\u0418\u0422\u041d\u0415\u0412\u042b\u0419", "\u041a\u0412\u0418\u0422\u041d\u0415\u0412\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200053", "2200053", "\u0411\u0420\u041e\u0412\u0410\u0420\u042b", "\u0411\u0420\u041e\u0412\u0410\u0420\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201205", "2201205", "\u041a\u041d\u042f\u0416\u0418\u0427\u0418", "\u041a\u041d\u042f\u0416\u0418\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200007", "2200007", "\u0414\u0410\u0420\u041d\u0418\u0426\u0410", "\u0414\u0410\u0420\u041d\u0418\u0426\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201155", "2201155", "\u041f\u0420\u041e\u0422\u0410\u0421 \u042f\u0420", "\u041f\u0420\u041e\u0422\u0410\u0421\u041e\u0412 \u042f\u0420", "\u041a", null);
            RailwayStationsDataProvider.put("2200001", "2200001", "\u041a\u0418\u0415\u0412 \u041f\u0410\u0421\u0421", "\u041a\u0418\u0415\u0412-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200311", "2200311", "\u041a\u0410\u0420\u0410\u0412 \u0414\u0410\u0427\u0418", "\u041a\u0410\u0420\u0410\u0412\u0410\u0415\u0412\u042b \u0414\u0410\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200003", "2200003", "\u041a\u0418\u0415\u0412 \u0412\u041e\u041b\u042b\u041d", "\u041a\u0418\u0415\u0412-\u0412\u041e\u041b\u042b\u041d\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200006", "2200006", "\u0412\u0418\u0428\u041d\u0415\u0412\u041e\u0415", "\u0412\u0418\u0428\u041d\u0415\u0412\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2201152", "2201152", "\u041a\u0420\u042e\u041a\u041e\u0412\u0429\u0418\u041d\u0410", "\u041a\u0420\u042e\u041a\u041e\u0412\u0429\u0418\u041d\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201135", "2201135", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u041a\u0410", "\u0422\u0410\u0420\u0410\u0421\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200312", "2200312", "\u041c\u0410\u041b\u042e\u0422\u0418\u041d\u041a\u0410", "\u041c\u0410\u041b\u042e\u0422\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201145", "2201145", "\u0413\u041b\u0415\u0412\u0410\u0425\u0410", "\u0413\u041b\u0415\u0412\u0410\u0425\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200139", "2200139", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a 1", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a\u041e\u0412 1", "\u041a", null);
            RailwayStationsDataProvider.put("2201220", "2201220", "\u041a\u041e\u0420\u0427\u0418", "\u041a\u041e\u0420\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201265", "2201265", "\u0411\u0415\u041b\u041a\u0418", "\u0411\u0415\u041b\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201260", "2201260", "\u041f\u0418\u0412\u041d\u0418", "\u041f\u0418\u0412\u041d\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201275", "2201275", "\u0412\u0418\u0428\u041d\u042f\u041a\u0418", "\u0412\u0418\u0428\u041d\u042f\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201241", "2201241", "\u0421\u041e\u0420\u041e\u0427 \u0411\u0420\u041e\u0414", "\u0421\u041e\u0420\u041e\u0427\u0418\u0419 \u0411\u0420\u041e\u0414", "\u041a", null);
            RailwayStationsDataProvider.put("2201298", "2201298", "\u0421\u041d\u0415\u0422\u0418\u041d\u041a\u0410", "\u0421\u041d\u0415\u0422\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200150", "2200150", "\u0424\u0410\u0421\u0422\u041e\u0412 1", "\u0424\u0410\u0421\u0422\u041e\u0412 1", "\u041a", null);
            RailwayStationsDataProvider.put("2204550", "2204550", "\u0413\u0420\u0415\u0411\u0415\u041d\u041a\u0410", "\u0413\u0420\u0415\u0411\u0415\u041d\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2201201", "2201201", "\u0421\u041b \u041f\u0415\u0422\u0420\u041e\u0412", "\u0421\u041b\u041e\u0411\u041e\u0414\u0410 \u041f\u0415\u0422\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201149", "2201149", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u041a\u0410", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200059", "2200059", "\u042f\u0413\u041e\u0422\u0418\u041d", "\u042f\u0413\u041e\u0422\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200313", "2200313", "\u0425\u041c\u0415\u041b\u0415\u0412\u0418\u041a", "\u0425\u041c\u0415\u041b\u0415\u0412\u0418\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200314", "2200314", "\u041a\u041e\u0420\u0416\u0418", "\u041a\u041e\u0420\u0416\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201315", "2201315", "\u0421\u0410\u041b\u042b\u0427\u0415\u0412\u041a\u0410", "\u0421\u0410\u041b\u042b\u0427\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201182", "2201182", "\u041c\u0410\u0419\u0421\u041a\u0410\u042f", "\u041c\u0410\u0419\u0421\u041a\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2200064", "2200064", "\u0411\u041e\u0420\u0418\u0421\u041f\u041e\u041b\u042c", "\u0411\u041e\u0420\u0418\u0421\u041f\u041e\u041b\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2201132", "2201132", "\u0424\u0410\u0420\u041c\u0410\u0426\u0415\u0412\u0422", "\u0424\u0410\u0420\u041c\u0410\u0426\u0415\u0412\u0422\u0418\u0427\u0415\u0421\u041a\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2201181", "2201181", "\u0422\u0420\u0418\u041b\u0415\u0421\u042b", "\u0422\u0420\u0418\u041b\u0415\u0421\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201203", "2201203", "\u0427\u0415\u0420\u041d\u042f\u0412\u041a\u0410", "\u0427\u0415\u0420\u041d\u042f\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201276", "2201276", "\u0421\u0410\u0412\u0415\u0420\u0426\u042b", "\u0421\u0410\u0412\u0415\u0420\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201231", "2201231", "\u0412\u0427\u0415\u0420\u0410\u0419\u0428\u0415", "\u0412\u0427\u0415\u0420\u0410\u0419\u0428\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200316", "2200316", "\u0412\u0415\u0420\u041d\u0418\u0413\u041e\u0420\u041e\u0414", "\u0412\u0415\u0420\u041d\u0418\u0413\u041e\u0420\u041e\u0414\u041e\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200302", "2200302", "\u041a\u0410\u0417\u0410\u0422 \u0422\u041e\u0412", "\u041a\u0410\u0417\u0410\u0422\u0418\u041d \u0422\u041e\u0412\u0410\u0420\u041d\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200170", "2200170", "\u041a\u0410\u0417\u0410\u0422 \u041f\u0410\u0421\u0421", "\u041a\u0410\u0417\u0410\u0422\u0418\u041d-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200317", "2200317", "\u0411\u041f 173 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 173 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200318", "2200318", "\u0412\u0418\u041d\u041d\u0418\u0426\u0410 \u0413\u0420", "\u0412\u0418\u041d\u041d\u0418\u0426\u0410 \u0413\u0420\u0423\u0417\u041e\u0412\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2200200", "2200200", "\u0412\u0418\u041d\u041d\u0418\u0426\u0410", "\u0412\u0418\u041d\u041d\u0418\u0426\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201131", "2201131", "\u042f\u0420\u042b\u0428\u0415\u0412\u041a\u0410", "\u042f\u0420\u042b\u0428\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201153", "2201153", "\u041c\u041e\u0413\u0418\u041b\u0415\u0412\u041a\u0410", "\u041c\u041e\u0413\u0418\u041b\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200270", "2200270", "\u0416\u041c\u0415\u0420\u0418\u041d\u041a\u0410", "\u0416\u041c\u0415\u0420\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201207", "2201207", "\u0411\u0423\u0428\u0418\u041d\u041a\u0410", "\u0411\u0423\u0428\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201222", "2201222", "\u0428\u041f\u0418\u041a\u041e\u0412", "\u0428\u041f\u0418\u041a\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201234", "2201234", "\u0428\u0423\u0420\u0410", "\u0428\u0423\u0420\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2208430", "2208430", "\u0412\u0410\u041f\u041d\u042f\u0420\u041a\u0410", "\u0412\u0410\u041f\u041d\u042f\u0420\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2201197", "2201197", "\u041f\u041e\u041b\u0415\u041d\u0418\u0427\u0415\u041d", "\u041f\u041e\u041b\u0415\u041d\u0418\u0427\u0415\u041d\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201174", "2201174", "\u0413\u0410\u0419", "\u0413\u0410\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200180", "2200180", "\u0411\u0415\u041b\u0410\u042f \u0426\u0415\u0420\u041a", "\u0411\u0415\u041b\u0410\u042f \u0426\u0415\u0420\u041a\u041e\u0412\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2201214", "2201214", "\u0422\u041e\u041c\u0418\u041b\u041e\u0412\u041a\u0410", "\u0422\u041e\u041c\u0418\u041b\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201134", "2201134", "\u0411\u0418\u0420\u042e\u041a\u0418", "\u0411\u0418\u0420\u042e\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201202", "2201202", "\u0427\u0415\u041f\u0415\u041b\u0418\u0415\u0412\u041a\u0410", "\u0427\u0415\u041f\u0415\u041b\u0418\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201161", "2201161", "\u0411\u0423\u0428\u0415\u0412\u041e", "\u0411\u0423\u0428\u0415\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200319", "2200319", "\u041b\u042e\u0422\u0410\u0420\u0421\u041a\u0418\u0419", "\u041b\u042e\u0422\u0410\u0420\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200321", "2200321", "\u041e\u041f 98 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 98 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200190", "2200190", "\u041c\u0418\u0420\u041e\u041d\u041e\u0412\u041a\u0410", "\u041c\u0418\u0420\u041e\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200090", "2200090", "\u041e\u0412\u0420\u0423\u0427", "\u041e\u0412\u0420\u0423\u0427", "\u041a", null);
            RailwayStationsDataProvider.put("2200110", "2200110", "\u041a\u041e\u0420\u041e\u0421\u0422\u0415\u041d\u042c", "\u041a\u041e\u0420\u041e\u0421\u0422\u0415\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200400", "2200400", "\u0416\u0418\u0422\u041e\u041c\u0418\u0420", "\u0416\u0418\u0422\u041e\u041c\u0418\u0420", "\u041a", null);
            RailwayStationsDataProvider.put("2201287", "2201287", "\u0411\u042b\u0421\u0422\u0420\u0410", "\u0411\u042b\u0421\u0422\u0420\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200120", "2200120", "\u0411\u0415\u0420\u0414\u0418\u0427\u0415\u0412", "\u0411\u0415\u0420\u0414\u0418\u0427\u0415\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201256", "2201256", "\u0414\u0418\u0412\u041b\u0418\u041d", "\u0414\u0418\u0412\u041b\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2201246", "2201246", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u0418", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201271", "2201271", "\u0412\u041e\u0417\u041b\u042f\u041a\u041e\u0412\u041e", "\u0412\u041e\u0417\u041b\u042f\u041a\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201296", "2201296", "\u0412\u041e\u041b\u041e\u0428\u0418\u041d\u041e", "\u0412\u041e\u041b\u041e\u0428\u0418\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200008", "2200008", "\u0421\u0412\u042f\u0422\u041e\u0428\u0418\u041d\u041e", "\u0421\u0412\u042f\u0422\u041e\u0428\u0418\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200083", "2200083", "\u0418\u0420\u041f\u0415\u041d\u042c", "\u0418\u0420\u041f\u0415\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2201240", "2201240", "\u041a\u0418\u0427\u0415\u0415\u0412\u041e", "\u041a\u0418\u0427\u0415\u0415\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200088", "2200088", "\u0411\u041e\u0420\u041e\u0414\u042f\u041d\u041a\u0410", "\u0411\u041e\u0420\u041e\u0414\u042f\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201166", "2201166", "\u0425\u0423\u0422\u041e\u0420 \u0413\u0410\u0419", "\u0425\u0423\u0422\u041e\u0420-\u0413\u0410\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2201123", "2201123", "\u0417\u0410\u0413\u0410\u041b\u042c\u0426\u042b", "\u0417\u0410\u0413\u0410\u041b\u042c\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201281", "2201281", "\u041f\u0418\u0421\u041a\u0418", "\u041f\u0418\u0421\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201177", "2201177", "\u041c\u0410\u041a\u0410\u041b\u0415\u0412\u0418\u0427\u0418", "\u041c\u0410\u041a\u0410\u041b\u0415\u0412\u0418\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200327", "2200327", "\u0429\u0415\u0411\u0417\u0410\u0412\u041e\u0414", "\u0429\u0415\u0411\u0417\u0410\u0412\u041e\u0414", "\u041a", null);
            RailwayStationsDataProvider.put("2200328", "2200328", "\u0414\u0420\u0415\u0412\u041b\u042f\u041d\u041a\u0410", "\u0414\u0420\u0415\u0412\u041b\u042f\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200329", "2200329", "\u041b\u041e\u0422\u041e\u0421", "\u041b\u041e\u0422\u041e\u0421", "\u041a", null);
            RailwayStationsDataProvider.put("2201193", "2201193", "\u0418\u0412\u041d\u0418\u0426\u0410", "\u0418\u0412\u041d\u0418\u0426\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200710", "2200710", "\u041d\u041e\u0412 \u0411\u042b\u0421\u0422\u0420\u0410", "\u041d\u041e\u0412\u0410\u042f \u0411\u042b\u0421\u0422\u0420\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200715", "2200715", "\u041d\u041e\u0412 \u0412\u042b\u0413\u041e\u0414\u0410", "\u041d\u041e\u0412\u0410\u042f \u0412\u042b\u0413\u041e\u0414\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2202261", "2202261", "\u041a\u041e\u041b\u041e\u0414\u0418\u0415\u0412\u041a\u0410", "\u041a\u041e\u041b\u041e\u0414\u0418\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200731", "2200731", "\u0421\u0422\u0420\u0418\u0411\u0415\u0416", "\u0421\u0422\u0420\u0418\u0411\u0415\u0416", "\u041a", null);
            RailwayStationsDataProvider.put("2200748", "2200748", "\u0425\u041e\u0414\u041e\u0420\u041e\u0412\u041a\u0410", "\u0425\u041e\u0414\u041e\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200752", "2200752", "\u0422\u0415\u0422\u0415\u0420\u041a\u0410", "\u0422\u0415\u0422\u0415\u0420\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200786", "2200786", "\u0411\u0410\u0420\u0412\u0418\u041d\u041e\u0412\u041a\u0410", "\u0411\u0410\u0420\u0412\u0418\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201787", "2201787", "\u0413\u0423\u041b\u042c\u0421\u041a", "\u0413\u0423\u041b\u042c\u0421\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2201788", "2201788", "\u0421\u041c\u041e\u041b\u041a\u0410", "\u0421\u041c\u041e\u041b\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200220", "2200220", "\u0428\u0415\u041f\u0415\u0422\u041e\u0412\u041a\u0410", "\u0428\u0415\u041f\u0415\u0422\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201173", "2201173", "\u0421\u0415\u041b\u041e \u041a\u0410\u041c\u0415\u041d", "\u0421\u0415\u041b\u041e \u041a\u0410\u041c\u0415\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2218010", "2218010", "\u0417\u0414\u041e\u041b\u0411\u0423\u041d\u041e\u0412", "\u0417\u0414\u041e\u041b\u0411\u0423\u041d\u041e\u0412", "\u041b", null);
            RailwayStationsDataProvider.put("2201789", "2201789", "\u041f\u0410\u041b\u0418\u0415\u0412\u041a\u0410", "\u041f\u0410\u041b\u0418\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200280", "2200280", "\u041c\u041e\u0413\u0418\u041b \u041f\u041e\u0414", "\u041c\u041e\u0413\u0418\u041b\u0415\u0412-\u041f\u041e\u0414\u041e\u041b\u042c\u0421\u041a\u0418\u0419   .", "\u041a", null);
            RailwayStationsDataProvider.put("2201278", "2201278", "\u041b\u041e\u041f\u0410\u0422\u0418\u041d\u0426\u042b", "\u041b\u041e\u041f\u0410\u0422\u0418\u041d\u0418\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201186", "2201186", "\u0414\u0423\u0411\u041a\u0418", "\u0414\u0423\u0411\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201269", "2201269", "\u0413\u0420\u0418\u0428\u041a\u0418", "\u0413\u0420\u0418\u0428\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201162", "2201162", "\u0420\u0410\u0414\u041e\u0412\u0426\u042b", "\u0420\u0410\u0414\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201187", "2201187", "\u0412 \u0423\u0427\u0410\u0421\u0422\u041e\u041a", "\u0412\u0415\u0420\u0425\u041d\u0418\u0419 \u0423\u0427\u0410\u0421\u0422\u041e\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200790", "2200790", "\u0420\u0410\u041a\u041e\u0412\u041e", "\u0420\u0410\u041a\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200300", "2200300", "\u0425\u041c\u0415\u041b\u042c\u041d\u0418\u0426\u041a", "\u0425\u041c\u0415\u041b\u042c\u041d\u0418\u0426\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2201791", "2201791", "\u0413\u0420 \u041f\u0415\u0420\u0415\u0415\u0417\u0414", "\u0413\u0420\u0415\u0427\u0410\u041d\u0421\u041a\u0418\u0419 \u041f\u0415\u0420\u0415\u0415\u0417\u0414", "\u041a", null);
            RailwayStationsDataProvider.put("2200229", "2200229", "\u0413\u0420\u0415\u0427\u0410\u041d\u042b", "\u0413\u0420\u0415\u0427\u0410\u041d\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201266", "2201266", "\u0413\u0420\u0423\u0417\u0415\u0412\u0426\u042b", "\u0413\u0420\u0423\u0417\u0415\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201221", "2201221", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u041a\u0410", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201217", "2201217", "\u0422\u0420\u0415\u0422\u0415\u041b\u042c\u041d\u0418\u041a", "\u0422\u0420\u0415\u0422\u0415\u041b\u042c\u041d\u0418\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201253", "2201253", "\u0413\u0410\u0420\u041d\u042b\u0428\u0415\u0412\u041a\u0410", "\u0413\u0410\u0420\u041d\u042b\u0428\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201792", "2201792", "\u041a\u0423\u0420\u0418\u041b\u041e\u0412\u041a\u0410", "\u041a\u0423\u0420\u0418\u041b\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200240", "2200240", "\u0425\u041c\u0415\u041b\u042c\u041d\u0418\u041a", "\u0425\u041c\u0415\u041b\u042c\u041d\u0418\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200793", "2200793", "\u0418\u0412\u0410\u041d\u041a\u041e\u0412\u0415\u0426\u041a", "\u0418\u0412\u0410\u041d\u041a\u041e\u0412\u0415\u0426\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200794", "2200794", "\u0411\u0423\u0413", "\u0411\u0423\u0413", "\u041a", null);
            RailwayStationsDataProvider.put("2201158", "2201158", "\u0412\u041e\u041b\u041a\u041e\u0412\u0426\u042b", "\u0412\u041e\u041b\u041a\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201277", "2201277", "\u0421\u0410\u0412\u0418\u041d\u0426\u042b", "\u0421\u0410\u0412\u0418\u041d\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201216", "2201216", "\u041d\u0415\u0413\u0418\u041d", "\u041d\u0415\u0413\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200260", "2200260", "\u041a\u0410\u041c\u0415\u041d \u041f\u041e\u0414", "\u041a\u0410\u041c\u0415\u041d\u0415\u0426-\u041f\u041e\u0414\u041e\u041b\u042c\u0421\u041a\u0418\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200796", "2200796", "\u041d\u041e\u0412\u041e\u041b\u0418\u0421\u041e\u0413", "\u041d\u041e\u0412\u041e\u041b\u0418\u0421\u041e\u0413\u041e\u0420\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201232", "2201232", "\u0420\u0410\u0419\u041a\u0418", "\u0420\u0410\u0419\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201157", "2201157", "\u041c\u0418\u0420\u041e\u0421\u041b\u0410\u0412\u041a\u0410", "\u041c\u0418\u0420\u041e\u0421\u041b\u0410\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201141", "2201141", "\u0420\u0410\u0427\u041a\u0418", "\u0420\u0410\u0427\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200797", "2200797", "\u0412\u0410\u041a\u0423\u041b\u0415\u041d\u0427\u0423\u041a", "\u0412\u0410\u041a\u0423\u041b\u0415\u041d\u0427\u0423\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2201229", "2201229", "\u0414\u041e\u0412\u0411\u0418\u0429\u0415", "\u0414\u041e\u0412\u0411\u0418\u0429\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2201191", "2201191", "\u0413\u041e\u0420\u0414\u0418\u0415\u0412\u041a\u0410", "\u0413\u041e\u0420\u0414\u0418\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200798", "2200798", "\u0414\u0415\u0420\u0422\u041a\u0410", "\u0414\u0415\u0420\u0422\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201267", "2201267", "\u0411\u041b\u042b\u0414\u041d\u0418", "\u0411\u041b\u042b\u0414\u041d\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201143", "2201143", "\u041f\u041e\u041d\u0418\u041d\u041a\u0410", "\u041f\u041e\u041d\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200799", "2200799", "\u0413\u0410\u041d\u0423\u0421\u0418\u041d\u041e", "\u0413\u0410\u041d\u0423\u0421\u0418\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201194", "2201194", "\u041f\u041e\u041b\u042f\u041d\u042b", "\u041f\u041e\u041b\u042f\u041d\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201211", "2201211", "\u041d\u041e\u0412\u0418\u0427\u0418", "\u041d\u041e\u0412\u0418\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201023", "2201023", "\u041f\u0410\u0428\u0423\u041a\u0418", "\u041f\u0410\u0428\u0423\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201213", "2201213", "\u0412\u0418\u0422\u041e\u0412\u0426\u042b", "\u0412\u0418\u0422\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201024", "2201024", "\u0421\u0410\u0416\u041a\u0418", "\u0421\u0410\u0416\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2208425", "2208425", "\u0417\u042f\u0422\u041a\u041e\u0412\u0426\u042b", "\u0417\u042f\u0422\u041a\u041e\u0412\u0426\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2201025", "2201025", "\u0416\u0418\u041b\u0415\u041d\u0426\u042b", "\u0416\u0418\u041b\u0415\u041d\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201292", "2201292", "\u041f\u0420\u0418\u041f\u0423\u0422\u041d\u0418", "\u041f\u0420\u0418\u041f\u0423\u0422\u041d\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201026", "2201026", "\u0412\u0418\u041b\u042c\u0428\u0410\u041d\u0418\u0426\u0410", "\u0412\u0418\u041b\u042c\u0428\u0410\u041d\u0418\u0426\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201027", "2201027", "\u042e\u0421\u042c\u041a\u041e\u0412\u0426\u042b", "\u042e\u0421\u042c\u041a\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201259", "2201259", "\u041a\u0423\u0420\u0410\u0412\u0410", "\u041a\u0423\u0420\u0410\u0412\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201273", "2201273", "\u041f \u041b\u0418\u0421\u0410\u0415\u0412\u041a\u0410", "\u041f\u041e\u041b\u0415\u0412\u0410\u042f \u041b\u0418\u0421\u0410\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201028", "2201028", "\u0421\u041e\u0411\u042b\u0427\u0415\u0412", "\u0421\u041e\u0411\u042b\u0427\u0415\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201029", "2201029", "\u0421\u041b\u041e\u0423\u0422", "\u0421\u041b\u041e\u0423\u0422", "\u041a", null);
            RailwayStationsDataProvider.put("2201282", "2201282", "\u0411\u0415\u0420\u0415\u0417\u041a\u0410", "\u0411\u0415\u0420\u0415\u0417\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201171", "2201171", "\u041e\u0421\u041e\u0422\u0410", "\u041e\u0421\u041e\u0422\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201251", "2201251", "\u0411\u0420\u0418\u0413\u0410\u0414\u041d\u042b\u0419", "\u0411\u0420\u0418\u0413\u0410\u0414\u041d\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2201030", "2201030", "\u041b\u041e\u041a\u041e\u0422\u041a\u0418", "\u041b\u041e\u041a\u041e\u0422\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200016", "2200016", "\u0428\u041e\u0421\u0422\u041a\u0410", "\u0428\u041e\u0421\u0422\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201031", "2201031", "\u0425\u0418\u041c\u0418\u041a\u041e\u0412", "\u0425\u0418\u041c\u0418\u041a\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201142", "2201142", "\u0411\u041e\u0413\u0414\u0410\u041d\u041a\u0410", "\u0411\u041e\u0413\u0414\u0410\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200331", "2200331", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u041a\u0410", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201032", "2201032", "\u0421\u0422\u0410\u0420 \u0411\u0423\u0414\u0410", "\u0421\u0422\u0410\u0420\u0410\u042f \u0411\u0423\u0414\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201294", "2201294", "\u0412\u0415\u0420\u0415\u0421\u042b", "\u0412\u0415\u0420\u0415\u0421\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2201264", "2201264", "\u0413\u0410\u0414\u0417\u0418\u041d\u041a\u0410", "\u0413\u0410\u0414\u0417\u0418\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201268", "2201268", "\u041a\u041c\u0418\u0422\u041e\u0412", "\u041a\u041c\u0418\u0422\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201033", "2201033", "\u041a\u041e\u0417\u0410\u041a", "\u041a\u041e\u0417\u0410\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2201034", "2201034", "\u0421\u0422\u0420\u042b\u0416\u041e\u0412\u041a\u0410", "\u0421\u0422\u0420\u042b\u0416\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201035", "2201035", "\u0413\u0410\u041b\u0418\u041d\u041e", "\u0413\u0410\u041b\u0418\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2201036", "2201036", "\u0420\u0410\u0421\u0410\u0412\u0410", "\u0420\u0410\u0421\u0410\u0412\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201037", "2201037", "\u041e\u0417\u0415\u0420\u041d\u042b\u0419", "\u041e\u0417\u0415\u0420\u041d\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2201038", "2201038", "\u0413\u041e\u0420\u0414\u042b\u041d\u042c", "\u0413\u041e\u0420\u0414\u042b\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2201039", "2201039", "\u0429\u0415\u0420\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0429\u0415\u0420\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200149", "2200149", "\u0422\u0420\u0418\u041f\u041e\u041b\u042c\u0415 \u0414", "\u0422\u0420\u0418\u041f\u041e\u041b\u042c\u0415 \u0414\u041d\u0415\u041f\u0420\u041e\u0412\u0421\u041a\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2201040", "2201040", "\u0421\u0422\u0423\u0413\u041d\u0410", "\u0421\u0422\u0423\u0413\u041d\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201041", "2201041", "\u041d \u0411\u0415\u0417\u0420\u0410\u0414\u0418\u0427", "\u041d\u041e\u0412\u042b\u0415 \u0411\u0415\u0417\u0420\u0410\u0414\u0418\u0427\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201042", "2201042", "\u0420\u041e\u041c\u0410\u041d\u041a\u041e\u0412", "\u0420\u041e\u041c\u0410\u041d\u041a\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201043", "2201043", "\u041f\u041e\u0414\u0413\u041e\u0420\u0426\u042b", "\u041f\u041e\u0414\u0413\u041e\u0420\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200301", "2200301", "\u041f \u041a\u0420\u0418\u0412\u041e\u041d\u041e\u0421", "\u041f\u0415\u0422\u0420 \u041a\u0420\u0418\u0412\u041e\u041d\u041e\u0421", "\u041a", null);
            RailwayStationsDataProvider.put("2201044", "2201044", "\u041f\u0420 \u041d\u0410\u0423\u041a\u0418", "\u041f\u0420\u041e\u0421\u041f\u0415\u041a\u0422 \u041d\u0410\u0423\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2201159", "2201159", "\u041a\u0410\u0420\u0425\u041e\u0412\u041a\u0410", "\u041a\u0410\u0420\u0425\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201252", "2201252", "\u041f\u041b\u0410\u041d\u041e\u0412\u042b\u0419", "\u041f\u041b\u0410\u041d\u041e\u0412\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2202263", "2202263", "\u0414\u0415\u0420\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u0414\u0415\u0420\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201046", "2201046", "\u0427\u0415\u0420 \u0425\u0423\u0422\u041e\u0420", "\u0427\u0415\u0420\u041d\u042f\u0427\u0418\u0419 \u0425\u0423\u0422\u041e\u0420", "\u041a", null);
            RailwayStationsDataProvider.put("2201289", "2201289", "\u0420\u041e\u0421\u041a\u041e\u041f\u0410\u041d\u0415", "\u0420\u041e\u0421\u041a\u041e\u041f\u0410\u041d\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2201047", "2201047", "\u0414\u0420\u0423\u0426\u041a\u0410\u042f", "\u0414\u0420\u0423\u0426\u041a\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2201048", "2201048", "\u0413\u041e\u0420\u041e\u0428\u041a\u041e\u0412", "\u0413\u041e\u0420\u041e\u0428\u041a\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201049", "2201049", "\u041a\u0420\u0418\u0412\u0427\u0423\u041d\u041a\u0410", "\u041a\u0420\u0418\u0412\u0427\u0423\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2201051", "2201051", "\u041f\u041b\u0418\u0421\u041a\u041e\u0412", "\u041f\u041b\u0418\u0421\u041a\u041e\u0412", "\u041a", null);
            RailwayStationsDataProvider.put("2201136", "2201136", "\u0427\u0415\u0420\u041a\u0415\u0421", "\u0427\u0415\u0420\u041a\u0415\u0421", "\u041a", null);
            RailwayStationsDataProvider.put("2201008", "2201008", "\u0428\u0415\u0427\u041a\u041e\u0412\u041e", "\u0428\u0415\u0427\u041a\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200706", "2200706", "\u0413\u0423\u0414\u041e\u0412\u041e", "\u0413\u0423\u0414\u041e\u0412\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200361", "2200361", "\u0421\u0415\u041b\u042c\u0426\u041e", "\u0421\u0415\u041b\u042c\u0426\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2218300", "2218300", "\u0422\u0415\u0420\u041d\u041e\u041f\u041e\u041b\u042c", "\u0422\u0415\u0420\u041d\u041e\u041f\u041e\u041b\u042c", "\u041b", null);
            RailwayStationsDataProvider.put("2218400", "2218400", "\u0420\u041e\u0412\u041d\u041e", "\u0420\u041e\u0412\u041d\u041e", "\u041b", null);
            RailwayStationsDataProvider.put("2219095", "2219095", "\u041a\u0418\u0412\u0415\u0420\u0426\u042b", "\u041a\u0418\u0412\u0415\u0420\u0426\u042b", "\u041b", null);
            RailwayStationsDataProvider.put("2218060", "2218060", "\u041b\u0423\u0426\u041a", "\u041b\u0423\u0426\u041a", "\u041b", null);
            RailwayStationsDataProvider.put("2218255", "2218255", "\u042f\u0420\u0415\u041c\u0427\u0415", "\u042f\u0420\u0415\u041c\u0427\u0415", "\u041b", null);
            RailwayStationsDataProvider.put("2218252", "2218252", "\u0418\u0417\u041e\u0412", "\u0418\u0417\u041e\u0412", "\u041b", null);
            RailwayStationsDataProvider.put("2300597", "2300597", "\u0411\u0415\u041d\u0414\u0415\u0420 2", "\u0411\u0415\u041d\u0414\u0415\u0420 2", "\u042c", null);
            RailwayStationsDataProvider.put("2300610", "2300610", "\u0422\u0418\u0420\u0410\u0421\u041f\u041e\u041b", "\u0422\u0418\u0420\u0410\u0421\u041f\u041e\u041b", "\u042c", null);
            RailwayStationsDataProvider.put("2300590", "2300590", "\u0411\u0415\u041d\u0414\u0415\u0420 1", "\u0411\u0415\u041d\u0414\u0415\u0420 1", "\u042c", null);
            RailwayStationsDataProvider.put("2300001", "2300001", "\u041a\u0418\u0428\u0418\u041d\u042d\u0423 \u0426", "\u041a\u0418\u0428\u0418\u041d\u042d\u0423 \u0426\u0415\u041d\u0422\u0420", "\u042c", null);
            RailwayStationsDataProvider.put("2208470", "2208470", "\u041a\u0420\u042b\u0416\u041e\u041f\u041e\u041b\u042c", "\u041a\u0420\u042b\u0416\u041e\u041f\u041e\u041b\u042c", "\u0428", null);
            RailwayStationsDataProvider.put("2208434", "2208434", "\u0420\u0423\u0414\u041d\u0418\u0426\u0410", "\u0420\u0423\u0414\u041d\u0418\u0426\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208510", "2208510", "\u041a\u041e\u0414\u042b\u041c\u0410", "\u041a\u041e\u0414\u042b\u041c\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208417", "2208417", "\u0421\u041b\u041e\u0411\u041e\u0414\u041a\u0410", "\u0421\u041b\u041e\u0411\u041e\u0414\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208450", "2208450", "\u041a\u041e\u0422\u041e\u0412\u0421\u041a", "\u041a\u041e\u0422\u041e\u0412\u0421\u041a", "\u0428", null);
            RailwayStationsDataProvider.put("2208454", "2208454", "\u041c\u0410\u0420\u0414\u0410\u0420\u041e\u0412\u041a\u0410", "\u041c\u0410\u0420\u0414\u0410\u0420\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208520", "2208520", "\u0417\u0410\u0422\u0418\u0428\u042c\u0415", "\u0417\u0410\u0422\u0418\u0428\u042c\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208460", "2208460", "\u0420\u0410\u0417\u0414\u0415\u041b\u042c\u041d 1", "\u0420\u0410\u0417\u0414\u0415\u041b\u042c\u041d\u0410\u042f 1", "\u0428", null);
            RailwayStationsDataProvider.put("2208001", "2208001", "\u041e\u0414\u0415\u0421\u0421\u0410 \u0413\u041b", "\u041e\u0414\u0415\u0421\u0421\u0410-\u0413\u041b\u0410\u0412\u041d\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208350", "2208350", "\u0418 \u0422 \u0428\u0415\u0412\u0427\u0415\u041d", "\u0418\u041c. \u0422.\u0428\u0415\u0412\u0427\u0415\u041d\u041a\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208346", "2208346", "\u041d\u041e\u0412\u041e\u041c\u0418\u0420\u0413\u041e\u0420", "\u041d\u041e\u0412\u041e\u041c\u0418\u0420\u0413\u041e\u0420\u041e\u0414", "\u0428", null);
            RailwayStationsDataProvider.put("2208347", "2208347", "\u0412\u0418\u0421\u041a\u0410", "\u0412\u0418\u0421\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208488", "2208488", "\u0420\u041e\u0416\u0415\u041d\u041e", "\u0420\u041e\u0416\u0415\u041d\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208348", "2208348", "\u041a\u0410\u041f\u0423\u0421\u0422\u0418\u041d\u041e", "\u041a\u0410\u041f\u0423\u0421\u0422\u0418\u041d\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208349", "2208349", "\u0410\u0414\u0410\u0411\u0410\u0428", "\u0410\u0414\u0410\u0411\u0410\u0428", "\u0428", null);
            RailwayStationsDataProvider.put("2208360", "2208360", "\u041f\u041e\u041c\u041e\u0428\u041d\u0410\u042f", "\u041f\u041e\u041c\u041e\u0428\u041d\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208097", "2208097", "\u0412\u042b\u0421\u041e\u0426\u041a\u041e\u0415", "\u0412\u042b\u0421\u041e\u0426\u041a\u041e\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208331", "2208331", "\u041e\u041b\u0415\u0419\u041d\u0418\u041a\u041e\u0412\u041e", "\u041e\u041b\u0415\u0419\u041d\u0418\u041a\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208405", "2208405", "\u041b\u042e\u0414\u041c\u0418\u041b\u041e\u0412\u041a\u0410", "\u041b\u042e\u0414\u041c\u0418\u041b\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208406", "2208406", "\u041a\u0410\u0412\u0423\u041d\u042b", "\u041a\u0410\u0412\u0423\u041d\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2208092", "2208092", "\u042e\u0416\u041d\u041e\u0423\u041a\u0420\u0410\u0418\u041d", "\u042e\u0416\u041d\u041e\u0423\u041a\u0420\u0410\u0418\u041d\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208407", "2208407", "\u0422\u0420\u0418\u041a\u0420\u0410\u0422\u041d\u041e\u0415", "\u0422\u0420\u0418\u041a\u0420\u0410\u0422\u041d\u041e\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208420", "2208420", "\u0412\u041e\u0417\u041d\u0415\u0421\u0415\u041d\u0421\u041a", "\u0412\u041e\u0417\u041d\u0415\u0421\u0415\u041d\u0421\u041a", "\u0428", null);
            RailwayStationsDataProvider.put("2208409", "2208409", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u0421\u041a", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208396", "2208396", "\u0412\u0415\u0421\u0415\u041b\u0418\u041d\u041e\u0412\u041e", "\u0412\u0415\u0421\u0415\u041b\u0418\u041d\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208397", "2208397", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041e", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208472", "2208472", "\u041a\u041e\u041b\u041e\u0421\u041e\u0412\u041a\u0410", "\u041a\u041e\u041b\u041e\u0421\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208473", "2208473", "\u0411\u0415\u0420\u0415\u0417\u041e\u0412\u041a\u0410", "\u0411\u0415\u0420\u0415\u0417\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208461", "2208461", "\u0420\u0410\u0423\u0425\u041e\u0412\u041a\u0410 1", "\u0420\u0410\u0423\u0425\u041e\u0412\u041a\u0410 1", "\u0428", null);
            RailwayStationsDataProvider.put("2209355", "2209355", "\u041e\u0414\u0415\u0421\u0421\u0410 \u0417 2", "\u041e\u0414\u0415\u0421\u0421\u0410-\u0417\u0410\u0421\u0422\u0410\u0412\u0410 2", "\u0428", null);
            RailwayStationsDataProvider.put("2204599", "2204599", "\u0411\u0423\u0420\u0422\u042b", "\u0411\u0423\u0420\u0422\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2208385", "2208385", "\u041f\u0410\u0412\u041b\u042b\u0428", "\u041f\u0410\u0412\u041b\u042b\u0428", "\u0428", null);
            RailwayStationsDataProvider.put("2208630", "2208630", "\u041a\u041e\u0420\u0418\u0421\u0422\u041e\u0412\u041a\u0410", "\u041a\u041e\u0420\u0418\u0421\u0422\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208394", "2208394", "\u041f\u0410\u041d\u0422\u0410\u0415\u0412\u041a\u0410", "\u041f\u0410\u041d\u0422\u0410\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208390", "2208390", "\u0417\u041d\u0410\u041c\u0415\u041d\u041a\u0410 \u041f", "\u0417\u041d\u0410\u041c\u0415\u041d\u041a\u0410 \u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208351", "2208351", "\u0427\u0415\u0420\u041d\u041e\u041b\u0415\u0421\u0421\u041a", "\u0427\u0415\u0420\u041d\u041e\u041b\u0415\u0421\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208410", "2208410", "\u041a\u0418\u0420\u041e\u0412\u041e\u0413\u0420\u0410\u0414", "\u041a\u0418\u0420\u041e\u0412\u041e\u0413\u0420\u0410\u0414", "\u0428", null);
            RailwayStationsDataProvider.put("2209433", "2209433", "\u041b\u0415\u041b\u0415\u041a\u041e\u0412\u041a\u0410", "\u041b\u0415\u041b\u0415\u041a\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208401", "2208401", "\u041f\u041b\u0415\u0422 \u0422\u0410\u0428\u041b", "\u041f\u041b\u0415\u0422\u0415\u041d\u042b\u0419 \u0422\u0410\u0428\u041b\u042b\u041a", "\u0428", null);
            RailwayStationsDataProvider.put("2208403", "2208403", "\u041d\u041e\u0412\u041e\u0423\u041a\u0420\u0410\u0418\u041d", "\u041d\u041e\u0412\u041e\u0423\u041a\u0420\u0410\u0418\u041d\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209338", "2209338", "\u0411\u0415\u0428\u041a\u0415\u0422\u041e\u0412\u041e", "\u0411\u0415\u0428\u041a\u0415\u0422\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208422", "2208422", "\u041f\u041e\u0414\u0413\u041e\u0420\u041e\u0414\u041d", "\u041f\u041e\u0414\u0413\u041e\u0420\u041e\u0414\u041d\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208119", "2208119", "\u041f\u0415\u0420\u0412\u041c \u041d\u0410 \u0411", "\u041f\u0415\u0420\u0412\u041e\u041c\u0410\u0419\u0421\u041a-\u041d\u0410-\u0411\u0423\u0413\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208443", "2208443", "\u0412\u0420\u0410\u0414\u0418\u0415\u0412\u041a\u0410", "\u0412\u0420\u0410\u0414\u0418\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208444", "2208444", "\u041b\u042e\u0411\u0410\u0428\u0415\u0412\u041a\u0410", "\u041b\u042e\u0411\u0410\u0428\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209336", "2209336", "\u041f\u0415\u0420\u0415\u041b\u0415\u0422\u042b", "\u041f\u0415\u0420\u0415\u041b\u0415\u0422\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2208550", "2208550", "\u0411\u0410\u041b\u0422\u0410", "\u0411\u0410\u041b\u0422\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208362", "2208362", "\u041a\u041e\u0420\u0421\u0423\u041d\u042c", "\u041a\u041e\u0420\u0421\u0423\u041d\u042c", "\u0428", null);
            RailwayStationsDataProvider.put("2208099", "2208099", "\u0413\u041e\u0420\u041e\u0414\u0418\u0429\u0415", "\u0413\u041e\u0420\u041e\u0414\u0418\u0429\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208359", "2208359", "\u0426\u0412\u0415\u0422\u041a\u041e\u0412\u041e", "\u0426\u0412\u0415\u0422\u041a\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208355", "2208355", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410", "\u041a\u0410\u041c\u0415\u041d\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208353", "2208353", "\u0424\u0423\u041d\u0414\u0423\u041a\u041b\u0415\u0415\u0412", "\u0424\u0423\u041d\u0414\u0423\u041a\u041b\u0415\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208352", "2208352", "\u0426\u042b\u0411\u0423\u041b\u0415\u0412\u041e", "\u0426\u042b\u0411\u0423\u041b\u0415\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208411", "2208411", "\u0421\u0410\u0425\u0410\u0420\u041d\u0410\u042f", "\u0421\u0410\u0425\u0410\u0420\u041d\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208416", "2208416", "\u041c\u0410\u0420\u0416\u0410\u041d\u041e\u0412\u041a\u0410", "\u041c\u0410\u0420\u0416\u0410\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208440", "2208440", "\u0414\u041e\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0414\u041e\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208504", "2208504", "\u041d\u041e\u0412\u042b\u0419 \u0411\u0423\u0413", "\u041d\u041e\u0412\u042b\u0419 \u0411\u0423\u0413", "\u0428", null);
            RailwayStationsDataProvider.put("2208505", "2208505", "\u041d\u041e\u0412\u041e\u041f\u041e\u041b\u0422\u0410\u0412", "\u041d\u041e\u0412\u041e\u041f\u041e\u041b\u0422\u0410\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208507", "2208507", "\u042f\u0412\u041a\u0418\u041d\u041e", "\u042f\u0412\u041a\u0418\u041d\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208536", "2208536", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412 \u041f", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412 \u041f\u0410\u0421\u0421", "\u0428", null);
            RailwayStationsDataProvider.put("2208380", "2208380", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u0418\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208514", "2208514", "\u042f\u0421\u041d\u0410\u042f \u0417\u0410\u0420\u042f", "\u042f\u0421\u041d\u0410\u042f \u0417\u0410\u0420\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2209414", "2209414", "\u0418\u041d\u0413\u0423\u041b", "\u0418\u041d\u0413\u0423\u041b", "\u0428", null);
            RailwayStationsDataProvider.put("2208128", "2208128", "\u0427\u0415\u0425\u041e\u0412\u0418\u0427\u0418", "\u0427\u0415\u0425\u041e\u0412\u0418\u0427\u0418", "\u0428", null);
            RailwayStationsDataProvider.put("2208530", "2208530", "\u0425\u0415\u0420\u0421\u041e\u041d", "\u0425\u0415\u0420\u0421\u041e\u041d", "\u0428", null);
            RailwayStationsDataProvider.put("2208528", "2208528", "\u0421\u0415\u0420\u041e\u0413\u041e\u0417\u042b", "\u0421\u0415\u0420\u041e\u0413\u041e\u0417\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2208531", "2208531", "\u0411\u0420\u0410\u0422\u041e\u041b\u042e\u0411\u041e\u0412", "\u0411\u0420\u0410\u0422\u041e\u041b\u042e\u0411\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208532", "2208532", "\u041a\u0410\u0425\u041e\u0412\u041a\u0410", "\u041a\u0410\u0425\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209435", "2209435", "\u0422\u041e\u041c\u0410\u0420\u0418\u041d\u041e", "\u0422\u041e\u041c\u0410\u0420\u0418\u041d\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208526", "2208526", "\u0421\u041d\u0418\u0413\u0418\u0420\u0415\u0412\u041a\u0410", "\u0421\u041d\u0418\u0413\u0418\u0420\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208367", "2208367", "\u0428\u041f\u041e\u041b\u0410", "\u0428\u041f\u041e\u041b\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209390", "2209390", "\u0414\u0410\u0420\u042c\u0415\u0412\u041a\u0410", "\u0414\u0410\u0420\u042c\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209519", "2209519", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a\u041e\u0412", "\u0412\u0410\u0421\u0418\u041b\u042c\u041a\u041e\u0412", "\u0428", null);
            RailwayStationsDataProvider.put("2209489", "2209489", "\u041f\u0420\u0423\u0414\u042f\u041d\u041a\u0410", "\u041f\u0420\u0423\u0414\u042f\u041d\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209514", "2209514", "\u0421\u0422\u0415\u0426\u041e\u0412\u041a\u0410", "\u0421\u0422\u0415\u0426\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208369", "2208369", "\u0411\u041e\u0413\u0410\u0427\u0415\u0412\u041e", "\u0411\u041e\u0413\u0410\u0427\u0415\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208466", "2208466", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u0418\u0426\u0410", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u0418\u0426\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209472", "2209472", "\u0413\u0423\u0421\u0410\u041a\u041e\u0412\u041e", "\u0413\u0423\u0421\u0410\u041a\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208373", "2208373", "\u0422\u0410\u041b\u042c\u041d\u041e\u0415", "\u0422\u0410\u041b\u042c\u041d\u041e\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2209406", "2209406", "\u0413\u041e\u0420\u0414\u042b\u0428\u0415\u0412\u041a\u0410", "\u0413\u041e\u0420\u0414\u042b\u0428\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208376", "2208376", "\u041f\u041e\u0422\u0410\u0428", "\u041f\u041e\u0422\u0410\u0428", "\u0428", null);
            RailwayStationsDataProvider.put("2208370", "2208370", "\u0425\u0420\u0418\u0421\u0422\u0418\u041d\u041e\u0412\u041a", "\u0425\u0420\u0418\u0421\u0422\u0418\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208424", "2208424", "\u041a\u0423\u0411\u041b\u0418\u0427", "\u041a\u0423\u0411\u041b\u0418\u0427", "\u0428", null);
            RailwayStationsDataProvider.put("2208427", "2208427", "\u041b\u0410\u0414\u042b\u0416\u0418\u041d", "\u041b\u0410\u0414\u042b\u0416\u0418\u041d", "\u0428", null);
            RailwayStationsDataProvider.put("2208336", "2208336", "\u0414\u0420\u0410\u0411\u041e\u0412\u041e \u0411", "\u0414\u0420\u0410\u0411\u041e\u0412\u041e-\u0411\u0410\u0420\u042f\u0422\u0418\u041d\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2208337", "2208337", "\u041f\u0410\u041b\u042c\u041c\u0418\u0420\u0410", "\u041f\u0410\u041b\u042c\u041c\u0418\u0420\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208338", "2208338", "\u0417\u041e\u041b\u041e\u0422\u041e\u041d\u041e\u04281", "\u0417\u041e\u041b\u041e\u0422\u041e\u041d\u041e\u0428\u0410 1", "\u0428", null);
            RailwayStationsDataProvider.put("2208340", "2208340", "\u0427\u0415\u0420\u041a\u0410\u0421\u0421\u042b", "\u0427\u0415\u0420\u041a\u0410\u0421\u0421\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2208341", "2208341", "\u0411\u0415\u041b\u041e\u0417\u0415\u0420\u042c\u0415", "\u0411\u0415\u041b\u041e\u0417\u0415\u0420\u042c\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208518", "2208518", "\u0412\u042b\u0421\u041e\u041a\u041e\u041f\u041e\u041b", "\u0412\u042b\u0421\u041e\u041a\u041e\u041f\u041e\u041b\u042c\u0415", "\u0428", null);
            RailwayStationsDataProvider.put("2208521", "2208521", "\u0411\u0415\u041b \u041a\u0420\u0418\u041d\u0418\u0426", "\u0411\u0415\u041b\u0410\u042f \u041a\u0420\u0418\u041d\u0418\u0426\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2209507", "2209507", "\u0410\u041d\u0422\u041e\u041d\u041e\u0412\u041a\u0410", "\u0410\u041d\u0422\u041e\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208541", "2208541", "\u0426\u042e\u0420\u0423\u041f\u0418\u041d\u0421\u041a", "\u0426\u042e\u0420\u0423\u041f\u0418\u041d\u0421\u041a", "\u0428", null);
            RailwayStationsDataProvider.put("2208543", "2208543", "\u0411\u041e\u041b\u042c\u0428 \u041a\u041e\u041f", "\u0411\u041e\u041b\u042c\u0428\u0418\u0415 \u041a\u041e\u041f\u0410\u041d\u0418", "\u0428", null);
            RailwayStationsDataProvider.put("2208544", "2208544", "\u0411\u0420\u0418\u041b\u0415\u0412\u041a\u0410", "\u0411\u0420\u0418\u041b\u0415\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208546", "2208546", "\u0412\u0410\u0414\u0418\u041c", "\u0412\u0410\u0414\u0418\u041c", "\u0428", null);
            RailwayStationsDataProvider.put("2208304", "2208304", "\u041a\u0423\u0427\u0423\u0420\u0413\u0410\u041d", "\u041a\u0423\u0427\u0423\u0420\u0413\u0410\u041d", "\u0428", null);
            RailwayStationsDataProvider.put("2204438", "2204438", "\u041a\u0410\u0417 \u041b\u041e\u041f\u0410\u041d\u042c", "\u041a\u0410\u0417\u0410\u0427\u042c\u042f \u041b\u041e\u041f\u0410\u041d\u042c", "\u042e", null);
            RailwayStationsDataProvider.put("2204001", "2204001", "\u0425\u0410\u0420\u042c\u041a \u041f\u0410\u0421\u0421", "\u0425\u0410\u0420\u042c\u041a\u041e\u0412-\u041f\u0410\u0421\u0421", "\u042e", null);
            RailwayStationsDataProvider.put("2204208", "2204208", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u041e\u0412\u041a", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204216", "2204216", "\u041f\u041e\u041a\u041e\u0422\u0418\u041b\u041e\u0412\u041a", "\u041f\u041e\u041a\u041e\u0422\u0418\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204207", "2204207", "\u041a\u041e\u041c\u0410\u0420\u041e\u0412\u041a\u0410", "\u041a\u041e\u041c\u0410\u0420\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204447", "2204447", "\u041c\u0415\u0420\u0415\u0424\u0410", "\u041c\u0415\u0420\u0415\u0424\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204218", "2204218", "\u0411\u041e\u0420\u041a\u0418", "\u0411\u041e\u0420\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204170", "2204170", "\u0428\u0423\u0420\u0418\u041d\u041e", "\u0428\u0423\u0420\u0418\u041d\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204471", "2204471", "\u0411\u0415\u0421\u041f\u0410\u041b\u041e\u0412\u041a\u0410", "\u0411\u0415\u0421\u041f\u0410\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204472", "2204472", "\u041b\u0418\u0425\u0410\u0427\u0415\u0412\u041e", "\u041b\u0418\u0425\u0410\u0427\u0415\u0412\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204172", "2204172", "\u0411\u0415\u041b\u042f\u0415\u0412\u041a\u0410", "\u0411\u0415\u041b\u042f\u0415\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204473", "2204473", "\u041a\u0420\u0410\u0421\u041d\u041e\u041f\u0410\u0412\u041b", "\u041a\u0420\u0410\u0421\u041d\u041e\u041f\u0410\u0412\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204430", "2204430", "\u041b\u041e\u0417\u041e\u0412\u0410\u042f", "\u041b\u041e\u0417\u041e\u0412\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204446", "2204446", "\u041d \u0411\u0410\u0412\u0410\u0420\u0418\u042f", "\u041d\u041e\u0412\u0410\u042f \u0411\u0410\u0412\u0410\u0420\u0418\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204159", "2204159", "\u0420\u042b\u0416\u041e\u0412", "\u0420\u042b\u0416\u041e\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204519", "2204519", "\u041b\u042e\u0411\u041e\u0422\u0418\u041d", "\u041b\u042e\u0411\u041e\u0422\u0418\u041d", "\u042e", null);
            RailwayStationsDataProvider.put("2204522", "2204522", "\u041e\u0413\u0423\u041b\u042c\u0426\u042b", "\u041e\u0413\u0423\u041b\u042c\u0426\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204524", "2204524", "\u041a\u041e\u0412\u042f\u0413\u0418", "\u041a\u041e\u0412\u042f\u0413\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204525", "2204525", "\u0412\u041e\u0414\u042f\u041d\u0410\u042f", "\u0412\u041e\u0414\u042f\u041d\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204526", "2204526", "\u041a\u041e\u041b\u041e\u041c\u0410\u041a", "\u041a\u041e\u041b\u041e\u041c\u0410\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204528", "2204528", "\u0421\u041a\u041e\u0420\u041e\u0425\u041e\u0414\u041e\u0412", "\u0421\u041a\u041e\u0420\u041e\u0425\u041e\u0414\u041e\u0412\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204529", "2204529", "\u041a\u041e\u0427\u0423\u0411\u0415\u0415\u0412\u041a\u0410", "\u041a\u041e\u0427\u0423\u0411\u0415\u0415\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204590", "2204590", "\u041f\u041e\u041b\u0422 \u042e\u0416\u041d", "\u041f\u041e\u041b\u0422\u0410\u0412\u0410-\u042e\u0416\u041d\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204580", "2204580", "\u041f\u041e\u041b\u0422 \u041a\u0418\u0415\u0412", "\u041f\u041e\u041b\u0422\u0410\u0412\u0410 \u041a\u0418\u0415\u0412\u0421\u041a\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204576", "2204576", "\u0421\u0423\u041f\u0420\u0423\u041d\u041e\u0412\u041a\u0410", "\u0421\u0423\u041f\u0420\u0423\u041d\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204575", "2204575", "\u0410\u0411\u0410\u0417\u041e\u0412\u041a\u0410", "\u0410\u0411\u0410\u0417\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204573", "2204573", "\u0420\u0415\u0428\u0415\u0422\u0418\u041b\u041e\u0412\u041a", "\u0420\u0415\u0428\u0415\u0422\u0418\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204571", "2204571", "\u0421\u0410\u0413\u0410\u0419\u0414\u0410\u041a", "\u0421\u0410\u0413\u0410\u0419\u0414\u0410\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204568", "2204568", "\u042f\u0420\u0415\u0421\u042c\u041a\u0418", "\u042f\u0420\u0415\u0421\u042c\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204567", "2204567", "\u0413\u041e\u0413\u041e\u041b\u0415\u0412\u041e", "\u0413\u041e\u0413\u041e\u041b\u0415\u0412\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204570", "2204570", "\u041c\u0418\u0420\u0413\u041e\u0420\u041e\u0414", "\u041c\u0418\u0420\u0413\u041e\u0420\u041e\u0414", "\u042e", null);
            RailwayStationsDataProvider.put("2204530", "2204530", "\u0420\u041e\u041c\u041e\u0414\u0410\u041d", "\u0420\u041e\u041c\u041e\u0414\u0410\u041d", "\u042e", null);
            RailwayStationsDataProvider.put("2204560", "2204560", "\u041b\u0423\u0411\u041d\u042b", "\u041b\u0423\u0411\u041d\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204563", "2204563", "\u041b\u0410\u0417\u041e\u0420\u041a\u0418", "\u041b\u0410\u0417\u041e\u0420\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204540", "2204540", "\u041f\u0420\u0418\u041b\u0423\u041a\u0418", "\u041f\u0420\u0418\u041b\u0423\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204461", "2204461", "\u0417\u041e\u041b\u041e\u0427\u0415\u0412", "\u0417\u041e\u041b\u041e\u0427\u0415\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204518", "2204518", "\u041c\u0415\u0420\u0427\u0418\u041a", "\u041c\u0415\u0420\u0427\u0418\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204517", "2204517", "\u041c\u0410\u041a\u0421\u0418\u041c\u041e\u0412\u041a\u0410", "\u041c\u0410\u041a\u0421\u0418\u041c\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204516", "2204516", "\u0411\u041e\u0413\u041e\u0414\u0423\u0425\u041e\u0412", "\u0411\u041e\u0413\u041e\u0414\u0423\u0425\u041e\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204515", "2204515", "\u0413\u0423\u0411\u0410\u0420\u0415\u0412\u041a\u0410", "\u0413\u0423\u0411\u0410\u0420\u0415\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204514", "2204514", "\u041a\u0423\u041f\u042c\u0415\u0412\u0410\u0425\u0410", "\u041a\u0423\u041f\u042c\u0415\u0412\u0410\u0425\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204512", "2204512", "\u041a\u0418\u0420\u0418\u041a\u041e\u0412\u041a\u0410", "\u041a\u0418\u0420\u0418\u041a\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204509", "2204509", "\u0411\u0410\u041a\u0418\u0420\u041e\u0412\u041a\u0410", "\u0411\u0410\u041a\u0418\u0420\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204460", "2204460", "\u0421\u041c\u041e\u0420\u041e\u0414\u0418\u041d\u041e", "\u0421\u041c\u041e\u0420\u041e\u0414\u0418\u041d\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204507", "2204507", "\u0411\u041e\u0420\u041e\u041c\u041b\u042f", "\u0411\u041e\u0420\u041e\u041c\u041b\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204505", "2204505", "\u0421\u042b\u0420\u041e\u0412\u0410\u0422\u041a\u0410", "\u0421\u042b\u0420\u041e\u0412\u0410\u0422\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204499", "2204499", "\u0411\u0410\u0421\u042b", "\u0411\u0410\u0421\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204450", "2204450", "\u0421\u0423\u041c\u042b", "\u0421\u0423\u041c\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204497", "2204497", "\u0422\u041e\u0420\u041e\u041f\u0418\u041b\u041e\u0412\u041a", "\u0422\u041e\u0420\u041e\u041f\u0418\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204496", "2204496", "\u0413\u041e\u041b\u041e\u0412\u0410\u0428\u0415\u0412\u041a", "\u0413\u041e\u041b\u041e\u0412\u0410\u0428\u0415\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204494", "2204494", "\u0412\u0418\u0420\u042b", "\u0412\u0418\u0420\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204493", "2204493", "\u0422\u041e\u0420\u041e\u0425\u0422\u042f\u041d\u042b\u0419", "\u0422\u041e\u0420\u041e\u0425\u0422\u042f\u041d\u042b\u0419", "\u042e", null);
            RailwayStationsDataProvider.put("2204440", "2204440", "\u0411\u0415\u041b\u041e\u041f\u041e\u041b\u042c\u0415", "\u0411\u0415\u041b\u041e\u041f\u041e\u041b\u042c\u0415", "\u042e", null);
            RailwayStationsDataProvider.put("2204510", "2204510", "\u0420\u041e\u041c\u041d\u042b", "\u0420\u041e\u041c\u041d\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204520", "2204520", "\u0421\u0423\u041b\u0410", "\u0421\u0423\u041b\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204542", "2204542", "\u041b\u041e\u0425\u0412\u0418\u0426\u0410", "\u041b\u041e\u0425\u0412\u0418\u0426\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204589", "2204589", "\u0425\u041e\u0420\u041e\u041b", "\u0425\u041e\u0420\u041e\u041b", "\u042e", null);
            RailwayStationsDataProvider.put("2204591", "2204591", "\u0412\u0415\u0421 \u041f\u041e\u0414\u041e\u041b", "\u0412\u0415\u0421\u0415\u041b\u042b\u0419 \u041f\u041e\u0414\u041e\u041b", "\u042e", null);
            RailwayStationsDataProvider.put("2204610", "2204610", "\u041a\u0420\u0415\u041c\u0415\u041d\u0427\u0423\u0413", "\u041a\u0420\u0415\u041c\u0415\u041d\u0427\u0423\u0413", "\u042e", null);
            RailwayStationsDataProvider.put("2204616", "2204616", "\u0413\u041e\u041b\u041e\u0412\u0410\u0427", "\u0413\u041e\u041b\u041e\u0412\u0410\u0427", "\u042e", null);
            RailwayStationsDataProvider.put("2204615", "2204615", "\u041c \u041f\u0415\u0420\u0415\u0429\u0415\u041f", "\u041c\u0410\u041b\u0410\u042f \u041f\u0415\u0420\u0415\u0429\u0415\u041f\u0418\u041d\u0421\u041a\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204613", "2204613", "\u041d\u041e\u0412\u041e\u0421\u0415\u041d\u0416\u0410\u0420", "\u041d\u041e\u0412\u041e\u0421\u0415\u041d\u0416\u0410\u0420\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204611", "2204611", "\u041b\u0415\u0429\u0418\u041d\u041e\u0412\u041a\u0410", "\u041b\u0415\u0429\u0418\u041d\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204609", "2204609", "\u041a\u041e\u0411\u0415\u041b\u042f\u041a\u0418", "\u041a\u041e\u0411\u0415\u041b\u042f\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204607", "2204607", "\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204606", "2204606", "\u041a\u041e\u0417\u0415\u041b\u042c\u0429\u0418\u041d\u0410", "\u041a\u041e\u0417\u0415\u041b\u042c\u0429\u0418\u041d\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204605", "2204605", "\u0413\u0410\u041b\u0415\u0429\u0418\u041d\u0410", "\u0413\u0410\u041b\u0415\u0429\u0418\u041d\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204603", "2204603", "\u041f\u041e\u0422\u041e\u041a\u0418", "\u041f\u041e\u0422\u041e\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204475", "2204475", "\u0412\u041e\u0414\u041e\u041b\u0410\u0413\u0410", "\u0412\u041e\u0414\u041e\u041b\u0410\u0413\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204482", "2204482", "\u041a\u0420\u0410\u0421\u041d\u041e\u0413\u0420\u0410\u0414", "\u041a\u0420\u0410\u0421\u041d\u041e\u0413\u0420\u0410\u0414", "\u042e", null);
            RailwayStationsDataProvider.put("2204578", "2204578", "\u041c\u0418\u041d\u041e\u0412\u041a\u0410", "\u041c\u0418\u041d\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204581", "2204581", "\u0421\u0415\u041b\u0415\u0429\u0418\u041d\u0410", "\u0421\u0415\u041b\u0415\u0429\u0418\u041d\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204582", "2204582", "\u0422\u0410\u0413\u0410\u041c\u041b\u042b\u041a", "\u0422\u0410\u0413\u0410\u041c\u041b\u042b\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204584", "2204584", "\u041a\u0410\u0420\u041b\u041e\u0412\u041a\u0410", "\u041a\u0410\u0420\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204586", "2204586", "\u041b\u0410\u041d\u041d\u0410\u042f", "\u041b\u0410\u041d\u041d\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204488", "2204488", "\u0421\u0410\u0425\u041d\u041e\u0412\u0429\u0418\u041d\u0410", "\u0421\u0410\u0425\u041d\u041e\u0412\u0429\u0418\u041d\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204392", "2204392", "\u0412\u041e\u041b\u0427\u0410\u041d\u0421\u041a", "\u0412\u041e\u041b\u0427\u0410\u041d\u0421\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204395", "2204395", "\u041f\u0420\u0418\u041a\u041e\u041b\u041e\u0422\u041d", "\u041f\u0420\u0418\u041a\u041e\u041b\u041e\u0422\u041d\u041e\u0415", "\u042e", null);
            RailwayStationsDataProvider.put("2204397", "2204397", "\u0411\u0423\u0420\u041b\u0423\u041a", "\u0411\u0423\u0420\u041b\u0423\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204403", "2204403", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a \u042e\u0416", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a \u042e\u0416\u041d\u042b\u0419", "\u042e", null);
            RailwayStationsDataProvider.put("2204380", "2204380", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a \u0423\u0417", "\u041a\u0423\u041f\u042f\u041d\u0421\u041a \u0423\u0417\u041b\u041e\u0412\u041e\u0419", "\u042e", null);
            RailwayStationsDataProvider.put("2204003", "2204003", "\u0425\u0410\u0420\u042c\u041a \u0411\u0410\u041b", "\u0425\u0410\u0420\u042c\u041a\u041e\u0412-\u0411\u0410\u041b\u0410\u0428\u0415\u0412\u0421\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204390", "2204390", "\u041b\u041e\u0421\u0415\u0412\u041e", "\u041b\u041e\u0421\u0415\u0412\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204156", "2204156", "\u0420\u041e\u0413\u0410\u041d\u042c", "\u0420\u041e\u0413\u0410\u041d\u042c", "\u042e", null);
            RailwayStationsDataProvider.put("2204428", "2204428", "\u041c\u041e\u0425\u041d\u0410\u0427", "\u041c\u041e\u0425\u041d\u0410\u0427", "\u042e", null);
            RailwayStationsDataProvider.put("2204427", "2204427", "\u042d\u0421\u0425\u0410\u0420", "\u042d\u0421\u0425\u0410\u0420", "\u042e", null);
            RailwayStationsDataProvider.put("2204426", "2204426", "\u0427\u0423\u0413\u0423\u0415\u0412", "\u0427\u0423\u0413\u0423\u0415\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204425", "2204425", "\u041a\u041e\u0420\u041e\u0411\u041e\u0427\u041a\u0418\u041d", "\u041a\u041e\u0420\u041e\u0411\u041e\u0427\u041a\u0418\u041d\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204424", "2204424", "\u0413\u0420\u0410\u041a\u041e\u0412\u041e", "\u0413\u0420\u0410\u041a\u041e\u0412\u041e", "\u042e", null);
            RailwayStationsDataProvider.put("2204153", "2204153", "\u0421\u0422\u0410\u0420\u041e\u0412\u0415\u0420\u041e\u0412", "\u0421\u0422\u0410\u0420\u041e\u0412\u0415\u0420\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204412", "2204412", "\u0422\u041e\u041f\u041e\u041b\u0418", "\u0422\u041e\u041f\u041e\u041b\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204413", "2204413", "\u0414\u0412\u0423\u0420\u0415\u0427\u041d\u0410\u042f", "\u0414\u0412\u0423\u0420\u0415\u0427\u041d\u0410\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204407", "2204407", "\u041a\u0423\u0417\u0415\u041c\u041e\u0412\u041a\u0410", "\u041a\u0423\u0417\u0415\u041c\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204465", "2204465", "\u0417\u041c\u0418\u0415\u0412", "\u0417\u041c\u0418\u0415\u0412", "\u042e", null);
            RailwayStationsDataProvider.put("2204165", "2204165", "\u0417\u0410\u041d\u041a\u0418", "\u0417\u0410\u041d\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204466", "2204466", "\u0428\u0415\u0411\u0415\u041b\u0418\u041d\u041a\u0410", "\u0428\u0415\u0411\u0415\u041b\u0418\u041d\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204467", "2204467", "\u0411\u0410\u041b\u0410\u041a\u041b\u0415\u042f", "\u0411\u0410\u041b\u0410\u041a\u041b\u0415\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2204420", "2204420", "\u0418\u0417\u042e\u041c", "\u0418\u0417\u042e\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204503", "2204503", "\u041a\u0420\u0410\u0421\u041d\u041e\u041f\u041e\u041b", "\u041a\u0420\u0410\u0421\u041d\u041e\u041f\u041e\u041b\u042c\u0415", "\u042e", null);
            RailwayStationsDataProvider.put("2210760", "2210760", "\u041f\u0410\u0412\u041b\u041e\u0413\u0420 1", "\u041f\u0410\u0412\u041b\u041e\u0413\u0420\u0410\u0414 1", "\u041f", null);
            RailwayStationsDataProvider.put("2210920", "2210920", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d\u0418\u041a1", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d\u0418\u041a\u041e\u0412\u041e-1", "\u041f", null);
            RailwayStationsDataProvider.put("2210800", "2210800", "\u0417\u0410\u041f\u041e\u0420\u041e\u0416 1", "\u0417\u0410\u041f\u041e\u0420\u041e\u0416\u042c\u0415 1", "\u041f", null);
            RailwayStationsDataProvider.put("2210785", "2210785", "\u0422\u0410\u0412\u0420\u0418\u0427\u0415\u0421\u041a", "\u0422\u0410\u0412\u0420\u0418\u0427\u0415\u0421\u041a", "\u041f", null);
            RailwayStationsDataProvider.put("2210960", "2210960", "\u0424\u0415\u0414\u041e\u0420\u041e\u0412\u041a\u0410", "\u0424\u0415\u0414\u041e\u0420\u041e\u0412\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210670", "2210670", "\u041c\u0415\u041b\u0418\u0422\u041e\u041f\u041e\u041b\u042c", "\u041c\u0415\u041b\u0418\u0422\u041e\u041f\u041e\u041b\u042c", "\u041f", null);
            RailwayStationsDataProvider.put("2210675", "2210675", "\u0410\u041a\u0418\u041c\u041e\u0412\u041a\u0410", "\u0410\u041a\u0418\u041c\u041e\u0412\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210790", "2210790", "\u041d\u041e\u0412\u041e\u0410\u041b\u0415\u041a\u0421", "\u041d\u041e\u0412\u041e\u0410\u041b\u0415\u041a\u0421\u0415\u0415\u0412\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210710", "2210710", "\u0414\u0416\u0410\u041d\u041a\u041e\u0419", "\u0414\u0416\u0410\u041d\u041a\u041e\u0419", "\u041f", null);
            RailwayStationsDataProvider.put("2210745", "2210745", "\u041e\u0421\u0422\u0420\u042f\u041a\u041e\u0412\u041e", "\u041e\u0421\u0422\u0420\u042f\u041a\u041e\u0412\u041e", "\u041f", null);
            RailwayStationsDataProvider.put("2210001", "2210001", "\u0421\u0418\u041c\u0424\u0415\u0420\u041e\u041f \u041f", "\u0421\u0418\u041c\u0424\u0415\u0420\u041e\u041f\u041e\u041b\u042c \u041f\u0410\u0421\u0421", "\u041f", null);
            RailwayStationsDataProvider.put("2210910", "2210910", "\u041d\u041e\u0412\u041e\u041c\u041e\u0421 \u0414\u041d", "\u041d\u041e\u0412\u041e\u041c\u041e\u0421\u041a\u041e\u0412\u0421\u041a \u0414\u041d\u0415\u041f\u0420\u041e\u0412\u0421\u041a", "\u041f", null);
            RailwayStationsDataProvider.put("2210830", "2210830", "\u0410\u041f\u041e\u0421\u0422\u041e\u041b\u041e\u0412\u041e", "\u0410\u041f\u041e\u0421\u0422\u041e\u041b\u041e\u0412\u041e", "\u041f", null);
            RailwayStationsDataProvider.put("2210810", "2210810", "\u041f\u042f\u0422\u0418\u0425\u0410\u0422\u041a\u0418", "\u041f\u042f\u0422\u0418\u0425\u0410\u0422\u041a\u0418", "\u041f", null);
            RailwayStationsDataProvider.put("2210815", "2210815", "\u0412\u0415\u0420\u0425\u041e\u0412\u0426\u0415\u0412\u041e", "\u0412\u0415\u0420\u0425\u041e\u0412\u0426\u0415\u0412\u041e", "\u041f", null);
            RailwayStationsDataProvider.put("2210720", "2210720", "\u0414\u041d\u0415\u041f\u0420\u041e\u0414\u0417 \u041f", "\u0414\u041d\u0415\u041f\u0420\u041e\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a-\u041f\u0410\u0421\u0421.", "\u041f", null);
            RailwayStationsDataProvider.put("2210700", "2210700", "\u0414\u041d\u0415\u041f\u0420\u041e\u041f \u0413\u041b", "\u0414\u041d\u0415\u041f\u0420\u041e\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a \u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u041f", null);
            RailwayStationsDataProvider.put("2210930", "2210930", "\u0427\u0410\u041f\u041b\u0418\u041d\u041e", "\u0427\u0410\u041f\u041b\u0418\u041d\u041e", "\u041f", null);
            RailwayStationsDataProvider.put("2210262", "2210262", "\u041f\u041b 31 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 31 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210797", "2210797", "\u041c\u0418\u0420\u041e\u0412\u0410\u042f", "\u041c\u0418\u0420\u041e\u0412\u0410\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("2210725", "2210725", "\u041c\u0410\u0420\u0413\u0410\u041d\u0415\u0426", "\u041c\u0410\u0420\u0413\u0410\u041d\u0415\u0426", "\u041f", null);
            RailwayStationsDataProvider.put("2210780", "2210780", "\u041d\u0418\u041a\u041e\u041f\u041e\u041b\u042c", "\u041d\u0418\u041a\u041e\u041f\u041e\u041b\u042c", "\u041f", null);
            RailwayStationsDataProvider.put("2210870", "2210870", "\u0427\u0415\u0420\u0422\u041e\u041c\u041b\u042b\u041a", "\u0427\u0415\u0420\u0422\u041e\u041c\u041b\u042b\u041a", "\u041f", null);
            RailwayStationsDataProvider.put("2210900", "2210900", "\u041a\u0420 \u0420\u041e\u0413 \u0413\u041b", "\u041a\u0420\u0418\u0412\u041e\u0419 \u0420\u041e\u0413-\u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u041f", null);
            RailwayStationsDataProvider.put("2210850", "2210850", "\u041f\u041e\u041b\u041e\u0413\u0418", "\u041f\u041e\u041b\u041e\u0413\u0418", "\u041f", null);
            RailwayStationsDataProvider.put("2210777", "2210777", "\u041a\u0410\u041c\u042b\u0428 \u0417\u0410\u0420\u042f", "\u041a\u0410\u041c\u042b\u0428-\u0417\u0410\u0420\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("2210832", "2210832", "\u041e\u0420\u0415\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e\u0420\u0415\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("2210316", "2210316", "\u0420\u0417\u0414 8 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 8 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210319", "2210319", "\u0420\u0417\u0414 10 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 10 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210320", "2210320", "\u0411\u041e\u0413\u0415\u041c\u041a\u0410", "\u0411\u041e\u0413\u0415\u041c\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210650", "2210650", "\u0414\u041d\u0415\u041f\u0420\u041e\u0414\u0417\u0415\u0420", "\u0414\u041d\u0415\u041f\u0420\u041e\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a", "\u041f", null);
            RailwayStationsDataProvider.put("2210801", "2210801", "\u0417\u0410\u041f\u041e\u0420\u041e\u0416 \u041b", "\u0417\u0410\u041f\u041e\u0420\u041e\u0416\u042c\u0415 \u041b\u0415\u0412\u041e\u0415", "\u041f", null);
            RailwayStationsDataProvider.put("2210680", "2210680", "\u041a\u0420\u0418\u0412\u041e\u0419 \u0420\u041e\u0413", "\u041a\u0420\u0418\u0412\u041e\u0419 \u0420\u041e\u0413", "\u041f", null);
            RailwayStationsDataProvider.put("2210739", "2210739", "\u0414\u041d\u0415\u041f\u0420 \u041e\u0414\u0411", "\u0414\u041d\u0415\u041f\u0420\u041e\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a \u041e\u0414\u0411", "\u041f", null);
            RailwayStationsDataProvider.put("2210921", "2210921", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d\u0418\u041a", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d\u0418\u041a\u041e\u0412\u041e", "\u041f", null);
            RailwayStationsDataProvider.put("2214063", "2214063", "\u0421\u0412\u042f\u0422\u041e\u0413\u041e\u0420\u0421\u041a", "\u0421\u0412\u042f\u0422\u041e\u0413\u041e\u0420\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214020", "2214020", "\u041a\u0420 \u041b\u0418\u041c\u0410\u041d", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u041b\u0418\u041c\u0410\u041d", "\u0414", null);
            RailwayStationsDataProvider.put("2214068", "2214068", "\u0421\u0415\u0412\u0415\u0420\u0421\u041a", "\u0421\u0415\u0412\u0415\u0420\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214180", "2214180", "\u0410\u0420\u0422\u0415\u041c\u041e\u0412\u0421\u041a2", "\u0410\u0420\u0422\u0415\u041c\u041e\u0412\u0421\u041a 2", "\u0414", null);
            RailwayStationsDataProvider.put("2214030", "2214030", "\u041d\u0418\u041a\u0418\u0422\u041e\u0412\u041a\u0410", "\u041d\u0418\u041a\u0418\u0422\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214240", "2214240", "\u0413\u041e\u0420\u041b\u041e\u0412\u041a\u0410", "\u0413\u041e\u0420\u041b\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214443", "2214443", "\u041d\u041e\u0412\u041e\u0411\u0410\u0425\u041c\u0423\u0422", "\u041d\u041e\u0412\u041e\u0411\u0410\u0425\u041c\u0423\u0422\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214040", "2214040", "\u0421\u041b\u0410\u0412\u042f\u041d\u0421\u041a", "\u0421\u041b\u0410\u0412\u042f\u041d\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214250", "2214250", "\u0418\u041b\u041e\u0412\u0410\u0419\u0421\u041a", "\u0418\u041b\u041e\u0412\u0410\u0419\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214110", "2214110", "\u041a\u0420\u0410\u041c\u0410\u0422\u041e\u0420\u0421\u041a", "\u041a\u0420\u0410\u041c\u0410\u0422\u041e\u0420\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214089", "2214089", "\u0414\u0420\u0423\u0416\u041a\u041e\u0412\u041a\u0410", "\u0414\u0420\u0423\u0416\u041a\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214140", "2214140", "\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0418\u041d", "\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0418\u041d\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214260", "2214260", "\u0425\u0410\u041d\u0416\u0415\u041d\u041a\u041e\u0412\u041e", "\u0425\u0410\u041d\u0416\u0415\u041d\u041a\u041e\u0412\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("2214270", "2214270", "\u0425\u0410\u0420\u0426\u042b\u0417\u0421\u041a", "\u0425\u0410\u0420\u0426\u042b\u0417\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214247", "2214247", "\u0410\u041c\u0412\u0420\u041e\u0421\u0418\u0415\u0412\u041a", "\u0410\u041c\u0412\u0420\u041e\u0421\u0418\u0415\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214318", "2214318", "\u041c\u041e\u0422\u041e\u0420\u041d\u042b\u0419", "\u041c\u041e\u0422\u041e\u0420\u041d\u042b\u0419", "\u0414", null);
            RailwayStationsDataProvider.put("2214477", "2214477", "\u041d\u041e\u0412\u041e\u0421\u0412\u0415\u0422\u041b", "\u041d\u041e\u0412\u041e\u0421\u0412\u0415\u0422\u041b\u041e\u0412\u0421\u041a\u0418\u0419", "\u0414", null);
            RailwayStationsDataProvider.put("2214417", "2214417", "\u0411\u0420\u0410\u0422\u041a\u0418", "\u0411\u0420\u0410\u0422\u041a\u0418", "\u0414", null);
            RailwayStationsDataProvider.put("2214369", "2214369", "\u041b\u0410\u041d\u0422\u0420\u0410\u0422\u041e\u0412\u041a", "\u041b\u0410\u041d\u0422\u0420\u0410\u0422\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214372", "2214372", "\u0421\u041e\u041b\u0418\u0414\u0410\u0420\u041d\u042b\u0419", "\u0421\u041e\u041b\u0418\u0414\u0410\u0420\u041d\u042b\u0419", "\u0414", null);
            RailwayStationsDataProvider.put("2064150", "2064150", "\u0410\u0414\u041b\u0415\u0420", "\u0410\u0414\u041b\u0415\u0420", "\u0421", null);
            RailwayStationsDataProvider.put("2064010", "2064010", "\u0425\u041e\u0421\u0422\u0410", "\u0425\u041e\u0421\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064130", "2064130", "\u0421\u041e\u0427\u0418", "\u0421\u041e\u0427\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064020", "2064020", "\u041b\u041e\u041e", "\u041b\u041e\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064030", "2064030", "\u041b\u0410\u0417\u0410\u0420\u0415\u0412\u0421\u041a", "\u041b\u0410\u0417\u0410\u0420\u0415\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064092", "2064092", "\u0428\u0415\u041f\u0421\u0418", "\u0428\u0415\u041f\u0421\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064140", "2064140", "\u0422\u0423\u0410\u041f\u0421\u0415 \u041f\u0410\u0421", "\u0422\u0423\u0410\u041f\u0421\u0415-\u041f\u0410\u0421\u0421", "\u0421", null);
            RailwayStationsDataProvider.put("2064284", "2064284", "\u041a\u0420\u0418\u0412\u0415\u041d\u041a\u041e\u0412\u0421", "\u041a\u0420\u0418\u0412\u0415\u041d\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064285", "2064285", "\u0425\u0410\u0414\u042b\u0416\u0415\u041d\u0421\u041a", "\u0425\u0410\u0414\u042b\u0416\u0415\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064083", "2064083", "\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421", "\u041a\u041e\u041c\u0421\u041e\u041c\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064250", "2064250", "\u0411\u0415\u041b\u041e\u0420\u0415\u0427\u0415\u041d\u0421", "\u0411\u0415\u041b\u041e\u0420\u0415\u0427\u0415\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064075", "2064075", "\u041a\u0423\u0420\u0413\u0410\u041d\u041d\u0410\u042f", "\u041a\u0423\u0420\u0413\u0410\u041d\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064290", "2064290", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420 \u0422", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420 \u0422\u0423\u0410\u041f\u0421\u0418\u041d\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064018", "2064018", "\u041a\u0423\u0411\u0410\u041d\u0421\u041a\u0410\u042f", "\u041a\u0423\u0411\u0410\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064225", "2064225", "\u0413\u0423\u041b\u042c\u041a\u0415\u0412\u0418\u0427\u0418", "\u0413\u0423\u041b\u042c\u041a\u0415\u0412\u0418\u0427\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064160", "2064160", "\u041a\u0410\u0412\u041a\u0410\u0417\u0421\u041a\u0410\u042f", "\u041a\u0410\u0412\u041a\u0410\u0417\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064260", "2064260", "\u0422\u0418\u0425\u041e\u0420\u0415\u0426\u041a\u0410\u042f", "\u0422\u0418\u0425\u041e\u0420\u0415\u0426\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064009", "2064009", "\u0421\u041e\u0421\u042b\u041a\u0410 \u0420\u041e\u0421", "\u0421\u041e\u0421\u042b\u041a\u0410-\u0420\u041e\u0421\u0422\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064008", "2064008", "\u041a\u0420\u042b\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041a\u0420\u042b\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064007", "2064007", "\u041a\u0423\u0429\u0415\u0412\u041a\u0410", "\u041a\u0423\u0429\u0415\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064105", "2064105", "\u0411\u0410\u0422\u0410\u0419\u0421\u041a", "\u0411\u0410\u0422\u0410\u0419\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064001", "2064001", "\u0420\u041e\u0421\u0422\u041e\u0412 \u0413\u041b", "\u0420\u041e\u0421\u0422\u041e\u0412-\u0413\u041b\u0410\u0412\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064270", "2064270", "\u0422\u0410\u0413\u0410\u041d\u0420 \u041f\u0410\u0421", "\u0422\u0410\u0413\u0410\u041d\u0420\u041e\u0413-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064035", "2064035", "\u0413\u0423\u0414\u0415\u0420\u041c\u0415\u0421", "\u0413\u0423\u0414\u0415\u0420\u041c\u0415\u0421", "\u0421", null);
            RailwayStationsDataProvider.put("2064098", "2064098", "\u0418\u0429\u0415\u0420\u0421\u041a\u0410\u042f", "\u0418\u0429\u0415\u0420\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064095", "2064095", "\u041c\u041e\u0417\u0414\u041e\u041a", "\u041c\u041e\u0417\u0414\u041e\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064315", "2064315", "\u041f\u0420\u041e\u0425\u041b\u0410\u0414\u041d\u0410\u042f", "\u041f\u0420\u041e\u0425\u041b\u0410\u0414\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064050", "2064050", "\u041a\u0418\u0421\u041b\u041e\u0412\u041e\u0414\u0421\u041a", "\u041a\u0418\u0421\u041b\u041e\u0412\u041e\u0414\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064080", "2064080", "\u0415\u0421\u0421\u0415\u041d\u0422\u0423\u041a\u0418", "\u0415\u0421\u0421\u0415\u041d\u0422\u0423\u041a\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064060", "2064060", "\u041f\u042f\u0422\u0418\u0413\u041e\u0420\u0421\u041a", "\u041f\u042f\u0422\u0418\u0413\u041e\u0420\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064151", "2064151", "\u0411\u0415\u0428\u0422\u0410\u0423", "\u0411\u0415\u0428\u0422\u0410\u0423", "\u0421", null);
            RailwayStationsDataProvider.put("2064170", "2064170", "\u041c\u0418\u041d \u0412\u041e\u0414\u042b", "\u041c\u0418\u041d\u0415\u0420\u0410\u041b\u042c\u041d\u042b\u0415 \u0412\u041e\u0414\u042b", "\u0421", null);
            RailwayStationsDataProvider.put("2064070", "2064070", "\u0412\u041b\u0410\u0414\u0418\u041a\u0410\u0412\u041a", "\u0412\u041b\u0410\u0414\u0418\u041a\u0410\u0412\u041a\u0410\u0417", "\u0421", null);
            RailwayStationsDataProvider.put("2064025", "2064025", "\u0411\u0415\u0421\u041b\u0410\u041d", "\u0411\u0415\u0421\u041b\u0410\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064055", "2064055", "\u041d\u0410\u041b\u042c\u0427\u0418\u041a", "\u041d\u0410\u041b\u042c\u0427\u0418\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064317", "2064317", "\u0414\u041e\u041a\u0428\u0423\u041a\u0418\u041d\u041e", "\u0414\u041e\u041a\u0428\u0423\u041a\u0418\u041d\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064316", "2064316", "\u041a\u041e\u0422\u041b\u042f\u0420\u0415\u0412\u0421\u041a", "\u041a\u041e\u0422\u041b\u042f\u0420\u0415\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064205", "2064205", "\u042d\u041b\u0418\u0421\u0422\u0410", "\u042d\u041b\u0418\u0421\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064242", "2064242", "\u0414\u0418\u0412\u041d\u041e\u0415", "\u0414\u0418\u0412\u041d\u041e\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064239", "2064239", "\u0418\u041f\u0410\u0422\u041e\u0412\u041e", "\u0418\u041f\u0410\u0422\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064244", "2064244", "\u0421\u0412\u0415\u0422\u041b\u041e\u0413\u0420\u0410\u0414", "\u0421\u0412\u0415\u0422\u041b\u041e\u0413\u0420\u0410\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064234", "2064234", "\u041f\u0410\u041b\u0410\u0413\u0418\u0410\u0414\u0410", "\u041f\u0410\u041b\u0410\u0413\u0418\u0410\u0414\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064700", "2064700", "\u0421\u0422\u0410\u0412\u0420\u041e\u041f\u041e\u041b\u042c", "\u0421\u0422\u0410\u0412\u0420\u041e\u041f\u041e\u041b\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064275", "2064275", "\u0418\u0417\u041e\u0411\u0418\u041b\u042c\u041d\u0410\u042f", "\u0418\u0417\u041e\u0411\u0418\u041b\u042c\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065249", "2065249", "\u0411\u041b\u0410\u0413\u041e\u0414\u0410\u0420\u041d", "\u0411\u041b\u0410\u0413\u041e\u0414\u0410\u0420\u041d\u041e\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064283", "2064283", "\u0411\u0423\u0414\u0415\u041d\u041d\u041e\u0412\u0421\u041a", "\u0411\u0423\u0414\u0415\u041d\u041d\u041e\u0412\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064310", "2064310", "\u0413\u0415\u041e\u0420\u0413\u0418\u0415\u0412\u0421\u041a", "\u0413\u0415\u041e\u0420\u0413\u0418\u0415\u0412\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064128", "2064128", "\u0414\u0416\u0415\u0413\u0423\u0422\u0410", "\u0414\u0416\u0415\u0413\u0423\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064730", "2064730", "\u041e\u041f 35 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 35 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064226", "2064226", "\u0421\u0410\u041c\u0423\u0420", "\u0421\u0410\u041c\u0423\u0420", "\u0421", null);
            RailwayStationsDataProvider.put("2064045", "2064045", "\u0414\u0415\u0420\u0411\u0415\u041d\u0422", "\u0414\u0415\u0420\u0411\u0415\u041d\u0422", "\u0421", null);
            RailwayStationsDataProvider.put("2064216", "2064216", "\u0418\u0417\u0411\u0415\u0420\u0411\u0410\u0428", "\u0418\u0417\u0411\u0415\u0420\u0411\u0410\u0428", "\u0421", null);
            RailwayStationsDataProvider.put("2064900", "2064900", "\u041c\u0410\u0425\u0410\u0427\u041a\u0410\u041b\u0410", "\u041c\u0410\u0425\u0410\u0427\u041a\u0410\u041b\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064063", "2064063", "\u041a\u0418\u0417\u0418\u041b\u042e\u0420\u0422", "\u041a\u0418\u0417\u0418\u041b\u042e\u0420\u0422", "\u0421", null);
            RailwayStationsDataProvider.put("2064165", "2064165", "\u0425\u0410\u0421\u0410\u0412 \u042e\u0420\u0422", "\u0425\u0410\u0421\u0410\u0412-\u042e\u0420\u0422", "\u0421", null);
            RailwayStationsDataProvider.put("2064180", "2064180", "\u0413\u0420\u041e\u0417\u041d\u042b\u0419", "\u0413\u0420\u041e\u0417\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064053", "2064053", "\u0421\u0415\u0420\u041d\u041e\u0412\u041e\u0414\u0421\u041a", "\u0421\u0415\u0420\u041d\u041e\u0412\u041e\u0414\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064052", "2064052", "\u0421\u041b\u0415\u041f\u0426\u041e\u0412\u0421\u041a", "\u0421\u041b\u0415\u041f\u0426\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064049", "2064049", "\u041d\u0410\u0417\u0420\u0410\u041d\u042c", "\u041d\u0410\u0417\u0420\u0410\u041d\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064029", "2064029", "\u041a\u0423\u0420\u0421\u0410\u0412\u041a\u0410", "\u041a\u0423\u0420\u0421\u0410\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064766", "2064766", "\u0421\u0423\u0420\u041a\u0423\u041b\u042c", "\u0421\u0423\u0420\u041a\u0423\u041b\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064220", "2064220", "\u041d\u0415\u0412\u0418\u041d\u041d\u041e\u041c\u042b\u0421", "\u041d\u0415\u0412\u0418\u041d\u041d\u041e\u041c\u042b\u0421\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064022", "2064022", "\u0411\u041e\u0413\u041e\u0421\u041b\u041e\u0412\u0421\u041a", "\u0411\u041e\u0413\u041e\u0421\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064240", "2064240", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420 \u0420", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420 \u0420\u041e\u0421\u0422\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064800", "2064800", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u04201", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u0420 1", "\u0421", null);
            RailwayStationsDataProvider.put("2064280", "2064280", "\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u0421\u041a", "\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064066", "2064066", "\u0411\u0420\u042e\u0425\u041e\u0412\u0415\u0426\u041a", "\u0411\u0420\u042e\u0425\u041e\u0412\u0415\u0426\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064245", "2064245", "\u041a\u0410\u041d\u0415\u0412\u0421\u041a\u0410\u042f", "\u041a\u0410\u041d\u0415\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064235", "2064235", "\u0421\u0422\u0410\u0420\u041e\u041c\u0418\u041d \u0422", "\u0421\u0422\u0410\u0420\u041e\u041c\u0418\u041d\u0421\u041a\u0410\u042f-\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064230", "2064230", "\u041d\u041e\u0412\u041e\u0427\u0415\u0420\u041a\u0410\u0421", "\u041d\u041e\u0412\u041e\u0427\u0415\u0420\u041a\u0410\u0421\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2065002", "2065002", "\u041a\u0410\u041c\u0415\u041d\u041e\u041b\u041e\u041c", "\u041a\u0410\u041c\u0415\u041d\u041e\u041b\u041e\u041c\u041d\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064201", "2064201", "\u0428\u0410\u0425\u0422\u041d\u0410\u042f", "\u0428\u0410\u0425\u0422\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064215", "2064215", "\u0421\u0423\u041b\u0418\u041d", "\u0421\u0423\u041b\u0418\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064185", "2064185", "\u0417\u0412\u0415\u0420\u0415\u0412\u041e", "\u0417\u0412\u0415\u0420\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064040", "2064040", "\u0415\u0419\u0421\u041a", "\u0415\u0419\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064320", "2064320", "\u041a\u0420\u042b\u041c\u0421\u041a\u0410\u042f", "\u041a\u0420\u042b\u041c\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064181", "2064181", "\u0410\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u0410\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064189", "2064189", "\u042d\u041d\u0415\u041c 1", "\u042d\u041d\u0415\u041c 1", "\u0421", null);
            RailwayStationsDataProvider.put("2064110", "2064110", "\u041d\u041e\u0412\u041e\u0420\u041e\u0421\u0421", "\u041d\u041e\u0412\u041e\u0420\u041e\u0421\u0421\u0418\u0419\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064195", "2064195", "\u0422\u041e\u041d\u041d\u0415\u041b\u042c\u041d\u0410\u042f", "\u0422\u041e\u041d\u041d\u0415\u041b\u042c\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064305", "2064305", "\u041f\u0420\u041e\u0422\u041e\u041a\u0410", "\u041f\u0420\u041e\u0422\u041e\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064172", "2064172", "\u0421\u0422\u0410\u0420\u041e\u0422\u0418\u0422\u0410\u0420", "\u0421\u0422\u0410\u0420\u041e\u0422\u0418\u0422\u0410\u0420\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064168", "2064168", "\u042e\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u042e\u0420\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064068", "2064068", "\u0411\u0423\u0419\u041d\u0410\u041a\u0421\u041a", "\u0411\u0423\u0419\u041d\u0410\u041a\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064133", "2064133", "\u0428\u0415\u0414\u041e\u041a", "\u0428\u0415\u0414\u041e\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064138", "2064138", "\u0425\u0410\u0414\u0416\u041e\u0425", "\u0425\u0410\u0414\u0416\u041e\u0425", "\u0421", null);
            RailwayStationsDataProvider.put("2064015", "2064015", "\u041c\u0410\u0419\u041a\u041e\u041f", "\u041c\u0410\u0419\u041a\u041e\u041f", "\u0421", null);
            RailwayStationsDataProvider.put("2064177", "2064177", "\u0422\u0415\u041c\u0420\u042e\u041a", "\u0422\u0415\u041c\u0420\u042e\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064139", "2064139", "\u0410\u041f\u0428\u0415\u0420\u041e\u041d\u0421\u041a", "\u0410\u041f\u0428\u0415\u0420\u041e\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064277", "2064277", "\u0426\u0418\u041c\u041b\u042f\u041d\u0421\u041a\u0410\u042f", "\u0426\u0418\u041c\u041b\u042f\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064145", "2064145", "\u0412\u041e\u041b\u0413\u041e\u0414\u041e\u041d\u0421\u041a", "\u0412\u041e\u041b\u0413\u041e\u0414\u041e\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064065", "2064065", "\u041a\u0423\u0411\u0415\u0420\u041b\u0415", "\u041a\u0423\u0411\u0415\u0420\u041b\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064090", "2064090", "\u0421\u0410\u041b\u042c\u0421\u041a", "\u0421\u0410\u041b\u042c\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064258", "2064258", "\u0410\u0422\u0410\u041c\u0410\u041d", "\u0410\u0422\u0410\u041c\u0410\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064254", "2064254", "\u0417\u0415\u0420\u041d\u041e\u0413\u0420\u0410\u0414", "\u0417\u0415\u0420\u041d\u041e\u0413\u0420\u0410\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2020860", "2020860", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u041a", "\u041a\u041e\u0422\u0415\u041b\u042c\u041d\u0418\u041a\u041e\u0412\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2064272", "2064272", "\u0420\u0415\u041c\u041e\u041d\u0422\u041d\u0410\u042f", "\u0420\u0415\u041c\u041e\u041d\u0422\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064295", "2064295", "\u0417\u0418\u041c\u041e\u0412\u041d\u0418\u041a\u0418", "\u0417\u0418\u041c\u041e\u0412\u041d\u0418\u041a\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064044", "2064044", "\u041f\u0420\u041e\u041b\u0415\u0422\u0410\u0420\u0421\u041a", "\u041f\u0420\u041e\u041b\u0415\u0422\u0410\u0420\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064643", "2064643", "\u041c\u0410\u041d\u042b\u0427", "\u041c\u0410\u041d\u042b\u0427", "\u0421", null);
            RailwayStationsDataProvider.put("2064801", "2064801", "\u041e\u041f 403 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 403 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064268", "2064268", "\u041f\u0415\u0421\u0427\u0410\u041d\u041e\u041a\u041e\u041f", "\u041f\u0415\u0421\u0427\u0410\u041d\u041e\u041a\u041e\u041f\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064267", "2064267", "\u0411\u0415\u041b\u041e\u0413\u041b\u0418\u041d\u0421\u041a", "\u0411\u0415\u041b\u041e\u0413\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064266", "2064266", "\u0415\u042f", "\u0415\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064116", "2064116", "\u0410\u0420\u0422\u0415\u0417\u0418\u0410\u041d", "\u0410\u0420\u0422\u0415\u0417\u0418\u0410\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064175", "2064175", "\u041a\u0418\u0417\u041b\u042f\u0420", "\u041a\u0418\u0417\u041b\u042f\u0420", "\u0421", null);
            RailwayStationsDataProvider.put("2064204", "2064204", "\u0423\u0421\u0422\u042c \u041b\u0410\u0411\u0418\u041d", "\u0423\u0421\u0422\u042c-\u041b\u0410\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064057", "2064057", "\u0413\u041e\u0420 \u041a\u041b\u042e\u0427", "\u0413\u041e\u0420\u042f\u0427\u0418\u0419 \u041a\u041b\u042e\u0427", "\u0421", null);
            RailwayStationsDataProvider.put("2064193", "2064193", "\u0414\u0418\u041d\u0421\u041a\u0410\u042f", "\u0414\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064194", "2064194", "\u041f\u041b\u0410\u0421\u0422\u0423\u041d\u041e\u0412", "\u041f\u041b\u0410\u0421\u0422\u0423\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064265", "2064265", "\u041a\u041e\u0420\u0415\u041d\u041e\u0412\u0421\u041a", "\u041a\u041e\u0420\u0415\u041d\u041e\u0412\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064674", "2064674", "\u0411\u0423\u0417\u0418\u041d\u041a\u0410", "\u0411\u0423\u0417\u0418\u041d\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064199", "2064199", "\u0427\u0415\u041b\u0411\u0410\u0421", "\u0427\u0415\u041b\u0411\u0410\u0421", "\u0421", null);
            RailwayStationsDataProvider.put("2064188", "2064188", "\u0410\u041d\u0410\u041f\u0410", "\u0410\u041d\u0410\u041f\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2065255", "2065255", "\u0410\u0425\u0422\u0410\u0420\u0418", "\u0410\u0425\u0422\u0410\u0420\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064141", "2064141", "\u0410\u0417\u041e\u0412", "\u0410\u0417\u041e\u0412", "\u0421", null);
            RailwayStationsDataProvider.put("2064155", "2064155", "\u0416\u0415\u041b\u0415\u0417\u041d\u041e\u0412\u041e\u0414", "\u0416\u0415\u041b\u0415\u0417\u041d\u041e\u0412\u041e\u0414\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064605", "2064605", "\u041b\u0418\u0425\u0410\u042f", "\u041b\u0418\u0425\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064570", "2064570", "\u041a\u0410\u041c\u0415\u041d\u0421\u041a\u0410\u042f", "\u041a\u0410\u041c\u0415\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064568", "2064568", "\u0413\u041b\u0423\u0411\u041e\u041a\u0410\u042f", "\u0413\u041b\u0423\u0411\u041e\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064565", "2064565", "\u0421\u0422 \u0421\u0422\u0410\u041d\u0418\u0426\u0410", "\u0421\u0422\u0410\u0420\u0410\u042f \u0421\u0422\u0410\u041d\u0418\u0426\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064375", "2064375", "\u041c\u0418\u041b\u041b\u0415\u0420\u041e\u0412\u041e", "\u041c\u0418\u041b\u041b\u0415\u0420\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064558", "2064558", "\u0428\u0415\u041f\u0422\u0423\u0425\u041e\u0412\u041a\u0410", "\u0428\u0415\u041f\u0422\u0423\u0425\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064603", "2064603", "\u0427\u0415\u0420\u0422\u041a\u041e\u0412\u041e", "\u0427\u0415\u0420\u0422\u041a\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064561", "2064561", "\u0423\u0421\u041e\u0412\u041e", "\u0423\u0421\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064610", "2064610", "\u041c\u041e\u0420\u041e\u0417\u041e\u0412\u0421\u041a", "\u041c\u041e\u0420\u041e\u0417\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064580", "2064580", "\u0411 \u041a\u0410\u041b\u0418\u0422\u0412\u0410", "\u0411\u0415\u041b\u0410\u042f \u041a\u0410\u041b\u0418\u0422\u0412\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064191", "2064191", "\u0411 \u0418\u0421\u041a\u0420\u0410", "\u0411\u041e\u041b\u042c\u0428\u0415\u0412\u0418\u0421\u0422\u0421\u041a\u0410\u042f \u0418\u0421\u041a\u0420\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064677", "2064677", "\u0423\u0421\u0422\u042c \u0414\u041e\u041d\u0415\u0426", "\u0423\u0421\u0422\u042c-\u0414\u041e\u041d\u0415\u0426\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064612", "2064612", "\u0422\u0418\u041c\u0410\u0428 \u041e\u0411\u0425", "\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u0421\u041a\u0418\u0419 \u041e\u0411\u0425\u041e\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064032", "2064032", "\u041c\u0410\u0422 \u041a\u0423\u0420\u0413\u0410\u041d", "\u041c\u0410\u0422\u0412\u0415\u0415\u0412 \u041a\u0423\u0420\u0413\u0410\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064255", "2064255", "\u041d\u0415\u041a\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041d\u0415\u041a\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2065617", "2065617", "\u041e\u0411\u0423\u0425\u041e\u0412\u0421\u041a\u0418\u0419", "\u041e\u0411\u0423\u0425\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064615", "2064615", "\u0417\u0410\u0419\u0427\u0418\u041a\u041e\u0412\u041e", "\u0417\u0410\u0419\u0427\u0418\u041a\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064620", "2064620", "\u041c\u0415\u0427\u0415\u0422\u041d\u041e\u0412\u0421\u041a", "\u041c\u0415\u0427\u0415\u0422\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064623", "2064623", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u041e\u041d\u0415", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u041e\u041d\u0415\u0426\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064788", "2064788", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u0420", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u0420", "\u0421", null);
            RailwayStationsDataProvider.put("2064291", "2064291", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420", "\u0410\u0420\u041c\u0410\u0412\u0418\u0420", "\u0421", null);
            RailwayStationsDataProvider.put("5700770", "5700770", "\u042f\u041b\u0410\u041c\u0410", "\u042f\u041b\u0410\u041c\u0410", "\u0410", null);
            RailwayStationsDataProvider.put("5700696", "5700696", "\u0425\u0423\u0414\u0410\u0422", "\u0425\u0423\u0414\u0410\u0422", "\u0410", null);
            RailwayStationsDataProvider.put("5700760", "5700760", "\u0425\u0410\u0427\u041c\u0410\u0421", "\u0425\u0410\u0427\u041c\u0410\u0421", "\u0410", null);
            RailwayStationsDataProvider.put("5700701", "5700701", "\u0414\u0418\u0412\u0418\u0427\u0418", "\u0414\u0418\u0412\u0418\u0427\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700711", "5700711", "\u0421\u0423\u041c\u0413\u0410\u0418\u0422", "\u0421\u0423\u041c\u0413\u0410\u0418\u0422", "\u0410", null);
            RailwayStationsDataProvider.put("5700853", "5700853", "\u041f\u0418\u0420\u0428\u0410\u0413\u0418", "\u041f\u0418\u0420\u0428\u0410\u0413\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700913", "5700913", "\u0417\u0410\u0411\u0420\u0410\u0422 2", "\u0417\u0410\u0411\u0420\u0410\u0422 2", "\u0410", null);
            RailwayStationsDataProvider.put("5700915", "5700915", "\u0421\u0410\u0411\u0423\u041d\u0427\u0418", "\u0421\u0410\u0411\u0423\u041d\u0427\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700910", "5700910", "\u0411\u0410\u041a\u0418\u0425\u0410\u041d\u041e\u0412", "\u0411\u0410\u041a\u0418\u0425\u0410\u041d\u041e\u0412", "\u0410", null);
            RailwayStationsDataProvider.put("5700905", "5700905", "\u0411\u0415\u042e\u041a \u0428\u041e\u0420", "\u0411\u0415\u042e\u041a-\u0428\u041e\u0420", "\u0410", null);
            RailwayStationsDataProvider.put("5700925", "5700925", "\u041f\u041b. 3 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 3 \u041a\u041c", "\u0410", null);
            RailwayStationsDataProvider.put("5700782", "5700782", "\u0425\u0410\u041d\u0410\u0411\u0410\u0414", "\u0425\u0410\u041d\u0410\u0411\u0410\u0414", "\u0410", null);
            RailwayStationsDataProvider.put("5700781", "5700781", "\u0421\u0410\u0411\u0423\u0425\u0418", "\u0421\u0410\u0411\u0423\u0425\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700779", "5700779", "\u0428\u0415\u041a\u0418", "\u0428\u0415\u041a\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700778", "5700778", "\u041a\u0410\u0425\u0418", "\u041a\u0410\u0425\u0418", "\u0410", null);
            RailwayStationsDataProvider.put("5700777", "5700777", "\u0417\u0410\u041a\u0410\u0422\u0410\u041b\u042b", "\u0417\u0410\u041a\u0410\u0422\u0410\u041b\u042b", "\u0410", null);
            RailwayStationsDataProvider.put("5700775", "5700775", "\u0411\u0415\u041b\u041e\u041a\u0410\u041d\u042b", "\u0411\u0415\u041b\u041e\u041a\u0410\u041d\u042b", "\u0410", null);
            RailwayStationsDataProvider.put("5700001", "5700001", "\u0411\u0410\u041a\u0423", "\u0411\u0410\u041a\u0423", "\u0410", null);
            RailwayStationsDataProvider.put("5800390", "5800390", "\u0413\u042e\u041c\u0420\u0418", "\u0413\u042e\u041c\u0420\u0418", "\u0417", null);
            RailwayStationsDataProvider.put("2800300", "4200300", "\u0421\u0423\u0425\u0423\u041c", "\u0421\u0423\u0425\u0423\u041c", "J", null);
            RailwayStationsDataProvider.put("4200360", "4200360", "\u0413\u0423\u0414\u0410\u0423\u0422\u0410", "\u0413\u0423\u0414\u0410\u0423\u0422\u0410", "J", null);
            RailwayStationsDataProvider.put("2800410", "2800410", "\u0421\u0410\u041c\u0422\u0420\u0415\u0414\u0418\u04101", "\u0421\u0410\u041c\u0422\u0420\u0415\u0414\u0418\u0410 1", "J", null);
            RailwayStationsDataProvider.put("2800001", "2800001", "\u0422\u0411\u0418\u041b\u0418\u0421\u0418 \u041f", "\u0422\u0411\u0418\u041b\u0418\u0421\u0418 \u041f\u0410\u0421\u0421", "J", null);
            RailwayStationsDataProvider.put("2014412", "2014412", "\u0410\u041b \u041d\u0415\u0412\u0421\u041a\u0410\u042f", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e-\u041d\u0415\u0412\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014414", "2014414", "\u0411\u041e\u0413\u041e\u042f\u0412\u041b\u0415\u041d\u0421", "\u0411\u041e\u0413\u041e\u042f\u0412\u041b\u0415\u041d\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014420", "2014420", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d \u0423\u0420", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d\u0421\u041a-\u0423\u0420\u0410\u041b\u042c\u0421\u041a\u0418\u0419", "\u0412", null);
            RailwayStationsDataProvider.put("2014418", "2014418", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d \u0412", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d\u0421\u041a-\u0412\u041e\u0420\u041e\u041d", "\u0412", null);
            RailwayStationsDataProvider.put("2014422", "2014422", "\u0418\u0417\u0411\u0415\u0420\u0414\u0415\u0419", "\u0418\u0417\u0411\u0415\u0420\u0414\u0415\u0419", "\u0412", null);
            RailwayStationsDataProvider.put("2014390", "2014390", "\u0413\u0420\u042f\u0417\u0418 \u0412\u041e\u0420", "\u0413\u0420\u042f\u0417\u0418-\u0412\u041e\u0420\u041e\u041d\u0415\u0416\u0421\u041a\u0418\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014484", "2014484", "\u0423\u0421\u041c\u0410\u041d\u042c", "\u0423\u0421\u041c\u0410\u041d\u042c", "\u0412", null);
            RailwayStationsDataProvider.put("2014483", "2014483", "\u0413\u0420\u0410\u0424\u0421\u041a\u0410\u042f", "\u0413\u0420\u0410\u0424\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014001", "2014001", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416 1", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416 1", "\u0412", null);
            RailwayStationsDataProvider.put("2014540", "2014540", "\u0420\u041e\u0421\u0421\u041e\u0428\u042c", "\u0420\u041e\u0421\u0421\u041e\u0428\u042c", "\u0412", null);
            RailwayStationsDataProvider.put("2014377", "2014377", "\u041a\u0410\u0417\u0418\u041d\u041a\u0410", "\u041a\u0410\u0417\u0418\u041d\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014130", "2014130", "\u041b\u0418\u041f\u0415\u0426\u041a", "\u041b\u0418\u041f\u0415\u0426\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014448", "2014448", "\u0411\u0410\u0419\u0413\u041e\u0420\u0410", "\u0411\u0410\u0419\u0413\u041e\u0420\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2015449", "2015449", "\u0425\u0412\u041e\u0420\u041e\u0421\u0422\u042f\u041d", "\u0425\u0412\u041e\u0420\u041e\u0421\u0422\u042f\u041d\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2015451", "2015451", "\u041f\u041b\u0410\u0412\u0418\u0426\u0410", "\u041f\u041b\u0410\u0412\u0418\u0426\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014430", "2014430", "\u0414\u041e\u0411\u0420\u0418\u041d\u041a\u0410", "\u0414\u041e\u0411\u0420\u0418\u041d\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014452", "2014452", "\u0421\u0422\u0420\u0415\u041b\u0415\u0426\u041a\u0410\u042f", "\u0421\u0422\u0420\u0415\u041b\u0415\u0426\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2015453", "2015453", "\u041e\u0411\u041e\u0420\u041e\u041d\u0410", "\u041e\u0411\u041e\u0420\u041e\u041d\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014456", "2014456", "\u042f\u0421\u0422\u0420\u0415\u0411\u041e\u0412\u041a\u0410", "\u042f\u0421\u0422\u0420\u0415\u0411\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014457", "2014457", "\u0422\u041e\u041a\u0410\u0420\u0415\u0412\u041a\u0410", "\u0422\u041e\u041a\u0410\u0420\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014458", "2014458", "\u0420\u042b\u041c\u0410\u0420\u0415\u0412\u041e", "\u0420\u042b\u041c\u0410\u0420\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014440", "2014440", "\u0416\u0415\u0420\u0414\u0415\u0412\u041a\u0410", "\u0416\u0415\u0420\u0414\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014461", "2014461", "\u0422\u0415\u0420\u041d\u041e\u0412\u041a\u0410", "\u0422\u0415\u0420\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014465", "2014465", "\u0413\u0420\u0418\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0413\u0420\u0418\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014450", "2014450", "\u0411\u041e\u0420\u0418\u0421\u041e\u0413\u041b\u0415\u0411", "\u0411\u041e\u0420\u0418\u0421\u041e\u0413\u041b\u0415\u0411\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014490", "2014490", "\u041f\u041e\u0412\u041e\u0420\u0418\u041d\u041e", "\u041f\u041e\u0412\u041e\u0420\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014537", "2014537", "\u0414\u0423\u041f\u041b\u042f\u0422\u041a\u0410", "\u0414\u0423\u041f\u041b\u042f\u0422\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014360", "2014360", "\u0412\u0410\u041b\u0423\u0419\u041a\u0418", "\u0412\u0410\u041b\u0423\u0419\u041a\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014460", "2014460", "\u0410\u041b\u0415\u041a\u0421\u0415\u0415\u0412\u041a\u0410", "\u0410\u041b\u0415\u041a\u0421\u0415\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014515", "2014515", "\u041e\u0421\u0422\u0420\u041e\u0413\u041e\u0416\u0421\u041a", "\u041e\u0421\u0422\u0420\u041e\u0413\u041e\u0416\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014120", "2014120", "\u041b\u0418\u0421\u041a\u0418", "\u041b\u0418\u0421\u041a\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014480", "2014480", "\u0422\u0410\u041b\u041e\u0412\u0410\u042f", "\u0422\u0410\u041b\u041e\u0412\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014527", "2014527", "\u0410\u0411\u0420\u0410\u041c\u041e\u0412\u041a\u0410", "\u0410\u0411\u0420\u0410\u041c\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014529", "2014529", "\u041a\u041e\u041b\u0415\u041d\u041e", "\u041a\u041e\u041b\u0415\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014532", "2014532", "\u041d\u041e\u0412\u041e\u0425\u041e\u041f\u0415\u0420\u0421", "\u041d\u041e\u0412\u041e\u0425\u041e\u041f\u0415\u0420\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014474", "2014474", "\u041b\u0410\u0422\u041d\u0410\u042f", "\u041b\u0410\u0422\u041d\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014475", "2014475", "\u0421\u0415\u041c\u0418\u041b\u0423\u041a\u0418", "\u0421\u0415\u041c\u0418\u041b\u0423\u041a\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014424", "2014424", "\u041d\u0418\u041a\u0418\u0424\u041e\u0420\u041e\u0412\u041a", "\u041d\u0418\u041a\u0418\u0424\u041e\u0420\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014700", "2014700", "\u0422\u0410\u041c\u0411\u041e\u0412 1", "\u0422\u0410\u041c\u0411\u041e\u0412 1", "\u0412", null);
            RailwayStationsDataProvider.put("2015436", "2015436", "\u041f\u041b\u0410\u0422\u041e\u041d\u041e\u0412\u041a\u0410", "\u041f\u041b\u0410\u0422\u041e\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2015435", "2015435", "\u041b\u041e\u041c\u041e\u0412\u0418\u0421", "\u041b\u041e\u041c\u041e\u0412\u0418\u0421", "\u0412", null);
            RailwayStationsDataProvider.put("2015432", "2015432", "\u0418\u041d\u041e\u041a\u041e\u0412\u041a\u0410", "\u0418\u041d\u041e\u041a\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014410", "2014410", "\u041a\u0418\u0420\u0421\u0410\u041d\u041e\u0412", "\u041a\u0418\u0420\u0421\u0410\u041d\u041e\u0412", "\u0412", null);
            RailwayStationsDataProvider.put("2014754", "2014754", "\u0423\u041c\u0415\u0422", "\u0423\u041c\u0415\u0422", "\u0412", null);
            RailwayStationsDataProvider.put("2014755", "2014755", "\u0422\u0410\u041c\u0410\u041b\u0410", "\u0422\u0410\u041c\u0410\u041b\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014720", "2014720", "\u0420\u0422\u0418\u0429\u0415\u0412\u041e 1", "\u0420\u0422\u0418\u0429\u0415\u0412\u041e 1", "\u0412", null);
            RailwayStationsDataProvider.put("2014447", "2014447", "\u041e\u0411\u041b\u041e\u0412\u041a\u0410", "\u041e\u0411\u041b\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014737", "2014737", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412 \u041f", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412-\u041f\u0410\u0421\u0421\u0410\u0416\u0418\u0420\u0421\u041a\u0418\u0419", "\u0412", null);
            RailwayStationsDataProvider.put("2014740", "2014740", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412 1", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412 1", "\u0412", null);
            RailwayStationsDataProvider.put("2020746", "2020746", "\u0418\u041b\u042c\u041c\u0415\u041d\u042c", "\u0418\u041b\u042c\u041c\u0415\u041d\u042c", "\u0416", null);
            RailwayStationsDataProvider.put("2014380", "2014380", "\u0420\u0410\u041d\u0415\u041d\u0411\u0423\u0420\u0413", "\u0420\u0410\u041d\u0415\u041d\u0411\u0423\u0420\u0413", "\u0412", null);
            RailwayStationsDataProvider.put("2014340", "2014340", "\u0421\u0422\u0410\u0420 \u041e\u0421\u041a\u041e\u041b", "\u0421\u0422\u0410\u0420\u042b\u0419 \u041e\u0421\u041a\u041e\u041b", "\u0412", null);
            RailwayStationsDataProvider.put("2014394", "2014394", "\u0413\u041e\u0420\u0428\u0415\u0427\u041d\u041e\u0415", "\u0413\u041e\u0420\u0428\u0415\u0427\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2015391", "2015391", "\u041a\u0410\u0421\u0422\u041e\u0420\u041d \u041d", "\u041a\u0410\u0421\u0422\u041e\u0420\u041d\u0410\u042f-\u041d\u041e\u0412\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2015388", "2015388", "\u041a\u0410\u0421\u0422\u041e\u0420\u041d \u0412", "\u041a\u0410\u0421\u0422\u041e\u0420\u041d\u0410\u042f-\u0412\u041e\u0421\u0422\u041e\u0427\u041d\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2015386", "2015386", "\u041d\u0410\u0411\u0415\u0420\u0415\u0416\u041d\u041e\u0415", "\u041d\u0410\u0411\u0415\u0420\u0415\u0416\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2015384", "2015384", "\u0422\u0415\u0420\u0411\u0423\u041d\u042b", "\u0422\u0415\u0420\u0411\u0423\u041d\u042b", "\u0412", null);
            RailwayStationsDataProvider.put("2015382", "2015382", "\u0414\u041e\u041b\u0413\u041e\u0420\u0423\u041a\u041e\u0412", "\u0414\u041e\u041b\u0413\u041e\u0420\u0423\u041a\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2015365", "2015365", "\u0421\u0422\u0410\u041d\u041e\u0412\u0410\u042f", "\u0421\u0422\u0410\u041d\u041e\u0412\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2015364", "2015364", "\u0413\u0420 \u0412\u041e\u0420\u0413\u041e\u041b", "\u0413\u0420\u0423\u041d\u0418\u041d \u0412\u041e\u0420\u0413\u041e\u041b", "\u0412", null);
            RailwayStationsDataProvider.put("2015363", "2015363", "\u0411\u0410\u0411\u0410\u0420\u042b\u041a\u0418\u041d\u041e", "\u0411\u0410\u0411\u0410\u0420\u042b\u041a\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2015362", "2015362", "\u041b\u041e\u0411\u0410\u041d\u041e\u0412\u041e", "\u041b\u041e\u0411\u0410\u041d\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014398", "2014398", "\u041c\u0418\u041b\u041e\u0421\u041b\u0410\u0412\u0421\u041a", "\u041c\u0418\u041b\u041e\u0421\u041b\u0410\u0412\u0421\u041a\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014496", "2014496", "\u041f\u0420\u0418\u0414\u0410\u0427\u0410", "\u041f\u0420\u0418\u0414\u0410\u0427\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014499", "2014499", "\u041a\u041e\u041b\u041e\u0414\u0415\u0417\u041d\u0410\u042f", "\u041a\u041e\u041b\u041e\u0414\u0415\u0417\u041d\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014502", "2014502", "\u0414\u0410\u0412\u042b\u0414\u041e\u0412\u041a\u0410", "\u0414\u0410\u0412\u042b\u0414\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014545", "2014545", "\u0415\u0412\u0414\u0410\u041a\u041e\u0412\u041e", "\u0415\u0412\u0414\u0410\u041a\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014549", "2014549", "\u041f\u041e\u0414\u0413\u041e\u0420\u041d\u041e\u0415", "\u041f\u041e\u0414\u0413\u041e\u0420\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014553", "2014553", "\u041c\u0418\u0422\u0420\u041e\u0424\u0410\u041d\u041e\u0412", "\u041c\u0418\u0422\u0420\u041e\u0424\u0410\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014550", "2014550", "\u041a\u0410\u041d\u0422\u0415\u041c\u0418\u0420\u041e\u0412", "\u041a\u0410\u041d\u0422\u0415\u041c\u0418\u0420\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014556", "2014556", "\u0413\u0410\u0420\u0422\u041c\u0410\u0428\u0415\u0412\u041a", "\u0413\u0410\u0420\u0422\u041c\u0410\u0428\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014721", "2014721", "\u041b\u0415\u0422\u042f\u0416\u0415\u0412\u041a\u0410", "\u041b\u0415\u0422\u042f\u0416\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014730", "2014730", "\u0410\u0420\u041a\u0410\u0414\u0410\u041a", "\u0410\u0420\u041a\u0410\u0414\u0410\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014710", "2014710", "\u0421\u0415\u0420\u0414\u041e\u0411\u0421\u041a", "\u0421\u0415\u0420\u0414\u041e\u0411\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2024549", "2024549", "\u041a\u0420\u0418\u0412\u041e\u0417\u0415\u0420\u041e\u0412", "\u041a\u0420\u0418\u0412\u041e\u0417\u0415\u0420\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2014336", "2014336", "\u041f\u041e\u041b\u0415\u0412\u0410\u042f", "\u041f\u041e\u041b\u0415\u0412\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014338", "2014338", "\u0421\u041e\u041b\u041d\u0426\u0415\u0412\u041e", "\u0421\u041e\u041b\u041d\u0426\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014379", "2014379", "\u0420\u0416\u0410\u0412\u0410", "\u0420\u0416\u0410\u0412\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014382", "2014382", "\u041f\u0420\u041e\u0425\u041e\u0420\u041e\u0412\u041a\u0410", "\u041f\u0420\u041e\u0425\u041e\u0420\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014385", "2014385", "\u0413\u041e\u0421\u0422\u0418\u0429\u0415\u0412\u041e", "\u0413\u041e\u0421\u0422\u0418\u0429\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014370", "2014370", "\u0411\u0415\u041b\u0413\u041e\u0420\u041e\u0414", "\u0411\u0415\u041b\u0413\u041e\u0420\u041e\u0414", "\u0412", null);
            RailwayStationsDataProvider.put("2014436", "2014436", "\u0422\u041e\u041b\u041e\u041a\u041e\u041d\u041d\u041e\u0415", "\u0422\u041e\u041b\u041e\u041a\u041e\u041d\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014341", "2014341", "\u0421\u0410\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u0421\u0410\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014344", "2014344", "\u0427\u0410\u041f\u041b\u042b\u0416\u041d\u041e\u0415", "\u0427\u0410\u041f\u041b\u042b\u0416\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014346", "2014346", "\u041e\u0421\u041a\u041e\u041b\u0415\u0426", "\u041e\u0421\u041a\u041e\u041b\u0415\u0426", "\u0412", null);
            RailwayStationsDataProvider.put("2014347", "2014347", "\u0413\u0423\u0411\u041a\u0418\u041d", "\u0413\u0423\u0411\u041a\u0418\u041d", "\u0412", null);
            RailwayStationsDataProvider.put("2014348", "2014348", "\u041b\u0415\u0411\u0415\u0414\u0418", "\u041b\u0415\u0411\u0415\u0414\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014352", "2014352", "\u0413\u0423\u041c\u041d\u042b", "\u0413\u0423\u041c\u041d\u042b", "\u0412", null);
            RailwayStationsDataProvider.put("2014391", "2014391", "\u041d\u0415\u0416\u0415\u0413\u041e\u041b\u042c", "\u041d\u0415\u0416\u0415\u0413\u041e\u041b\u042c", "\u0412", null);
            RailwayStationsDataProvider.put("2014454", "2014454", "\u0425\u041e\u0422\u041c\u042b\u0416\u0421\u041a", "\u0425\u041e\u0422\u041c\u042b\u0416\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014354", "2014354", "\u0413\u041e\u041b\u041e\u0424\u0415\u0415\u0412\u041a\u0410", "\u0413\u041e\u041b\u041e\u0424\u0415\u0415\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014356", "2014356", "\u0427\u0415\u0420\u041d\u042f\u041d\u041a\u0410", "\u0427\u0415\u0420\u041d\u042f\u041d\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014350", "2014350", "\u041d\u041e\u0412 \u041e\u0421\u041a\u041e\u041b", "\u041d\u041e\u0412\u042b\u0419 \u041e\u0421\u041a\u041e\u041b", "\u0412", null);
            RailwayStationsDataProvider.put("2014359", "2014359", "\u0421\u0422\u0410\u0420\u041e\u0418\u0412\u0410\u041d", "\u0421\u0422\u0410\u0420\u041e\u0418\u0412\u0410\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014361", "2014361", "\u0412\u041e\u041b\u041e\u041a\u041e\u041d\u041e\u0412\u041a", "\u0412\u041e\u041b\u041e\u041a\u041e\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014364", "2014364", "\u0421\u041e\u041b\u041e\u0422\u0418", "\u0421\u041e\u041b\u041e\u0422\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014365", "2014365", "\u0422\u0420\u041e\u0428\u0418\u041d\u041e", "\u0422\u0420\u041e\u0428\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014411", "2014411", "\u0423\u0420\u0410\u0417\u041e\u0412\u041e", "\u0423\u0420\u0410\u0417\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014000", "2014000", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416", "\u0412", null);
            RailwayStationsDataProvider.put("2014704", "2014704", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412", "\u0411\u0410\u041b\u0410\u0428\u041e\u0412", "\u0412", null);
            RailwayStationsDataProvider.put("2014421", "2014421", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d\u0421\u041a", "\u041c\u0418\u0427\u0423\u0420\u0418\u041d\u0421\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2020021", "2020021", "\u041e\u041f 11 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 11 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020025", "2020025", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020031", "2020031", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020048", "2020048", "\u041e\u041f 64\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 64\u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020500", "2020500", "\u0412\u041e\u041b\u0413\u041e\u0413\u0420 1", "\u0412\u041e\u041b\u0413\u041e\u0413\u0420\u0410\u0414 1", "\u0416", null);
            RailwayStationsDataProvider.put("2020832", "2020832", "\u0412\u041e\u041b\u0416\u0421\u041a\u0418\u0419", "\u0412\u041e\u041b\u0416\u0421\u041a\u0418\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2021064", "2021064", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2021069", "2021069", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2020124", "2020124", "\u041f\u0415\u0421\u0427\u0410\u041d\u042b\u0419", "\u041f\u0415\u0421\u0427\u0410\u041d\u042b\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2020917", "2020917", "\u0412 \u0411\u0410\u0421\u041a\u0423\u041d\u0427", "\u0412\u0415\u0420\u0425\u041d\u0418\u0419 \u0411\u0410\u0421\u041a\u0423\u041d\u0427\u0410\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2020760", "2020760", "\u041f\u0415\u0422\u0420\u041e\u0412 \u0412\u0410\u041b", "\u041f\u0415\u0422\u0420\u041e\u0412 \u0412\u0410\u041b", "\u0416", null);
            RailwayStationsDataProvider.put("2020870", "2020870", "\u041f\u0423\u0413\u0410\u0427\u0415\u0412\u0421\u041a", "\u041f\u0423\u0413\u0410\u0427\u0415\u0412\u0421\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2020864", "2020864", "\u0412\u041e\u041b\u042c\u0421\u041a 2", "\u0412\u041e\u041b\u042c\u0421\u041a 2", "\u0416", null);
            RailwayStationsDataProvider.put("2020886", "2020886", "\u0422\u041e\u041f\u041e\u041b\u0415\u041a", "\u0422\u041e\u041f\u041e\u041b\u0415\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2025957", "2025957", "\u0427\u0410\u0413\u0420\u0410", "\u0427\u0410\u0413\u0420\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2020880", "2020880", "\u0415\u0420\u0428\u041e\u0412", "\u0415\u0420\u0428\u041e\u0412", "\u0416", null);
            RailwayStationsDataProvider.put("2020861", "2020861", "\u0427\u0415\u0420\u041d\u042b\u0428\u041a\u041e\u0412", "\u0427\u0415\u0420\u041d\u042b\u0428\u041a\u041e\u0412", "\u0416", null);
            RailwayStationsDataProvider.put("2020850", "2020850", "\u041e\u0411\u041b\u0418\u0412\u0421\u041a\u0410\u042f", "\u041e\u0411\u041b\u0418\u0412\u0421\u041a\u0410\u042f", "\u0416", null);
            RailwayStationsDataProvider.put("2021068", "2021068", "\u0421\u0415\u041a\u0420\u0415\u0422\u0415\u0412", "\u0421\u0415\u041a\u0420\u0415\u0422\u0415\u0412", "\u0416", null);
            RailwayStationsDataProvider.put("2020840", "2020840", "\u0421\u0423\u0420\u041e\u0412\u0418\u041a\u0418\u041d\u041e", "\u0421\u0423\u0420\u041e\u0412\u0418\u041a\u0418\u041d\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020858", "2020858", "\u0427\u0418\u0420", "\u0427\u0418\u0420", "\u0416", null);
            RailwayStationsDataProvider.put("2020829", "2020829", "\u041b\u041e\u041a\u041e\u041c \u0414\u0415\u041f\u041e", "\u041b\u041e\u041a\u041e\u041c\u041e\u0422\u0418\u0412\u041d\u041e\u0415 \u0414\u0415\u041f\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020079", "2020079", "\u0420\u0417\u0414 161 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 161 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020078", "2020078", "\u0420\u0417\u0414 140 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 140 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020845", "2020845", "\u0416\u0423\u0422\u041e\u0412\u041e", "\u0416\u0423\u0422\u041e\u0412\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020823", "2020823", "\u041a\u0410\u0427\u0410\u041b\u0418\u041d\u041e", "\u041a\u0410\u0427\u0410\u041b\u0418\u041d\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020830", "2020830", "\u0410\u0420\u0427\u0415\u0414\u0410", "\u0410\u0420\u0427\u0415\u0414\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2020820", "2020820", "\u0421\u0415\u0411\u0420\u042f\u041a\u041e\u0412\u041e", "\u0421\u0415\u0411\u0420\u042f\u041a\u041e\u0412\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020131", "2020131", "\u0422\u0420\u041e\u0418\u0426\u041a\u0418\u0419", "\u0422\u0420\u041e\u0418\u0426\u041a\u0418\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2020950", "2020950", "\u0424\u0418\u041b\u041e\u041d\u041e\u0412\u041e", "\u0424\u0418\u041b\u041e\u041d\u041e\u0412\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020088", "2020088", "\u0420\u0417\u0414 782 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 782 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020089", "2020089", "\u0420\u0417\u0414 764 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 764 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020091", "2020091", "\u041e\u041f 742 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 742 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020092", "2020092", "\u0420\u0417\u0414 726 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 726 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020899", "2020899", "\u0423\u0420\u0411\u0410\u0425", "\u0423\u0420\u0411\u0410\u0425", "\u0416", null);
            RailwayStationsDataProvider.put("2020896", "2020896", "\u041f\u041b\u0415\u0421", "\u041f\u041b\u0415\u0421", "\u0416", null);
            RailwayStationsDataProvider.put("2020892", "2020892", "\u0410\u041b\u0422\u0410\u0422\u0410", "\u0410\u041b\u0422\u0410\u0422\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2020893", "2020893", "\u0414\u0415\u041c\u042c\u042f\u0421", "\u0414\u0415\u041c\u042c\u042f\u0421", "\u0416", null);
            RailwayStationsDataProvider.put("2024637", "2024637", "\u0413\u0420\u041e\u041c\u041e\u0412\u041e", "\u0413\u0420\u041e\u041c\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2020943", "2020943", "\u0412\u041e\u0417\u0420\u041e\u0416\u0414\u0415\u041d", "\u0412\u041e\u0417\u0420\u041e\u0416\u0414\u0415\u041d\u0418\u0415", "\u0416", null);
            RailwayStationsDataProvider.put("2020758", "2020758", "\u041e\u041f 99\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 99\u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020759", "2020759", "\u041e\u041f 110 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 110 \u041a\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020126", "2020126", "\u041c\u0410\u0417\u0410", "\u041c\u0410\u0417\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2021076", "2021076", "\u041a\u0420\u042f\u0416\u0418\u041c", "\u041a\u0420\u042f\u0416\u0418\u041c", "\u0416", null);
            RailwayStationsDataProvider.put("2020791", "2020791", "\u0421\u0415\u041d\u041d\u0410\u042f", "\u0421\u0415\u041d\u041d\u0410\u042f", "\u0416", null);
            RailwayStationsDataProvider.put("2020790", "2020790", "\u0410\u0422\u041a\u0410\u0420\u0421\u041a", "\u0410\u0422\u041a\u0410\u0420\u0421\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2020901", "2020901", "\u041a\u0420\u0410\u0421\u041d \u041a\u0423\u0422", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u041a\u0423\u0422", "\u0416", null);
            RailwayStationsDataProvider.put("2020780", "2020780", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0412", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0412\u041a\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2020000", "2020000", "\u0421\u0410\u0420\u0410\u0422\u041e\u0412 1", "\u0421\u0410\u0420\u0410\u0422\u041e\u0412 1 \u041f\u0410\u0421\u0421", "\u0416", null);
            RailwayStationsDataProvider.put("2020874", "2020874", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041e", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041e", "\u0416", null);
            RailwayStationsDataProvider.put("2020909", "2020909", "\u041f\u0410\u041b\u041b\u0410\u0421\u041e\u0412\u041a\u0410", "\u041f\u0410\u041b\u041b\u0410\u0421\u041e\u0412\u041a\u0410", "\u0416", null);
            RailwayStationsDataProvider.put("2020912", "2020912", "\u0414\u0416\u0410\u041d\u042b\u0411\u0415\u041a", "\u0414\u0416\u0410\u041d\u042b\u0411\u0415\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2020920", "2020920", "\u0425\u0410\u0420\u0410\u0411\u0410\u041b\u0418\u041d", "\u0425\u0410\u0420\u0410\u0411\u0410\u041b\u0418\u041d\u0421\u041a\u0410\u042f", "\u0416", null);
            RailwayStationsDataProvider.put("2020923", "2020923", "\u0410\u0428\u0423\u041b\u0423\u041a", "\u0410\u0428\u0423\u041b\u0423\u041a", "\u0416", null);
            RailwayStationsDataProvider.put("2021042", "2021042", "\u0425\u041e\u0428\u0415\u0423\u0422\u041e\u0412", "\u0425\u041e\u0428\u0415\u0423\u0422\u041e\u0412\u0421\u041a\u0418\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2020600", "2020600", "\u0410\u0421\u0422\u0420\u0410\u0425\u0410\u041d\u042c1", "\u0410\u0421\u0422\u0420\u0410\u0425\u0410\u041d\u042c 1", "\u0416", null);
            RailwayStationsDataProvider.put("2021126", "2021126", "\u0418\u041b\u042c\u041c\u0415\u041d\u041d\u042b\u0419", "\u0418\u041b\u042c\u041c\u0415\u041d\u041d\u042b\u0419", "\u0416", null);
            RailwayStationsDataProvider.put("2020119", "2020119", "\u0417\u0415\u041d\u0417\u0415\u041b\u0418", "\u0417\u0415\u041d\u0417\u0415\u041b\u0418", "\u0416", null);
            RailwayStationsDataProvider.put("2024939", "2024939", "\u0420\u0417\u0414 414\u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 414 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024501", "2024501", "\u041f\u0418\u0427\u041a\u0418\u0420\u042f\u0415\u0412\u041e", "\u041f\u0418\u0427\u041a\u0418\u0420\u042f\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024502", "2024502", "\u0412\u0410\u0414", "\u0412\u0410\u0414", "\u0419", null);
            RailwayStationsDataProvider.put("2024503", "2024503", "\u0422\u0415\u041f \u0421\u0422\u0410\u041d", "\u0422\u0415\u041f\u041b\u042b\u0419 \u0421\u0422\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024510", "2024510", "\u0417\u0423\u0411\u041e\u0412 \u041f\u041e\u041b", "\u0417\u0423\u0411\u041e\u0412\u0410 \u041f\u041e\u041b\u042f\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024520", "2024520", "\u041f\u041e\u0422\u042c\u041c\u0410", "\u041f\u041e\u0422\u042c\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024504", "2024504", "\u0412\u0418\u0425\u0420\u041e\u0412\u041e", "\u0412\u0418\u0425\u0420\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024940", "2024940", "\u041f\u041f 473 \u041a\u041c", "\u041f\u0423\u0422\u0415\u0412\u041e\u0419 \u041f\u041e\u0421\u0422 473 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024530", "2024530", "\u0422\u041e\u0420\u0411\u0415\u0415\u0412\u041e", "\u0422\u041e\u0420\u0411\u0415\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024941", "2024941", "\u0420\u0417\u0414 487 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 487 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024505", "2024505", "\u0412\u041e\u0414\u0415\u041d\u042f\u041f\u0418\u041d\u0421", "\u0412\u041e\u0414\u0415\u041d\u042f\u041f\u0418\u041d\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024912", "2024912", "\u041f\u041f 502 \u041a\u041c", "\u041f\u0423\u0422\u0415\u0412\u041e\u0419 \u041f\u041e\u0421\u0422 502 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024506", "2024506", "\u0421\u0410\u041c\u0410\u0415\u0412\u041a\u0410", "\u0421\u0410\u041c\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024911", "2024911", "\u041b\u0410\u0428\u041c\u0410", "\u041b\u0410\u0428\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024507", "2024507", "\u0417\u0410\u041f\u0418\u0429\u0418\u041a\u041e\u0412\u041e", "\u0417\u0410\u041f\u0418\u0429\u0418\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024540", "2024540", "\u041a\u041e\u0412\u042b\u041b\u041a\u0418\u041d\u041e", "\u041a\u041e\u0412\u042b\u041b\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024753", "2024753", "\u041e\u041f 534 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 534 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024910", "2024910", "\u041c\u041e\u041a\u0428\u0410", "\u041c\u041e\u041a\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024942", "2024942", "\u041e\u041f 539 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 539 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024508", "2024508", "\u0422\u041e\u041a\u041c\u041e\u0412\u041e", "\u0422\u041e\u041a\u041c\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024943", "2024943", "\u041e\u041f 547 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 547 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024948", "2024948", "\u041e\u041f 551 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 551 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025956", "2025956", "\u041e\u041f 554 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 554 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024898", "2024898", "\u0418\u041d\u0421\u0410\u0420", "\u0418\u041d\u0421\u0410\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2025961", "2025961", "\u041e\u041f 569\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 569\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024509", "2024509", "\u041a\u0410\u0414\u041e\u0428\u041a\u0418\u041d\u041e", "\u041a\u0410\u0414\u041e\u0428\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024991", "2024991", "\u0420\u0417\u0414 582 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 582 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024511", "2024511", "\u0425\u041e\u0412\u0410\u041d\u0429\u0418\u041d\u0410", "\u0425\u041e\u0412\u0410\u041d\u0429\u0418\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024970", "2024970", "\u041e\u041f 595 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 595 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024512", "2024512", "\u041f\u0410\u0419\u0413\u0410\u0420\u041c", "\u041f\u0410\u0419\u0413\u0410\u0420\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024978", "2024978", "\u041e\u041f 605 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 605 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024513", "2024513", "\u041f\u0418\u0428\u041b\u042f", "\u041f\u0418\u0428\u041b\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024979", "2024979", "\u041e\u041f 612 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 612 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024550", "2024550", "\u0420\u0423\u0417\u0410\u0415\u0412\u041a\u0410", "\u0420\u0423\u0417\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024980", "2024980", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u041e\u0419", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u041e\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2025962", "2025962", "\u0413\u041e\u041b\u0418\u0426\u0418\u041d\u041e", "\u0413\u041e\u041b\u0418\u0426\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024944", "2024944", "\u041e\u0411\u041f 626 \u041a\u041c", "\u041e\u0411\u0413\u041e\u041d\u041d\u042b\u0419 \u041f\u0423\u041d\u041a\u0422 626 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024981", "2024981", "\u041e\u041f 632 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 632 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025963", "2025963", "\u0416\u0423\u0420\u041b\u041e\u0412\u041a\u0410", "\u0416\u0423\u0420\u041b\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024993", "2024993", "\u041e\u041f 642 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 642 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024514", "2024514", "\u0412\u041e\u0415\u0412\u041e\u0414\u0421\u041a\u041e\u0415", "\u0412\u041e\u0415\u0412\u041e\u0414\u0421\u041a\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024974", "2024974", "\u0421\u0418\u041c\u0411\u0423\u0425\u041e\u0412\u041e", "\u0421\u0418\u041c\u0411\u0423\u0425\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024515", "2024515", "\u0423\u041c\u042b\u0421", "\u0423\u041c\u042b\u0421", "\u0419", null);
            RailwayStationsDataProvider.put("2024516", "2024516", "\u041a\u0410\u0427\u0415\u041b\u0410\u0419", "\u041a\u0410\u0427\u0415\u041b\u0410\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024754", "2024754", "\u041e\u041f 679 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 679 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024517", "2024517", "\u0421\u0423\u0420\u0410 \u041d\u041e\u0412\u0410\u042f", "\u0421\u0423\u0420\u0410-\u041d\u041e\u0412\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024518", "2024518", "\u0421\u0423\u0420\u0410", "\u0421\u0423\u0420\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024806", "2024806", "\u0427\u0410\u0418\u0421", "\u0427\u0410\u0418\u0421", "\u0419", null);
            RailwayStationsDataProvider.put("2024805", "2024805", "\u041d\u041e\u0427\u041a\u0410", "\u041d\u041e\u0427\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024519", "2024519", "\u0421\u0412\u0415\u0422", "\u0421\u0412\u0415\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024560", "2024560", "\u0418\u041d\u0417\u0410", "\u0418\u041d\u0417\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024521", "2024521", "\u0412\u042b\u0420\u042b\u041f\u0410\u0415\u0412\u041a\u0410", "\u0412\u042b\u0420\u042b\u041f\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024522", "2024522", "\u0414\u041e\u041b\u0416\u041d\u0418\u041a\u041e\u0412\u041e", "\u0414\u041e\u041b\u0416\u041d\u0418\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024523", "2024523", "\u0411\u0410\u0417\u0410\u0420\u041d\u0410\u042f", "\u0411\u0410\u0417\u0410\u0420\u041d\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024524", "2024524", "\u041f\u0410\u0422\u0420\u0418\u041a\u0415\u0415\u0412\u041e", "\u041f\u0410\u0422\u0420\u0418\u041a\u0415\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024837", "2024837", "\u0417\u0410\u0412 \u0420\u0415\u0428\u0415\u0422\u041a", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f \u0420\u0415\u0428\u0415\u0422\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024526", "2024526", "\u0411\u0410\u0420\u042b\u0428", "\u0411\u0410\u0420\u042b\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024527", "2024527", "\u0412\u041e\u0414\u041e\u0420\u0410\u0426\u041a\u0418\u0419", "\u0412\u041e\u0414\u041e\u0420\u0410\u0426\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024528", "2024528", "\u041f\u041e\u041b\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u041f\u041e\u041b\u0418\u0412\u0410\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024529", "2024529", "\u041d\u0410\u041b\u0415\u0419\u041a\u0410", "\u041d\u0410\u041b\u0415\u0419\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024531", "2024531", "\u041a\u0423\u0417\u041e\u0412\u0410\u0422\u041e\u0412\u041e", "\u041a\u0423\u0417\u041e\u0412\u0410\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024782", "2024782", "\u0411\u0415\u0417\u0412\u041e\u0414\u041e\u0412\u041a\u0410", "\u0411\u0415\u0417\u0412\u041e\u0414\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024532", "2024532", "\u0420\u0410\u0427\u0415\u0419\u041a\u0410", "\u0420\u0410\u0427\u0415\u0419\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024533", "2024533", "\u0411\u0410\u041b\u0410\u0428\u0415\u0419\u041a\u0410", "\u0411\u0410\u041b\u0410\u0428\u0415\u0419\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024784", "2024784", "\u0415\u0420\u0418\u041a", "\u0415\u0420\u0418\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024813", "2024813", "\u0417\u0410\u0411\u041e\u0420\u041e\u0412\u041a\u0410", "\u0417\u0410\u0411\u041e\u0420\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024599", "2024599", "\u041d\u041e\u0412\u041e\u041e\u0411\u0420\u0410\u0417\u0426", "\u041d\u041e\u0412\u041e\u041e\u0411\u0420\u0410\u0417\u0426\u041e\u0412\u041e\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024900", "2024900", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a \u0426\u0415\u041d\u0422\u0420.", "\u0419", null);
            RailwayStationsDataProvider.put("2024755", "2024755", "\u041e\u041f 7 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 7 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024622", "2024622", "\u0411\u0415\u041b\u042b\u0419 \u041a\u041b\u042e\u0427", "\u0411\u0415\u041b\u042b\u0419 \u041a\u041b\u042e\u0427", "\u0419", null);
            RailwayStationsDataProvider.put("2024623", "2024623", "\u041a\u041b\u042e\u0427\u0418\u0429\u0418", "\u041a\u041b\u042e\u0427\u0418\u0429\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024932", "2024932", "\u0420\u0417\u0414 28 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 28 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024624", "2024624", "\u041a\u0420 \u0413\u0423\u041b\u042f\u0419", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u0413\u0423\u041b\u042f\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024625", "2024625", "\u041a\u0423\u0427\u0423\u0420\u042b", "\u041a\u0423\u0427\u0423\u0420\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024626", "2024626", "\u0422\u0410\u0428\u041b\u0410", "\u0422\u0410\u0428\u041b\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025903", "2025903", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024627", "2024627", "\u041c\u041e\u041b\u0412\u0418\u041d\u041e", "\u041c\u041e\u041b\u0412\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025910", "2025910", "\u041e\u041f 66 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 66 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024628", "2024628", "\u0421\u0412\u0415\u0422\u041b\u042b\u0419", "\u0421\u0412\u0415\u0422\u041b\u042b\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024629", "2024629", "\u0413\u0420\u0415\u041c \u041a\u041b\u042e\u0427", "\u0413\u0420\u0415\u041c\u042f\u0427\u0418\u0419 \u041a\u041b\u042e\u0427", "\u0419", null);
            RailwayStationsDataProvider.put("2024791", "2024791", "\u041e\u041f 84 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 84 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024631", "2024631", "\u0422\u0423\u041a\u0428\u0423\u041c", "\u0422\u0423\u041a\u0428\u0423\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024632", "2024632", "\u0411\u0418\u0427\u0415\u0412\u041d\u041e\u0419", "\u0411\u0418\u0427\u0415\u0412\u041d\u041e\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024812", "2024812", "\u0411\u0410\u0419\u0414\u0415\u0420\u042f\u041a\u041e\u0412", "\u0411\u0410\u0419\u0414\u0415\u0420\u042f\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024633", "2024633", "\u041c\u0410\u041b\u042f\u0427\u041a\u0418\u041d\u041e", "\u041c\u0410\u041b\u042f\u0427\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024814", "2024814", "\u041e\u041f 117 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 117 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024815", "2024815", "\u041a\u0423\u0428\u041d\u0418\u041a\u041e\u0412\u041e", "\u041a\u0423\u0428\u041d\u0418\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024634", "2024634", "\u0428\u0418\u0413\u041e\u041d\u042b", "\u0428\u0418\u0413\u041e\u041d\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024890", "2024890", "\u0413\u0423\u0411\u0418\u041d\u041e", "\u0413\u0423\u0411\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024794", "2024794", "\u0420\u0410\u0414\u0423\u0413\u0410", "\u0420\u0410\u0414\u0423\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024977", "2024977", "\u041d\u041e\u0412\u041e\u0421\u042b\u0417\u0420\u0410\u041d", "\u041d\u041e\u0412\u041e\u0421\u042b\u0417\u0420\u0410\u041d\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024602", "2024602", "\u0421\u042b\u0417\u0420\u0410\u041d \u0413\u041e\u0420", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c \u0413\u041e\u0420\u041e\u0414", "\u0419", null);
            RailwayStationsDataProvider.put("2024896", "2024896", "\u0417\u0410\u0421\u042b\u0417\u0420\u0410\u041d\u0421\u041a", "\u0417\u0410\u0421\u042b\u0417\u0420\u0410\u041d\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024635", "2024635", "\u041a\u0410\u0428\u041f\u0418\u0420", "\u041a\u0410\u0428\u041f\u0418\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024636", "2024636", "\u041a\u0423\u0411\u0420\u0410", "\u041a\u0423\u0411\u0420\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024795", "2024795", "\u0420\u042f\u0411\u0418\u041d\u0410", "\u0420\u042f\u0411\u0418\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024630", "2024630", "\u041a\u0418\u041d\u0415\u041b\u042c", "\u041a\u0418\u041d\u0415\u041b\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2025817", "2025817", "\u042f\u0417\u0415\u0412\u041a\u0410", "\u042f\u0417\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024638", "2024638", "\u0422\u0423\u0420\u0413\u0415\u041d\u0415\u0412\u041a\u0410", "\u0422\u0423\u0420\u0413\u0415\u041d\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024824", "2024824", "\u041e\u041f 1161 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1161 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024889", "2024889", "\u0413\u0415\u041e\u0420\u0413\u0418\u0415\u0412\u041a\u0410", "\u0413\u0415\u041e\u0420\u0413\u0418\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025905", "2025905", "\u041e\u041f 1169 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1169 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024639", "2024639", "\u041a\u0420\u041e\u0422\u041e\u0412\u041a\u0410", "\u041a\u0420\u041e\u0422\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024646", "2024646", "\u041d\u041e\u0412\u041e\u041e\u0422\u0420\u0410\u0414\u041d", "\u041d\u041e\u0412\u041e\u041e\u0422\u0420\u0410\u0414\u041d\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024647", "2024647", "\u0422\u041e\u041b\u041a\u0410\u0419", "\u0422\u041e\u041b\u041a\u0410\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024648", "2024648", "\u041f\u041e\u0414\u0411\u0415\u041b\u042c\u0421\u041a", "\u041f\u041e\u0414\u0411\u0415\u041b\u042c\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024640", "2024640", "\u041f\u041e\u0425\u0412\u0418\u0421\u0422\u041d", "\u041f\u041e\u0425\u0412\u0418\u0421\u0422\u041d\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024650", "2024650", "\u0411\u0423\u0413\u0423\u0420\u0423\u0421\u041b\u0410\u041d", "\u0411\u0423\u0413\u0423\u0420\u0423\u0421\u041b\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024649", "2024649", "\u0417\u0410\u0413\u041b\u042f\u0414\u0418\u041d\u041e", "\u0417\u0410\u0413\u041b\u042f\u0414\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024660", "2024660", "\u0410\u0421\u0415\u041a\u0415\u0415\u0412\u041e", "\u0410\u0421\u0415\u041a\u0415\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024651", "2024651", "\u0424\u0418\u041b\u0418\u041f\u041f\u041e\u0412\u041a\u0410", "\u0424\u0418\u041b\u0418\u041f\u041f\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024652", "2024652", "\u0421\u0410\u0420\u0410\u0419 \u0413\u0418\u0420", "\u0421\u0410\u0420\u0410\u0419-\u0413\u0418\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024670", "2024670", "\u0410\u0411\u0414\u0423\u041b\u0418\u041d\u041e", "\u0410\u0411\u0414\u0423\u041b\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024653", "2024653", "\u0422\u0410\u041b \u0411\u0423\u041b\u0410\u041a", "\u0422\u0410\u041b\u0414\u042b-\u0411\u0423\u041b\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024654", "2024654", "\u041f\u0420\u0418\u042e\u0422\u041e\u0412\u041e", "\u041f\u0420\u0418\u042e\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024680", "2024680", "\u0410\u041a\u0421\u0410\u041a\u041e\u0412\u041e", "\u0410\u041a\u0421\u0410\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024655", "2024655", "\u0413\u041b\u0423\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u0413\u041b\u0423\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024656", "2024656", "\u0410\u041a\u0421\u0415\u041d\u041e\u0412\u041e", "\u0410\u041a\u0421\u0415\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024657", "2024657", "\u0428\u0410\u0424\u0420\u0410\u041d\u041e\u0412\u041e", "\u0428\u0410\u0424\u0420\u0410\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024658", "2024658", "\u0420\u0410\u0415\u0412\u041a\u0410", "\u0420\u0410\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024659", "2024659", "\u0414\u0410\u0412\u041b\u0415\u041a\u0410\u041d", "\u0414\u0410\u0412\u041b\u0415\u041a\u0410\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024661", "2024661", "\u0428\u0418\u041d\u0413 \u041a\u0423\u041b\u042c", "\u0428\u0418\u041d\u0413\u0410\u041a-\u041a\u0423\u041b\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2024690", "2024690", "\u0427\u0418\u0428\u041c\u042b 1", "\u0427\u0418\u0428\u041c\u042b 1", "\u0419", null);
            RailwayStationsDataProvider.put("2024662", "2024662", "\u0410\u041b\u041a\u0418\u041d\u041e", "\u0410\u041b\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024663", "2024663", "\u042e\u041c\u0410\u0422\u041e\u0412\u041e", "\u042e\u041c\u0410\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024664", "2024664", "\u0414\u0415\u041c\u0410", "\u0414\u0415\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024600", "2024600", "\u0423\u0424\u0410", "\u0423\u0424\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024738", "2024738", "\u0427\u0415\u0420\u041d\u0418\u041a\u041e\u0412\u041a\u0410", "\u0427\u0415\u0420\u041d\u0418\u041a\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024742", "2024742", "\u0428\u0410\u041a\u0428\u0410", "\u0428\u0410\u041a\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024743", "2024743", "\u0418\u0413\u041b\u0418\u041d\u041e", "\u0418\u0413\u041b\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024744", "2024744", "\u0422\u0410\u0412\u0422\u0418\u041c\u0410\u041d\u041e\u0412", "\u0422\u0410\u0412\u0422\u0418\u041c\u0410\u041d\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025911", "2025911", "\u041e\u041f 1680 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1680 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024745", "2024745", "\u041a\u0423\u0414\u0415\u0415\u0412\u041a\u0410", "\u041a\u0423\u0414\u0415\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024834", "2024834", "\u041e\u041f 1688 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1688 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024746", "2024746", "\u0423\u0420\u041c\u0410\u041d", "\u0423\u0420\u041c\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024747", "2024747", "\u0423\u041b\u0423 \u0422\u0415\u041b\u042f\u041a", "\u0423\u041b\u0423-\u0422\u0415\u041b\u042f\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024748", "2024748", "\u041a\u0410\u0417\u0410\u042f\u041a", "\u041a\u0410\u0417\u0410\u042f\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024760", "2024760", "\u0410\u0428\u0410", "\u0410\u0428\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025913", "2025913", "\u041e\u041f 1732 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1732 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025912", "2025912", "\u0428\u0410\u041b\u0410\u0428\u041e\u0412\u0421\u041a", "\u0428\u0410\u041b\u0410\u0428\u041e\u0412\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2025917", "2025917", "\u041e\u041f 1738 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1738 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025918", "2025918", "\u041e\u041f 1740 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1740 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024749", "2024749", "\u041c\u0418\u041d\u042c\u042f\u0420", "\u041c\u0418\u041d\u042c\u042f\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024885", "2024885", "\u0411\u0418\u042f\u041d\u041a\u0410", "\u0411\u0418\u042f\u041d\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025914", "2025914", "\u041e\u041f 1753 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1753 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025915", "2025915", "\u041e\u041f 1756\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1756 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024751", "2024751", "\u0421\u0418\u041c\u0421\u041a\u0410\u042f", "\u0421\u0418\u041c\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2025925", "2025925", "\u041e\u041f 1762 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1762 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025933", "2025933", "\u041e\u041f 1766 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1766 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024752", "2024752", "\u0415\u0420\u0410\u041b", "\u0415\u0420\u0410\u041b", "\u0419", null);
            RailwayStationsDataProvider.put("2025916", "2025916", "\u041e\u041f 1774\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1774 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2040580", "2040580", "\u041a\u0420\u041e\u041f\u0410\u0427\u0415\u0412\u041e", "\u041a\u0420\u041e\u041f\u0410\u0427\u0415\u0412\u041e", "\u0423", null);
            RailwayStationsDataProvider.put("2024608", "2024608", "\u0417\u0412\u0415\u0417\u0414\u0410", "\u0417\u0412\u0415\u0417\u0414\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025958", "2025958", "\u0428\u0418\u0420\u041e\u041a\u041e\u041f\u041e\u041b", "\u0428\u0418\u0420\u041e\u041a\u041e\u041f\u041e\u041b\u042c\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024926", "2024926", "\u0420\u0410\u0417\u0418\u041d\u0421\u041a\u0418\u0419", "\u0420\u0410\u0417\u0418\u041d\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024768", "2024768", "\u0410\u041b\u041b\u0410\u0413\u0423\u0412\u0410\u0422", "\u0410\u041b\u041b\u0410\u0413\u0423\u0412\u0410\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024767", "2024767", "\u0418\u0428\u0418\u041c\u0411\u0410\u0415\u0412\u041e", "\u0418\u0428\u0418\u041c\u0411\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024707", "2024707", "\u0410\u041a\u0411\u0410\u0428", "\u0410\u041a\u0411\u0410\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024995", "2024995", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025934", "2025934", "\u041e\u041f 13 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 13 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025959", "2025959", "\u042f\u041b\u0410\u041d", "\u042f\u041b\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024996", "2024996", "\u041e\u041f 19 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 19 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024708", "2024708", "\u041f\u0418\u0421\u042c\u041c\u042f\u041d\u041a\u0410", "\u041f\u0418\u0421\u042c\u041c\u042f\u041d\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024997", "2024997", "\u041e\u041f 30 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 30 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024709", "2024709", "\u0412\u0410\u0422\u0410\u041d", "\u0412\u0410\u0422\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024998", "2024998", "\u041e\u041f 48 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 48 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024788", "2024788", "\u041a\u0415\u0420\u041b\u0415\u0419", "\u041a\u0415\u0420\u041b\u0415\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024851", "2024851", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024711", "2024711", "\u041c\u0418\u041d\u041d\u0418\u0411\u0410\u0415\u0412", "\u041c\u0418\u041d\u041d\u0418\u0411\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024712", "2024712", "\u041a\u0423\u041b\u042c\u0428\u0410\u0420\u0418\u041f", "\u041a\u0423\u041b\u042c\u0428\u0410\u0420\u0418\u041f\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024713", "2024713", "\u0410\u041b\u042c\u041c\u0415\u0422\u042c\u0415\u0412\u0421", "\u0410\u041b\u042c\u041c\u0415\u0422\u042c\u0415\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024951", "2024951", "\u041e\u041f 85 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 85 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024875", "2024875", "\u0410\u041a\u0422\u0410\u0428", "\u0410\u041a\u0422\u0410\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024952", "2024952", "\u041e\u041f 95 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 95 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024789", "2024789", "\u041c\u0410\u0412\u0420\u0418\u041d\u041e", "\u041c\u0410\u0412\u0420\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024949", "2024949", "\u0421\u0412\u0415\u0422 \u041e\u0417\u0415\u0420\u041e", "\u0421\u0412\u0415\u0422\u041b\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024953", "2024953", "\u041e\u041f 119\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 119\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024714", "2024714", "\u0417\u0410\u0418\u041d\u0421\u041a", "\u0417\u0410\u0418\u041d\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024954", "2024954", "\u041e\u041f 136 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 136 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024897", "2024897", "\u0417\u042b\u0427\u0410", "\u0417\u042b\u0427\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024955", "2024955", "\u041e\u041f 144 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 144 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024882", "2024882", "\u0411\u0415\u0413\u0418\u0428\u0415\u0412\u041e", "\u0411\u0415\u0413\u0418\u0428\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024956", "2024956", "\u041e\u041f 157 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 157 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024916", "2024916", "\u041d\u0418\u041a\u0410\u0428\u041d\u041e\u0412\u041a\u0410", "\u041d\u0418\u041a\u0410\u0428\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024715", "2024715", "\u041a\u0420\u0423\u0413 \u041f\u041e\u041b\u0415", "\u041a\u0420\u0423\u0413\u041b\u041e\u0415 \u041f\u041e\u041b\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024525", "2024525", "\u041d\u0410\u0411 \u0427\u0415\u041b\u041d\u042b", "\u041d\u0410\u0411\u0415\u0420\u0415\u0416\u041d\u042b\u0415 \u0427\u0415\u041b\u041d\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024553", "2024553", "\u0422\u041e\u0419\u041c\u0410", "\u0422\u041e\u0419\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024575", "2024575", "\u0412\u042b\u0413\u041b\u042f\u0414\u041e\u0412\u041a\u0410", "\u0412\u042b\u0413\u041b\u042f\u0414\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024563", "2024563", "\u041d\u0418\u0416 \u041b\u041e\u041c\u041e\u0412", "\u041d\u0418\u0416\u041d\u0418\u0419 \u041b\u041e\u041c\u041e\u0412", "\u0419", null);
            RailwayStationsDataProvider.put("2024797", "2024797", "\u0421\u041c\u042b\u0428\u041b\u042f\u0415\u0412\u041a\u0410", "\u0421\u041c\u042b\u0428\u041b\u042f\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024906", "2024906", "\u041a\u041e\u0417\u0415\u041b\u041a\u041e\u0412\u0421\u041a", "\u041a\u041e\u0417\u0415\u041b\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024888", "2024888", "\u0412\u041e\u0414\u0418\u041d\u0421\u041a\u0410\u042f", "\u0412\u041e\u0414\u0418\u041d\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2025951", "2025951", "\u0421\u0422\u0410\u0420\u041e\u0421\u0415\u041c\u0415\u0419", "\u0421\u0422\u0410\u0420\u041e\u0421\u0415\u041c\u0415\u0419\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024615", "2024615", "\u0426\u0410\u0420\u0415\u0412\u0429\u0418\u041d\u0410", "\u0426\u0410\u0420\u0415\u0412\u0429\u0418\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024909", "2024909", "\u041a\u0423\u0420\u0423\u041c\u041e\u0427", "\u041a\u0423\u0420\u0423\u041c\u041e\u0427", "\u0419", null);
            RailwayStationsDataProvider.put("2024914", "2024914", "\u041c\u0410\u0421\u0422\u0420\u042e\u041a\u041e\u0412\u041e", "\u041c\u0410\u0421\u0422\u0420\u042e\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024895", "2024895", "\u0417\u0410\u0414\u0415\u041b\u042c\u041d\u0410\u042f", "\u0417\u0410\u0414\u0415\u041b\u042c\u041d\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024920", "2024920", "\u041f\u0418\u0421\u041a\u0410\u041b\u042b", "\u041f\u0418\u0421\u041a\u0410\u041b\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2025901", "2025901", "\u041a\u0410\u041d\u0410\u041b", "\u041a\u0410\u041d\u0410\u041b", "\u0419", null);
            RailwayStationsDataProvider.put("2024786", "2024786", "\u0416\u0418\u0413\u0423\u041b \u041c\u041e\u0420\u0415", "\u0416\u0418\u0413\u0423\u041b\u0415\u0412\u0421\u041a\u041e\u0415 \u041c\u041e\u0420\u0415", "\u0419", null);
            RailwayStationsDataProvider.put("2024620", "2024620", "\u0411\u0415\u0417\u042b\u041c\u042f\u041d\u041a\u0410", "\u0411\u0415\u0417\u042b\u041c\u042f\u041d\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024798", "2024798", "\u0421\u0420\u0415\u0414\u041d\u0415\u0412\u041e\u041b\u0416", "\u0421\u0420\u0415\u0414\u041d\u0415\u0412\u041e\u041b\u0416\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024907", "2024907", "\u041a\u0420 \u0413\u041b\u0418\u041d\u041a\u0410", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f \u0413\u041b\u0418\u041d\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025955", "2025955", "\u0425\u0418\u041c\u0417\u0410\u0412\u041e\u0414\u0421\u041a", "\u0425\u0418\u041c\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024921", "2024921", "\u041f\u041e\u041b\u0415\u0412\u041e\u0419", "\u041f\u041e\u041b\u0415\u0412\u041e\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024810", "2024810", "\u0422\u041e\u041b\u042c\u042f\u0422\u0422\u0418", "\u0422\u041e\u041b\u042c\u042f\u0422\u0422\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024883", "2024883", "\u0411\u0415\u041b\u0415\u0411\u0415\u0419", "\u0411\u0415\u041b\u0415\u0411\u0415\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024722", "2024722", "\u0423\u0420\u0423\u0421\u0421\u0423", "\u0423\u0420\u0423\u0421\u0421\u0423", "\u0419", null);
            RailwayStationsDataProvider.put("2024877", "2024877", "\u0410\u041f\u0421\u0410\u041b\u042f\u041c\u041e\u0412\u041e", "\u0410\u041f\u0421\u0410\u041b\u042f\u041c\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024915", "2024915", "\u041d\u0410\u0420\u042b\u0428\u0415\u0412\u041e", "\u041d\u0410\u0420\u042b\u0428\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024687", "2024687", "\u0410\u041c\u0418\u0420\u041e\u0412\u041a\u0410", "\u0410\u041c\u0418\u0420\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025931", "2025931", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025935", "2025935", "\u041e\u041f 14 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 14 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025932", "2025932", "\u0421\u0410\u041d\u0414\u0415\u041c\u0418\u0420", "\u0421\u0410\u041d\u0414\u0415\u041c\u0418\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024803", "2024803", "\u041d\u041e\u0412\u041e\u0427\u0415\u0420\u0415\u041c\u0428", "\u041d\u041e\u0412\u041e\u0427\u0415\u0420\u0415\u041c\u0428\u0410\u041d\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024783", "2024783", "\u0411\u0418\u041a\u041b\u042f\u041d\u042c", "\u0411\u0418\u041a\u041b\u042f\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2024876", "2024876", "\u0410\u041b\u0410\u041d\u042c", "\u0410\u041b\u0410\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2024610", "2024610", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c 1", "\u0421\u042b\u0417\u0420\u0410\u041d\u042c 1", "\u0419", null);
            RailwayStationsDataProvider.put("2024927", "2024927", "\u0420\u0417\u0414 N1", "\u0420\u0410\u0417'\u0415\u0417\u0414 N1", "\u0419", null);
            RailwayStationsDataProvider.put("2024928", "2024928", "\u0420\u0417\u0414 N2", "\u0420\u0410\u0417'\u0415\u0417\u0414 N2", "\u0419", null);
            RailwayStationsDataProvider.put("2024929", "2024929", "\u0420\u0417\u0414 N3", "\u0420\u0410\u0417'\u0415\u0417\u0414 N 3", "\u0419", null);
            RailwayStationsDataProvider.put("2024919", "2024919", "\u041f\u0415\u0427 \u0411\u0415\u0420\u0415\u0413", "\u041f\u0415\u0427\u0415\u0420\u0421\u041a\u0418\u0419 \u0411\u0415\u0420\u0415\u0413", "\u0419", null);
            RailwayStationsDataProvider.put("2024918", "2024918", "\u041f\u0415\u0420\u0415\u0412\u041e\u041b\u041e\u041a\u0418", "\u041f\u0415\u0420\u0415\u0412\u041e\u041b\u041e\u041a\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2025954", "2025954", "\u0423\u0421\u041b\u0410\u0414\u0410", "\u0423\u0421\u041b\u0410\u0414\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024947", "2024947", "\u0420\u042f\u0417\u0410\u041d\u0421\u041a\u0418\u0419", "\u0420\u042f\u0417\u0410\u041d\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024950", "2024950", "\u0421\u041d\u0415\u0416\u041d \u0412\u0410\u041b\u042b", "\u0421\u041d\u0415\u0416\u041d\u042b\u0415 \u0412\u0410\u041b\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024792", "2024792", "\u041e\u0422\u0412\u0410\u0413\u0410", "\u041e\u0422\u0412\u0410\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024785", "2024785", "\u0416\u0418\u0413\u0423\u041b\u0415\u0412\u0421\u041a", "\u0416\u0418\u0413\u0423\u041b\u0415\u0412\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024829", "2024829", "\u041c\u041e\u0413\u0423\u0422\u041e\u0412\u0410\u042f", "\u041c\u041e\u0413\u0423\u0422\u041e\u0412\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024641", "2024641", "\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u041e", "\u0422\u0418\u041c\u0410\u0428\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025936", "2025936", "\u041e\u041f 13 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 13 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025937", "2025937", "\u041e\u041f 19 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 19 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025938", "2025938", "\u041e\u041f 26\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 26\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024642", "2024642", "\u0421\u0410\u0420\u0411\u0410\u0419", "\u0421\u0410\u0420\u0411\u0410\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024643", "2024643", "\u041a\u0410\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a\u0410\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025939", "2025939", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025940", "2025940", "\u041a\u041e\u041f\u042b\u0422\u041e\u0412\u041a\u0410", "\u041a\u041e\u041f\u042b\u0422\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024999", "2024999", "\u041e\u041f 72 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 72 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024644", "2024644", "\u0421\u0415\u0420 \u0412\u041e\u0414\u042b 1", "\u0421\u0415\u0420\u041d\u042b\u0415 \u0412\u041e\u0414\u042b 1", "\u0419", null);
            RailwayStationsDataProvider.put("2024645", "2024645", "\u0421\u0415\u0420 \u0412\u041e\u0414\u042b 2", "\u0421\u0415\u0420\u041d\u042b\u0415 \u0412\u041e\u0414\u042b 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024983", "2024983", "\u0428\u0423\u041c\u041e\u0412\u041a\u0410", "\u0428\u0423\u041c\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024617", "2024617", "\u041b\u0410\u0418\u0428\u0415\u0412\u041a\u0410", "\u041b\u0410\u0418\u0428\u0415\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024984", "2024984", "\u041e\u041f 188 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 188 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024621", "2024621", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421 3", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a 3", "\u0419", null);
            RailwayStationsDataProvider.put("2024665", "2024665", "\u0414\u0423\u0411\u0415\u041d\u041a\u0418", "\u0414\u0423\u0411\u0415\u041d\u041a\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024666", "2024666", "\u042e\u041b\u041e\u0412\u041a\u0410", "\u042e\u041b\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025941", "2025941", "\u041e\u041f 754 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 754 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024667", "2024667", "\u0413\u041b\u041e\u0422\u041e\u0412\u041a\u0410", "\u0413\u041b\u041e\u0422\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2025942", "2025942", "\u041e\u041f 767 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 767 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024668", "2024668", "\u0428\u0410\u0420\u041b\u041e\u0412\u041e", "\u0428\u0410\u0420\u041b\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025943", "2025943", "\u041e\u041f 777 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 777 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024891", "2024891", "\u0414\u0420\u0423\u0416\u041d\u042b\u0419", "\u0414\u0420\u0423\u0416\u041d\u042b\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024669", "2024669", "\u0412\u0415\u0428\u041a\u0410\u0419\u041c\u0410", "\u0412\u0415\u0428\u041a\u0410\u0419\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024957", "2024957", "\u0420\u0410\u0414\u041e\u0421\u0422\u041d\u042b\u0419", "\u0420\u0410\u0414\u041e\u0421\u0422\u041d\u042b\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2025944", "2025944", "\u041e\u041f 802 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 802 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025945", "2025945", "\u041e\u041f 805 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 805 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024671", "2024671", "\u0427\u0423\u0424\u0410\u0420\u041e\u0412\u041e", "\u0427\u0423\u0424\u0410\u0420\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2025946", "2025946", "\u041e\u041f 820 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 820 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024958", "2024958", "\u041e\u041f 823 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 823 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024899", "2024899", "\u041a\u0410\u041c\u0410\u041d\u0414\u0410\u041a", "\u041a\u0410\u041c\u0410\u041d\u0414\u0410\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024968", "2024968", "\u041c\u0410\u0419\u041d\u0410", "\u041c\u0410\u0419\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024959", "2024959", "\u041e\u041f 842 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 842 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024945", "2024945", "\u0420\u0417\u0414 844 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 844 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024961", "2024961", "\u041e\u041f 847 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 847 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024672", "2024672", "\u0412\u042b\u0420\u042b", "\u0412\u042b\u0420\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024946", "2024946", "\u0420\u0417\u0414 861 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 861 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024962", "2024962", "\u041e\u041f 864 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 864 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024673", "2024673", "\u041e\u0425\u041e\u0422\u041d\u0418\u0427\u042c\u042f", "\u041e\u0425\u041e\u0422\u041d\u0418\u0427\u042c\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024963", "2024963", "\u041e\u041f 875 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 875 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025947", "2025947", "\u041e\u041f 878 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 878 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024674", "2024674", "\u0410\u041d\u041d\u0415\u041d\u041a\u041e\u0412\u041e", "\u0410\u041d\u041d\u0415\u041d\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024799", "2024799", "\u0421\u0422\u0423\u0414\u0415\u041d\u0427\u0415\u0421\u041a", "\u0421\u0422\u0423\u0414\u0415\u041d\u0427\u0415\u0421\u041a\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024619", "2024619", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421 2", "\u0423\u041b\u042c\u042f\u041d\u041e\u0412\u0421\u041a 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024894", "2024894", "\u0417\u0410\u0412\u041e\u041b\u0416\u0421\u041a\u0418\u0419", "\u0417\u0410\u0412\u041e\u041b\u0416\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024675", "2024675", "\u0412\u0415\u0420\u0425\u041d \u0422\u0415\u0420", "\u0412\u0415\u0420\u0425\u041d\u042f\u042f \u0422\u0415\u0420\u0420\u0410\u0421\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024676", "2024676", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0421\u041e\u0412\u0425\u041e\u0417\u041d\u042b\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024677", "2024677", "\u0427\u0415\u0420\u0414\u0410\u041a\u041b\u042b", "\u0427\u0415\u0420\u0414\u0410\u041a\u041b\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2025948", "2025948", "\u041e\u041f 939\u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 939\u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025953", "2025953", "\u0423\u0420\u0415\u041d\u0411\u0410\u0428", "\u0423\u0420\u0415\u041d\u0411\u0410\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024678", "2024678", "\u041f\u0423\u0422\u0415\u0412\u041e\u0419", "\u041f\u0423\u0422\u0415\u0412\u041e\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024679", "2024679", "\u0411\u0420\u042f\u041d\u0414\u0418\u041d\u041e", "\u0411\u0420\u042f\u041d\u0414\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024681", "2024681", "\u0422\u0418\u0418\u041d\u0421\u041a", "\u0422\u0418\u0418\u041d\u0421\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024682", "2024682", "\u0420\u0410\u0421\u0421\u0412\u0415\u0422", "\u0420\u0410\u0421\u0421\u0412\u0415\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024683", "2024683", "\u0414\u0418\u041c\u0418\u0422\u0420\u041e\u0412\u0413\u0420", "\u0414\u0418\u041c\u0418\u0422\u0420\u041e\u0412\u0413\u0420\u0410\u0414", "\u0419", null);
            RailwayStationsDataProvider.put("2025949", "2025949", "\u041e\u041f 989 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 989 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024684", "2024684", "\u041e\u0411\u0410\u041c\u0417\u0410", "\u041e\u0411\u0410\u041c\u0417\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024685", "2024685", "\u041c\u0410\u041b\u042b\u041a\u041b\u0410", "\u041c\u0410\u041b\u042b\u041a\u041b\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024686", "2024686", "\u042f\u041a\u0423\u0428\u041a\u0410", "\u042f\u041a\u0423\u0428\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024688", "2024688", "\u041a\u0410\u0420\u041c\u0410\u041b\u0410", "\u041a\u0410\u0420\u041c\u0410\u041b\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024710", "2024710", "\u041f\u041e\u0413\u0420\u0423\u0417\u041d\u0410\u042f", "\u041f\u041e\u0413\u0420\u0423\u0417\u041d\u0410\u042f", "\u0419", null);
            RailwayStationsDataProvider.put("2024689", "2024689", "\u0420\u041e\u0417\u041e\u0412\u041a\u0410", "\u0420\u041e\u0417\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024691", "2024691", "\u0410\u0425\u041c\u0415\u0422\u042c\u0415\u0412\u041e", "\u0410\u0425\u041c\u0415\u0422\u042c\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024720", "2024720", "\u041d\u0423\u0420\u041b\u0410\u0422", "\u041d\u0423\u0420\u041b\u0410\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024692", "2024692", "\u041a\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u041a\u041b\u0418\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024693", "2024693", "\u0427\u0415\u041b\u041d\u0410", "\u0427\u0415\u041b\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024694", "2024694", "\u0421\u041e\u0421\u041d\u0410", "\u0421\u041e\u0421\u041d\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024695", "2024695", "\u041a\u041e\u041d\u0414\u0423\u0420\u0427\u0418", "\u041a\u041e\u041d\u0414\u0423\u0420\u0427\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024730", "2024730", "\u0428\u0415\u041d\u0422\u0410\u041b\u0410", "\u0428\u0415\u041d\u0422\u0410\u041b\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024696", "2024696", "\u0411\u0410\u041b\u0410\u041d\u0414\u0410\u0415\u0412\u041e", "\u0411\u0410\u041b\u0410\u041d\u0414\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024697", "2024697", "\u0414\u0415\u041d\u0418\u0421\u041a\u0418\u041d\u041e", "\u0414\u0415\u041d\u0418\u0421\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024778", "2024778", "\u0410\u0411\u0414\u0418\u041a\u0415\u0415\u0412\u041e", "\u0410\u0411\u0414\u0418\u041a\u0415\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024698", "2024698", "\u0428\u0410\u041b\u0410\u0428\u041d\u0418\u041a", "\u0428\u0410\u041b\u0410\u0428\u041d\u0418\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024699", "2024699", "\u041f\u0420\u041e\u041d\u0418\u041d\u041e", "\u041f\u0420\u041e\u041d\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024880", "2024880", "\u0411\u0410\u0420\u041a\u041e\u0412\u041e", "\u0411\u0410\u0420\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024701", "2024701", "\u041a\u041b\u042f\u0412\u041b\u0418\u041d\u041e", "\u041a\u041b\u042f\u0412\u041b\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024702", "2024702", "\u041d\u041e\u0412 \u041a\u0410\u0417\u0411\u0423\u041b", "\u041d\u041e\u0412\u042b\u0419 \u041a\u0410\u0417\u0411\u0423\u041b\u0410\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024703", "2024703", "\u041c\u0410\u041a\u041b\u0410\u0423\u0428", "\u041c\u0410\u041a\u041b\u0410\u0423\u0428", "\u0419", null);
            RailwayStationsDataProvider.put("2024704", "2024704", "\u0427\u0415\u0421\u0422\u0410\u041a\u041e\u0412\u041a\u0410", "\u0427\u0415\u0421\u0422\u0410\u041a\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024705", "2024705", "\u0414\u042b\u041c\u041a\u0410", "\u0414\u042b\u041c\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024706", "2024706", "\u041f\u041e\u041b\u0422\u0410\u0412\u041a\u0410", "\u041f\u041e\u041b\u0422\u0410\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024716", "2024716", "\u0411\u0410\u0417\u0410\u0420\u041e\u0412\u041a\u0410", "\u0411\u0410\u0417\u0410\u0420\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024740", "2024740", "\u0411\u0423\u0413\u0423\u041b\u042c\u041c\u0410", "\u0411\u0423\u0413\u0423\u041b\u042c\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024892", "2024892", "\u0415\u0424\u0410\u041d\u041e\u0412\u041a\u0410", "\u0415\u0424\u0410\u041d\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024717", "2024717", "\u0417\u0410\u0419", "\u0417\u0410\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024718", "2024718", "\u0410\u0420\u0413\u0423\u041d\u041e\u0412\u0421\u041a\u0418", "\u0410\u0420\u0413\u0423\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0419", null);
            RailwayStationsDataProvider.put("2024719", "2024719", "\u0411\u0410\u0419\u0420\u042f\u041a\u0418\u041d\u041e", "\u0411\u0410\u0419\u0420\u042f\u041a\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024903", "2024903", "\u041a\u0410\u0420\u0410\u041a\u0410\u0428\u041b\u042b", "\u041a\u0410\u0420\u0410\u041a\u0410\u0428\u041b\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024721", "2024721", "\u042e\u0422\u0410\u0417\u0410", "\u042e\u0422\u0410\u0417\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024723", "2024723", "\u0418\u0421\u041c\u0415\u0422\u041e\u0412\u041e", "\u0418\u0421\u041c\u0415\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024724", "2024724", "\u0418\u041b\u042c\u0427\u0415\u041d\u0411\u0415\u0422", "\u0418\u041b\u042c\u0427\u0415\u041d\u0411\u0415\u0422", "\u0419", null);
            RailwayStationsDataProvider.put("2024750", "2024750", "\u0422\u0423\u0419\u041c\u0410\u0417\u042b", "\u0422\u0423\u0419\u041c\u0410\u0417\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024725", "2024725", "\u0423\u0421\u0415\u041d\u042c", "\u0423\u0421\u0415\u041d\u042c", "\u0419", null);
            RailwayStationsDataProvider.put("2024726", "2024726", "\u0411\u0418\u041a\u041c\u0415\u0422\u041e\u0412\u041e", "\u0411\u0418\u041a\u041c\u0415\u0422\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024727", "2024727", "\u041a\u0410\u041d\u0414\u0420\u042b", "\u041a\u0410\u041d\u0414\u0420\u042b", "\u0419", null);
            RailwayStationsDataProvider.put("2024728", "2024728", "\u041a\u0410\u0420\u0410\u041d \u0415\u041b\u0413\u0410", "\u041a\u0410\u0420\u0410\u041d-\u0415\u041b\u0413\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024729", "2024729", "\u0423\u0421\u0422\u042e\u0411\u0410", "\u0423\u0421\u0422\u042e\u0411\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024731", "2024731", "\u0411\u0423\u0417\u0414\u042f\u041a", "\u0411\u0423\u0417\u0414\u042f\u041a", "\u0419", null);
            RailwayStationsDataProvider.put("2024732", "2024732", "\u0413\u0410\u0424\u0423\u0420\u0418", "\u0413\u0410\u0424\u0423\u0420\u0418", "\u0419", null);
            RailwayStationsDataProvider.put("2024733", "2024733", "\u0427\u0415\u0420\u0415\u041c\u0428\u0410\u041d", "\u0427\u0415\u0420\u0415\u041c\u0428\u0410\u041d", "\u0419", null);
            RailwayStationsDataProvider.put("2024734", "2024734", "\u0411\u041b\u0410\u0413\u041e\u0412\u0410\u0420", "\u0411\u041b\u0410\u0413\u041e\u0412\u0410\u0420", "\u0419", null);
            RailwayStationsDataProvider.put("2024735", "2024735", "\u042f\u041c\u0411\u0410\u0425\u0422\u0410", "\u042f\u041c\u0411\u0410\u0425\u0422\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024736", "2024736", "\u0421\u0410\u0424\u0410\u0420\u041e\u0412\u041e", "\u0421\u0410\u0424\u0410\u0420\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024737", "2024737", "\u0427\u0418\u0428\u041c\u042b 2", "\u0427\u0418\u0428\u041c\u042b 2", "\u0419", null);
            RailwayStationsDataProvider.put("2024567", "2024567", "\u0412\u0415\u0420\u041d\u0410\u0414\u041e\u0412\u041a\u0410", "\u0412\u0415\u0420\u041d\u0410\u0414\u041e\u0412\u041a\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024825", "2024825", "\u041e\u041f 120 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 120 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2025950", "2025950", "\u041e\u041f 114 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 114 \u041a\u041c", "\u0419", null);
            RailwayStationsDataProvider.put("2024568", "2024568", "\u0417\u0415\u041c\u0415\u0422\u0427\u0418\u041d\u041e", "\u0417\u0415\u041c\u0415\u0422\u0427\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024569", "2024569", "\u041e\u0422\u041e\u0420\u041c\u0410", "\u041e\u0422\u041e\u0420\u041c\u0410", "\u0419", null);
            RailwayStationsDataProvider.put("2024210", "2024210", "\u041f\u0410\u0428\u041a\u041e\u0412\u041e", "\u041f\u0410\u0428\u041a\u041e\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024551", "2024551", "\u0415\u0413\u041e\u041b\u0414\u0410\u0415\u0412\u041e", "\u0415\u0413\u041e\u041b\u0414\u0410\u0415\u0412\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024552", "2024552", "\u041a\u0415\u041d\u0417\u0418\u041d\u041e", "\u041a\u0415\u041d\u0417\u0418\u041d\u041e", "\u0419", null);
            RailwayStationsDataProvider.put("2024554", "2024554", "\u0421\u0423\u0425\u0410\u0420\u0415\u0412\u041e", "\u0421\u0423\u0425\u0410\u0420\u0415\u0412\u041e", "\u0419", null);
        }
    }

    private static final class RailwayStationInitializer07 {
        private RailwayStationInitializer07() {
        }

        /*
         * Opcode count of 17502 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
         */
        public static void init() {
            RailwayStationsDataProvider.put("2208302", "2208302", "\u0424\u0420\u0418\u041a\u0410\u0426\u0415\u0419", "\u0424\u0420\u0418\u041a\u0410\u0426\u0415\u0419", "\u0428", null);
            RailwayStationsDataProvider.put("2210034", "2210034", "\u041f\u041b\u0410\u0412\u041d\u0418 \u0413\u0420", "\u041f\u041b\u0410\u0412\u041d\u0418 \u0413\u0420\u0423\u0417\u041e\u0412\u042b\u0415", "\u041f", null);
            RailwayStationsDataProvider.put("2210032", "2210032", "\u041e\u041f 1143 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1143 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210033", "2210033", "\u041e\u041f 1146 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1146 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210038", "2210038", "\u041e\u041f 1452 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1452 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210039", "2210039", "\u041e\u041f 1457 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1457 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210040", "2210040", "\u041e\u041f 1473 \u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 1473 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210041", "2210041", "\u041e\u041f 1509 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1509 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210042", "2210042", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210043", "2210043", "\u041e\u041f 26 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 26 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210045", "2210045", "\u0422\u0415\u0425\u041d\u0418\u041a\u0423\u041c", "\u0422\u0415\u0425\u041d\u0418\u041a\u0423\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210029", "2210029", "\u041e\u041f 235 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 235 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210028", "2210028", "\u041e\u041f 132 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 132 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210027", "2210027", "\u041e\u041f 109 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 109 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210026", "2210026", "\u041e\u041f 73 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 73 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210736", "2210736", "\u0427\u0418\u0421\u0422\u041e\u041f\u041e\u041b\u042c\u0415", "\u0427\u0418\u0421\u0422\u041e\u041f\u041e\u041b\u042c\u0415", "\u041f", null);
            RailwayStationsDataProvider.put("2210705", "2210705", "\u041a\u0418\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u041a\u0418\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("2210035", "2210035", "\u041e\u041f 4 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210036", "2210036", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210037", "2210037", "\u041e\u041f 19 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 19 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210969", "2210969", "\u0411\u0410\u041b\u041e\u0412\u041a\u0410", "\u0411\u0410\u041b\u041e\u0412\u041a\u0410", "\u041f", null);
            RailwayStationsDataProvider.put("2210031", "2210031", "\u041e\u041f 50 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 50 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210030", "2210030", "\u041e\u041f 52 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 52 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2214208", "2214208", "\u041a\u0420 \u041c\u041e\u0413\u0418\u041b\u0410", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f \u041c\u041e\u0413\u0418\u041b\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2038470", "2038470", "\u041a\u0418\u041b\u042c\u0427\u0423\u0413", "\u041a\u0418\u041b\u042c\u0427\u0423\u0413", "\u042b", null);
            RailwayStationsDataProvider.put("8040260", "8040260", "\u0414\u042e\u0421\u0421\u0415\u041b\u042c\u0414\u041e\u0420", "\u0414\u042e\u0421\u0421\u0415\u041b\u042c\u0414\u041e\u0420\u0424", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5453693", "5453693", "\u0417\u0410\u041c\u0420\u0421\u041a", "\u0417\u0410\u041c\u0420\u0421\u041a", "V", null);
            RailwayStationsDataProvider.put("5453843", "5453843", "\u0411\u0420\u0410\u041d\u0414 \u041d \u041e\u0420", "\u0411\u0420\u0410\u041d\u0414\u0423\u0421 \u041d\u0410\u0414 \u041e\u0420\u041b\u0418", "V", null);
            RailwayStationsDataProvider.put("2210770", "2210770", "\u0415\u0412\u041f\u0410\u0422 \u041a\u0423\u0420", "\u0415\u0412\u041f\u0410\u0422\u041e\u0420\u0418\u042f-\u041a\u0423\u0420\u041e\u0420\u0422", "\u041f", null);
            RailwayStationsDataProvider.put("2204019", "2204019", "\u041e\u041f 29 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 29 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204020", "2204020", "\u041e\u041f 24 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 24 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2208487", "2208487", "\u0428\u0410\u0411\u041e", "\u0428\u0410\u0411\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208486", "2208486", "\u0411\u0423\u0413\u0410\u0417", "\u0411\u0423\u0413\u0410\u0417", "\u0428", null);
            RailwayStationsDataProvider.put("2000479", "2000479", "\u041a\u0410\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a\u0410\u0417\u0410\u041d\u041e\u0412\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000960", "2000960", "\u0412\u0415\u0416\u0415\u041d\u041a\u0410", "\u0412\u0415\u0416\u0415\u041d\u041a\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2100467", "2100467", "\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a", "\u0414\u0417\u0415\u0420\u0416\u0418\u041d\u0421\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2010826", "2010826", "\u0426\u0418\u0411\u0418\u0420\u0418\u041d\u041e", "\u0426\u0418\u0411\u0418\u0420\u0418\u041d\u041e", "\u042f", null);
            RailwayStationsDataProvider.put("2209352", "2209352", "\u041e\u0420\u0416\u0418\u0426\u0410", "\u041e\u0420\u0416\u0418\u0426\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208478", "2208478", "\u041e\u0414\u0415\u0421\u0421\u0410 \u0421\u041e\u0420", "\u041e\u0414\u0415\u0421\u0421\u0410-\u0421\u041e\u0420\u0422\u0418\u0420\u041e\u0412\u041e\u0427\u041d\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("5111136", "5111136", "\u0412\u0410\u0420\u0428\u0410\u0412 \u0411\u0410\u0421", "\u0412\u0410\u0420\u0428\u0410\u0412\u0410 \u0411\u0410\u0421", "W", null);
            RailwayStationsDataProvider.put("2000553", "2000553", "\u041e\u041f 298 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 298 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000098", "2000098", "\u0420\u0417\u0414 422 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 422 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2200089", "2200089", "\u0421\u041f\u0410\u0420\u0422\u0410\u041a", "\u0421\u041f\u0410\u0420\u0422\u0410\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200783", "2200783", "\u0428\u0410\u0422\u0420\u0418\u0429\u0415", "\u0428\u0410\u0422\u0420\u0418\u0429\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2204030", "2204030", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204031", "2204031", "\u0413\u0420\u0418\u0428\u041a\u0418", "\u0413\u0420\u0418\u0428\u041a\u0418", "\u042e", null);
            RailwayStationsDataProvider.put("2204022", "2204022", "\u041e\u041f 160 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 160 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204023", "2204023", "\u0421\u0410\u0414\u042b-6", "\u0421\u0410\u0414\u042b-6", "\u042e", null);
            RailwayStationsDataProvider.put("2204024", "2204024", "\u0421\u0410\u0414\u042b-5", "\u0421\u0410\u0414\u042b-5", "\u042e", null);
            RailwayStationsDataProvider.put("2204025", "2204025", "\u0421\u0410\u0414\u042b-4", "\u0421\u0410\u0414\u042b-4", "\u042e", null);
            RailwayStationsDataProvider.put("2204026", "2204026", "\u0421\u0410\u0414\u042b-3", "\u0421\u0410\u0414\u042b-3", "\u042e", null);
            RailwayStationsDataProvider.put("2204027", "2204027", "\u0421\u0410\u0414\u042b-1", "\u0421\u0410\u0414\u042b-1", "\u042e", null);
            RailwayStationsDataProvider.put("2204028", "2204028", "\u0421\u041e\"\u0414\u041d\u0418\u041f\u0420\u041e\"", "\u0421\u0410\u0414.\u041e\u0411\u0429\u0415\u0421\u0422\u0412\u041e\"\u0414\u041d\u0418\u041f\u0420\u041e\"", "\u042e", null);
            RailwayStationsDataProvider.put("2204029", "2204029", "\u0410\u0412\u0422\u041e\u0421\u0422\u041d\u0410\u041d\u0426", "\u0410\u0412\u0422\u041e\u0421\u0422\u0410\u041d\u0426\u0418\u042f", "\u042e", null);
            RailwayStationsDataProvider.put("2210044", "2210044", "\u0410\u041c\u0415\u0422\u0425-\u0421\u0423\u041b\u0422", "\u0410\u041c\u0415\u0422\u0425\u0410\u041d-\u0421\u0423\u041b\u0422\u0410\u041d", "\u041f", null);
            RailwayStationsDataProvider.put("2214175", "2214175", "\u0413\u041b\u0410\u0424\u0418\u0420\u041e\u0412\u041a\u0410", "\u0413\u041b\u0410\u0424\u0418\u0420\u041e\u0412\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2214205", "2214205", "\u041a\u0410\u0420\u0422\u0423\u0428\u0418\u041d\u041e", "\u041a\u0410\u0420\u0422\u0423\u0428\u0418\u041d\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("2214277", "2214277", "\u041e\u041f 412 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 412 \u041a\u041c", "\u0414", null);
            RailwayStationsDataProvider.put("2214284", "2214284", "\u041e\u041f 394 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 394 \u041a\u041c", "\u0414", null);
            RailwayStationsDataProvider.put("2214285", "2214285", "\u041e\u041f 375 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 375 \u041a\u041c", "\u0414", null);
            RailwayStationsDataProvider.put("2214286", "2214286", "\u041e\u041f 357 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 357 \u041a\u041c", "\u0414", null);
            RailwayStationsDataProvider.put("2214219", "2214219", "\u0420\u042f\u0421\u041d\u041e\u0415", "\u0420\u042f\u0421\u041d\u041e\u0415", "\u0414", null);
            RailwayStationsDataProvider.put("2214217", "2214217", "\u041b\u0418\u0412\u0415\u041d\u041a\u0410", "\u041b\u0418\u0412\u0415\u041d\u041a\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2707700", "2707700", "\u0410\u0421\u0422\u0410\u041d\u0410-\u0410\u0422\u0410", "\u0410\u0421\u0422\u0410\u041d\u0410-\u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707702", "2707702", "\u0421\u0410\u0420\u042b\u041e\u0411\u0410\u0410\u0422\u0410", "\u0421\u0410\u0420\u042b-\u041e\u0411\u0410-\u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707703", "2707703", "\u0418\u0420\u0427\u0415\u041d\u041a\u041e\u0410\u0422\u0410", "\u0418\u0420\u0427\u0415\u041d\u041a\u041e-\u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707706", "2707706", "\u0410\u041d\u0410\u0420 \u0410\u0422\u0410", "\u0410\u041d\u0410\u0420 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707707", "2707707", "\u0411\u0410\u0411\u0410\u0422\u0410\u0419\u0410\u0422\u0410", "\u0411\u0410\u0411\u0410\u0422\u0410\u0419 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707708", "2707708", "\u0412\u0418\u0428\u041d\u0415\u0412\u041a\u0410\u0422\u0410", "\u0412\u0418\u0428\u041d\u0415\u0412\u041a\u0410 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707709", "2707709", "\u0415\u0420\u041a\u0415\u041d\u0428\u0418\u0410\u0422\u0410", "\u0415\u0420\u041a\u0415\u041d\u0428\u0418\u041b \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707710", "2707710", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420\u0410\u0422\u0410", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707711", "2707711", "\u0415\u0420\u041c\u0415\u041d\u0422\u0410\u0410\u0422\u0410", "\u0415\u0420\u041c\u0415\u041d\u0422\u0410\u0423 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707712", "2707712", "\u0416\u0410\u041a\u0421\u042b \u0410\u0422\u0410", "\u0416\u0410\u041a\u0421\u042b \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707714", "2707714", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420\u0410\u0422\u0410", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420 \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707715", "2707715", "\u0415\u0421\u0418\u041b\u042c \u0410\u0422\u0410", "\u0415\u0421\u0418\u041b\u042c \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2707753", "2707753", "\u041a\u0410\u0420\u0421\u0411\u0410\u0425\u0416", "\u041a\u0410\u0420 \u0421 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707755", "2707755", "\u0428\u041e\u041a\u0410\u0419\u0411\u0410\u0425\u0416", "\u0428\u041e\u041a\u0410\u0419 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707761", "2707761", "\u041e\u0421\u0410\u041a\u0410\u0420\u0411\u0410\u0425\u0416", "\u041e\u0421\u0410\u041a\u0410\u0420 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707764", "2707764", "\u041c\u042b\u0420\u0417\u0410\u0411\u0410\u0425\u0416", "\u041c\u042b\u0420\u0417\u0410 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707765", "2707765", "\u041d\u0423\u0420\u0410\u0411\u0410\u0425\u0416", "\u041d\u0423\u0420\u0410 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707770", "2707770", "\u0410\u041a\u0422\u0410\u0421\u0422\u0411\u0410\u0425\u0416", "\u0410\u041a\u0422\u0410\u0421\u0422 \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707772", "2707772", "\u041a\u041e\u041a\u041f\u0415\u041a\u0411\u0410\u0425\u0416", "\u041a\u041e\u041a\u041f\u0415\u041a \u0411\u0410\u0425 \u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707780", "2707780", "\u0428\u0418\u0414\u0415\u0420\u0428\u0415\u041b\u041a\u041f", "\u0428\u0418\u0414\u0415\u0420 \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2707781", "2707781", "\u041a\u0410\u041b\u041a\u0428\u0415\u041b\u041a\u041f", "\u041a\u0410\u041b\u041a \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2707783", "2707783", "\u0416\u041e\u041b\u041a\u0428\u0415\u041b\u041a\u041f", "\u0416\u041e\u041b\u041a \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2707787", "2707787", "\u0411\u041e\u0417\u0428\u0428\u0415\u041b\u041a\u041f", "\u0411\u041e\u0417\u0428 \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2707788", "2707788", "\u0423\u041b\u0415\u041d\u0428\u0415\u041b\u041a\u041f", "\u0423\u041b\u0415\u041d \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2707789", "2707789", "\u0415\u041a\u0418\u0411\u0428\u0415\u041b\u041a\u041f", "\u0415\u041a\u0418\u0411 \u0428\u0415\u041b\u041a \u041f", "\u0426", null);
            RailwayStationsDataProvider.put("2709771", "2709771", "\u0418\u041b\u0415\u0426\u041a \u0410\u0422\u0410", "\u0418\u041b\u0415\u0426\u041a \u0410\u0422\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2709848", "2709848", "\u041a\u0410\u0420\u0413\u0411\u0410\u0425\u042b\u0422\u0416", "\u041a\u0410\u0420\u0413\u0411\u0410\u0425\u042b\u0422\u0416\u041e\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("2040432", "2040432", "\u0421\u042b\u0420\u041e\u0421\u0422\u0410\u041d", "\u0421\u042b\u0420\u041e\u0421\u0422\u0410\u041d", "\u0423", null);
            RailwayStationsDataProvider.put("2709960", "2709960", "\u0415\u0420\u041a\u0415\u041d\u0428\u0418\u041b\u0418\u041a", "\u0415\u0420\u041a\u0415\u041d\u0428\u0418\u041b\u0418\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2708851", "2708851", "\u041d\u041e\u0412\u041e\u0418\u0428\u0418\u041c\u0421\u041a", "\u041d\u041e\u0412\u041e\u0418\u0428\u0418\u041c\u0421\u041a\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("2704845", "2704845", "\u0410\u041b\u0413\u0410", "\u0410\u041b\u0413\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("2704859", "2704859", "\u0411\u0418\u0420\u0428\u041e\u0413\u042b\u0420", "\u0411\u0418\u0420\u0428\u041e\u0413\u042b\u0420", "\u0426", null);
            RailwayStationsDataProvider.put("2704990", "2704990", "\u0414\u0416\u0423\u0421\u0410\u041b\u042b", "\u0414\u0416\u0423\u0421\u0410\u041b\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2700872", "2700872", "\u041c\u0410\u041d\u041a\u0415\u041d\u0422", "\u041c\u0410\u041d\u041a\u0415\u041d\u0422", "\u0426", null);
            RailwayStationsDataProvider.put("2704791", "2704791", "\u0413\u0410\u041d\u042e\u0428\u041a\u0418\u041d\u041e", "\u0413\u0410\u041d\u042e\u0428\u041a\u0418\u041d\u041e", "\u0426", null);
            RailwayStationsDataProvider.put("2700701", "2700701", "\u0410\u0423\u041b", "\u0410\u0423\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("2700755", "2700755", "\u0411\u0415\u0421\u041a\u041e\u041b\u042c", "\u0411\u0415\u0421\u041a\u041e\u041b\u042c", "\u0426", null);
            RailwayStationsDataProvider.put("2000795", "2000795", "\u0416\u0415\u0427\u0410", "\u0416\u0415\u0427\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2200382", "2200382", "\u0416\u0423\u041a\u041e\u0412\u041a\u0410", "\u0416\u0423\u041a\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200384", "2200384", "\u0414\u0410\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u0414\u0410\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200383", "2200383", "\u0417\u0410\u0421\u0423\u041f\u041e\u0415\u0412\u041a\u0410", "\u0417\u0410\u0421\u0423\u041f\u041e\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200381", "2200381", "\u0421\u0410\u0414\u042b", "\u0421\u0410\u0414\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200380", "2200380", "\u041a\u041e\u0412\u0415\u041b \u041f\u0410\u0420\u041a", "\u041a\u041e\u0412\u0415\u041b\u042c\u0421\u041a\u0418\u0419 \u041f\u0410\u0420\u041a", "\u041a", null);
            RailwayStationsDataProvider.put("2200379", "2200379", "\u041d\u0410\u041b\u0418\u0412\u041d\u0410\u042f", "\u041d\u0410\u041b\u0418\u0412\u041d\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2200362", "2200362", "\u0412\u041e\u041b\u041e\u0421\u0421\u041a\u041e\u0415", "\u0412\u041e\u041b\u041e\u0421\u0421\u041a\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200363", "2200363", "\u041a\u041e\u041f\u042b\u0421\u0422\u0418\u041d", "\u041a\u041e\u041f\u042b\u0421\u0422\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200364", "2200364", "\u0412\u0418\u0428\u041d\u0415\u0412 \u0421\u0410\u0414", "\u0412\u0418\u0428\u041d\u0415\u0412\u042b\u0419 \u0421\u0410\u0414", "\u041a", null);
            RailwayStationsDataProvider.put("2200365", "2200365", "\u0411\u0410\u0413\u041b\u0410\u0418", "\u0411\u0410\u0413\u041b\u0410\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200378", "2200378", "\u0417\u0410\u041b\u0415\u0421\u042c\u0415", "\u0417\u0410\u041b\u0415\u0421\u042c\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200377", "2200377", "\u0417\u0410\u041c\u0427\u0418\u041a\u0418", "\u0417\u0410\u041c\u0427\u0418\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200376", "2200376", "\u041a\u0423\u0417\u042c\u041c\u0418\u041d", "\u041a\u0423\u0417\u042c\u041c\u0418\u041d", "\u041a", null);
            RailwayStationsDataProvider.put("2200375", "2200375", "\u0417\u0410\u0420\u0423\u0414\u042c\u0415", "\u0417\u0410\u0420\u0423\u0414\u042c\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200366", "2200366", "\u0420\u041e\u0421\u0421\u041e\u0428\u0410", "\u0420\u041e\u0421\u0421\u041e\u0428\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200367", "2200367", "\u0428\u0415\u0412\u0427\u0415\u041d\u041a\u041e", "\u0428\u0415\u0412\u0427\u0415\u041d\u041a\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200368", "2200368", "\u0421\u0410\u0425\u041a\u0410\u041c\u0415\u041d\u042c", "\u0421\u0410\u0425\u041a\u0410\u041c\u0415\u041d\u042c", "\u041a", null);
            RailwayStationsDataProvider.put("2200369", "2200369", "\u041a\u0423\u0422\u041a\u041e\u0412\u0426\u042b", "\u041a\u0423\u0422\u041a\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200370", "2200370", "\u041e\u041b\u042c\u0425\u041e\u0412\u0426\u042b", "\u041e\u041b\u042c\u0425\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200374", "2200374", "\u041c\u041e\u041a\u0418\u0415\u0412\u0426\u042b", "\u041c\u041e\u041a\u0418\u0415\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200373", "2200373", "\u0421\u0422 \u0411\u0415\u0419\u0417\u0418\u041c\u042b", "\u0421\u0422\u0410\u0420\u042b\u0415 \u0411\u0415\u0419\u0417\u0418\u041c\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200372", "2200372", "\u0412\u0415\u041b \u042e\u041d\u0410\u0427\u041a\u0418", "\u0412\u0415\u041b\u0418\u041a\u0418\u0415 \u042e\u041d\u0410\u0427\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200371", "2200371", "\u0420\u041e\u0421\u041e\u041b\u041e\u0412\u0426\u042b", "\u0420\u041e\u0421\u041e\u041b\u041e\u0412\u0426\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2020329", "2020329", "\u0420\u0417\u0414 N4", "\u0420\u0410\u0417'\u0415\u0417\u0414 N4", "\u0416", null);
            RailwayStationsDataProvider.put("2411001", "2411001", "\u0412\u0418\u041b\u042c\u041d \u0411\u0410\u0421", "\u0412\u0418\u041b\u042c\u041d\u042e\u0421 \u0411\u0410\u0421", "L", null);
            RailwayStationsDataProvider.put("3000750", "3000750", "\u041f\u0425\u0415\u041d\u042c\u0421\u041e\u041d", "\u041f\u0425\u0415\u041d\u042c\u0421\u041e\u041d", "5", "\u041a\u043e\u0440\u0435\u044f");
            RailwayStationsDataProvider.put("2600199", "2600199", "\u0422\u0410\u0411\u0418\u0412\u0415\u0420\u0415", "\u0422\u0410\u0411\u0418\u0412\u0415\u0420\u0415", "S", null);
            RailwayStationsDataProvider.put("2100924", "2100924", "\u0422\u041e\u0412\u0410\u0420.\u0414\u0412\u041e\u0420", "\u0422\u041e\u0412\u0410\u0420\u041d\u042b\u0419 \u0414\u0412\u041e\u0420", "\u0411", null);
            RailwayStationsDataProvider.put("2100916", "2100916", "\u041c\u0415\u041d\u042e\u0422\u0415\u0412\u041e", "\u041c\u0415\u041d\u042e\u0422\u0415\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2000214", "2000214", "\u0422\u0415\u041f\u041b\u041e\u0415", "\u0422\u0415\u041f\u041b\u041e\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2208506", "2208506", "\u0413\u041e\u0420\u041e\u0416\u0410\u041d\u042b", "\u0413\u041e\u0420\u041e\u0416\u0410\u041d\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2214014", "2214014", "\u0423\u0414\u0410\u0427\u041d\u0410\u042f", "\u0423\u0414\u0410\u0427\u041d\u0410\u042f", "\u0414", null);
            RailwayStationsDataProvider.put("2064380", "2064380", "\u0418\u0417\u0412\u0415\u0421\u0422\u0418\u042f", "\u0418\u0417\u0412\u0415\u0421\u0422\u0418\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064381", "2064381", "\u041a\u0423\u0414\u0415\u041f\u0421\u0422\u0410", "\u041a\u0423\u0414\u0415\u041f\u0421\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064382", "2064382", "\u0410\u0425\u0423\u041d", "\u0410\u0425\u0423\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064383", "2064383", "\u0421\u0422\u0410\u0414\u0418\u041e\u041d", "\u0421\u0422\u0410\u0414\u0418\u041e\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064384", "2064384", "\u041c\u0410\u041a\u041e\u041f\u0421\u0415", "\u041c\u0410\u041a\u041e\u041f\u0421\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064385", "2064385", "\u0422\u0423\u0410\u041f\u0421\u0415-\u0421\u041e\u0420", "\u0422\u0423\u0410\u041f\u0421\u0415-\u0421\u041e\u0420\u0422\u0418\u0420\u041e\u0412\u041e\u0427\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064386", "2064386", "\u041a\u0418\u0420\u041f\u0418\u0427\u041d\u041e\u0415", "\u041a\u0418\u0420\u041f\u0418\u0427\u041d\u041e\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064387", "2064387", "\u041e\u041f 1771 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1771 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064388", "2064388", "\u041e\u041f 1676 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1676 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064389", "2064389", "\u041e\u041f 1655 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1655 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064390", "2064390", "\u041f\u0420\u041e\u0427\u041d\u041e\u041e\u041a\u041e\u041f", "\u041f\u0420\u041e\u0427\u041d\u041e\u041e\u041a\u041e\u041f\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064391", "2064391", "\u041e\u041f 1627 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1627 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064392", "2064392", "\u041a\u041e\u0426\u0415\u0411\u0423", "\u041a\u041e\u0426\u0415\u0411\u0423", "\u0421", null);
            RailwayStationsDataProvider.put("2064393", "2064393", "\u041e\u041f 1621 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1621 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064394", "2064394", "\u041e\u041f 1612 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1612 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064395", "2064395", "\u0414\u041e\u0420\u041e\u0416\u041a\u041e\u0412", "\u0414\u041e\u0420\u041e\u0416\u041a\u041e\u0412", "\u0421", null);
            RailwayStationsDataProvider.put("2064396", "2064396", "\u041e\u041f 1605 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1605 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064397", "2064397", "\u0420\u041e\u0413\u0410\u0427\u0415\u0412\u0421\u041a", "\u0420\u041e\u0413\u0410\u0427\u0415\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064398", "2064398", "\u041e\u041f 1576 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1576 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064399", "2064399", "\u041e\u041f 1571 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1571 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064451", "2064451", "\u041e\u041f 1561 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1561 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064452", "2064452", "\u0411\u0415\u041a\u0415\u0428\u0415\u0412\u0421\u041a", "\u0411\u0415\u041a\u0415\u0428\u0415\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064453", "2064453", "\u041e\u041f 1543 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1543 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064455", "2064455", "\u041e\u041f 1540 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1540 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064456", "2064456", "\u041e\u041f 1537 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1537 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064457", "2064457", "\u041e\u041f 1532 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1532 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064458", "2064458", "\u041e\u041f 1531 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1531 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064459", "2064459", "\u041e\u041f 1528 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1528 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064460", "2064460", "\u041f 1522 \u041a\u041c", "\u041f\u041e\u0421\u0422 1522 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064461", "2064461", "\u041e\u041f 1519 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1519 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064462", "2064462", "\u041e\u041f 1517 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1517 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064463", "2064463", "\u041e\u041f 1511 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1511 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064464", "2064464", "\u041e\u041f 1507 \u041a\u041c", "\u041e\u0421\u0422 \u041f\u0423\u041d\u041a\u0422 1507 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064465", "2064465", "\u041e\u041f 1501 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1501 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064466", "2064466", "\u041e\u041f 1498 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1498 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064467", "2064467", "\u041e\u0427\u0415\u0420\u0415\u0422\u041e\u0412\u0410\u0422", "\u041e\u0427\u0415\u0420\u0415\u0422\u041e\u0412\u0410\u0422\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064468", "2064468", "\u041e\u041f 1490 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1490 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064469", "2064469", "\u041e\u041f 1482 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1482 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064470", "2064470", "\u041e\u041f 1477 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1477 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064471", "2064471", "\u041e\u041f 1474 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1474 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064472", "2064472", "\u041e\u041f 1459 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1459 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064473", "2064473", "\u041e\u041f 1454 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1454 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064474", "2064474", "\u041e\u041f 1422 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1422 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064475", "2064475", "\u041e\u041f 1412 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1412 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064476", "2064476", "\u041e\u041f 1411 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1411 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064477", "2064477", "\u041e\u041f 1401 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1401 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064480", "2064480", "\u041e\u041f 1376 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1376 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064481", "2064481", "\u041a\u041e\u0427\u0415\u0412\u0410\u041d\u0427\u0418\u041a", "\u041a\u041e\u0427\u0415\u0412\u0410\u041d\u0427\u0418\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064482", "2064482", "\u041e\u041f 1373 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1373 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064483", "2064483", "\u041e\u041f 1370 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1370 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064484", "2064484", "\u0413\u0410\u0419\u0414\u0410\u0428", "\u0413\u0410\u0419\u0414\u0410\u0428", "\u0421", null);
            RailwayStationsDataProvider.put("2064486", "2064486", "\u041e\u041f 1354 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1354 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064487", "2064487", "\u041e\u041f 1344 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1344 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064488", "2064488", "\u041e\u041f 1337 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1337 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064489", "2064489", "\u041f 1330 \u041a\u041c", "\u041f\u041e\u0421\u0422 1330 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064490", "2064490", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u041e", "\u041c\u0410\u0420\u0422\u042b\u041d\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064491", "2064491", "\u041e\u041f 1314 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1314 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064492", "2064492", "\u0422\u0410\u041d\u0410\u0418\u0421", "\u0422\u0410\u041d\u0410\u0418\u0421", "\u0421", null);
            RailwayStationsDataProvider.put("2064493", "2064493", "\u041e\u041f 1300 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1300 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064494", "2064494", "\u041e\u041f 1286 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1286 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064495", "2064495", "\u041e\u041f 1282 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1282 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064496", "2064496", "\u0413\u0423\u0414\u0415\u0420\u041c\u0415\u0421-\u0417", "\u0413\u0423\u0414\u0415\u0420\u041c\u0415\u0421-\u0417\u0410\u041f\u0410\u0414\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064497", "2064497", "\u041f 169 \u041a\u041c", "\u041f\u041e\u0421\u0422 169 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064498", "2064498", "\u041e\u041f 173 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 173 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064499", "2064499", "\u0422\u0415\u041f\u041b\u041e\u0412\u041e\u0414\u041d", "\u0422\u0415\u041f\u041b\u041e\u0412\u041e\u0414\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064500", "2064500", "\u0421\u041e\u041b\u041a\u0423\u0428\u0418\u041d\u041e", "\u0421\u041e\u041b\u041a\u0423\u0428\u0418\u041d\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064501", "2064501", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u0421\u041a", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064502", "2064502", "\u041f\u0410\u0412\u041b\u041e\u0414\u041e\u041b\u042c\u0421", "\u041f\u0410\u0412\u041b\u041e\u0414\u041e\u041b\u042c\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064503", "2064503", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0413", "\u0415\u041a\u0410\u0422\u0415\u0420\u0418\u041d\u041e\u0413\u0420\u0410\u0414\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064504", "2064504", "\u0421\u0410\u0414\u041e\u041d", "\u0421\u0410\u0414\u041e\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064505", "2064505", "\u0421\u0415\u041b\u0415\u041a\u0426\u0418\u041e\u041d\u041d", "\u0421\u0415\u041b\u0415\u041a\u0426\u0418\u041e\u041d\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064351", "2064351", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064506", "2064506", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0417\u0410\u0412\u041e\u0414\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064507", "2064507", "\u0423\u0420\u0412\u0410\u041d\u042c", "\u0423\u0420\u0412\u0410\u041d\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064508", "2064508", "\u0428\u0418\u0428\u041a\u0418\u041d\u041e", "\u0428\u0418\u0428\u041a\u0418\u041d\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064509", "2064509", "\u041a\u0420\u0423\u0422 \u041f\u0415\u0421\u041a\u0418", "\u041a\u0420\u0423\u0422\u042b\u0415 \u041f\u0415\u0421\u041a\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064510", "2064510", "\u041c\u0418\u0425\u0410\u0419\u041b\u041e\u0412\u0421\u041a", "\u041c\u0418\u0425\u0410\u0419\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064511", "2064511", "\u041e\u041f 65 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 65 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064512", "2064512", "\u041e\u041f 63 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 63 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064930", "2064930", "\u041e\u041f 53 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 53 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064513", "2064513", "\u041e\u041f 28 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 28 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064514", "2064514", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064515", "2064515", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064516", "2064516", "\u041a\u0420.\u0414\u0415\u0420\u0415\u0412\u041d\u042f", "\u041a\u0420\u0410\u0421\u041d\u0410\u042f \u0414\u0415\u0420\u0415\u0412\u041d\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064517", "2064517", "\u041e\u041f 2444 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2444 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064518", "2064518", "\u041e\u041f 2411 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2411 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064519", "2064519", "\u041e\u041f 2408 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2408 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064520", "2064520", "\u041e\u041f 2398 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2398 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064521", "2064521", "\u041e\u041f 2383 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2383 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064522", "2064522", "\u041f\u0410\u041f\u0410\u0421", "\u041f\u0410\u041f\u0410\u0421", "\u0421", null);
            RailwayStationsDataProvider.put("2064523", "2064523", "\u041e\u041f 2371 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2371 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064524", "2064524", "\u041e\u041f 2363 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2363 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064525", "2064525", "\u0423\u041b\u041b\u0423\u0411\u0418\u0415\u0412\u041e", "\u0423\u041b\u041b\u0423\u0411\u0418\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064933", "2064933", "\u041e\u041f 2330 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2330 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064526", "2064526", "\u041e\u041f 2323 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2323 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064527", "2064527", "\u041e\u041f 2314 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2314 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064528", "2064528", "\u0423\u0419\u0422\u0410\u0428", "\u0423\u0419\u0422\u0410\u0428", "\u0421", null);
            RailwayStationsDataProvider.put("2064529", "2064529", "\u041e\u041f 2304 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2304 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064530", "2064530", "\u041e\u041f 2301 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2301 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064531", "2064531", "\u041e\u041f 2290 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2290 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064532", "2064532", "\u041e\u041f 2279 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2279 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064932", "2064932", "\u0411\u041e\u0413\u0410\u0422\u042b\u0420\u0415\u0412\u041e", "\u0411\u041e\u0413\u0410\u0422\u042b\u0420\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064533", "2064533", "\u041e\u041f 2265 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2265 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064534", "2064534", "\u0410\u041b\u041c\u0410\u041b\u041e", "\u0410\u041b\u041c\u0410\u041b\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064535", "2064535", "\u041e\u041f 2244 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2244 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064536", "2064536", "\u041f\u0415\u041b\u042c\u0422\u0418\u0415\u0412\u0421\u041a", "\u041f\u0415\u041b\u042c\u0422\u0418\u0415\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064537", "2064537", "\u041e\u041f 2236 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2236 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064539", "2064539", "\u041e\u041f 2233 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2233 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064540", "2064540", "\u0421\u0423\u041b\u0410\u041a", "\u0421\u0423\u041b\u0410\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064541", "2064541", "\u041e\u041f 2219 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2219 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064542", "2064542", "\u0411\u0410\u0419\u0420\u0410\u041c", "\u0411\u0410\u0419\u0420\u0410\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064547", "2064547", "\u0418\u0421\u0422\u0418\u0421\u0423", "\u0418\u0421\u0422\u0418\u0421\u0423", "\u0421", null);
            RailwayStationsDataProvider.put("2064548", "2064548", "\u041e\u041f 2159 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2159 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064549", "2064549", "\u041e\u041f 2155 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2155 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064750", "2064750", "\u041e\u041f 2149 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2149 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064751", "2064751", "\u041e\u041f 2138 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2138 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064752", "2064752", "\u041e\u041f 2137 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2137 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064753", "2064753", "\u0410\u041b\u0414\u042b", "\u0410\u041b\u0414\u042b", "\u0421", null);
            RailwayStationsDataProvider.put("2064754", "2064754", "\u041e\u041f 2046 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2046 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064755", "2064755", "\u041e\u041f 1957 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1957 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064756", "2064756", "\u041e\u041f 1925 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1925 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064757", "2064757", "\u0422\u0415\u041f \u0420\u0415\u0427\u041a\u0410", "\u0422\u0415\u041f\u041b\u0410\u042f \u0420\u0415\u0427\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064758", "2064758", "\u041e\u041f 1863 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1863 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064759", "2064759", "\u041e\u041f 1854 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1854 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064760", "2064760", "\u041f\u0423\u0422\u0415\u041f\u0420\u041e\u0412\u041e\u0414", "\u041f\u0423\u0422\u0415\u041f\u0420\u041e\u0412\u041e\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064761", "2064761", "\u041e\u041f 1823 \u041a\u041c", "\u041e\u0421\u0422.1823 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064762", "2064762", "\u041e\u041f 1807 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1807 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064763", "2064763", "\u041e\u041f 1796 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1796 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064764", "2064764", "\u041a\u0420\u042b\u041c-\u0413\u0418\u0420", "\u041a\u0420\u042b\u041c-\u0413\u0418\u0420\u0415\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064765", "2064765", "\u041e\u041f 1784 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1784 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064767", "2064767", "\u041e\u041f 1774 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1774 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064768", "2064768", "\u041e\u041f 1764 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1764 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064769", "2064769", "\u041e\u041f 1752 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1752 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064770", "2064770", "\u041e\u041f 1749 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1749 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064771", "2064771", "\u041e\u041f 1741 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1741 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064772", "2064772", "\u041e\u041f 1738 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1738 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064773", "2064773", "\u041e\u041f 1737 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1737 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064774", "2064774", "\u041e\u041f 1724 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1724 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064775", "2064775", "\u041e\u041f 1717 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1717 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064776", "2064776", "\u041d\u0415\u0421\u041a\u0423\u0427\u041d\u042b\u0419", "\u041d\u0415\u0421\u041a\u0423\u0427\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064777", "2064777", "\u041e\u041f 1704 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1704 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064778", "2064778", "\u041e\u041f 1695 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1695 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064779", "2064779", "\u041e\u041f 1690 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1690 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064780", "2064780", "\u041a\u0423\u0420\u0413\u041e\u041a\u041e\u0412\u0421\u041a", "\u041a\u0423\u0420\u0413\u041e\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064781", "2064781", "\u041e\u041f 1680 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1680 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064782", "2064782", "\u041e\u041f 1669 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1669 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064783", "2064783", "\u0412\u041e\u041b\u042c\u041d\u042b\u0419", "\u0412\u041e\u041b\u042c\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064784", "2064784", "\u041e\u041f 1661 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1661 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065700", "2065700", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u04202", "\u041a\u0420\u0410\u0421\u041d\u041e\u0414\u0410\u0420 2", "\u0421", null);
            RailwayStationsDataProvider.put("2064785", "2064785", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064786", "2064786", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064787", "2064787", "\u041e\u041f 61 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 61 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064790", "2064790", "\u0411\u0415\u0419\u0421\u0423\u0416\u0415\u041a", "\u0411\u0415\u0419\u0421\u0423\u0416\u0415\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064791", "2064791", "\u0427\u0415\u041f\u0418\u0413\u0418\u041d\u0421\u041a", "\u0427\u0415\u041f\u0418\u0413\u0418\u041d\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064792", "2064792", "\u0411\u041e\u0420\u0415\u0426 \u0422\u0420\u0423\u0414", "\u0411\u041e\u0420\u0415\u0426 \u0422\u0420\u0423\u0414\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064793", "2064793", "\u0416\u0415\u041b\u0422\u042b\u0415 \u041a\u041e\u041f", "\u0416\u0415\u041b\u0422\u042b\u0415 \u041a\u041e\u041f\u0410\u041d\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064797", "2064797", "\u041e\u041f 1401 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1401 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064798", "2064798", "\u041e\u041f 1382 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1382 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064799", "2064799", "\u041e\u041f 1379 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1379 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064901", "2064901", "\u0412\u042b\u0421\u041e\u0427\u0418\u041d\u041e", "\u0412\u042b\u0421\u041e\u0427\u0418\u041d\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064902", "2064902", "\u0417\u041e\u041e\u041b\u041e\u0413 \u0421\u0410\u0414", "\u0417\u041e\u041e\u041b\u041e\u0413\u0418\u0427\u0415\u0421\u041a\u0418\u0419 \u0421\u0410\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064903", "2064903", "\u0420\u0410\u0417\u0412\u0418\u041b\u041a\u0410", "\u0420\u0410\u0417\u0412\u0418\u041b\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064904", "2064904", "\u041a\u0420\u0410\u0421 \u0410\u041a\u0421\u0410\u0419", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u0410\u041a\u0421\u0410\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064905", "2064905", "\u0421\u0422\u0415\u041a\u041b\u041e\u0417\u0410\u0412", "\u0421\u0422\u0415\u041a\u041b\u041e\u0417\u0410\u0412\u041e\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064906", "2064906", "\u0411\u0415\u0420\u0414\u0410\u041d\u041e\u0421\u041e\u0412", "\u0411\u0415\u0420\u0414\u0410\u041d\u041e\u0421\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064907", "2064907", "\u0411\u041e\u041b\u042c\u0428 \u041b\u041e\u0413", "\u0411\u041e\u041b\u042c\u0428\u041e\u0419 \u041b\u041e\u0413", "\u0421", null);
            RailwayStationsDataProvider.put("2064908", "2064908", "\u041f\u0427\u0415\u041b\u041e\u0412\u041e\u0414\u041d", "\u041f\u0427\u0415\u041b\u041e\u0412\u041e\u0414\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064909", "2064909", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064910", "2064910", "\u041c\u042b\u0428\u041a\u0418\u041d\u0421\u041a\u0410\u042f", "\u041c\u042b\u0428\u041a\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064911", "2064911", "\u041e\u041f 1178 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1178 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064912", "2064912", "\u0426\u0418\u041a\u0423\u041d\u041e\u0412\u041a\u0410", "\u0426\u0418\u041a\u0423\u041d\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064913", "2064913", "\u041e\u041f 1165 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1165 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064914", "2064914", "\u041e\u041f 1148 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1148 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064915", "2064915", "\u041e\u041f 1144 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1144 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064916", "2064916", "\u041e\u041f 1136 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1136 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064917", "2064917", "\u041e\u041f 1129 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1129 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064918", "2064918", "\u0410\u0422\u042e\u0425\u0422\u0410", "\u0410\u0422\u042e\u0425\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064919", "2064919", "\u041e\u041f 1123 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1123 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064920", "2064920", "\u041b\u0415\u0421\u041e\u0421\u0422\u0415\u041f\u042c", "\u041b\u0415\u0421\u041e\u0421\u0422\u0415\u041f\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064931", "2064931", "\u041e\u041f 1115 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1115 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064921", "2064921", "\u041a\u0423\u041d\u0414\u0420\u042e\u0427\u0418\u0419", "\u041a\u0423\u041d\u0414\u0420\u042e\u0427\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064922", "2064922", "\u041e\u041f 1108 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1108 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064923", "2064923", "\u041e\u041f 1101 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1101 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064924", "2064924", "\u041e\u041f 1089 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1089 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064925", "2064925", "\u041e\u041f 138 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 138 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064926", "2064926", "\u041e\u041f 134 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 134 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064927", "2064927", "\u041e\u041f 126 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 126 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064928", "2064928", "\u0420\u0417\u0414 738 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 738 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064929", "2064929", "\u0425\u041e\u041b\u041c\u0421\u041a\u0410\u042f", "\u0425\u041e\u041b\u041c\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064401", "2064401", "\u041e\u041f 60 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 60 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064403", "2064403", "\u041e\u041f 36 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 36 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064404", "2064404", "\u041e\u041f 33 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 33 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064405", "2064405", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064406", "2064406", "\u0425\u0423\u0422\u041e\u0420\u0421\u041a\u0410\u042f", "\u0425\u0423\u0422\u041e\u0420\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064407", "2064407", "\u0413\u041e\u0420\u041d\u042b\u0419", "\u0413\u041e\u0420\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064408", "2064408", "\u041e\u041f 33 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 33 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064409", "2064409", "\u041e\u041f 116 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 116 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064410", "2064410", "\u041e\u041f 144 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 144 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064411", "2064411", "\u0414\u0416\u0418\u0413\u0418\u041d\u0421\u041a\u0418\u0419", "\u0414\u0416\u0418\u0413\u0418\u041d\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064412", "2064412", "\u0427\u0415\u041a\u041e\u041d", "\u0427\u0415\u041a\u041e\u041d", "\u0421", null);
            RailwayStationsDataProvider.put("2064413", "2064413", "\u041e\u041f 30 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 30 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064414", "2064414", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064415", "2064415", "\u041a\u0410\u0424\u042b\u0420-\u041a\u0423\u041c\u0423", "\u041a\u0410\u0424\u042b\u0420-\u041a\u0423\u041c\u0423\u0425", "\u0421", null);
            RailwayStationsDataProvider.put("2064416", "2064416", "\u041e\u041f 29 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 29 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064417", "2064417", "\u041e\u041f 25 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 25 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064418", "2064418", "\u041a\u0423\u041c\u0422\u041e\u0420-\u041a\u0410\u041b", "\u041a\u0423\u041c\u0422\u041e\u0420-\u041a\u0410\u041b\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2064419", "2064419", "\u041e\u041f 7 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 7 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064420", "2064420", "\u041e\u041f 4 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064421", "2064421", "\u041a\u0410\u041b\u0410\u0414\u0416\u0418\u041d\u0421\u041a", "\u041a\u0410\u041b\u0410\u0414\u0416\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064422", "2064422", "\u0413\u041e\u0421\u041f\u0418\u0422\u0410\u041b\u042c", "\u0413\u041e\u0421\u041f\u0418\u0422\u0410\u041b\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064423", "2064423", "\u0417\u0410\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u0417\u0410\u0421\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064424", "2064424", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u0421\u041a", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064425", "2064425", "\u041e\u041f 25 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 25 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064426", "2064426", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064427", "2064427", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064428", "2064428", "\u041e\u041f 56 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 56 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065037", "2065037", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064429", "2064429", "\u0428\u0423\u041d\u0422\u0423\u041a", "\u0428\u0423\u041d\u0422\u0423\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064430", "2064430", "\u041e\u041f 37 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 37 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064431", "2064431", "\u041e\u041f 35 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 35 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064432", "2064432", "\u041e\u041f 29 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 29 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064433", "2064433", "\u041e\u041f 9 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 9 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064434", "2064434", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064435", "2064435", "\u041a\u0418\u041c", "\u041a\u0418\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064436", "2064436", "\u041e\u041f 113 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 113 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064437", "2064437", "\u041e\u041f 118 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 118 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064438", "2064438", "\u041f\u041e\u0419\u041c\u0415\u041d\u041d\u042b\u0419", "\u041f\u041e\u0419\u041c\u0415\u041d\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064439", "2064439", "\u041e\u041f 138 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 138 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064440", "2064440", "\u041e\u041f 153 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 153 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064441", "2064441", "\u041d\u041e\u0412\u041e\u041b\u041e\u0414\u0418\u041d\u041e", "\u041d\u041e\u0412\u041e\u041b\u041e\u0414\u0418\u041d\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064442", "2064442", "\u041e\u041f 166 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 166 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064443", "2064443", "\u041e\u041f 169 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 169 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064444", "2064444", "\u041e\u041f 147 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 147 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064445", "2064445", "\u041e\u041f 89 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 89 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064446", "2064446", "\u041e\u041f 44 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 44 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064447", "2064447", "\u041c\u0418\u041d\u0410\u0415\u0412\u0421\u041a\u0418\u0419", "\u041c\u0418\u041d\u0410\u0415\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064448", "2064448", "\u041e\u041f 240 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 240 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064449", "2064449", "\u041a\u0423\u0420\u0415\u041d\u042b\u0419", "\u041a\u0423\u0420\u0415\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064802", "2064802", "\u041e\u041f 411 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 411 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064803", "2064803", "\u041e\u041f 431 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 431 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064808", "2064808", "\u041e\u041f 118 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 118 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064809", "2064809", "\u0420\u0415\u0414\u0423\u0422\u0421\u041a\u0418\u0419", "\u0420\u0415\u0414\u0423\u0422\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064810", "2064810", "\u041f\u041e\u0422\u0410\u0415\u041d\u041d\u042b\u0419", "\u041f\u041e\u0422\u0410\u0415\u041d\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064811", "2064811", "\u041a\u0410\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u041a\u0410\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064812", "2064812", "\u041a\u0423\u0411\u0410\u041d\u042c", "\u041a\u0423\u0411\u0410\u041d\u042c", "\u0421", null);
            RailwayStationsDataProvider.put("2064813", "2064813", "\u041e\u041f 654 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 654 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064814", "2064814", "\u041e\u041f 597 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 597 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064815", "2064815", "\u041e\u041f 130 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 130 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064816", "2064816", "\u041e\u041f 115 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 115 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064817", "2064817", "\u041e\u041f 85 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 85 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064818", "2064818", "\u041e\u041f 79 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 79 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064819", "2064819", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064820", "2064820", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064821", "2064821", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064822", "2064822", "\u041e\u041f 12 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064823", "2064823", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064824", "2064824", "\u041e\u041f 27 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 27 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064825", "2064825", "\u041e\u041f 4 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064826", "2064826", "\u041e\u041f 1070 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1070 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064827", "2064827", "\u041e\u041f 1067 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1067 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064828", "2064828", "\u041e\u041f 1064 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1064 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064829", "2064829", "\u041e\u041f 1057 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1057 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064830", "2064830", "\u041e\u041f 1055 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1055 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064831", "2064831", "\u041e\u041f 1051 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1051 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064832", "2064832", "\u0421\u0415\u0412\u0415\u0420-\u0414\u041e\u041d", "\u0421\u0415\u0412\u0415\u0420\u041e-\u0414\u041e\u041d\u0415\u0426\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2064833", "2064833", "\u041e\u041f 1045 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1045 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064834", "2064834", "\u041e\u041f 1043 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1043 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064835", "2064835", "\u041e\u041f 1040 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1040 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064836", "2064836", "\u041e\u041f 1034 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1034 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064837", "2064837", "\u041e\u041f 1032 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1032 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064838", "2064838", "\u041e\u041f 1022 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1022 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064839", "2064839", "\u041e\u041f 1020 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1020 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064840", "2064840", "\u041e\u041f 1018 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1018 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064841", "2064841", "\u041e\u041f 1015 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1015 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064842", "2064842", "\u041e\u041f 1008 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1008 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064843", "2064843", "\u041e\u041f 995 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 995 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064844", "2064844", "\u041e\u041f 983 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 983 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064845", "2064845", "\u041e\u041f 972 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 972 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064846", "2064846", "\u0411\u041e\u0427\u0415\u041d\u041a\u041e\u0412\u041e", "\u0411\u041e\u0427\u0415\u041d\u041a\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064847", "2064847", "\u041e\u041f 940 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 940 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064848", "2064848", "\u041e\u041f 937 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 937 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064849", "2064849", "\u0421\u042b\u0421\u041e\u0415\u0412\u041e", "\u0421\u042b\u0421\u041e\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064950", "2064950", "\u041e\u041f 928 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 928 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064951", "2064951", "\u041e\u041f 917 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 917 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064952", "2064952", "\u041c\u0410\u041d\u042c\u041a\u041e\u0412\u041e", "\u041c\u0410\u041d\u042c\u041a\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064953", "2064953", "\u041e\u041f 907 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 907 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064956", "2064956", "\u0421\u0422.\u0418\u041b\u042c\u0415\u041d\u041a\u041e", "\u0421\u0422\u0410\u0420\u0410\u042f \u0418\u041b\u042c\u0415\u041d\u041a\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064958", "2064958", "\u041e\u041f 126 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 126 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064959", "2064959", "\u041e\u041f 134 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 134 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064960", "2064960", "\u041e\u041f 137 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 137 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064961", "2064961", "\u041e\u041f 140 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 140 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064962", "2064962", "\u041e\u041f 145 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 145 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064963", "2064963", "\u041e\u041f 149 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 149 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064964", "2064964", "\u041e\u041f 152 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 152 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064965", "2064965", "\u041e\u041f 166 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 166 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064966", "2064966", "\u041e\u041f 173 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 173 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064967", "2064967", "\u041e\u041f 175 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 175 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064968", "2064968", "\u041e\u041f 178 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 178 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064969", "2064969", "\u041e\u041f 183 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 183 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064970", "2064970", "\u041e\u041f 83 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 83 \u041a\u041c.", "\u0421", null);
            RailwayStationsDataProvider.put("2064971", "2064971", "\u041e\u041f 75 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 75 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064972", "2064972", "\u041e\u041f 70 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 70 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064973", "2064973", "\u041e\u041f 69 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 69 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064974", "2064974", "\u041e\u041f 65 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 65 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064975", "2064975", "\u041e\u041f 52 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 52 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064976", "2064976", "\u041e\u041f 47 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 47 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064977", "2064977", "\u041e\u041f 43 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 43 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064979", "2064979", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064980", "2064980", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064981", "2064981", "\u041e\u041f 146 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 146 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064982", "2064982", "\u041e\u041f 136 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 136 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064983", "2064983", "\u041e\u041f 124 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 124 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064984", "2064984", "\u041e\u041f 113 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 113 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064985", "2064985", "\u041e\u041f 105 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 105 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064986", "2064986", "\u041e\u041f 89 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 89 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064987", "2064987", "\u041e\u041f 81 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 81 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064988", "2064988", "\u041e\u041f 79 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 79 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064989", "2064989", "\u0411\u041f 77 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 77 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064991", "2064991", "\u041e\u041f 60 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a 60 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064992", "2064992", "\u0411\u041f 58 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 58 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064993", "2064993", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064994", "2064994", "\u0411\u041f 47 \u041a\u041c", "\u0411\u041b\u041e\u041a \u041f\u041e\u0421\u0422 47 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064995", "2064995", "\u041e\u041f 20 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a 20 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064996", "2064996", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064997", "2064997", "\u041e\u041f 15 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 15 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064998", "2064998", "\u041e\u041f 9 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a 9 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064999", "2064999", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065003", "2065003", "\u0420\u0417\u0414 201 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 201 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065004", "2065004", "\u041e\u041f 200 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 200 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065005", "2065005", "\u041e\u041f 197 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 197 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065006", "2065006", "\u041e\u041f 142 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 142 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065031", "2065031", "\u041b\u0415\u0422\u041d\u0418\u041a", "\u041b\u0415\u0422\u041d\u0418\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2065033", "2065033", "\u041b\u0415\u0412\u0415\u041d\u0426\u041e\u0412\u0421\u041a", "\u041b\u0415\u0412\u0415\u041d\u0426\u041e\u0412\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065034", "2065034", "\u041f\u041e\u0421\u0422 4 \u041a\u041c", "\u041f\u041e\u0421\u0422 4 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065035", "2065035", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065036", "2065036", "\u041a\u0420\u0410\u0421.\u041c\u0410\u042f\u041a", "\u041a\u0420\u0410\u0421\u041d\u042b\u0419 \u041c\u0410\u042f\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2065008", "2065008", "\u041e\u041f 29 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 29 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065009", "2065009", "\u041e\u041f 22 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 22 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065010", "2065010", "\u041e\u041f 12 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065024", "2065024", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065012", "2065012", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065013", "2065013", "\u041e\u041f 65 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 65 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065014", "2065014", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065015", "2065015", "\u041e\u041f 58 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 58 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065016", "2065016", "\u041e\u041f 53 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 53 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065017", "2065017", "\u041a\u0420\u0410\u0421\u041d\u041e\u041a\u0423\u0420\u0413", "\u041a\u0420\u0410\u0421\u041d\u041e\u041a\u0423\u0420\u0413\u0410\u041d\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065018", "2065018", "\u041e\u041f 45 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 45 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065019", "2065019", "\u041e\u041f 39 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 39 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065020", "2065020", "\u041a\u0415\u0420\u0427\u0418\u041a", "\u041a\u0415\u0420\u0427\u0418\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2065021", "2065021", "\u041a\u0410\u0414\u0410\u041c\u041e\u0412\u041a\u0410", "\u041a\u0410\u0414\u0410\u041c\u041e\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2065022", "2065022", "\u0413\u0420\u0418\u0412\u0415\u041d\u041d\u0410\u042f", "\u0413\u0420\u0418\u0412\u0415\u041d\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065025", "2065025", "\u0421\u0410\u041c\u0410\u0420\u0421\u041a\u0410\u042f", "\u0421\u0410\u041c\u0410\u0420\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065027", "2065027", "\u041a\u041e\u041b\u0415\u0421\u041d\u0418\u041a\u041e\u0412", "\u041a\u041e\u041b\u0415\u0421\u041d\u0418\u041a\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2065028", "2065028", "\u041e\u041f 1262 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1262 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2065029", "2065029", "\u041a\u0423\u0428\u041d\u0410\u0420\u0415\u0412\u041a\u0410", "\u041a\u0423\u0428\u041d\u0410\u0420\u0415\u0412\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2065030", "2065030", "\u041a\u0418\u0420\u041f.\u0417\u0410\u0412\u041e\u0414", "\u041a\u0418\u0420\u041f\u0418\u0427\u041d\u042b\u0419 \u0417\u0410\u0412\u041e\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064954", "2064954", "\u0412\u041b\u0410\u0421.\u041a\u041e\u041f\u0418", "\u0412\u041b\u0410\u0421\u041e\u0412\u0421\u041a\u0418\u0415 \u041a\u041e\u041f\u0418", "\u0421", null);
            RailwayStationsDataProvider.put("2064955", "2064955", "\u0413\u0420\u0423\u0428.\u0410\u041d\u0422\u0420.", "\u0413\u0420\u0423\u0428\u0415\u0412\u0421\u041a\u0418\u0419 \u0410\u041d\u0422\u0420\u0410\u0426\u0418\u0422", "\u0421", null);
            RailwayStationsDataProvider.put("2704714", "2704714", "\u0410\u0419\u041a\u0415", "\u0410\u0419\u041a\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2900879", "2900879", "\u041a\u0410\u0420\u0410\u041a\u0410\u041b\u041f\u0410\u041a", "\u041a\u0410\u0420\u0410\u041a\u0410\u041b\u041f\u0410\u041a\u0418\u042f", "\u0424", null);
            RailwayStationsDataProvider.put("2064478", "2064478", "\u041e\u041f 1388 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1388 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064479", "2064479", "\u041e\u041f 1386 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1386 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064543", "2064543", "\u0411\u0410\u0422\u0410\u0428\u0415\u0412\u0421\u041a", "\u0411\u0410\u0422\u0410\u0428\u0415\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064544", "2064544", "\u041e\u041f 2192 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2192 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064545", "2064545", "\u0413\u0415\u0420\u0417\u0415\u041b\u042c-\u0410\u0423", "\u0413\u0415\u0420\u0417\u0415\u041b\u042c-\u0410\u0423\u041b", "\u0421", null);
            RailwayStationsDataProvider.put("2064546", "2064546", "\u041e\u041f 2184 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 2184 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064795", "2064795", "\u041e\u041f 1418 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1418 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064796", "2064796", "\u041e\u041f 1413 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1413 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2014076", "2014076", "\u041e\u041f 463 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 463 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014077", "2014077", "\u041f\u041f 474 \u041a\u041c", "\u041f\u0423\u0422\u0415\u0412\u041e\u0419 \u041f\u041e\u0421\u0422 474 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014078", "2014078", "\u041e\u041f 479 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 479 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014487", "2014487", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u041e\u0412\u041e", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014080", "2014080", "\u041e\u041f 488 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 488 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014486", "2014486", "\u0414\u0420\u042f\u0417\u0413\u0418", "\u0414\u0420\u042f\u0417\u0413\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("2014081", "2014081", "\u0412\u0415\u0414\u0420\u0418\u041d\u0426\u0415\u0412\u041e", "\u0412\u0415\u0414\u0420\u0418\u041d\u0426\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014007", "2014007", "\u041c\u041e\u0421\u041a\u041e\u0412\u041a\u0410", "\u041c\u041e\u0421\u041a\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014083", "2014083", "\u041e\u041f 517 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 517 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014086", "2014086", "\u041f\u041e\u0414\u0421\u0422\u0410\u041d\u0426\u0418\u042f", "\u041f\u041e\u0414\u0421\u0422\u0410\u041d\u0426\u0418\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014767", "2014767", "\u041e\u041f 527 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 527 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014087", "2014087", "\u0411\u0415\u041b\u042f\u0415\u0412\u041e", "\u0411\u0415\u041b\u042f\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014088", "2014088", "\u041e\u041f 539 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 539 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014095", "2014095", "\u0423\u0413\u041b\u042f\u041d\u0415\u0426", "\u0423\u0413\u041b\u042f\u041d\u0415\u0426", "\u0412", null);
            RailwayStationsDataProvider.put("2014094", "2014094", "\u041e\u0420\u041b\u041e\u0412\u041e", "\u041e\u0420\u041b\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014482", "2014482", "\u0422\u0420\u0415\u0421\u0412\u042f\u0422\u0421\u041a", "\u0422\u0420\u0415\u0421\u0412\u042f\u0422\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014093", "2014093", "\u0421\u0418\u041d\u0418\u0426\u042b\u041d\u041e", "\u0421\u0418\u041d\u0418\u0426\u042b\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014092", "2014092", "\u0428\u0423\u0411\u0415\u0420\u0421\u041a\u041e\u0415", "\u0428\u0423\u0411\u0415\u0420\u0421\u041a\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014091", "2014091", "\u0414\u0423\u0411\u041e\u0412\u041a\u0410", "\u0414\u0423\u0411\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014479", "2014479", "\u0421\u041e\u041c\u041e\u0412\u041e", "\u0421\u041e\u041c\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014090", "2014090", "\u0411\u041e\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0411\u041e\u0420\u041e\u0412\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014478", "2014478", "\u041e\u0422\u0420\u041e\u0416\u041a\u0410", "\u041e\u0422\u0420\u041e\u0416\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014089", "2014089", "\u0411\u0415\u0420\u0415\u0417 \u0420\u041e\u0429\u0410", "\u0411\u0415\u0420\u0415\u0417\u041e\u0412\u0410\u042f \u0420\u041e\u0429\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014234", "2014234", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014096", "2014096", "\u041e\u041f 7 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 7 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014235", "2014235", "\u041e\u041f 12 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 12 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014236", "2014236", "\u041e\u041f 14 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 14 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014097", "2014097", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014237", "2014237", "\u041e\u041f 20 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 20 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014491", "2014491", "\u0425\u0410\u0412\u0410", "\u0425\u0410\u0412\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014243", "2014243", "\u041e\u041f 37 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 37 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014099", "2014099", "\u041e\u041f 41 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 41 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014492", "2014492", "\u041f\u0415\u0420\u0415\u041b\u0415\u0428\u0418\u041d\u041e", "\u041f\u0415\u0420\u0415\u041b\u0415\u0428\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014493", "2014493", "\u0422\u0423\u041b\u0418\u041d\u041e\u0412\u041e", "\u0422\u0423\u041b\u0418\u041d\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014494", "2014494", "\u0422\u041e\u0419\u0414\u0410", "\u0422\u041e\u0419\u0414\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014238", "2014238", "\u041e\u041f 70 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 70 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014100", "2014100", "\u041e\u041f 79 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 79 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014495", "2014495", "\u0410\u041d\u041d\u0410", "\u0410\u041d\u041d\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014606", "2014606", "\u0413\u0420\u042f\u0417\u0418 \u041e\u0420\u041b", "\u0413\u0420\u042f\u0417\u0418 \u041e\u0420\u041b\u041e\u0412\u0421\u041a\u0418\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014103", "2014103", "\u0413\u0420\u042f\u0417\u0418 \u0412\u041e\u041b", "\u0413\u0420\u042f\u0417\u0418-\u0412\u041e\u041b\u0413\u041e\u0413\u0420\u0410\u0414\u0421\u041a\u0418\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014053", "2014053", "\u041e\u041f 482 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 482 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014245", "2014245", "\u041e\u041f 520 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 520 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014246", "2014246", "\u041e\u041f 533 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 533 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014054", "2014054", "\u041e\u041f 554 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 554 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014055", "2014055", "\u041e\u041f 564 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 564 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014056", "2014056", "\u041e\u041f 582 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 582 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014763", "2014763", "\u041e\u041f 598 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 598 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014247", "2014247", "\u041e\u041f 608 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 608 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014459", "2014459", "\u0415\u0421\u0418\u041f\u041e\u0412\u041e", "\u0415\u0421\u0418\u041f\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014462", "2014462", "\u0411\u041e\u0427\u0410\u0420\u041d\u0418\u041a\u041e\u0412", "\u0411\u041e\u0427\u0410\u0420\u041d\u0418\u041a\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014463", "2014463", "\u041d\u0410\u0420\u041e\u0414\u041d\u0410\u042f", "\u041d\u0410\u0420\u041e\u0414\u041d\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014248", "2014248", "\u041e\u041f 648 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 648 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014464", "2014464", "\u041a\u0410\u0420\u0410\u0427\u0410\u041d", "\u041a\u0410\u0420\u0410\u0427\u0410\u041d", "\u0412", null);
            RailwayStationsDataProvider.put("2014249", "2014249", "\u041e\u041f 659 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 659 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014143", "2014143", "\u0420\u0417\u0414 667 \u041a\u041c", "\u0420\u0417\u0414 667 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014176", "2014176", "\u041e\u041f 676 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 676 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014141", "2014141", "\u0420\u0417\u0414 686 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 686 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014177", "2014177", "\u041e\u041f 689 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 689 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014250", "2014250", "\u041e\u041f 691 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 691 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014467", "2014467", "\u0417\u0412\u0415\u0413\u0418\u041d\u0426\u0415\u0412\u041e", "\u0417\u0412\u0415\u0413\u0418\u041d\u0426\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014102", "2014102", "\u041e\u041f 698 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 698 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014084", "2014084", "\u0420\u0417\u0414 701 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 701 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014468", "2014468", "\u0411\u041b\u0410\u0413\u041e\u0414\u0410\u0422\u0415\u041d", "\u0411\u041b\u0410\u0413\u041e\u0414\u0410\u0422\u0415\u041d\u0421\u041a\u0418\u0419", "\u0412", null);
            RailwayStationsDataProvider.put("2014105", "2014105", "\u041e\u041f 171 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 171 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014785", "2014785", "\u041e\u041f 173 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 173 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014469", "2014469", "\u041d\u0418\u0416\u041d\u0415\u0414\u0415\u0412\u0418\u0426", "\u041d\u0418\u0416\u041d\u0415\u0414\u0415\u0412\u0418\u0426\u041a", "\u0412", null);
            RailwayStationsDataProvider.put("2014786", "2014786", "\u041e\u041f 179 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 179 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014471", "2014471", "\u0418\u0417\u0411\u0418\u0429\u0415", "\u0418\u0417\u0411\u0418\u0429\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2015669", "2015669", "\u041e\u041f 187 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 187 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014670", "2014670", "\u041e\u041f 193 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 193 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014472", "2014472", "\u041a\u0423\u0420\u0411\u0410\u0422\u041e\u0412\u041e", "\u041a\u0423\u0420\u0411\u0410\u0422\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014671", "2014671", "\u041e\u041f 201 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 201 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014787", "2014787", "\u041e\u041f 205 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 205 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014599", "2014599", "\u041a\u0423\u0417\u0418\u0425\u0410", "\u041a\u0423\u0417\u0418\u0425\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014788", "2014788", "\u041e\u041f 209 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 209 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014473", "2014473", "\u0412\u0415\u0414\u0423\u0413\u0410", "\u0412\u0415\u0414\u0423\u0413\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014789", "2014789", "\u041e\u041f 215 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 215 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014070", "2014070", "\u0420\u0417\u0414 226 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 226 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014476", "2014476", "\u041f\u041e\u0414\u041a\u041b\u0415\u0422\u041d\u041e\u0415", "\u041f\u041e\u0414\u041a\u041b\u0415\u0422\u041d\u041e\u0415", "\u0412", null);
            RailwayStationsDataProvider.put("2014672", "2014672", "\u041e\u041f 236 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 236 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014673", "2014673", "\u0420\u0417\u0414 239 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 239 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014002", "2014002", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416 \u041a", "\u0412\u041e\u0420\u041e\u041d\u0415\u0416-\u041a\u0423\u0420\u0421\u041a\u0418\u0419", "\u0412", null);
            RailwayStationsDataProvider.put("2014104", "2014104", "\u041f\u041b\u0415\u0425\u0410\u041d\u041e\u0412\u0421\u041a", "\u041f\u041b\u0415\u0425\u0410\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014758", "2014758", "\u0425\u041e\u0425\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u0425\u041e\u0425\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014050", "2014050", "\u041e\u041f 582 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 582 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014060", "2014060", "\u041e\u041f 586 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 586 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014005", "2014005", "\u041c\u0410\u0428\u041c\u0415\u0422", "\u041c\u0410\u0428\u041c\u0415\u0422", "\u0412", null);
            RailwayStationsDataProvider.put("2014497", "2014497", "\u041c\u0410\u0421\u041b\u041e\u0412\u041a\u0410", "\u041c\u0410\u0421\u041b\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014175", "2014175", "\u041e\u041f 600 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 600 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014302", "2014302", "\u041e\u041f 604 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 604 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014769", "2014769", "\u041e\u041f 607 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 607 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014045", "2014045", "\u0411\u041e\u0415\u0412\u041e", "\u0411\u041e\u0415\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014332", "2014332", "\u041e\u041f 613 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 613 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014333", "2014333", "\u041e\u041f 618 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 618 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014205", "2014205", "\u041e\u041f 626 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 626 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014334", "2014334", "\u041e\u041f 631 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 631 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014351", "2014351", "\u0410\u041d\u041e\u0428\u041a\u0418\u041d\u041e", "\u0410\u041d\u041e\u0428\u041a\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014304", "2014304", "\u041e\u041f 640 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 640 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014764", "2014764", "\u041f\u041e\u041b\u0423\u0411\u042f\u041d\u041e\u0412\u041a", "\u041f\u041e\u041b\u0423\u0411\u042f\u041d\u041e\u0412\u041a\u0410", "\u0412", null);
            RailwayStationsDataProvider.put("2014085", "2014085", "\u041d\u041e\u0412\u041e\u0412\u041e\u0420\u041e\u041d", "\u041d\u041e\u0412\u041e\u0412\u041e\u0420\u041e\u041d\u0415\u0416\u0421\u041a\u0410\u042f", "\u0412", null);
            RailwayStationsDataProvider.put("2014765", "2014765", "\u041e\u041f 14 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 14 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014222", "2014222", "\u041e\u041f 9 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 9 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014223", "2014223", "\u041e\u0425\u041e\u0422\u041d\u0418\u041a\u041e\u0412\u041e", "\u041e\u0425\u041e\u0422\u041d\u0418\u041a\u041e\u0412\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2014840", "2014840", "\u041e\u041f 19 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 19 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014224", "2014224", "\u0420\u0417\u0414 26 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 26 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014003", "2014003", "\u042d\u0420\u0422\u0418\u041b\u042c", "\u042d\u0420\u0422\u0418\u041b\u042c", "\u0412", null);
            RailwayStationsDataProvider.put("2014015", "2014015", "\u041e\u041f 4 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2014017", "2014017", "\u041e\u041f 10 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 10 \u041a\u041c", "\u0412", null);
            RailwayStationsDataProvider.put("2015019", "2015019", "\u0411\u041e\u0420", "\u0411\u041e\u0420", "\u0412", null);
            RailwayStationsDataProvider.put("2014020", "2014020", "\u0420\u0410\u041c\u041e\u041d\u042c", "\u0420\u0410\u041c\u041e\u041d\u042c", "\u0412", null);
            RailwayStationsDataProvider.put("2014404", "2014404", "\u0413\u0420\u042f\u0417\u0418", "\u0413\u0420\u042f\u0417\u0418", "\u0412", null);
            RailwayStationsDataProvider.put("8000011", "8000011", "\u0411\u0415\u0420\u041b\u0418\u041d \u0428\u0415\u041d", "\u0411\u0415\u0420\u041b\u0418\u041d \u0428\u0415\u041d\u0415\u0424\u0415\u041b\u042c\u0414", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("6600185", "6600185", "\u041a\u0423\u0420\u0413\u0410\u041d \u0422\u042e\u0411", "\u041a\u0423\u0420\u0413\u0410\u041d-\u0422\u042e\u0411\u0415", "N", null);
            RailwayStationsDataProvider.put("2064552", "2064552", "\u041f\u0420\u0415\u0414\u0423\u0413\u041e\u041b\u042c\u041d", "\u041f\u0420\u0415\u0414\u0423\u0413\u041e\u041b\u042c\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065570", "2065570", "\u0410\u0424\u0410\u041f\u041e\u0421\u0422\u0418\u041a", "\u0410\u0424\u0410\u041f\u041e\u0421\u0422\u0418\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2064069", "2064069", "\u0417\u0410\u0420\u0415\u0427\u041d\u0410\u042f", "\u0417\u0410\u0420\u0415\u0427\u041d\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065612", "2065612", "\u041e\u041f 1359 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1359 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064485", "2064485", "\u041e\u041f 1361 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1361 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2214248", "2214248", "\u041a\u0412\u0410\u0428\u0418\u041d\u041e", "\u041a\u0412\u0410\u0428\u0418\u041d\u041e", "\u0414", null);
            RailwayStationsDataProvider.put("5500010", "5500010", "\u0410\u041a\u0421", "\u0410\u041a\u0421", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5500011", "5500011", "\u0411\u0415\u0417\u0415\u041d\u042c\u0415", "\u0411\u0415\u0417\u0415\u041d\u042c\u0415", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8056498", "8056498", "\u041a\u041e\u0411\u041b\u0415\u041d\u0426", "\u041a\u041e\u0411\u041b\u0415\u041d\u0426", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2208300", "2208300", "\u041f\u0415\u0422\u0420\u041e\u0421\u0422\u0410\u041b\u042c", "\u041f\u0415\u0422\u0420\u041e\u0421\u0422\u0410\u041b\u042c", "\u0428", null);
            RailwayStationsDataProvider.put("2210775", "2210775", "\u0421 \u041a\u041e\u041b\u041e\u0414\u0415\u0417", "\u0421\u0415\u041c\u042c \u041a\u041e\u041b\u041e\u0414\u0415\u0417\u0415\u0419", "\u041f", null);
            RailwayStationsDataProvider.put("2064617", "2064617", "\u041c\u0415\u0427\u0415\u0422\u041d\u042b\u0419", "\u041c\u0415\u0427\u0415\u0422\u041d\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064713", "2064713", "\u041a\u0410\u041d\u0415\u041b\u041e\u0412\u0421\u041a", "\u041a\u0410\u041d\u0415\u041b\u041e\u0412\u0421\u041a\u0418\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2064794", "2064794", "\u041e\u041f 1431 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1431 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2064676", "2064676", "\u041e\u0420\u041b\u041e\u0412\u041a\u0410 \u041a", "\u041e\u0420\u041b\u041e\u0412\u041a\u0410-\u041a\u0423\u0411\u0410\u041d\u0421\u041a", "\u0421", null);
            RailwayStationsDataProvider.put("2065564", "2065564", "\u041c\u0415\u041a\u041b\u0415\u0422\u0410", "\u041c\u0415\u041a\u041b\u0415\u0422\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064804", "2064804", "\u0413\u041e\u0420.\u0411\u0410\u041b\u041a\u0410", "\u0413\u041e\u0420\u042c\u041a\u0410\u042f \u0411\u0410\u041b\u041a\u0410", "\u0421", null);
            RailwayStationsDataProvider.put("2064264", "2064264", "\u0420\u041e\u0412\u041d\u041e\u0415", "\u0420\u041e\u0412\u041d\u041e\u0415", "\u0421", null);
            RailwayStationsDataProvider.put("2065565", "2065565", "\u0412\u041f\u0415\u0420\u0415\u0414", "\u0412\u041f\u0415\u0420\u0415\u0414", "\u0421", null);
            RailwayStationsDataProvider.put("2064263", "2064263", "\u041f\u041e\u0420\u041e\u0428\u0418\u041d\u0421\u041a", "\u041f\u041e\u0420\u041e\u0428\u0418\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2065327", "2065327", "\u0410\u0427\u041a\u0410\u0421\u041e\u0412\u041e", "\u0410\u0427\u041a\u0410\u0421\u041e\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2704797", "2704797", "\u041a\u0410\u0420\u0410\u0411\u0410\u0422\u0410\u041d\u041e", "\u041a\u0410\u0420\u0410\u0411\u0410\u0422\u0410\u041d\u041e", "\u0426", null);
            RailwayStationsDataProvider.put("5200570", "5200570", "\u0428\u0423\u041c\u0415\u041d", "\u0428\u0423\u041c\u0415\u041d", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("2000084", "2000084", "\u0422\u0423\u041b\u0410 2", "\u0422\u0423\u041b\u0410 2", "\u041c", null);
            RailwayStationsDataProvider.put("2000173", "2000173", "\u0422\u0423\u041b\u0410 \u0412\u042f\u0417", "\u0422\u0423\u041b\u0410-\u0412\u042f\u0417\u0415\u041c\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000119", "2000119", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426 \u0421\u042b", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426-\u0421\u042b\u0417\u0420\u0410\u041d\u0421\u041a\u0418\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000118", "2000118", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426 \u0422\u0423", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426-\u0422\u0423\u041b\u042c\u0421\u041a\u0418\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000082", "2000082", "\u041a\u0423\u0411\u0418\u041d\u041a\u0410 1", "\u041a\u0423\u0411\u0418\u041d\u041a\u0410 1", "\u041c", null);
            RailwayStationsDataProvider.put("2001077", "2001077", "\u0418\u041a\u0428\u0410", "\u0418\u041a\u0428\u0410", "\u041c", null);
            RailwayStationsDataProvider.put("2000110", "2000110", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426", "\u041f\u0410\u0412\u0415\u041b\u0415\u0426", "\u041c", null);
            RailwayStationsDataProvider.put("2218215", "2218215", "\u041f\u041e\u0414\u0417\u0410\u041c\u0427\u0415", "\u041f\u041e\u0414\u0417\u0410\u041c\u0427\u0415", "\u041b", null);
            RailwayStationsDataProvider.put("2218070", "2218070", "\u041c\u0423\u041a\u0410\u0427\u0415\u0412\u041e", "\u041c\u0423\u041a\u0410\u0427\u0415\u0412\u041e", "\u041b", null);
            RailwayStationsDataProvider.put("2218068", "2218068", "\u0421\u0422\u041e\u042f\u041d\u041e\u0412", "\u0421\u0422\u041e\u042f\u041d\u041e\u0412", "\u041b", null);
            RailwayStationsDataProvider.put("2218067", "2218067", "\u0421\u0410\u041f\u0415\u0416\u0410\u041d\u041a\u0410", "\u0421\u0410\u041f\u0415\u0416\u0410\u041d\u041a\u0410", "\u041b", null);
            RailwayStationsDataProvider.put("2218180", "2218180", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420 \u0412", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420-\u0412\u041e\u041b\u042b\u041d\u0421\u041a\u0418\u0419", "\u041b", null);
            RailwayStationsDataProvider.put("2218193", "2218193", "\u0414\u041e\u041b\u0418\u041d\u0410", "\u0414\u041e\u041b\u0418\u041d\u0410", "\u041b", null);
            RailwayStationsDataProvider.put("2218154", "2218154", "\u0412\u042b\u0413\u041d\u0410\u041d\u041a\u0410", "\u0412\u042b\u0413\u041d\u0410\u041d\u041a\u0410", "\u041b", null);
            RailwayStationsDataProvider.put("2218206", "2218206", "\u0413\u0410\u041b\u0418\u0427", "\u0413\u0410\u041b\u0418\u0427", "\u041b", null);
            RailwayStationsDataProvider.put("2218098", "2218098", "\u0425\u041e\u0414\u041e\u0420\u041e\u0412", "\u0425\u041e\u0414\u041e\u0420\u041e\u0412", "\u041b", null);
            RailwayStationsDataProvider.put("2218461", "2218461", "\u0421\u041e\u041a\u0418\u0420\u042f\u041d\u042b", "\u0421\u041e\u041a\u0418\u0420\u042f\u041d\u042b", "\u041b", null);
            RailwayStationsDataProvider.put("2208744", "2208744", "\u0422\u0418\u041c\u041a\u041e\u0412\u041e", "\u0422\u0418\u041c\u041a\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2210940", "2210940", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d 2", "\u0421\u0418\u041d\u0415\u041b\u042c\u041d\u0418\u041a\u041e\u0412\u041e 2", "\u041f", null);
            RailwayStationsDataProvider.put("2214050", "2214050", "\u041a\u0420\u0410\u0421\u041d\u041e\u0410\u0420\u041c", "\u041a\u0420\u0410\u0421\u041d\u041e\u0410\u0420\u041c\u0415\u0419\u0421\u041a", "\u0414", null);
            RailwayStationsDataProvider.put("2214230", "2214230", "\u0412\u041e\u041b\u041d\u041e\u0412\u0410\u0425\u0410", "\u0412\u041e\u041b\u041d\u041e\u0412\u0410\u0425\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2065160", "2065160", "\u041c\u0410\u0420\u0426\u0415\u0412\u041e", "\u041c\u0410\u0420\u0426\u0415\u0412\u041e", "\u0421", null);
            RailwayStationsDataProvider.put("2064249", "2064249", "\u0423\u0421\u041f\u0415\u041d\u0421\u041a\u0410\u042f", "\u0423\u0421\u041f\u0415\u041d\u0421\u041a\u0410\u042f", "\u0421", null);
            RailwayStationsDataProvider.put("2708989", "2708989", "\u0411\u0410\u041b\u0425\u0410\u0428 1", "\u0411\u0410\u041b\u0425\u0410\u0428 1", "\u0426", null);
            RailwayStationsDataProvider.put("5100237", "5100237", "\u041c\u0415\u0414\u042b\u041a\u0410", "\u041c\u0415\u0414\u042b\u041a\u0410", "W", null);
            RailwayStationsDataProvider.put("5100011", "5100011", "\u041e\u0414\u041e\u041b\u0410\u041d\u041e\u0412", "\u041e\u0414\u041e\u041b\u0410\u041d\u041e\u0412", "W", null);
            RailwayStationsDataProvider.put("5100180", "5100180", "\u0416\u0415\u041f\u0418\u041d", "\u0416\u0415\u041f\u0418\u041d", "W", null);
            RailwayStationsDataProvider.put("5100062", "5100062", "\u041b\u0415\u0428\u041d\u041e", "\u041b\u0415\u0428\u041d\u041e", "W", null);
            RailwayStationsDataProvider.put("5100024", "5100024", "\u0413\u041b\u0418\u0412\u0418\u0426\u0415", "\u0413\u041b\u0418\u0412\u0418\u0426\u0415", "W", null);
            RailwayStationsDataProvider.put("5100140", "5100140", "\u0412\u0415\u0413\u041b\u0418\u041d\u0418\u0415\u0426", "\u0412\u0415\u0413\u041b\u0418\u041d\u0418\u0415\u0426", "W", null);
            RailwayStationsDataProvider.put("5100053", "5100053", "\u041a\u0420\u0416\u0418\u0428", "\u041a\u0420\u0416\u0418\u0428", "W", null);
            RailwayStationsDataProvider.put("5100091", "5100091", "\u041f\u0418\u041b\u0410", "\u041f\u0418\u041b\u0410", "W", null);
            RailwayStationsDataProvider.put("5100185", "5100185", "\u0429\u0415\u0426\u0418\u041d\u0415\u041a", "\u0429\u0415\u0426\u0418\u041d\u0415\u041a", "W", null);
            RailwayStationsDataProvider.put("5100653", "5100653", "\u0421\u0422\u0410\u041b \u0412\u041e\u041b\u042f", "\u0421\u0422\u0410\u041b\u0415\u0412\u0410 \u0412\u041e\u041b\u042f", "W", null);
            RailwayStationsDataProvider.put("5100182", "5100182", "\u0421 \u0412\u041e\u041b\u042f \u0420\u041e\u0417", "\u0421\u0422\u0410\u041b\u0415\u0412\u0410 \u0412\u041e\u041b\u042f \u0420\u041e\u0417\u0412\u0410\u0414\u0423\u0412", "W", null);
            RailwayStationsDataProvider.put("5100117", "5100117", "\u0428\u0423\u0412\u0410\u041b\u041a\u0418", "\u0428\u0423\u0412\u0410\u041b\u041a\u0418", "W", null);
            RailwayStationsDataProvider.put("5100530", "5100530", "\u041d\u0410\u0421\u0418\u041b\u0421\u041a", "\u041d\u0410\u0421\u0418\u041b\u0421\u041a", "W", null);
            RailwayStationsDataProvider.put("5350691", "5350691", "\u041c\u042d\u0420\u042d\u0428\u042d\u0428\u0422\u0418", "\u041c\u042d\u0420\u042d\u0428\u042d\u0428\u0422\u0418", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5351798", "5351798", "\u0412\u0418\u041a\u0428\u0410\u041d\u0418", "\u0412\u0418\u041a\u0428\u0410\u041d\u0418", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5380892", "5380892", "\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0426\u0410", "\u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0426\u0410", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5310445", "5310445", "\u0420\u041e\u0428\u0418\u041e\u0420\u0418", "\u0420\u041e\u0428\u0418\u041e\u0420\u0418", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5310770", "5310770", "\u041a\u0420\u0410\u0419\u041e\u0412\u0410", "\u041a\u0420\u0410\u0419\u041e\u0412\u0410", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5311231", "5311231", "\u041e\u0420\u0428\u041e\u0412\u0410", "\u041e\u0420\u0428\u041e\u0412\u0410", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5360658", "5360658", "\u0412\u0410\u0421\u041b\u0423\u0419", "\u0412\u0410\u0421\u041b\u0423\u0419", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5300225", "5300225", "\u0411\u042b\u0420\u041b\u0410\u0414", "\u0411\u042b\u0420\u041b\u0410\u0414", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5353007", "5353007", "\u041e\u041d\u0415\u0428\u0422\u0418", "\u041e\u041d\u0415\u0428\u0422\u0418", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5340373", "5340373", "\u041c\u0415\u0420\u041a\u0423\u0420 \u0427\u0423\u041a", "\u041c\u0415\u0420\u041a\u0423\u0420\u042f \u0427\u0423\u041a", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5453863", "5453863", "\u0423\u0421\u0422\u0418 \u041d \u041e\u0420\u041b", "\u0423\u0421\u0422\u0418 \u041d\u0410\u0414 \u041e\u0420\u041b\u0418\u0426\u0415", "V", null);
            RailwayStationsDataProvider.put("5514175", "5514175", "\u0417\u0410\u0425\u041e\u041d\u042c", "\u0417\u0410\u0425\u041e\u041d\u042c", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5514019", "5514019", "\u041d\u042c\u0418\u0420\u0415\u0414\u042c\u0425\u0410\u0417", "\u041d\u042c\u0418\u0420\u0415\u0414\u042c\u0425\u0410\u0417\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5513912", "5513912", "\u0414\u0415\u0411\u0420\u0415\u0426\u0415\u041d", "\u0414\u0415\u0411\u0420\u0415\u0426\u0415\u041d", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5513847", "5513847", "\u041a\u0410\u0420\u0426\u0410\u0413", "\u041a\u0410\u0420\u0426\u0410\u0413", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5513748", "5513748", "\u0421\u041e\u041b\u042c\u041d\u041e\u041a", "\u0421\u041e\u041b\u042c\u041d\u041e\u041a", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5513722", "5513722", "\u0426\u0415\u0413\u041b\u0415\u0414", "\u0426\u0415\u0413\u041b\u0415\u0414", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5510033", "5510033", "\u0411\u0423\u0414\u0410\u041f \u041d\u042c\u042e\u0413", "\u0411\u0423\u0414\u0410\u041f\u0415\u0428\u0422 \u041d\u042c\u042e\u0413\u0410\u0422\u0418 \u041f\u0423", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5510017", "5510017", "\u0411\u0423\u0414\u0410\u041f\u0415\u0428\u0422 \u041a", "\u0411\u0423\u0414\u0410\u041f\u0415\u0428\u0422 \u041a\u0415\u041b\u0415\u0422\u0418", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501024", "5501024", "\u0411\u0423\u0414 \u041a\u0415\u041b\u0415\u041d\u0424", "\u0411\u0423\u0414\u0410\u041f\u0415\u0428\u0422-\u041a\u0415\u041b\u0415\u041d\u0424\u0415\u041b\u042c", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503269", "5503269", "\u0421\u0415\u041a\u0415\u0428\u0424\u0415\u0425\u0415\u0420", "\u0421\u0415\u041a\u0415\u0428\u0424\u0415\u0425\u0415\u0420\u0412\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503350", "5503350", "\u0428\u0418\u041e\u0424\u041e\u041a", "\u0428\u0418\u041e\u0424\u041e\u041a", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503392", "5503392", "\u0417\u0410\u041c\u0410\u0420\u0414\u0418", "\u0417\u0410\u041c\u0410\u0420\u0414\u0418", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503418", "5503418", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0424\u0415\u041b", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0424\u0415\u041b\u0414\u0412\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503426", "5503426", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0428\u0410\u0420", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0428\u0410\u0420\u0421\u041e", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503434", "5503434", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0421\u0415\u041c", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0421\u0415\u041c\u0415\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503459", "5503459", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u041b\u0415\u041b", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u041b\u0415\u041b\u041b\u0415", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503475", "5503475", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0411\u041e\u0413", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0411\u041e\u0413\u041b\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503491", "5503491", "\u0424\u041e\u041d\u042c\u041e\u0414", "\u0424\u041e\u041d\u042c\u041e\u0414", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503525", "5503525", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0424\u0415\u041d", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0424\u0415\u041d\u0418\u0412\u0415\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503541", "5503541", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u041c\u0410\u0420", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u041c\u0410\u0420\u0418\u0410\u0424\u0423\u0415\u0420\u0414\u0415", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503566", "5503566", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0421\u0415\u041d", "\u0411\u0410\u041b\u0410\u0422\u041e\u041d\u0421\u0415\u041d\u0413\u042e\u0415\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503657", "5503657", "\u0417\u0410\u041b\u0410\u041a\u041e\u041c\u0410\u0420", "\u0417\u0410\u041b\u0410\u041a\u041e\u041c\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503624", "5503624", "\u041d\u0410\u0414\u042c\u041a\u0410\u041d\u0418\u0416\u0410", "\u041d\u0410\u0414\u042c\u041a\u0410\u041d\u0418\u0416\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5506437", "5506437", "\u0414\u042c\u0415\u041a\u0415\u041d\u0415\u0428", "\u0414\u042c\u0415\u041a\u0415\u041d\u0415\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5517111", "5517111", "\u041a\u0415\u0427\u041a\u0415\u041c\u0415\u0422", "\u041a\u0415\u0427\u041a\u0415\u041c\u0415\u0422", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5517137", "5517137", "\u041a\u0418\u0428\u041a\u0423\u041d\u0424\u0415\u041b\u0415", "\u041a\u0418\u0428\u041a\u0423\u041d\u0424\u0415\u041b\u0415\u0414\u042c\u0425\u0410\u0417\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5516311", "5516311", "\u041a\u0418\u0428\u041a\u0423\u041d\u0425\u0410\u041b\u0410", "\u041a\u0418\u0428\u041a\u0423\u041d\u0425\u0410\u041b\u0410\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5516352", "5516352", "\u041a\u0415\u041b\u0415\u0411\u0418\u042f", "\u041a\u0415\u041b\u0415\u0411\u0418\u042f", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5505876", "5505876", "\u041f\u0423\u0421\u0422\u0410\u0421\u0410\u0411\u041e\u041b", "\u041f\u0423\u0421\u0422\u0410\u0421\u0410\u0411\u041e\u041b\u042c\u0427", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5506189", "5506189", "\u0414\u041e\u041c\u0411\u041e\u0412\u0410\u0420", "\u0414\u041e\u041c\u0411\u041e\u0412\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5506288", "5506288", "\u041a\u0410\u041f\u041e\u0428\u0412\u0410\u0420", "\u041a\u0410\u041f\u041e\u0428\u0412\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5503640", "5503640", "\u041c\u0423\u0420\u0410\u041a\u0415\u0420\u0415\u0421\u0422", "\u041c\u0423\u0420\u0410\u041a\u0415\u0420\u0415\u0421\u0422\u0423\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501222", "5501222", "\u041a\u041e\u041c\u0410\u0420\u041e\u041c", "\u041a\u041e\u041c\u0410\u0420\u041e\u041c", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501289", "5501289", "\u0414\u042c\u0415\u0420", "\u0414\u042c\u0415\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501347", "5501347", "\u041c\u041e\u0421\u041e\u041d\u041c\u0410\u0414\u042c\u042f", "\u041c\u041e\u0421\u041e\u041d\u041c\u0410\u0414\u042c\u042f\u0420\u041e\u0412\u0410\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501362", "5501362", "\u0425\u0415\u0414\u042c\u0415\u0428\u0425\u0410\u041b", "\u0425\u0415\u0414\u042c\u0415\u0428\u0425\u0410\u041b\u041e\u041c", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5517228", "5517228", "\u0421\u0415\u0413\u0415\u0414", "\u0421\u0415\u0413\u0415\u0414", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5517673", "5517673", "\u0420\u041e\u0417\u041a\u0415", "\u0420\u041e\u0417\u041a\u0415", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5510504", "5510504", "\u0421\u041e\u0411", "\u0421\u041e\u0411", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5510447", "5510447", "\u0412\u0410\u0426", "\u0412\u0410\u0426", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5516204", "5516204", "\u041a\u0423\u041d\u0421\u0415\u041d\u0422\u041c\u0418\u041a", "\u041a\u0423\u041d\u0421\u0415\u041d\u0422\u041c\u0418\u041a\u041b\u041e\u0428-\u0422\u0410\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5516238", "5516238", "\u0424\u0423\u0415\u041b\u041e\u041f\u0421\u0410\u041b\u0410", "\u0424\u0423\u0415\u041b\u041e\u041f\u0421\u0410\u041b\u0410\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5516261", "5516261", "\u041a\u0418\u0428\u041a\u041e\u0420\u041e\u0428", "\u041a\u0418\u0428\u041a\u041e\u0420\u041e\u0428", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501164", "5501164", "\u0422\u0410\u0422\u0410", "\u0422\u0410\u0422\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501131", "5501131", "\u0422\u0410\u0422\u0410\u0411\u0410\u041d\u0418\u042f", "\u0422\u0410\u0422\u0410\u0411\u0410\u041d\u0418\u042f", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501081", "5501081", "\u0411\u0418\u0421\u041a\u0415", "\u0411\u0418\u0421\u041a\u0415", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5502329", "5502329", "\u0421\u0415\u041d\u0422\u0413\u041e\u0414\u0425\u0410\u0420", "\u0421\u0415\u041d\u0422\u0413\u041e\u0414\u0425\u0410\u0420\u0414", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5502287", "5502287", "\u041a\u0415\u0420\u041c\u0415\u041d\u0414", "\u041a\u0415\u0420\u041c\u0415\u041d\u0414", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5502246", "5502246", "\u0421\u041e\u041c\u0411\u0410\u0422\u0425\u0415\u0419", "\u0421\u041e\u041c\u0411\u0410\u0422\u0425\u0415\u0419", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5501974", "5501974", "\u0420\u0410\u0419\u041a\u0410", "\u0420\u0410\u0419\u041a\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8300250", "8300250", "\u041f\u041e\u0420\u0422\u041e\u0413\u0420\u0423\u0410\u0420", "\u041f\u041e\u0420\u0422\u041e\u0413\u0420\u0423\u0410\u0420\u041e", "1", "\u0418\u0442\u0430\u043b\u0438\u044f");
            RailwayStationsDataProvider.put("8700216", "8700216", "\u0416\u0415\u041c\u041e\u041d\u0422", "\u0416\u0415\u041c\u041e\u041d\u0422", "4", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f");
            RailwayStationsDataProvider.put("8800917", "8800917", "\u041e\u0421\u0422\u0415\u041d\u0414\u0415", "\u041e\u0421\u0422\u0415\u041d\u0414\u0415", "&", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f");
            RailwayStationsDataProvider.put("8899910", "8899910", "\u0417\u0410\u041f \u041a\u041e\u0414", "\u0417\u0410\u041f \u041a\u041e\u0414", "&", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f");
            RailwayStationsDataProvider.put("2001440", "2001440", "\u041e\u041f 536 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 536 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2208457", "2208457", "\u0418\u0412\u0410\u041d\u041e\u0412\u041a\u0410", "\u0418\u0412\u0410\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2100098", "2100098", "\u0422\u0410\u0422\u0410\u0420\u041a\u0410", "\u0422\u0410\u0422\u0410\u0420\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100164", "2100164", "\u041d\u0415\u041c\u0410\u041d", "\u041d\u0415\u041c\u0410\u041d", "\u0411", null);
            RailwayStationsDataProvider.put("2100238", "2100238", "\u0411\u042b\u0427\u0418\u0425\u0410", "\u0411\u042b\u0427\u0418\u0425\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2101001", "2101001", "\u041f\u0420\u0418\u041f\u042f\u0422\u042c", "\u041f\u0420\u0418\u041f\u042f\u0422\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2200197", "2200197", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u041a 2", "\u041a\u0410\u041b\u0418\u041d\u041e\u0412\u041a\u0410 2", "\u041a", null);
            RailwayStationsDataProvider.put("2214171", "2214171", "\u0411\u0410\u0420\u041e\u041d\u0421\u041a\u0410\u042f", "\u0411\u0410\u0420\u041e\u041d\u0421\u041a\u0410\u042f", "\u0414", null);
            RailwayStationsDataProvider.put("2044895", "2044895", "\u041e\u041f 22 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 22 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("5199051", "5199051", "\u041a\u0420\u0410\u041a\u041e\u0412", "\u041a\u0420\u0410\u041a\u041e\u0412", "W", null);
            RailwayStationsDataProvider.put("2100668", "2100668", "\u0412\u0410\u0421\u042c\u041a\u041e\u0412\u0429\u0418\u0417", "\u0412\u0410\u0421\u042c\u041a\u041e\u0412\u0429\u0418\u0417\u041d\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2002963", "2002963", "\u041e\u041f 406 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 406 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2208003", "2208003", "\u041e\u041f 25 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 25 \u041a\u041c", "\u0428", null);
            RailwayStationsDataProvider.put("2204040", "2204040", "\u041e\u041f 727 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 727 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204041", "2204041", "\u041e\u041f 104 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 104 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204032", "2204032", "\u0421\u041e\u041b\u042f\u041d\u0418\u041a\u041e\u0412\u041a", "\u0421\u041e\u041b\u042f\u041d\u0418\u041a\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2204036", "2204036", "\u041e\u041f 127 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 127 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204037", "2204037", "\u041e\u041f 17 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 17 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204038", "2204038", "\u041e\u041f 23 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 23 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204039", "2204039", "\u041e\u041f 34 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 34 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2210051", "2210051", "\u041e\u041f 1005 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1005 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210050", "2210050", "\u041e\u041f 1012 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1012 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210056", "2210056", "\u041e\u041f 1061 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1061 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210071", "2210071", "\u041e\u041f 1226 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1226 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210070", "2210070", "\u041e\u041f 1237 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1237 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210069", "2210069", "\u041e\u041f 1240 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1240 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210068", "2210068", "\u041e\u041f 1267 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1267 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210067", "2210067", "\u041e\u041f 1361 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1361 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210072", "2210072", "\u041e\u041f 1370 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1370 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("56513", "56513", "\u0417\u0412\u0410\u0420\u0414/\u0421\u041a\u0410\u041b", "\u0417\u0412\u0410\u0420\u0414\u041e\u041d/\u0421\u041a\u0410\u041b\u0418\u0422\u0415", "W", null);
            RailwayStationsDataProvider.put("1000240", "1000240", "\u042e\u0412\u042f\u0421\u041a\u042e\u041b\u042f", "\u042e\u0412\u042f\u0421\u041a\u042e\u041b\u042f", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000387", "1000387", "\u041a\u0410\u042f\u041d\u0418", "\u041a\u0410\u042f\u041d\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000420", "1000420", "\u0418\u0419\u0421\u0410\u041b\u041c\u0418", "\u0418\u0419\u0421\u0410\u041b\u041c\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000364", "1000364", "\u0420\u041e\u0412\u0410\u041d\u0418\u0415\u041c\u0418", "\u0420\u041e\u0412\u0410\u041d\u0418\u0415\u041c\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000347", "1000347", "\u041a\u0415\u041c\u0418", "\u041a\u0415\u041c\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000370", "1000370", "\u041e\u0423\u041b\u0423", "\u041e\u0423\u041b\u0423", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000280", "1000280", "\u0421\u0415\u0419\u041d\u042f\u0419\u041e\u041a\u0418", "\u0421\u0415\u0419\u041d\u042f\u0419\u041e\u041a\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000160", "1000160", "\u0422\u0410\u041c\u041f\u0415\u0420\u0415", "\u0422\u0410\u041c\u041f\u0415\u0420\u0415", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000408", "1000408", "\u041a\u0423\u041e\u041f\u0418\u041e", "\u041a\u0423\u041e\u041f\u0418\u041e", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000400", "1000400", "\u041f\u0418\u0415\u041a\u0421\u042f\u041c\u042f\u041a\u0418", "\u041f\u0418\u0415\u041a\u0421\u042f\u041c\u042f\u041a\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000546", "1000546", "\u041c\u0418\u041a\u041a\u0415\u041b\u0418", "\u041c\u0418\u041a\u041a\u0415\u041b\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000001", "1000001", "\u0425\u0415\u041b\u042c\u0421\u0418\u041d\u041a\u0418", "\u0425\u0415\u041b\u042c\u0421\u0418\u041d\u041a\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("25262", "25262", "\u0420\u0423\u0418\u0415\u041d-\u041c\u042b\u0419\u0417", "\u0420\u0423\u0418\u0415\u041d\u0410-\u041c\u042b\u0419\u0417\u0410\u041a\u042e\u041b\u0410 \u0413\u0420\u0410\u041d", "R", null);
            RailwayStationsDataProvider.put("27591", "27591", "\u041b\u0423\u0413-\u041f\u041b 15", "\u041b\u0423\u0413\u041e\u0412\u0410\u042f-\u041f\u041b.15 \u041a\u041c \u0413\u0420", "Y", null);
            RailwayStationsDataProvider.put("29591", "29591", "\u0421\u0410\u0412\u0410\u0419-\u041a\u0410\u0420\u0410", "\u0421\u0410\u0412\u0410\u0419-\u041a\u0410\u0420\u0410\u0421\u0423 \u0413\u0420", "\u0424", null);
            RailwayStationsDataProvider.put("29592", "29592", "\u041a\u0410\u0420\u0410\u0421\u0423-\u0421\u0423\u041b", "\u041a\u0410\u0420\u0410\u0421\u0423-\u0421\u0423\u041b\u0422 \u0413\u0420", "\u0424", null);
            RailwayStationsDataProvider.put("29593", "29593", "\u0423\u0427\u041a\u0423\u0420\u0413-\u0428\u0410\u041c", "\u0423\u0427\u041a\u0423\u0420\u0413-\u0428\u0410\u041c\u0410\u041b\u0414 \u0413\u0420", "\u0424", null);
            RailwayStationsDataProvider.put("29672", "29672", "\u0422\u0410\u041b\u0418\u041c-153", "\u0422\u0410\u041b\u0418\u041c\u0410\u0420\u0414\u0416\u0410\u041d-\u0420\u0417\u0414 153 \u041a\u041c", "\u0424", null);
            RailwayStationsDataProvider.put("29673", "29673", "\u0422\u0410\u0425\u0418-\u041d\u0410\u0419\u041c", "\u0422\u0410\u0425\u0418\u0410\u0422\u0410\u0428-\u041d\u0410\u0419\u041c\u0410\u041d\u041a\u0423\u041b\u042c \u0413\u0420", "U", null);
            RailwayStationsDataProvider.put("29677", "29677", "\u041c\u0418\u0421\u041a-\u0413\u0410\u0417\u041e\u0414", "\u041c\u0418\u0421\u041a\u0418\u041d-\u0413\u0410\u0417\u0410\u0414\u0416\u0410\u041a", "\u0424", null);
            RailwayStationsDataProvider.put("29662", "29662", "\u0410\u041c\u0423\u0417-\u0410\u0419\u0412\u0410\u0414", "\u0410\u041c\u0423\u0417\u0410\u041d\u0413-\u0410\u0419\u0412\u0410\u0414\u0416", "\u0424", null);
            RailwayStationsDataProvider.put("29674", "29674", "\u0411\u041e\u041b\u0414\u042b\u0420-161", "\u0411\u041e\u041b\u0414\u042b\u0420-\u0420\u0417\u0414 161 \u041a\u041c \u0413\u0420", "\u0424", null);
            RailwayStationsDataProvider.put("29663", "29663", "\u0421\u0410\u0420-\u041f\u0410\u0425\u0422\u0410", "\u0421\u0410\u0420\u042b\u0410\u0421\u0418\u042f-\u041f\u0410\u0425\u0422\u0410\u0410\u0411\u0410\u0414", "N", null);
            RailwayStationsDataProvider.put("29675", "29675", "\u0413\u0410\u0417\u041e\u0414\u0416-\u041f\u0418\u0422", "\u0413\u0410\u0417\u041e\u0414\u0416\u0410\u041a-\u041f\u0418\u0422\u041d\u042f\u041a \u0413\u0420", "\u0424", null);
            RailwayStationsDataProvider.put("29676", "29676", "\u0414\u0410\u0428\u041e-\u0428\u0410\u0412\u0410\u0422", "\u0414\u0410\u0428\u041e\u0413\u0423\u0417-\u0428\u0410\u0412\u0410\u0422 \u0413\u0420", "U", null);
            RailwayStationsDataProvider.put("29664", "29664", "\u041d\u0410\u0423-\u0411\u0415\u041a\u0410\u0411", "\u041d\u0410\u0423-\u0411\u0415\u041a\u0410\u0411\u0410\u0414", "\u0424", null);
            RailwayStationsDataProvider.put("29671", "29671", "\u0424\u0410\u0420\u0410\u041f-\u0425\u041e\u0414\u0416", "\u0424\u0410\u0420\u0410\u041f-\u0425\u041e\u0414\u0416\u0410\u0414\u0410\u0412\u041b\u0415\u0422 \u0413\u0420", "U", null);
            RailwayStationsDataProvider.put("29661", "29661", "\u041a\u0410\u041d\u0418\u0411-\u0421\u0423\u0412\u041e", "\u041a\u0410\u041d\u0418\u0411\u0410\u0414\u0410\u041c-\u0421\u0423\u0412\u041e\u041d\u041e\u0411\u041e\u0414", "\u0424", null);
            RailwayStationsDataProvider.put("2000019", "2000019", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d  2", "\u0410\u041b\u0415\u041a\u0421\u0410\u041d\u0414\u0420\u041e\u0412 2", "\u041c", null);
            RailwayStationsDataProvider.put("71871", "71871", "\u0418\u0420\u0423\u041d-\u0410\u041d\u0414\u0410\u0419", "\u0418\u0420\u0423\u041d-\u0410\u041d\u0414\u0410\u0419", "4", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f");
            RailwayStationsDataProvider.put("27331", "27331", "\u0414\u041e\u0421\u0422-\u0410\u041b\u0410\u0428", "\u0414\u041e\u0421\u0422\u042b\u041a-\u0410\u041b\u0410\u0428\u0410\u041d\u042c\u041a\u041e\u0423", "?", "\u041a\u0438\u0442\u0430\u0439");
            RailwayStationsDataProvider.put("56551", "56551", "\u041a\u041e\u041c\u0410\u0420-\u041a\u041e\u041c", "\u041a\u041e\u041c\u0410\u0420\u041e\u041c-\u041a\u041e\u041c\u0410\u0420\u041d\u041e", "Q", null);
            RailwayStationsDataProvider.put("55812", "55812", "\u0421\u0415\u041d\u0422-\u0424\u0415\u0420\u0418\u041d", "\u0421\u0415\u041d\u0422\u0413\u041e\u0414\u0425\u0410\u0420\u0414-\u0424\u0415\u0420\u0418\u041d\u0413", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("79812", "79812", "\u0428\u041f\u0418\u041b\u042c-\u041c\u0410\u0420\u0418", "\u0428\u041f\u0418\u041b\u042c\u0424\u0415\u041b\u042c\u0414-\u041c\u0410\u0420\u0418\u0411\u041e\u0420\u041d", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("27291", "27291", "\u041e\u0410\u0417\u0418\u0421-\u041a\u0410\u0420\u0410", "\u041e\u0410\u0417\u0418\u0421-\u041a\u0410\u0420\u0410\u041a\u0410\u041b\u041f\u0410\u041a\u0418\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("27292", "27292", "\u0421\u0410\u0420\u042b-\u041a\u0415\u041b\u0415\u0421", "\u0421\u0410\u0420\u042b-\u0410\u0413\u0410\u0427-\u041a\u0415\u041b\u0415\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("27293", "27293", "\u041f\u0410\u0425\u0422-\u0421\u042b\u0420\u0414\u0410", "\u041f\u0410\u0425\u0422\u0410\u0410\u0420\u0410\u041b-\u0421\u042b\u0420\u0414\u0410\u0420\u042c\u0418\u041d\u0421\u041a\u0410", "\u0426", null);
            RailwayStationsDataProvider.put("56811", "56811", "\u041a\u0418\u0422\u0422\u0417-\u041a\u0418\u0422\u0417", "\u041a\u0418\u0422\u0422\u0417\u0415\u0415-\u041a\u0418\u0422\u0422\u0417\u0415\u0415", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("56553", "56553", "\u0420\u0410\u0419\u041a-\u0420\u0423\u0421\u041e\u0412", "\u0420\u0410\u0419\u041a\u0410-\u0420\u0423\u0421\u041e\u0412\u0426\u0415", "Q", null);
            RailwayStationsDataProvider.put("1000492", "1000492", "\u0412\u0410\u0419\u041d\u0418\u041a\u041a\u0410\u041b\u0410", "\u0412\u0410\u0419\u041d\u0418\u041a\u041a\u0410\u041b\u0410", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000130", "1000130", "\u0422\u0423\u0420\u041a\u0423", "\u0422\u0423\u0420\u041a\u0423", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("2000039", "2000039", "\u0412\u041e\u0421\u041a\u0420\u0415\u0421\u0415\u041d", "\u0412\u041e\u0421\u041a\u0420\u0415\u0421\u0415\u041d\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2210066", "2210066", "\u041e\u041f 1518 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1518 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210047", "2210047", "\u041e\u041f 140 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 140 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210048", "2210048", "\u041e\u041f 160 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 160 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210049", "2210049", "\u041e\u041f 162 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 162 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210055", "2210055", "\u041e\u041f 252 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 252 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210046", "2210046", "\u041e\u041f 121 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 121 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210053", "2210053", "\u041e\u041f 90 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 90 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210052", "2210052", "\u041e\u041f 80 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 80 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210054", "2210054", "\u041e\u041f 125 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 125 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210058", "2210058", "\u041e\u041f 7 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 7 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210059", "2210059", "\u041e\u041f 28 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 28 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210060", "2210060", "\u041e\u041f 35 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 35 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210061", "2210061", "\u041e\u041f 58 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 58 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210062", "2210062", "\u041e\u041f 62 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 62 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210063", "2210063", "\u041e\u041f 73 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 73 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210057", "2210057", "\u041e\u041f 211 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 211 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210065", "2210065", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210064", "2210064", "\u041e\u041f 13 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 13 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2210073", "2210073", "\u041e\u041f 106 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 106 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2708962", "2708962", "\u0410\u041a\u0422\u0410\u0419", "\u0410\u041a\u0422\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2704844", "2704844", "\u0410\u041b\u0416\u0410\u041d", "\u0410\u041b\u0416\u0410\u041d", "\u0426", null);
            RailwayStationsDataProvider.put("2700724", "2700724", "\u0421\u0423\u042b\u0420\u041b\u042b", "\u0421\u0423\u042b\u0420\u041b\u042b", "\u0426", null);
            RailwayStationsDataProvider.put("2034617", "2034617", "\u0414\u0415\u041f\u041e", "\u0414\u0415\u041f\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2100146", "2100146", "\u041c\u0418\u041a\u0410\u0428\u0415\u0412\u0418\u0427\u0418", "\u041c\u0418\u041a\u0410\u0428\u0415\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100926", "2100926", "\u0421\u041d\u0418\u0422\u041e\u0412\u041e", "\u0421\u041d\u0418\u0422\u041e\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100186", "2100186", "\u0422\u0420\u0423\u0414\u041e\u0412\u0410\u042f", "\u0422\u0420\u0423\u0414\u041e\u0412\u0410\u042f", "\u0411", null);
            RailwayStationsDataProvider.put("2100925", "2100925", "\u0427\u0415\u0420\u0415\u0412\u0410\u0427\u0418\u0426\u042b", "\u0427\u0415\u0420\u0415\u0412\u0410\u0427\u0418\u0426\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2101034", "2101034", "\u041b\u042e\u0411\u0410\u0428\u0415\u0412\u041e", "\u041b\u042e\u0411\u0410\u0428\u0415\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100169", "2100169", "\u0421\u041a\u0418\u0414\u0415\u041b\u042c", "\u0421\u041a\u0418\u0414\u0415\u041b\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2208005", "2208005", "\u0414\u0410\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u0414\u0410\u041d\u0418\u041b\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208004", "2208004", "\u0417 \u041a\u041e\u0420\u042b\u0421\u0422\u042c", "\u0417\u0410\u0413\u0410\u041b\u042c\u041d\u0410\u042f \u041a\u041e\u0420\u042b\u0421\u0422\u042c", "\u0428", null);
            RailwayStationsDataProvider.put("2208007", "2208007", "\u041d\u041e\u0412.\u0421\u0422\u0415\u041f\u042c", "\u041d\u041e\u0412\u0410\u042f \u0421\u0422\u0415\u041f\u042c", "\u0428", null);
            RailwayStationsDataProvider.put("2208008", "2208008", "\u041a\u041e\u0421\u0422\u041e\u0413\u0420\u042b\u0417", "\u041a\u041e\u0421\u0422\u041e\u0413\u0420\u042b\u0417\u041e\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208102", "2208102", "\u0414\u0423\u0411\u041a\u0418", "\u0414\u0423\u0411\u041a\u0418", "\u0428", null);
            RailwayStationsDataProvider.put("2208006", "2208006", "\u041d\u041e\u0412\u041e\u041f\u0410\u0412\u041b\u041e\u0412", "\u041d\u041e\u0412\u041e\u041f\u0410\u0412\u041b\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208525", "2208525", "\u0422\u0423\u0420\u041a\u0423\u041b\u042b", "\u0422\u0423\u0420\u041a\u0423\u041b\u042b", "\u0428", null);
            RailwayStationsDataProvider.put("2204044", "2204044", "\u041e\u041f 798 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 798 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204045", "2204045", "\u041e\u041f 780 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 780 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204046", "2204046", "\u041e\u041f 750 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 750 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204043", "2204043", "\u041e\u041f 668 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 668 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204042", "2204042", "\u041e\u041f 58 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 58 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204192", "2204192", "\u0417\u0412\u0415\u0417\u0414\u0418\u041b\u041e\u0412\u041a", "\u0417\u0412\u0415\u0417\u0414\u0418\u041b\u041e\u0412\u041a\u0410", "\u042e", null);
            RailwayStationsDataProvider.put("2064978", "2064978", "\u0422\u0415\u0420\u041d\u041e\u0412\u042b\u0419", "\u0422\u0415\u0420\u041d\u041e\u0412\u042b\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2065026", "2065026", "\u041e\u041f 1229 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 1229 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2208483", "2208483", "\u0410\u041a\u041a\u0410\u0420\u0416\u0410", "\u0410\u041a\u041a\u0410\u0420\u0416\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("5100088", "5100088", "\u041e\u0421\u0412\u0415\u041d\u0426\u0418\u041c", "\u041e\u0421\u0412\u0415\u041d\u0426\u0418\u041c", "W", null);
            RailwayStationsDataProvider.put("5100110", "5100110", "\u0421\u0410\u041d\u041e\u041a", "\u0421\u0410\u041d\u041e\u041a", "W", null);
            RailwayStationsDataProvider.put("2200028", "2200028", "\u0413\u0420\u0423\u0417\u0421\u041a\u041e\u0415", "\u0413\u0420\u0423\u0417\u0421\u041a\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2208435", "2208435", "\u041f\u041e\u041f\u0415\u041b\u042e\u0425\u0418", "\u041f\u041e\u041f\u0415\u041b\u042e\u0425\u0418", "\u0428", null);
            RailwayStationsDataProvider.put("2208398", "2208398", "\u0428\u0415\u0421\u0422\u0410\u041a\u041e\u0412\u041a\u0410", "\u0428\u0415\u0421\u0422\u0410\u041a\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208301", "2208301", "\u0411\u041e\u041b\u0413\u0420\u0410\u0414", "\u0411\u041e\u041b\u0413\u0420\u0410\u0414", "\u0428", null);
            RailwayStationsDataProvider.put("2210820", "2210820", "\u0423\u0420\u041e\u0416\u0410\u0419\u041d\u0410\u042f", "\u0423\u0420\u041e\u0416\u0410\u0419\u041d\u0410\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("2208495", "2208495", "\u0410\u041b\u0418\u042f\u0413\u0410", "\u0410\u041b\u0418\u042f\u0413\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208496", "2208496", "\u0414\u0417\u0418\u041d\u0418\u041b\u041e\u0420", "\u0414\u0417\u0418\u041d\u0418\u041b\u041e\u0420", "\u0428", null);
            RailwayStationsDataProvider.put("2064354", "2064354", "\u0414\u0415\u0414\u0415\u0420\u041a\u041e\u0419", "\u0414\u0415\u0414\u0415\u0420\u041a\u041e\u0419", "\u0421", null);
            RailwayStationsDataProvider.put("2709807", "2709807", "\u0410\u0421\u0422\u0410\u041d\u0410 \u0411\u0416", "\u0410\u0421\u0422\u0410\u041d\u0410 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707610", "2707610", "\u0418\u0420\u0427\u0415\u041d\u041a\u041e \u0411\u0416", "\u0418\u0420\u0427\u0415\u041d\u041a\u041e \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707602", "2707602", "\u0411\u0410\u0411\u0410\u0422\u0410\u0419 \u0411\u0416", "\u0411\u0410\u0411\u0410\u0422\u0410\u0419 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707603", "2707603", "\u0412\u0418\u0428\u041d\u0415\u0412 \u0411\u0416", "\u0412\u0418\u0428\u041d\u0415\u0412 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707606", "2707606", "\u0415\u0420\u041a\u0418\u041d\u0428 \u0411\u0416", "\u0415\u0420\u041a\u0418\u041d\u0428 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707605", "2707605", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420 \u0411\u0416", "\u0414\u0416\u0410\u041b\u0422\u042b\u0420 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707607", "2707607", "\u0415\u0420\u041c\u0415\u041d\u0422 \u0411\u0416", "\u0415\u0420\u041c\u0415\u041d\u0422 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707609", "2707609", "\u0416\u0410\u041a\u0421\u042b \u0411\u0416", "\u0416\u0410\u041a\u0421\u042b \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707601", "2707601", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420 \u0411\u0416", "\u0410\u0422\u0411\u0410\u0421\u0410\u0420 \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2707608", "2707608", "\u0415\u0421\u0418\u041b\u042c \u0411\u0416", "\u0415\u0421\u0418\u041b\u042c \u0411\u0416", "\u0426", null);
            RailwayStationsDataProvider.put("2045801", "2045801", "\u041e\u041f 396 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 396 \u041a\u041c", "\u041d", null);
            RailwayStationsDataProvider.put("2034574", "2034574", "\u0423\u0414\u0410\u0420\u041d\u042b\u0419", "\u0423\u0414\u0410\u0420\u041d\u042b\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034575", "2034575", "\u041b\u0410\u0413\u0410\u0420 \u0410\u0423\u041b", "\u041b\u0410\u0413\u0410\u0420-\u0410\u0423\u041b", "\u042d", null);
            RailwayStationsDataProvider.put("2034577", "2034577", "\u041a\u0418\u041c\u041a\u0410\u041d", "\u041a\u0418\u041c\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034593", "2034593", "\u0411\u0418\u0420\u0410\u041a\u0410\u041d", "\u0411\u0418\u0420\u0410\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034780", "2034780", "\u0422\u0415\u041f\u041b \u041e\u0417\u0415\u0420\u041e", "\u0422\u0415\u041f\u041b\u041e\u0415 \u041e\u0417\u0415\u0420\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2034517", "2034517", "\u0418\u0417\u0412\u0415\u0421 \u0417\u0410\u0412", "\u0418\u0417\u0412\u0415\u0421\u0422\u041a\u041e\u0412\u042b\u0419 \u0417\u0410\u0412\u041e\u0414", "\u042d", null);
            RailwayStationsDataProvider.put("2034594", "2034594", "\u041b\u041e\u041d\u0414\u041e\u041a\u041e", "\u041b\u041e\u041d\u0414\u041e\u041a\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2034595", "2034595", "\u0411\u0423\u0414\u0423\u041a\u0410\u041d", "\u0411\u0423\u0414\u0423\u041a\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034596", "2034596", "\u0421\u0415\u041c\u0418\u0421\u0422\u041e\u0427\u041d", "\u0421\u0415\u041c\u0418\u0421\u0422\u041e\u0427\u041d\u042b\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034597", "2034597", "\u0422\u0420\u0415\u041a", "\u0422\u0420\u0415\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2034598", "2034598", "\u041a\u0418\u0420\u0413\u0410", "\u041a\u0418\u0420\u0413\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034606", "2034606", "\u0418\u041a\u0423\u0420\u0410", "\u0418\u041a\u0423\u0420\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034522", "2034522", "\u0423\u0421\u041e\u0412 \u0411\u0410\u041b\u0410\u0413", "\u0423\u0421\u041e\u0412 \u0411\u0410\u041b\u0410\u0413\u0410\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034608", "2034608", "\u0410\u0423\u0420", "\u0410\u0423\u0420", "\u042d", null);
            RailwayStationsDataProvider.put("2034609", "2034609", "\u041e\u041b\u042c", "\u041e\u041b\u042c", "\u042d", null);
            RailwayStationsDataProvider.put("2034790", "2034790", "\u0418\u041d", "\u0418\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2048113", "2048113", "\u0423\u0420\u041c\u0418", "\u0423\u0420\u041c\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2034611", "2034611", "\u041e\u041b\u042c\u0413\u041e\u0425\u0422\u0410", "\u041e\u041b\u042c\u0413\u041e\u0425\u0422\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2048112", "2048112", "\u041b\u0423\u041c\u041a\u0423 \u041a\u041e\u0420\u0410", "\u041b\u0423\u041c\u041a\u0423-\u041a\u041e\u0420\u0410\u041d\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2034612", "2034612", "\u0412\u041e\u041b\u041e\u0427\u0410\u0415\u0412 1", "\u0412\u041e\u041b\u041e\u0427\u0410\u0415\u0412\u041a\u0410 1", "\u042d", null);
            RailwayStationsDataProvider.put("2034613", "2034613", "\u0422\u0423\u041d\u0413\u0423\u0421\u0421\u041a\u0418\u0419", "\u0422\u0423\u041d\u0413\u0423\u0421\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034614", "2034614", "\u0414\u0415\u0416\u041d\u0415\u0412\u041a\u0410", "\u0414\u0415\u0416\u041d\u0415\u0412\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034726", "2034726", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041a\u0410", "\u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u041a\u0410", "\u042d", null);
            RailwayStationsDataProvider.put("2034615", "2034615", "\u041f\u0420\u0418\u0410\u041c\u0423\u0420\u0421\u041a", "\u041f\u0420\u0418\u0410\u041c\u0423\u0420\u0421\u041a\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("2035608", "2035608", "\u0411\u0418\u0420\u041e\u0411\u0418\u0414\u0416 2", "\u0411\u0418\u0420\u041e\u0411\u0418\u0414\u0416\u0410\u041d 2", "\u042d", null);
            RailwayStationsDataProvider.put("2034604", "2034604", "\u0411\u0418\u0420\u041e\u0424\u0415\u041b\u042c\u0414", "\u0411\u0418\u0420\u041e\u0424\u0415\u041b\u042c\u0414", "\u042d", null);
            RailwayStationsDataProvider.put("2034602", "2034602", "\u041a\u0420\u0410\u0421\u0418\u0412\u042b\u0419", "\u041a\u0420\u0410\u0421\u0418\u0412\u042b\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034601", "2034601", "\u0423\u041d\u0413\u0423\u041d", "\u0423\u041d\u0413\u0423\u041d", "\u042d", null);
            RailwayStationsDataProvider.put("2034599", "2034599", "\u0411\u0410\u0411\u0421\u0422\u041e\u0412\u041e", "\u0411\u0410\u0411\u0421\u0422\u041e\u0412\u041e", "\u042d", null);
            RailwayStationsDataProvider.put("2034482", "2034482", "\u041b\u0415\u041d\u0418\u041d\u0421\u041a", "\u041b\u0415\u041d\u0418\u041d\u0421\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("2034669", "2034669", "\u0412\u041e\u041b\u041e\u0427\u0410\u0415\u0412 2", "\u0412\u041e\u041b\u041e\u0427\u0410\u0415\u0412\u041a\u0410 2", "\u042d", null);
            RailwayStationsDataProvider.put("2201137", "2201137", "\u041a\u0423\u041a\u0418\u041b\u041a\u0410", "\u041a\u0423\u041a\u0418\u041b\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2208499", "2208499", "\u041f\u0410\u0420\u0418\u0416\u0421\u041a\u0410\u042f", "\u041f\u0410\u0420\u0418\u0416\u0421\u041a\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2900251", "2900251", "\u0411\u041e\u041b\u0414\u042b\u0420   *", "\u0411\u041e\u041b\u0414\u042b\u0420*", "\u0424", null);
            RailwayStationsDataProvider.put("2900253", "2900253", "\u041d\u0410\u0423\u0428\u0410\u0425\u0410\u0420 *", "\u041d\u0410\u0423\u0428\u0410\u0425\u0410\u0420*", "\u0424", null);
            RailwayStationsDataProvider.put("2900862", "2900862", "\u0414\u0416\u0410\u0420\u041a\u0423\u0420\u0413\u0410\u041d", "\u0414\u0416\u0410\u0420\u041a\u0423\u0420\u0413\u0410\u041d", "\u0424", null);
            RailwayStationsDataProvider.put("2900863", "2900863", "\u0421\u0423\u0420\u0425\u0410\u041d\u042b", "\u0421\u0423\u0420\u0425\u0410\u041d\u042b", "\u0424", null);
            RailwayStationsDataProvider.put("2900865", "2900865", "\u042d\u041b\u042c\u0411\u0410\u042f\u041d", "\u042d\u041b\u042c\u0411\u0410\u042f\u041d", "\u0424", null);
            RailwayStationsDataProvider.put("2900868", "2900868", "\u0421\u0410\u0420\u042b\u0410\u0421\u0418\u042f", "\u0421\u0410\u0420\u042b\u0410\u0421\u0418\u042f", "\u0424", null);
            RailwayStationsDataProvider.put("2900369", "2900369", "\u041e\u041f 4609 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4609 \u041a\u041c", "\u0424", null);
            RailwayStationsDataProvider.put("2900100", "2900100", "\u041a\u0423\u0414\u0423\u041a\u041b\u0418 \u042d\u041a", "\u041a\u0423\u0414\u0423\u041a\u041b\u0418 \u042d\u041a\u0421\u041f", "\u0424", null);
            RailwayStationsDataProvider.put("2034740", "2034740", "\u0423\u0413\u041e\u041b\u042c\u041d\u0410\u042f", "\u0423\u0413\u041e\u041b\u042c\u041d\u0410\u042f", "\u042d", null);
            RailwayStationsDataProvider.put("5613013", "5613013", "\u041c\u0410\u0420\u0422\u0418\u041d", "\u041c\u0410\u0420\u0422\u0418\u041d", "Q", null);
            RailwayStationsDataProvider.put("5613083", "5613083", "\u0422\u0423\u0420\u0427 \u0422\u0415\u041f\u041b", "\u0422\u0423\u0420\u0427\u0410\u041d\u0421\u041a\u0415 \u0422\u0415\u041f\u041b\u0418\u0426\u0415", "Q", null);
            RailwayStationsDataProvider.put("5613363", "5613363", "\u0411\u0410\u041d\u0421\u041a\u0410 \u0411\u0418\u0421", "\u0411\u0410\u041d\u0421\u041a\u0410 \u0411\u0418\u0421\u0422\u0420\u0418\u0426\u0410", "Q", null);
            RailwayStationsDataProvider.put("5613383", "5613383", "\u0411\u0410\u041d \u0411\u0418\u0421 \u041c", "\u0411\u0410\u041d\u0421\u041a\u0410 \u0411\u0418\u0421\u0422\u0420\u0418\u0426\u0410 \u041c\u0415\u0421\u0422\u041e", "Q", null);
            RailwayStationsDataProvider.put("5613443", "5613443", "\u0421\u041b\u0418\u0410\u0426 \u041a\u0423\u041f", "\u0421\u041b\u0418\u0410\u0426 \u041a\u0423\u041f\u0415\u041b\u0415", "Q", null);
            RailwayStationsDataProvider.put("5613263", "5613263", "\u0417\u0412\u041e\u041b\u0415\u041d \u041c\u0415\u0421", "\u0417\u0412\u041e\u041b\u0415\u041d \u041c\u0415\u0421\u0422\u041e", "Q", null);
            RailwayStationsDataProvider.put("5513888", "5513888", "\u0425\u0410\u0419\u0414\u0423\u0428\u041e\u0411\u041e\u0428", "\u0425\u0410\u0419\u0414\u0423\u0428\u041e\u0411\u041e\u0428\u041b\u041e", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5513862", "5513862", "\u041f\u042e\u0428\u041f\u0415\u041a\u041b\u0410\u0414", "\u041f\u042e\u0428\u041f\u0415\u041a\u041b\u0410\u0414\u0410\u041d\u042c", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("2600470", "2600470", "\u041f\u042f\u0420\u041d\u0423 \u0420\u0415\u0419\u0417", "\u041f\u042f\u0420\u041d\u0423 \u0420\u0415\u0419\u0417\u0418\u042f\u0410\u041c", "S", null);
            RailwayStationsDataProvider.put("2400315", "2400315", "\u041a\u0420\u042f\u0422\u0418\u041d\u0413\u0410\u041b\u0415", "\u041a\u0420\u042f\u0422\u0418\u041d\u0413\u0410\u041b\u0415", "L", null);
            RailwayStationsDataProvider.put("2401393", "2401393", "\u041a\u0423\u041b\u0423\u041f\u0415\u041d\u0410\u0419", "\u041a\u0423\u041b\u0423\u041f\u0415\u041d\u0410\u0419", "L", null);
            RailwayStationsDataProvider.put("2401392", "2401392", "\u0428\u0410\u0422\u0415\u0419\u041a\u042f\u0419", "\u0428\u0410\u0422\u0415\u0419\u041a\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2400390", "2400390", "\u041b\u0415\u041f\u041b\u0410\u0423\u041a\u0415", "\u041b\u0415\u041f\u041b\u0410\u0423\u041a\u0415", "L", null);
            RailwayStationsDataProvider.put("2400396", "2400396", "\u041f\u0410\u041f\u0418\u041b\u0415", "\u041f\u0410\u041f\u0418\u041b\u0415", "L", null);
            RailwayStationsDataProvider.put("2200761", "2200761", "\u0421\u0415\u041c\u0418\u041b\u0415\u0422\u041a\u0410", "\u0421\u0415\u041c\u0418\u041b\u0415\u0422\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2218232", "2218232", "\u0417\u0414\u041e\u041b\u0411\u0423\u041d \u042e\u0416", "\u0417\u0414\u041e\u041b\u0411\u0423\u041d\u041e\u0412 \u042e\u0416\u041d\u042b\u0419", "\u041b", null);
            RailwayStationsDataProvider.put("2708884", "2708884", "\u041a\u0410\u0417\u0410\u0425\u0421\u041a\u0410\u042f", "\u041a\u0410\u0417\u0410\u0425\u0421\u041a\u0410\u042f", "\u0426", null);
            RailwayStationsDataProvider.put("6700217", "6700217", "\u041c0\u041b\u041b\u0410\u041d\u0415\u041f\u0415\u0421", "\u041c\u041e\u041b\u041b\u0410\u041d\u0415\u041f\u0415\u0421", "U", null);
            RailwayStationsDataProvider.put("2030323", "2030323", "\u041b\u0418\u041c\u0411\u0415\u0419", "\u041b\u0418\u041c\u0411\u0415\u0419", "\u0415", null);
            RailwayStationsDataProvider.put("2218234", "2218234", "\u041e\u041f 39 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 39 \u041a\u041c", "\u041b", null);
            RailwayStationsDataProvider.put("2208497", "2208497", "\u041a\u041e\u0422\u041b\u0410\u0411\u0423\u0425", "\u041a\u041e\u0422\u041b\u0410\u0411\u0423\u0425", "\u0428", null);
            RailwayStationsDataProvider.put("2210750", "2210750", "\u0421\u0415\u0412\u0410\u0421\u0422\u041e\u041f", "\u0421\u0415\u0412\u0410\u0421\u0422\u041e\u041f\u041e\u041b\u042c", "\u041f", null);
            RailwayStationsDataProvider.put("2708808", "2708808", "\u041e\u0411\u041f N86", "\u041e\u0411\u0413\u041e\u041d\u041d\u042b\u0419 \u041f\u0423\u041d\u041a\u0422 N86", "\u0426", null);
            RailwayStationsDataProvider.put("1000018", "1000018", "\u0422\u0418\u041a\u041a\u0423\u0420\u0418\u041b\u0410", "\u0422\u0418\u041a\u041a\u0423\u0420\u0418\u041b\u0410", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("2208432", "2208432", "\u041a\u041d\u042f\u0416\u0415\u0412\u041e", "\u041a\u041d\u042f\u0416\u0415\u0412\u041e", "\u0428", null);
            RailwayStationsDataProvider.put("2208485", "2208485", "\u041a\u0410\u0420 \u0411\u0423\u0413\u0410\u0417", "\u041a\u0410\u0420\u041e\u041b\u0418\u041d\u041e-\u0411\u0423\u0413\u0410\u0417", "\u0428", null);
            RailwayStationsDataProvider.put("2208303", "2208303", "\u0420\u0415\u041d\u0418", "\u0420\u0415\u041d\u0418", "\u0428", null);
            RailwayStationsDataProvider.put("2014383", "2014383", "\u0411\u0415\u041b\u0415\u041d\u0418\u0425\u0418\u041d\u041e", "\u0411\u0415\u041b\u0415\u041d\u0418\u0425\u0418\u041d\u041e", "\u0412", null);
            RailwayStationsDataProvider.put("2100345", "2100345", "\u0418\u0412\u0410\u041a\u0418", "\u0418\u0412\u0410\u041a\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100211", "2100211", "\u0411\u041e\u0420\u041e\u041a", "\u0411\u041e\u0420\u041e\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2100062", "2100062", "\u0422\u0410\u041b\u042c\u041a\u0410", "\u0422\u0410\u041b\u042c\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100185", "2100185", "\u041f\u0423\u0425\u041e\u0412\u0418\u0427\u0418", "\u041f\u0423\u0425\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100671", "2100671", "\u0420\u0423\u0414\u0415\u041d\u0421\u041a", "\u0420\u0423\u0414\u0415\u041d\u0421\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2100111", "2100111", "\u041c\u0418\u0425\u0410\u041d\u041e\u0412\u0418\u0427\u0418", "\u041c\u0418\u0425\u0410\u041d\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100019", "2100019", "\u0427\u0415\u0420\u0412\u0415\u041d\u041e", "\u0427\u0415\u0420\u0412\u0415\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100016", "2100016", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u041e\u0421\u0418\u041d\u041e\u0412\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100103", "2100103", "\u0425\u041b\u042e\u0421\u0422\u0418\u041d\u041e", "\u0425\u041b\u042e\u0421\u0422\u0418\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100511", "2100511", "\u041a\u041e\u0425\u0410\u041d\u041e\u0412\u041e", "\u041a\u041e\u0425\u0410\u041d\u041e\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100014", "2100014", "\u0422\u041e\u041b\u041e\u0427\u0418\u041d", "\u0422\u041e\u041b\u041e\u0427\u0418\u041d", "\u0411", null);
            RailwayStationsDataProvider.put("2100013", "2100013", "\u0421\u041b\u0410\u0412\u041d\u041e\u0415", "\u0421\u041b\u0410\u0412\u041d\u041e\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100012", "2100012", "\u0411\u041e\u0411\u0420", "\u0411\u041e\u0411\u0420", "\u0411", null);
            RailwayStationsDataProvider.put("2100011", "2100011", "\u041a\u0420\u0423\u041f\u041a\u0418", "\u041a\u0420\u0423\u041f\u041a\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100009", "2100009", "\u041f\u0420\u0418\u042f\u041c\u0418\u041d\u041e", "\u041f\u0420\u0418\u042f\u041c\u0418\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100008", "2100008", "\u041d\u041e\u0412\u041e\u0421\u0410\u0414\u042b", "\u041d\u041e\u0412\u041e\u0421\u0410\u0414\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2100145", "2100145", "\u0416\u041e\u0414\u0418\u041d\u041e", "\u0416\u041e\u0414\u0418\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100007", "2100007", "\u0421\u041c\u041e\u041b\u0415\u0412\u0418\u0427\u0418", "\u0421\u041c\u041e\u041b\u0415\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100510", "2100510", "\u0413\u041e\u0420\u041e\u0414\u0418\u0429\u0415", "\u0413\u041e\u0420\u041e\u0414\u0418\u0429\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100006", "2100006", "\u041a\u041e\u041b\u041e\u0414\u0418\u0429\u0418", "\u041a\u041e\u041b\u041e\u0414\u0418\u0429\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100109", "2100109", "\u0424\u0410\u041d\u0418\u041f\u041e\u041b\u042c", "\u0424\u0410\u041d\u0418\u041f\u041e\u041b\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2100028", "2100028", "\u041a\u041e\u0419\u0414\u0410\u041d\u041e\u0412\u041e", "\u041a\u041e\u0419\u0414\u0410\u041d\u041e\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100029", "2100029", "\u041d\u0415\u0413\u041e\u0420\u0415\u041b\u041e\u0415", "\u041d\u0415\u0413\u041e\u0420\u0415\u041b\u041e\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100017", "2100017", "\u0427\u0410\u0428\u041d\u0418\u041a\u0418", "\u0427\u0410\u0428\u041d\u0418\u041a\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100443", "2100443", "\u0417\u0410\u0421\u041b\u041e\u041d\u041e\u0412\u041e", "\u0417\u0410\u0421\u041b\u041e\u041d\u041e\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100018", "2100018", "\u041b\u0415\u041f\u0415\u041b\u042c", "\u041b\u0415\u041f\u0415\u041b\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2100026", "2100026", "\u041a\u041d\u042f\u0413\u0418\u041d\u0418\u041d", "\u041a\u041d\u042f\u0413\u0418\u041d\u0418\u041d", "\u0411", null);
            RailwayStationsDataProvider.put("2100265", "2100265", "\u0412\u0418\u041b\u0415\u0419\u041a\u0410", "\u0412\u0418\u041b\u0415\u0419\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100108", "2100108", "\u041f\u041e\u041b\u041e\u0427\u0410\u041d\u042b", "\u041f\u041e\u041b\u041e\u0427\u0410\u041d\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2100057", "2100057", "\u0412\u041e\u041b\u041e\u0416\u0418\u041d", "\u0412\u041e\u041b\u041e\u0416\u0418\u041d", "\u0411", null);
            RailwayStationsDataProvider.put("2100058", "2100058", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412", "\u0411\u041e\u0413\u0414\u0410\u041d\u041e\u0412", "\u0411", null);
            RailwayStationsDataProvider.put("2100514", "2100514", "\u0420\u0410\u0422\u041e\u041c\u041a\u0410", "\u0420\u0410\u0422\u041e\u041c\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100106", "2100106", "\u0411\u0415\u041b\u0410\u0420\u0423\u0421\u042c", "\u0411\u0415\u041b\u0410\u0420\u0423\u0421\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2100680", "2100680", "\u0420\u0410\u0414\u041e\u0428\u041a\u041e\u0412\u0418\u0427", "\u0420\u0410\u0414\u041e\u0428\u041a\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100107", "2100107", "\u041e\u041b\u0415\u0425\u041d\u041e\u0412\u0418\u0427\u0418", "\u041e\u041b\u0415\u0425\u041d\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100021", "2100021", "\u0423\u0428\u0410", "\u0423\u0428\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100518", "2100518", "\u041f\u0420\u0423\u0414\u042b", "\u041f\u0420\u0423\u0414\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2100022", "2100022", "\u0417\u0410\u041b\u0415\u0421\u042c\u0415", "\u0417\u0410\u041b\u0415\u0421\u042c\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100205", "2100205", "\u0421\u041c\u041e\u0420\u0413\u041e\u041d\u042c", "\u0421\u041c\u041e\u0420\u0413\u041e\u041d\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2100023", "2100023", "\u0421\u041e\u041b\u042b", "\u0421\u041e\u041b\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2100301", "2100301", "\u041e\u0428\u041c\u042f\u041d\u042b", "\u041e\u0428\u041c\u042f\u041d\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2200107", "2200107", "\u0421\u041e\u041a\u041e\u0420\u0418\u041a\u0418", "\u0421\u041e\u041a\u041e\u0420\u0418\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2101057", "2101057", "\u041a\u0418\u0420\u0415\u0415\u0412\u041e", "\u041a\u0418\u0420\u0415\u0415\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100695", "2100695", "\u041c\u0418\u0422\u042c\u041a\u0418", "\u041c\u0418\u0422\u042c\u041a\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100157", "2100157", "\u0416\u0418\u0422\u041e\u041c\u041b\u042f", "\u0416\u0418\u0422\u041e\u041c\u041b\u042f", "\u0411", null);
            RailwayStationsDataProvider.put("2100448", "2100448", "\u041e\u0417\u0415\u0420\u041d\u0418\u0426\u0410", "\u041e\u0417\u0415\u0420\u041d\u0418\u0426\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2218236", "2218236", "\u042f\u0412\u041e\u0420\u041e\u0412-\u0414\u041e\u041b", "\u042f\u0412\u041e\u0420\u041e\u0412-\u0414\u041e\u041b\u0418\u041d\u0421\u041a\u0418\u0419", "\u041b", null);
            RailwayStationsDataProvider.put("2214127", "2214127", "\u041a\u0410\u041c\u042b\u0428\u0415\u0412\u0410\u0425\u0410", "\u041a\u0410\u041c\u042b\u0428\u0415\u0412\u0410\u0425\u0410", "\u0414", null);
            RailwayStationsDataProvider.put("2064296", "2064296", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2709978", "2709978", "\u0422\u0423\u0420\u0413\u0410\u0419", "\u0422\u0423\u0420\u0413\u0410\u0419", "\u0426", null);
            RailwayStationsDataProvider.put("2704963", "2704963", "\u0416\u0410\u0419\u042b\u041a", "\u0416\u0410\u0419\u042b\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707890", "2707890", "\u0413\u0410\u041d\u042e\u0428\u041a-\u0417\u0411", "\u0413\u0410\u041d\u042e\u0428\u041a-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707888", "2707888", "\u0418\u0421\u0410\u0422\u0410\u0419-\u0417\u0411", "\u0418\u0421\u0410\u0422\u0410\u0419-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707892", "2707892", "\u0410\u041a\u041a\u0418\u0421\u0422-\u0417\u0411", "\u0410\u041a\u041a\u0418\u0421\u0422-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707830", "2707830", "\u0410\u0422\u042b\u0420\u0410\u0423-\u0417\u0411", "\u0410\u0422\u042b\u0420\u0410\u0423-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707889", "2707889", "\u0414\u041e\u0421\u0421\u041e\u0420-\u0417\u0411", "\u0414\u041e\u0421\u0421\u041e\u0420-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707871", "2707871", "\u041c\u0410\u041a\u0410\u0422-\u0417\u0411", "\u041c\u0410\u041a\u0410\u0422-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707887", "2707887", "\u0416\u0410\u041c\u0410\u041d\u0421-\u0417\u0411", "\u0416\u0410\u041c\u0410\u041d\u0421-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707878", "2707878", "\u0416\u0410\u041d\u0422\u0415\u0420-\u0417\u0411", "\u0416\u0410\u041d\u0422\u0415\u0420-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707874", "2707874", "\u041c\u0423\u041a\u0423\u0420-\u0417\u0411", "\u041c\u0423\u041a\u0423\u0420-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707891", "2707891", "\u0421\u0410\u0413\u0418\u0417-\u0417\u0411", "\u0421\u0410\u0413\u0418\u0417-\u0417\u0411", "\u0426", null);
            RailwayStationsDataProvider.put("2707660", "2707660", "\u041d\u041e\u0413\u0410\u0419\u0422-\u0410\u0414\u041c", "\u041d\u041e\u0413\u0410\u0419\u0422-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707658", "2707658", "\u041a\u0410\u0420\u0410\u0423\u041b-\u0410\u0414\u041c", "\u041a\u0410\u0420\u0410\u0423\u041b-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707664", "2707664", "\u0428\u0423\u0411\u0410\u0420\u041a-\u0410\u0414\u041c", "\u0428\u0423\u0411\u0410\u0420\u041a-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707657", "2707657", "\u041a-\u0410\u0413\u0410\u0428-\u0410\u0414\u041c", "\u041a-\u0410\u0413\u0410\u0428-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707655", "2707655", "\u0416\u0423\u0420\u042b\u041d-\u0410\u0414\u041c", "\u0416\u0423\u0420\u042b\u041d-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707654", "2707654", "\u0416\u0415\u041c-\u0410\u0414\u041c", "\u0416\u0415\u041c-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707652", "2707652", "\u0411\u0418\u0420\u0428\u041e\u0413-\u0410\u0414\u041c", "\u0411\u0418\u0420\u0428\u041e\u0413-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707662", "2707662", "\u0428\u0410\u041b\u041a\u0410\u0420-\u0410\u0414\u041c", "\u0428\u0410\u041b\u041a\u0410\u0420-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707663", "2707663", "\u0428\u0418\u041b\u0418\u041a-\u0410\u0414\u041c", "\u0428\u0418\u041b\u0418\u041a-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707670", "2707670", "\u0421\u0410\u041a\u0421\u0410\u0423-\u0410\u0414\u041c", "\u0421\u0410\u041a\u0421\u0410\u0423-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707665", "2707665", "\u0410\u0420\u041c\u041e\u0420\u0415-\u0410\u0414\u041c", "\u0410\u0420\u041c\u041e\u0420\u0415-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707668", "2707668", "\u041a\u0410\u0417\u0410\u041b-\u0410\u0414\u041c", "\u041a\u0410\u0417\u0410\u041b-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707673", "2707673", "\u0422\u042e\u0420\u0410\u0422-\u0410\u0414\u041c", "\u0422\u042e\u0420\u0410\u0422-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707667", "2707667", "\u0414\u0416\u0423\u0421\u0410\u041b-\u0410\u0414\u041c", "\u0414\u0416\u0423\u0421\u0410\u041b-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707666", "2707666", "\u0414\u0416\u0410\u041b\u0410\u0413-\u0410\u0414\u041c", "\u0414\u0416\u0410\u041b\u0410\u0413-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707671", "2707671", "\u0422\u0415\u0420-\u0423\u0417-\u0410\u0414\u041c", "\u0422\u0415\u0420-\u0423\u0417-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707669", "2707669", "\u041a-\u041e\u0420\u0414\u0410-\u0410\u0414\u041c", "\u041a-\u041e\u0420\u0414\u0410-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707674", "2707674", "\u0427\u0418\u0418\u041b\u0418-\u0410\u0414\u041c", "\u0427\u0418\u0418\u041b\u0418-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707672", "2707672", "\u0422\u042e\u041c-\u0410\u0420-\u0410\u0414\u041c", "\u0422\u042e\u041c-\u0410\u0420-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707675", "2707675", "\u042f-\u041a\u0423\u0420\u0413-\u0410\u0414\u041c", "\u042f-\u041a\u0423\u0420\u0413-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707628", "2707628", "\u0411\u0423\u0420\u041d\u041e\u0415-\u0418\u042d\u041a", "\u0411\u0423\u0420\u041d\u041e\u0415-\u0418\u042d\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707633", "2707633", "\u041c\u0410\u0419\u041c\u0410\u041a-\u0418\u042d\u041a", "\u041c\u0410\u0419\u041c\u0410\u041a-\u0418\u042d\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707629", "2707629", "\u0414\u0416\u0410\u041c\u0411-\u0418\u042d\u041a", "\u0414\u0416\u0410\u041c\u0411-\u0418\u042d\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707632", "2707632", "\u041b\u0423\u0413\u041e\u0412-\u0418\u042d\u041a", "\u041b\u0423\u0413\u041e\u0412-\u0418\u042d\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707636", "2707636", "\u0427\u0423-\u0418\u042d\u041a", "\u0427\u0423-\u0418\u042d\u041a", "\u0426", null);
            RailwayStationsDataProvider.put("2707621", "2707621", "\u041e\u0422\u0410\u0420-\u0410\u0414\u041c", "\u041e\u0422\u0410\u0420-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707613", "2707613", "\u0410\u041b\u041c-1-\u0410\u0414\u041c", "\u0410\u041b\u041c-1-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2707614", "2707614", "\u0410\u041b\u041c-2-\u0410\u0414\u041c", "\u0410\u0414\u041c-2-\u0410\u0414\u041c", "\u0426", null);
            RailwayStationsDataProvider.put("2204047", "2204047", "\u041e\u041f 823 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 823 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2700912", "2700912", "\u041a\u041e\u041a-\u0422\u041e\u0411\u0415", "\u041a\u041e\u041a-\u0422\u041e\u0411\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2707732", "2707732", "\u041a\u0423\u0421\u0422\u0410\u041d-\u0410\u0419\u0421", "\u041a\u0423\u0421\u0422\u0410\u041d\u0410\u0419-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707735", "2707735", "\u0427\u0415\u041b\u0413\u0410\u0428-\u0410\u0419\u0421", "\u0427\u0415\u041b\u0413\u0410\u0428\u0418-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707746", "2707746", "\u0422\u041e\u0411\u041e\u041b-\u0410\u0419\u0421", "\u0422\u041e\u0411\u041e\u041b-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707747", "2707747", "\u0416\u0415\u041b\u0415\u0417-\u0410\u0419\u0421", "\u0416\u0415\u041b\u0415\u0417\u041e\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707748", "2707748", "\u041a\u0423\u0428\u041c\u0423\u0420-\u0410\u0419\u0421", "\u041a\u0423\u0428\u041c\u0423\u0420\u0423\u041d-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707749", "2707749", "\u0410\u041c\u0410\u041d\u041a-\u0410\u0419\u0421", "\u0410\u041c\u0410\u041d\u041a\u0410\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709791", "2709791", "\u041a\u0410\u0420 \u0421-\u0410\u0419\u0421", "\u041a\u0410\u0420 \u0421-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707795", "2707795", "\u0428\u041e\u041a\u0410\u0419-\u0410\u0419\u0421", "\u0428\u041e\u041a\u0410\u0419-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707792", "2707792", "\u041e\u0421\u0410\u041a\u0410\u0420-\u0410\u0419\u0421", "\u041e\u0421\u0410\u041a\u0410\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709797", "2709797", "\u041c\u042b\u0420\u0417\u0410-\u0410\u0419\u0421", "\u041c\u042b\u0420\u0417\u0410-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709799", "2709799", "\u041d\u0423\u0420\u0410-\u0410\u0419\u0421", "\u041d\u0423\u0420\u0410-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709777", "2709777", "\u0410\u041a\u0422\u0410\u0421\u0422-\u0410\u0419\u0421", "\u0410\u041a\u0422\u0410\u0421\u0422-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707893", "2707893", "\u0423\u0420\u0410\u041b\u042c\u0421-\u0410\u0419\u0421", "\u0423\u0420\u0410\u041b\u042c\u0421\u041a-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707896", "2707896", "\u042f\u0418\u041a-\u0410\u0419\u0421", "\u042f\u0418\u041a-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707897", "2707897", "\u0421\u0415\u041c\u041c\u0410\u0420-\u0410\u0419\u0421", "\u0421\u0415\u041c\u041c\u0410\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707899", "2707899", "\u0410\u041b\u0413\u0410\u0411-\u0410\u0419\u0421", "\u0410\u041b\u0413\u0410\u0411\u0410\u0421-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709769", "2709769", "\u041f\u041e\u0419\u041c\u0410-\u0410\u0419\u0421", "\u041f\u041e\u0419\u041c\u0410-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709770", "2709770", "\u041f\u0415\u0420\u0415\u041c-\u0410\u0419\u0421", "\u041f\u0415\u0420\u0415\u041c\u0415\u0422-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709772", "2709772", "\u0427\u0418\u041d\u0413\u0418\u0420-\u0410\u0419\u0421", "\u0427\u0418\u041d\u0413\u0418\u0420\u041b-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709773", "2709773", "\u0410\u041c\u0410\u041d\u0413-\u0410\u0419\u0421", "\u0410\u041c\u0410\u041d\u0413\u0415\u041b-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709774", "2709774", "\u0428\u0418\u041f\u041e\u0412\u041e-\u0410\u0419\u0421", "\u0428\u0418\u041f\u041e\u0412\u041e-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709775", "2709775", "\u041a\u0410\u0417\u0410\u0425\u0421-\u0410\u0419\u0421", "\u041a\u0410\u0417\u0410\u0425\u0421-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709789", "2709789", "\u041a\u0410\u0420 \u041f-\u0410\u0419\u0421", "\u041a\u0410\u0420 \u041f-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707834", "2707834", "\u0416\u0410\u0420\u041b\u042b-\u0410\u0419\u0421", "\u0416\u0410\u0420\u041b\u042b-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707833", "2707833", "\u041a\u041e\u0422\u042b\u0420-\u0410\u0419\u0421", "\u041a\u041e\u0422\u042b\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707843", "2707843", "\u0422\u041e\u0413\u042b\u0417-\u0410\u0419\u0421", "\u0422\u041e\u0413\u042b\u0417-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707853", "2707853", "\u0410\u0420\u0410\u041b\u041a-\u0410\u0419\u0421", "\u0410\u0420\u0410\u041b\u041a-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707855", "2707855", "\u0421\u041e\u041b\u041e\u0422\u041e-\u0410\u0419\u0421", "\u0421\u041e\u041b\u041e\u0422\u041e-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707854", "2707854", "\u0422\u0410\u0420\u0422\u0423\u0413-\u0410\u0419\u0421", "\u0422\u0410\u0420\u0422\u0423\u0413-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2707863", "2707863", "\u0411\u0415\u0428\u0410\u0420-\u0410\u0419\u0421", "\u0411\u0415\u0428\u0410\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709735", "2709735", "\u0422\u0423\u0420\u041a\u0415\u0421-\u0410\u0419\u0421", "\u0422\u0423\u0420\u041a\u0415\u0421-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709730", "2709730", "\u0422\u0418\u041c\u0423\u0420-\u0410\u0419\u0421", "\u0422\u0418\u041c\u0423\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709736", "2709736", "\u0410\u0420\u042b\u0421\u042c-\u0410\u0419\u0421", "\u0410\u0420\u042b\u0421\u042c-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709729", "2709729", "\u0427\u0418\u041c\u041a\u0415\u041d-\u0410\u0419\u0421", "\u0427\u0418\u041c\u041a\u0415\u041d-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709738", "2709738", "\u041c\u0410\u041d\u041a\u0415\u041d-\u0410\u0419\u0421", "\u041c\u0410\u041d\u041a\u0415\u041d-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709733", "2709733", "\u0421\u0410\u0421\u0422\u041e\u0411-\u0410\u0419\u0421", "\u0421\u0410\u0421\u0422\u041e\u0411-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709734", "2709734", "\u0422\u042e\u041b\u042c\u041a\u0423-\u0410\u0419\u0421", "\u0422\u042e\u041b\u042c\u041a\u0423-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709706", "2709706", "\u0427\u041e\u041a\u041f\u0410\u0420-\u0410\u0419\u0421", "\u0427\u041e\u041a\u041f\u0410\u0420-\u0410\u0419\u0421", "\u0426", null);
            RailwayStationsDataProvider.put("2709901", "2709901", "\u041a\u041e\u041a\u0422\u041e\u0411\u0415", "\u041a\u041e\u041a\u0422\u041e\u0411\u0415", "\u0426", null);
            RailwayStationsDataProvider.put("2401398", "2401398", "\u0412\u0415\u041a\u0428\u041d\u042f\u0419", "\u0412\u0415\u041a\u0428\u041d\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2100485", "2100485", "\u0413\u041b\u0423\u0428\u0410\u041d\u0418\u041d\u041e", "\u0413\u041b\u0423\u0428\u0410\u041d\u0418\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100927", "2100927", "\u041f\u0410\u0420\u0428\u0418\u041d\u041e", "\u041f\u0410\u0420\u0428\u0418\u041d\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100847", "2100847", "\u0415\u0420\u041c\u041e\u041b\u041e\u0412\u041a\u0410", "\u0415\u0420\u041c\u041e\u041b\u041e\u0412\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2208357", "2208357", "\u041f\u0415\u0420\u0415\u0413\u041e\u041d\u041e\u0412\u041a", "\u041f\u0415\u0420\u0415\u0413\u041e\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2704818", "2704818", "\u041a\u041e\u0420\u041a\u041e\u041b", "\u041a\u041e\u0420\u041a\u041e\u041b", "\u0426", null);
            RailwayStationsDataProvider.put("8053192", "8053192", "\u0411\u041e\u041d\u041d", "\u0411\u041e\u041d\u041d", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5100170", "5100170", "\u041a\u0420\u0410\u041a\u041e\u0412 \u041f\u041b\u0410", "\u041a\u0420\u0410\u041a\u041e\u0412 \u041f\u041b\u0410\u0428\u041e\u0412", "W", null);
            RailwayStationsDataProvider.put("5100051", "5100051", "\u041a\u0420\u0410\u041a\u041e\u0412 \u0413\u041b", "\u041a\u0420\u0410\u041a\u041e\u0412 \u0413\u041b", "W", null);
            RailwayStationsDataProvider.put("5100131", "5100131", "\u0422\u042b\u0425\u0418", "\u0422\u042b\u0425\u0418", "W", null);
            RailwayStationsDataProvider.put("5100248", "5100248", "\u041f\u0421\u0416\u0429\u0418\u041d\u0410", "\u041f\u0421\u0416\u0429\u0418\u041d\u0410", "W", null);
            RailwayStationsDataProvider.put("5454396", "5454396", "\u041a\u0420\u0410\u041b\u0423\u041f \u041d \u0412", "\u041a\u0420\u0410\u041b\u0423\u041f\u042b \u041d\u0410\u0414 \u0412\u041b\u0422\u0410\u0412\u041e\u042e", "V", null);
            RailwayStationsDataProvider.put("5455859", "5455859", "\u041b\u041e\u0412\u041e\u0421\u0418\u0426\u0415", "\u041b\u041e\u0412\u041e\u0421\u0418\u0426\u0415", "V", null);
            RailwayStationsDataProvider.put("5453179", "5453179", "\u0423\u0421\u0422\u0418 \u041d \u041b\u0410\u0411", "\u0423\u0421\u0422\u0418 \u041d\u0410\u0414 \u041b\u0410\u0411\u0415\u041c", "V", null);
            RailwayStationsDataProvider.put("5453289", "5453289", "\u0422\u0415\u041f\u041b \u0412 \u0427\u0415\u0425", "\u0422\u0415\u041f\u041b\u0418\u0426\u0415 \u0412 \u0427\u0415\u0425\u0410\u0425", "V", null);
            RailwayStationsDataProvider.put("5400011", "5400011", "\u0414\u0423\u0425\u0426\u041e\u0412", "\u0414\u0423\u0425\u0426\u041e\u0412", "V", null);
            RailwayStationsDataProvider.put("5454819", "5454819", "\u0411\u0418\u041b\u0418\u041d\u0410", "\u0411\u0418\u041b\u0418\u041d\u0410", "V", null);
            RailwayStationsDataProvider.put("5454019", "5454019", "\u0418\u0418\u0420\u041a\u041e\u0412 \u0417\u0410\u0421", "\u0418\u0418\u0420\u041a\u041e\u0412 \u0417\u0410\u0421\u0422\u0410\u0412\u041a\u0410", "V", null);
            RailwayStationsDataProvider.put("5453509", "5453509", "\u0425\u041e\u041c\u0423\u0422\u041e\u0412 \u041c\u0415", "\u0425\u041e\u041c\u0423\u0422\u041e\u0412 \u041c\u0415\u0421\u0422\u041e", "V", null);
            RailwayStationsDataProvider.put("5453549", "5453549", "\u041a\u0410\u0414\u0410\u041d\u042c", "\u041a\u0410\u0414\u0410\u041d\u042c", "V", null);
            RailwayStationsDataProvider.put("5453519", "5453519", "\u041a\u041b\u0410\u0421\u0422 \u041d \u041e\u0425", "\u041a\u041b\u0410\u0421\u0422\u0415\u0420\u0415\u0426 \u041d\u0410\u0414 \u041e\u0425\u0420\u0418", "V", null);
            RailwayStationsDataProvider.put("5479855", "5479855", "\u041e\u0421\u0422\u0420\u041e\u0412 \u041d \u041e", "\u041e\u0421\u0422\u0420\u041e\u0412 \u041d\u0410\u0414 \u041e\u0425\u0420\u0418", "V", null);
            RailwayStationsDataProvider.put("5475935", "5475935", "\u041a\u042b\u041d\u0421\u041f \u041d \u041e\u0425", "\u041a\u042b\u041d\u0421\u041f\u0415\u0420\u041a \u041d\u0410\u0414 \u041e\u0425\u0420\u0418", "V", null);
            RailwayStationsDataProvider.put("5501411", "5501411", "\u041a\u0418\u0421\u0412\u0410\u0420\u0414\u0410", "\u041a\u0418\u0421\u0412\u0410\u0420\u0414\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5500009", "5500009", "\u0414\u0415\u041c\u0415\u041a\u0421\u0415\u0420", "\u0414\u0415\u041c\u0415\u041a\u0421\u0415\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5500330", "5500330", "\u041b\u0415\u041f\u0421\u0415\u041d\u0418", "\u041b\u0415\u041f\u0421\u0415\u041d\u0418", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5600017", "5600017", "\u0421\u0422\u0420\u0415\u0428\u041d\u041e", "\u0421\u0422\u0420\u0415\u0428\u041d\u041e", "Q", null);
            RailwayStationsDataProvider.put("5600018", "5600018", "\u0412\u0410\u0420\u0418\u041d", "\u0412\u0410\u0420\u0418\u041d", "Q", null);
            RailwayStationsDataProvider.put("5600015", "5600015", "\u0413\u041e\u0420\u041d \u0428\u0422 \u041e\u0411", "\u0413\u041e\u0420\u041d\u0410 \u0428\u0422\u0423\u0411\u041d\u0410 \u041e\u0411\u0415\u0426", "Q", null);
            RailwayStationsDataProvider.put("5600013", "5600013", "\u0427\u0420\u0415\u041c\u041e\u0428\u041d\u0415", "\u0427\u0420\u0415\u041c\u041e\u0428\u041d\u0415", "Q", null);
            RailwayStationsDataProvider.put("5600014", "5600014", "\u0425\u0410\u0420\u041c\u0410\u041d\u0415\u0426 \u0414", "\u0425\u0410\u0420\u041c\u0410\u041d\u0415\u0426 \u0414\u0416\u0410\u0421\u041a\u0418\u041d\u0410", "Q", null);
            RailwayStationsDataProvider.put("5600016", "5600016", "\u0420\u0410\u0414\u0412\u0410\u041d", "\u0420\u0410\u0414\u0412\u0410\u041d", "Q", null);
            RailwayStationsDataProvider.put("5600019", "5600019", "\u0412\u041b\u041a\u0410\u041d\u041e\u0412\u0410", "\u0412\u041b\u041a\u0410\u041d\u041e\u0412\u0410", "Q", null);
            RailwayStationsDataProvider.put("8010139", "8010139", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u041b", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u041b\u0410\u0412\u041d\u042b\u0419", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2101036", "2101036", "\u041d\u0410\u0420\u0426\u0418\u0417\u041e\u0412\u041e", "\u041d\u0410\u0420\u0426\u0418\u0417\u041e\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100772", "2100772", "\u0424\u0410\u041a\u0415\u041b", "\u0424\u0410\u041a\u0415\u041b", "\u0411", null);
            RailwayStationsDataProvider.put("8010138", "8010138", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u0415\u0417", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u0415\u0417\u0423\u041d\u0411\u0420\u0423\u041d\u041d\u0415\u041d", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2034744", "2034744", "\u041f\u041b N1", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 N1", "\u042d", null);
            RailwayStationsDataProvider.put("2034745", "2034745", "\u0425\u0415\u0425\u0426\u0418\u0420\u0421\u041a\u0418\u0419", "\u0425\u0415\u0425\u0426\u0418\u0420\u0421\u041a\u0418\u0419", "\u042d", null);
            RailwayStationsDataProvider.put("2034746", "2034746", "\u0427\u0418\u0420\u041a\u0418", "\u0427\u0418\u0420\u041a\u0418", "\u042d", null);
            RailwayStationsDataProvider.put("2034747", "2034747", "\u0414\u0423\u0411\u041e\u041a", "\u0414\u0423\u0411\u041e\u041a", "\u042d", null);
            RailwayStationsDataProvider.put("8000100", "8000100", "\u0411\u0415\u0420\u041b\u0418\u041d", "\u0411\u0415\u0420\u041b\u0418\u041d", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8010110", "8010110", "\u0411\u0415\u0420\u041b\u0418\u041d \u041e\u0421\u0422", "\u0411\u0415\u0420\u041b\u0418\u041d \u041e\u0421\u0422\u0411\u0410\u041d\u0425\u041e\u0424", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8010100", "8010100", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u041b", "\u0411\u0415\u0420\u041b\u0418\u041d \u0413\u041b\u0410\u0412\u041d\u042b\u0419", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8016195", "8016195", "\u0411\u0415\u0420\u041d\u0410\u0423", "\u0411\u0415\u0420\u041d\u0410\u0423", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5100163", "5100163", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412", "\u042f\u0420\u041e\u0421\u041b\u0410\u0412", "W", null);
            RailwayStationsDataProvider.put("5100031", "5100031", "\u0425\u0420\u0423\u0411\u0415\u0428\u041e\u0412", "\u0425\u0420\u0423\u0411\u0415\u0428\u0423\u0412", "W", null);
            RailwayStationsDataProvider.put("5100147", "5100147", "\u0417\u0410\u041c\u041e\u0421\u0422\u042c", "\u0417\u0410\u041c\u041e\u0421\u0422\u042c", "W", null);
            RailwayStationsDataProvider.put("5100245", "5100245", "\u041e\u041b\u041a\u0423\u0428", "\u041e\u041b\u041a\u0423\u0428", "W", null);
            RailwayStationsDataProvider.put("5100246", "5100246", "\u041f\u0420\u0410\u0411\u0423\u0422\u042b", "\u041f\u0420\u0410\u0411\u0423\u0422\u042b", "W", null);
            RailwayStationsDataProvider.put("5100929", "5100929", "\u0420\u0415\u0419\u041e\u0412\u0418\u0426", "\u0420\u0415\u0419\u041e\u0412\u0418\u0426", "W", null);
            RailwayStationsDataProvider.put("5351190", "5351190", "\u0420\u041e\u041c\u0410\u041d", "\u0420\u041e\u041c\u0410\u041d", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5475035", "5475035", "\u0425\u0415\u0411", "\u0425\u0415\u0411", "V", null);
            RailwayStationsDataProvider.put("5502576", "5502576", "\u0427\u041e\u0420\u041d\u0410", "\u0427\u041e\u0420\u041d\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("7200931", "7200931", "\u041f\u0410\u041d\u0421\u0415\u0412\u041e", "\u041f\u0410\u041d\u0421\u0415\u0412\u041e", "\"", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u044f");
            RailwayStationsDataProvider.put("8002227", "8002227", "\u041b\u0415\u0411\u0410\u0423", "\u041b\u0415\u0411\u0410\u0423", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8100216", "8100216", "\u0412 \u041d\u041e\u0419\u0428\u0422\u0410\u0414\u0422", "\u0412\u0418\u0415\u041d\u0415\u0420 \u041d\u041e\u0419\u0428\u0422\u0410\u0414\u0422", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8100612", "8100612", "\u0413\u0410\u041d\u0417\u0415\u0420\u0414\u041e\u0420\u0424", "\u0413\u0410\u041d\u0417\u0415\u0420\u0414\u041e\u0420\u0424", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8300244", "8300244", "\u0422\u0420\u0418\u0415\u0421\u0422", "\u0422\u0420\u0418\u0415\u0421\u0422", "1", "\u0418\u0442\u0430\u043b\u0438\u044f");
            RailwayStationsDataProvider.put("8300237", "8300237", "\u041c\u041e\u041d\u0424\u0410\u041b\u041a\u041e\u041d\u0415", "\u041c\u041e\u041d\u0424\u0410\u041b\u041a\u041e\u041d\u0415", "1", "\u0418\u0442\u0430\u043b\u0438\u044f");
            RailwayStationsDataProvider.put("2100319", "2100319", "\u0410\u0421\u0415\u0415\u0412\u041a\u0410", "\u0410\u0421\u0415\u0415\u0412\u041a\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2401446", "2401446", "\u0421\u0422\u041e\u041d\u0418\u0428\u041a\u042f\u0419", "\u0421\u0422\u041e\u041d\u0418\u0428\u041a\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2400326", "2400326", "\u0427\u042e\u0422\u042f\u041b\u042f\u0419", "\u0427\u042e\u0422\u042f\u041b\u042f\u0419", "L", null);
            RailwayStationsDataProvider.put("2500830", "2500830", "\u041b\u0418\u041c\u0411\u0410\u0416\u0418", "\u041b\u0418\u041c\u0411\u0410\u0416\u0418", "R", null);
            RailwayStationsDataProvider.put("2500806", "2500806", "\u0420\u0423\u0418\u0415\u041d\u0410", "\u0420\u0423\u0419\u0415\u041d\u0410", "R", null);
            RailwayStationsDataProvider.put("2500113", "2500113", "\u041b\u0418\u0412\u0411\u0415\u0420\u0417\u0415", "\u041b\u0418\u0412\u0411\u0415\u0420\u0417\u0415", "R", null);
            RailwayStationsDataProvider.put("2044825", "2044825", "\u0423\u041a\u041b\u0410\u0414\u041e\u0427\u041d\u042b\u0419", "\u0423\u041a\u041b\u0410\u0414\u041e\u0427\u041d\u042b\u0419", "\u041d", null);
            RailwayStationsDataProvider.put("2900122", "2900122", "\u041b\u0423\u041d\u0410\u0427\u0410\u0420\u0421\u041a", "\u041b\u0423\u041d\u0410\u0427\u0410\u0420\u0421\u041a\u041e\u0413\u041e", "\u0424", null);
            RailwayStationsDataProvider.put("2210016", "2210016", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u041f", null);
            RailwayStationsDataProvider.put("2204051", "2204051", "\u0420\u0415\u0414\u0423\u0422\u042b", "\u0420\u0415\u0414\u0423\u0422\u042b", "\u042e", null);
            RailwayStationsDataProvider.put("2204050", "2204050", "\u042e\u0416\u041d\u042b\u0419 \u041f\u0410\u0420\u041a", "\u042e\u0416\u041d\u042b\u0419 \u041f\u0410\u0420\u041a", "\u042e", null);
            RailwayStationsDataProvider.put("2204049", "2204049", "\u041f\u041e\u0421\u0422 4 \u041a\u041c", "\u041f\u041e\u0421\u0422 4 \u041a\u041c", "\u042e", null);
            RailwayStationsDataProvider.put("2204048", "2204048", "\u041a\u041e\u041c\u041c\u0423\u041d\u0410\u0420", "\u041a\u041e\u041c\u041c\u0423\u041d\u0410\u0420", "\u042e", null);
            RailwayStationsDataProvider.put("2208009", "2208009", "\u0420\u0423\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0420\u0423\u0411\u0410\u041d\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2218332", "2218332", "\u0414\u0418\u0411\u0420\u041e\u0412\u0410", "\u0414\u0418\u0411\u0420\u041e\u0412\u0410", "\u041b", null);
            RailwayStationsDataProvider.put("2218128", "2218128", "\u041a\u041e\u0421\u0418\u041d\u042b", "\u041a\u041e\u0421\u0418\u041d\u042b", "\u041b", null);
            RailwayStationsDataProvider.put("2218138", "2218138", "\u0414\u041e\u0411\u0420\u041e\u0412\u041b\u042f\u041d\u042b", "\u0414\u041e\u0411\u0420\u041e\u0412\u041b\u042f\u041d\u042b", "\u041b", null);
            RailwayStationsDataProvider.put("2218173", "2218173", "\u0420\u041e\u0414\u0410\u0422\u042b\u0427\u0415", "\u0420\u041e\u0414\u0410\u0422\u042b\u0427\u0415", "\u041b", null);
            RailwayStationsDataProvider.put("2200397", "2200397", "\u0412\u042b\u0421\u041e\u041a\u041e\u0415", "\u0412\u042b\u0421\u041e\u041a\u041e\u0415", "\u041a", null);
            RailwayStationsDataProvider.put("2200395", "2200395", "\u0421\u0410\u0414\u041e\u0412\u042b\u0419", "\u0421\u0410\u0414\u041e\u0412\u042b\u0419", "\u041a", null);
            RailwayStationsDataProvider.put("2200389", "2200389", "\u041d \u041e\u0411\u0418\u0425\u041e\u0414\u042b", "\u041d\u041e\u0412\u042b\u0415 \u041e\u0411\u0418\u0425\u041e\u0414\u042b", "\u041a", null);
            RailwayStationsDataProvider.put("2200388", "2200388", "\u041e\u041f 5 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 5 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200393", "2200393", "\u0414\u0410\u0427\u041d\u0410\u042f", "\u0414\u0410\u0427\u041d\u0410\u042f", "\u041a", null);
            RailwayStationsDataProvider.put("2200398", "2200398", "\u041e\u041f 4 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 4 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200392", "2200392", "\u041b\u0418\u0422\u041a\u0418", "\u041b\u0418\u0422\u041a\u0418", "\u041a", null);
            RailwayStationsDataProvider.put("2200391", "2200391", "\u041a\u0418\u042f\u041d\u041e\u0412\u041a\u0410", "\u041a\u0418\u042f\u041d\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200390", "2200390", "\u0427\u0410\u041f\u0410\u0415\u0412\u041a\u0410", "\u0427\u0410\u041f\u0410\u0415\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200394", "2200394", "\u041d\u0415\u0411\u041e\u0420\u041e\u0412\u041a\u0410", "\u041d\u0415\u0411\u041e\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200396", "2200396", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200399", "2200399", "\u041e\u041f 41 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 41 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200402", "2200402", "\u041e\u041f 6 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 6 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200401", "2200401", "\u041e\u041f 3 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 3 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200406", "2200406", "\u041e\u041f 669 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 669 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200403", "2200403", "\u041c\u0410\u0419\u041e\u0420\u041e\u0412\u041a\u0410", "\u041c\u0410\u0419\u041e\u0420\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200014", "2200014", "\u041f\u0418\u0420\u041e\u0422\u0427\u0418\u041d\u041e", "\u041f\u0418\u0420\u041e\u0422\u0427\u0418\u041d\u041e", "\u041a", null);
            RailwayStationsDataProvider.put("2200407", "2200407", "\u041b\u041e\u0411\u041a\u041e\u0412\u041a\u0410", "\u041b\u041e\u0411\u041a\u041e\u0412\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2200404", "2200404", "\u041e\u041f 133 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 133 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2200405", "2200405", "\u041e\u041f 149 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 149 \u041a\u041c", "\u041a", null);
            RailwayStationsDataProvider.put("2100462", "2100462", "\u0427\u0415\u0420\u041d\u0423\u0425\u0410  *", "\u0427\u0415\u0420\u041d\u0423\u0425\u0410 *", "\u0411", null);
            RailwayStationsDataProvider.put("2100429", "2100429", "\u041b\u0418\u0425\u0410\u0427\u0418   *", "\u041b\u0418\u0425\u0410\u0427\u0418 *", "\u0411", null);
            RailwayStationsDataProvider.put("2100691", "2100691", "\u041f \u041c\u0423\u0425\u0410\u0412\u0415\u0426", "\u041f\u041e\u0421\u0415\u041b\u041e\u041a \u041c\u0423\u0425\u0410\u0412\u0415\u0426", "\u0411", null);
            RailwayStationsDataProvider.put("2100574", "2100574", "\u0424\u0410\u0411\u0420\u0418\u0427\u041d\u042b\u0419", "\u0424\u0410\u0411\u0420\u0418\u0427\u041d\u042b\u0419", "\u0411", null);
            RailwayStationsDataProvider.put("2010337", "2010337", "\u041e\u041f 489 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 489 \u041a\u041c", "\u042f", null);
            RailwayStationsDataProvider.put("2200165", "2200165", "\u0414\u0415\u0421\u0415\u041d\u041a\u0410", "\u0414\u0415\u0421\u0415\u041d\u041a\u0410", "\u041a", null);
            RailwayStationsDataProvider.put("2000014", "2000014", "\u041e\u041f 37 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 37 \u041a\u041c", "\u041c", null);
            RailwayStationsDataProvider.put("2000006", "2000006", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0411\u0415\u041b", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0411\u0415\u041b\u041e\u0420\u0423\u0421\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000015", "2000015", "\u041c\u042b\u0422\u0418\u0429\u0418", "\u041c\u042b\u0422\u0418\u0429\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000002", "2000002", "\u041c\u041e\u0421\u041a\u0412\u0410 \u042f\u0420", "\u041c\u041e\u0421\u041a\u0412\u0410 \u042f\u0420\u041e\u0421\u041b\u0410\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000038", "2000038", "\u0427\u0415\u0420\u0423\u0421\u0422\u0418", "\u0427\u0415\u0420\u0423\u0421\u0422\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000003", "2000003", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0410\u0417", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0410\u0417\u0410\u041d\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000021", "2000021", "\u041a\u0410\u0420\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u041a\u0410\u0420\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000022", "2000022", "\u0411\u0415\u041b\u042c\u041a\u041e\u0412\u041e", "\u0411\u0415\u041b\u042c\u041a\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000032", "2000032", "\u0418\u041b\u042c\u0418\u041d \u041f\u041e\u0413", "\u0418\u041b\u042c\u0418\u041d\u0421\u041a\u0418\u0419 \u041f\u041e\u0413\u041e\u0421\u0422", "\u041c", null);
            RailwayStationsDataProvider.put("2000007", "2000007", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0418\u0412", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041a\u0418\u0415\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("51211", "51211", "\u0412\u042b\u0421\u041e\u041a-\u0427\u0415\u0420\u0415", "\u0412\u042b\u0421\u041e\u041a\u041e\u041b\u0418\u0422\u041e\u0412\u0421\u041a-\u0427\u0415\u0420\u0415\u041c\u0425\u0410", "W", null);
            RailwayStationsDataProvider.put("25211", "25211", "\u0418\u041d\u0414\u0420\u0410-\u0411\u0418\u0413\u041e", "\u0418\u041d\u0414\u0420\u0410-\u0411\u0418\u0413\u041e\u0421\u041e\u0412\u041e \u0413\u0420\u0410\u041d\u0418\u0426\u0410", "R", null);
            RailwayStationsDataProvider.put("25242", "25242", "\u041a\u0423\u0420\u0426\u0423-\u0422\u0423\u0420\u041c", "\u041a\u0423\u0420\u0426\u0423\u041c\u0421-\u0422\u0423\u0420\u041c\u0410\u041d\u0422\u0410\u0421 \u0413\u0420\u0410\u041d", "R", null);
            RailwayStationsDataProvider.put("25261", "25261", "\u041b\u0423\u0413\u0410\u0416-\u0412\u0410\u041b\u0413", "\u041b\u0423\u0413\u0410\u0416\u0418-\u0412\u0410\u041b\u0413\u0410 \u0413\u0420\u0410\u041d\u0418\u0426\u0410", "R", null);
            RailwayStationsDataProvider.put("1000045", "1000045", "\u041f\u0410\u0421\u0418\u041b\u0410", "\u041f\u0410\u0421\u0418\u041b\u0410", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000040", "1000040", "\u0420\u0418\u0418\u0425\u0418\u041c\u042f\u041a\u0418", "\u0420\u0418\u0418\u0425\u0418\u041c\u042f\u041a\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000100", "1000100", "\u041b\u0410\u0425\u0422\u0418", "\u041b\u0410\u0425\u0422\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("1000480", "1000480", "\u041a\u041e\u0423\u0412\u041e\u041b\u0410", "\u041a\u041e\u0423\u0412\u041e\u041b\u0410", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("58751", "58751", "\u0410\u0425\u0423\u0420\u042f\u041d-\u0414\u041e\u0413", "\u0410\u0425\u0423\u0420\u042f\u041d-\u0414\u041e\u0413\u0423\u041a\u0410\u041f\u042b", "6", "\u0422\u0443\u0440\u0446\u0438\u044f");
            RailwayStationsDataProvider.put("28581", "28581", "\u0421\u0410\u0414\u0410\u0425-\u0410\u0419\u0420\u0423", "\u0421\u0410\u0414\u0410\u0425\u041b\u041e-\u0410\u0419\u0420\u0423\u041c \u0413\u0420\u0410\u041d\u0418\u0426\u0410", "\u0417", null);
            RailwayStationsDataProvider.put("57961", "57961", "\u0414\u0416\u0423\u041b \u0421-\u0414\u0416", "\u0414\u0416\u0423\u041b\u042c\u0424\u0410 \u0421\u041e\u0412-\u0414\u0416\u0423\u041b\u042c\u0424\u0410 \u0418\u0420", "7", "\u0418\u0440\u0430\u043d");
            RailwayStationsDataProvider.put("57582", "57582", "\u0418\u0414\u0416\u0415\u0412-\u0411\u0410\u0420\u0425", "\u0418\u0414\u0416\u0415\u0412\u0410\u041d-\u0411\u0410\u0420\u0425\u0423\u0414\u0410\u0420\u041b\u042b \u0413\u0420", "\u0410", null);
            RailwayStationsDataProvider.put("57581", "57581", "\u0415\u0420\u0410\u0421\u0425-\u0428\u0410\u0420\u0423", "\u0415\u0420\u0410\u0421\u0425-\u0428\u0410\u0420\u0423\u0420 \u0413\u0420", "\u0410", null);
            RailwayStationsDataProvider.put("28571", "28571", "\u0413\u0410\u0420\u0414-\u0411\u0415\u042e\u041a", "\u0413\u0410\u0420\u0414\u0410\u0411\u0410\u041d\u0418-\u0411\u0415\u042e\u041a \u041a\u042f\u0421\u0418\u041a \u0413", "J", null);
            RailwayStationsDataProvider.put("2000010", "2000010", "\u041c\u041e\u0421\u041a\u0412 \u0422 \u0421\u041c", "\u041c\u041e\u0421\u041a\u0412\u0410-\u0422\u041e\u0412-\u0421\u041c\u041e\u041b\u0415\u041d\u0421\u041a.", "\u041c", null);
            RailwayStationsDataProvider.put("2000011", "2000011", "\u042d\u041b\u0415\u041a\u0422\u0420\u041e\u0413\u041e\u0420", "\u042d\u041b\u0415\u041a\u0422\u0420\u041e\u0413\u041e\u0420\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000018", "2000018", "\u0423\u0421\u0410\u0414", "\u0423\u0421\u0410\u0414", "\u041c", null);
            RailwayStationsDataProvider.put("2000033", "2000033", "\u041a\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u041a\u0410\u0411\u0410\u041d\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000020", "2000020", "\u0422\u0410\u041b\u0414\u041e\u041c \u0421\u0410\u0412", "\u0422\u0410\u041b\u0414\u041e\u041c-\u0421\u0410\u0412\u0415\u041b\u041e\u0412\u0421\u041a\u0418\u0419", "\u041c", null);
            RailwayStationsDataProvider.put("2000027", "2000027", "\u0412\u0415\u0420\u0411\u0418\u041b\u041a\u0418", "\u0412\u0415\u0420\u0411\u0418\u041b\u041a\u0418", "\u041c", null);
            RailwayStationsDataProvider.put("2000026", "2000026", "\u0414\u041c\u0418\u0422\u0420\u041e\u0412", "\u0414\u041c\u0418\u0422\u0420\u041e\u0412", "\u041c", null);
            RailwayStationsDataProvider.put("2000009", "2000009", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0421\u0410\u0412", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0421\u0410\u0412\u0415\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000031", "2000031", "\u0411\u0423\u0425\u041e\u041b\u041e\u0412\u041e", "\u0411\u0423\u0425\u041e\u041b\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000029", "2000029", "\u0411\u041b\u0410\u0413\u041e\u0412\u0415\u0429\u0415\u041d", "\u0411\u041b\u0410\u0413\u041e\u0412\u0415\u0429\u0415\u041d\u0421\u041a\u041e\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2000030", "2000030", "\u0412\u041e\u041b\u041e\u041a\u041e\u041b\u0410\u041c", "\u0412\u041e\u041b\u041e\u041a\u041e\u041b\u0410\u041c\u0421\u041a", "\u041c", null);
            RailwayStationsDataProvider.put("2000008", "2000008", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0420\u0418\u0416", "\u041c\u041e\u0421\u041a\u0412\u0410 \u0420\u0418\u0416\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000028", "2000028", "\u0416\u0418\u041b\u0415\u0412\u041e", "\u0416\u0418\u041b\u0415\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2000005", "2000005", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041f\u0410\u0412", "\u041c\u041e\u0421\u041a\u0412\u0410 \u041f\u0410\u0412\u0415\u041b\u0415\u0426\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("87881", "87881", "\u0416\u0415\u041c\u041e\u041d\u0422-\u042d\u0420\u041a", "\u0416\u0415\u041c\u041e\u041d\u0422-\u042d\u0420\u041a\u0412\u0415\u041b\u0418\u041d", "&", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f");
            RailwayStationsDataProvider.put("85871", "85871", "\u0416\u0415\u041d\u0415\u0412\u0410-\u0416\u0415\u041d", "\u0416\u0415\u041d\u0415\u0412\u0410-\u0416\u0415\u041d\u0415\u0412\u0410", "2", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("81831", "81831", "\u0410\u0420\u041d\u041e-\u0422\u0410\u0420\u0412\u0418", "\u0410\u0420\u041d\u041e\u041b\u042c\u0414\u0421\u0422\u0415\u0419\u041d-\u0422\u0410\u0420\u0412\u0418\u0417\u041e", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("80861", "80861", "\u0412\u0410\u0420-\u0413\u0415\u0414\u0417\u0415\u0420", "\u0412\u0410\u0420\u041d\u0415\u041c\u042e\u041d\u0414\u0415-\u0413\u0415\u0414\u0417\u0415\u0420", "3", "\u0414\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("80851", "80851", "\u0411\u0410\u0417 \u0411-\u0411\u0410\u0417", "\u0411\u0410\u0417\u0415\u041b\u042c \u0411\u0410\u0414-\u0411\u0410\u0417\u0415\u041b\u042c \u0421\u0411\u0411", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("80841", "80841", "\u0411 \u0411\u0415\u041d\u0422\u0425-\u0425\u0415", "\u0411\u0410\u0414 \u0411\u0415\u041d\u0422\u0425\u0415\u0419\u041c-\u0425\u0415\u041d\u0413\u0415\u041b\u041e", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("80881", "80881", "\u0410\u0425\u0415\u041d-\u0412\u0415\u041b\u042c\u041a", "\u0410\u0425\u0415\u041d-\u0412\u0415\u041b\u042c\u041a\u0415\u041d\u0420\u0415\u0414", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("79831", "79831", "\u0421\u0415\u0416\u0410\u041d-\u0412 \u041e\u041f", "\u0421\u0415\u0416\u0410\u041d\u0410-\u0412\u0418\u041b\u041b\u0410 \u041e\u041f\u0418\u0427\u0418\u041d\u0410", "1", "\u0418\u0442\u0430\u043b\u0438\u044f");
            RailwayStationsDataProvider.put("80741", "80741", "\u0417\u0410\u0421\u0421\u041d-\u0422\u0420\u0415\u041b", "\u0417\u0410\u0421\u0421\u041d\u0418\u0426-\u0422\u0420\u0415\u041b\u041b\u0415\u0411\u041e\u0420\u0413", null, null);
            RailwayStationsDataProvider.put("74764", "74764", "\u042d\u0414-\u041a\u041e\u0420\u041d\u0421\u042c\u0415", "\u042d\u0414 \u041a\u041e\u0420\u041d\u0421\u042c\u0415", null, null);
            RailwayStationsDataProvider.put("70841", "70841", "\u0413\u0410\u0420-\u0425 \u0412 \u0425\u041e", "\u0413\u0410\u0420\u0412\u0418\u0427-\u0425\u0423\u041a \u0412\u0410\u041d \u0425\u041e\u041b\u041b\u0410\u041d\u0414", ";", "\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("70881", "70881", "\u0414\u0423\u0412\u0420-\u041e\u0421\u0422\u0415\u041d", "\u0414\u0423\u0412\u0420-\u041e\u0421\u0422\u0415\u041d\u0414\u0415", "&", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f");
            RailwayStationsDataProvider.put("73651", "73651", "\u0413\u0415\u0412\u0413\u0415\u041b-\u0418\u0414\u041e", "\u0413\u0415\u0412\u0413\u0415\u041b\u0418\u042f-\u0418\u0414\u041e\u041c\u0415\u041d\u0418", "\u0420", null);
            RailwayStationsDataProvider.put("72651", "72651", "\u0422\u0410\u0411\u0410\u041d-\u0422\u0410\u0411\u0410", "\u0422\u0410\u0411\u0410\u041d\u041e\u0412\u0426\u042b-\u0422\u0410\u0411\u0410\u041d\u041e\u0412\u0426\u042b", "\u0420", null);
            RailwayStationsDataProvider.put("56813", "56813", "\u0414\u0415\u0412-\u041c\u0410\u0420\u0425\u0415\u0413", "\u0414\u0415\u0412\u0418\u041d\u0421\u041a\u0410 \u041d \u0412-\u041c\u0410\u0420\u0425\u0415\u0413\u0413", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("56556", "56556", "\u0421\u041e\u0411-\u0428\u0422\u0423\u0420\u041e\u0412", "\u0421\u041e\u0411-\u0428\u0422\u0423\u0420\u041e\u0412\u041e", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("55724", "55724", "\u0420\u041e\u0417\u041a\u0415-\u0425\u041e\u0420\u0413", "\u0420\u041e\u0417\u041a\u0415-\u0425\u041e\u0420\u0413\u041e\u0421", "\"", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u044f");
            RailwayStationsDataProvider.put("55811", "55811", "\u0425\u0415\u0414\u042c\u0415-\u041d\u0418\u0426\u041a", "\u0425\u0415\u0414\u042c\u0415\u0428\u0425\u0410\u041b\u041e\u041c-\u041d\u0418\u0426\u041a\u0415\u041b\u042c\u0414\u041e\u0420", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("55783", "55783", "\u041c\u0423\u0420\u0410\u041a-\u041a\u041e\u0422\u041e", "\u041c\u0423\u0420\u0410\u041a\u0415\u0420\u0415\u0421\u0422\u0423\u0420-\u041a\u041e\u0422\u041e\u0420\u0418\u0411", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("55722", "55722", "\u041a\u0415\u041b\u0415\u0411-\u0421\u0423\u0411\u0411", "\u041a\u0415\u041b\u0415\u0411\u0418\u042f-\u0421\u0423\u0411\u0411\u041e\u0422\u0418\u0426\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("55781", "55781", "\u0414\u042c\u0415\u041a\u0415\u041d-\u041a\u041e\u041f", "\u0414\u042c\u0415\u041a\u0415\u041d\u042c\u0415\u0428-\u041a\u041e\u041f\u0420\u0418\u0412\u041d\u0418\u0426\u0410", "<", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("54561", "54561", "\u0427\u0410\u0414\u0426\u0410-\u0427\u0410\u0414\u0426", "\u0427\u0410\u0414\u0426\u0410-\u0427\u0410\u0414\u0426\u0410", "V", null);
            RailwayStationsDataProvider.put("54811", "54811", "\u0411\u0420\u0416\u0415\u0426\u041b-\u0425\u041e\u0425", "\u0411\u0420\u0416\u0415\u0426\u041b\u0410\u0412-\u0425\u041e\u0425\u0415\u041d\u0410\u0423", "V", null);
            RailwayStationsDataProvider.put("54563", "54563", "\u0413.\u041b\u0418\u0414-\u0413.\u041b\u0418", "\u0413\u041e\u0420\u041d\u0418 \u041b\u0418\u0414-\u0413\u041e\u0420\u041d\u0418 \u041b\u0418\u0414", "Q", null);
            RailwayStationsDataProvider.put("53722", "53722", "\u0421\u0422\u0410\u041c.\u041c-\u0412\u0420\u0428", "\u0421\u0422\u0410\u041c\u041e\u0420\u0410 \u041c\u041e\u0420\u0410\u0412\u0418\u0426\u0410-\u0412\u0420\u0428\u0410\u0426", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("52731", "52731", "\u041a\u0423\u041b\u0410\u0422\u0410-\u041f\u0420\u041e", "\u041a\u0423\u041b\u0410\u0422\u0410-\u041f\u0420\u041e\u041c\u0410\u0425\u041e\u041d", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("52751", "52751", "\u0421\u0412\u0418\u041b\u0415\u041d-\u041a\u0410\u041f", "\u0421\u0412\u0418\u041b\u0415\u041d\u0413\u0420\u0410\u0414-\u041a\u0410\u041f\u0418\u041a\u0423\u041b\u0415", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("52531", "52531", "\u041d\u0415\u0413\u0420 \u0412\u041e\u0414-\u041a", "\u041d\u0415\u0413\u0420\u0423 \u0412\u041e\u0414\u0410-\u041a\u0410\u0420\u0414\u0410\u041c", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("52532", "52532", "\u0420\u0423\u0421\u0415-\u0414\u0416\u0423\u0420", "\u0420\u0423\u0421\u0415-\u0414\u0416\u0423\u0420\u0414\u0416\u0423 \u041d\u041e\u0420\u0414", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("80514", "80514", "\u0429\u0415\u0426\u0418\u041d-\u0422\u0410\u041d\u0422", "\u0429\u0415\u0426\u0418\u041d-\u0422\u0410\u041d\u0422\u041e\u0412", "W", null);
            RailwayStationsDataProvider.put("80511", "80511", "\u0413\u0415\u0420-\u0417\u0413\u041e\u0416\u0415\u041b", "\u0413\u0415\u0420\u041b\u0418\u0426-\u0417\u0413\u041e\u0416\u0415\u041b\u0415\u0426", "W", null);
            RailwayStationsDataProvider.put("51541", "51541", "\u0417\u0415\u0411\u0416-\u041f\u0415\u0422\u0420", "\u0417\u0415\u0411\u0416\u0415\u0414\u041e\u0412-\u041f\u0415\u0422\u0420\u041e\u0412 \u0423 \u041a\u0410\u0420\u0412", "W", null);
            RailwayStationsDataProvider.put("80516", "80516", "\u041a\u0423\u041d\u041e\u0412-\u0424\u0420\u0410\u041d", "\u041a\u0423\u041d\u041e\u0412\u0418\u0426\u0415-\u0424\u0420\u0410\u041d\u041a \u041d\u0410 \u041e\u0414.", "W", null);
            RailwayStationsDataProvider.put("51542", "51542", "\u041c\u0415\u041d\u0414\u0417-\u041b\u0418\u0425\u041a", "\u041c\u0415\u041d\u0414\u0417\u042b\u041b\u0415\u0421\u0415-\u041b\u0418\u0425\u041a\u041e\u0412", "W", null);
            RailwayStationsDataProvider.put("30331", "30331", "\u0414\u0410\u041d\u042c\u0414-\u0421\u0418\u041d\u0418", "\u0414\u0410\u041d\u042c\u0414\u0423\u041d-\u0421\u0418\u041d\u0418\u0414\u0416\u0423", "?", "\u041a\u0438\u0442\u0430\u0439");
            RailwayStationsDataProvider.put("2005308", "2005308", "\u041e\u041f 32 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 32 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005312", "2005312", "\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005089", "2005089", "\u041b\u0415\u0422\u041d.\u0420\u0415\u0427\u041a\u0410", "\u041b\u0415\u0422\u041d\u042f\u042f \u0420\u0415\u0427\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2000040", "2000040", "\u0428\u0410\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u0428\u0410\u0425\u041e\u0412\u0421\u041a\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2064990", "2064990", "\u041e\u041f 66 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 66 \u041a\u041c", "\u0421", null);
            RailwayStationsDataProvider.put("2800850", "2800850", "\u0421\u0410\u041c\u0422\u0420\u0415\u0414\u0418\u04102", "\u0421\u0410\u041c\u0422\u0420\u0415\u0414\u0418\u0410 2", "J", null);
            RailwayStationsDataProvider.put("2900316", "2900316", "\u041e\u041f 352 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 352 \u041a\u041c", "\u0424", null);
            RailwayStationsDataProvider.put("2068401", "2068401", "\u0417\u0410\u041e\u0417\u0415\u0420\u041d \u0421\u0422", "\u0417\u0410\u041e\u0417\u0415\u0420\u041d\u041e\u0415 \u0421\u0422\u0410\u0420\u041e\u0415", "G", null);
            RailwayStationsDataProvider.put("2068403", "2068403", "\u042f\u0421\u041d \u041f\u041e\u041b\u042f\u041d\u0410", "\u042f\u0421\u041d\u0410\u042f \u041f\u041e\u041b\u042f\u041d\u0410", "G", null);
            RailwayStationsDataProvider.put("2068404", "2068404", "\u0412\u0415\u0422\u0415\u0420\u0410\u041d\u0421\u041a", "\u0412\u0415\u0422\u0415\u0420\u0410\u041d\u0421\u041a\u0410\u042f", "G", null);
            RailwayStationsDataProvider.put("2068405", "2068405", "\u0415\u041b\u041e\u0427\u041a\u0418", "\u0415\u041b\u041e\u0427\u041a\u0418", "G", null);
            RailwayStationsDataProvider.put("2068406", "2068406", "\u041e\u041f 353 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 353 \u041a\u041c", "G", null);
            RailwayStationsDataProvider.put("2068407", "2068407", "\u0417\u0410\u0411\u0410\u0419\u041a\u0410\u041b\u0415\u0426", "\u0417\u0410\u0411\u0410\u0419\u041a\u0410\u041b\u0415\u0426", "G", null);
            RailwayStationsDataProvider.put("2068408", "2068408", "\u041c\u0410\u0422\u0420\u041e\u0421\u041e\u0412\u041e", "\u041c\u0410\u0422\u0420\u041e\u0421\u041e\u0412\u041e", "G", null);
            RailwayStationsDataProvider.put("2068402", "2068402", "\u0410\u0420\u0413\u0418-\u041f\u0410\u0413\u0418", "\u0410\u0420\u0413\u0418-\u041f\u0410\u0413\u0418", "G", null);
            RailwayStationsDataProvider.put("2068409", "2068409", "\u041c\u0418\u041d\u0415\u0420\u0410\u041b\u042c\u041d", "\u041c\u0418\u041d\u0415\u0420\u0410\u041b\u042c\u041d\u0410\u042f", "G", null);
            RailwayStationsDataProvider.put("2068410", "2068410", "\u041e\u041f 102 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 102 \u041a\u041c", "G", null);
            RailwayStationsDataProvider.put("2068411", "2068411", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "\u041f\u041e\u041a\u0420\u041e\u0412\u041a\u0410", "G", null);
            RailwayStationsDataProvider.put("2068412", "2068412", "\u041e\u041f 15 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 15 \u041a\u041c", "G", null);
            RailwayStationsDataProvider.put("2068413", "2068413", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "G", null);
            RailwayStationsDataProvider.put("1000390", "1000390", "\u041a\u041e\u041d\u0422\u0418\u041e\u041c\u042f\u041a\u0418", "\u041a\u041e\u041d\u0422\u0418\u041e\u041c\u042f\u041a\u0418", "!", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f");
            RailwayStationsDataProvider.put("5200300", "5200300", "\u041c\u0415\u0417\u0414\u0420\u0410", "\u041c\u0415\u0417\u0414\u0420\u0410", "/", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("5310287", "5310287", "\u0412\u0418\u0414\u0415\u041b\u0415", "\u0412\u0418\u0414\u0415\u041b\u0415", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("5311906", "5311906", "\u0422\u0418\u041c\u0418\u0428\u041e\u0410\u0420\u0410", "\u0422\u0418\u041c\u0418\u0428\u041e\u0410\u0420\u0410", ">", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("7300001", "7300001", "\u0418\u0414\u041e\u041c\u0415\u041d\u0418", "\u0418\u0414\u041e\u041c\u0415\u041d\u0418", ".", "\u0413\u0440\u0435\u0446\u0438\u044f");
            RailwayStationsDataProvider.put("8001380", "8001380", "\u0420\u0418\u0417\u0410", "\u0420\u0418\u0417\u0410", "%", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("8100666", "8100666", "\u0412\u0418\u041b\u041b\u0410\u0425 \u0413\u041b", "\u0412\u0418\u041b\u041b\u0410\u041a \u0413\u041b\u0410\u0412\u041d\u042b\u0419", ")", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8500010", "8500010", "\u0411\u0410\u0417\u0415\u041b\u042c \u0421\u0411\u0411", "\u0411\u0410\u0417\u0415\u041b\u042c \u0421\u0411\u0411", "2", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f");
            RailwayStationsDataProvider.put("8600626", "8600626", "\u041a\u041e\u041f\u0415\u041d\u0413\u0410\u0413\u0415\u041d", "\u041a\u041e\u041f\u0415\u041d\u0413\u0410\u0413\u0415\u041d \u0413", "3", "\u0414\u0430\u043d\u0438\u044f");
            RailwayStationsDataProvider.put("2000919", "2000919", "\u0417\u0410\u0414\u0423\u0411\u0420\u041e\u0412\u042c\u0415", "\u0417\u0410\u0414\u0423\u0411\u0420\u041e\u0412\u042c\u0415", "\u041c", null);
            RailwayStationsDataProvider.put("2000401", "2000401", "\u0411\u0415\u041b\u041e\u041a\u0410\u041c\u0415\u041d\u041d", "\u0411\u0415\u041b\u041e\u041a\u0410\u041c\u0415\u041d\u041d\u0410\u042f", "\u041c", null);
            RailwayStationsDataProvider.put("2000677", "2000677", "\u0427\u0415\u0420\u041a\u0418\u0417\u041e\u0412\u041e", "\u0427\u0415\u0420\u041a\u0418\u0417\u041e\u0412\u041e", "\u041c", null);
            RailwayStationsDataProvider.put("2039779", "2039779", "\u041a\u0423\u0427\u0415\u0422\u041a\u0410\u041d", "\u041a\u0423\u0427\u0415\u0422\u041a\u0410\u041d", "\u042b", null);
            RailwayStationsDataProvider.put("2501114", "2501114", "\u041d\u0415\u0419\u041a\u0415\u041d\u0415", "\u041d\u0415\u0419\u041a\u0415\u041d\u0415", "R", null);
            RailwayStationsDataProvider.put("2100801", "2100801", "\u041f\u041e\u0413\u041e\u0420\u0415\u041b\u041e\u0415", "\u041f\u041e\u0413\u041e\u0420\u0415\u041b\u041e\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100034", "2100034", "\u0414\u0420\u0415\u0422\u0423\u041d\u042c", "\u0414\u0420\u0415\u0422\u0423\u041d\u042c", "\u0411", null);
            RailwayStationsDataProvider.put("2100499", "2100499", "\u0421\u0415\u041a\u0415\u0420\u041e\u0412\u0429\u0418\u041d", "\u0421\u0415\u041a\u0415\u0420\u041e\u0412\u0429\u0418\u041d\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100042", "2100042", "\u0417\u042f\u0411\u041a\u0418", "\u0417\u042f\u0411\u041a\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100043", "2100043", "\u041f\u041e\u0414\u0421\u0412\u0418\u041b\u042c\u0415", "\u041f\u041e\u0414\u0421\u0412\u0418\u041b\u042c\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100503", "2100503", "\u041f\u0410\u0420\u0410\u0424\u042c\u042f\u041d\u041e\u0412", "\u041f\u0410\u0420\u0410\u0424\u042c\u042f\u041d\u041e\u0412", "\u0411", null);
            RailwayStationsDataProvider.put("2100421", "2100421", "\u042e\u0413\u041e-\u0417\u0410\u041f\u0410\u0414", "\u042e\u0413\u041e-\u0417\u0410\u041f\u0410\u0414", "\u0411", null);
            RailwayStationsDataProvider.put("2100611", "2100611", "\u041b\u041e\u0421\u0412\u0418\u0414\u0410", "\u041b\u041e\u0421\u0412\u0418\u0414\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100239", "2100239", "\u0417\u0410\u041c\u041e\u0421\u0422\u041e\u0427\u042c\u0415", "\u0417\u0410\u041c\u041e\u0421\u0422\u041e\u0427\u042c\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100237", "2100237", "\u0421\u0422\u0410\u0420 \u0421\u0415\u041b\u041e", "\u0421\u0422\u0410\u0420\u041e\u0415 \u0421\u0415\u041b\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100233", "2100233", "\u0411\u041e\u0420\u041a\u041e\u0412\u0418\u0427\u0418", "\u0411\u041e\u0420\u041a\u041e\u0412\u0418\u0427\u0418", "\u0411", null);
            RailwayStationsDataProvider.put("2100105", "2100105", "\u0412\u0415\u0420\u0425\u041d\u0415\u0414\u0412\u0418\u041d", "\u0412\u0415\u0420\u0425\u041d\u0415\u0414\u0412\u0418\u041d\u0421\u041a", "\u0411", null);
            RailwayStationsDataProvider.put("2100031", "2100031", "\u0411\u0418\u0413\u041e\u0421\u041e\u0412\u041e *", "\u0411\u0418\u0413\u041e\u0421\u041e\u0412\u041e *", "\u0411", null);
            RailwayStationsDataProvider.put("2100044", "2100044", "\u0413\u041b\u0423\u0411\u041e\u041a\u041e\u0415", "\u0413\u041b\u0423\u0411\u041e\u041a\u041e\u0415", "\u0411", null);
            RailwayStationsDataProvider.put("2100047", "2100047", "\u0412\u041e\u0420\u041e\u041f\u0410\u0415\u0412\u041e", "\u0412\u041e\u0420\u041e\u041f\u0410\u0415\u0412\u041e", "\u0411", null);
            RailwayStationsDataProvider.put("2100053", "2100053", "\u0428\u0410\u0420\u041a\u041e\u0412\u0429\u0418\u0417\u041d", "\u0428\u0410\u0420\u041a\u041e\u0412\u0429\u0418\u0417\u041d\u0410", "\u0411", null);
            RailwayStationsDataProvider.put("2100054", "2100054", "\u041c\u0418\u041e\u0420\u042b", "\u041c\u0418\u041e\u0420\u042b", "\u0411", null);
            RailwayStationsDataProvider.put("2100056", "2100056", "\u0414\u0420\u0423\u042f     *", "\u0414\u0420\u0423\u042f *", "\u0411", null);
            RailwayStationsDataProvider.put("2100468", "2100468", "\u041b\u042b\u041d\u0422\u0423\u041f\u042b  *", "\u041b\u042b\u041d\u0422\u0423\u041f\u042b *", "\u0411", null);
            RailwayStationsDataProvider.put("22232", "22232", "\u041a\u0420\u0418\u0412\u0410-\u041c\u0410\u041c", "\u041a\u0420\u0418\u0412\u0410-\u041c\u0410\u041c\u0410\u041b\u042b\u0413\u0410 \u0413\u0420\u0410\u041d.", "\u042c", null);
            RailwayStationsDataProvider.put("2208413", "2208413", "\u0428\u0410\u0420\u041e\u0412\u041a\u0410", "\u0428\u0410\u0420\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208415", "2208415", "\u041a\u0423\u0426\u041e\u0412\u041a\u0410", "\u041a\u0423\u0426\u041e\u0412\u041a\u0410", "\u0428", null);
            RailwayStationsDataProvider.put("2208391", "2208391", "\u0421\u0427\u0410\u0421\u0422\u041b\u0418\u0412\u0410\u042f", "\u0421\u0427\u0410\u0421\u0422\u041b\u0418\u0412\u0410\u042f", "\u0428", null);
            RailwayStationsDataProvider.put("2210890", "2210890", "\u042d\u041b\u0415\u0412\u0410\u0422\u041e\u0420\u041d\u0410", "\u042d\u041b\u0415\u0412\u0410\u0422\u041e\u0420\u041d\u0410\u042f", "\u041f", null);
            RailwayStationsDataProvider.put("6700267", "6700267", "\u0410\u0411\u0410\u0414\u0410\u041d-2", "\u0410\u0411\u0410\u0414\u0410\u041d-2", "U", null);
            RailwayStationsDataProvider.put("6700266", "6700266", "\u0410\u0411\u0410\u0414\u0410\u041d-1", "\u0410\u0411\u0410\u0414\u0410\u041d-1", "U", null);
            RailwayStationsDataProvider.put("5433845", "5433845", "\u0425\u041e\u0414\u041e\u041d\u0418\u041d", "\u0425\u041e\u0414\u041e\u041d\u0418\u041d", "V", null);
            RailwayStationsDataProvider.put("2005307", "2005307", "\u0421\u041e\u041a \u0420\u0423\u0427\u0415\u0419", "\u0421\u041e\u041a\u041e\u041b\u041e\u0412.\u0420\u0423\u0427\u0415\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2005344", "2005344", "\u0411\u041e\u041b\u041e\u0422\u041d\u0418\u0426\u041a", "\u0411\u041e\u041b\u041e\u0422\u041d\u0418\u0426\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004592", "2004592", "\u041c\u0410\u041b \u0412\u0418\u0428\u0415\u0420\u0410", "\u041c\u0410\u041b\u0410\u042f \u0412\u0418\u0428\u0415\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004579", "2004579", "\u041e\u041a\u0423\u041b\u041e\u0412\u041a\u0410", "\u041e\u041a\u0423\u041b\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004660", "2004660", "\u0411\u041e\u041b\u041e\u0413\u041e\u0415 \u041c", "\u0411\u041e\u041b\u041e\u0413\u041e\u0415-\u041c\u041e\u0421\u041a\u041e\u0412\u0421\u041a\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004460", "2004460", "\u0412 \u0412\u041e\u041b\u041e\u0427\u0415\u041a", "\u0412\u042b\u0428\u041d\u0418\u0419 \u0412\u041e\u041b\u041e\u0427\u0415\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2005284", "2005284", "\u041c\u0423\u0422\u0410\u0428\u0415\u041b\u0418\u0425\u0410", "\u041c\u0423\u0422\u0410\u0428\u0415\u041b\u0418\u0425\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005342", "2005342", "\u041b\u041e\u041a\u041e\u0422\u0426\u042b", "\u041b\u041e\u041a\u041e\u0422\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2005362", "2005362", "\u041f\u041e\u0420\u0428\u0418\u041d\u0415\u0426", "\u041f\u041e\u0420\u0428\u0418\u041d\u0415\u0426", "\u041e", null);
            RailwayStationsDataProvider.put("2005044", "2005044", "\u0422\u0420\u0423\u0411\u0418\u041d\u041e", "\u0422\u0420\u0423\u0411\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005384", "2005384", "\u041a\u0423\u041b\u0418\u0426\u041a \u041c\u041e\u0425", "\u041a\u0423\u041b\u0418\u0426\u041a\u0418\u0419 \u041c\u041e\u0425", "\u041e", null);
            RailwayStationsDataProvider.put("2006103", "2006103", "\u041f\u0420\u041e\u041b\u0415\u0422\u0410\u0420\u0421\u041a", "\u041f\u0420\u041e\u041b\u0415\u0422\u0410\u0420\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004600", "2004600", "\u0422\u0412\u0415\u0420\u042c", "\u0422\u0412\u0415\u0420\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2005010", "2005010", "\u041f\u041e\u0412\u0410\u0420\u041e\u0412\u041a\u0410", "\u041f\u041e\u0412\u0410\u0420\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005376", "2005376", "\u0420\u0410\u0414\u0418\u0429\u0415\u0412\u041e", "\u0420\u0410\u0414\u0418\u0429\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005280", "2005280", "\u0410\u041b\u0410\u0411\u0423\u0428\u0415\u0412\u041e", "\u0410\u041b\u0410\u0411\u0423\u0428\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005381", "2005381", "\u041c\u0410\u041b\u0418\u041d\u041e", "\u041c\u0410\u041b\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005215", "2005215", "\u0424\u0418\u0420\u0421\u0410\u041d\u041e\u0412\u0421\u041a", "\u0424\u0418\u0420\u0421\u0410\u041d\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005090", "2005090", "\u0421\u0425\u041e\u0414\u041d\u042f", "\u0421\u0425\u041e\u0414\u041d\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005005", "2005005", "\u041f\u041e\u0414\u0420\u0415\u0417\u041a\u041e\u0412\u041e", "\u041f\u041e\u0414\u0420\u0415\u0417\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005003", "2005003", "\u041d\u041e\u0412\u041e\u041f\u041e\u0414\u0420\u0415\u0417", "\u041d\u041e\u0412\u041e\u041f\u041e\u0414\u0420\u0415\u0417\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005250", "2005250", "\u041f\u041b\u0410\u041d\u0415\u0420\u041d\u0410\u042f", "\u041f\u041b\u0410\u041d\u0415\u0420\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005000", "2005000", "\u0425\u0418\u041c\u041a\u0418", "\u0425\u0418\u041c\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005275", "2005275", "\u041b\u0415\u0412\u041e\u0411\u0415\u0420\u0415\u0416\u041d", "\u041b\u0415\u0412\u041e\u0411\u0415\u0420\u0415\u0416\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2006100", "2006100", "\u0425\u041e\u0412\u0420\u0418\u041d\u041e", "\u0425\u041e\u0412\u0420\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005080", "2005080", "\u041c\u041e\u0421\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u041c\u041e\u0421\u0421\u0415\u041b\u042c\u041c\u0410\u0428", "\u041e", null);
            RailwayStationsDataProvider.put("2004764", "2004764", "\u041d\u0410\u0422\u0418", "\u041d\u0410\u0422\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005060", "2005060", "\u041f \u0420\u0410\u0417\u0423\u041c\u041e\u0412", "\u041f\u0415\u0422\u0420\u041e\u0412\u0421\u041a\u041e-\u0420\u0410\u0417\u0423\u041c\u041e\u0412\u0421\u041a\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004090", "2004090", "\u041a\u041e\u0420\u0421\u0410\u041a\u041e\u0412\u0421\u041a", "\u041a\u041e\u0420\u0421\u0410\u041a\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004091", "2004091", "\u0422\u0420\u0410\u0412\u041a\u041e\u0412\u041e", "\u0422\u0420\u0410\u0412\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004430", "2004430", "\u041d\u0418\u041a\u0418\u0422\u0418\u041d\u0421\u041a", "\u041d\u0418\u041a\u0418\u0422\u0418\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005038", "2005038", "\u041c\u0410\u0420\u041a\u041e\u0412\u041e", "\u041c\u0410\u0420\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004750", "2004750", "\u0411\u041e\u0420\u041e\u0412\u0418\u0427\u0418", "\u0411\u041e\u0420\u041e\u0412\u0418\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004093", "2004093", "\u041f\u041e\u0414\u0414\u0423\u0411\u042c\u0415", "\u041f\u041e\u0414\u0414\u0423\u0411\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004766", "2004766", "\u041e\u041f 8 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 8 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004581", "2004581", "\u041a\u0423\u041b\u041e\u0422\u0418\u041d\u041e", "\u041a\u0423\u041b\u041e\u0422\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004767", "2004767", "\u041e\u041f 16 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 16 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004582", "2004582", "\u041a\u041e\u0422\u041e\u0412\u041e", "\u041a\u041e\u0422\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004583", "2004583", "\u0422\u041e\u041f\u041e\u0420\u041e\u041a", "\u0422\u041e\u041f\u041e\u0420\u041e\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2004094", "2004094", "\u0422\u0420\u0423\u0411\u0415\u0426", "\u0422\u0420\u0423\u0411\u0415\u0426", "\u041e", null);
            RailwayStationsDataProvider.put("2004584", "2004584", "\u0412\u041e\u041c\u041f\u0415", "\u0412\u041e\u041c\u041f\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004768", "2004768", "\u041e\u041f 43 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 43 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004095", "2004095", "\u0417\u0410\u0420\u0423\u0411\u0418\u041d\u0421\u041a", "\u0417\u0410\u0420\u0423\u0411\u0418\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005167", "2005167", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004096", "2004096", "\u0413\u0410\u041c\u0417\u0418\u041d\u041e", "\u0413\u0410\u041c\u0417\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005361", "2005361", "\u041b\u042e\u0411\u042b\u0422\u0418\u041d\u041e", "\u041b\u042e\u0411\u042b\u0422\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004097", "2004097", "\u0429\u0415\u0413\u0420\u0418\u041d\u041e", "\u0429\u0415\u0413\u0420\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004098", "2004098", "\u0427\u0410\u0414\u041a\u041e\u0412\u041e", "\u0427\u0410\u0414\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005149", "2005149", "\u041e\u041f 86 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 86 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004099", "2004099", "\u041f\u0415\u0420\u041d\u0418\u0426\u0410", "\u041f\u0415\u0420\u041d\u0418\u0426\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005971", "2005971", "\u041e\u041f 99 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 99 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004627", "2004627", "\u041d\u0415\u0411\u041e\u041b\u0427\u0418", "\u041d\u0415\u0411\u041e\u041b\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004004", "2004004", "\u0421-\u041f\u0415\u0422-\u0424\u0418\u041d", "\u0421\u0410\u041d\u041a\u0422-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420\u0413-\u0424\u0418\u041d\u041b\u042f\u041d", "\u041e", null);
            RailwayStationsDataProvider.put("2005130", "2005130", "\u041a\u0423\u0428\u0415\u041b\u0415\u0412\u041a\u0410", "\u041a\u0423\u0428\u0415\u041b\u0415\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005055", "2005055", "\u041f\u0418\u0421\u041a\u0410\u0420\u0415\u0412\u041a\u0410", "\u041f\u0418\u0421\u041a\u0410\u0420\u0415\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004241", "2004241", "\u0420\u0423\u0427\u042c\u0418", "\u0420\u0423\u0427\u042c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005220", "2005220", "\u041c\u0423\u0420\u0418\u041d\u041e", "\u041c\u0423\u0420\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2006025", "2006025", "\u0414\u0415\u0412\u042f\u0422\u041a\u0418\u041d\u041e", "\u0414\u0415\u0412\u042f\u0422\u041a\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005286", "2005286", "\u041b\u0410\u0412\u0420\u0418\u041a\u0418", "\u041b\u0410\u0412\u0420\u0418\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004419", "2004419", "\u041a\u0410\u041f\u0418\u0422\u041e\u041b\u041e\u0412\u041e", "\u041a\u0410\u041f\u0418\u0422\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005160", "2005160", "\u041a\u0423\u0417\u042c\u041c\u041e\u041b\u041e\u0412\u041e", "\u041a\u0423\u0417\u042c\u041c\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004242", "2004242", "\u0422\u041e\u041a\u0421\u041e\u0412\u041e", "\u0422\u041e\u041a\u0421\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005310", "2005310", "\u041a\u0410\u0412\u0413\u041e\u041b\u041e\u0412\u041e", "\u041a\u0410\u0412\u0413\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004243", "2004243", "\u041e\u0421\u0415\u041b\u042c\u041a\u0418", "\u041e\u0421\u0415\u041b\u042c\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004244", "2004244", "\u041f\u0415\u0420\u0418", "\u041f\u0415\u0420\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005938", "2005938", "\u041e\u041f 39 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 39 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004245", "2004245", "\u0413\u0420\u0423\u0417\u0418\u041d\u041e", "\u0413\u0420\u0423\u0417\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005321", "2005321", "\u041e\u041f 47 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 47 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004246", "2004246", "\u0412\u0410\u0421\u041a\u0415\u041b\u041e\u0412\u041e", "\u0412\u0410\u0421\u041a\u0415\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004769", "2004769", "\u041e\u041f 54 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 54 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004770", "2004770", "\u041b\u0415\u041c\u0411\u041e\u041b\u041e\u0412\u041e", "\u041b\u0415\u041c\u0411\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004247", "2004247", "\u041e\u0420\u0415\u0425\u041e\u0412\u041e", "\u041e\u0420\u0415\u0425\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005365", "2005365", "\u041e\u041f 67 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 67 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005355", "2005355", "\u041e\u041f 69 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 69 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004683", "2004683", "\u0421\u041e\u0421\u041d\u041e\u0412\u041e", "\u0421\u041e\u0421\u041d\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004771", "2004771", "\u041e\u041f 79 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 79 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004248", "2004248", "\u041f\u0415\u0422\u042f\u042f\u0420\u0412\u0418", "\u041f\u0415\u0422\u042f\u042f\u0420\u0412\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004249", "2004249", "\u041b\u041e\u0421\u0415\u0412\u041e", "\u041b\u041e\u0421\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004250", "2004250", "\u0413\u0420\u041e\u041c\u041e\u0412\u041e", "\u0413\u0420\u041e\u041c\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004251", "2004251", "\u0421\u0423\u0425\u041e\u0414\u041e\u041b\u042c\u0415", "\u0421\u0423\u0425\u041e\u0414\u041e\u041b\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004252", "2004252", "\u041e\u0422\u0420\u0410\u0414\u041d\u041e\u0415", "\u041e\u0422\u0420\u0410\u0414\u041d\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004253", "2004253", "\u041c\u042e\u041b\u041b\u042e\u041f\u0415\u041b\u042c\u0422", "\u041c\u042e\u041b\u041b\u042e\u041f\u0415\u041b\u042c\u0422\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004254", "2004254", "\u0421\u0418\u041d\u0415\u0412\u041e", "\u0421\u0418\u041d\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004684", "2004684", "\u041f\u0420\u0418\u041e\u0417\u0415\u0420\u0421\u041a", "\u041f\u0420\u0418\u041e\u0417\u0415\u0420\u0421\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2004772", "2004772", "\u041a\u0410\u041f\u0415\u0410\u0421\u0410\u041b\u041c\u0418", "\u041a\u0410\u041f\u0415\u0410\u0421\u0410\u041b\u041c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004255", "2004255", "\u041a\u0423\u0417\u041d\u0415\u0427\u041d\u041e\u0415*", "\u041a\u0423\u0417\u041d\u0415\u0427\u041d\u041e\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004773", "2004773", "\u041e\u041f 168 \u041a\u041c*", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 168 \u041a\u041c *", "\u041e", null);
            RailwayStationsDataProvider.put("2004256", "2004256", "\u0425\u0418\u0419\u0422\u041e\u041b\u0410", "\u0425\u0418\u0419\u0422\u041e\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004774", "2004774", "\u0425\u0410\u0423\u041a\u041a\u0410\u0412\u0410\u0410\u0420", "\u0425\u0410\u0423\u041a\u041a\u0410\u0412\u0410\u0410\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004257", "2004257", "\u0410\u041b\u0425\u041e", "\u0410\u041b\u0425\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004258", "2004258", "\u042d\u041b\u0418\u0421\u0415\u041d\u0412\u0410\u0410\u0420", "\u042d\u041b\u0418\u0421\u0415\u041d\u0412\u0410\u0410\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004259", "2004259", "\u0410\u041a\u041a\u0410\u0425\u0410\u0420\u042c\u042e", "\u0410\u041a\u041a\u0410\u0425\u0410\u0420\u042c\u042e", "\u041e", null);
            RailwayStationsDataProvider.put("2004260", "2004260", "\u0418\u0425\u0410\u041b\u0410", "\u0418\u0425\u0410\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004261", "2004261", "\u042f\u041a\u041a\u0418\u041c\u0410", "\u042f\u041a\u041a\u0418\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004444", "2004444", "\u0425\u0423\u0425\u041e\u042f\u041c\u042f\u041a\u0418", "\u0425\u0423\u0425\u041e\u042f\u041c\u042f\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004262", "2004262", "\u041a\u0423\u041c\u041c\u0423\u041d\u0419\u041e\u041a\u0418", "\u041a\u0423\u041c\u041c\u0423\u041d\u0419\u041e\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004263", "2004263", "\u041d\u0418\u0412\u0410", "\u041d\u0418\u0412\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004264", "2004264", "\u041a\u0423\u041e\u041a\u041a\u0410\u041d\u0418\u042d\u041c", "\u041a\u0423\u041e\u041a\u041a\u0410\u041d\u0418\u042d\u041c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004265", "2004265", "\u0422\u0423\u041e\u041a\u0421\u041b\u0410\u0425\u0422\u0418", "\u0422\u0423\u041e\u041a\u0421\u041b\u0410\u0425\u0422\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004266", "2004266", "\u0421\u041e\u0420\u0422\u0410\u0412\u0410\u041b\u0410", "\u0421\u041e\u0420\u0422\u0410\u0412\u0410\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004267", "2004267", "\u0425\u0415\u041b\u042e\u041b\u042f", "\u0425\u0415\u041b\u042e\u041b\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004268", "2004268", "\u0420\u042e\u0422\u0422\u042e", "\u0420\u042e\u0422\u0422\u042e", "\u041e", null);
            RailwayStationsDataProvider.put("2004269", "2004269", "\u041a\u0410\u0410\u041b\u0410\u041c\u041e", "\u041a\u0410\u0410\u041b\u0410\u041c\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004270", "2004270", "\u041c\u0410\u0422\u041a\u0410\u0421\u0415\u041b\u042c\u041a", "\u041c\u0410\u0422\u041a\u0410\u0421\u0415\u041b\u042c\u041a\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004271", "2004271", "\u041f\u0418\u0420\u0422\u0422\u0418\u041f\u041e\u0425", "\u041f\u0418\u0420\u0422\u0422\u0418\u041f\u041e\u0425\u042c\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004272", "2004272", "\u0410\u041b\u0410\u041b\u0410\u041c\u041f\u0418", "\u0410\u041b\u0410\u041b\u0410\u041c\u041f\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004273", "2004273", "\u042f\u041d\u0418\u0421'\u042f\u0420\u0412\u0418", "\u042f\u041d\u0418\u0421'\u042f\u0420\u0412\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004274", "2004274", "\u0410\u041b\u0410\u0422\u0422\u0423", "\u0410\u041b\u0410\u0422\u0422\u0423", "\u041e", null);
            RailwayStationsDataProvider.put("2004275", "2004275", "\u0421\u0423\u0419\u0421\u0422\u0410\u041c\u041e", "\u0421\u0423\u0419\u0421\u0422\u0410\u041c\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004276", "2004276", "\u041b\u0415\u041f\u041f\u042f\u0421\u042e\u0420\u042c\u042f", "\u041b\u0415\u041f\u041f\u042f\u0421\u042e\u0420\u042c\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004776", "2004776", "\u041e\u041f 346 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 346 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004277", "2004277", "\u0420\u0410\u0419\u041a\u041e\u041d\u041a\u041e\u0421\u041a", "\u0420\u0410\u0419\u041a\u041e\u041d\u041a\u041e\u0421\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004278", "2004278", "\u041b\u041e\u0419\u041c\u041e\u041b\u0410", "\u041b\u041e\u0419\u041c\u041e\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004279", "2004279", "\u041d\u042f\u042f\u0422\u042f\u041e\u042f", "\u041d\u042f\u042f\u0422\u042f\u041e\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004280", "2004280", "\u041f\u0418\u0419\u0422\u0421\u0418\u0415\u041a\u0418", "\u041f\u0418\u0419\u0422\u0421\u0418\u0415\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004281", "2004281", "\u041f\u0410\u041f\u0415\u0420\u041e", "\u041f\u0410\u041f\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004282", "2004282", "\u0421\u0423\u041e\u042f\u0420\u0412\u0418 1", "\u0421\u0423\u041e\u042f\u0420\u0412\u0418 1", "\u041e", null);
            RailwayStationsDataProvider.put("2004314", "2004314", "\u0412\u0415\u0420\u041a\u041a\u041e", "\u0412\u0415\u0420\u041a\u041a\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004315", "2004315", "\u0425\u0410\u0423\u0422\u0410\u0412\u0410\u0410\u0420\u0410", "\u0425\u0410\u0423\u0422\u0410\u0412\u0410\u0410\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004316", "2004316", "\u0417\u0410\u0421\u0422\u0410\u0412\u0410", "\u0417\u0410\u0421\u0422\u0410\u0412\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004688", "2004688", "\u041d\u041e\u0412 \u041f\u0415\u0421\u041a\u0418", "\u041d\u041e\u0412\u042b\u0415 \u041f\u0415\u0421\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004777", "2004777", "\u0418\u041c\u0410\u0422\u041e\u0417\u0415\u0420\u041e", "\u0418\u041c\u0410\u0422\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004689", "2004689", "\u042d\u0421\u0421\u041e\u0419\u041b\u0410", "\u042d\u0421\u0421\u041e\u0419\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004317", "2004317", "\u0421\u042f\u041d\u042c\u0413\u0410", "\u0421\u042f\u041d\u042c\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004318", "2004318", "\u041a\u0423\u0422\u0418\u0416\u041c\u0410", "\u041a\u0423\u0422\u0418\u0416\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004319", "2004319", "\u0412\u0418\u041b\u041b\u0410\u0413\u041e\u0420\u0410", "\u0412\u0418\u041b\u041b\u0410\u0413\u041e\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005430", "2005430", "\u041e\u041f 509 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 509 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004320", "2004320", "\u041f\u0410\u0414\u041e\u0417\u0415\u0420\u041e", "\u041f\u0410\u0414\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004321", "2004321", "\u0427\u0410\u041b\u041d\u0410 \u041e\u041d\u0415\u0416", "\u0427\u0410\u041b\u041d\u0410-\u041e\u041d\u0415\u0416\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004329", "2004329", "\u0422\u041e\u041c\u0418\u0426\u042b", "\u0422\u041e\u041c\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004283", "2004283", "\u0421\u0423\u041e\u042f\u0420\u0412\u0418 2", "\u0421\u0423\u041e\u042f\u0420\u0412\u0418 2", "\u041e", null);
            RailwayStationsDataProvider.put("2004778", "2004778", "\u0421\u0423\u041e\u0415\u041a\u0418", "\u0421\u0423\u041e\u0415\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004779", "2004779", "\u041e\u041f 22 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 22 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004284", "2004284", "\u041d\u0410\u0419\u0421\u0422\u0415\u041d'\u042f\u0420", "\u041d\u0410\u0419\u0421\u0422\u0415\u041d'\u042f\u0420\u0412\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004490", "2004490", "\u041e\u041f 35 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 35 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004285", "2004285", "\u041b\u0410\u0425\u041a\u041e\u041b\u0410\u041c\u0415\u041d", "\u041b\u0410\u0425\u041a\u0410\u041b\u0410\u041c\u0415\u041d", "\u041e", null);
            RailwayStationsDataProvider.put("2004950", "2004950", "\u041e\u041f 55 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 55 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004286", "2004286", "\u0422\u0423\u041c\u0410\u0421\u041e\u0417\u0415\u0420\u041e", "\u0422\u0423\u041c\u0410\u0421\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004287", "2004287", "\u041f\u041e\u0420\u041e\u0421\u041e\u0417\u0415\u0420\u041e", "\u041f\u041e\u0420\u041e\u0421\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004288", "2004288", "\u0410\u041a\u041e\u041d'\u042f\u0420\u0412\u0418", "\u0410\u041a\u041e\u041d'\u042f\u0420\u0412\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004289", "2004289", "\u0413\u0418\u041c\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u0413\u0418\u041c\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004951", "2004951", "\u041e\u041f 123 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 123 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004952", "2004952", "\u0420\u0423\u0413\u041e\u041b\u0410\u041c\u0411\u0418", "\u0420\u0423\u0413\u041e\u041b\u0410\u041c\u0411\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004290", "2004290", "\u0421\u0423\u041a\u041a\u041e\u0417\u0415\u0420\u041e", "\u0421\u0423\u041a\u041a\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004291", "2004291", "\u0411\u0420\u0423\u0421\u041d\u0418\u0427\u041d\u0410\u042f", "\u0411\u0420\u0423\u0421\u041d\u0418\u0427\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004292", "2004292", "\u0421\u0423\u0423\u041d", "\u0421\u0423\u0423\u041d", "\u041e", null);
            RailwayStationsDataProvider.put("2004898", "2004898", "\u041e\u041f 170 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 170 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004293", "2004293", "\u041c\u041e\u0422\u041a\u041e", "\u041c\u041e\u0422\u041a\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004953", "2004953", "\u0420\u0417\u0414 197 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 197 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004294", "2004294", "\u041b\u0415\u041d\u0414\u0415\u0420\u042b", "\u041b\u0415\u041d\u0414\u0415\u0420\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004954", "2004954", "\u041a\u0410\u041d\u0413\u0410\u0421", "\u041a\u0410\u041d\u0413\u0410\u0421", "\u041e", null);
            RailwayStationsDataProvider.put("2004295", "2004295", "\u041f\u0415\u041d\u0418\u041d\u0413\u0410", "\u041f\u0415\u041d\u0418\u041d\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004955", "2004955", "\u0412\u041e\u041b\u041e\u041c\u0410", "\u0412\u041e\u041b\u041e\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004296", "2004296", "\u0421\u041e\u041d\u041e\u0417\u0415\u0420\u041e", "\u0421\u041e\u041d\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004956", "2004956", "\u0421\u0415\u041b\u042c\u0413\u0410", "\u0421\u0415\u041b\u042c\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004297", "2004297", "\u041c\u0423\u0415\u0417\u0415\u0420\u041a\u0410", "\u041c\u0423\u0415\u0417\u0415\u0420\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004298", "2004298", "\u041b\u0415\u0414\u041c\u041e\u0417\u0415\u0420\u041e", "\u041b\u0415\u0414\u041c\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004299", "2004299", "\u0425\u0418\u0416\u041e\u0417\u0415\u0420\u041e", "\u0425\u0418\u0416\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004301", "2004301", "\u0411\u041e\u0420\u041e\u0412\u0410\u042f", "\u0411\u041e\u0420\u041e\u0412\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005300", "2005300", "\u042e\u0428\u041a\u041e\u0417\u0415\u0420\u041e", "\u042e\u0428\u041a\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004445", "2004445", "\u0425\u042f\u041c\u0415\u041a\u041e\u0421\u041a\u0418", "\u0425\u042f\u041c\u0415\u041a\u041e\u0421\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004302", "2004302", "\u0425\u0410\u0420\u041b\u0423", "\u0425\u0410\u0420\u041b\u0423", "\u041e", null);
            RailwayStationsDataProvider.put("2004303", "2004303", "\u041b\u042f\u0421\u041a\u0415\u041b\u042f", "\u041b\u042f\u0421\u041a\u0415\u041b\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004957", "2004957", "\u0412\u042f\u041b\u0418\u041c\u042f\u041a\u0418", "\u0412\u042f\u041b\u0418\u041c\u042f\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004304", "2004304", "\u0418\u041c\u041f\u0418\u041b\u0410\u0425\u0422\u0418", "\u0418\u041c\u041f\u0418\u041b\u0410\u0425\u0422\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004427", "2004427", "\u041b\u0415\u041f\u041f\u042f\u0421\u0418\u041b\u0422\u0410", "\u041b\u0415\u041f\u041f\u042f\u0421\u0418\u041b\u0422\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004305", "2004305", "\u041a\u0418\u0422\u0415\u041b\u042f", "\u041a\u0418\u0422\u0415\u041b\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004420", "2004420", "\u041a\u041e\u0419\u0420\u0418\u041d\u041e\u042f", "\u041a\u041e\u0419\u0420\u0418\u041d\u041e\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004685", "2004685", "\u041f\u0418\u0422\u041a\u042f\u0420\u0410\u041d\u0422\u0410", "\u041f\u0418\u0422\u041a\u042f\u0420\u0410\u041d\u0422\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004306", "2004306", "\u0418\u041b\u042f \u0423\u0423\u041a\u0421\u0423", "\u0418\u041b\u042f-\u0423\u0423\u041a\u0421\u0423", "\u041e", null);
            RailwayStationsDataProvider.put("2004307", "2004307", "\u0423\u0423\u041a\u0421\u0423 2", "\u0423\u0423\u041a\u0421\u0423 2", "\u041e", null);
            RailwayStationsDataProvider.put("2004958", "2004958", "\u0421\u0410\u0422\u0423\u041b\u0418", "\u0421\u0410\u0422\u0423\u041b\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004308", "2004308", "\u0421\u0410\u041b\u041c\u0418", "\u0421\u0410\u041b\u041c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004309", "2004309", "\u041a\u0423\u0420\u041a\u0423\u041d\u041a\u0423\u041b\u0410", "\u041a\u0423\u0420\u041a\u0423\u041d\u041a\u0423\u041b\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004310", "2004310", "\u041f\u041e\u0413\u0420\u0410\u041d\u041a\u041e\u041d\u0414", "\u041f\u041e\u0413\u0420\u0410\u041d\u041a\u041e\u041d\u0414\u0423\u0428\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004686", "2004686", "\u0412\u0418\u0414\u041b\u0418\u0426\u0410", "\u0412\u0418\u0414\u041b\u0418\u0426\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004311", "2004311", "\u0422\u0423\u041b\u041e\u041a\u0421\u0410", "\u0422\u0423\u041b\u041e\u041a\u0421\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004312", "2004312", "\u0418\u041b\u042c\u0418\u041d\u0421\u041a\u0410\u042f", "\u0418\u041b\u042c\u0418\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004313", "2004313", "\u0422\u0423\u0423\u041a\u0421\u0410", "\u0422\u0423\u0423\u041a\u0421\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004687", "2004687", "\u041e\u041b\u041e\u041d\u0415\u0426", "\u041e\u041b\u041e\u041d\u0415\u0426", "\u041e", null);
            RailwayStationsDataProvider.put("2004225", "2004225", "\u0418\u041d\u0415\u041c\u0410", "\u0418\u041d\u0415\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004678", "2004678", "\u041b\u041e\u0414 \u041f\u041e\u041b\u0415", "\u041b\u041e\u0414\u0415\u0419\u041d\u041e\u0415 \u041f\u041e\u041b\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005045", "2005045", "\u041b\u0410\u041d\u0421\u041a\u0410\u042f", "\u041b\u0410\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005065", "2005065", "\u0423\u0414\u0415\u041b\u042c\u041d\u0410\u042f", "\u0423\u0414\u0415\u041b\u042c\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005339", "2005339", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041e\u0417\u0415\u0420\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005260", "2005260", "\u0428\u0423\u0412\u0410\u041b\u041e\u0412\u041e", "\u0428\u0423\u0412\u0410\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005455", "2005455", "\u041f\u0410\u0420\u0413\u041e\u041b\u041e\u0412\u041e", "\u041f\u0410\u0420\u0413\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005235", "2005235", "\u041b\u0415\u0412\u0410\u0428\u041e\u0412\u041e", "\u041b\u0415\u0412\u0410\u0428\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005145", "2005145", "\u041f\u0415\u0421\u041e\u0427\u041d\u0410\u042f", "\u041f\u0415\u0421\u041e\u0427\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005399", "2005399", "\u0414\u0418\u0411\u0423\u041d\u042b", "\u0414\u0418\u0411\u0423\u041d\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004231", "2004231", "\u0411\u0415\u041b\u041e\u041e\u0421\u0422\u0420\u041e\u0412", "\u0411\u0415\u041b\u041e\u041e\u0421\u0422\u0420\u041e\u0412", "\u041e", null);
            RailwayStationsDataProvider.put("2005330", "2005330", "\u0421\u041e\u041b\u041d\u0415\u0427\u041d\u041e\u0415", "\u0421\u041e\u041b\u041d\u0415\u0427\u041d\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005225", "2005225", "\u0420\u0415\u041f\u0418\u041d\u041e", "\u0420\u0415\u041f\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005340", "2005340", "\u041a\u041e\u041c\u0410\u0420\u041e\u0412\u041e", "\u041a\u041e\u041c\u0410\u0420\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004232", "2004232", "\u0417\u0415\u041b\u0415\u041d\u041e\u0413\u041e\u0420\u0421", "\u0417\u0415\u041b\u0415\u041d\u041e\u0413\u041e\u0420\u0421\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2005366", "2005366", "\u0423\u0428\u041a\u041e\u0412\u041e", "\u0423\u0428\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005185", "2005185", "\u0420\u041e\u0429\u0418\u041d\u041e", "\u0420\u041e\u0429\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005298", "2005298", "\u041e\u041f 63 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 63 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005116", "2005116", "\u0413\u041e\u0420\u042c\u041a\u041e\u0412\u0421\u041a", "\u0413\u041e\u0420\u042c\u041a\u041e\u0412\u0421\u041a\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005939", "2005939", "\u041e\u041f 73 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 73 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005048", "2005048", "\u041a\u0410\u041d\u041d\u0415\u041b\u042c\u042f\u0420\u0412", "\u041a\u0410\u041d\u041d\u0415\u041b\u042c\u042f\u0420\u0412\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005196", "2005196", "\u0417\u0410\u0425\u041e\u0414\u0421\u041a\u041e\u0415", "\u0417\u0410\u0425\u041e\u0414\u0421\u041a\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005304", "2005304", "\u041a\u0418\u0420\u0418\u041b\u041b\u041e\u0412\u0421\u041a", "\u041a\u0418\u0420\u0418\u041b\u041b\u041e\u0412\u0421\u041a\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005199", "2005199", "\u041b\u0415\u0419\u041f\u042f\u0421\u0423\u041e", "\u041b\u0415\u0419\u041f\u042f\u0421\u0423\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005266", "2005266", "\u0413\u0410\u0412\u0420\u0418\u041b\u041e\u0412\u041e", "\u0413\u0410\u0412\u0420\u0418\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005333", "2005333", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041a\u0410", "\u041b\u0415\u0411\u0415\u0414\u0415\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005216", "2005216", "\u0412\u0415\u0420\u0425\u041d\u0415\u0427\u0415\u0420\u041a", "\u0412\u0415\u0420\u0425\u041d\u0415\u0427\u0415\u0420\u041a\u0410\u0421\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005404", "2005404", "\u041b\u0410\u0417\u041e\u0420\u0415\u0412\u041a\u0410", "\u041b\u0410\u0417\u041e\u0420\u0415\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004682", "2004682", "\u0412\u042b\u0411\u041e\u0420\u0413", "\u0412\u042b\u0411\u041e\u0420\u0413", "\u041e", null);
            RailwayStationsDataProvider.put("2005311", "2005311", "\u041f\u0420\u0418\u0413\u041e\u0420\u041e\u0414\u041d*", "\u041f\u0420\u0418\u0413\u041e\u0420\u041e\u0414\u041d\u0410\u042f *", "\u041e", null);
            RailwayStationsDataProvider.put("2004901", "2004901", "\u041e\u041f 138 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 138 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005279", "2005279", "\u041a\u0420\u0410\u0412\u0426\u041e\u0412\u041e *", "\u041a\u0420\u0410\u0412\u0426\u041e\u0412\u041e *", "\u041e", null);
            RailwayStationsDataProvider.put("2004025", "2004025", "\u041b\u0423\u0416\u0410\u0419\u041a\u0410  *", "\u041b\u0423\u0416\u0410\u0419\u041a\u0410 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004928", "2004928", "\u0411\u0423\u0421\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0411\u0423\u0421\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004003", "2004003", "\u0421-\u041f\u0415\u0422-\u0412\u0418\u0422", "\u0421\u0410\u041d\u041a\u0422-\u041f\u0415\u0422\u0415\u0420\u0411\u0423\u0420\u0413-\u0412\u0418\u0422\u0415\u0411.", "\u041e", null);
            RailwayStationsDataProvider.put("2005315", "2005315", "\u0412\u041e\u0417\u0414 \u041f\u0410\u0420\u041a", "\u0412\u041e\u0417\u0414\u0423\u0425-\u041f\u0410\u0420\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2005020", "2005020", "\u041f\u0420 \u0421\u041b\u0410\u0412\u042b", "\u041f\u0420\u041e\u0421\u041f\u0415\u041a\u0422 \u0421\u041b\u0410\u0412\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2005001", "2005001", "\u041a\u0423\u041f\u0427\u0418\u041d\u041e", "\u041a\u0423\u041f\u0427\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005166", "2005166", "\u0428\u0423\u0428\u0410\u0420\u042b", "\u0428\u0423\u0428\u0410\u0420\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004780", "2004780", "\u041f\u0410\u0420\u041e\u0412\u041e\u0417 \u041c", "\u041f\u0410\u0420\u041e\u0412\u041e\u0417\u041d\u042b\u0419 \u041c\u0423\u0417\u0415\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2004923", "2004923", "\u041e\u041f 21 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 21 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004182", "2004182", "\u0414\u0415\u0422\u0421\u041a \u0421\u0415\u041b\u041e", "\u0414\u0415\u0422\u0421\u041a\u041e\u0415 \u0421\u0415\u041b\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004181", "2004181", "\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a", "\u041f\u0410\u0412\u041b\u041e\u0412\u0421\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2005046", "2005046", "\u0410\u041d\u0422\u0420\u041e\u041f\u0428\u0418\u041d\u041e", "\u0410\u041d\u0422\u0420\u041e\u041f\u0428\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005096", "2005096", "\u041a\u041e\u0411\u0420\u0410\u041b\u041e\u0412\u041e", "\u041a\u041e\u0411\u0420\u0410\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005236", "2005236", "\u0421\u0415\u041c\u0420\u0418\u041d\u041e", "\u0421\u0415\u041c\u0420\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004781", "2004781", "\u041e\u041f 46 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 46 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005454", "2005454", "\u0421\u0423\u0421\u0410\u041d\u0418\u041d\u041e", "\u0421\u0423\u0421\u0410\u041d\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005369", "2005369", "\u041a\u0420\u0410\u0421\u041d\u0418\u0426\u0410", "\u041a\u0420\u0410\u0421\u041d\u0418\u0426\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005296", "2005296", "\u041c\u0418\u0425\u0410\u0419\u041b\u041e\u0412\u041a\u0410", "\u041c\u0418\u0425\u0410\u0419\u041b\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004180", "2004180", "\u0412\u042b\u0420\u0418\u0426\u0410", "\u0412\u042b\u0420\u0418\u0426\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004179", "2004179", "\u0421\u041b\u0423\u0414\u0418\u0426\u042b", "\u0421\u041b\u0423\u0414\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004178", "2004178", "\u041d\u041e\u0412\u0418\u041d\u041a\u0410", "\u041d\u041e\u0412\u0418\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004177", "2004177", "\u0427\u0410\u0429\u0410", "\u0427\u0410\u0429\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005431", "2005431", "\u041e\u041f 100 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 100 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005445", "2005445", "\u041e\u041f 101 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 101 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004176", "2004176", "\u0427\u041e\u041b\u041e\u0412\u041e", "\u0427\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004175", "2004175", "\u0422\u0410\u0420\u041a\u041e\u0412\u0418\u0427\u0418", "\u0422\u0410\u0420\u041a\u041e\u0412\u0418\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005448", "2005448", "\u041e\u041f 125 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 125 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004641", "2004641", "\u041e\u0420\u0415\u0414\u0415\u0416", "\u041e\u0420\u0415\u0414\u0415\u0416", "\u041e", null);
            RailwayStationsDataProvider.put("2004116", "2004116", "\u0417\u0410\u041a\u041b\u0418\u041d\u042c\u0415", "\u0417\u0410\u041a\u041b\u0418\u041d\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004612", "2004612", "\u0411\u0410\u0422\u0415\u0426\u041a\u0410\u042f", "\u0411\u0410\u0422\u0415\u0426\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004115", "2004115", "\u0411\u0410\u0425\u0410\u0420\u0415\u0412\u041e", "\u0411\u0410\u0425\u0410\u0420\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004611", "2004611", "\u041f\u0415\u0420\u0415\u0414\u041e\u041b\u042c\u0421\u041a", "\u041f\u0415\u0420\u0415\u0414\u041e\u041b\u042c\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004609", "2004609", "\u041a\u0427\u0415\u0420\u042b", "\u041a\u0427\u0415\u0420\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004608", "2004608", "\u0423\u0422\u041e\u0420\u0413\u041e\u0428", "\u0423\u0422\u041e\u0420\u0413\u041e\u0428", "\u041e", null);
            RailwayStationsDataProvider.put("2004607", "2004607", "\u041d\u0418\u0417\u042b", "\u041d\u0418\u0417\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004606", "2004606", "\u0421\u041e\u041b\u042c\u0426\u042b", "\u0421\u041e\u041b\u042c\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2005433", "2005433", "\u0420\u0417\u0414 210 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 210 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004605", "2004605", "\u041a\u0423\u041a\u041b\u0418\u041d\u041e", "\u041a\u0423\u041a\u041b\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004959", "2004959", "\u041e\u041f 219 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 219 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004604", "2004604", "\u041b\u0415\u041c\u0415\u041d\u041a\u0410", "\u041b\u0415\u041c\u0415\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004960", "2004960", "\u041e\u041f 230 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 230 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004961", "2004961", "\u0420\u0417\u0414 232 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 232 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004603", "2004603", "\u0413\u0410\u0427\u041a\u0418", "\u0413\u0410\u0427\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005314", "2005314", "\u041e\u041f 238 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 238 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005067", "2005067", "\u041e\u041f 241 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 241 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004570", "2004570", "\u0414\u041d\u041e", "\u0414\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005232", "2005232", "\u041e\u041f 251 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 251 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004529", "2004529", "\u0412\u042f\u0417\u042c\u0415", "\u0412\u042f\u0417\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005425", "2005425", "\u041e\u041f 258 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 258 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005294", "2005294", "\u041e\u041f 264 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 264 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004528", "2004528", "\u0411\u0410\u041a\u0410\u0427", "\u0411\u0410\u041a\u0410\u0427", "\u041e", null);
            RailwayStationsDataProvider.put("2005331", "2005331", "\u041e\u041f 272 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 272 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004527", "2004527", "\u0414\u0415\u0414\u041e\u0412\u0418\u0427\u0418", "\u0414\u0415\u0414\u041e\u0412\u0418\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004526", "2004526", "\u0421\u0423\u0414\u041e\u041c\u0410", "\u0421\u0423\u0414\u041e\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004525", "2004525", "\u041f\u041b\u041e\u0422\u041e\u0412\u0415\u0426", "\u041f\u041b\u041e\u0422\u041e\u0412\u0415\u0426", "\u041e", null);
            RailwayStationsDataProvider.put("2005426", "2005426", "\u041e\u041f 301 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 301 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004524", "2004524", "\u0427\u0418\u0425\u0410\u0427\u0415\u0412\u041e", "\u0427\u0418\u0425\u0410\u0427\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004523", "2004523", "\u0410\u0428\u0415\u0412\u041e", "\u0410\u0428\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004051", "2004051", "\u041b\u041e\u0417\u041e\u0412\u0418\u0426\u042b", "\u041b\u041e\u0417\u041e\u0412\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004560", "2004560", "\u0421\u0423\u0429\u0415\u0412\u041e", "\u0421\u0423\u0429\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004050", "2004050", "\u0417\u0410\u0413\u041e\u0421\u041a\u0418\u041d\u041e", "\u0417\u0410\u0413\u041e\u0421\u041a\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004049", "2004049", "\u0422\u0418\u0413\u041e\u0429\u0418", "\u0422\u0418\u0413\u041e\u0429\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004522", "2004522", "\u041b\u041e\u041a\u041d\u042f", "\u041b\u041e\u041a\u041d\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004521", "2004521", "\u0421\u0422\u0420\u0418\u041c\u041e\u0412\u0418\u0427\u0418", "\u0421\u0422\u0420\u0418\u041c\u041e\u0412\u0418\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004519", "2004519", "\u0421\u0410\u041c\u041e\u041b\u0423\u041a\u041e\u0412\u041e", "\u0421\u0410\u041c\u041e\u041b\u0423\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004518", "2004518", "\u041d\u0410\u0421\u0412\u0410", "\u041d\u0410\u0421\u0412\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004517", "2004517", "\u041a\u0418\u0421\u0415\u041b\u0415\u0412\u0418\u0427\u0418", "\u041a\u0418\u0421\u0415\u041b\u0415\u0412\u0418\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004048", "2004048", "\u0428\u0423\u0411\u0418\u041d\u041e", "\u0428\u0423\u0411\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004508", "2004508", "\u041d\u041e\u0412\u041e\u0421\u041e\u041a\u041e\u041b", "\u041d\u041e\u0412\u041e\u0421\u041e\u041a\u041e\u041b\u042c\u041d\u0418\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004507", "2004507", "\u0412\u041b\u0410\u0421\u042c\u0415", "\u0412\u041b\u0410\u0421\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004506", "2004506", "\u0418\u0417\u041e\u0427\u0410", "\u0418\u0417\u041e\u0427\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005337", "2005337", "\u0420\u0417\u0414 451 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 451 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004039", "2004039", "\u041a\u0410\u0420\u0410\u0422\u0410\u0419", "\u041a\u0410\u0420\u0410\u0422\u0410\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2005189", "2005189", "\u0413\u041e\u0420\u0423\u0428\u041a\u0418 \u041d", "\u0413\u041e\u0420\u0423\u0428\u041a\u0418 \u041d\u0415\u0412\u0415\u041b\u042c\u0421\u041a\u0418\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004550", "2004550", "\u041d\u0415\u0412\u0415\u041b\u042c 2", "\u041d\u0415\u0412\u0415\u041b\u042c 2", "\u041e", null);
            RailwayStationsDataProvider.put("2004038", "2004038", "\u0417\u0410\u0412\u0415\u0420\u0415\u0416\u042c\u0415", "\u0417\u0410\u0412\u0415\u0420\u0415\u0416\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004639", "2004639", "\u0413\u0410\u0422\u0427\u0418\u041d \u0412\u0410\u0420", "\u0413\u0410\u0422\u0427\u0418\u041d\u0410 \u0412\u0410\u0420\u0428\u0410\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004963", "2004963", "\u0420\u0417\u0414 47 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 47 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004173", "2004173", "\u0421\u0423\u0419\u0414\u0410", "\u0421\u0423\u0419\u0414\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005072", "2005072", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u041e\u0412\u041e", "\u041f\u0420\u0418\u0411\u042b\u0422\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005156", "2005156", "\u041a\u0410\u0420\u0422\u0410\u0428\u0415\u0412\u0421\u041a", "\u041a\u0410\u0420\u0422\u0410\u0428\u0415\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004638", "2004638", "\u0421\u0418\u0412\u0415\u0420\u0421\u041a\u0410\u042f", "\u0421\u0418\u0412\u0415\u0420\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005011", "2005011", "\u041b\u0410\u041c\u041f\u041e\u0412\u041e", "\u041b\u0410\u041c\u041f\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004172", "2004172", "\u0421\u0422\u0420\u041e\u0413\u0410\u041d\u041e\u0412\u041e", "\u0421\u0422\u0420\u041e\u0413\u0410\u041d\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004171", "2004171", "\u0414\u0418\u0412\u0415\u041d\u0421\u041a\u0410\u042f", "\u0414\u0418\u0412\u0415\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004170", "2004170", "\u041d\u0418\u0417\u041e\u0412\u0421\u041a\u0410\u042f", "\u041d\u0418\u0417\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005040", "2005040", "\u0420\u041e\u0421\u0418\u041d\u041a\u0410", "\u0420\u041e\u0421\u0418\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004169", "2004169", "\u041c\u0428\u0418\u041d\u0421\u041a\u0410\u042f", "\u041c\u0428\u0418\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005393", "2005393", "\u0410 \u041f\u0415\u0422\u0420\u041e\u0412\u041e\u0419", "\u0410\u041d\u0422\u041e\u041d\u0418\u041d\u042b \u041f\u0415\u0422\u0420\u041e\u0412\u041e\u0419", "\u041e", null);
            RailwayStationsDataProvider.put("2004637", "2004637", "\u0422\u041e\u041b\u041c\u0410\u0427\u0415\u0412\u041e", "\u0422\u041e\u041b\u041c\u0410\u0427\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005319", "2005319", "\u041f\u0410\u0420\u0422\u0418\u0417\u0410\u041d\u0421\u041a", "\u041f\u0410\u0420\u0422\u0418\u0417\u0410\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004964", "2004964", "\u0413\u0415\u041d \u041e\u041c\u0415\u041b\u042c\u0427", "\u0413\u0415\u041d\u0415\u0420\u0410\u041b\u0410 \u041e\u041c\u0415\u041b\u042c\u0427\u0415\u041d\u041a\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004636", "2004636", "\u041b\u0423\u0413\u0410 1", "\u041b\u0423\u0413\u0410 1", "\u041e", null);
            RailwayStationsDataProvider.put("2004965", "2004965", "\u0420\u0417\u0414 144 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 144 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005079", "2005079", "\u041a\u0410\u041b\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u041a\u0410\u041b\u0413\u0410\u041d\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004546", "2004546", "\u0421\u0415\u0420\u0415\u0411\u0420\u042f\u041d\u041a\u0410", "\u0421\u0415\u0420\u0415\u0411\u0420\u042f\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004545", "2004545", "\u041b\u042f\u041c\u0426\u0415\u0412\u041e", "\u041b\u042f\u041c\u0426\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004544", "2004544", "\u041f\u041b\u042e\u0421\u0421\u0410", "\u041f\u041b\u042e\u0421\u0421\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005141", "2005141", "\u0420\u0417\u0414 197 \u041a\u041c", "\u0420\u0410\u0417'\u0415\u0417\u0414 197 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004543", "2004543", "\u0421\u0422\u0420\u0423\u0413\u0418 \u041a\u0420", "\u0421\u0422\u0420\u0423\u0413\u0418 \u041a\u0420\u0410\u0421\u041d\u042b\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004542", "2004542", "\u0412\u041b \u041b\u0410\u0413\u0415\u0420\u042c", "\u0412\u041b\u0410\u0414\u0418\u041c\u0418\u0420\u0421\u041a\u0418\u0419 \u041b\u0410\u0413\u0415\u0420\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2004068", "2004068", "\u041b\u0410\u041f\u0418\u041d\u041e", "\u041b\u0410\u041f\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004541", "2004541", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u042c\u0415", "\u041d\u041e\u0412\u041e\u0421\u0415\u041b\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004966", "2004966", "\u041e\u041f 233 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 233 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004539", "2004539", "\u041c\u041e\u041b\u041e\u0414\u0418", "\u041c\u041e\u041b\u041e\u0414\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004897", "2004897", "\u041e\u041f 246 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 246 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004538", "2004538", "\u0422\u041e\u0420\u041e\u0428\u0418\u041d\u041e", "\u0422\u041e\u0420\u041e\u0428\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005017", "2005017", "\u041e\u041f 259 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 259 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005348", "2005348", "\u041e\u041f 262 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 262 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004067", "2004067", "\u0427\u0415\u0420\u041d\u042f\u041a\u041e\u0412\u0418\u0426", "\u0427\u0415\u0420\u041d\u042f\u041a\u041e\u0412\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004066", "2004066", "\u041b\u042e\u0411\u042f\u0422\u041e\u0412\u041e", "\u041b\u042e\u0411\u042f\u0422\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004500", "2004500", "\u041f\u0421\u041a\u041e\u0412 \u041f\u0410\u0421\u0421", "\u041f\u0421\u041a\u041e\u0412-\u041f\u0410\u0421\u0421", "\u041e", null);
            RailwayStationsDataProvider.put("2004065", "2004065", "\u0427\u0415\u0420\u0415\u0425\u0410", "\u0427\u0415\u0420\u0415\u0425\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004967", "2004967", "\u0421\u041e\u041b\u041e\u0412\u042c\u0418", "\u0421\u041e\u041b\u041e\u0412\u042c\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004064", "2004064", "\u0421\u0422\u0420\u0415\u041c\u0423\u0422\u041a\u0410", "\u0421\u0422\u0420\u0415\u041c\u0423\u0422\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004537", "2004537", "\u0427\u0415\u0420\u0421\u041a\u0410\u042f", "\u0427\u0415\u0420\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004063", "2004063", "\u0414\u0423\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u0414\u0423\u041b\u041e\u0412\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004968", "2004968", "\u0429\u0415\u041f\u0415\u0426", "\u0429\u0415\u041f\u0415\u0426", "\u041e", null);
            RailwayStationsDataProvider.put("2004536", "2004536", "\u041e\u0421\u0422\u0420\u041e\u0412", "\u041e\u0421\u0422\u0420\u041e\u0412", "\u041e", null);
            RailwayStationsDataProvider.put("2004535", "2004535", "\u0411\u0420\u042f\u041d\u0427\u0410\u041d\u0418\u041d", "\u0411\u0420\u042f\u041d\u0427\u0410\u041d\u0418\u041d\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004881", "2004881", "\u041e\u041f 345 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 345 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004969", "2004969", "\u0413\u041e\u041b\u042c\u0426\u0415\u0412\u041e", "\u0413\u041e\u041b\u042c\u0426\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004534", "2004534", "\u0420\u0418\u0422\u0423\u041f\u0415", "\u0420\u0418\u0422\u0423\u041f\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004970", "2004970", "\u041f\u0418\u0420\u0410\u0413\u0418", "\u041f\u0418\u0420\u0410\u0413\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004435", "2004435", "\u041f\u042b\u0422\u0410\u041b\u041e\u0412\u041e", "\u041f\u042b\u0422\u0410\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004356", "2004356", "\u041f\u0423\u041d\u0414\u0423\u0420\u0418", "\u041f\u0423\u041d\u0414\u0423\u0420\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004357", "2004357", "\u0421\u041a\u0410\u041d\u0413\u0410\u041b\u0418", "\u0421\u041a\u0410\u041d\u0413\u0410\u041b\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005460", "2005460", "\u041b\u0418\u0413\u041e\u0412\u041e", "\u041b\u0418\u0413\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005030", "2005030", "\u0421\u041e\u0421 \u041f\u041e\u041b\u042f\u041d\u0410", "\u0421\u041e\u0421\u041d\u041e\u0412\u0410\u042f \u041f\u041e\u041b\u042f\u041d\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005175", "2005175", "\u0412\u041e\u041b\u041e\u0414\u0410\u0420\u0421\u041a", "\u0412\u041e\u041b\u041e\u0414\u0410\u0420\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005150", "2005150", "\u0421\u0422\u0420\u0415\u041b\u042c\u041d\u0410", "\u0421\u0422\u0420\u0415\u041b\u042c\u041d\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005086", "2005086", "\u041a\u0420\u0410\u0421\u041d \u0417\u041e\u0420\u0418", "\u041a\u0420\u0410\u0421\u041d\u042b\u0415 \u0417\u041e\u0420\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2006300", "2006300", "\u041d \u041f\u0415\u0422\u0415\u0420\u0413\u041e\u0424", "\u041d\u041e\u0412\u042b\u0419 \u041f\u0415\u0422\u0415\u0420\u0413\u041e\u0424", "\u041e", null);
            RailwayStationsDataProvider.put("2005155", "2005155", "\u0421 \u041f\u0415\u0422\u0415\u0420\u0413\u041e\u0424", "\u0421\u0422\u0410\u0420\u042b\u0419 \u041f\u0415\u0422\u0415\u0420\u0413\u041e\u0424", "\u041e", null);
            RailwayStationsDataProvider.put("2005385", "2005385", "\u0423\u041d\u0418\u0412\u0415\u0420\u0421\u0418\u0422", "\u0423\u041d\u0418\u0412\u0415\u0420\u0421\u0418\u0422\u0415\u0422", "\u041e", null);
            RailwayStationsDataProvider.put("2005230", "2005230", "\u041c\u0410\u0420\u0422\u042b\u0428\u041a\u0418\u041d\u041e", "\u041c\u0410\u0420\u0422\u042b\u0428\u041a\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004645", "2004645", "\u041e\u0420\u0410\u041d\u0418\u0415\u041d\u0411", "\u041e\u0420\u0410\u041d\u0418\u0415\u041d\u0411\u0410\u0423\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005281", "2005281", "\u041a\u0420\u041e\u041d \u041a\u041e\u041b\u041e\u041d", "\u041a\u0420\u041e\u041d\u0428\u0422\u0410\u0414\u0422\u0421\u041a\u0410\u042f \u041a\u041e\u041b\u041e\u041d\u0418\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005074", "2005074", "\u0411\u0420\u041e\u041d\u041a\u0410", "\u0411\u0420\u041e\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005076", "2005076", "\u0414\u0423\u0411\u041e\u0427\u041a\u0418", "\u0414\u0423\u0411\u041e\u0427\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004196", "2004196", "\u0411 \u0418\u0416\u041e\u0420\u0410", "\u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0418\u0416\u041e\u0420\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005378", "2005378", "\u0427\u0410\u0419\u041a\u0410    *", "\u0427\u0410\u0419\u041a\u0410 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004195", "2004195", "\u041b\u0415\u0411\u042f\u0416\u042c\u0415  *", "\u041b\u0415\u0411\u042f\u0416\u042c\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004971", "2004971", "\u041e\u041f 68 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 68 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004972", "2004972", "\u041a\u041e\u0412\u0410\u0428\u0418   *", "\u041a\u041e\u0412\u0410\u0428\u0418 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004973", "2004973", "\u041a\u0410\u0420\u042c\u0415\u0420", "\u041a\u0410\u0420\u042c\u0415\u0420", "\u041e", null);
            RailwayStationsDataProvider.put("2006357", "2006357", "\u041f\u041b 80 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 80 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004194", "2004194", "\u041a\u0410\u041b\u0418\u0429\u0415   *", "\u041a\u0410\u041b\u0418\u0429\u0415 *", "\u041e", null);
            RailwayStationsDataProvider.put("2005372", "2005372", "\u0412\u041e\u0420\u041e\u041d\u041a\u0410  *", "\u0412\u041e\u0420\u041e\u041d\u041a\u0410 *", "\u041e", null);
            RailwayStationsDataProvider.put("2004193", "2004193", "\u041a\u041e\u041f\u041e\u0420\u042c\u0415", "\u041a\u041e\u041f\u041e\u0420\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005227", "2005227", "\u041a\u0423\u041c\u041c\u041e\u041b\u041e\u0412\u041e", "\u041a\u0423\u041c\u041c\u041e\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004974", "2004974", "\u041f\u041b \u041d\u0418\u041a\u041e\u041b", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 \u041d\u0418\u041a\u041e\u041b\u0410\u0415\u0412\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004192", "2004192", "\u041a\u041e\u0422\u041b\u042b", "\u041a\u041e\u0422\u041b\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004422", "2004422", "\u041a\u0418\u0425\u0422\u041e\u041b\u041a\u0410", "\u041a\u0418\u0425\u0422\u041e\u041b\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004975", "2004975", "\u0421\u0410\u041b\u041a\u0410", "\u0421\u0410\u041b\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004191", "2004191", "\u041a\u0415\u0420\u0421\u0422\u041e\u0412\u041e", "\u041a\u0415\u0420\u0421\u0422\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004644", "2004644", "\u0412\u0415\u0419\u041c\u0410\u0420\u041d", "\u0412\u0415\u0419\u041c\u0410\u0420\u041d", "\u041e", null);
            RailwayStationsDataProvider.put("2004190", "2004190", "\u041a\u041b\u0415\u041d\u041d\u0410", "\u041a\u041b\u0415\u041d\u041d\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004424", "2004424", "\u041a\u0420\u0418\u0423\u0428\u0418", "\u041a\u0420\u0418\u0423\u0428\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004189", "2004189", "\u0422\u0423\u0413\u0410\u041d\u042b", "\u0422\u0423\u0413\u0410\u041d\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004976", "2004976", "\u041e\u041f 183 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 183 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004188", "2004188", "\u0412\u0415\u0420\u0412\u0415\u041d\u041a\u0410", "\u0412\u0415\u0420\u0412\u0415\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004187", "2004187", "\u0418\u0429\u0415\u0412\u041e", "\u0418\u0429\u0415\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004186", "2004186", "\u0420\u0423\u0414\u041d\u0418\u0427\u041d\u0410\u042f", "\u0420\u0423\u0414\u041d\u0418\u0427\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004643", "2004643", "\u0421\u041b\u0410\u041d\u0426\u042b", "\u0421\u041b\u0410\u041d\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004185", "2004185", "\u0413\u041e\u0421\u0422\u0418\u0426\u042b", "\u0413\u041e\u0421\u0422\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004977", "2004977", "\u0420\u0417\u0414 N8", "\u0420\u0410\u0417'\u0415\u0417\u0414 N8", "\u041e", null);
            RailwayStationsDataProvider.put("2004184", "2004184", "\u0414\u041e\u0411\u0420\u0423\u0427\u0418", "\u0414\u041e\u0411\u0420\u0423\u0427\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2004183", "2004183", "\u041b\u042f\u0414\u041e\u0426\u041a\u0418\u0419 \u041f", "\u041b\u042f\u0414\u041e\u0426\u041a\u0418\u0419 \u041f\u0415\u0420\u0415\u0415\u0417\u0414", "\u041e", null);
            RailwayStationsDataProvider.put("2004978", "2004978", "\u0420\u0417\u0414 N7", "\u0420\u0410\u0417'\u0415\u0417\u0414 N7", "\u041e", null);
            RailwayStationsDataProvider.put("2004642", "2004642", "\u0413\u0414\u041e\u0412", "\u0413\u0414\u041e\u0412", "\u041e", null);
            RailwayStationsDataProvider.put("2005295", "2005295", "\u041f\u041b 34 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 34 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005940", "2005940", "\u041e\u041f 36 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 36 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004240", "2004240", "\u041d\u041e\u0412\u041e\u041b\u0418\u0421\u0418\u041d\u041e", "\u041d\u041e\u0412\u041e\u041b\u0418\u0421\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004979", "2004979", "\u041e\u041f 46 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 46 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2005367", "2005367", "\u041f\u041b 52 \u041a\u041c", "\u041f\u041b\u0410\u0422\u0424\u041e\u0420\u041c\u0410 52 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004127", "2004127", "\u041b\u0423\u0421\u0422\u041e\u0412\u041a\u0410", "\u041b\u0423\u0421\u0422\u041e\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004126", "2004126", "\u041a\u0410\u0421\u0422\u0415\u041d\u0421\u041a\u0410\u042f", "\u041a\u0410\u0421\u0422\u0415\u041d\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005941", "2005941", "\u041e\u041f 77 \u041a\u041c", "\u041e\u0421\u0422.\u041f\u0423\u041d\u041a\u0422 77 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004125", "2004125", "\u0415\u0413\u041b\u0418\u041d\u041e", "\u0415\u0413\u041b\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004124", "2004124", "\u0420\u0410\u0414\u041e\u0424\u0418\u041d\u041d\u0418\u041a", "\u0420\u0410\u0414\u041e\u0424\u0418\u041d\u041d\u0418\u041a\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004123", "2004123", "\u041e\u0413\u041e\u0420\u0415\u041b\u042c\u0415", "\u041e\u0413\u041e\u0420\u0415\u041b\u042c\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004122", "2004122", "\u0420\u041e\u0413\u0410\u0412\u041a\u0410", "\u0420\u041e\u0413\u0410\u0412\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005134", "2005134", "\u041a\u0415\u0420\u0415\u0421\u0422\u042c", "\u041a\u0415\u0420\u0415\u0421\u0422\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2004980", "2004980", "\u041f 134 \u041a\u041c", "\u041f\u041e\u0421\u0422 134 \u041a\u041c", "\u041e", null);
            RailwayStationsDataProvider.put("2004120", "2004120", "\u0413\u041e\u0420\u0415\u041d\u041a\u0410", "\u0413\u041e\u0420\u0415\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004119", "2004119", "\u0422\u0410\u0422\u0418\u041d\u041e", "\u0422\u0410\u0422\u0418\u041d\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005081", "2005081", "\u0411\u041e\u041b\u041e\u0422\u041d\u0410\u042f", "\u0411\u041e\u041b\u041e\u0422\u041d\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005456", "2005456", "\u0412\u042f\u0416\u0418\u0429\u0415", "\u0412\u042f\u0416\u0418\u0429\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004702", "2004702", "\u0411\u0415\u041b\u041e\u041c\u041e\u0420\u0421\u041a", "\u0411\u0415\u041b\u041e\u041c\u041e\u0420\u0421\u041a", "\u041e", null);
            RailwayStationsDataProvider.put("2004362", "2004362", "\u0412\u042b\u0413", "\u0412\u042b\u0413", "\u041e", null);
            RailwayStationsDataProvider.put("2004363", "2004363", "\u0428\u0418\u0416\u041d\u042f", "\u0428\u0418\u0416\u041d\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004364", "2004364", "\u0421\u0423\u0425\u041e\u0415", "\u0421\u0423\u0425\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2004365", "2004365", "\u0412\u0418\u0420\u041c\u0410", "\u0412\u0418\u0420\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004703", "2004703", "\u0421\u0423\u041c \u041f\u041e\u0421\u0410\u0414", "\u0421\u0423\u041c\u0421\u041a\u0418\u0419 \u041f\u041e\u0421\u0410\u0414", "\u041e", null);
            RailwayStationsDataProvider.put("2004366", "2004366", "\u0422\u0415\u0413\u041e\u0417\u0415\u0420\u041e", "\u0422\u0415\u0413\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004367", "2004367", "\u041a\u041e\u041b\u0415\u0416\u041c\u0410", "\u041a\u041e\u041b\u0415\u0416\u041c\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004368", "2004368", "\u0423\u0425\u0422\u0418\u0426\u0410", "\u0423\u0425\u0422\u0418\u0426\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005144", "2005144", "\u0412\u0418\u0420\u0410\u041d\u0414\u041e\u0417", "\u0412\u0418\u0420\u0410\u041d\u0414\u041e\u0417\u0415\u0420\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2004369", "2004369", "\u0420\u0423\u0419\u0413\u0410", "\u0420\u0423\u0419\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004370", "2004370", "\u041d\u042e\u0425\u0427\u0410", "\u041d\u042e\u0425\u0427\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2004371", "2004371", "\u041c\u0410\u041b\u0415\u041d\u042c\u0413\u0410", "\u041c\u0410\u041b\u0415\u041d\u042c\u0413\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005035", "2005035", "\u041b\u0415\u041d\u0418\u041d \u041f\u0420", "\u041b\u0415\u041d\u0418\u041d\u0421\u041a\u0418\u0419 \u041f\u0420", "\u041e", null);
            RailwayStationsDataProvider.put("2005205", "2005205", "\u0414\u0410\u0427\u041d\u041e\u0415", "\u0414\u0410\u0427\u041d\u041e\u0415", "\u041e", null);
            RailwayStationsDataProvider.put("2005140", "2005140", "\u0423\u041b\u042c\u042f\u041d\u041a\u0410", "\u0423\u041b\u042c\u042f\u041d\u041a\u0410", "\u041e", null);
            RailwayStationsDataProvider.put("2005180", "2005180", "\u0413\u041e\u0420\u0415\u041b\u041e\u0412\u041e", "\u0413\u041e\u0420\u0415\u041b\u041e\u0412\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005174", "2005174", "\u0421\u041a\u0410\u0427\u041a\u0418", "\u0421\u041a\u0410\u0427\u041a\u0418", "\u041e", null);
            RailwayStationsDataProvider.put("2005165", "2005165", "\u041a\u0420 \u0421\u0415\u041b\u041e", "\u041a\u0420\u0410\u0421\u041d\u041e\u0415 \u0421\u0415\u041b\u041e", "\u041e", null);
            RailwayStationsDataProvider.put("2005377", "2005377", "\u041c\u041e\u0416\u0410\u0419\u0421\u041a\u0410\u042f", "\u041c\u041e\u0416\u0410\u0419\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005285", "2005285", "\u0422\u0410\u0419\u0426\u042b", "\u0422\u0410\u0419\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2005033", "2005033", "\u041f\u0423\u0414\u041e\u0421\u0422\u042c", "\u041f\u0423\u0414\u041e\u0421\u0422\u042c", "\u041e", null);
            RailwayStationsDataProvider.put("2004993", "2004993", "\u041c\u0410\u0420\u0418\u0415\u041d\u0411\u0423\u0420\u0413", "\u041c\u0410\u0420\u0418\u0415\u041d\u0411\u0423\u0420\u0413", "\u041e", null);
            RailwayStationsDataProvider.put("2004174", "2004174", "\u0413\u0410\u0422\u0427 \u041f \u0411\u0410\u041b", "\u0413\u0410\u0422\u0427\u0418\u041d\u0410 \u041f.\u0411\u0410\u041b\u0422\u0418\u0419\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2005301", "2005301", "\u0413\u0410\u0422\u0427 \u0422 \u0411\u0410\u041b", "\u0413\u0410\u0422\u0427\u0418\u041d\u0410 \u0422.\u0411\u0410\u041b\u0422\u0418\u0419\u0421\u041a\u0410\u042f", "\u041e", null);
            RailwayStationsDataProvider.put("2004204", "2004204", "\u0412\u041e\u0419\u0421\u041a\u041e\u0412\u0418\u0426\u042b", "\u0412\u041e\u0419\u0421\u041a\u041e\u0412\u0418\u0426\u042b", "\u041e", null);
            RailwayStationsDataProvider.put("2004981", "2004981", "\u0411\u041e\u0420\u041d\u0418\u0426\u0410", "\u0411\u041e\u0