/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.export.railway;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayFopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayTaxExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReservedSeatExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RailwayExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportRailwayFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        RailwayProductExport productExport = new RailwayProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        RailwayProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof RailwayProduct) {
            previousProductExport = new RailwayProductExport();
            this.updateProductExport(previousProductExport, (RailwayProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, (BookingXmlExportSettings)settings, (BookingXmlExportSettings)previousSettings)));
    }

    private void updateProductExport(RailwayProductExport productExport, RailwayProduct product) {
        boolean negate = false;
        if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
            negate = true;
        }
        if (product.getPreviousProduct() != null) {
            if (product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                productExport.setExchangeTicketNumber(product.getPreviousProduct().getSystemNumber());
            }
            if (product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
                productExport.setPreviousSellProductUid(product.getPreviousProduct().getUid());
            }
        }
        productExport.setUid(product.getUid());
        productExport.setCarrierNumber(product.getCarrierNumber());
        productExport.setSystemNumberPrefix(product.getSystemNumberPrefix());
        productExport.setScn(product.getScn());
        productExport.setPcc(product.getPcc());
        if (product.getGdsCurrency() != null) {
            productExport.setGdsCurrency(product.getGdsCurrency());
        }
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        String gdsCurrency = TextUtil.isBlank((String)product.getGdsCurrency()) ? DictHelper.getEquivCurrency() : product.getGdsCurrency();
        productExport.setEndorsement(product.getEndorsement());
        productExport.setFareCalculationData(product.getFareCalculationData());
        productExport.setServiceLocationType(MetadataBasedExportHelper.convertEnum((Enum)product.getServiceLocationType()));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum((Enum)product.getTicketType()));
        productExport.setBlankOwnerRef(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getBlankOwnerRef()));
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary((DictionaryReference)product.getBlankType()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setEticket(Boolean.valueOf(product.isEticket()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setProviderSystemNumber(product.getProviderSystemNumber());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum((Enum)product.getStatus()));
        productExport.setValidatorCode(product.getValidatorCode());
        productExport.setCashier(MetadataBasedExportHelper.convertPerson((EntityReference)product.getCashier()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference)RailwayProductHelper.getSubagency((RailwayProduct)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference)RailwayProductHelper.getAgency((RailwayProduct)product)));
        EntityReference supplierRef = RailwayProductHelper.getSupplier((BaseProduct)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference)supplierRef));
        productExport.setProvider(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getProvider()));
        productExport.setCarrier(MetadataBasedExportHelper.convertDictionary((DictionaryReference)product.getCarrier()));
        productExport.setComments(product.getComments());
        RailwayExportHelper.convertRailwayTravellers(product.getPassengers(), productExport.getTravellers(), t -> RailwayProductHelper.getPassengerType((RailwayProduct)product, (Traveller)t));
        RailwayExportHelper.convertRailwaySegments(product.getSegments(), productExport.getSegments());
        for (ReservedSeat seat : product.getReservedSeats()) {
            ReservedSeatExport seatExport = new ReservedSeatExport();
            seatExport.setEquivalentFare(seat.getEquivalentFare());
            seatExport.setEquivalentVAT(seat.getEquivalentVAT());
            seatExport.setFare(MetadataBasedExportHelper.convertMoney((Money)seat.getFare()));
            seatExport.setScn(seat.getScn());
            if (seat.getSegment() != null) {
                seatExport.setSegmentNumber(Integer.valueOf(seat.getSegment().getNumber()));
            }
            seatExport.setSystemNumber(seat.getSystemNumber());
            productExport.getReservedSeats().add(seatExport);
        }
        for (RailwayTax tax : product.getTaxes()) {
            RailwayTaxExport taxExport = new RailwayTaxExport();
            taxExport.setAmount(MetadataBasedExportHelper.convertMoney((Money)tax.getFare()));
            taxExport.setCode(tax.getCode());
            if (tax.getSegment() != null) {
                taxExport.setSegmentNo(String.valueOf(tax.getSegment().getNumber()));
            }
            taxExport.setEquivalentAmount(MetadataBasedExportHelper.convertProductAmount((BigDecimal)tax.getEquivalentFare(), (String)gdsCurrency, (BigDecimal)tax.getEquivalentVAT(), (BigDecimal)BigDecimal.ZERO, (boolean)negate));
            productExport.getTaxes().add(taxExport);
        }
        productExport.setTotalEquivalentFare(RailwayProductHelper.calculateTotalEquivalentFare((RailwayProduct)product));
        productExport.setTotalEquivalentVAT(RailwayProductHelper.calculateTotalEquivalentVat((RailwayProduct)product));
        productExport.setPenalty(product.getPenalty());
        productExport.setPenaltyVAT(product.getPenaltyVAT());
        productExport.setServiceFare(product.getServiceFare());
        productExport.setServiceVAT(product.getServiceVAT());
        productExport.setEquivalentFare(product.getEquivalentFare());
        productExport.setEquivalentVAT(product.getEquivalentVAT());
        List contractRelations = RailwayProductHelper.getContractRelations((RailwayProduct)product);
        for (RailwayProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((RailwayProductExport)productExport).setClientContract(arg_0), arg_0 -> ((RailwayProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((RailwayProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((RailwayProductExport)productExport).setTechnicalProviderContract(arg_0));
            List fops = contractRelation.getFops().stream().sorted((o1, o2) -> {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getAmount() == null) {
                    return o2.getAmount() == null ? MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid())) : -1;
                }
                if (o2.getAmount() == null) {
                    return 1;
                }
                int result = MiscUtil.compare((Comparable)o1.getAmount().getValue(), (Comparable)o2.getAmount().getValue());
                if (result == 0) {
                    return MiscUtil.compare((Comparable)((Object)o1.getUid()), (Comparable)((Object)o2.getUid()));
                }
                return result;
            }).collect(Collectors.toList());
            for (RailwayProductFop fop : fops) {
                Object card;
                RailwayFopExport fopExport = new RailwayFopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportRailwayFillProductHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum((Enum)fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney((Money)fop.getAmount(), (boolean)negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum((Enum)card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum((Enum)fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List components = MetadataBasedExportHelper.getSortedFopComponents((List)fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent((FopComponent)component, (boolean)negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getVendorCommissions(), (String)vendorEquivalentCurrency, (boolean)negate));
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getSubagencyCommissions(), (String)subagencyEquivalentCurrency, (boolean)negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getClientCommissions(), (String)clientEquivalentCurrency, (boolean)negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getVendorServiceFee(), (String)vendorEquivalentCurrency, (boolean)negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getSubagencyServiceFee(), (String)subagencyEquivalentCurrency, (boolean)negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getClientServiceFee(), (String)clientEquivalentCurrency, (boolean)negate));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }

    private static ObjectReferenceExport getFopCategory(RailwayProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!RailwayProductHelper.isServiceFop((RailwayProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

