/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.export.railwayCrimeaMco;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayCrimeaMcoExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwaySegmentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayTravellerExport;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RailwayExportHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookingExportRailwayCrimeaMCOFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwayCrimeaMco product = (RailwayCrimeaMco)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        RailwayCrimeaMcoExport productExport = new RailwayCrimeaMcoExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        RailwayCrimeaMcoExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof RailwayCrimeaMco) {
            previousProductExport = new RailwayCrimeaMcoExport();
            this.updateProductExport(previousProductExport, (RailwayCrimeaMco)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, (BookingXmlExportSettings)settings, (BookingXmlExportSettings)previousSettings)));
    }

    private void updateProductExport(RailwayCrimeaMcoExport productExport, RailwayCrimeaMco product) {
        productExport.setUid(product.getUid());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum((Enum)product.getStatus()));
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary((DictionaryReference)product.getBlankType()));
        productExport.setServiceLocationType(MetadataBasedExportHelper.convertEnum((Enum)product.getServiceLocationType()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getBlankOwner()));
        productExport.setCarrierNumber(product.getCarrierNumber());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setProviderSystemNumber(product.getProviderSystemNumber());
        productExport.setEticket(Boolean.valueOf(product.isEticket()));
        productExport.setScn(product.getScn());
        productExport.setIssueDate(product.getIssueDate());
        productExport.setProvider(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getProvider()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference)product.getSalesPoint()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference)product.getAgent()));
        if (product.getValidator() != null) {
            productExport.setValidatorCode(product.getValidator().getUid());
        }
        productExport.setPcc(product.getPcc());
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum((Enum)product.getTicketType()));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setEndorsement(product.getEndorsement());
        productExport.setFareCalculationData(product.getFareCalculationData());
        productExport.setComments(product.getComments());
        for (Traveller traveller : product.getPassengers()) {
            RailwayTravellerExport travellerExport = new RailwayTravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setNameInGds(traveller.getNameInGds());
            travellerExport.setNameInCyrillic(traveller.getCyrillicName());
            if (traveller.getPassenger() != null) {
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                if (personCtr != null) {
                    travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer)personCtr));
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            productExport.getPassengers().add(travellerExport);
        }
        for (RailwaySegment segment : product.getSegments()) {
            RailwaySegmentExport segmentExport = new RailwaySegmentExport();
            segmentExport.setAddInfo(segment.getAddInfo());
            segmentExport.setArriveDate(segment.getArriveDate());
            segmentExport.setArriveStation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getArriveStation()));
            segmentExport.setArriveCity(RailwayExportHelper.getCityFromStation((DictionaryReference<RailwayStation>)segment.getArriveStation()));
            segmentExport.setCarriageNumber(segment.getCarriageNumber());
            segmentExport.setCarriageType(MetadataBasedExportHelper.convertEnum((Enum)segment.getCarriageType()));
            segmentExport.setCarrier(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getCarrier()));
            segmentExport.setCompartmentType(MetadataBasedExportHelper.convertEnum((Enum)segment.getCompartmentType()));
            segmentExport.setDepartureDate(segment.getDepartureDate());
            segmentExport.setDepartureStation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getDepartureStation()));
            segmentExport.setDepartureCity(RailwayExportHelper.getCityFromStation((DictionaryReference<RailwayStation>)segment.getDepartureStation()));
            segmentExport.setDurationInMinutes(segment.getDurationInMinutes());
            segmentExport.setEquivalentFare(segment.getEquivalentFare());
            segmentExport.setEquivalentVAT(segment.getEquivalentVAT());
            segmentExport.setERegEnabled(Boolean.valueOf(segment.isERegEnabled()));
            segmentExport.setFare(MetadataBasedExportHelper.convertMoney((Money)segment.getFare()));
            segmentExport.setHasEReg(Boolean.valueOf(segment.isHasEReg()));
            segmentExport.setNumber(Integer.valueOf(segment.getNumber()));
            segmentExport.setRoute(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getRoute()));
            segmentExport.setServiceClass(MetadataBasedExportHelper.convertEnum((Enum)segment.getServiceClass()));
            segmentExport.setSlot(segment.getSlot());
            segmentExport.setTimeInfo(segment.getTimeInfo());
            segmentExport.setTrainNumber(segment.getTrainNumber());
            segmentExport.setPlaces(String.join((CharSequence)", ", segment.getPlaces()));
            productExport.getSegments().add(segmentExport);
        }
        List relatedProductUids = product.getRelatedProducts().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
        MetadataBasedExportHelper.convertStringCollection((Collection)productExport.getRelatedProductsUids(), relatedProductUids);
        productExport.setEquivalentFare(product.getEquivalentFare());
        productExport.setEquivalentVat(product.getEquivalentVat());
        productExport.setPenalty(product.getPenalty());
        productExport.setPenaltyVat(product.getPenaltyVat());
        productExport.setTotalEquivalentFare(RailwayCrimeaMcoHelper.calculateTotalEquivalentFare((RailwayCrimeaMco)product));
        productExport.setTotalEquivalentVat(RailwayCrimeaMcoHelper.calculateTotalEquivalentVat((RailwayCrimeaMco)product));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        GeneralProductHelper.getContractRelationsByReflection((BaseProduct)product).forEach(contractRelation -> BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((RailwayCrimeaMcoExport)productExport).setClientContract(arg_0), arg_0 -> ((RailwayCrimeaMcoExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((RailwayCrimeaMcoExport)productExport).setVendorContract(arg_0), arg_0 -> ((RailwayCrimeaMcoExport)productExport).setTechnicalProviderContract(arg_0)));
    }
}

