/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.export.railwayMcoProduct;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayMcoProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RailwayExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportRailwayMcoFillProductHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwayMcoProduct product = (RailwayMcoProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        RailwayMcoProductExport productExport = new RailwayMcoProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        RailwayMcoProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof RailwayMcoProduct) {
            previousProductExport = new RailwayMcoProductExport();
            this.updateProductExport(previousProductExport, (RailwayMcoProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, (BookingXmlExportSettings)settings, (BookingXmlExportSettings)previousSettings)));
    }

    private void updateProductExport(RailwayMcoProductExport productExport, RailwayMcoProduct product) {
        boolean negate;
        boolean bl = negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        if (product.getPreviousProduct() != null) {
            if (product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                productExport.setExchangeTicketNumber(product.getPreviousProduct().getSystemNumber());
            }
            if (product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
                productExport.setPreviousSellProductUid(product.getPreviousProduct().getUid());
            }
        }
        MetadataBasedExportHelper.convertStringCollection((Collection)productExport.getRelatedProductUids(), (Collection)product.getRelatedProducts().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        productExport.setUid(product.getUid());
        productExport.setMcoCategory(MetadataBasedExportHelper.convertEnum((Enum)product.getMcoCategory()));
        productExport.setCarrierNumber(product.getCarrierNumber());
        productExport.setPcc(product.getPcc());
        productExport.setGdsCurrency(product.getGdsCurrency());
        String vendorEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.VENDOR);
        String subagencyEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.SUBAGENCY);
        String clientEquivalentCurrency = GeneralProductHelper.getContractCurrency((BaseProduct)product, (ContractType)ContractType.CLIENT);
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum((Enum)product.getTicketType()));
        productExport.setBlankOwnerRef(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getBlankOwnerRef()));
        productExport.setBlankType(MetadataBasedExportHelper.convertDictionary((DictionaryReference)product.getBlankType()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setEticket(Boolean.valueOf(product.isEticket()));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setProviderSystemNumber(product.getProviderSystemNumber());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum((Enum)product.getStatus()));
        productExport.setValidatorCode(product.getValidatorCode());
        productExport.setCashier(MetadataBasedExportHelper.convertPerson((EntityReference)product.getCashier()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference)RailwayMcoProductHelper.getSubagency((RailwayMcoProduct)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference)RailwayMcoProductHelper.getAgency((RailwayMcoProduct)product)));
        EntityReference supplierRef = RailwayProductHelper.getSupplier((BaseProduct)product);
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference)supplierRef));
        productExport.setProvider(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getProvider()));
        productExport.setComments(product.getComments());
        RailwayExportHelper.convertRailwayTravellers(product.getPassengers(), productExport.getTravellers(), t -> RailwayMcoProductHelper.getPassengerType((RailwayMcoProduct)product, (Traveller)t));
        RailwayExportHelper.convertRailwaySegments(product.getSegments(), productExport.getSegments());
        productExport.setPenalty(product.getPenaltyFare());
        productExport.setPenaltyVat(product.getPenaltyVat());
        productExport.setTotalEquivalentFare(RailwayMcoProductHelper.calculateTotalEquivalentFare((RailwayMcoProduct)product));
        productExport.setTotalEquivalentVat(RailwayMcoProductHelper.calculateTotalEquivalentVat((RailwayMcoProduct)product));
        productExport.setEquivalentFare(product.getEquivalentFare());
        productExport.setEquivalentVat(product.getEquivalentVat());
        List contractRelations = GeneralProductHelper.getContractRelationsByReflection((BaseProduct)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((RailwayMcoProductExport)productExport).setClientContract(arg_0), arg_0 -> ((RailwayMcoProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((RailwayMcoProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((RailwayMcoProductExport)productExport).setTechnicalProviderContract(arg_0));
            List fops = MetadataBasedExportHelper.getSortedFops((List)contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(MetadataBasedExportHelper.getFopCategory((GeneralProductFop)fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum((Enum)fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney((Money)MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)GeneralProductHelper.getContractCurrency((GeneralProductContractRelationData)contractRelation)), (boolean)negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum((Enum)card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum((Enum)fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    ReferenceItemExport commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                List components = MetadataBasedExportHelper.getSortedFopComponents((List)fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent((FopComponent)component, (boolean)negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setTotalVendorCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getVendorCommissions(), (String)vendorEquivalentCurrency, (boolean)negate));
        productExport.setTotalSubagencyCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getSubagencyCommissions(), (String)subagencyEquivalentCurrency, (boolean)negate));
        productExport.setTotalClientCommissions(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.commissionPropertyTypes, (Collection)productExport.getClientCommissions(), (String)clientEquivalentCurrency, (boolean)negate));
        productExport.setTotalVendorServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.VENDOR, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getVendorServiceFee(), (String)vendorEquivalentCurrency, (boolean)negate));
        productExport.setTotalSubagencyServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getSubagencyServiceFee(), (String)subagencyEquivalentCurrency, (boolean)negate));
        productExport.setTotalClientServiceFee(MetadataBasedExportHelper.calculateCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.serviceFeePropertyTypes, (Collection)productExport.getClientServiceFee(), (String)clientEquivalentCurrency, (boolean)negate));
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
    }
}

