/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;

public class BookingDao {
    public static RailwayProduct getProduct(BookingFile bookingFile, String systemNumber, ProductStatus status) {
        if (TextUtil.isBlank((String)systemNumber)) {
            return null;
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayProduct product;
                if (!(baseProduct instanceof RailwayProduct) || !systemNumber.equals((product = (RailwayProduct)baseProduct).getSystemNumber()) || status != null && status != product.getStatus()) continue;
                return product;
            }
        }
        return null;
    }

    public static RailwayProduct getProduct(String systemNumber) throws Exception {
        return BookingDao.getProduct(systemNumber, null);
    }

    public static RailwayProduct getProduct(String systemNumber, ProductStatus status) throws Exception {
        RailwayProductIndex index = BookingDao.getProductIndex(systemNumber, status);
        if (index == null) {
            return null;
        }
        EntityStorage entityStorage = EntityStorage.get();
        EntityContainer bookingFileContainer = entityStorage.resolve(index.getSource());
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        return BookingDao.getProduct(bookingFile, systemNumber, status);
    }

    public static RailwayProductIndex getProductIndex(String systemNumber) throws Exception {
        return BookingDao.getProductIndex(systemNumber, null);
    }

    public static RailwayProductIndex getProductIndex(String systemNumber, ProductStatus status) throws Exception {
        EntityStorage entityStorage;
        List railwayProductIndexes;
        if (TextUtil.isBlank((String)systemNumber)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)systemNumber));
        if (status != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)status));
        }
        if ((railwayProductIndexes = (entityStorage = EntityStorage.get()).search(RailwayProductIndex.class, query).getData()).size() == 0) {
            return null;
        }
        return (RailwayProductIndex)railwayProductIndexes.get(0);
    }
}

