/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class ProfileHelper {
    public static String getFullName(Organization organization, Locale locale, boolean strict) {
        if (organization == null) {
            return null;
        }
        return ProfileHelper.getFullName(organization.getCode(), organization.getShortName(), organization.getFullName(), (DictionaryReference<LegalForm>)organization.getLegalForm(), locale, strict);
    }

    public static String getFullName(SalesPoint salesPoint) {
        if (salesPoint == null) {
            return null;
        }
        return ProfileHelper.getFullName(salesPoint.getCode(), salesPoint.getShortName(), salesPoint.getFullName(), null);
    }

    public static String getFullName(String code, L10nString shortNameLocalization, L10nString fullNameLocalization, DictionaryReference<LegalForm> legalFormReference, Locale locale, boolean strict) {
        String shortName = L10nStringHelper.getValue((L10nString)shortNameLocalization, (Locale)locale, (boolean)strict);
        String fullName = L10nStringHelper.getValue((L10nString)fullNameLocalization, (Locale)locale, (boolean)strict);
        return ProfileHelper.getFullName(code, shortName, fullName, legalFormReference);
    }

    public static String getFullName(String code, String shortName, String fullName, DictionaryReference<LegalForm> legalFormReference) {
        if (TextUtil.isBlank((String)fullName)) {
            if (TextUtil.isBlank((String)shortName)) {
                return code;
            }
            return shortName;
        }
        String legalForm = DictHelper.getShortLegalForm(legalFormReference, (Locale)LocaleManager.get().getCurrentLocale());
        if (legalFormReference != null && legalForm == null) {
            legalForm = legalFormReference.getCode();
        }
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)legalForm)) {
            boolean ip = legalForm.equalsIgnoreCase("\u0418\u041f");
            result.append(legalForm).append(" ");
            if (!ip) {
                result.append("\"");
            }
            result.append(fullName);
            if (!ip) {
                result.append("\"");
            }
        } else {
            result.append(fullName);
        }
        return result.toString();
    }

    public static List<EntityReference<Person>> getCurrentUsers() throws Exception {
        String user = LogicalStorage.get().getUser();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)user));
        List userIndexes = EntityStorage.get().search(PersonIndex.class, query).getData();
        ArrayList<EntityReference<Person>> users = new ArrayList<EntityReference<Person>>();
        for (PersonIndex userIndex : userIndexes) {
            users.add((EntityReference<Person>)userIndex.getSource());
        }
        return users;
    }

    public static List<ValidatorIndex> getProductValidators(RailwayProduct product) throws Exception {
        String validatorCode = product.getValidatorCode();
        Date issieDate = product.getIssueDate();
        String pcc = product.getPcc();
        if (TextUtil.isBlank((String)validatorCode)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorCode));
        if (issieDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.closed.name(), null), SearchCriterion.ge((String)ValidatorIndex.Property.closed.name(), (Object)issieDate)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ValidatorIndex.Property.opened.name(), null), SearchCriterion.le((String)ValidatorIndex.Property.opened.name(), (Object)issieDate)}));
        }
        if (!TextUtil.isBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)ValidatorIndex.Property.pcc.name(), (String)pcc));
        }
        return EntityStorage.get().search(ValidatorIndex.class, query).getData();
    }

    public static Set<EntityReference<Organization>> getProductSuppliers(RailwayProduct product) {
        ArrayList<ValidatorIndex> validatorIndexes = new ArrayList<ValidatorIndex>();
        try {
            validatorIndexes.addAll(ProfileHelper.getProductValidators(product));
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        LinkedHashSet<EntityReference<Organization>> suppliers = new LinkedHashSet<EntityReference<Organization>>();
        for (ValidatorIndex validatorIndex : validatorIndexes) {
            suppliers.add((EntityReference<Organization>)validatorIndex.getSupplier());
        }
        return suppliers;
    }
}

