/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwaySegmentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.RailwayTravellerExport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.util.List;
import java.util.function.Function;

public class RailwayExportHelper {
    public static ObjectReferenceExport getCityFromStation(DictionaryReference<RailwayStation> stationRef) {
        if (stationRef == null) {
            return null;
        }
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        if (station != null) {
            return MetadataBasedExportHelper.convertDictionary((DictionaryReference)station.getGeoLocation());
        }
        return null;
    }

    public static void convertRailwaySegments(List<RailwaySegment> segments, List<RailwaySegmentExport> exportSegments) {
        for (RailwaySegment segment : segments) {
            RailwaySegmentExport segmentExport = new RailwaySegmentExport();
            segmentExport.setAddInfo(segment.getAddInfo());
            segmentExport.setArriveDate(segment.getArriveDate());
            segmentExport.setLocalArriveDate(segment.getLocalArriveDate());
            segmentExport.setArriveStation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getArriveStation()));
            segmentExport.setArriveCity(RailwayExportHelper.getCityFromStation((DictionaryReference<RailwayStation>)segment.getArriveStation()));
            segmentExport.setCarriageNumber(segment.getCarriageNumber());
            segmentExport.setCarriageType(MetadataBasedExportHelper.convertEnum((Enum)segment.getCarriageType()));
            segmentExport.setCarrier(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getCarrier()));
            segmentExport.setCompartmentType(MetadataBasedExportHelper.convertEnum((Enum)segment.getCompartmentType()));
            segmentExport.setDepartureDate(segment.getDepartureDate());
            segmentExport.setLocalDepartureDate(segment.getLocalDepartureDate());
            segmentExport.setDepartureStation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getDepartureStation()));
            segmentExport.setDepartureCity(RailwayExportHelper.getCityFromStation((DictionaryReference<RailwayStation>)segment.getDepartureStation()));
            segmentExport.setDurationInMinutes(segment.getDurationInMinutes());
            segmentExport.setEquivalentFare(segment.getEquivalentFare());
            segmentExport.setEquivalentVAT(segment.getEquivalentVAT());
            segmentExport.setERegEnabled(Boolean.valueOf(segment.isERegEnabled()));
            segmentExport.setFare(MetadataBasedExportHelper.convertMoney((Money)segment.getFare()));
            segmentExport.setHasEReg(Boolean.valueOf(segment.isHasEReg()));
            segmentExport.setNumber(Integer.valueOf(segment.getNumber()));
            segmentExport.setRoute(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getRoute()));
            segmentExport.setServiceClass(MetadataBasedExportHelper.convertEnum((Enum)segment.getServiceClass()));
            segmentExport.setSlot(segment.getSlot());
            segmentExport.setTimeInfo(segment.getTimeInfo());
            segmentExport.setTrainNumber(segment.getTrainNumber());
            segmentExport.setPlaces(String.join((CharSequence)", ", segment.getPlaces()));
            exportSegments.add(segmentExport);
        }
    }

    public static void convertRailwayTravellers(List<Traveller> travellers, List<RailwayTravellerExport> exportTravellers, Function<Traveller, DictionaryReference<PassengerType>> typeSupplier) {
        for (Traveller traveller : travellers) {
            RailwayTravellerExport travellerExport = new RailwayTravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setNameInGds(traveller.getNameInGds());
            travellerExport.setNameInCyrillic(traveller.getCyrillicName());
            travellerExport.setType(MetadataBasedExportHelper.convertDictionary(typeSupplier.apply(traveller)));
            if (traveller.getPassenger() != null) {
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                if (personCtr != null) {
                    travellerExport.getExternalCodes().addAll(BookingXmlExportHelper.getPersonExternalCodes((EntityContainer)personCtr));
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            exportTravellers.add(travellerExport);
        }
    }
}

