/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettings;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.GroovyShellHelper;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class RailwayProductVatCalculator {
    public static final String RAILWAY_VAT_CALCULATION_SETTINGS_UID = "RAILWAY_VAT_CALCULATION_SETTINGS";
    public static final String RAILWAY_VAT_CALCULATION_SETTINGS_SYNCHRONIZATION_TASK_UID = "RAILWAY_VAT_CALCULATION_SETTINGS_SYNCHRONIZATION_TASK";
    private static final Date date201701;

    public static void updateVat(RailwayProduct product) {
        if (product.isDontRecalculateVAT()) {
            return;
        }
        if (product.getTotalEquivalentVAT() != null && product.getVendorVatDetalization() != null && GeneralProductHelper.isVendorVatDetalizationComplete((VatDetalization)product.getVendorVatDetalization())) {
            return;
        }
        if (product.getEquivalentFare() == null && product.getServiceFare() == null) {
            return;
        }
        if (product.getSegments().isEmpty()) {
            return;
        }
        MessageHelper.removeMessages((Collection)product.getValidationMessages(), (ValidationMessageCategory)ValidationMessageCategory.VAT_CALCULATION);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        VatDetalization detalization = RailwayProductVatCalculator.calculateVat(product);
        if (detalization == null) {
            return;
        }
        BigDecimal totalVat = BigDecimal.ZERO;
        BigDecimal penaltyVat = BigDecimal.ZERO;
        for (VatComponent comp : detalization.getComponents()) {
            totalVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVat, comp.getSum()});
            if (!comp.getBasisTypes().contains(VatBasisType.PENALTY)) continue;
            penaltyVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{penaltyVat, comp.getSum()});
        }
        if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
            penaltyVat = penaltyVat.negate();
        }
        if (product.getTotalEquivalentVAT() != null && totalVat.compareTo(product.getTotalEquivalentVAT()) != 0) {
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.APVC_DIFFERENT_TOTAL_VAT, (Object[])new Object[]{product.getTotalEquivalentVAT(), totalVat}));
        } else {
            product.setTotalEquivalentVAT(totalVat);
            product.setPenaltyVAT(penaltyVat);
        }
        detalization.setDetalized(true);
        product.setVendorVatDetalization(detalization);
    }

    private static VatDetalization calculateVat(RailwayProduct product) {
        VatDetalization detalization = RailwayProductVatCalculator.calculateVatWithSrcipt(product);
        if (detalization == null) {
            detalization = RailwayProductVatCalculator.calculateVatWithOldLogic(product);
        }
        return detalization;
    }

    private static BigDecimal getTotalVat(List<VatComponent> components) {
        BigDecimal totalVat = null;
        for (VatComponent comp : components) {
            totalVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVat, comp.getSum()});
        }
        return totalVat;
    }

    private static VatDetalization calculateVatWithOldLogic(RailwayProduct product) {
        double rate;
        VatComponent comp;
        VatDetalization detalization = new VatDetalization();
        BigDecimal tariff = MiscUtil.guarded((BigDecimal)product.getEquivalentFare());
        BigDecimal service = MiscUtil.guarded((BigDecimal)product.getServiceFare());
        BigDecimal penalty = MiscUtil.guarded((BigDecimal)product.getPenalty());
        BigDecimal deduction = MiscUtil.guarded((BigDecimal)RailwayProductHelper.getDeduction((RailwayProduct)product));
        BigDecimal deductionVat = RailwayProductHelper.getDeductionVat((RailwayProduct)product);
        Date issueDate = product.getIssueDate();
        if (product.getStatus() == ProductStatus.REFUND) {
            issueDate = product.getPreviousProduct().getIssueDate();
        }
        boolean hasVat = RailwayProductHelper.isHasVat((RailwayProduct)product);
        if (BigDecimal.ZERO.compareTo(tariff) != 0) {
            comp = new VatComponent();
            comp.setBasis(tariff);
            comp.getBasisTypes().add(VatBasisType.FARE);
            rate = !hasVat || issueDate == null ? 0.0 : RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)issueDate);
            comp.setRate(Double.valueOf(rate));
            comp.setSum(RailwayProductHelper.calculateVat((BigDecimal)tariff, (double)rate));
            detalization.getComponents().add(comp);
        }
        if (BigDecimal.ZERO.compareTo(service) != 0) {
            comp = new VatComponent();
            comp.setBasis(service);
            comp.getBasisTypes().add(VatBasisType.SERVICE);
            rate = hasVat ? RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate) : 0.0;
            comp.setRate(Double.valueOf(rate));
            comp.setSum(RailwayProductHelper.calculateVat((BigDecimal)service, (double)rate));
            detalization.getComponents().add(comp);
        }
        if (BigDecimal.ZERO.compareTo(penalty) != 0) {
            boolean refund;
            comp = new VatComponent();
            comp.setBasis(penalty);
            boolean bl = refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
            if (refund) {
                comp.setBasis(comp.getBasis().negate());
            }
            comp.getBasisTypes().add(VatBasisType.PENALTY);
            double rate2 = RailwayProductHelper.isHasPenaltyVat((RailwayProduct)product) ? RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate) : 0.0;
            comp.setRate(Double.valueOf(rate2));
            comp.setSum(RailwayProductHelper.calculateVat((BigDecimal)penalty, (double)rate2));
            if (refund) {
                comp.setSum(comp.getSum().negate());
            }
            detalization.getComponents().add(comp);
        }
        if (BigDecimal.ZERO.compareTo(deduction) != 0) {
            boolean refund;
            comp = new VatComponent();
            comp.setBasis(deduction.negate());
            boolean bl = refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
            if (refund) {
                comp.setBasis(comp.getBasis().negate());
            }
            comp.getBasisTypes().add(VatBasisType.DEDUCTION);
            if (deductionVat != null) {
                comp.setSum(deductionVat);
                comp.setRate(Double.valueOf(deductionVat.multiply(BigDecimal.valueOf(100L)).divide(deduction.subtract(deductionVat), 0, 4).doubleValue()));
                if (refund) {
                    comp.setSum(comp.getSum().negate());
                }
            }
            detalization.getComponents().add(comp);
        }
        return detalization;
    }

    private static VatDetalization calculateVatWithSrcipt(RailwayProduct product) {
        EntityContainer settingsCtr = EntityStorage.get().load(VatCalculationSettings.class, RAILWAY_VAT_CALCULATION_SETTINGS_UID);
        if (settingsCtr != null && ((VatCalculationSettings)settingsCtr.getEntity()).isActive()) {
            VatDetalization detalization = new VatDetalization();
            Binding binding = new Binding();
            binding.setProperty("detalizationProperty", (Object)detalization);
            binding.setProperty("productProperty", (Object)product);
            GroovyShell shell = new GroovyShell(binding);
            try {
                GroovyShellHelper.wrapShellIntoCacheDecorator((GroovyShell)shell).evaluate(((VatCalculationSettings)settingsCtr.getEntity()).getScript(), true);
                return detalization;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(RailwayProductVatCalculator.class).error("unable to calculate VAT", (Throwable)e);
                product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.UNABLE_TO_CALCULATE_VAT, (Throwable)e, (Object[])new Object[0]));
                return null;
            }
        }
        return null;
    }

    private RailwayProductVatCalculator() {
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(2017, 0, 1, 0, 0, 0);
        date201701 = cal.getTime();
    }
}

