/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RailwayCrimeaMcoCloneHelper {
    public static void clone(RailwayCrimeaMco source, RailwayCrimeaMco target) throws Exception {
        ProductCloneHelper.clone((BaseProduct)source, (BaseProduct)target, (ProductCloneHelper.ProductCloneSourceHandler)new RailwayCrimeaMcoCloneSourceHandler(), (ProductCloneHelper.ProductCloneTargetHandler)new RailwayCrimeaMcoCloneTargetHandler());
    }

    public static void clone(RailwayCrimeaMco source, RailwayCrimeaMco target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone((BaseProduct)source, (BaseProduct)target, uidsMapping, (ProductCloneHelper.ProductCloneSourceHandler)new RailwayCrimeaMcoCloneSourceHandler());
    }

    public static class RailwayCrimeaMcoCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<RailwayCrimeaMco> {
        public void update(RailwayCrimeaMco product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class RailwayCrimeaMcoCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<RailwayCrimeaMco> {
        private Reservation reservation;
        private RailwayCrimeaMco previousProduct;
        private RailwayCrimeaMco nextProduct;
        private final List<RailwayProduct> relatedProducts = new ArrayList<RailwayProduct>();
        private final List<Traveller> travellers = new ArrayList<Traveller>();

        public void before(RailwayCrimeaMco product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.relatedProducts.clear();
            this.relatedProducts.addAll(product.getRelatedProducts());
            this.travellers.clear();
            this.travellers.addAll(product.getPassengers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            product.getRelatedProducts().clear();
            if (!cloneTraveller) {
                product.getPassengers().clear();
            }
        }

        public void after(RailwayCrimeaMco product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getRelatedProducts().clear();
            product.getRelatedProducts().addAll(this.relatedProducts);
            product.getPassengers().clear();
            product.getPassengers().addAll(this.travellers);
        }
    }
}

