/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.rules.standart.proxy;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductPropertySet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RailwayProductCommissionActionSet
extends GeneralProductCommissionActionSet {
    private static final long serialVersionUID = 1880786408962032416L;

    public RailwayProductCommissionActionSet(RuleProxy<RailwayProductPropertySet, RailwayProductCommissionActionSet> proxy, RailwayProductPropertiesProvider propertySet, RailwayProduct ticket) {
        super(proxy, (BaseProduct)ticket, RailwayProductCommissionActionSet.createHandler(ticket, propertySet));
    }

    public RailwayProductCommissionActionSet(RuleProxy<?, ?> proxy, BaseProduct ticket, GeneralProductCommissionActionSet.CommissionActionProxy cProxy) {
        super(proxy, ticket, cProxy);
    }

    protected boolean updateCommissionAmount(GeneralProductCommission result, RuleResultValue value, GeneralProductContractRelationData relation, List<GeneralProductContractRelationData> previousProductContractRelations, List<GeneralProductCommission> hiddenFees, boolean refunded, Collection<ValidationMessage> messages) throws Exception {
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        EntityContainer ctr = EntityStorage.get().resolve(value.getTarget());
        BaseCommissionProperties prop = (BaseCommissionProperties)ctr.getEntity();
        if (prop instanceof FeeProperties && ((FeeProperties)prop).getType() == FeeType.MANUALLY_CALCULATED && this.getBaseProduct().getManualFeeAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualFeeAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof CommissionProperties && ((CommissionProperties)prop).isManuallyCalculated() && this.getBaseProduct().getManualCommissionAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualCommissionAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof DiscountProperties && ((DiscountProperties)prop).getType() == DiscountType.MANUALLY_CALCULATED && this.getBaseProduct().getManualDiscountAppliedFlags().get(contractType) != null && ((Boolean)this.getBaseProduct().getManualDiscountAppliedFlags().get(contractType)).booleanValue()) {
            return false;
        }
        if (prop instanceof FeeProperties || prop instanceof DiscountProperties) {
            CalculationType calculationType = null;
            if (prop instanceof FeeProperties) {
                calculationType = ((FeeProperties)prop).getCalculationType();
            } else if (prop instanceof DiscountProperties) {
                calculationType = ((DiscountProperties)prop).getCalculationType();
            }
            if (calculationType == CalculationType.RAILWAY_SEATS_COUNT) {
                int seatsCount = RailwayProductHelper.getSeatsCount((RailwayProduct)((RailwayProductPropertySet)this.proxy.getPropertySet()).getProduct());
                if (seatsCount == 0) {
                    seatsCount = 1;
                }
                Money money = new Money();
                money.setValue(BigDecimal.valueOf(value.getValue()).multiply(BigDecimal.valueOf(seatsCount)));
                money.setCurrency(this.getCurrency(value.getCurrencyCode(), messages));
                result.setCommissionProperties(ctr.toReference());
                result.setContractType(contractType);
                result.setAmount(money);
                if (prop instanceof FeeProperties) {
                    this.fixFeeRate(result, (FeeProperties)prop);
                } else if (prop instanceof DiscountProperties) {
                    this.fixDiscountRate(result, (DiscountProperties)prop);
                }
                this.updateAmountWithVatRate(result, prop);
                this.updateEquivalentAmount(result, hiddenFees, null, relation, previousProductContractRelations, false, messages);
                return true;
            }
        }
        return super.updateCommissionAmount(result, value, relation, previousProductContractRelations, hiddenFees, refunded, messages);
    }

    protected static GeneralProductCommissionActionSet.CommissionActionProxy createHandler(final RailwayProduct ticket, final RailwayProductPropertiesProvider propertySet) {
        return new GeneralProductCommissionActionSet.CommissionActionProxy(){

            public boolean isOneWayTicket() {
                return true;
            }

            public boolean isForcedRefund() {
                return ticket.isForcedRefund();
            }

            public List<ValidationMessage> getValidationMessages() {
                return ticket.getValidationMessages();
            }

            public TicketType getTicketType() {
                return ticket.getTicketType();
            }

            public String getTargetType() {
                return "TICKET";
            }

            public ProductStatus getStatus() {
                return ticket.getStatus();
            }

            public int getSegmentsCount() {
                return ticket.getSegments().size();
            }

            public ProductType getProductType() {
                return ProductType.RAILWAY_PRODUCT;
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getPreviousProduct() {
                return ticket.getPreviousProduct() != null ? RailwayProductCommissionActionSet.createHandler(ticket.getPreviousProduct(), propertySet) : null;
            }

            public GeneralProductCommissionActionSet.CommissionActionProxy getNextProduct() {
                return ticket.getNextProduct() != null ? RailwayProductCommissionActionSet.createHandler(ticket.getNextProduct(), propertySet) : null;
            }

            public BigDecimal getAdditionalFare() {
                return null;
            }

            public Set<String> getPaymentTypes() {
                return propertySet.getFopTypes();
            }

            public Date getIssueDate() {
                return ticket.getIssueDate();
            }

            public EntityReference<SalesPoint> getSalesPoint() {
                return ticket.getSalesPoint();
            }

            public int getSegmentTariffsCount() {
                return 0;
            }

            public int getTravellersCount() {
                return ticket.getPassengers().size();
            }
        };
    }
}

