/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.rules.standart.proxy;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoCategory;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.EmployeeCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.PayersPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ProductStatusPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TicketTypePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TranslateSupplierFeesPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravelSubjectPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TravellersPropertyProvider;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProxyHelper;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.PayersCollector;
import com.gridnine.xtrip.server.model.handlers.ProductPropertiesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayRulesHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RailwayProductPropertySet
implements Serializable,
RailwayProductPropertiesProvider,
PayersPropertiesProvider,
TranslateSupplierFeesPropertyProvider,
TravellersPropertyProvider,
UDIDsPropertyProvider,
TicketTypePropertiesProvider,
ProductStatusPropertiesProvider,
EmployeeCategoriesProvider,
ReservationPropertiesProvider,
ClientCreditCardVendorProvider,
TravelSubjectPropertiesProvider {
    private static final long serialVersionUID = -5745569096852733921L;
    private final RuleProxy<? extends RailwayProductPropertiesProvider, ?> ruleProxy;
    private final Set<String> blankOwners = new HashSet<String>();
    private final Set<String> passengerTypeCategories = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final Set<String> arriveLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private final List<String> trainNumbers = new ArrayList<String>();
    private final List<String> carriageTypes = new ArrayList<String>();
    private final List<String> serviceClasses = new ArrayList<String>();
    private final Set<String> fopTypes = new HashSet<String>();
    private final List<String> carriers = new ArrayList<String>();
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    protected String gdsName;
    protected RailwayProduct product;
    private Set<String> m_passengerTypes;
    private Date issueDate;
    private String validatorCode;
    private String salesPoint;
    private String pnr;
    private int segmentsAmount;
    private Date departureDate;
    private Date arrivalDate;
    private Date departureDateLocal;
    private Date arrivalDateLocal;
    private String passengerStatus;
    private boolean eticket;
    private BigDecimal totalEquivalentFare;
    private BigDecimal previousSellTotalEquivalentFare;
    private TransportationType transportationType;
    private EntityReference<Person> agent;
    private EntityReference<Person> bookingAgent;
    private EntityReference<Organization> client;
    private int travelDuration;
    private boolean translateSupplierFees;
    private final Collection<EntityReference<Person>> travellers = new ArrayList<EntityReference<Person>>();
    private final Collection<EntityReference<Organization>> payers = new HashSet<EntityReference<Organization>>();
    private final LazyValueHolder<List<EmployeeCategory>> employeeCategories = new LazyValueHolder(ArrayList::new);
    private final LazyValueHolder<Boolean> createdByClient = new LazyValueHolder(() -> Boolean.FALSE);
    private final LazyValueHolder<List<EntityReference<Organization>>> employers = new LazyValueHolder(ArrayList::new);
    private String clientCreditCardVendor;
    private String agencyCode;
    private String branchUid;
    private String reservationType;
    private EntityReference<Organization> supplier;
    private final List<CostCode> costCodes = new ArrayList<CostCode>();
    private Money travelSubjectTotalPrice;
    private TravelSubject travelSubject;

    public RailwayProductPropertySet(RuleProxy<? extends RailwayProductPropertiesProvider, ?> ruleProxy) {
        this.ruleProxy = ruleProxy;
    }

    public RailwayProduct getProduct() {
        return this.product;
    }

    public Set<String> getBlankOwners() {
        return this.blankOwners;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public void setValidatorCode(String validatorCode) {
        this.validatorCode = validatorCode;
    }

    public String getSalesPoint() {
        return this.salesPoint;
    }

    public void setSalesPoint(String salesPoint) {
        this.salesPoint = salesPoint;
    }

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String pnr) {
        this.pnr = pnr;
    }

    public int getSegmentsAmount() {
        return this.segmentsAmount;
    }

    public void setSegmentsAmount(int segmentsAmount) {
        this.segmentsAmount = segmentsAmount;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public Set<String> getArrivalLocations() {
        return this.arriveLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public List<String> getTrainNumbers() {
        return this.trainNumbers;
    }

    public List<String> getCarriageTypes() {
        return this.carriageTypes;
    }

    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public Date getArrivalDate() {
        return this.arrivalDate;
    }

    public Date getArrivalDateLocal() {
        return this.arrivalDateLocal;
    }

    public Date getDepartureDateLocal() {
        return this.departureDateLocal;
    }

    public Set<String> getFopTypes() {
        return this.fopTypes;
    }

    public String getPassengerStatus() {
        return this.passengerStatus;
    }

    public void setPassengerStatus(String passengerStatus) {
        this.passengerStatus = passengerStatus;
    }

    public Set<String> getPassengerTypes() {
        return this.m_passengerTypes;
    }

    public Set<String> getPassengerTypeCategories() {
        return this.passengerTypeCategories;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public void setGdsName(String gdsName) {
        this.gdsName = gdsName;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public void setEticket(boolean eticket) {
        this.eticket = eticket;
    }

    public BigDecimal getTotalEquivalentFare() {
        return this.totalEquivalentFare;
    }

    public void setTotalEquivalentFare(BigDecimal totalEquivalentFare) {
        this.totalEquivalentFare = totalEquivalentFare;
    }

    public BigDecimal getPreviousSellTotalEquivalentFare() {
        return this.previousSellTotalEquivalentFare;
    }

    public void setPreviousSellTotalEquivalentFare(BigDecimal previousSellTotalEquivalentFare) {
        this.previousSellTotalEquivalentFare = previousSellTotalEquivalentFare;
    }

    public List<String> getCarriers() {
        return this.carriers;
    }

    public TransportationType getTransportationType() {
        return this.transportationType;
    }

    public int getTravelDuration() {
        return this.travelDuration;
    }

    public void init(RailwayProduct product) {
        RuleLogTracer tracer = this.ruleProxy.getTracer();
        tracer.traceEnteringMethod(RailwayProductPropertySet.class, "init()", new String[0]);
        try {
            RailwayProduct previousProduct;
            this.agencyCode = CommonProductHelper.getAgencyCode((BaseProduct)product);
            this.supplier = RailwayProductHelper.getSupplier((BaseProduct)product);
            this.product = product;
            if (product.getReservation() != null && product.getReservation().getType() != null) {
                this.reservationType = product.getReservation().getType().name();
            }
            this.agent = product.getCashier();
            this.bookingAgent = product.getReservation().getBookingAgent();
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                this.client = product.getReservation().getBookingFile().getCustomerProfile();
            }
            CommonProductHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)RailwayProductHelper.getSubagency((RailwayProduct)product));
            this.agencyCode = CommonProductHelper.getAgencyCode((BaseProduct)product);
            CommonProductHelper.addProfileGroups(this.profileGroups, this.agent);
            this.setTravelSubject(ProductHandler.of((BaseProduct)product).findTravelSubject((BaseProduct)product));
            this.setTravelSubjectTotalPrice(BookingHelper.getTravelSubjectTotalPrice((BaseProduct)product));
            if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
                CommonProductHelper.addProfileGroups(this.profileGroups, (EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
            }
            this.blankOwners.clear();
            this.blankOwners.addAll(RailwayRulesHelper.getBlankOwnerValues((EntityReference<Organization>)product.getBlankOwnerRef()));
            this.m_passengerTypes = RailwayProductHelper.getPassengerTypes((RailwayProduct)product).stream().filter(Objects::nonNull).map(DictionaryReference::getCode).collect(Collectors.toSet());
            this.passengerTypeCategories.clear();
            this.passengerTypeCategories.addAll(RailwayProductHelper.getPassengerTypes((RailwayProduct)product).stream().flatMap(it -> RulesHelper.getPassengerTypeCategoryCodes((DictionaryReference)it).stream()).filter(Objects::nonNull).collect(Collectors.toSet()));
            this.issueDate = product.getIssueDate();
            this.validatorCode = RailwayProductPropertySet.getString(product.getValidatorCode());
            EntityReference salesPointReference = product.getSalesPoint();
            if (salesPointReference != null) {
                this.salesPoint = product.getSalesPoint().getUid();
            }
            this.pnr = RailwayProductPropertySet.getString(product.getReservation() != null ? CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()) : null);
            this.segmentsAmount = product.getSegments().size();
            this.departureLocations.clear();
            this.arriveLocations.clear();
            this.visitedCities.clear();
            this.trainNumbers.clear();
            this.carriageTypes.clear();
            this.serviceClasses.clear();
            this.carriers.clear();
            this.travelDuration = 0;
            for (RailwaySegment segment : product.getSegments()) {
                Integer durationInMinutes;
                Date adl;
                Date ddl;
                Date ad;
                Date dd;
                String carrierCode;
                DictionaryReference arriveStation;
                HashSet<String> geoCodes = new HashSet<String>();
                DictionaryReference departureStation = segment.getDepartureStation();
                if (departureStation != null) {
                    geoCodes.clear();
                    geoCodes.add(departureStation.getCode());
                    geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
                    this.departureLocations.addAll(geoCodes);
                    this.visitedCities.add(geoCodes.toArray(new String[0]));
                }
                if ((arriveStation = segment.getArriveStation()) != null) {
                    geoCodes.clear();
                    geoCodes.add(arriveStation.getCode());
                    geoCodes.addAll(RailwayProxyHelper.collectRailwayStationCodes(geoCodes));
                    this.arriveLocations.addAll(geoCodes);
                    this.visitedCities.add(geoCodes.toArray(new String[0]));
                }
                this.trainNumbers.add(RailwayProductPropertySet.getString(segment.getTrainNumber()));
                this.carriageTypes.add(RailwayProductPropertySet.getEnumName(segment.getCarriageType()));
                this.serviceClasses.add(RailwayProductPropertySet.getEnumName(segment.getServiceClass()));
                if (segment.getCarrier() != null && !this.carriers.contains(carrierCode = segment.getCarrier().getCode())) {
                    this.carriers.add(carrierCode);
                }
                if ((dd = this.getSegmentDepartureDate(segment)) != null && (this.departureDate == null || this.departureDate.after(dd))) {
                    this.departureDate = dd;
                }
                if ((ad = this.getSegmentArrivalDate(segment)) != null && (this.arrivalDate == null || this.arrivalDate.before(ad))) {
                    this.arrivalDate = ad;
                }
                if ((ddl = this.getSegmentDepartureDateLocal(segment)) != null && (this.departureDateLocal == null || this.departureDateLocal.after(ddl))) {
                    this.departureDateLocal = ddl;
                }
                if ((adl = this.getSegmentArrivalDateLocal(segment)) != null && (this.arrivalDateLocal == null || this.arrivalDateLocal.before(adl))) {
                    this.arrivalDateLocal = adl;
                }
                this.travelDuration += (durationInMinutes = segment.getDurationInMinutes()) != null ? durationInMinutes : 0;
            }
            this.fopTypes.clear();
            for (RailwayProductFop fop : RailwayProductHelper.getClientFops((RailwayProduct)product)) {
                PaymentType paymentType = fop.getType();
                if (paymentType == null) continue;
                this.fopTypes.add(RailwayProductPropertySet.getEnumName(paymentType));
            }
            for (RailwayProductFop fop : RailwayProductHelper.getVendorFops((RailwayProduct)product)) {
                if (fop.getType() != PaymentType.CREDIT && fop.getType() != PaymentType.INTERLINE && fop.getType() != PaymentType.MTD) continue;
                this.passengerStatus = RailwayProductPropertySet.getEnumName(fop.getPassengerStatus());
                break;
            }
            this.gdsName = RailwayProductPropertySet.getEnumName(product.getReservation() != null ? CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)product.getReservation()) : null);
            this.eticket = product.isEticket();
            this.totalEquivalentFare = product.getTotalEquivalentFare();
            this.transportationType = RailwayProductHelper.getTransportationType((RailwayProduct)product);
            if (product.getStatus() == ProductStatus.REFUND && (previousProduct = product.getPreviousProduct()) != null) {
                this.previousSellTotalEquivalentFare = previousProduct.getTotalEquivalentFare();
            }
            this.payers.addAll(PayersCollector.collect((BaseProduct)product));
            product.getPassengers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.travellers::add);
            this.employeeCategories.setSupplier(() -> GeneralProductHelper.getEmployeeCategories((BaseProduct)product));
            this.createdByClient.setSupplier(() -> BookingHelper.isCreatedByClient((Reservation)product.getReservation()));
            this.clientCreditCardVendor = ProductPropertiesHelper.getClientCreditCardVendor((BaseProduct)product);
            this.branchUid = Optional.ofNullable(product.getBranch()).map(EntityReference::getUid).orElse(null);
            this.employers.setSupplier(() -> BookingHelper.getEmployersOfBookingAgent((Reservation)product.getReservation()));
            this.costCodes.addAll(StatisticsHelper.getProductCostCodes((BaseProduct)product, null));
            this.afterInit(product);
        }
        catch (Exception e) {
            tracer.traceError("unable to initialize railway property set", (Throwable)e);
            throw e;
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(RailwayProductPropertySet.class, "init()", new String[0]);
        }
    }

    protected Date getSegmentArrivalDate(RailwaySegment segment) {
        return segment.getArriveDate();
    }

    protected Date getSegmentDepartureDate(RailwaySegment segment) {
        return segment.getDepartureDate();
    }

    protected Date getSegmentArrivalDateLocal(RailwaySegment segment) {
        return segment.getLocalArriveDate();
    }

    protected Date getSegmentDepartureDateLocal(RailwaySegment segment) {
        return segment.getLocalDepartureDate();
    }

    protected void afterInit(RailwayProduct product) {
    }

    public Collection<EntityReference<Person>> getTravellers() {
        return this.travellers;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Person> getBookingAgent() {
        return this.bookingAgent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public Collection<EntityReference<Organization>> getPayers() {
        return this.payers;
    }

    public boolean isTranslateSupplierFees() {
        return this.translateSupplierFees;
    }

    public void setTranslateSupplierFees(boolean value) {
        this.translateSupplierFees = value;
    }

    public List<CostCode> getCostCodes() {
        return this.costCodes;
    }

    public TicketType getTicketType() {
        return this.product.getTicketType();
    }

    private static <E extends Enum<?>> String getEnumName(E value) {
        if (value == null) {
            return null;
        }
        return value.name();
    }

    private static String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public ProductStatus getProductStatus() {
        return this.product.getStatus();
    }

    public List<EmployeeCategory> getEmployeeCategories() {
        return (List)this.employeeCategories.get();
    }

    public boolean isCreatedByClient() {
        return (Boolean)this.createdByClient.get();
    }

    public List<EntityReference<Organization>> getEmployersOfBookingAgent() {
        return (List)this.employers.get();
    }

    public String getClientCreditCardVendor() {
        return this.clientCreditCardVendor;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public String getBranchUid() {
        return this.branchUid;
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public RailwayMcoCategory getRailwayMcoCategory() {
        return null;
    }

    public Money getTravelSubjectTotalPrice() {
        return this.travelSubjectTotalPrice;
    }

    public void setTravelSubjectTotalPrice(Money totalPrice) {
        this.travelSubjectTotalPrice = totalPrice;
    }

    public TravelSubject getTravelSubject() {
        return this.travelSubject;
    }

    public void setTravelSubject(TravelSubject travelSubject) {
        this.travelSubject = travelSubject;
    }
}

