/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.rules.standart.proxy;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RailwayRulesHelper {
    static final Logger log = LoggerFactory.getLogger(RailwayRulesHelper.class);

    static String getProductTitle(RailwayProduct product) {
        return product.getSystemNumber() != null ? product.getSystemNumber() : null;
    }

    public static List<GeneralProductFop> toGeneralFops(List<RailwayProductFop> fops) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (RailwayProductFop fop : fops) {
            GeneralProductFop item = new GeneralProductFop();
            item.setUid(fop.getUid());
            item.setAgent(fop.getAgent());
            item.setCard(fop.getCard());
            item.setEquivalentAmount(fop.getAmount() != null ? fop.getAmount().getValue() : null);
            item.setOperationDate(fop.getOperationDate());
            item.setPassengerStatus(fop.getPassengerStatus());
            item.setRelatedTicketNumber(fop.getRelatedTicketNumber());
            item.setType(fop.getType());
            item.setPayer(fop.getPayer());
            item.getCommissions().addAll(fop.getCommissions());
            result.add(item);
        }
        return result;
    }

    public static void fromGeneralFops(GeneralProductContractRelationData relation, List<RailwayProductFop> fops) {
        List generalFops = relation.getFops();
        ArrayList<RailwayProductFop> newFops = new ArrayList<RailwayProductFop>();
        for (GeneralProductFop fop : generalFops) {
            RailwayProductFop item = (RailwayProductFop)CollectionUtil.find(fops, (String)fop.getUid());
            if (item == null) {
                item = new RailwayProductFop();
                item.setUid(fop.getUid());
            }
            item.setAgent(fop.getAgent());
            item.setCard(fop.getCard());
            item.setAmount(fop.getEquivalentAmount() != null ? SystemHelper.getMoney((double)fop.getEquivalentAmount().doubleValue(), (String)(relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency())) : null);
            item.setOperationDate(fop.getOperationDate());
            item.setRelatedTicketNumber(fop.getRelatedTicketNumber());
            item.setType(fop.getType());
            item.getCommissions().clear();
            item.setPayer(fop.getPayer());
            item.getCommissions().addAll(fop.getCommissions());
            newFops.add(item);
        }
        fops.clear();
        fops.addAll(newFops);
    }

    public static Set<String> getBlankOwnerValues(EntityReference<Organization> blankOwnerRef) {
        HashSet<String> result = new HashSet<String>();
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        if (blankOwnerCtr != null) {
            Organization blankOwner = (Organization)blankOwnerCtr.getEntity();
            result.add(blankOwner.getCode());
            result.addAll(blankOwner.getShortName().getValues().values());
            result.addAll(blankOwner.getFullName().getValues().values());
        }
        return result;
    }
}

