/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.model.rules.travelPolicy;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductPropertySet;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TravelPolicyRailwayProductPropertySet
extends RailwayProductPropertySet
implements TravelPolicyPropertiesProvider {
    private final Set<EntityReference<Person>> persons = new HashSet<EntityReference<Person>>();
    private BigDecimal clientTotal;
    private String clientCurrency;
    private TravelPolicyMatchType matchType;

    public TravelPolicyRailwayProductPropertySet(RuleProxy<? extends RailwayProductPropertiesProvider, ?> ruleProxy) {
        super(ruleProxy);
    }

    @Override
    public void init(RailwayProduct product) {
        super.init(product);
        ProductHandler.of((BaseProduct)product).getTravellers((BaseProduct)product).stream().map(Traveller::getPassenger).filter(Objects::nonNull).forEach(this.persons::add);
        this.clientTotal = BookingHelper.getTotalPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
        DictionaryReference currency = GeneralProductHelper.getCurrency((BaseContractRelationData)GeneralProductHelper.getContractRelation((BaseProduct)product, (ContractType)ContractType.CLIENT));
        this.clientCurrency = DictHelper.getCode((DictionaryReference)currency);
        for (RailwaySegment segment : product.getSegments()) {
            if (Objects.equals(segment.getTrainNumber(), segment.getTrainNumberInSearch()) || !TextUtil.nonBlank((String)segment.getTrainNumberInSearch())) continue;
            this.getTrainNumbers().add(TravelPolicyRailwayProductPropertySet.getString(segment.getTrainNumberInSearch()));
        }
    }

    private static String getString(String value) {
        return TextUtil.isBlank((String)value) ? null : value.trim();
    }

    public Set<EntityReference<Person>> getPersons() {
        return this.persons;
    }

    public BigDecimal getClientTotal() {
        return this.clientTotal;
    }

    public BigDecimal getMinimal(EntityReference<BaseTravelPolicyMinimalPriceProperties> propsRef) {
        throw new UnsupportedOperationException();
    }

    public String getClientCurrency() {
        return this.clientCurrency;
    }

    public void setMatchType(TravelPolicyMatchType matchType) {
        this.matchType = matchType;
    }

    public TravelPolicyMatchType getMatchType() {
        return this.matchType;
    }
}

