/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.aura;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.AuraDataType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.aura.AuraDataHolder;
import com.gridnine.xtrip.server.parsers2.aura.AuraHelper;
import com.gridnine.xtrip.server.railway.parsers.aura.AuraRailwayProductData;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuraParseRailwayProductRefundProductExchangeDataProcessor
extends BaseProcessor {
    private static final String FORCED_TOKEN = "1";

    public void process(MessageContext context) throws Exception {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        AuraDataHolder holder = (AuraDataHolder)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        Boolean registrationPhase = (Boolean)context.getObject((Enum)IBusParsersContextKeys.REGISTRATION_PHASE);
        boolean registration = registrationPhase != null && registrationPhase != false;
        Element refundDataElement = XmlUtil.getElement((Element)document.getDocumentElement(), (String)"REPS/DATA/TICK_RET/DATA");
        if (refundDataElement != null) {
            this.parse((AuraDataHolder<AuraRailwayProductData>)holder, document, refundDataElement, registration, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(holder.toString());
        }
    }

    private void parse(AuraDataHolder<AuraRailwayProductData> holder, Document document, Element element, boolean registration, boolean related) {
        Object clientContainer;
        EntityReference client;
        AuraRailwayProductData data = related ? (AuraRailwayProductData)holder.getPreviousData() : (AuraRailwayProductData)holder.getCurrentData();
        ArrayList<Message> messages = new ArrayList<Message>();
        String id = XmlUtil.getValue((Element)element, (String)"@ID");
        String pnr = XmlUtil.getValue((Element)element, (String)"@PNR");
        EntityReference blankOwner = null;
        String blankCode = AuraHelper.parseBlankCode((Element)element);
        if (!TextUtil.isBlank((String)blankCode)) {
            Element blankOwnerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/EMI/DATA"), (String)"BLN_CODE", (String)blankCode);
            if (blankOwnerElement != null) {
                String blankOwnerUid = XmlUtil.getValue((Element)blankOwnerElement, (String)"@NSO_SID");
                String blankOwnerName = XmlUtil.getValue((Element)blankOwnerElement, (String)"@NAME");
                if (!TextUtil.isBlank((String)blankOwnerUid)) {
                    blankOwner = AuraHelper.getOrganization((String)blankOwnerUid, (String)blankOwnerUid, (String)blankOwnerName, (OrganizationType)OrganizationType.BLANK_OWNER, messages, (!registration ? 1 : 0) != 0);
                }
            }
        } else {
            blankOwner = data.getAgency();
        }
        EntityReference supplier = null;
        TicketType ticketType = null;
        String supplierCode = XmlUtil.getValue((Element)element, (String)"@MARK");
        if (!TextUtil.isBlank((String)supplierCode)) {
            String supplierUid = AuraHelper.getSupplierUid((String)supplierCode);
            if (!TextUtil.isBlank((String)supplierUid)) {
                supplier = AuraHelper.getOrganization((String)supplierUid, null, null, (OrganizationType)OrganizationType.AGENCY, messages, (!registration ? 1 : 0) != 0);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductSupplierDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_supplierWithCodeNotSupported_railway, (Object[])new Object[]{supplierCode}), (Object[])new Object[0]));
            }
            ticketType = TicketType.EXTERNAL;
        } else {
            supplier = !TextUtil.isBlank((String)XmlUtil.getValue((Element)element, (String)"@BL_CODE")) ? blankOwner : data.getAgency();
            ticketType = TicketType.OWN;
        }
        String validatorNumber = XmlUtil.getValue((Element)element, (String)"@VALDR");
        boolean eticket = AuraHelper.isETicket((String)XmlUtil.getValue((Element)element, (String)"@EMARK"), (String)blankCode);
        boolean forced = TextUtil.isSame((String)FORCED_TOKEN, (String)XmlUtil.getValue((Element)element, (String)"@EMERGENCY"));
        String blankSeries = AuraHelper.parseBlankSeries((Element)element);
        String blankNumber = AuraHelper.parseBlankNumber((Element)element);
        DictionaryReference blankType = null;
        if (!TextUtil.isBlank((String)blankSeries) && blankOwner != null) {
            blankType = DictHelper.getBlankType((EntityReference)blankOwner, (String)(eticket ? null : "\u0420\u0416\u0414 \u0421\u043b\u0438\u043f"), (ProductCategory)ProductCategory.AIR, (BlankCategory)(eticket ? BlankCategory.ETICKET : null));
        }
        String systemNumber = null;
        if (!TextUtil.isBlank((String)blankSeries) || !TextUtil.isBlank((String)blankNumber)) {
            systemNumber = TextUtil.join((String)"", Arrays.asList(blankSeries, blankNumber), (boolean)true);
        }
        Date issueDate = null;
        String issueDateString = XmlUtil.getValue((Element)element, (String)"RETREF@REG_DT");
        if (!TextUtil.isBlank((String)issueDateString)) {
            try {
                issueDate = AuraHelper.getDateFormat().parse(issueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductIssueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_dateHasWrongFormat_railway, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Date previousProductIssueDate = null;
        String previousProductIssueDateString = XmlUtil.getValue((Element)element, (String)"@OP_DATE");
        if (!TextUtil.isBlank((String)previousProductIssueDateString)) {
            try {
                previousProductIssueDate = AuraHelper.getDateFormat().parse(previousProductIssueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductIssueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_dateHasWrongFormat_railway, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        String name = XmlUtil.getValue((Element)element, (String)"@PASS_FIO");
        Date birthday = null;
        String birthdayString = XmlUtil.getValue((Element)element, (String)"EXT_INFO@BIRTHDAY");
        if (!TextUtil.isBlank((String)birthdayString)) {
            try {
                birthday = AuraHelper.getDateFormat().parse(birthdayString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductBirthdayDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_dateHasWrongFormat_railway, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        Passport passport = new Passport();
        String passportNumber = XmlUtil.getValue((Element)element, (String)"@NOTE2");
        if (!TextUtil.isBlank((String)passportNumber)) {
            passportNumber = passportNumber.replaceAll("^\\D+", "");
        }
        passport.setNumber(passportNumber);
        passport.setBirthday(birthday);
        Traveller traveller = new Traveller();
        traveller.setName(name);
        traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
        traveller.setBirthday(birthday);
        traveller.setPassport(passport);
        travellers.clear();
        travellers.add(traveller);
        BigDecimal totalFare = null;
        String totalFareString = XmlUtil.getValue((Element)element, (String)"@FARE_TOT");
        if (!TextUtil.isBlank((String)totalFareString)) {
            try {
                totalFare = (BigDecimal)AuraHelper.getNumberFormat().parse(totalFareString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductTotalFareDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal totalVat = null;
        String totalVatString = XmlUtil.getValue((Element)element, (String)"@VAT_SUM");
        if (!TextUtil.isBlank((String)totalVatString)) {
            try {
                totalVat = (BigDecimal)AuraHelper.getNumberFormat().parse(totalVatString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductTotalVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        ArrayList<RailwaySegment> segments = new ArrayList<RailwaySegment>();
        for (int i = 0; i < 4; ++i) {
            Element segmentElement = XmlUtil.getElement((Element)element, (String)String.format("S%s", String.valueOf(i + 1)));
            if (segmentElement == null) continue;
            RailwayStationReference departureLocation = null;
            String departureLocationCode = "2034130";
            Collection departureStations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)departureLocationCode);
            if (departureStations.size() > 0) {
                departureLocation = ((RailwayStation)departureStations.iterator().next()).toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductDepartureLocationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_railwayProductRailwayStationWithCodeNotFound, (Object[])new Object[]{departureLocationCode}), (Object[])new Object[0]));
            }
            RailwayStationReference arriveLocation = null;
            String arriveLocationCode = "2000002";
            Collection arriveStations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)arriveLocationCode);
            if (arriveStations.size() > 0) {
                arriveLocation = ((RailwayStation)arriveStations.iterator().next()).toReference();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductArriveLocationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_railwayProductRailwayStationWithCodeNotFound, (Object[])new Object[]{arriveLocationCode}), (Object[])new Object[0]));
            }
            String trainNumber = "001";
            String slot = "\u041c";
            ServiceClass serviceClass = ServiceClass.K2;
            Object departureDate = null;
            String departureDateString = XHelper.readString((Element)segmentElement, (String)"@DPT_DT");
            if (!TextUtil.isBlank((String)departureDateString)) {
                try {
                    departureDate = AuraHelper.getDateFormat().parse(departureDateString);
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductDepartureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_dateHasWrongFormat_railway, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            String carriageNumber = FORCED_TOKEN;
            CarriageType carriageType = CarriageType.K;
            CompartmentType compartmentType = CompartmentType.COMMON;
            List<String> places = Collections.singletonList(FORCED_TOKEN);
            RailwaySegment segment = new RailwaySegment();
            segment.setNumber(i + 1);
            segment.setDepartureStation((DictionaryReference)departureLocation);
            segment.setArriveStation((DictionaryReference)arriveLocation);
            segment.setTrainNumber(trainNumber);
            segment.setSlot(slot);
            segment.setCarriageNumber(carriageNumber);
            segment.setCarriageType(carriageType);
            segment.setCompartmentType(compartmentType);
            segment.setServiceClass(serviceClass);
            segment.setDepartureDate((Date)departureDate);
            segment.getPlaces().clear();
            segment.getPlaces().addAll(places);
            segments.add(segment);
        }
        BigDecimal equivalentFare = null;
        BigDecimal penalty = null;
        for (int i = 0; i < 16; ++i) {
            BigDecimal taxEquivalentAmount;
            Element taxElement = XmlUtil.getElement((Element)element, (String)String.format("TAX%s", String.valueOf(i + 1)));
            if (taxElement == null) continue;
            BigDecimal taxBaseAmountAmount = null;
            String taxBaseAmountAmountString = XHelper.readString((Element)taxElement, (String)"@VAL");
            if (!TextUtil.isBlank((String)taxBaseAmountAmountString)) {
                try {
                    taxBaseAmountAmount = (BigDecimal)AuraHelper.getNumberFormat().parse(taxBaseAmountAmountString);
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductTaxBaseAmountAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            String taxBaseAmountCurrency = null;
            String taxBaseAmountCurrencyCode = XHelper.readString((Element)taxElement, (String)"@CUR_CODE");
            if (!TextUtil.isBlank((String)taxBaseAmountCurrencyCode)) {
                try {
                    taxBaseAmountCurrency = taxBaseAmountCurrencyCode;
                }
                catch (IllegalArgumentException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductTaxBaseAmountCurrencyDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_currencyWithCodeNotSupported_railway, (Object[])new Object[]{taxBaseAmountCurrencyCode}), (Object[])new Object[0]));
                }
            }
            Money taxBaseAmount = null;
            if (taxBaseAmountAmount != null || taxBaseAmountCurrency != null) {
                taxBaseAmount = new Money();
                taxBaseAmount.setValue(taxBaseAmountAmount);
                taxBaseAmount.setCurrency(taxBaseAmountCurrency);
            }
            if ((taxEquivalentAmount = taxBaseAmountAmount) == null) continue;
            if (taxEquivalentAmount.compareTo(BigDecimal.ZERO) >= 0) {
                equivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivalentFare, taxEquivalentAmount});
                continue;
            }
            penalty = MiscUtil.sum((BigDecimal[])new BigDecimal[]{penalty, MiscUtil.negate((BigDecimal)taxEquivalentAmount)});
        }
        if (segments.size() > 0 && equivalentFare != null) {
            RailwaySegment segment = (RailwaySegment)segments.get(0);
            Money money = new Money();
            money.setValue(equivalentFare);
            money.setCurrency(DictHelper.getEquivCurrency());
            segment.setFare(money);
            segment.setEquivalentFare(equivalentFare);
        }
        EntityReference regularClient = null;
        EntityReference specialClient = null;
        EntityReference mediator = null;
        ArrayList<RailwayProductFop> vendorFops = new ArrayList<RailwayProductFop>();
        ArrayList<RailwayProductFop> subagentFops = new ArrayList<RailwayProductFop>();
        ArrayList<RailwayProductFop> clientFops = new ArrayList<RailwayProductFop>();
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            Element payElement = XmlUtil.getElement((Element)element, (String)String.format("PAY%s", String.valueOf(i + 1)));
            if (payElement == null) continue;
            for (ContractType contractType : Arrays.asList(ContractType.VENDOR, ContractType.SUBAGENCY, ContractType.CLIENT)) {
                PaymentType paymentType = null;
                String paymentTypeCode = XHelper.readString((Element)payElement, (String)"@PYFO_CODE");
                if (!TextUtil.isBlank((String)paymentTypeCode)) {
                    String paymentVariantCode = null;
                    if (paymentTypeCode.equals("\u041a")) {
                        paymentVariantCode = ProfileHelper.isOrganizationCode((EntityReference)blankOwner, (String)"\u04281") ? "B" : "A";
                    }
                    if ((paymentType = AuraHelper.getPaymentType((String)paymentTypeCode, paymentVariantCode, (ContractType)contractType)) == null && !AuraHelper.isIgnorePaymentType((String)paymentTypeCode, (ContractType)contractType)) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopPaymentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_paymentTypeWithCodeNotSupported_railway, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    paymentType = PaymentType.CASH;
                }
                Date operationDate = null;
                if (AuraHelper.isPaid((String)paymentTypeCode)) {
                    operationDate = issueDate;
                }
                BigDecimal fopBaseAmountAmount = null;
                String fopBaseAmountAmountString = XHelper.readString((Element)payElement, (String)"@VAL");
                if (!TextUtil.isBlank((String)fopBaseAmountAmountString)) {
                    try {
                        fopBaseAmountAmount = (BigDecimal)AuraHelper.getNumberFormat().parse(fopBaseAmountAmountString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopBaseAmountAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                String fopBaseAmountCurrency = null;
                String fopBaseAmountCurrencyCode = XHelper.readString((Element)payElement, (String)"@CUR_CODE");
                if (!TextUtil.isBlank((String)fopBaseAmountCurrencyCode)) {
                    try {
                        fopBaseAmountCurrency = fopBaseAmountCurrencyCode;
                    }
                    catch (IllegalArgumentException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopBaseAmountCurrencyDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_currencyWithCodeNotSupported_railway, (Object[])new Object[]{fopBaseAmountCurrencyCode}), (Object[])new Object[0]));
                    }
                }
                Money fopBaseAmount = null;
                if (fopBaseAmountAmount != null || fopBaseAmountCurrency != null) {
                    fopBaseAmount = new Money();
                    fopBaseAmount.setValue(fopBaseAmountAmount);
                    fopBaseAmount.setCurrency(fopBaseAmountCurrency);
                }
                AuraHelper.PayerType payerType = null;
                String payerTypeCode = XHelper.readString((Element)payElement, (String)"@D_CONTR_KIND");
                if (!TextUtil.isBlank((String)payerTypeCode)) {
                    payerType = AuraHelper.getPayerType((String)payerTypeCode);
                    if (payerType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductPayerTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_payerTypeWithCodeNotSupported_railway, (Object[])new Object[]{payerTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    payerType = AuraHelper.PayerType.REGULAR;
                }
                EntityReference payer = null;
                PassengerStatus passengerStatus = null;
                if (payerType != null) {
                    EntityContainer payerContainer;
                    String payerCode;
                    String payerUid;
                    Element payerElement;
                    String payerName;
                    if (payerType == AuraHelper.PayerType.REGULAR) {
                        payerName = XmlUtil.getValue((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)payerName)) {
                            payerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/CONT/DATA"), (String)"NAME", (String)payerName);
                            if (payerElement != null) {
                                payerUid = XmlUtil.getValue((Element)payerElement, (String)"@NSO_SID");
                                payerCode = XmlUtil.getValue((Element)payerElement, (String)"@DKNUMBER");
                                if (!TextUtil.isBlank((String)payerUid)) {
                                    payer = AuraHelper.getOrganization((String)payerUid, (String)payerCode, (String)payerName, (OrganizationType)OrganizationType.CORPORATE_CLIENT, messages, (!registration ? 1 : 0) != 0);
                                }
                            }
                        } else {
                            payerContainer = ProfileHelper.getRetailProfileContainer();
                            if (payerContainer != null) {
                                payer = payerContainer.toReference();
                            }
                        }
                    } else if (payerType == AuraHelper.PayerType.SPECIAL) {
                        payerName = XmlUtil.getValue((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)payerName)) {
                            payerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/CTC/DATA"), (String)"CTC_CODE", (String)payerName);
                            if (payerElement != null) {
                                payerUid = XmlUtil.getValue((Element)payerElement, (String)"@NSO_SID");
                                payerCode = XmlUtil.getValue((Element)payerElement, (String)"@DKNUMBER");
                                if (!TextUtil.isBlank((String)payerUid)) {
                                    payerName = XmlUtil.getValue((Element)payerElement, (String)"@NAME");
                                    payer = AuraHelper.getOrganization((String)payerUid, (String)payerUid, (String)payerName, (OrganizationType)OrganizationType.CORPORATE_CLIENT, messages, (!registration ? 1 : 0) != 0);
                                }
                            }
                        } else {
                            payerContainer = ProfileHelper.getRetailProfileContainer();
                            if (payerContainer != null) {
                                payer = payerContainer.toReference();
                            }
                        }
                        String passengerStatusCode = XHelper.readString((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)passengerStatusCode) && (passengerStatus = AuraHelper.getPassengerStatus((String)passengerStatusCode)) == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductPassengerStatusDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_passengerStatusWithCodeNotSupported_railway, (Object[])new Object[]{passengerStatusCode}), (Object[])new Object[0]));
                        }
                    }
                }
                if (payer != null) {
                    if (AuraHelper.isMediatorPaymentType((String)paymentTypeCode)) {
                        if (mediator == null) {
                            mediator = payer;
                        }
                    } else if (regularClient == null && payerType == AuraHelper.PayerType.REGULAR) {
                        regularClient = payer;
                    } else if (specialClient == null && payerType == AuraHelper.PayerType.SPECIAL) {
                        specialClient = payer;
                    }
                }
                String relatedDocumentNumber = null;
                String documentSeries = XmlUtil.getValue((Element)payElement, (String)"@D_SER");
                String documentNumber = XmlUtil.getValue((Element)payElement, (String)"@D_NO");
                if (!TextUtil.isBlank((String)documentSeries) || !TextUtil.isBlank((String)documentNumber)) {
                    relatedDocumentNumber = TextUtil.join((String)" ", Arrays.asList(documentSeries, documentNumber), (boolean)true);
                } else {
                    relatedDocumentNumber = XmlUtil.getValue((Element)payElement, (String)"@NOTE");
                    if (AuraHelper.isServiceDemandPaymentType((String)paymentTypeCode)) {
                        relatedDocumentNumber = relatedDocumentNumber.substring(Math.max(0, relatedDocumentNumber.indexOf(",") + 1));
                    }
                }
                if (AuraHelper.isIgnorePaymentType((String)paymentTypeCode, (ContractType)contractType)) continue;
                RailwayProductFop fop = new RailwayProductFop();
                fop.setType(paymentType);
                fop.setAmount(fopBaseAmount);
                fop.setAgent(data.getAgent());
                fop.setOperationDate(operationDate);
                fop.setPayer(payer);
                fop.setPassengerStatus(passengerStatus);
                fop.setRelatedTicketNumber(relatedDocumentNumber);
                if (contractType == ContractType.VENDOR) {
                    vendorFops.add(fop);
                    continue;
                }
                if (contractType == ContractType.SUBAGENCY) {
                    subagentFops.add(fop);
                    continue;
                }
                if (contractType != ContractType.CLIENT) continue;
                clientFops.add(fop);
            }
            ++count;
        }
        EntityReference entityReference = client = specialClient != null ? specialClient : regularClient;
        if (client == null && count > 0 && (clientContainer = ProfileHelper.getRetailProfileContainer()) != null) {
            client = clientContainer.toReference();
        }
        if (count == 0) {
            for (ContractType contractType : Arrays.asList(ContractType.VENDOR, ContractType.SUBAGENCY, ContractType.CLIENT)) {
                Money fopBaseAmount = new Money();
                fopBaseAmount.setValue(BigDecimal.ZERO);
                fopBaseAmount.setCurrency(DictHelper.getLocalCurrencyCode());
                RailwayProductFop fop = new RailwayProductFop();
                fop.setType(PaymentType.CASH);
                fop.setAmount(fopBaseAmount);
                fop.setAgent(data.getAgent());
                fop.setOperationDate(data.getIssueDate());
                fop.setPayer(client);
                fop.setPassengerStatus(null);
                fop.setRelatedTicketNumber(null);
                if (contractType == ContractType.VENDOR) {
                    vendorFops.add(fop);
                    continue;
                }
                if (contractType == ContractType.SUBAGENCY) {
                    subagentFops.add(fop);
                    continue;
                }
                if (contractType != ContractType.CLIENT) continue;
                clientFops.add(fop);
            }
        }
        AuraDataType dataType = AuraDataType.PRODUCT;
        ProductType productType = ProductType.RAILWAY_PRODUCT;
        TransactionType transactionType = TransactionType.REFUND;
        ProductStatus status = ProductStatus.REFUND;
        ((AuraRailwayProductData)holder.getPreviousData()).setIssueDate(previousProductIssueDate);
        data.setId(id);
        data.setTicketType(ticketType);
        data.setDataType(dataType);
        data.setProductType(productType);
        data.setTransactionType(transactionType);
        data.setStatus(status);
        data.setClient((EntityReference<Organization>)client);
        data.setBlankOwner((EntityReference<Organization>)blankOwner);
        data.setSupplier((EntityReference<Organization>)supplier);
        data.setMediator(mediator);
        data.setBlankType((DictionaryReference<BlankType>)blankType);
        data.setPnr(pnr);
        data.setValidatorNumber(validatorNumber);
        data.setSystemNumber(systemNumber);
        data.setEticket(eticket);
        data.setForced(forced);
        data.setIssueDate(issueDate);
        data.setTotalFare(totalFare);
        data.setTotalVat(totalVat);
        data.setPenalty(penalty);
        data.setEquivalentFare(equivalentFare);
        data.getTravellers().clear();
        data.getTravellers().addAll(travellers);
        data.getSegments().clear();
        data.getSegments().addAll(segments);
        data.getVendorFops().clear();
        data.getVendorFops().addAll(vendorFops);
        data.getSubagentFops().clear();
        data.getSubagentFops().addAll(subagentFops);
        data.getClientFops().clear();
        data.getClientFops().addAll(clientFops);
        data.getMessages().clear();
        data.getMessages().addAll(messages);
    }
}

