/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.aura;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.AuraDataType;
import com.gridnine.xtrip.common.parsers.model.AuraSupplementType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.aura.AuraDataHolder;
import com.gridnine.xtrip.server.parsers2.aura.AuraHelper;
import com.gridnine.xtrip.server.railway.parsers.aura.AuraRailwayProductData;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuraParseRailwayProductRefundSupplementExchangeDataProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Document document = (Document)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_ENTRY);
        AuraDataHolder holder = (AuraDataHolder)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        Boolean registrationPhase = (Boolean)context.getObject((Enum)IBusParsersContextKeys.REGISTRATION_PHASE);
        boolean registration = registrationPhase != null && registrationPhase != false;
        Element sellDataElement = XmlUtil.getElement((Element)document.getDocumentElement(), (String)"REPS/DATA/MCO_SALE/DATA");
        Element refundDataElement = XmlUtil.getElement((Element)document.getDocumentElement(), (String)"REPS/DATA/MCO_RET/DATA");
        if (sellDataElement != null) {
            this.parse((AuraDataHolder<AuraRailwayProductData>)holder, document, sellDataElement, registration, false);
        } else if (refundDataElement != null) {
            this.parse((AuraDataHolder<AuraRailwayProductData>)holder, document, refundDataElement, registration, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(holder.toString());
        }
    }

    private void parse(AuraDataHolder<AuraRailwayProductData> holder, Document document, Element element, boolean registration, boolean related) {
        EntityContainer clientContainer;
        EntityReference client;
        Element blankOwnerElement;
        AuraRailwayProductData data = related ? (AuraRailwayProductData)holder.getPreviousData() : (AuraRailwayProductData)holder.getCurrentData();
        ArrayList<Message> messages = new ArrayList<Message>();
        String id = XmlUtil.getValue((Element)element, (String)"@ID");
        String pnr = XmlUtil.getValue((Element)element, (String)"@PNR");
        EntityReference blankOwner = null;
        String blankCode = XmlUtil.getValue((Element)element, (String)"MCO_OT/BL_PACK@BL_CODE");
        if (!TextUtil.isBlank((String)blankCode) && (blankOwnerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/EMI/DATA"), (String)"BLN_CODE", (String)blankCode)) != null) {
            String blankOwnerUid = XmlUtil.getValue((Element)blankOwnerElement, (String)"@NSO_SID");
            String blankOwnerName = XmlUtil.getValue((Element)blankOwnerElement, (String)"@NAME");
            if (!TextUtil.isBlank((String)blankOwnerUid)) {
                blankOwner = AuraHelper.getOrganization((String)blankOwnerUid, (String)blankOwnerUid, (String)blankOwnerName, (OrganizationType)OrganizationType.BLANK_OWNER, messages, (!registration ? 1 : 0) != 0);
            }
        }
        EntityReference supplier = !TextUtil.isBlank((String)XmlUtil.getValue((Element)element, (String)"MCO_OT/BL_PACK@BL_CODE")) ? blankOwner : data.getAgency();
        String blankSeries = XmlUtil.getValue((Element)element, (String)"MCO_OT/BL_PACK@BL_SERIES");
        String blankNumber = XmlUtil.getValue((Element)element, (String)"MCO_OT/BL_PACK@BL_BEG_NO");
        String systemNumber = null;
        if (!TextUtil.isBlank((String)blankSeries) || !TextUtil.isBlank((String)blankNumber)) {
            systemNumber = TextUtil.join((String)"", Arrays.asList(blankSeries, blankNumber), (boolean)true);
        }
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        ArrayList<AuraSupplementType> supplementTypes = new ArrayList<AuraSupplementType>();
        for (int i = 0; i < 4; ++i) {
            String dataTypeCode;
            AuraDataType dataType;
            Element elementElement = XmlUtil.getElement((Element)element, (String)String.format("ELM%s", String.valueOf(i + 1)));
            if (elementElement == null || (dataType = AuraHelper.getDataType((String)(dataTypeCode = XHelper.readString((Element)elementElement, (String)"@ACCN_CODE")))) != AuraDataType.SUPPLEMENT) continue;
            String supplementTypeCode = XHelper.readString((Element)elementElement, (String)"@ACCN_CODE");
            AuraSupplementType supplementType = AuraHelper.getSupplementType((String)supplementTypeCode);
            if (supplementType == AuraSupplementType.SERVICE_FEE) {
                EntityReference serviceFeeProperties = null;
                String serviceFeeCode = XHelper.readString((Element)elementElement, (String)"@ACCN_CODE");
                if (!TextUtil.isBlank((String)serviceFeeCode) && (serviceFeeProperties = AuraHelper.getServiceFeeProperties((String)serviceFeeCode)) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductServiceFeePropertiesDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_serviceFeePropertiesWithCodeNotSupported_railway, (Object[])new Object[]{serviceFeeCode}), (Object[])new Object[0]));
                }
                BigDecimal sericeFeeBaseAmountAmount = null;
                String serviceFeeBaseAmountAmountString = XHelper.readString((Element)elementElement, (String)"@VAL");
                if (!TextUtil.isBlank((String)serviceFeeBaseAmountAmountString)) {
                    try {
                        sericeFeeBaseAmountAmount = (BigDecimal)AuraHelper.getNumberFormat().parse(serviceFeeBaseAmountAmountString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductServiceFeeBaseAmountAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                String serviceFeeBaseAmountCurrency = null;
                String serviceFeeBaseAmountCurrencyCode = XHelper.readString((Element)elementElement, (String)"@CUR_CODE");
                if (!TextUtil.isBlank((String)serviceFeeBaseAmountCurrencyCode)) {
                    try {
                        serviceFeeBaseAmountCurrency = serviceFeeBaseAmountCurrencyCode;
                    }
                    catch (IllegalArgumentException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductServiceFeeBaseAmountCurrencyDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_currencyWithCodeNotSupported_railway, (Object[])new Object[]{serviceFeeBaseAmountCurrencyCode}), (Object[])new Object[0]));
                    }
                }
                Money serviceFeeBaseAmount = null;
                if (sericeFeeBaseAmountAmount != null || serviceFeeBaseAmountCurrency != null) {
                    serviceFeeBaseAmount = new Money();
                    serviceFeeBaseAmount.setValue(sericeFeeBaseAmountAmount);
                    serviceFeeBaseAmount.setCurrency(serviceFeeBaseAmountCurrency);
                }
                BigDecimal serviceFeeEquivalentAmount = sericeFeeBaseAmountAmount;
                GeneralProductCommission serviceFee = new GeneralProductCommission();
                serviceFee.setAmount(serviceFeeBaseAmount);
                serviceFee.setEquivalentAmount(serviceFeeEquivalentAmount);
                serviceFee.setCommissionProperties(serviceFeeProperties);
                commissions.add(serviceFee);
            }
            if (supplementType == null || supplementTypes.contains(supplementType)) continue;
            supplementTypes.add(supplementType);
        }
        EntityReference regularClient = null;
        EntityReference specialClient = null;
        EntityReference mediator = null;
        ArrayList<RailwayProductFop> vendorFops = new ArrayList<RailwayProductFop>();
        ArrayList<RailwayProductFop> subagentFops = new ArrayList<RailwayProductFop>();
        ArrayList<RailwayProductFop> clientFops = new ArrayList<RailwayProductFop>();
        int count = 0;
        for (int i = 0; i < 7; ++i) {
            Element payElement = XmlUtil.getElement((Element)element, (String)String.format("PAY%s", String.valueOf(i + 1)));
            if (payElement == null) continue;
            for (ContractType contractType : Arrays.asList(ContractType.VENDOR, ContractType.SUBAGENCY, ContractType.CLIENT)) {
                PaymentType paymentType = null;
                String paymentTypeCode = XHelper.readString((Element)payElement, (String)"@PYFO_CODE");
                if (!TextUtil.isBlank((String)paymentTypeCode)) {
                    String paymentVariantCode = null;
                    if (paymentTypeCode.equals("\u041a")) {
                        paymentVariantCode = ProfileHelper.isOrganizationCode((EntityReference)blankOwner, (String)"\u04281") ? "B" : "A";
                    }
                    if ((paymentType = AuraHelper.getPaymentType((String)paymentTypeCode, paymentVariantCode, (ContractType)contractType)) == null && !AuraHelper.isIgnorePaymentType((String)paymentTypeCode, (ContractType)contractType)) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopPaymentTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_paymentTypeWithCodeNotSupported_railway, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    paymentType = PaymentType.CASH;
                }
                Date operationDate = null;
                BigDecimal fopBaseAmountAmount = null;
                String fopBaseAmountAmountString = XHelper.readString((Element)payElement, (String)"@VAL");
                if (!TextUtil.isBlank((String)fopBaseAmountAmountString)) {
                    try {
                        fopBaseAmountAmount = (BigDecimal)AuraHelper.getNumberFormat().parse(fopBaseAmountAmountString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopBaseAmountAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_valueNotNumber_railway, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                String fopBaseAmountCurrency = null;
                String fopBaseAmountCurrencyCode = XHelper.readString((Element)payElement, (String)"@CUR_CODE");
                if (!TextUtil.isBlank((String)fopBaseAmountCurrencyCode)) {
                    try {
                        fopBaseAmountCurrency = fopBaseAmountCurrencyCode;
                    }
                    catch (IllegalArgumentException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductFopBaseAmountCurrencyDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_currencyWithCodeNotSupported_railway, (Object[])new Object[]{fopBaseAmountCurrencyCode}), (Object[])new Object[0]));
                    }
                }
                Money fopBaseAmount = null;
                if (fopBaseAmountAmount != null || fopBaseAmountCurrency != null) {
                    fopBaseAmount = new Money();
                    fopBaseAmount.setValue(fopBaseAmountAmount);
                    fopBaseAmount.setCurrency(fopBaseAmountCurrency);
                }
                AuraHelper.PayerType payerType = null;
                String payerTypeCode = XHelper.readString((Element)payElement, (String)"@D_CONTR_KIND");
                if (!TextUtil.isBlank((String)payerTypeCode)) {
                    payerType = AuraHelper.getPayerType((String)payerTypeCode);
                    if (payerType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductPayerTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_payerTypeWithCodeNotSupported_railway, (Object[])new Object[]{payerTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    payerType = AuraHelper.PayerType.REGULAR;
                }
                EntityReference payer = null;
                PassengerStatus passengerStatus = null;
                if (payerType != null) {
                    EntityContainer payerContainer;
                    String payerCode;
                    String payerUid;
                    Element payerElement;
                    String payerName;
                    if (payerType == AuraHelper.PayerType.REGULAR) {
                        payerName = XmlUtil.getValue((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)payerName)) {
                            payerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/CONT/DATA"), (String)"NAME", (String)payerName);
                            if (payerElement != null) {
                                payerUid = XmlUtil.getValue((Element)payerElement, (String)"@NSO_SID");
                                payerCode = XmlUtil.getValue((Element)payerElement, (String)"@DKNUMBER");
                                if (!TextUtil.isBlank((String)payerUid)) {
                                    payer = AuraHelper.getOrganization((String)payerUid, (String)payerCode, (String)payerName, (OrganizationType)OrganizationType.CORPORATE_CLIENT, messages, (!registration ? 1 : 0) != 0);
                                }
                            }
                        } else {
                            payerContainer = ProfileHelper.getRetailProfileContainer();
                            if (payerContainer != null) {
                                payer = payerContainer.toReference();
                            }
                        }
                    } else if (payerType == AuraHelper.PayerType.SPECIAL) {
                        payerName = XmlUtil.getValue((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)payerName)) {
                            payerElement = AuraHelper.find((Element[])XmlUtil.getElements((Element)document.getDocumentElement(), (String)"NSI/CTC/DATA"), (String)"CTC_CODE", (String)payerName);
                            if (payerElement != null) {
                                payerUid = XmlUtil.getValue((Element)payerElement, (String)"@NSO_SID");
                                payerCode = XmlUtil.getValue((Element)payerElement, (String)"@DKNUMBER");
                                if (!TextUtil.isBlank((String)payerUid)) {
                                    payerName = XmlUtil.getValue((Element)payerElement, (String)"@NAME");
                                    payer = AuraHelper.getOrganization((String)payerUid, (String)payerUid, (String)payerName, (OrganizationType)OrganizationType.CORPORATE_CLIENT, messages, (!registration ? 1 : 0) != 0);
                                }
                            }
                        } else {
                            payerContainer = ProfileHelper.getRetailProfileContainer();
                            if (payerContainer != null) {
                                payer = payerContainer.toReference();
                            }
                        }
                        String passengerStatusCode = XHelper.readString((Element)payElement, (String)"@D_CONTR_NAME");
                        if (!TextUtil.isBlank((String)passengerStatusCode) && (passengerStatus = AuraHelper.getPassengerStatus((String)passengerStatusCode)) == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.AuraExchangeProcessor_railwayProductPassengerStatusDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.AuraExchangeProcessor_passengerStatusWithCodeNotSupported_railway, (Object[])new Object[]{passengerStatusCode}), (Object[])new Object[0]));
                        }
                    }
                }
                if (payer != null) {
                    if (AuraHelper.isMediatorPaymentType((String)paymentTypeCode)) {
                        if (mediator == null) {
                            mediator = payer;
                        }
                    } else if (regularClient == null && payerType == AuraHelper.PayerType.REGULAR) {
                        regularClient = payer;
                    } else if (specialClient == null && payerType == AuraHelper.PayerType.SPECIAL) {
                        specialClient = payer;
                    }
                }
                String relatedDocumentNumber = null;
                String documentSeries = XmlUtil.getValue((Element)payElement, (String)"@D_SER");
                String documentNumber = XmlUtil.getValue((Element)payElement, (String)"@D_NO");
                if (!TextUtil.isBlank((String)documentSeries) || !TextUtil.isBlank((String)documentNumber)) {
                    relatedDocumentNumber = TextUtil.join((String)" ", Arrays.asList(documentSeries, documentNumber), (boolean)true);
                } else {
                    relatedDocumentNumber = XmlUtil.getValue((Element)payElement, (String)"@NOTE");
                    if (AuraHelper.isServiceDemandPaymentType((String)paymentTypeCode)) {
                        relatedDocumentNumber = relatedDocumentNumber.substring(Math.max(0, relatedDocumentNumber.indexOf(",") + 1));
                    }
                }
                if (AuraHelper.isIgnorePaymentType((String)paymentTypeCode, (ContractType)contractType)) continue;
                RailwayProductFop fop = new RailwayProductFop();
                fop.setType(paymentType);
                fop.setAmount(fopBaseAmount);
                fop.setAgent(data.getAgent());
                fop.setOperationDate(operationDate);
                fop.setPayer(payer);
                fop.setPassengerStatus(passengerStatus);
                fop.setRelatedTicketNumber(relatedDocumentNumber);
                if (contractType == ContractType.VENDOR && commissions.size() == 0) {
                    vendorFops.add(fop);
                    continue;
                }
                if (contractType == ContractType.SUBAGENCY && commissions.size() == 0) {
                    subagentFops.add(fop);
                    continue;
                }
                if (contractType != ContractType.CLIENT) continue;
                clientFops.add(fop);
            }
            ++count;
        }
        EntityReference entityReference = client = specialClient != null ? specialClient : regularClient;
        if (client == null && count > 0 && (clientContainer = ProfileHelper.getRetailProfileContainer()) != null) {
            client = clientContainer.toReference();
        }
        Iterator commissionIterator = commissions.iterator();
        block11: for (RailwayProductFop clientFop : clientFops) {
            while (commissionIterator.hasNext()) {
                GeneralProductCommission commission = (GeneralProductCommission)commissionIterator.next();
                clientFop.getCommissions().add(commission);
                if (MiscUtil.compare((Comparable)Optional.ofNullable(clientFop.getAmount()).map(item -> item.getValue()).orElse(null), (Comparable)clientFop.getCommissions().stream().map(item -> item.getEquivalentAmount()).reduce(null, (value, item) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, item}))) < 0) continue;
                continue block11;
            }
        }
        TicketType ticketType = TicketType.FAKE;
        AuraDataType dataType = AuraDataType.SUPPLEMENT;
        ProductType productType = ProductType.RAILWAY_PRODUCT;
        AuraSupplementType supplementType = supplementTypes.size() > 0 ? (AuraSupplementType)supplementTypes.get(0) : null;
        TransactionType transactionType = TransactionType.REFUND;
        ProductStatus status = ProductStatus.REFUND;
        data.setId(id);
        data.setTicketType(ticketType);
        data.setDataType(dataType);
        data.setProductType(productType);
        data.setSupplementType(supplementType);
        data.setTransactionType(transactionType);
        data.setStatus(status);
        data.setClient((EntityReference<Organization>)client);
        data.setBlankOwner((EntityReference<Organization>)blankOwner);
        data.setSupplier((EntityReference<Organization>)supplier);
        data.setMediator(mediator);
        data.setPnr(pnr);
        data.setSystemNumber(systemNumber);
        data.getCommissions().clear();
        data.getCommissions().addAll(commissions);
        data.getVendorFops().clear();
        data.getVendorFops().addAll(vendorFops);
        data.getSubagentFops().clear();
        data.getSubagentFops().addAll(subagentFops);
        data.getClientFops().clear();
        data.getClientFops().addAll(clientFops);
        data.getMessages().clear();
        data.getMessages().addAll(messages);
    }
}

