/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.aura;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.parsers2.aura.AuraData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AuraRailwayProductData
extends AuraData {
    private TicketType ticketType;
    private ProductStatus status;
    private EntityReference<Organization> client;
    private EntityReference<Organization> blankOwner;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> mediator;
    private DictionaryReference<BlankType> blankType;
    private GdsName gds;
    private String pnr;
    private String pcc;
    private String validatorNumber;
    private BigDecimal totalFare;
    private BigDecimal totalVat;
    private BigDecimal penalty;
    private boolean eticket;
    private boolean forced;
    private BigDecimal equivalentFare;
    private final List<RailwaySegment> segments = new ArrayList<RailwaySegment>();
    private final List<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
    private final List<RailwayProductFop> vendorFops = new ArrayList<RailwayProductFop>();
    private final List<RailwayProductFop> subagentFops = new ArrayList<RailwayProductFop>();
    private final List<RailwayProductFop> clientFops = new ArrayList<RailwayProductFop>();

    public TicketType getTicketType() {
        return this.ticketType;
    }

    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    public ProductStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProductStatus status) {
        this.status = status;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public void setClient(EntityReference<Organization> client) {
        this.client = client;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    public void setBlankOwner(EntityReference<Organization> blankOwner) {
        this.blankOwner = blankOwner;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public EntityReference<Organization> getMediator() {
        return this.mediator;
    }

    public void setMediator(EntityReference<Organization> mediator) {
        this.mediator = mediator;
    }

    public DictionaryReference<BlankType> getBlankType() {
        return this.blankType;
    }

    public void setBlankType(DictionaryReference<BlankType> blankType) {
        this.blankType = blankType;
    }

    public GdsName getGds() {
        return this.gds;
    }

    public void setGds(GdsName gds) {
        this.gds = gds;
    }

    public String getPnr() {
        return this.pnr;
    }

    public void setPnr(String pnr) {
        this.pnr = pnr;
    }

    public String getPcc() {
        return this.pcc;
    }

    public void setPcc(String pcc) {
        this.pcc = pcc;
    }

    public String getValidatorNumber() {
        return this.validatorNumber;
    }

    public void setValidatorNumber(String validatorNumber) {
        this.validatorNumber = validatorNumber;
    }

    public BigDecimal getTotalFare() {
        return this.totalFare;
    }

    public void setTotalFare(BigDecimal totalFare) {
        this.totalFare = totalFare;
    }

    public BigDecimal getTotalVat() {
        return this.totalVat;
    }

    public void setTotalVat(BigDecimal totalVat) {
        this.totalVat = totalVat;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public void setPenalty(BigDecimal penalty) {
        this.penalty = penalty;
    }

    public boolean isEticket() {
        return this.eticket;
    }

    public void setEticket(boolean eticket) {
        this.eticket = eticket;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public void setEquivalentFare(BigDecimal equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    public List<RailwaySegment> getSegments() {
        return this.segments;
    }

    public List<GeneralProductCommission> getCommissions() {
        return this.commissions;
    }

    public List<RailwayProductFop> getVendorFops() {
        return this.vendorFops;
    }

    public List<RailwayProductFop> getSubagentFops() {
        return this.subagentFops;
    }

    public List<RailwayProductFop> getClientFops() {
        return this.clientFops;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("ticketType -> " + this.ticketType);
        stringBuilder.append("\n");
        stringBuilder.append("status -> " + this.status);
        stringBuilder.append("\n");
        stringBuilder.append("client -> " + this.client);
        stringBuilder.append("\n");
        stringBuilder.append("blankOwner -> " + this.blankOwner);
        stringBuilder.append("\n");
        stringBuilder.append("supplier -> " + this.supplier);
        stringBuilder.append("\n");
        stringBuilder.append("mediator -> " + this.mediator);
        stringBuilder.append("\n");
        stringBuilder.append("blankType -> " + this.blankType);
        stringBuilder.append("\n");
        stringBuilder.append("gds -> " + this.gds);
        stringBuilder.append("\n");
        stringBuilder.append("pnr -> " + this.pnr);
        stringBuilder.append("\n");
        stringBuilder.append("pcc -> " + this.pcc);
        stringBuilder.append("\n");
        stringBuilder.append("validatorNumber -> " + this.validatorNumber);
        stringBuilder.append("\n");
        stringBuilder.append("totalFare -> " + this.totalFare);
        stringBuilder.append("\n");
        stringBuilder.append("totalVat -> " + this.totalVat);
        stringBuilder.append("\n");
        stringBuilder.append("penalty -> " + this.penalty);
        stringBuilder.append("\n");
        stringBuilder.append("eticket -> " + this.eticket);
        stringBuilder.append("\n");
        stringBuilder.append("forced -> " + this.forced);
        stringBuilder.append("\n");
        stringBuilder.append("equivalentFare -> " + this.equivalentFare);
        stringBuilder.append("\n");
        stringBuilder.append("segments -> ");
        stringBuilder.append("\n");
        for (RailwaySegment segment : this.segments) {
            stringBuilder.append("\n\t");
            stringBuilder.append("departureStation -> " + segment.getDepartureStation());
            stringBuilder.append("\n\t");
            stringBuilder.append("arriveStation -> " + segment.getArriveStation());
            stringBuilder.append("\n\t");
            stringBuilder.append("trainNumber -> " + segment.getTrainNumber());
            stringBuilder.append("\n\t");
            stringBuilder.append("slot -> " + segment.getSlot());
            stringBuilder.append("\n\t");
            stringBuilder.append("carriageNumber -> " + segment.getCarriageNumber());
            stringBuilder.append("\n\t");
            stringBuilder.append("carriageType -> " + segment.getCarriageType());
            stringBuilder.append("\n\t");
            stringBuilder.append("compartmentType -> " + segment.getCompartmentType());
            stringBuilder.append("\n\t");
            stringBuilder.append("serviceClass -> " + segment.getServiceClass());
            stringBuilder.append("\n\t");
            stringBuilder.append("departureDate -> " + segment.getDepartureDate());
            stringBuilder.append("\n\t");
            stringBuilder.append("amount -> " + (segment.getFare() != null ? (segment.getFare().getValue() != null ? segment.getFare().getValue().toPlainString() : "?") + " " + (segment.getFare().getCurrency() != null ? segment.getFare().getCurrency() : "?") : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("equivalentAmount -> " + segment.getEquivalentFare());
            stringBuilder.append("\n\t");
            stringBuilder.append("places -> " + Arrays.toString(segment.getPlaces().toArray()));
            stringBuilder.append("\n");
        }
        if (this.segments.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("commissions -> ");
        stringBuilder.append("\n");
        for (GeneralProductCommission commission : this.commissions) {
            stringBuilder.append("\n\t");
            stringBuilder.append("amount -> " + (commission.getAmount() != null ? (commission.getAmount().getValue() != null ? commission.getAmount().getValue().toPlainString() : "?") + " " + (commission.getAmount().getCurrency() != null ? commission.getAmount().getCurrency() : "?") : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("equivalentAmount -> " + (commission.getEquivalentAmount() != null ? commission.getEquivalentAmount().toPlainString() : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("commissionProperties -> " + commission.getCommissionProperties());
            stringBuilder.append("\n");
        }
        if (this.commissions.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("vendorFops -> ");
        stringBuilder.append("\n");
        for (RailwayProductFop vendorFop : this.vendorFops) {
            stringBuilder.append("\n\t");
            stringBuilder.append("paymentType -> " + vendorFop.getType());
            stringBuilder.append("\n\t");
            stringBuilder.append("amount -> " + (vendorFop.getAmount() != null ? (vendorFop.getAmount().getValue() != null ? vendorFop.getAmount().getValue().toPlainString() : "?") + " " + (vendorFop.getAmount().getCurrency() != null ? vendorFop.getAmount().getCurrency() : "?") : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("operationDate -> " + vendorFop.getOperationDate());
            stringBuilder.append("\n\t");
            stringBuilder.append("passengerStatus -> " + vendorFop.getPassengerStatus());
            stringBuilder.append("\n\t");
            stringBuilder.append("relatedDocumentNumber -> " + vendorFop.getRelatedTicketNumber());
            stringBuilder.append("\n\t");
            stringBuilder.append("payer -> " + vendorFop.getPayer());
            stringBuilder.append("\n");
        }
        if (this.vendorFops.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("subagentFops -> ");
        stringBuilder.append("\n");
        for (RailwayProductFop subagentFop : this.subagentFops) {
            stringBuilder.append("\n\t");
            stringBuilder.append("paymentType -> " + subagentFop.getType());
            stringBuilder.append("\n\t");
            stringBuilder.append("amount -> " + (subagentFop.getAmount() != null ? (subagentFop.getAmount().getValue() != null ? subagentFop.getAmount().getValue().toPlainString() : "?") + " " + (subagentFop.getAmount().getCurrency() != null ? subagentFop.getAmount().getCurrency() : "?") : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("operationDate -> " + subagentFop.getOperationDate());
            stringBuilder.append("\n\t");
            stringBuilder.append("passengerStatus -> " + subagentFop.getPassengerStatus());
            stringBuilder.append("\n\t");
            stringBuilder.append("relatedDocumentNumber -> " + subagentFop.getRelatedTicketNumber());
            stringBuilder.append("\n\t");
            stringBuilder.append("payer -> " + subagentFop.getPayer());
            stringBuilder.append("\n");
        }
        if (this.subagentFops.size() > 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("clientFops -> ");
        stringBuilder.append("\n");
        for (RailwayProductFop clientFop : this.clientFops) {
            stringBuilder.append("\n\t");
            stringBuilder.append("paymentType -> " + clientFop.getType());
            stringBuilder.append("\n\t");
            stringBuilder.append("amount -> " + (clientFop.getAmount() != null ? (clientFop.getAmount().getValue() != null ? clientFop.getAmount().getValue().toPlainString() : "?") + " " + (clientFop.getAmount().getCurrency() != null ? clientFop.getAmount().getCurrency() : "?") : "?"));
            stringBuilder.append("\n\t");
            stringBuilder.append("operationDate -> " + clientFop.getOperationDate());
            stringBuilder.append("\n\t");
            stringBuilder.append("passengerStatus -> " + clientFop.getPassengerStatus());
            stringBuilder.append("\n\t");
            stringBuilder.append("relatedDocumentNumber -> " + clientFop.getRelatedTicketNumber());
            stringBuilder.append("\n\t");
            stringBuilder.append("payer -> " + clientFop.getPayer());
            stringBuilder.append("\n");
        }
        if (this.clientFops.size() > 0) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

