/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.aura;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AuraParserMetaInfo;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.AuraDataType;
import com.gridnine.xtrip.common.parsers.model.AuraSupplementType;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers2.aura.AuraDataHolder;
import com.gridnine.xtrip.server.parsers2.aura.AuraHelper;
import com.gridnine.xtrip.server.railway.parsers.aura.AuraRailwayProductData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class AuraUpdateRailwaySellProductProductProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        AuraDataHolder holder = (AuraDataHolder)context.getMandatoryObject((Enum)IBusParsersContextKeys.EXCHANGE_DOCUMENT_DATA);
        ProductSearchResult productSearchResult = (ProductSearchResult)context.getMandatoryObject((Enum)IBusParsersContextKeys.PRODUCT_SEARCH_RESULT);
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.update(product, (AuraDataHolder<AuraRailwayProductData>)holder, false);
    }

    private void update(RailwayProduct product, AuraDataHolder<AuraRailwayProductData> holder, boolean related) throws Exception {
        AuraRailwayProductData data = related ? (AuraRailwayProductData)holder.getPreviousData() : (AuraRailwayProductData)holder.getCurrentData();
        BookingFile bookingFile = product.getReservation().getBookingFile();
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(data.getAgency());
        }
        if (bookingFile.getCustomerProfile() == null) {
            bookingFile.setCustomerProfile(data.getClient());
        }
        ArrayList<Traveller> productTravellers = new ArrayList<Traveller>();
        for (Traveller traveller : data.getTravellers()) {
            Traveller bookingFileTraveller = (Traveller)CollectionUtil.find((Collection)bookingFile.getTravellers(), (Object)traveller, TravellerHelper::equals);
            if (bookingFileTraveller != null) {
                if (bookingFileTraveller.getName() == null) {
                    bookingFileTraveller.setName(traveller.getName());
                }
                if (bookingFileTraveller.getCyrillicName() == null) {
                    bookingFileTraveller.setCyrillicName(traveller.getCyrillicName());
                }
                if (bookingFileTraveller.getNameInGds() == null) {
                    bookingFileTraveller.setNameInGds(traveller.getNameInGds());
                }
                if (bookingFileTraveller.getBirthday() == null) {
                    bookingFileTraveller.setBirthday(traveller.getBirthday());
                }
                if (bookingFileTraveller.getPassport() != null) {
                    if (traveller.getPassport() != null) {
                        if (bookingFileTraveller.getPassport().getNumber() == null) {
                            bookingFileTraveller.getPassport().setNumber(traveller.getPassport().getNumber());
                        }
                        if (bookingFileTraveller.getPassport().getBirthday() == null) {
                            bookingFileTraveller.getPassport().setBirthday(traveller.getPassport().getBirthday());
                        }
                    }
                } else {
                    bookingFileTraveller.setPassport(traveller.getPassport());
                }
                productTravellers.add(bookingFileTraveller);
                continue;
            }
            bookingFile.getTravellers().add(traveller);
            productTravellers.add(traveller);
        }
        Reservation reservation = product.getReservation();
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)data.getGds(), (RecordLocatorType)RecordLocatorType.DEFAULT, (String)data.getPnr());
        product.setTicketType(data.getTicketType());
        if (product.getStatus() != ProductStatus.VOID) {
            product.setStatus(data.getStatus());
        }
        product.setBlankOwnerRef(data.getBlankOwner());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)data.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)data.getSubagency());
        product.setSalesPoint(data.getSalesPoint());
        product.setCashier(data.getAgent());
        product.setBlankType(data.getBlankType());
        product.setIssueDate(data.getIssueDate());
        product.setPcc(data.getPcc());
        product.setValidatorCode(data.getValidatorNumber());
        product.setTotalEquivalentVAT(data.getTotalVat());
        product.setSystemNumber(data.getSystemNumber());
        product.getPassengers().clear();
        product.getPassengers().addAll(data.getTravellers());
        product.getPassengerTypes().clear();
        List infos = product.getAuraParserMetaInfos();
        AuraParserMetaInfo info = (AuraParserMetaInfo)CollectionUtil.computeIfAbsent((Collection)product.getAuraParserMetaInfos(), item -> TextUtil.isSame((String)item.getId(), (String)data.getId()), () -> new AuraParserMetaInfo());
        String sortingNumber = AuraHelper.getSortingNumber((AuraDataType)data.getDataType(), (ProductType)data.getProductType(), (TransactionType)data.getTransactionType(), (AuraSupplementType)data.getSupplementType(), (String)data.getSystemNumber());
        info.setId(data.getId());
        info.setSortingNumber(sortingNumber);
        Collections.sort(infos, MiscUtil.comparator(item -> item.getSortingNumber()));
        product.getSegments().removeIf(item -> info.getSegmentUids().contains(item.getUid()));
        product.getSegments().addAll(data.getSegments());
        info.getSegmentUids().clear();
        info.getSegmentUids().addAll(data.getSegments().stream().map(item -> item.getUid()).collect(Collectors.toList()));
        product.setEquivalentFare(data.getEquivalentFare());
        product.setTotalEquivalentFare(data.getTotalFare());
        product.setPenalty(data.getPenalty());
        product.setEticket(data.isEticket());
        RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        if (vendorContractRelation != null) {
            Collection vendorFops = data.getVendorFops().stream().collect(Collectors.groupingBy(item -> item.getType(), () -> new LinkedHashMap(), Collectors.reducing(null, (identity, item) -> {
                if (identity != null) {
                    if (!(item.getAmount() == null || item.getAmount().getValue() == null && TextUtil.isBlank((String)item.getAmount().getCurrency()))) {
                        Money amount = (Money)MiscUtil.computeIfNull((Object)identity, RailwayProductFop::getAmount, RailwayProductFop::setAmount, Money::new);
                        amount.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount.getValue(), item.getAmount().getValue()}));
                        if (TextUtil.isBlank((String)amount.getCurrency())) {
                            amount.setCurrency(item.getAmount().getCurrency());
                        }
                    }
                } else {
                    identity = (RailwayProductFop)MiscUtil.uncheckCall(() -> (RailwayProductFop)item.clone(true, new HashMap()));
                }
                return identity;
            }))).values();
            vendorContractRelation.getFops().removeIf(item -> info.getVendorFopUids().contains(item.getUid()));
            vendorContractRelation.getFops().addAll(vendorFops);
            info.getVendorFopUids().clear();
            info.getVendorFopUids().addAll(vendorFops.stream().map(item -> item.getUid()).collect(Collectors.toList()));
        }
        if (subagentContractRelation != null) {
            subagentContractRelation.getFops().removeIf(item -> info.getSubagentFopUids().contains(item.getUid()));
            subagentContractRelation.getFops().addAll(data.getSubagentFops());
            info.getSubagentFopUids().clear();
            info.getSubagentFopUids().addAll(data.getSubagentFops().stream().map(item -> item.getUid()).collect(Collectors.toList()));
        }
        if (clientContractRelation != null) {
            if (clientContractRelation.getGeneralData().getMediator() == null) {
                clientContractRelation.getGeneralData().setMediator(data.getMediator());
            }
            clientContractRelation.getCommissions().removeIf(item -> info.getClientCommissionUids().contains(item.getUid()));
            clientContractRelation.getCommissions().addAll(data.getCommissions());
            info.getClientCommissionUids().clear();
            info.getClientCommissionUids().addAll(data.getCommissions().stream().map(item -> item.getUid()).collect(Collectors.toList()));
            clientContractRelation.getFops().removeIf(item -> info.getClientFopUids().contains(item.getUid()));
            clientContractRelation.getFops().addAll(data.getClientFops());
            info.getClientFopUids().clear();
            info.getClientFopUids().addAll(data.getClientFops().stream().map(item -> item.getUid()).collect(Collectors.toList()));
        }
        if (product.getTicketType() != TicketType.FAKE) {
            RailwayProductHelper.updateFops((RailwayProduct)product);
        }
    }
}

