/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.express;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.parsers.BaseExchangeProcessor;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import com.gridnine.xtrip.server.railway.parsers.express.ExpressData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

@Deprecated
public class ExpressExchangeProcessor
extends BaseExchangeProcessor<ExpressExchangeDocument> {
    public static final String EXCHANGE_FILE_ENCODING = "utf8";
    public static final String STORE_ENCODING = "utf8";
    public static final String TOKEN_SEPARATOR = "\n";
    public static final int AGENT_RECORD_STRING_AMOUNT = 1;
    public static final int REFUSE_RECORD_STRING_AMOUNT = 4;
    public static final int COUPON_RECORD_STRING_AMOUNT = 8;
    public static final String BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u0421\u043b\u0438\u043f";
    public static final String MCO_BLANK_TYPE_CODE = "\u0420\u0416\u0414 \u041a\u0420\u0421";
    public static final String INSURANCE_TAX_CODE = "\u0421\u0422\u0420";
    public static final int PNR_DAYS_THRESHOLD = 14;
    public static final int REFUND_HOURS_THRESHOLD = 12;

    protected Class<? extends EntityIndex<ExpressExchangeDocument>> getIndexClass() {
        return ExpressExchangeDocumentIndex.class;
    }

    public String getType() {
        return "EXPRESS";
    }

    public void processExchangeFile(ExpressExchangeDocument document) throws Exception {
        this.log.debug(String.format("processing exchange file %s document", document.getLocation()));
        document.setStatus(ProcessingStatus.UNPROCESSED);
        document.getMessages().clear();
        ObjectFactory<ExpressData> expressDataFactory = new ObjectFactory<ExpressData>(){

            public ExpressData createObject() {
                return new ExpressData();
            }
        };
        this.processExchangeFile(document, expressDataFactory);
    }

    protected void processExchangeFile(ExpressExchangeDocument document, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        String agentCode = document.getCashierCode();
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)document.getTransactionType());
        if (status == ProductStatus.SELL) {
            ExpressData expressData = this.createSellData(new String(document.getContent(), "utf8"), expressDataFactory);
            expressData.setAgentCode(agentCode);
            this.processSellExchangeDocument(document, expressData);
        } else if (status == ProductStatus.REFUND) {
            ExpressData expressData = this.createRefundData(new String(document.getContent(), "utf8"), expressDataFactory);
            expressData.setAgentCode(agentCode);
            this.processRefundExchangeDocument(document, expressData);
        } else if (status == ProductStatus.VOID) {
            ExpressData expressData = this.createVoidData(new String(document.getContent(), "utf8"), expressDataFactory);
            expressData.setAgentCode(agentCode);
            this.processVoidExchangeDocument(document, expressData);
        }
    }

    private void processSellExchangeDocument(ExpressExchangeDocument document, ExpressData expressData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)expressData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)expressData.getPnr()));
            if (expressData.getIssueDate() != null) {
                Date issueDateStart = new Date(expressData.getIssueDate().getTime() - 1209600000L);
                Date issueDateEnd = new Date(expressData.getIssueDate().getTime() + 1209600000L);
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
            }
            List bookingFileIndexes = entityStorage.search(BookingFileIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            if (bookingFileIndexes.size() == 0) {
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.EXPRESS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)expressData.getPnr());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            } else {
                BookingFileIndex index = (BookingFileIndex)bookingFileIndexes.get(0);
                if (bookingFileIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
            }
            RailwayProduct product = new RailwayProduct();
            this.updateProduct(product, expressData, (List<Message>)messages);
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, expressData.getPnr(), (List<Message>)messages);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(expressData.getMessages());
            for (Message message : messages) {
                this.logWarning(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_transactionOnTicket, (Object[])new Object[]{expressData.getTransactionType(), expressData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
            if (railwayProductIndexes.size() > 1) {
                // empty if block
            }
            if ((index.getStatus() == ProductStatus.SELL || index.getStatus() == ProductStatus.VOID) && index.getTicketType() == TicketType.FAKE) {
                EntityContainer bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                RailwayProduct product = null;
                if (index.getStatus() == ProductStatus.SELL) {
                    product = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                    this.updateProduct(product, expressData, (List<Message>)messages);
                    RailwayProduct refundProduct = product.getNextProduct();
                    if (refundProduct != null && refundProduct.getStatus() == ProductStatus.REFUND) {
                        this.synchronizeSellAndRefundData(product, refundProduct);
                    }
                } else if (index.getStatus() == ProductStatus.VOID) {
                    product = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.VOID);
                    this.updateProduct(product, expressData, (List<Message>)messages);
                    product.setStatus(ProductStatus.VOID);
                }
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, expressData.getPnr(), (List<Message>)messages);
                entityStorage.save(bookingFileContainer, true);
                messages.addAll(expressData.getMessages());
                for (Message message : messages) {
                    this.logWarning(message, document.getLocation());
                }
                document.setOwner(bookingFileContainer.toReference());
                document.setRelatedBookingFile(bookingFileContainer.toReference());
                document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
                messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_transactionOnTicket, (Object[])new Object[]{expressData.getTransactionType(), expressData.getSystemNumber()}), (Object[])new Object[0]));
            } else {
                messages.add(MessageHelper.createErrorMessage((String)Messages.ExpressExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_tickerWithNumberExist, (Object[])new Object[]{expressData.getSystemNumber()}), (Object[])new Object[0]));
                document.setStatus(ProcessingStatus.ERROR);
            }
        }
    }

    private void processRefundExchangeDocument(ExpressExchangeDocument document, ExpressData expressData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)expressData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.REFUND), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)expressData.getSystemNumber()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            RailwayProduct sellProduct = null;
            if (railwayProductIndexes.size() > 0) {
                RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
                if (railwayProductIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                sellProduct = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                expressData.setPnr(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)sellProduct.getReservation(), (GdsName)GdsName.EXPRESS, (RecordLocatorType)RecordLocatorType.DEFAULT));
            }
            if (bookingFileContainer == null) {
                if (sellProduct == null) {
                    this.log.info(String.format("Refund ticket's PNR %s would be used for reservation because refund ticket was found before sell ticket", expressData.getPnr()));
                }
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.EXPRESS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)expressData.getPnr());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            }
            RailwayProduct refundProduct = new RailwayProduct();
            this.updateProduct(refundProduct, expressData, (List<Message>)messages);
            if (sellProduct != null) {
                this.synchronizeSellAndRefundData(sellProduct, refundProduct);
            }
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, refundProduct, expressData.getPnr(), (List<Message>)messages);
            RailwayReferenceMCO mcoProduct = new RailwayReferenceMCO();
            this.updateProduct(mcoProduct, expressData, (List<Message>)messages);
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, mcoProduct, expressData.getPnr(), (List<Message>)messages);
            mcoProduct.setRelatedProduct((BaseProduct)refundProduct);
            if (sellProduct == null) {
                sellProduct = new RailwayProduct();
                this.updateFakeSellProduct(sellProduct, expressData, messages);
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, sellProduct, expressData.getPnr(), (List<Message>)messages);
            }
            refundProduct.setPreviousProduct(sellProduct);
            sellProduct.setNextProduct(refundProduct);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(expressData.getMessages());
            for (Message message : messages) {
                this.logWarning(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_transactionOnTicket, (Object[])new Object[]{expressData.getTransactionType(), expressData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            messages.add(MessageHelper.createErrorMessage((String)Messages.ExpressExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_tickerWithNumberExist, (Object[])new Object[]{expressData.getSystemNumber()}), (Object[])new Object[0]));
            document.setStatus(ProcessingStatus.ERROR);
        }
    }

    private void processVoidExchangeDocument(ExpressExchangeDocument document, ExpressData expressData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)expressData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)expressData.getSystemNumber()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            RailwayProduct voidProduct = null;
            if (railwayProductIndexes.size() > 0) {
                RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
                if (railwayProductIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                voidProduct = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                voidProduct.setStatus(ProductStatus.VOID);
            }
            if (bookingFileContainer == null) {
                this.log.info(String.format("Void ticket's PNR %s would be used for reservation because void ticket was found before sell ticket", expressData.getPnr()));
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.EXPRESS, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)expressData.getPnr());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
                voidProduct = new RailwayProduct();
                this.updateFakeVoidProduct(voidProduct, expressData, messages);
            }
            this.updateBookingFile(bookingFileContainer, voidProduct, expressData.getPnr(), (List<Message>)messages);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(expressData.getMessages());
            for (Message message : messages) {
                this.logWarning(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_transactionOnTicket, (Object[])new Object[]{expressData.getTransactionType(), expressData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            messages.add(MessageHelper.createErrorMessage((String)Messages.ExpressExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_tickerWithNumberExist, (Object[])new Object[]{expressData.getSystemNumber()}), (Object[])new Object[0]));
            document.setStatus(ProcessingStatus.ERROR);
        }
    }

    private void synchronizeSellAndRefundData(RailwayProduct sellProduct, RailwayProduct refundProduct) throws Exception {
        int refundProductSegmentNumber;
        for (RailwaySegment sellProductSegment : sellProduct.getSegments()) {
            int sellProductSegmentNumber = sellProductSegment.getNumber();
            for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                int refundProductSegmentNumber2 = refundProductSegment.getNumber();
                if (refundProductSegmentNumber2 != sellProductSegmentNumber) continue;
                refundProductSegment.setDepartureStation(sellProductSegment.getDepartureStation());
                refundProductSegment.setArriveStation(sellProductSegment.getArriveStation());
                refundProductSegment.setDepartureDate(sellProductSegment.getDepartureDate());
                refundProductSegment.setArriveDate(sellProductSegment.getArriveDate());
                refundProductSegment.setFare(sellProductSegment.getFare());
                refundProductSegment.setEquivalentFare(sellProductSegment.getEquivalentFare());
                refundProductSegment.setEquivalentVAT(sellProductSegment.getEquivalentVAT());
            }
        }
        refundProduct.getReservedSeats().clear();
        for (ReservedSeat sellProductReservedSeat : sellProduct.getReservedSeats()) {
            ReservedSeat refundProductReservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)sellProductReservedSeat);
            refundProductReservedSeat.setSegment(null);
            RailwaySegment sellProductReservedSeatSegment = sellProductReservedSeat.getSegment();
            if (sellProductReservedSeatSegment != null) {
                int sellProductReservedSeatSegmentNumber = sellProductReservedSeatSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductReservedSeatSegmentNumber) continue;
                    refundProductReservedSeat.setSegment(refundProductSegment);
                }
            }
            refundProduct.getReservedSeats().add(refundProductReservedSeat);
        }
        refundProduct.getTaxes().clear();
        for (RailwayTax sellProductTax : sellProduct.getTaxes()) {
            RailwayTax refundProductTax = (RailwayTax)XCloneHelper.clone((XCloneable)sellProductTax);
            refundProductTax.setSegment(null);
            RailwaySegment sellProductTaxSegment = sellProductTax.getSegment();
            if (sellProductTaxSegment != null) {
                int sellProductTaxSegmentNumber = sellProductTaxSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductTaxSegmentNumber) continue;
                    refundProductTax.setSegment(refundProductSegment);
                }
            }
            refundProduct.getTaxes().add(refundProductTax);
        }
        refundProduct.setEquivalentFare(sellProduct.getEquivalentFare());
        refundProduct.setEquivalentVAT(sellProduct.getEquivalentVAT());
        refundProduct.setServiceFare(sellProduct.getServiceFare());
        refundProduct.setServiceVAT(sellProduct.getServiceVAT());
        BigDecimal sellTotalEquivalentFare = sellProduct.getTotalEquivalentFare();
        BigDecimal refundTotalEquivalentFare = refundProduct.getTotalEquivalentFare();
        BigDecimal penaltyFare = null;
        if (sellTotalEquivalentFare != null && refundTotalEquivalentFare != null) {
            penaltyFare = sellTotalEquivalentFare.subtract(refundTotalEquivalentFare);
        }
        BigDecimal penaltyVat = null;
        refundProduct.setPenalty(penaltyFare);
        refundProduct.setPenaltyVAT(penaltyVat);
        BigDecimal sellTotalEquivalentVat = sellProduct.getTotalEquivalentVAT();
        BigDecimal refundTotalEquivalentVat = null;
        if (sellTotalEquivalentVat != null) {
            refundTotalEquivalentVat = sellTotalEquivalentVat;
        }
        if (penaltyVat != null) {
            refundTotalEquivalentVat = refundTotalEquivalentVat == null ? penaltyVat.negate() : refundTotalEquivalentVat.subtract(penaltyVat);
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
    }

    private void updateProduct(RailwayProduct product, ExpressData expressData, List<Message> messages) throws Exception {
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)expressData.getTransactionType());
        String systemNumber = expressData.getSystemNumber();
        Date issueDate = expressData.getIssueDate();
        String agentCode = expressData.getAgentCode();
        String pccCode = expressData.getPccCode();
        String blankTypeCode = expressData.getBlankTypeCode();
        String blankOwnerCode = expressData.getBlankOwnerCode();
        TicketType ticketType = expressData.getTicketType();
        String endorsement = expressData.getEndorsement();
        String fareCalculationData = expressData.getFareCalculationData();
        List<Traveller> travellers = expressData.getTravellers();
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        EntityReference blankOwner = null;
        OrganizationIndex blankOwnerIndex = this.findBlankOwner(blankOwnerCode, messages);
        if (blankOwnerIndex != null) {
            blankOwner = blankOwnerIndex.getSource();
        }
        String validatorCode = null;
        EntityReference supplier = null;
        EntityReference agency = null;
        EntityReference subagency = null;
        EntityReference salesPoint = null;
        ValidatorIndex validatorIndex = this.findValidator((EntityReference<Organization>)blankOwner, pccCode, issueDate, messages);
        if (validatorIndex != null) {
            validatorCode = validatorIndex.getNumber();
            supplier = validatorIndex.getSupplier();
            agency = validatorIndex.getAgency();
            subagency = validatorIndex.getSubagency();
            salesPoint = validatorIndex.getSource();
        }
        EntityReference agent = null;
        GdsReferenceIndex gdsReferenceIndex = this.findGdsReference(agentCode, issueDate, messages);
        if (gdsReferenceIndex != null) {
            agent = gdsReferenceIndex.getSource();
        }
        int number = 1;
        DictionaryReference<RailwayStation> departureStation = expressData.getDepartureStation();
        DictionaryReference<RailwayStation> arriveStation = expressData.getArriveStation();
        String trainNumber = expressData.getTrainNumber();
        String slot = expressData.getSlot();
        String carriageNumber = expressData.getCarriageNumber();
        CarriageType carriageType = expressData.getCarriageType();
        CompartmentType compartmentType = expressData.getCompartmentType();
        List<Integer> places = expressData.getPlaces();
        ServiceClass serviceClass = expressData.getServiceClass();
        Date departureDate = expressData.getDepartureDate();
        Date arriveDate = expressData.getArriveDate();
        BigDecimal equivalentSegmentFare = expressData.getSegmentFare();
        Money segmentFare = null;
        if (equivalentSegmentFare != null) {
            segmentFare = new Money();
            segmentFare.setValue(equivalentSegmentFare);
            segmentFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(number);
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.setCompartmentType(compartmentType);
        segment.getPlaces().clear();
        for (Integer place : places) {
            segment.getPlaces().add(String.valueOf(place));
        }
        segment.setServiceClass(serviceClass);
        segment.setDepartureDate(departureDate);
        segment.setArriveDate(arriveDate);
        segment.setFare(segmentFare);
        segment.setEquivalentFare(equivalentSegmentFare);
        ReservedSeat reservedSeat = null;
        BigDecimal reservedSeatEquivalentFare = expressData.getReservedSeatFare();
        if (reservedSeatEquivalentFare != null) {
            reservedSeat = new ReservedSeat();
            reservedSeat.setSegment(segment);
            Money reservedSeatFare = new Money();
            reservedSeatFare.setValue(reservedSeatEquivalentFare);
            reservedSeatFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            reservedSeat.setFare(reservedSeatFare);
            reservedSeat.setEquivalentFare(reservedSeatEquivalentFare);
        }
        RailwayTax insuranceTax = null;
        BigDecimal insuranceTaxEquivalentFare = expressData.getInsuranceTaxFare();
        if (insuranceTaxEquivalentFare != null && insuranceTaxEquivalentFare.compareTo(BigDecimal.ZERO) > 0) {
            insuranceTax = new RailwayTax();
            insuranceTax.setSegment(segment);
            insuranceTax.setCode(INSURANCE_TAX_CODE);
            Money insuranceTaxFare = new Money();
            insuranceTaxFare.setValue(insuranceTaxEquivalentFare);
            insuranceTaxFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            insuranceTax.setFare(insuranceTaxFare);
            insuranceTax.setEquivalentFare(insuranceTaxEquivalentFare);
        }
        BigDecimal tariffFare = expressData.getTariffFare();
        BigDecimal tariffVat = expressData.getTariffVat();
        BigDecimal tariffVatRate = expressData.getTariffVatRate();
        BigDecimal serviceFare = expressData.getServiceFare();
        BigDecimal serviceVat = expressData.getServiceVat();
        BigDecimal serviceVatRate = expressData.getServiceVatRate();
        BigDecimal penalty = expressData.getPenalty();
        BigDecimal penaltyVat = expressData.getPenaltyVat();
        BigDecimal penaltyVatRate = expressData.getPenaltyVatRate();
        BigDecimal totalEquivalentFare = expressData.getTotalFare();
        BigDecimal totalEquivalentVAT = expressData.getTotalVat();
        if (totalEquivalentVAT == null && (tariffVat != null || serviceVat != null || penaltyVat != null)) {
            totalEquivalentVAT = BigDecimal.ZERO;
            if (tariffVat != null) {
                totalEquivalentVAT = totalEquivalentVAT.add(tariffVat);
            }
            if (serviceVat != null) {
                totalEquivalentVAT = totalEquivalentVAT.add(serviceVat);
            }
            if (penaltyVat != null) {
                BigDecimal bigDecimal = totalEquivalentVAT = status == ProductStatus.REFUND ? totalEquivalentVAT.subtract(penaltyVat) : totalEquivalentVAT.add(penaltyVat);
            }
        }
        if (totalEquivalentFare != null) {
            BigDecimal fare = totalEquivalentFare;
            if (insuranceTaxEquivalentFare != null) {
                fare = fare.subtract(insuranceTaxEquivalentFare);
            }
            if (penalty != null) {
                BigDecimal bigDecimal = fare = status == ProductStatus.REFUND ? fare.add(penalty) : fare.subtract(penalty);
            }
            if (serviceFare != null) {
                fare = fare.subtract(serviceFare);
            }
            if (tariffFare != null || fare.compareTo(BigDecimal.ZERO) != 0) {
                tariffFare = fare;
            }
            if (serviceFare == null || serviceFare.compareTo(BigDecimal.ZERO) == 0) {
                fare = totalEquivalentFare;
                if (insuranceTaxEquivalentFare != null) {
                    fare = fare.subtract(insuranceTaxEquivalentFare);
                }
                if (penalty != null) {
                    BigDecimal bigDecimal = fare = status == ProductStatus.REFUND ? fare.add(penalty) : fare.subtract(penalty);
                }
                if (tariffFare != null) {
                    fare = fare.subtract(tariffFare);
                }
                if (serviceFare != null || fare.compareTo(BigDecimal.ZERO) != 0) {
                    serviceFare = fare;
                }
            }
        }
        VatDetalization vendorVatDetalization = new VatDetalization();
        if (tariffVat != null || tariffVatRate != null || serviceVat != null || serviceVatRate != null || penaltyVat != null || penaltyVatRate != null) {
            VatComponent vatComponent;
            vendorVatDetalization.setDetalized(true);
            vendorVatDetalization.getComponents().clear();
            if (tariffVat != null || tariffVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(tariffFare);
                vatComponent.setSum(tariffVat);
                vatComponent.setRate(Double.valueOf(tariffVatRate != null ? tariffVatRate.doubleValue() : 0.0));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (serviceVat != null || serviceVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(serviceFare);
                vatComponent.setSum(serviceVat);
                vatComponent.setRate(Double.valueOf(serviceVatRate != null ? serviceVatRate.doubleValue() : 0.0));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
            if (penaltyVat != null || penaltyVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(penalty);
                vatComponent.setSum(penaltyVat);
                vatComponent.setRate(Double.valueOf(penaltyVatRate != null ? penaltyVatRate.doubleValue() : 0.0));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.PENALTY);
                vendorVatDetalization.getComponents().add(vatComponent);
            }
        }
        TreeMap<PaymentType, ExpressData.FOPDetails> fopDetails = new TreeMap<PaymentType, ExpressData.FOPDetails>(expressData.getFopDetails());
        BigDecimal totalFOPAmount = null;
        for (ExpressData.FOPDetails details : fopDetails.values()) {
            BigDecimal fare = details.getFare();
            if (fare == null) continue;
            totalFOPAmount = totalFOPAmount != null ? totalFOPAmount.add(fare) : fare;
        }
        ArrayList<RailwayProductFop> vendorFOPs = new ArrayList<RailwayProductFop>();
        ArrayList<RailwayProductFop> clientFOPs = new ArrayList<RailwayProductFop>();
        String certificateNumber = expressData.getCertificateNumber();
        for (Map.Entry entry : fopDetails.entrySet()) {
            RailwayProductFop fop;
            Money amount;
            PaymentType paymentType = (PaymentType)entry.getKey();
            ExpressData.FOPDetails details = (ExpressData.FOPDetails)entry.getValue();
            BigDecimal fare = details.getFare();
            PassengerStatus passengerStatus = details.getPassengerStatus();
            if (fare != null && (fare.compareTo(BigDecimal.ZERO) != 0 || vendorFOPs.size() == 0 && (totalFOPAmount == null || totalFOPAmount.compareTo(BigDecimal.ZERO) == 0))) {
                amount = new Money();
                amount.setValue(fare);
                amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
                fop = new RailwayProductFop();
                fop.setType(paymentType);
                fop.setAmount(amount);
                fop.setPassengerStatus(passengerStatus);
                if (paymentType == PaymentType.MTD) {
                    fop.setRelatedTicketNumber(certificateNumber);
                }
                fop.setOperationDate(null);
                fop.setAgent(null);
                vendorFOPs.add(fop);
            }
            if (fare == null || fare.compareTo(BigDecimal.ZERO) == 0 && (clientFOPs.size() != 0 || totalFOPAmount != null && totalFOPAmount.compareTo(BigDecimal.ZERO) != 0)) continue;
            amount = new Money();
            amount.setValue(fare);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop = new RailwayProductFop();
            fop.setType(paymentType);
            fop.setAmount(amount);
            fop.setPassengerStatus(passengerStatus);
            if (paymentType == PaymentType.MTD) {
                fop.setRelatedTicketNumber(certificateNumber);
            }
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        product.setStatus(status);
        product.setSystemNumber(systemNumber);
        product.setIssueDate(issueDate);
        product.setValidatorCode(validatorCode);
        product.setPcc(pccCode);
        product.setEquivalentFare(tariffFare);
        product.setEquivalentVAT(tariffVat);
        product.setServiceFare(serviceFare);
        product.setServiceVAT(serviceVat);
        product.setPenalty(penalty);
        product.setPenaltyVAT(penaltyVat);
        product.setTotalEquivalentFare(totalEquivalentFare);
        product.setTotalEquivalentVAT(totalEquivalentVAT);
        product.setVendorVatDetalization(vendorVatDetalization);
        product.getPassengers().clear();
        product.getPassengers().addAll(travellers);
        product.getPassengerTypes().clear();
        product.setBlankType(blankType);
        product.setBlankOwnerRef(blankOwner);
        product.getSegments().clear();
        product.getSegments().add(segment);
        product.getReservedSeats().clear();
        if (reservedSeat != null) {
            product.getReservedSeats().add(reservedSeat);
        }
        product.getTaxes().clear();
        if (insuranceTax != null) {
            product.getTaxes().add(insuranceTax);
        }
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        clientContractRelation.getFops().clear();
        vendorContractRelation.getFops().clear();
        clientContractRelation.getFops().addAll(clientFOPs);
        vendorContractRelation.getFops().addAll(vendorFOPs);
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)supplier);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
        product.setSalesPoint(salesPoint);
        product.setCashier(agent);
        product.setTicketType(ticketType);
        product.setEndorsement(endorsement);
        product.setFareCalculationData(fareCalculationData);
    }

    private void updateProduct(RailwayReferenceMCO mco, ExpressData expressData, List<Message> messages) throws Exception {
        String systemNumber = expressData.getMcoNumber();
        Date issueDate = expressData.getIssueDate();
        String blankTypeCode = expressData.getMcoBlankTypeCode();
        TicketType ticketType = expressData.getTicketType();
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        ProductStatus productStatus = ProductStatus.SELL;
        mco.setSystemNumber(systemNumber);
        mco.setIssueDate(issueDate);
        mco.setBlankType(blankType);
        mco.setTicketType(ticketType);
        mco.setStatus(productStatus);
    }

    private void updateFakeSellProduct(RailwayProduct product, ExpressData expressData, List<Message> messages) throws Exception {
        String systemNumber = expressData.getSystemNumber();
        product.setSystemNumber(systemNumber);
        product.setStatus(ProductStatus.SELL);
        product.setTicketType(TicketType.FAKE);
    }

    private void updateFakeVoidProduct(RailwayProduct product, ExpressData expressData, List<Message> messages) throws Exception {
        this.updateProduct(product, expressData, messages);
        product.setTicketType(TicketType.FAKE);
    }

    private void updateBookingFile(EntityContainer<BookingFile> bookingFileContainer, RailwayProduct product, String pnr, List<Message> messages) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        boolean updatedProduct = false;
        block0: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(product.getUid())) continue;
                updatedProduct = true;
                continue block0;
            }
        }
        boolean bookingFileContainsNonFakeSellOrVoid = false;
        boolean bookingFileContainsNonFakeRefund = false;
        block2: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL || baseTicketProduct.getStatus() == ProductStatus.VOID) {
                        bookingFileContainsNonFakeSellOrVoid = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        bookingFileContainsNonFakeRefund = true;
                    }
                }
                if (!bookingFileContainsNonFakeSellOrVoid || !bookingFileContainsNonFakeRefund) continue;
                continue block2;
            }
        }
        if (!bookingFileContainsNonFakeSellOrVoid && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.VOID || !bookingFileContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
            bookingFile.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
            bookingFile.setCreateDate(product.getIssueDate());
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)GdsName.EXPRESS)) continue;
            boolean reservationContainsNonFakeSellOrVoid = false;
            boolean reservationContainsNonFakeRefund = false;
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL || baseTicketProduct.getStatus() == ProductStatus.VOID) {
                        reservationContainsNonFakeSellOrVoid = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        reservationContainsNonFakeRefund = true;
                    }
                }
                if (!reservationContainsNonFakeSellOrVoid || !reservationContainsNonFakeRefund) continue;
                break;
            }
            if (!reservationContainsNonFakeSellOrVoid && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.VOID || !reservationContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
                reservation.setBookingAgent(product.getCashier());
                reservation.setSalesPoint(product.getSalesPoint());
                reservation.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
                reservation.setResDate(product.getIssueDate());
            }
            List productTravellers = product.getPassengers();
            List bookingTravellers = bookingFile.getTravellers();
            ArrayList<Traveller> updatedProductTravellers = new ArrayList<Traveller>();
            for (Traveller productTraveller : productTravellers) {
                boolean contains = false;
                for (Traveller bookingTraveller : bookingTravellers) {
                    if (!this.compareTravellers(productTraveller, bookingTraveller)) continue;
                    contains = true;
                    updatedProductTravellers.add(bookingTraveller);
                    break;
                }
                if (contains) continue;
                updatedProductTravellers.add(productTraveller);
                bookingTravellers.add(productTraveller);
            }
            productTravellers.clear();
            productTravellers.addAll(updatedProductTravellers);
            if (updatedProduct) break;
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            break;
        }
    }

    private void updateBookingFile(EntityContainer<BookingFile> bookingFileContainer, RailwayReferenceMCO mco, String pnr, List<Message> messages) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        boolean updatedProduct = false;
        block0: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(mco.getUid())) continue;
                updatedProduct = true;
                continue block0;
            }
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)GdsName.EXPRESS)) continue;
            if (updatedProduct) break;
            mco.setReservation(reservation);
            reservation.getProducts().add(mco);
            break;
        }
    }

    private RailwayProduct getProduct(EntityContainer<BookingFile> bookingFileContainer, String systemNumber, ProductStatus status) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayProduct product;
                if (!(baseProduct instanceof RailwayProduct) || !TextUtil.isSame((String)(product = (RailwayProduct)baseProduct).getSystemNumber(), (String)systemNumber) || product.getStatus() != status) continue;
                return product;
            }
        }
        return null;
    }

    protected boolean compareTravellers(Traveller traveller01, Traveller traveller02) {
        String fullName02;
        String fullName01;
        if (traveller01 == null && traveller02 == null) {
            return true;
        }
        if (traveller01 == null || traveller02 == null) {
            return false;
        }
        if (traveller01.getPassport() != null && traveller02.getPassport() != null) {
            fullName01 = TextUtil.buildFullName((PersonalName)traveller01.getPassport());
            fullName02 = TextUtil.buildFullName((PersonalName)traveller02.getPassport());
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        if (traveller01.getName() != null && traveller02.getName() != null) {
            fullName01 = traveller01.getName();
            fullName02 = traveller02.getName();
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        return false;
    }

    private DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }

    private OrganizationIndex findBlankOwner(String blankOwnerCode, List<Message> messages) throws Exception {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)blankOwnerCode));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        List blankOwnerIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (blankOwnerIndexes.size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineBlankOwner, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_blankOwnerWithCode, (Object[])new Object[]{blankOwnerCode}), (Object[])new Object[0]));
            return null;
        }
        if (blankOwnerIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_blankOwnerMay, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_foundMoreOneBlankOwner, (Object[])new Object[]{blankOwnerCode}), (Object[])new Object[0]));
        }
        return (OrganizationIndex)blankOwnerIndexes.get(0);
    }

    private ValidatorIndex findValidator(EntityReference<Organization> blankOwner, String pccCode, Date date, List<Message> messages) throws Exception {
        List validatorIndexes = ValidatorHelper.getValidatorIndexes(null, blankOwner, (String)pccCode, (Date)date);
        if (validatorIndexes.size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_validatorNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_validatorAppropriateBlankOwner, (Object[])new Object[]{blankOwner, pccCode}), (Object[])new Object[0]));
            return null;
        }
        if (validatorIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_validatorMayDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_foundMoreOneValidator, (Object[])new Object[]{blankOwner, pccCode}), (Object[])new Object[0]));
        }
        return (ValidatorIndex)validatorIndexes.get(0);
    }

    private GdsReferenceIndex findGdsReference(String agentCode, Date date, List<Message> messages) throws Exception {
        List gdsReferenceIndexes;
        if (TextUtil.isBlank((String)agentCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)agentCode));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null)}));
        }
        if ((gdsReferenceIndexes = EntityStorage.get().search(GdsReferenceIndex.class, query).getData()).size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_noAgent, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noAgentWithReference, (Object[])new Object[]{agentCode}), (Object[])new Object[0]));
            return null;
        }
        if (gdsReferenceIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_agentMay, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_foundMoreOneAgent, (Object[])new Object[]{agentCode}), (Object[])new Object[0]));
        }
        return !gdsReferenceIndexes.isEmpty() ? (GdsReferenceIndex)gdsReferenceIndexes.get(0) : null;
    }

    public ExchangeDocumentRegistrationResult registerExchangeFile(final ExchangeFile exchangeFile) throws Exception {
        this.log.debug(String.format("registering exchange file %s", exchangeFile.getLocation()));
        ObjectFactory<ExpressData> expressDataFactory = new ObjectFactory<ExpressData>(){

            public ExpressData createObject() {
                return new ExpressData();
            }
        };
        ObjectFactory<EntityContainer<ExpressExchangeDocument>> expressExchangeDocumentFactory = new ObjectFactory<EntityContainer<ExpressExchangeDocument>>(){

            public EntityContainer<ExpressExchangeDocument> createObject() {
                EntityContainer result = new EntityContainer(ExpressExchangeDocument.class);
                ((ExpressExchangeDocument)result.getEntity()).setType(exchangeFile.getType());
                return result;
            }
        };
        return this.registerExchangeFile(exchangeFile, expressDataFactory, expressExchangeDocumentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile exchangeFile, ObjectFactory<ExpressData> expressDataFactory, ObjectFactory<EntityContainer<ExpressExchangeDocument>> expressExchangeDocumentFactory) throws Exception {
        ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult;
        if (exchangeFile == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        String user = LogicalStorage.get().getUser();
        String location = exchangeFile.getLocation();
        String checkSum = null;
        byte[] content = exchangeFile.getContent();
        if (content == null) {
            this.log.error(String.format("content of file %s is empty", location));
            this.addFakeDocument(expressExchangeDocumentFactory, user, exchangeFile, Messages.ExpressExchangeProcessor_ContentIsEmpty, null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        checkSum = MiscUtil.getCheckSum((byte[])content);
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"checkSum", (Object)checkSum));
        if (entityStorage.search(this.getIndexClass(), query).getData().size() > 0) {
            this.log.error(String.format("file %s is already registered", location));
            this.addFakeDocument(expressExchangeDocumentFactory, user, exchangeFile, Messages.ExpressExchangeProcessor_FileAlreadyRegistered, null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        List<ExpressData> expressDataList = this.createDataList(exchangeFile, expressDataFactory);
        if (expressDataList == null) {
            this.log.error(String.format("no data were extracted from file %s", location));
            return ParsersHelper.createOkRegistrationResult();
        }
        this.log.debug(String.format("data from file %s were extracted succesfully: count: %s", location, expressDataList.size()));
        LogicalSession managedSession = LogicalStorage.get().beginUnitOfWork();
        try {
            for (ExpressData expressData : expressDataList) {
                Date date = new Date(MiscUtil.getTimestamp());
                this.log.debug(String.format("saving exchange file: system number: %s, transaction: %s, issue date: %s, agent code: %s", expressData.getSystemNumber(), expressData.getTransactionType(), expressData.getIssueDate(), expressData.getAgentCode()));
                EntityContainer container = (EntityContainer)expressExchangeDocumentFactory.createObject();
                container.setCreatedBy(user);
                container.setModifiedBy(user);
                container.setCreated(date);
                container.setModified(date);
                ExpressExchangeDocument expressExchangeDocument = (ExpressExchangeDocument)container.getEntity();
                expressExchangeDocument.setCreated(exchangeFile.getCreated());
                expressExchangeDocument.setCheckSum(checkSum);
                expressExchangeDocument.setTitle(location);
                expressExchangeDocument.setLocation(location);
                expressExchangeDocument.setContent(expressData.getContent().getBytes("utf8"));
                expressExchangeDocument.setContentType(ContentType.TEXT);
                expressExchangeDocument.setStatus(expressData.isCorrupted() ? ProcessingStatus.ERROR : ProcessingStatus.UNPROCESSED);
                expressExchangeDocument.getMessages().clear();
                expressExchangeDocument.getMessages().addAll(expressData.getMessages());
                this.updateDocumentData(expressExchangeDocument, expressData);
                EntityStorage.get().save(container, true);
                this.log.debug(String.format("exchange file saved succesfully", new Object[0]));
            }
            LogicalStorage.get().endUnitOfWork(managedSession, true);
            exchangeDocumentRegistrationResult = ParsersHelper.createOkRegistrationResult();
        }
        catch (Throwable throwable) {
            try {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
                throw throwable;
            }
            catch (Exception e) {
                this.log.error(String.format("failed registering file %s", location), (Throwable)e);
                this.addFakeDocument(expressExchangeDocumentFactory, user, exchangeFile, Messages.ExpressExchangeProcessor_errorRegFile, e, new Object[0]);
                return ParsersHelper.createOkRegistrationResult();
            }
        }
        LogicalStorage.get().cancelUnitOfWork(managedSession);
        return exchangeDocumentRegistrationResult;
    }

    private void updateDocumentData(ExpressExchangeDocument index, ExpressData expressData) {
        index.setSystemNumber(expressData.getSystemNumber());
        index.setTransactionType(expressData.getTransactionType());
        index.setIssueDate(expressData.getIssueDate());
        index.setCashierCode(expressData.getAgentCode());
        index.getTravellers().clear();
        for (Traveller traveller : expressData.getTravellers()) {
            index.getTravellers().add(traveller.getName());
        }
    }

    protected List<ExpressData> createDataList(ExchangeFile file, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        ArrayList<ExpressData> expressDataList = new ArrayList<ExpressData>();
        String content = new String(file.getContent(), "utf8");
        this.log.debug(String.format("create data list: content:\n%s", content));
        String[] tokens = content.split(TOKEN_SEPARATOR);
        int startLine = 0;
        int endLine = 0;
        String agentCode = null;
        RecordType recordType = null;
        boolean searchingRecordEnd = false;
        boolean corrupted = false;
        for (int i = 0; i < tokens.length; ++i) {
            int j;
            String token = tokens[i].trim();
            try {
                if (Pattern.compile("^\\d{6}\\s+\\d{4}\\s+\\d{7}\\s+\\d{2}\u041d\\s+").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of agent record found before previous record ends!");
                    }
                    recordType = RecordType.AGENT;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 1;
                } else if (Pattern.compile("(^|\\s+)\u0418\u041d\u041d\\s+\\d{10}$").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = Math.max(i - 1, 0);
                        throw new UnexpectedRecoredEndException("Start of sell or refund or void record found before previous record ends!");
                    }
                    recordType = RecordType.SELL;
                    searchingRecordEnd = true;
                    startLine = Math.max(i - 1, 0);
                    if (i + 1 < tokens.length) {
                        String nextToken = tokens[i + 1].trim();
                        if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                            recordType = RecordType.REFUND;
                            searchingRecordEnd = true;
                            startLine = i;
                        } else if (Pattern.compile("^\u041f\u041e\u0413\u0410\u0428\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                            recordType = RecordType.VOID;
                            searchingRecordEnd = true;
                            startLine = i;
                        } else if (i + 2 < tokens.length) {
                            nextToken = tokens[i + 2].trim();
                            if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                                recordType = RecordType.REFUND;
                                searchingRecordEnd = true;
                                startLine = i;
                            }
                        }
                    }
                } else if (Pattern.compile("^\u041e\u0422\u041a\u0410\u0417\\s+\u041e\u0422\\s+\u0417\u0410\u041a\u0410\u0417\u0410$").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of refuse record found before previous record ends!");
                    }
                    recordType = RecordType.REFUSE;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 4;
                } else if (Pattern.compile("\\s+\\d{4}-\u0422\u0410\u041b\u041e\u041d\\s+").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of coupon record found before previous record ends!");
                    }
                    recordType = RecordType.COUPON;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 8;
                } else if (Pattern.compile("^###\u041a\u0410\u0421\u0421\u0418\u0420\\s*").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Agent code record found before previous record ends!");
                    }
                    searchingRecordEnd = false;
                    String[] values = token.split("\\s+");
                    agentCode = null;
                    if (values.length > 1) {
                        for (j = 1; j < values.length; ++j) {
                            agentCode = agentCode != null ? agentCode + " " + values[j].trim() : values[j].trim();
                        }
                    }
                } else if (searchingRecordEnd && (recordType == RecordType.SELL || recordType == RecordType.REFUND) && Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(token).find()) {
                    endLine = i + 1;
                } else if (searchingRecordEnd && (recordType == RecordType.REFUND || recordType == RecordType.VOID) && Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(token).find()) {
                    if (recordType == RecordType.REFUND) {
                        if (i + 2 == tokens.length || i + 2 < tokens.length && !Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(tokens[i + 2].trim()).find()) {
                            endLine = i + 2;
                        }
                    } else if (recordType == RecordType.VOID) {
                        endLine = i + 2;
                    }
                }
            }
            catch (UnexpectedRecoredEndException e) {
                this.log.error("", (Throwable)e);
                corrupted = true;
                i = endLine - 1;
            }
            if (!searchingRecordEnd || i != endLine - 1) continue;
            searchingRecordEnd = false;
            StringBuilder record = new StringBuilder();
            for (j = startLine; j < endLine; ++j) {
                if (record.length() > 0) {
                    record.append(TOKEN_SEPARATOR);
                }
                record.append(tokens[j]);
            }
            ExpressData expressData = this.createData(record.toString(), recordType, corrupted, expressDataFactory);
            if (expressData != null) {
                expressData.setAgentCode(agentCode);
                expressDataList.add(expressData);
            }
            corrupted = false;
        }
        return expressDataList;
    }

    protected ExpressData createData(String content, RecordType recordType, boolean corrupted, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        if (recordType != RecordType.AGENT) {
            if (recordType == RecordType.SELL) {
                return corrupted ? this.createCorruptedData(content, TransactionType.SELL, expressDataFactory) : this.createSellData(content, expressDataFactory);
            }
            if (recordType == RecordType.REFUND) {
                return corrupted ? this.createCorruptedData(content, TransactionType.REFUND, expressDataFactory) : this.createRefundData(content, expressDataFactory);
            }
            if (recordType == RecordType.VOID) {
                return corrupted ? this.createCorruptedData(content, TransactionType.CANCEL, expressDataFactory) : this.createVoidData(content, expressDataFactory);
            }
            if (recordType == RecordType.REFUSE || recordType == RecordType.COUPON) {
                // empty if block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected ExpressData createSellData(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        HashSet<Message> messages;
        ExpressData expressData = null;
        if (content != null) {
            void var14_42;
            int j;
            String[] entries;
            int index;
            void var14_40;
            String[] entries2;
            String[] values;
            void var14_24;
            String[] entries3;
            BigDecimal segmentEquivalentFare;
            CarriageType carriageType;
            String carriageNumber;
            Date departureDate;
            String slot;
            String trainNumber;
            String token;
            int tokenIndex;
            String[] tokens;
            block169: {
                messages = new HashSet<Message>();
                expressData = (ExpressData)expressDataFactory.createObject();
                tokens = content.split(TOKEN_SEPARATOR);
                tokenIndex = 2;
                token = tokens[tokenIndex].trim();
                trainNumber = null;
                slot = null;
                departureDate = null;
                carriageNumber = null;
                carriageType = null;
                segmentEquivalentFare = null;
                Object var14_22 = null;
                entries3 = token.split("\\s+");
                if (entries3.length > 0) {
                    String trainNumberString = entries3[0].trim();
                    try {
                        trainNumber = String.valueOf(Integer.valueOf(trainNumberString));
                    }
                    catch (NumberFormatException e) {
                        trainNumber = trainNumberString;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries3.length > 1) {
                    slot = entries3[1].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSlot, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSlot, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries3.length > 3) {
                    try {
                        String departureDateString = String.format("%s.%s.%s", Calendar.getInstance().get(1), entries3[2].trim(), entries3[3].trim());
                        if (entries3[3].contains(":")) {
                            departureDate = new SimpleDateFormat("yyyy.dd.MM.HH:mm").parse(departureDateString);
                            break block169;
                        }
                        departureDate = new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(departureDateString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (entries3.length > 4) {
                String carriageNumberString = entries3[4].trim();
                try {
                    carriageNumber = String.valueOf(Integer.valueOf(carriageNumberString));
                }
                catch (NumberFormatException e) {
                    carriageNumber = carriageNumberString;
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 5) {
                String carriageTypeCode = entries3[5].trim();
                if (!TextUtil.isBlank((String)carriageTypeCode)) {
                    carriageType = this.getCarriageType(carriageTypeCode);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_CarriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_CarriageTypeCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 6) {
                try {
                    segmentEquivalentFare = new BigDecimal(entries3[6].trim());
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_ticketPriceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_priceValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketPrice, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketPrice, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 7) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(entries3[7].trim());
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_reservedSeatPriceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_priceValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineReservedSeatPrice, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataReservedSeatPrice, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setTrainNumber(trainNumber);
            expressData.setSlot(slot);
            expressData.setDepartureDate(departureDate);
            expressData.setCarriageNumber(carriageNumber);
            expressData.setCarriageType(carriageType);
            expressData.setSegmentFare(segmentEquivalentFare);
            expressData.setReservedSeatFare((BigDecimal)var14_24);
            token = tokens[++tokenIndex].trim();
            RailwayStationReference departureStation = null;
            RailwayStationReference arriveStation = null;
            ServiceClass serviceClass = null;
            String[] entries4 = token.split("[()]");
            if (entries4.length > 1) {
                Iterator iterator;
                String routeString = entries4[1].trim();
                String[] values2 = routeString.split("-");
                if (values2.length > 0) {
                    RailwayStation departureLocation;
                    String string = values2[0].trim();
                    Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (departureLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_departureStationMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = departureLocation = (iterator = departureLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (departureLocation != null) {
                        departureStation = departureLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDepartureStation, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values2.length > 1) {
                    RailwayStation arriveLocation;
                    String string = values2[1].trim();
                    Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (arriveLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationMay, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = arriveLocation = (iterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (arriveLocation != null) {
                        arriveStation = arriveLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDestination, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDD, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStations, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries4.length > 2) {
                values = entries4[2].trim().split("\\s+");
                String serviceClassString = null;
                for (String value : values) {
                    if (Pattern.compile("^\u041a\u041b\\.\u041e\u0411\u0421\u041b\\.\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                        serviceClassString = value.substring(8);
                        break;
                    }
                    if (!Pattern.compile("^\\d{1}\\D{1}$").matcher(value.trim()).find()) continue;
                    serviceClassString = value;
                    break;
                }
                if (serviceClassString != null) {
                    serviceClass = this.getServiceClass(serviceClassString);
                    if (serviceClass == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_classServiceNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_classServiceCodeNotSupported, (Object[])new Object[]{serviceClassString}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
            expressData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
            expressData.setServiceClass(serviceClass);
            token = tokens[++tokenIndex].trim();
            ArrayList<Integer> places = new ArrayList<Integer>();
            CompartmentType compartmentType = null;
            String[] entries5 = token.split("\\s+");
            int entryIndexOffset = 0;
            if (entries5.length > 1) {
                if (Pattern.compile("^\u0411\u0415\u0417$").matcher(entries5[0].trim()).find() && Pattern.compile("^\u041c\u0415\u0421\u0422$").matcher(entries5[1].trim()).find()) {
                    messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_noPlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_ticketNoPlace, (Object[])new Object[0]), (Object[])new Object[0]));
                    entryIndexOffset = 1;
                } else if (Pattern.compile("^\\d+-\\d+$").matcher(entries5[1].trim()).find()) {
                    void var14_33;
                    values = entries5[1].trim().split("-");
                    Object startPlace = null;
                    Object var14_31 = null;
                    try {
                        startPlace = Integer.valueOf(values[0].trim());
                        Integer n = Integer.valueOf(values[1].trim());
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (startPlace != null && var14_33 != null && (Integer)startPlace <= var14_33.intValue()) {
                        for (int j2 = ((Integer)startPlace).intValue(); j2 <= var14_33.intValue(); ++j2) {
                            places.add(j2);
                        }
                    }
                } else {
                    values = entries5[1].trim().split(";");
                    for (String value : values) {
                        Integer place = null;
                        try {
                            place = Integer.valueOf(value.trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (place == null) continue;
                        places.add(place);
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPlaceNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries5.length > 2 + entryIndexOffset) {
                compartmentType = Pattern.compile("^/\u041c\u0423\u0416\u0421\u041a\u041e\u0415$").matcher(entries5[2 + entryIndexOffset].trim()).find() ? CompartmentType.MEN : (Pattern.compile("^/\u0416\u0415\u041d\u0421\u041a\u041e\u0415$").matcher(entries5[2 + entryIndexOffset].trim()).find() ? CompartmentType.WOMEN : CompartmentType.COMMON);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCoupe, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTypeCoupe, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.getPlaces().clear();
            expressData.getPlaces().addAll(places);
            expressData.setCompartmentType(compartmentType);
            token = tokens[++tokenIndex].trim();
            String systemNumber = null;
            String pnr = null;
            Date issueDate = null;
            String pccCode = null;
            StringBuilder stringBulder = new StringBuilder();
            stringBulder.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String string = tokens[i];
                if (Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(string.trim()).find()) break;
                stringBulder.append(string);
                ++tokenIndex;
            }
            if ((entries2 = (token = stringBulder.toString().trim()).split("[\\s/]+")).length > 0) {
                systemNumber = entries2[0].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 3) {
                pnr = entries2[3].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePNR, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPNR, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 5) {
                try {
                    String string = String.format("%s.%s", entries2[4].trim(), entries2[5].trim());
                    issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(string);
                    Date departureDate2 = expressData.getDepartureDate();
                    if (departureDate2 != null) {
                        Calendar departureCalendar = Calendar.getInstance();
                        Calendar issueCalendar = Calendar.getInstance();
                        departureCalendar.setTime(departureDate2);
                        issueCalendar.setTime(issueDate);
                        departureCalendar.set(1, issueCalendar.get(1));
                        if (issueDate.after(departureDate2)) {
                            departureCalendar.add(1, 1);
                        }
                        departureDate2 = departureCalendar.getTime();
                        expressData.setDepartureDate(departureDate2);
                    }
                }
                catch (ParseException parseException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateOpNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateOp, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateOp, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 6) {
                String string = entries2[6].trim();
                if (string.length() > 2) {
                    pccCode = string.substring(2);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setSystemNumber(systemNumber);
            expressData.setPnr(pnr);
            expressData.setIssueDate(issueDate);
            expressData.setPccCode(pccCode);
            token = tokens[++tokenIndex].trim();
            ArrayList<String[]> travellers = new ArrayList<String[]>();
            String[] entries6 = token.split("[/]");
            String certificateNumber = null;
            Date certificateIssueDate = null;
            int startEntry = 0;
            int endEntry = 0;
            boolean bl = false;
            while (var14_40 < entries6.length) {
                if (!Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410).*$").matcher(entries6[var14_40].trim()).find() && Pattern.compile("^((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+$").matcher(entries6[var14_40].trim()).find() && var14_40 + true < entries6.length) {
                    String genderCode;
                    int entryIndexOffset2;
                    PassportType passportType = null;
                    String passportNumber = null;
                    String lastName = null;
                    String firstName = null;
                    String middleName = null;
                    Date birthday = null;
                    CountryReference citizenship = null;
                    Gender gender = null;
                    startEntry = endEntry;
                    endEntry = var14_40 + 2;
                    ++var14_40;
                    if (endEntry - startEntry == 4) {
                        certificateNumber = entries6[startEntry].trim();
                        String certificateDateString = entries6[startEntry + 1].trim();
                        certificateIssueDate = new SimpleDateFormat("ddMMyy").parse(certificateDateString);
                    }
                    if (entries6.length > (entryIndexOffset2 = Math.max(startEntry, endEntry - 2))) {
                        String passportString = entries6[entryIndexOffset2].trim();
                        if (passportString.length() > 1) {
                            String passportTypeCode = passportString.substring(0, 2);
                            passportType = this.getPassportType(passportTypeCode);
                            if (passportType == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_passportTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (passportString.length() > 2) {
                            passportNumber = passportString.substring(2);
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportData, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassport, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (entries6.length > entryIndexOffset2 + 1) {
                        String nameString = entries6[entryIndexOffset2 + 1].trim();
                        String[] values3 = nameString.split("[=]");
                        if (values3.length > 0) {
                            lastName = values3[0].trim().replaceAll("[\\d-]", "");
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSurname, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSurname, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (values3.length > 1) {
                            String firstNameString = values3[1].trim();
                            if (firstNameString.length() == 2 && values3.length == 2) {
                                String string = firstNameString.replaceAll("[\\d-]", "");
                                if (string.length() > 0) {
                                    firstName = string.substring(0, 1);
                                    middleName = string.substring(1);
                                }
                            } else {
                                firstName = firstNameString.replaceAll("[\\d-]", "");
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineName, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataName, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (middleName == null) {
                            if (values3.length > 2) {
                                middleName = values3[2].trim().replaceAll("[\\d-]", "");
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineMiddlename, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataMiddlename, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 2 && Pattern.compile("^\\d{8}$").matcher(entries6[entryIndexOffset2 + 2].trim()).find()) {
                        String birthdayString = entries6[entryIndexOffset2 + 2].trim();
                        try {
                            birthday = new SimpleDateFormat("ddMMyyyy").parse(birthdayString);
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_birthdayNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 3 && Pattern.compile("^\\w{3}$").matcher(entries6[entryIndexOffset2 + 3].trim()).find()) {
                        Iterator iterator;
                        Country country;
                        String citizenshipCodeString = entries6[entryIndexOffset2 + 3].trim();
                        Set citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO.name()});
                        if (citizenships.isEmpty()) {
                            citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                        }
                        if (citizenships.size() > 1) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_moreOneCountryFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                        Country country2 = country = (iterator = citizenships.iterator()).hasNext() ? (Country)iterator.next() : null;
                        if (country != null) {
                            citizenship = country.toReference();
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryNotFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 4 && Pattern.compile("^((\u041c)|(M)|(\u0416)|(F))$").matcher(entries6[entryIndexOffset2 + 4].trim()).find() && (gender = this.getGender(genderCode = entries6[entryIndexOffset2 + 4].trim())) == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_genderNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                    }
                    if (passportType != null || passportNumber != null || lastName != null || firstName != null || middleName != null || birthday != null || citizenship != null || gender != null) {
                        String[] traveller = new Traveller();
                        Passport passport = new Passport();
                        passport.setType(passportType);
                        passport.setNumber(passportNumber);
                        passport.setLastName(lastName);
                        passport.setFirstName(firstName);
                        passport.setMiddleName(middleName);
                        passport.setBirthday(birthday);
                        passport.setCitizenship(citizenship);
                        passport.setGender(gender);
                        String fullName = TextUtil.buildFullName((PersonalName)passport);
                        traveller.setName(fullName);
                        traveller.setCyrillicName(TextUtil.translit((String)fullName, (boolean)false));
                        traveller.setBirthday(birthday);
                        traveller.setGender(gender);
                        traveller.setPassport(passport);
                        travellers.add(traveller);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassenger, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassenger, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                ++var14_40;
            }
            expressData.setCertificateNumber(certificateNumber);
            expressData.setCertificateIssueDate(certificateIssueDate);
            expressData.getTravellers().clear();
            expressData.getTravellers().addAll(travellers);
            token = tokens[++tokenIndex].trim();
            HashMap<PaymentType, ExpressData.FOPDetails> fopDetails = new HashMap<PaymentType, ExpressData.FOPDetails>();
            BigDecimal totalFare = null;
            BigDecimal totalVat = null;
            BigDecimal insuranceTaxFare = null;
            BigDecimal tariffFare = null;
            BigDecimal tariffVat = null;
            Object var14_41 = null;
            BigDecimal serviceFare = null;
            BigDecimal serviceVat = null;
            BigDecimal serviceVatRate = null;
            String fareCalculationData = null;
            Date arriveDate = null;
            StringBuilder stringBulder2 = new StringBuilder();
            stringBulder2.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(nextToken.trim()).find()) break;
                stringBulder2.append(nextToken);
                ++tokenIndex;
            }
            if ((index = (token = stringBulder2.toString().trim()).indexOf("\u0412\u0420\u0415\u041c\u042f")) != -1) {
                token = token.substring(0, index).trim();
            }
            String arrive = null;
            index = token.indexOf("\u041f\u0420\u0418\u0411\u042b\u0422\u0418\u0415");
            if (index != -1) {
                arrive = token.substring(index).trim();
                token = token.substring(0, index).trim();
            }
            fareCalculationData = token;
            for (Traveller traveller : entries = token.split("[\\s();]+")) {
                if (!Pattern.compile("^((\u041d)|(\u04121)|(\u04123)|(\u04125)|(\u04127)|(\u041213))\\-.+$").matcher(traveller.trim()).find()) continue;
                String[] values4 = traveller.trim().split("-");
                PaymentType paymentType = PaymentType.CASH;
                PassengerStatus passengerStatus = null;
                BigDecimal fare = null;
                if (values4.length > 0) {
                    String paymentTypeCode = values4[0];
                    if (!TextUtil.isBlank((String)paymentTypeCode)) {
                        paymentType = this.getPaymentType(paymentTypeCode);
                        passengerStatus = this.getPassengerStatus(paymentTypeCode);
                        if (paymentType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentNoSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDatePaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDatePaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values4.length > 1) {
                    try {
                        fare = new BigDecimal(values4[1]);
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (paymentType == null || fare == null) continue;
                ExpressData.FOPDetails details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                if (details == null) {
                    details = new ExpressData.FOPDetails();
                    fopDetails.put(paymentType, details);
                }
                details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                details.setPassengerStatus(passengerStatus);
                totalFare = totalFare != null ? totalFare.add(fare) : fare;
            }
            boolean tariffVatEntryFound = false;
            boolean serviceVatEntryFound = false;
            for (j = 0; j < entries.length; ++j) {
                if (Pattern.compile("^\u0422\\.\u0427\\.\u0421\u0422\u0420\\.").matcher(entries[j].trim()).find()) {
                    String[] stringArray = entries[j].trim().split(";");
                    String insuranceTaxFareString = stringArray[0];
                    if (insuranceTaxFareString.length() <= 8) continue;
                    try {
                        insuranceTaxFare = new BigDecimal(insuranceTaxFareString.substring(8));
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSumInsurance, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueSumInsurance, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    continue;
                }
                if (Pattern.compile("^\u041d\u0414\u0421$").matcher(entries[j].trim()).find() && !tariffVatEntryFound && !serviceVatEntryFound) {
                    if (j + 1 >= entries.length) continue;
                    if (Pattern.compile("^\\d+%$").matcher(entries[j + 1].trim()).find()) {
                        void var27_94;
                        void var27_91;
                        Object var27_89 = null;
                        try {
                            BigDecimal bigDecimal = new BigDecimal(entries[j + 1].trim().replaceAll("%", ""));
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_tariffVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        BigDecimal vat = null;
                        if (j + 2 < entries.length) {
                            try {
                                vat = new BigDecimal(entries[j + 2].trim());
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_tariffVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                        if (var27_91 == null || BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)expressData.getIssueDate())).compareTo((BigDecimal)var27_91) == 0) {
                            tariffVatEntryFound = true;
                            void var14_43 = var27_91;
                            tariffVat = vat;
                        } else {
                            serviceVatEntryFound = true;
                            serviceVatRate = var27_91;
                            serviceVat = vat;
                        }
                        if (j + 4 >= entries.length || !Pattern.compile("^\\d+%$").matcher(entries[j + 4].trim()).find()) continue;
                        Object var27_92 = null;
                        try {
                            BigDecimal bigDecimal = new BigDecimal(entries[j + 4].trim().replaceAll("%", ""));
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_serviceVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        vat = null;
                        if (j + 5 < entries.length) {
                            try {
                                vat = new BigDecimal(entries[j + 5].trim());
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_serviceVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                        if (tariffVatEntryFound) {
                            serviceVatEntryFound = true;
                            serviceVatRate = var27_94;
                            serviceVat = vat;
                            continue;
                        }
                        tariffVatEntryFound = true;
                        void var14_44 = var27_94;
                        tariffVat = vat;
                        continue;
                    }
                    try {
                        totalVat = new BigDecimal(entries[j + 1].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_noNds, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_taxValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    continue;
                }
                if (j + 1 < entries.length && Pattern.compile("^\u0412$").matcher(entries[j].trim()).find() && Pattern.compile("^\u0422\\.\u0427\\.\u041d\u0414\u0421$").matcher(entries[j + 1].trim()).find() && !tariffVatEntryFound && !serviceVatEntryFound) {
                    if (j + 2 >= entries.length) continue;
                    try {
                        totalVat = new BigDecimal(entries[j + 2].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_noNds, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_taxValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    continue;
                }
                if (j + 1 < entries.length && Pattern.compile("^\u0422\u0410\u0420\u0418\u0424$").matcher(entries[j].trim()).find() && Pattern.compile("^\u0420\u0424(\\+\u041a\u0421\u0411)*$").matcher(entries[j + 1].trim()).find()) {
                    if (j + 2 < entries.length) {
                        try {
                            tariffFare = new BigDecimal(entries[j + 2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_sumRateRF, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueSumRateRf, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                    if (j + 4 >= entries.length || !Pattern.compile("^\u0412$").matcher(entries[j + 3].trim()).find() || !Pattern.compile("^\u0422\\.\u0427\\.\u041d\u0414\u0421$").matcher(entries[j + 4].trim()).find()) continue;
                    tariffVatEntryFound = true;
                    if (j + 5 >= entries.length) continue;
                    try {
                        tariffVat = new BigDecimal(entries[j + 5].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_taxValueRateNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_taxValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    continue;
                }
                if (!Pattern.compile("^\u0421\u0415\u0420\u0412\u0418\u0421$").matcher(entries[j].trim()).find()) continue;
                if (j + 1 < entries.length) {
                    try {
                        serviceFare = new BigDecimal(entries[j + 1].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_sumServiceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueSumSeviceNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                if (j + 3 >= entries.length || !Pattern.compile("^\u0412$").matcher(entries[j + 2].trim()).find() || !Pattern.compile("^\u0422\\.\u0427\\.\u041d\u0414\u0421$").matcher(entries[j + 3].trim()).find()) continue;
                serviceVatEntryFound = true;
                if (j + 4 >= entries.length) continue;
                try {
                    serviceVat = new BigDecimal(entries[j + 4].trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_taxValueServiceNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_taxValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (arrive != null) {
                entries = arrive.split("\\s+");
                for (j = 0; j < entries.length; ++j) {
                    String string = entries[j].trim();
                    if (!Pattern.compile("^\u0412$").matcher(string).find()) continue;
                    if (j - 1 >= 0 && j + 1 < entries.length) {
                        try {
                            String arriveDateString = String.format("%s.%s.%s", Calendar.getInstance().get(1), entries[j - 1].trim(), entries[j + 1].trim());
                            arriveDate = entries[j + 1].contains(":") ? new SimpleDateFormat("yyyy.dd.MM.HH:mm").parse(arriveDateString) : new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(arriveDateString);
                            Date departureDate3 = expressData.getDepartureDate();
                            if (departureDate3 == null) break;
                            Calendar departureCalendar = Calendar.getInstance();
                            Calendar arriveCalendar = Calendar.getInstance();
                            departureCalendar.setTime(departureDate3);
                            arriveCalendar.setTime(arriveDate);
                            arriveCalendar.set(1, departureCalendar.get(1));
                            if (departureDate3.after(arriveDate)) {
                                arriveCalendar.add(1, 1);
                            }
                            arriveDate = arriveCalendar.getTime();
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateArrivalNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        break;
                    }
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateArrival, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataArrival, (Object[])new Object[0]), (Object[])new Object[0]));
                    break;
                }
            }
            if (tariffFare == null || serviceFare == null) {
                if (tariffVat != null && var14_42 != null && var14_42.compareTo(BigDecimal.ZERO) != 0) {
                    tariffFare = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(tariffVat.doubleValue() * ((100.0 + var14_42.doubleValue()) / var14_42.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                }
                if (serviceVat != null && serviceVatRate != null && serviceVatRate.compareTo(BigDecimal.ZERO) != 0) {
                    serviceFare = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVat.doubleValue() * ((100.0 + serviceVatRate.doubleValue()) / serviceVatRate.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
                }
            }
            expressData.setTotalFare(totalFare);
            expressData.setTotalVat(totalVat);
            expressData.getFopDetails().clear();
            expressData.getFopDetails().putAll(fopDetails);
            expressData.setInsuranceTaxFare(insuranceTaxFare);
            expressData.setTariffFare(tariffFare);
            expressData.setTariffVat(tariffVat);
            expressData.setTariffVatRate((BigDecimal)var14_42);
            expressData.setServiceFare(serviceFare);
            expressData.setServiceVat(serviceVat);
            expressData.setServiceVatRate(serviceVatRate);
            expressData.setArriveDate(arriveDate);
            expressData.setFareCalculationData(fareCalculationData);
            token = tokens[++tokenIndex].trim();
            String endorsement = null;
            endorsement = token;
            expressData.setEndorsement(endorsement);
            ++tokenIndex;
        } else {
            throw new Exception("Corrupted record!");
        }
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        TransactionType transactionType = TransactionType.SELL;
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    protected ExpressData createRefundData(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        ExpressData expressData = null;
        if (content != null) {
            String[] tokens = content.split(TOKEN_SEPARATOR);
            boolean old = false;
            for (String token : tokens) {
                if (!Pattern.compile("^.+\\s+D\\d{2}\\.\\d{2}\\s+\u0412\u0420\u0415\u041c\u042f((\\d{4})|(-\\d{3,4}))\\s+.+$").matcher(token.trim()).find()) continue;
                old = true;
                break;
            }
            expressData = old ? this.createRefundDataOldFormat(content, expressDataFactory) : this.createRefundDataNewFormat(content, expressDataFactory);
        } else {
            throw new Exception("Corrupted record!");
        }
        return expressData;
    }

    protected ExpressData createRefundDataOldFormat(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        HashSet<Message> messages;
        ExpressData expressData = null;
        if (content != null) {
            int index;
            String[] entries;
            messages = new HashSet<Message>();
            expressData = (ExpressData)expressDataFactory.createObject();
            String[] tokens = content.split(TOKEN_SEPARATOR);
            int tokenIndex = 1;
            String token = tokens[tokenIndex].trim();
            HashMap<PaymentType, ExpressData.FOPDetails> fopDetails = new HashMap<PaymentType, ExpressData.FOPDetails>();
            BigDecimal totalFare = null;
            String[] entries2 = token.split("\\s+");
            for (int i = 0; i < entries2.length; ++i) {
                ExpressData.FOPDetails details;
                String paymentTypeCode;
                BigDecimal fare;
                PassengerStatus passengerStatus;
                PaymentType paymentType;
                String[] values;
                if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e$").matcher(entries2[i].trim()).find()) {
                    if (i + 1 >= entries2.length) continue;
                    values = entries2[i + 1].trim().split("-");
                    paymentType = PaymentType.CASH;
                    passengerStatus = null;
                    fare = null;
                    if (values.length > 0) {
                        paymentTypeCode = values[0];
                        if (!TextUtil.isBlank((String)paymentTypeCode)) {
                            paymentType = this.getPaymentType(paymentTypeCode);
                            passengerStatus = this.getPassengerStatus(paymentTypeCode);
                            if (paymentType == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (values.length > 1) {
                        try {
                            fare = new BigDecimal(values[1]);
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (paymentType == null || fare == null) continue;
                    details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                    if (details == null) {
                        details = new ExpressData.FOPDetails();
                        fopDetails.put(paymentType, details);
                    }
                    details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                    details.setPassengerStatus(passengerStatus);
                    totalFare = totalFare != null ? totalFare.add(fare) : fare;
                    continue;
                }
                if (!Pattern.compile("^\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u041e$").matcher(entries2[i].trim()).find() || i + 1 >= entries2.length) continue;
                values = entries2[i + 1].trim().split("-");
                paymentType = PaymentType.CASH;
                passengerStatus = null;
                fare = null;
                if (values.length > 0) {
                    paymentTypeCode = values[0];
                    if (!TextUtil.isBlank((String)paymentTypeCode)) {
                        paymentType = this.getPaymentType(paymentTypeCode);
                        passengerStatus = this.getPassengerStatus(paymentTypeCode);
                        if (paymentType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values.length > 1) {
                    try {
                        fare = new BigDecimal(values[1]).negate();
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (paymentType == null || fare == null) continue;
                details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                if (details == null) {
                    details = new ExpressData.FOPDetails();
                    fopDetails.put(paymentType, details);
                }
                details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                details.setPassengerStatus(passengerStatus);
                totalFare = totalFare != null ? totalFare.add(fare) : fare;
            }
            expressData.getFopDetails().clear();
            expressData.getFopDetails().putAll(fopDetails);
            expressData.setSegmentFare(totalFare);
            expressData.setTotalFare(totalFare);
            token = tokens[++tokenIndex].trim();
            String trainNumber = null;
            String slot = null;
            Date departureDate = null;
            String carriageNumber = null;
            String[] carriageType = null;
            String[] entries3 = token.split("\\s+");
            if (entries3.length > 0) {
                String trainNumberString = entries3[0].trim();
                if (trainNumberString.length() > 1) {
                    trainNumberString = trainNumberString.substring(1);
                    try {
                        trainNumber = String.valueOf(Integer.valueOf(trainNumberString));
                    }
                    catch (NumberFormatException e) {
                        trainNumber = trainNumberString;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 1) {
                slot = entries3[1].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSlot, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSlot, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 4) {
                String carriageNumberString = entries3[4].trim();
                if (carriageNumberString.length() > 3) {
                    carriageNumberString = carriageNumberString.substring(3);
                    try {
                        carriageNumber = String.valueOf(Integer.valueOf(carriageNumberString));
                    }
                    catch (NumberFormatException e) {
                        carriageNumber = carriageNumberString;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 5) {
                String carriageTypeCode = entries3[5].trim();
                if (!TextUtil.isBlank((String)carriageTypeCode)) {
                    carriageType = this.getCarriageType(carriageTypeCode);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_CarriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_CarriageTypeCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setTrainNumber(trainNumber);
            expressData.setSlot(slot);
            expressData.setDepartureDate(departureDate);
            expressData.setCarriageNumber(carriageNumber);
            expressData.setCarriageType((CarriageType)carriageType);
            ++tokenIndex;
            token = tokens[++tokenIndex].trim();
            ArrayList<Integer> places = new ArrayList<Integer>();
            ServiceClass serviceClass = null;
            entries2 = token.split("\\s+");
            if (entries2.length > 0) {
                String[] values;
                for (String value : values = entries2[0].trim().split(";")) {
                    Integer place = null;
                    try {
                        place = Integer.valueOf(value.trim());
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (place == null) continue;
                    places.add(place);
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPlaceNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 1) {
                String serviceClassString = entries2[entries2.length - 1].trim();
                if (serviceClassString.length() > 8) {
                    String serviceClassCode = serviceClassString.substring(8);
                    if (!TextUtil.isBlank((String)serviceClassCode)) {
                        serviceClass = this.getServiceClass(serviceClassCode);
                        if (serviceClass == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_classServiceNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_classServiceCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.getPlaces().clear();
            expressData.getPlaces().addAll(places);
            expressData.setServiceClass(serviceClass);
            token = tokens[++tokenIndex].trim();
            String mcoNumber = null;
            String pnr = null;
            Date issueDate = null;
            String pccCode = null;
            String systemNumber = null;
            StringBuilder stringBulder = new StringBuilder();
            stringBulder.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(nextToken.trim()).find()) break;
                stringBulder.append(nextToken);
                ++tokenIndex;
            }
            if ((entries = (token = stringBulder.toString().trim()).split("[()]")).length > 0) {
                String[] values = entries[0].trim().split("[\\s/]+");
                if (values.length > 0) {
                    mcoNumber = values[0].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineNumberKRS, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataNumberKRS, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values.length > 3) {
                    pnr = values[3].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePNR, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPNR, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values.length > 5) {
                    try {
                        String issueDateString = String.format("%s.%s", values[4].trim(), values[5].trim());
                        issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(issueDateString);
                        Date departureDate2 = expressData.getDepartureDate();
                        if (departureDate2 != null) {
                            long differenceInHours;
                            Calendar departureCalendar = Calendar.getInstance();
                            Calendar issueCalendar = Calendar.getInstance();
                            departureCalendar.setTime(departureDate2);
                            issueCalendar.setTime(issueDate);
                            departureCalendar.set(1, issueCalendar.get(1));
                            if (departureCalendar.get(2) == 11 && departureCalendar.get(5) == 31 && issueCalendar.get(2) == 0 && issueCalendar.get(5) == 1) {
                                departureCalendar.add(1, -1);
                            }
                            if (issueDate.after(departureDate2 = departureCalendar.getTime()) && (differenceInHours = (issueCalendar.getTimeInMillis() - departureCalendar.getTimeInMillis()) / 3600000L) >= 12L) {
                                departureCalendar.add(1, 1);
                            }
                            departureDate2 = departureCalendar.getTime();
                            expressData.setDepartureDate(departureDate2);
                        }
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateOperationNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHaveWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_cantDefineDateOp, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values.length > 6) {
                    String pccCodeString = values[6].trim();
                    if (pccCodeString.length() > 2) {
                        pccCode = pccCodeString.substring(2);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (entries.length > 1) {
                String systemNumberString = entries[1].trim();
                if (systemNumberString.length() > 4) {
                    systemNumber = systemNumberString.substring(4);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setMcoNumber(mcoNumber);
            expressData.setPnr(pnr);
            expressData.setIssueDate(issueDate);
            expressData.setPccCode(pccCode);
            expressData.setSystemNumber(systemNumber);
            token = tokens[++tokenIndex].trim();
            ArrayList<Traveller> travellers = new ArrayList<Traveller>();
            String[] entries4 = token.split("[/]");
            String certificateNumber = null;
            Date certificateIssueDate = null;
            int startEntry = 0;
            int endEntry = 0;
            for (int i = 0; i < entries4.length; ++i) {
                String genderCode;
                int entryIndexOffset;
                if (Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410.*)$").matcher(entries4[i].trim()).find() || !Pattern.compile("^((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+$").matcher(entries4[i].trim()).find() || i + 1 >= entries4.length) continue;
                PassportType passportType = null;
                String passportNumber = null;
                String lastName = null;
                String firstName = null;
                String middleName = null;
                Date birthday = null;
                CountryReference citizenship = null;
                Gender gender = null;
                startEntry = endEntry;
                endEntry = i + 2;
                ++i;
                if (endEntry - startEntry == 4) {
                    certificateNumber = entries4[startEntry].trim();
                    String certificateDateString = entries4[startEntry + 1].trim();
                    certificateIssueDate = new SimpleDateFormat("ddMMyy").parse(certificateDateString);
                }
                if (entries4.length > (entryIndexOffset = Math.max(startEntry, endEntry - 2))) {
                    String passportString = entries4[entryIndexOffset].trim();
                    if (passportString.length() > 1) {
                        String passportTypeCode = passportString.substring(0, 2);
                        passportType = this.getPassportType(passportTypeCode);
                        if (passportType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_passportTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (passportString.length() > 2) {
                        passportNumber = passportString.substring(2);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportData, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDatePassport, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries4.length > entryIndexOffset + 1) {
                    String nameString = entries4[entryIndexOffset + 1].trim();
                    String[] values = nameString.split("[=]");
                    if (values.length > 0) {
                        lastName = values[0].trim().replaceAll("[\\d-]", "");
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSurname, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSurname, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (values.length > 1) {
                        String firstNameString = values[1].trim();
                        if (firstNameString.length() == 2 && values.length == 2) {
                            String initialsString = firstNameString.replaceAll("[\\d-]", "");
                            if (initialsString.length() > 0) {
                                firstName = initialsString.substring(0, 1);
                                middleName = initialsString.substring(1);
                            }
                        } else {
                            firstName = firstNameString.replaceAll("[\\d-]", "");
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineName, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataName, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (middleName == null) {
                        if (values.length > 2) {
                            middleName = values[2].trim().replaceAll("[\\d-]", "");
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineMiddlename, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataMiddlename, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                }
                if (entries4.length > entryIndexOffset + 2 && Pattern.compile("^\\d{8}$").matcher(entries4[entryIndexOffset + 2].trim()).find()) {
                    String birthdayString = entries4[entryIndexOffset + 2].trim();
                    try {
                        birthday = new SimpleDateFormat("ddMMyyyy").parse(birthdayString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_birthdayNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                if (entries4.length > entryIndexOffset + 3 && Pattern.compile("^\\w{3}$").matcher(entries4[entryIndexOffset + 3].trim()).find()) {
                    Iterator iterator;
                    Country citizenshipCountry;
                    String citizenshipCodeString = entries4[entryIndexOffset + 3].trim();
                    Set citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO.name()});
                    if (citizenships.isEmpty()) {
                        citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                    }
                    if (citizenships.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_moreOneCountryFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                    }
                    Country country = citizenshipCountry = (iterator = citizenships.iterator()).hasNext() ? (Country)iterator.next() : null;
                    if (citizenshipCountry != null) {
                        citizenship = citizenshipCountry.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryNotFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                    }
                }
                if (entries4.length > entryIndexOffset + 4 && Pattern.compile("^((\u041c)|(M)|(\u0416)|(F))$").matcher(entries4[entryIndexOffset + 4].trim()).find() && (gender = this.getGender(genderCode = entries4[entryIndexOffset + 4].trim())) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_genderNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                }
                if (passportType != null || passportNumber != null || lastName != null || firstName != null || middleName != null || birthday != null || citizenship != null || gender != null) {
                    Traveller traveller = new Traveller();
                    Passport passport = new Passport();
                    passport.setType(passportType);
                    passport.setNumber(passportNumber);
                    passport.setLastName(lastName);
                    passport.setFirstName(firstName);
                    passport.setMiddleName(middleName);
                    passport.setBirthday(birthday);
                    passport.setCitizenship(citizenship);
                    passport.setGender(gender);
                    String fullName = TextUtil.buildFullName((PersonalName)passport);
                    traveller.setName(fullName);
                    traveller.setCyrillicName(TextUtil.translit((String)fullName, (boolean)false));
                    traveller.setBirthday(birthday);
                    traveller.setGender(gender);
                    traveller.setPassport(passport);
                    travellers.add(traveller);
                    continue;
                }
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassenger, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassenger, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setCertificateNumber(certificateNumber);
            expressData.setCertificateIssueDate(certificateIssueDate);
            expressData.getTravellers().clear();
            expressData.getTravellers().addAll(travellers);
            token = tokens[++tokenIndex].trim();
            String fareCalculationData = null;
            StringBuilder stringBulder2 = new StringBuilder();
            stringBulder2.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(nextToken.trim()).find()) break;
                stringBulder2.append(nextToken);
                ++tokenIndex;
            }
            if ((index = (token = stringBulder2.toString().trim()).indexOf("\u0412\u0420\u0415\u041c\u042f")) != -1) {
                token = token.substring(0, index).trim();
            }
            if ((index = token.indexOf("\u041f\u0420\u0418\u0411\u042b\u0422\u0418\u0415")) != -1) {
                token = token.substring(0, index).trim();
            }
            fareCalculationData = token;
            expressData.setFareCalculationData(fareCalculationData);
            if (tokens.length < ++tokenIndex) {
                token = tokens[tokenIndex].trim();
                String endorsement = null;
                endorsement = token;
                expressData.setEndorsement(endorsement);
                ++tokenIndex;
            }
        } else {
            throw new Exception("Corrupted record!");
        }
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        String mcoBlankTypeCode = MCO_BLANK_TYPE_CODE;
        TransactionType transactionType = TransactionType.REFUND;
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setMcoBlankTypeCode(mcoBlankTypeCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    /*
     * WARNING - void declaration
     */
    protected ExpressData createRefundDataNewFormat(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        HashSet<Message> messages;
        ExpressData expressData = null;
        if (content != null) {
            int index;
            void var14_46;
            String[] stringArray;
            void var14_43;
            String[] values;
            String[] entries2;
            CarriageType carriageType;
            String carriageNumber;
            Date departureDate;
            String slot;
            String trainNumber;
            String token;
            int tokenIndex;
            String[] tokens;
            block166: {
                void var14_22;
                messages = new HashSet<Message>();
                expressData = (ExpressData)expressDataFactory.createObject();
                tokens = content.split(TOKEN_SEPARATOR);
                tokenIndex = 1;
                token = tokens[tokenIndex].trim();
                HashMap<PaymentType, ExpressData.FOPDetails> fopDetails = new HashMap<PaymentType, ExpressData.FOPDetails>();
                BigDecimal totalFare = null;
                BigDecimal segmentEquivalentFare = null;
                BigDecimal reservedSeatEquivalentFare = null;
                BigDecimal tariffFare = null;
                BigDecimal tariffVat = null;
                Object var14_21 = null;
                BigDecimal serviceFare = null;
                BigDecimal serviceVat = null;
                BigDecimal serviceVatRate = null;
                BigDecimal penalty = null;
                BigDecimal penaltyVat = null;
                BigDecimal penaltyVatRate = null;
                StringBuilder stringBulder = new StringBuilder();
                stringBulder.append(tokens[tokenIndex]);
                for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                    String nextToken = tokens[i];
                    if (Pattern.compile("^(\u0412\u0420\u0415\u041c\u042f \u0414\u041e \u041e\u0422\u041f\u0420|\u0412\u0420\u0415\u041c\u042f \u041f\u041e\u0421\u041b\u0415 \u041e\u0422\u041f\u0420).+$").matcher(nextToken.trim()).find()) break;
                    stringBulder.append(nextToken);
                    ++tokenIndex;
                }
                token = stringBulder.toString();
                String[] entries3 = token.split("[\\s(),/;]+");
                boolean refund = false;
                boolean tariffVatEntryFound = false;
                boolean serviceVatEntryFound = false;
                for (int i = 0; i < entries3.length; ++i) {
                    ExpressData.FOPDetails details;
                    String paymentTypeCode;
                    BigDecimal fare;
                    PassengerStatus passengerStatus;
                    PaymentType paymentType;
                    if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e$").matcher(entries3[i].trim()).find()) {
                        refund = true;
                        if (i + 1 >= entries3.length) continue;
                        String[] values2 = entries3[i + 1].trim().split("-");
                        paymentType = PaymentType.CASH;
                        passengerStatus = null;
                        fare = null;
                        if (values2.length > 0) {
                            paymentTypeCode = values2[0];
                            if (!TextUtil.isBlank((String)paymentTypeCode)) {
                                paymentType = this.getPaymentType(paymentTypeCode);
                                passengerStatus = this.getPassengerStatus(paymentTypeCode);
                                if (paymentType == null) {
                                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                                }
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (values2.length > 1) {
                            try {
                                fare = new BigDecimal(values2[1]);
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (paymentType == null || fare == null) continue;
                        details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                        if (details == null) {
                            details = new ExpressData.FOPDetails();
                            fopDetails.put(paymentType, details);
                        }
                        details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                        details.setPassengerStatus(passengerStatus);
                        totalFare = totalFare != null ? totalFare.add(fare) : fare;
                        continue;
                    }
                    if (Pattern.compile("^\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u041e$").matcher(entries3[i].trim()).find()) {
                        refund = false;
                        if (i + 1 >= entries3.length) continue;
                        String[] values2 = entries3[i + 1].trim().split("-");
                        paymentType = PaymentType.CASH;
                        passengerStatus = null;
                        fare = null;
                        if (values2.length > 0) {
                            paymentTypeCode = values2[0];
                            if (!TextUtil.isBlank((String)paymentTypeCode)) {
                                paymentType = this.getPaymentType(paymentTypeCode);
                                passengerStatus = this.getPassengerStatus(paymentTypeCode);
                                if (paymentType == null) {
                                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                                }
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (values2.length > 1) {
                            try {
                                fare = new BigDecimal(values2[1]).negate();
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (paymentType == null || fare == null) continue;
                        details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                        if (details == null) {
                            details = new ExpressData.FOPDetails();
                            fopDetails.put(paymentType, details);
                        }
                        details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                        details.setPassengerStatus(passengerStatus);
                        totalFare = totalFare != null ? totalFare.add(fare) : fare;
                        continue;
                    }
                    if (Pattern.compile("^\u0411\u0418\u041b\\.$").matcher(entries3[i].trim()).find() && refund) {
                        if (i + 1 >= entries3.length) continue;
                        try {
                            segmentEquivalentFare = new BigDecimal(entries3[i + 1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_ticketPriceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_priceValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        tariffFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffFare, segmentEquivalentFare});
                        continue;
                    }
                    if (Pattern.compile("^\u041f\u041b\\.$").matcher(entries3[i].trim()).find() && refund) {
                        if (i + 1 >= entries3.length) continue;
                        try {
                            reservedSeatEquivalentFare = new BigDecimal(entries3[i + 1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_reservedSeatPriceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_priceValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        tariffFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffFare, reservedSeatEquivalentFare});
                        continue;
                    }
                    if (Pattern.compile("^\u0421\u0415\u0420\u0412\\..*$").matcher(entries3[i].trim()).find() && refund) {
                        if (entries3[i].trim().length() > 5) {
                            try {
                                serviceFare = new BigDecimal(entries3[i].trim().substring(5));
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_sumServiceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueSumSeviceNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                            continue;
                        }
                        if (i + 1 >= entries3.length) continue;
                        try {
                            serviceFare = new BigDecimal(entries3[i + 1].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_sumServiceNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueSumSeviceNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (Pattern.compile("^\u041a\u0421\u0411\\..+$").matcher(entries3[i].trim()).find() && refund) {
                        try {
                            penalty = new BigDecimal(entries3[i].trim().substring(4)).negate();
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_penaltyDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (Pattern.compile("^\u041d\u0414\u0421$").matcher(entries3[i].trim()).find() && refund && !tariffVatEntryFound && !serviceVatEntryFound) {
                        if (i + 1 >= entries3.length || !Pattern.compile("^\\d+%$").matcher(entries3[i + 1].trim()).find()) continue;
                        tariffVatEntryFound = true;
                        try {
                            BigDecimal bigDecimal = new BigDecimal(entries3[i + 1].trim().substring(0, entries3[i + 1].trim().length() - 1));
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_tariffVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (i + 2 < entries3.length) {
                            try {
                                tariffVat = new BigDecimal(entries3[i + 2].trim());
                            }
                            catch (NumberFormatException e) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_tariffVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                        if (i + 4 >= entries3.length || !Pattern.compile("^\\d+%$").matcher(entries3[i + 4].trim()).find()) continue;
                        serviceVatEntryFound = true;
                        try {
                            serviceVatRate = new BigDecimal(entries3[i + 4].trim().substring(0, entries3[i + 4].trim().length() - 1));
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_serviceVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (i + 5 >= entries3.length) continue;
                        try {
                            serviceVat = new BigDecimal(entries3[i + 5].trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_serviceVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        continue;
                    }
                    if (i + 1 >= entries3.length || !Pattern.compile("^\u041f\u041e\u041b\u0423\u0427\u0415\u041d$").matcher(entries3[i].trim()).find() || !Pattern.compile("^\u041d\u0414\u0421$").matcher(entries3[i + 1].trim()).find() || !refund || i + 2 >= entries3.length || !Pattern.compile("^\\d+%$").matcher(entries3[i + 2].trim()).find()) continue;
                    try {
                        penaltyVatRate = new BigDecimal(entries3[i + 2].trim().substring(0, entries3[i + 2].trim().length() - 1));
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_penaltyVatDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (i + 3 >= entries3.length) continue;
                    try {
                        penaltyVat = new BigDecimal(entries3[i + 3].trim());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_penaltyVatRateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                expressData.getFopDetails().clear();
                expressData.getFopDetails().putAll(fopDetails);
                expressData.setTotalFare(totalFare);
                expressData.setSegmentFare(segmentEquivalentFare);
                expressData.setReservedSeatFare(reservedSeatEquivalentFare);
                expressData.setTariffFare(tariffFare);
                expressData.setTariffVat(tariffVat);
                expressData.setTariffVatRate((BigDecimal)var14_22);
                expressData.setServiceFare(serviceFare);
                expressData.setServiceVat(serviceVat);
                expressData.setServiceVatRate(serviceVatRate);
                expressData.setPenalty(penalty);
                expressData.setPenaltyVat(penaltyVat);
                expressData.setPenaltyVatRate(penaltyVatRate);
                ++tokenIndex;
                token = tokens[++tokenIndex].trim();
                trainNumber = null;
                slot = null;
                departureDate = null;
                carriageNumber = null;
                carriageType = null;
                entries2 = token.split("\\s+");
                if (entries2.length > 0) {
                    String string = entries2[0].trim();
                    try {
                        trainNumber = String.valueOf(Integer.valueOf(string));
                    }
                    catch (NumberFormatException e) {
                        trainNumber = string;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries2.length > 1) {
                    slot = entries2[1].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSlot, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSlot, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries2.length > 3) {
                    String string = entries2[2].trim();
                    String timeString = entries2[3].trim();
                    String date = string;
                    String time = timeString;
                    if (date != null && time != null) {
                        try {
                            String departureDateString = String.format("%s.%s.%s", Calendar.getInstance().get(1), date, time);
                            if (entries2[3].contains(":")) {
                                departureDate = new SimpleDateFormat("yyyy.dd.MM.HH:mm").parse(departureDateString);
                                break block166;
                            }
                            departureDate = new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(departureDateString);
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (entries2.length > 4) {
                String string = entries2[4].trim();
                try {
                    carriageNumber = String.valueOf(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    carriageNumber = string;
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 5) {
                String string = entries2[5].trim();
                if (!TextUtil.isBlank((String)string)) {
                    carriageType = this.getCarriageType(string);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_CarriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_CarriageTypeCodeNotSupported, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setTrainNumber(trainNumber);
            expressData.setSlot(slot);
            expressData.setDepartureDate(departureDate);
            expressData.setCarriageNumber(carriageNumber);
            expressData.setCarriageType(carriageType);
            token = tokens[++tokenIndex].trim();
            RailwayStationReference departureStation = null;
            RailwayStationReference arriveStation = null;
            ServiceClass serviceClass = null;
            String[] entries4 = token.split("[()]");
            if (entries4.length > 1) {
                Iterator iterator;
                String routeString = entries4[1].trim();
                String[] values3 = routeString.split("-");
                if (values3.length > 0) {
                    RailwayStation departureLocation;
                    String string = values3[0].trim();
                    Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (departureLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_departureStationMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = departureLocation = (iterator = departureLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (departureLocation != null) {
                        departureStation = departureLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDepartureStation, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values3.length > 1) {
                    RailwayStation arriveLocation;
                    String string = values3[1].trim();
                    Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (arriveLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationMay, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = arriveLocation = (iterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (arriveLocation != null) {
                        arriveStation = arriveLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDestination, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDD, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStations, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries4.length > 2) {
                values = entries4[2].trim().split("\\s+");
                String serviceClassString = null;
                for (String value : values) {
                    if (Pattern.compile("^\u041a\u041b\\.\u041e\u0411\u0421\u041b\\.\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                        serviceClassString = value.substring(8);
                        break;
                    }
                    if (!Pattern.compile("^\\d{1}\\D{1}$").matcher(value.trim()).find()) continue;
                    serviceClassString = value;
                    break;
                }
                if (serviceClassString != null) {
                    serviceClass = this.getServiceClass(serviceClassString);
                    if (serviceClass == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_classServiceNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_classServiceCodeNotSupported, (Object[])new Object[]{serviceClassString}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
            expressData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
            expressData.setServiceClass(serviceClass);
            token = tokens[++tokenIndex].trim();
            ArrayList<Integer> places = new ArrayList<Integer>();
            CompartmentType compartmentType = null;
            String[] entries5 = token.split("\\s+");
            int entryIndexOffset = 0;
            if (entries5.length > 1) {
                if (Pattern.compile("^\u0411\u0415\u0417$").matcher(entries5[0].trim()).find() && Pattern.compile("^\u041c\u0415\u0421\u0422$").matcher(entries5[1].trim()).find()) {
                    messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_noPlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_ticketNoPlace, (Object[])new Object[0]), (Object[])new Object[0]));
                    entryIndexOffset = 1;
                } else if (Pattern.compile("^\\d+-\\d+$").matcher(entries5[1].trim()).find()) {
                    void var14_40;
                    values = entries5[1].trim().split("-");
                    Object startPlace = null;
                    Object var14_38 = null;
                    try {
                        startPlace = Integer.valueOf(values[0].trim());
                        Integer n = Integer.valueOf(values[1].trim());
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (startPlace != null && var14_40 != null && (Integer)startPlace <= var14_40.intValue()) {
                        for (int j = ((Integer)startPlace).intValue(); j <= var14_40.intValue(); ++j) {
                            places.add(j);
                        }
                    }
                } else {
                    values = entries5[1].trim().split(";");
                    for (String value : values) {
                        Integer place = null;
                        try {
                            place = Integer.valueOf(value.trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (place == null) continue;
                        places.add(place);
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPlaceNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries5.length > 2 + entryIndexOffset) {
                compartmentType = Pattern.compile("^/\u041c\u0423\u0416\u0421\u041a\u041e\u0415$").matcher(entries5[2 + entryIndexOffset].trim()).find() ? CompartmentType.MEN : (Pattern.compile("^/\u0416\u0415\u041d\u0421\u041a\u041e\u0415$").matcher(entries5[2 + entryIndexOffset].trim()).find() ? CompartmentType.WOMEN : CompartmentType.COMMON);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCoupe, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTypeCoupe, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.getPlaces().clear();
            expressData.getPlaces().addAll(places);
            expressData.setCompartmentType(compartmentType);
            token = tokens[++tokenIndex].trim();
            String mcoNumber = null;
            String pnr = null;
            Date issueDate = null;
            String pccCode = null;
            String systemNumber = null;
            StringBuilder stringBulder = new StringBuilder();
            stringBulder.append(tokens[tokenIndex]);
            int n = tokenIndex + 1;
            while (var14_43 < tokens.length) {
                String nextToken = tokens[var14_43];
                if (Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(nextToken.trim()).find()) break;
                stringBulder.append(nextToken);
                ++tokenIndex;
                ++var14_43;
            }
            if ((stringArray = (token = stringBulder.toString().trim()).split("[()]")).length > 0) {
                String[] values4 = stringArray[0].trim().split("[\\s/]+");
                if (values4.length > 0) {
                    mcoNumber = values4[0].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineNumberKRS, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataNumberKRS, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values4.length > 3) {
                    pnr = values4[3].trim();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePNR, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPNR, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values4.length > 5) {
                    try {
                        String issueDateString = String.format("%s.%s", values4[4].trim(), values4[5].trim());
                        issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(issueDateString);
                        Date departureDate2 = expressData.getDepartureDate();
                        if (departureDate2 != null) {
                            long differenceInHours;
                            Calendar departureCalendar = Calendar.getInstance();
                            Calendar issueCalendar = Calendar.getInstance();
                            departureCalendar.setTime(departureDate2);
                            issueCalendar.setTime(issueDate);
                            departureCalendar.set(1, issueCalendar.get(1));
                            if (departureCalendar.get(2) == 11 && departureCalendar.get(5) == 31 && issueCalendar.get(2) == 0 && issueCalendar.get(5) == 1) {
                                departureCalendar.add(1, -1);
                            }
                            if (issueDate.after(departureDate2 = departureCalendar.getTime()) && (differenceInHours = (issueCalendar.getTimeInMillis() - departureCalendar.getTimeInMillis()) / 3600000L) >= 12L) {
                                departureCalendar.add(1, 1);
                            }
                            departureDate2 = departureCalendar.getTime();
                            expressData.setDepartureDate(departureDate2);
                        }
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateOperationNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHaveWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_cantDefineDateOp, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values4.length > 6) {
                    String pccCodeString = values4[6].trim();
                    if (pccCodeString.length() > 2) {
                        pccCode = pccCodeString.substring(2);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            if (stringArray.length > 1) {
                String systemNumberString = stringArray[1].trim();
                if (systemNumberString.length() > 4) {
                    systemNumber = systemNumberString.substring(4);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            expressData.setMcoNumber(mcoNumber);
            expressData.setPnr(pnr);
            expressData.setIssueDate(issueDate);
            expressData.setPccCode(pccCode);
            expressData.setSystemNumber(systemNumber);
            token = tokens[++tokenIndex].trim();
            ArrayList<Traveller> travellers = new ArrayList<Traveller>();
            String[] entries6 = token.split("[/]");
            String certificateNumber = null;
            Date certificateIssueDate = null;
            int startEntry = 0;
            int endEntry = 0;
            boolean bl = false;
            while (var14_46 < entries6.length) {
                if (!Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410.*)$").matcher(entries6[var14_46].trim()).find() && Pattern.compile("^((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+$").matcher(entries6[var14_46].trim()).find() && var14_46 + true < entries6.length) {
                    String genderCode;
                    int entryIndexOffset2;
                    PassportType passportType = null;
                    String passportNumber = null;
                    String lastName = null;
                    String firstName = null;
                    String middleName = null;
                    Date birthday = null;
                    CountryReference citizenship = null;
                    Gender gender = null;
                    startEntry = endEntry;
                    endEntry = var14_46 + 2;
                    ++var14_46;
                    if (endEntry - startEntry == 4) {
                        certificateNumber = entries6[startEntry].trim();
                        String certificateDateString = entries6[startEntry + 1].trim();
                        certificateIssueDate = new SimpleDateFormat("ddMMyy").parse(certificateDateString);
                    }
                    if (entries6.length > (entryIndexOffset2 = Math.max(startEntry, endEntry - 2))) {
                        String passportString = entries6[entryIndexOffset2].trim();
                        if (passportString.length() > 1) {
                            String passportTypeCode = passportString.substring(0, 2);
                            passportType = this.getPassportType(passportTypeCode);
                            if (passportType == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_passportTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (passportString.length() > 2) {
                            passportNumber = passportString.substring(2);
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportData, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDatePassport, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (entries6.length > entryIndexOffset2 + 1) {
                        String nameString = entries6[entryIndexOffset2 + 1].trim();
                        String[] values5 = nameString.split("[=]");
                        if (values5.length > 0) {
                            lastName = values5[0].trim().replaceAll("[\\d-]", "");
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSurname, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSurname, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (values5.length > 1) {
                            String firstNameString = values5[1].trim();
                            if (firstNameString.length() == 2 && values5.length == 2) {
                                String initialsString = firstNameString.replaceAll("[\\d-]", "");
                                if (initialsString.length() > 0) {
                                    firstName = initialsString.substring(0, 1);
                                    middleName = initialsString.substring(1);
                                }
                            } else {
                                firstName = firstNameString.replaceAll("[\\d-]", "");
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineName, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataName, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (middleName == null) {
                            if (values5.length > 2) {
                                middleName = values5[2].trim().replaceAll("[\\d-]", "");
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineMiddlename, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataMiddlename, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 2 && Pattern.compile("^\\d{8}$").matcher(entries6[entryIndexOffset2 + 2].trim()).find()) {
                        String birthdayString = entries6[entryIndexOffset2 + 2].trim();
                        try {
                            birthday = new SimpleDateFormat("ddMMyyyy").parse(birthdayString);
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_birthdayNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 3 && Pattern.compile("^\\w{3}$").matcher(entries6[entryIndexOffset2 + 3].trim()).find()) {
                        Iterator iterator;
                        Country citizenshipCountry;
                        String citizenshipCodeString = entries6[entryIndexOffset2 + 3].trim();
                        Set citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO.name()});
                        if (citizenships.isEmpty()) {
                            citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                        }
                        if (citizenships.size() > 1) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_moreOneCountryFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                        Country country = citizenshipCountry = (iterator = citizenships.iterator()).hasNext() ? (Country)iterator.next() : null;
                        if (citizenshipCountry != null) {
                            citizenship = citizenshipCountry.toReference();
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryNotFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                    }
                    if (entries6.length > entryIndexOffset2 + 4 && Pattern.compile("^((\u041c)|(M)|(\u0416)|(F))$").matcher(entries6[entryIndexOffset2 + 4].trim()).find() && (gender = this.getGender(genderCode = entries6[entryIndexOffset2 + 4].trim())) == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_genderNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                    }
                    if (passportType != null || passportNumber != null || lastName != null || firstName != null || middleName != null || birthday != null || citizenship != null || gender != null) {
                        Traveller traveller = new Traveller();
                        Passport passport = new Passport();
                        passport.setType(passportType);
                        passport.setNumber(passportNumber);
                        passport.setLastName(lastName);
                        passport.setFirstName(firstName);
                        passport.setMiddleName(middleName);
                        passport.setBirthday(birthday);
                        passport.setCitizenship(citizenship);
                        passport.setGender(gender);
                        String fullName = TextUtil.buildFullName((PersonalName)passport);
                        traveller.setName(fullName);
                        traveller.setCyrillicName(TextUtil.translit((String)fullName, (boolean)false));
                        traveller.setBirthday(birthday);
                        traveller.setGender(gender);
                        traveller.setPassport(passport);
                        travellers.add(traveller);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassenger, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassenger, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                ++var14_46;
            }
            expressData.setCertificateNumber(certificateNumber);
            expressData.setCertificateIssueDate(certificateIssueDate);
            expressData.getTravellers().clear();
            expressData.getTravellers().addAll(travellers);
            token = tokens[++tokenIndex].trim();
            String fareCalculationData = null;
            StringBuilder stringBulder2 = new StringBuilder();
            stringBulder2.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(nextToken.trim()).find()) break;
                stringBulder2.append(nextToken);
                ++tokenIndex;
            }
            if ((index = (token = stringBulder2.toString().trim()).indexOf("\u0412\u0420\u0415\u041c\u042f")) != -1) {
                token = token.substring(0, index).trim();
            }
            if ((index = token.indexOf("\u041f\u0420\u0418\u0411\u042b\u0422\u0418\u0415")) != -1) {
                token = token.substring(0, index).trim();
            }
            fareCalculationData = token;
            expressData.setFareCalculationData(fareCalculationData);
            if (tokens.length < ++tokenIndex) {
                token = tokens[tokenIndex].trim();
                String endorsement = null;
                endorsement = token;
                expressData.setEndorsement(endorsement);
                ++tokenIndex;
            }
        } else {
            throw new Exception("Corrupted record!");
        }
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        String mcoBlankTypeCode = MCO_BLANK_TYPE_CODE;
        TransactionType transactionType = TransactionType.REFUND;
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setMcoBlankTypeCode(mcoBlankTypeCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    protected ExpressData createVoidData(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        ExpressData expressData = null;
        if (content != null) {
            String[] tokens = content.split(TOKEN_SEPARATOR);
            boolean old = false;
            for (String token : tokens) {
                if (!Pattern.compile("^.+\\s+D\\d{2}\\.\\d{2}\\s+\u0412\u0420\u0415\u041c\u042f\\d{2}\\.\\d{2}\\s+.+$").matcher(token.trim()).find()) continue;
                old = true;
                break;
            }
            expressData = old ? this.createVoidDataOldFormat(content, expressDataFactory) : this.createVoidDataNewFormat(content, expressDataFactory);
        } else {
            throw new Exception("Corrupted record!");
        }
        return expressData;
    }

    protected ExpressData createVoidDataOldFormat(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        String fareCalculationData;
        String token;
        HashSet<Message> messages;
        ExpressData expressData = null;
        if (content != null) {
            messages = new HashSet<Message>();
            expressData = (ExpressData)expressDataFactory.createObject();
            String[] tokens = content.split(TOKEN_SEPARATOR);
            int tokenIndex = 1;
            token = tokens[tokenIndex].trim();
            HashMap<PaymentType, ExpressData.FOPDetails> fopDetails = new HashMap<PaymentType, ExpressData.FOPDetails>();
            BigDecimal totalFare = null;
            String[] entries = token.split("\\s+");
            if (entries.length > 1) {
                String[] values = entries[1].trim().split("-");
                PaymentType paymentType = PaymentType.CASH;
                PassengerStatus passengerStatus = null;
                BigDecimal fare = null;
                if (values.length > 0) {
                    String paymentTypeCode = values[0];
                    if (!TextUtil.isBlank((String)paymentTypeCode)) {
                        paymentType = this.getPaymentType(paymentTypeCode);
                        passengerStatus = this.getPassengerStatus(paymentTypeCode);
                        if (paymentType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values.length > 1) {
                    try {
                        fare = new BigDecimal(values[1]);
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (paymentType != null && fare != null) {
                    ExpressData.FOPDetails details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                    if (details == null) {
                        details = new ExpressData.FOPDetails();
                        fopDetails.put(paymentType, details);
                    }
                    details.setFare(details.getFare() != null ? details.getFare().add(fare) : fare);
                    details.setPassengerStatus(passengerStatus);
                    totalFare = totalFare != null ? totalFare.add(fare) : fare;
                }
            }
            expressData.getFopDetails().clear();
            expressData.getFopDetails().putAll(fopDetails);
            token = tokens[++tokenIndex].trim();
            String trainNumber = null;
            String slot = null;
            Date departureDate = null;
            String carriageNumber = null;
            CarriageType carriageType = null;
            String[] entries2 = token.split("\\s+");
            if (entries2.length > 0) {
                String trainNumberString = entries2[0].trim();
                if (trainNumberString.length() > 1) {
                    trainNumberString = trainNumberString.substring(1);
                    try {
                        trainNumber = String.valueOf(Integer.valueOf(trainNumberString));
                    }
                    catch (NumberFormatException e) {
                        trainNumber = trainNumberString;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 1) {
                slot = entries2[1].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSlot, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSlot, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 3) {
                String dateString = entries2[2].trim();
                String timeString = entries2[3].trim();
                String date = null;
                String time = null;
                if (dateString.length() > 1) {
                    date = dateString.substring(1);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDayDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDayDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (timeString.length() > 5) {
                    time = timeString.substring(5);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTimeDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTimeDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (date != null && time != null) {
                    try {
                        String departureDateString = String.format("%s.%s.%s", Calendar.getInstance().get(1), date, time);
                        departureDate = new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(departureDateString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 4) {
                String carriageNumberString = entries2[4].trim();
                if (carriageNumberString.length() > 3) {
                    carriageNumberString = carriageNumberString.substring(3);
                    try {
                        carriageNumber = String.valueOf(Integer.valueOf(carriageNumberString));
                    }
                    catch (NumberFormatException e) {
                        carriageNumber = carriageNumberString;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 5) {
                String carriageTypeCode = entries2[5].trim();
                if (!TextUtil.isBlank((String)carriageTypeCode)) {
                    carriageType = this.getCarriageType(carriageTypeCode);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_CarriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_CarriageTypeCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setTrainNumber(trainNumber);
            expressData.setSlot(slot);
            expressData.setDepartureDate(departureDate);
            expressData.setCarriageNumber(carriageNumber);
            expressData.setCarriageType(carriageType);
            ++tokenIndex;
            token = tokens[++tokenIndex].trim();
            ArrayList<Integer> places = new ArrayList<Integer>();
            ServiceClass serviceClass = null;
            entries = token.split("\\s+");
            if (entries.length > 0) {
                Integer place = null;
                try {
                    place = Integer.valueOf(entries[0].trim());
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (place != null) {
                    places.add(place);
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPlaceNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 1) {
                String serviceClassString = entries[entries.length - 1].trim();
                if (serviceClassString.length() > 8) {
                    String serviceClassCode = serviceClassString.substring(8);
                    if (!TextUtil.isBlank((String)serviceClassCode)) {
                        serviceClass = this.getServiceClass(serviceClassCode);
                        if (serviceClass == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_classServiceCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.getPlaces().clear();
            expressData.getPlaces().addAll(places);
            expressData.setServiceClass(serviceClass);
            token = tokens[++tokenIndex].trim();
            String pnr = null;
            Date issueDate = null;
            String pccCode = null;
            String systemNumber = null;
            StringBuilder stringBulder = new StringBuilder();
            stringBulder.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                if (Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(nextToken.trim()).find()) break;
                stringBulder.append(nextToken);
                ++tokenIndex;
            }
            if ((entries = (token = stringBulder.toString().trim()).split("[\\s/()]+")).length > 2) {
                pnr = entries[2].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePNR, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPNR, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 4) {
                try {
                    String issueDateString = String.format("%s.%s", entries[3].trim(), entries[4].trim());
                    issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(issueDateString);
                    Date departureDate2 = expressData.getDepartureDate();
                    if (departureDate2 != null) {
                        long differenceInHours;
                        Calendar departureCalendar = Calendar.getInstance();
                        Calendar issueCalendar = Calendar.getInstance();
                        departureCalendar.setTime(departureDate2);
                        issueCalendar.setTime(issueDate);
                        departureCalendar.set(1, issueCalendar.get(1));
                        if (departureCalendar.get(2) == 11 && departureCalendar.get(5) == 31 && issueCalendar.get(2) == 0 && issueCalendar.get(5) == 1) {
                            departureCalendar.add(1, -1);
                        }
                        if (issueDate.after(departureDate2 = departureCalendar.getTime()) && (differenceInHours = (issueCalendar.getTimeInMillis() - departureCalendar.getTimeInMillis()) / 3600000L) >= 12L) {
                            departureCalendar.add(1, 1);
                        }
                        departureDate2 = departureCalendar.getTime();
                        expressData.setDepartureDate(departureDate2);
                    }
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateOpNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateOp, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateOp, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 5) {
                String pccCodeString = entries[5].trim();
                if (pccCodeString.length() > 2) {
                    pccCode = pccCodeString.substring(2);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 8) {
                String systemNumberString = entries[8].trim();
                if (systemNumberString.length() > 4) {
                    systemNumber = systemNumberString.substring(4);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]));
            }
            expressData.setPnr(pnr);
            expressData.setIssueDate(issueDate);
            expressData.setPccCode(pccCode);
            expressData.setSystemNumber(systemNumber);
            token = tokens[++tokenIndex].trim();
            ArrayList<Traveller> travellers = new ArrayList<Traveller>();
            String[] entries3 = token.split("[/]");
            String certificateNumber = null;
            Date certificateIssueDate = null;
            int startEntry = 0;
            int endEntry = 0;
            for (int i = 0; i < entries3.length; ++i) {
                String genderCode;
                int entryIndexOffset;
                if (Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410.*)$").matcher(entries3[i].trim()).find() || !Pattern.compile("^((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+$").matcher(entries3[i].trim()).find() || i + 1 >= entries3.length) continue;
                PassportType passportType = null;
                String passportNumber = null;
                String lastName = null;
                String firstName = null;
                String middleName = null;
                Date birthday = null;
                CountryReference citizenship = null;
                Gender gender = null;
                startEntry = endEntry;
                endEntry = i + 2;
                ++i;
                if (endEntry - startEntry == 4) {
                    certificateNumber = entries3[startEntry].trim();
                    String certificateDateString = entries3[startEntry + 1].trim();
                    certificateIssueDate = new SimpleDateFormat("ddMMyy").parse(certificateDateString);
                }
                if (entries3.length > (entryIndexOffset = Math.max(startEntry, endEntry - 2))) {
                    String passportString = entries3[entryIndexOffset].trim();
                    if (passportString.length() > 1) {
                        String passportTypeCode = passportString.substring(0, 2);
                        passportType = this.getPassportType(passportTypeCode);
                        if (passportType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_passportTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (passportString.length() > 2) {
                        passportNumber = passportString.substring(2);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportData, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassport, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (entries3.length > entryIndexOffset + 1) {
                    String nameString = entries3[entryIndexOffset + 1].trim();
                    String[] values = nameString.split("[=]");
                    if (values.length > 0) {
                        lastName = values[0].trim().replaceAll("[\\d-]", "");
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSurname, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSurname, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (values.length > 1) {
                        String firstNameString = values[1].trim();
                        if (firstNameString.length() == 2 && values.length == 2) {
                            String initialsString = firstNameString.replaceAll("[\\d-]", "");
                            if (initialsString.length() > 0) {
                                firstName = initialsString.substring(0, 1);
                                middleName = initialsString.substring(1);
                            }
                        } else {
                            firstName = firstNameString.replaceAll("[\\d-]", "");
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineName, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataName, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (middleName == null) {
                        if (values.length > 2) {
                            middleName = values[2].trim().replaceAll("[\\d-]", "");
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineMiddlename, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataMiddlename, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                }
                if (entries3.length > entryIndexOffset + 2 && Pattern.compile("^\\d{8}$").matcher(entries3[entryIndexOffset + 2].trim()).find()) {
                    String birthdayString = entries3[entryIndexOffset + 2].trim();
                    try {
                        birthday = new SimpleDateFormat("ddMMyyyy").parse(birthdayString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_birthdayNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                if (entries3.length > entryIndexOffset + 3 && Pattern.compile("^\\w{3}$").matcher(entries3[entryIndexOffset + 3].trim()).find()) {
                    Iterator iterator;
                    Country citizenshipCountry;
                    String citizenshipCodeString = entries3[entryIndexOffset + 3].trim();
                    Set citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO.name()});
                    if (citizenships.isEmpty()) {
                        citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                    }
                    if (citizenships.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_moreOneCountryFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                    }
                    Country country = citizenshipCountry = (iterator = citizenships.iterator()).hasNext() ? (Country)iterator.next() : null;
                    if (citizenshipCountry != null) {
                        citizenship = citizenshipCountry.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryNotFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                    }
                }
                if (entries3.length > entryIndexOffset + 4 && Pattern.compile("^((\u041c)|(M)|(\u0416)|(F))$").matcher(entries3[entryIndexOffset + 4].trim()).find() && (gender = this.getGender(genderCode = entries3[entryIndexOffset + 4].trim())) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_genderNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                }
                if (passportType != null || passportNumber != null || lastName != null || firstName != null || middleName != null || birthday != null || citizenship != null || gender != null) {
                    Traveller traveller = new Traveller();
                    Passport passport = new Passport();
                    passport.setType(passportType);
                    passport.setNumber(passportNumber);
                    passport.setLastName(lastName);
                    passport.setFirstName(firstName);
                    passport.setMiddleName(middleName);
                    passport.setBirthday(birthday);
                    passport.setCitizenship(citizenship);
                    passport.setGender(gender);
                    String fullName = TextUtil.buildFullName((PersonalName)passport);
                    traveller.setName(fullName);
                    traveller.setCyrillicName(TextUtil.translit((String)fullName, (boolean)false));
                    traveller.setBirthday(birthday);
                    traveller.setGender(gender);
                    traveller.setPassport(passport);
                    travellers.add(traveller);
                    continue;
                }
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassenger, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassenger, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setCertificateNumber(certificateNumber);
            expressData.setCertificateIssueDate(certificateIssueDate);
            expressData.getTravellers().clear();
            expressData.getTravellers().addAll(travellers);
            token = tokens[++tokenIndex].trim();
            fareCalculationData = null;
            StringBuilder stringBulder2 = new StringBuilder();
            stringBulder2.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                stringBulder2.append(nextToken);
                ++tokenIndex;
            }
            token = stringBulder2.toString().trim();
            int index = token.indexOf("\u0412\u0420\u0415\u041c\u042f");
            if (index != -1) {
                token = token.substring(0, index).trim();
            }
            if ((index = token.indexOf("\u041f\u0420\u0418\u0411\u042b\u0422\u0418\u0415")) != -1) {
                token = token.substring(0, index).trim();
            }
        } else {
            throw new Exception("Corrupted record!");
        }
        fareCalculationData = token;
        expressData.setFareCalculationData(fareCalculationData);
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        TransactionType transactionType = TransactionType.CANCEL;
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    /*
     * WARNING - void declaration
     */
    protected ExpressData createVoidDataNewFormat(String content, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        String fareCalculationData;
        String token;
        HashSet<Message> messages;
        ExpressData expressData = null;
        if (content != null) {
            void var14_48;
            String[] entries;
            String[] values;
            messages = new HashSet<Message>();
            expressData = (ExpressData)expressDataFactory.createObject();
            String[] tokens = content.split(TOKEN_SEPARATOR);
            int tokenIndex = 1;
            token = tokens[tokenIndex].trim();
            HashMap<PaymentType, ExpressData.FOPDetails> fopDetails = new HashMap<PaymentType, ExpressData.FOPDetails>();
            BigDecimal totalFare = null;
            String[] entries2 = token.split("\\s+");
            if (entries2.length > 1) {
                void var14_24;
                String[] values2 = entries2[1].trim().split("-");
                PaymentType paymentType = PaymentType.CASH;
                PassengerStatus passengerStatus = null;
                Object var14_22 = null;
                if (values2.length > 0) {
                    String paymentTypeCode = values2[0];
                    if (!TextUtil.isBlank((String)paymentTypeCode)) {
                        paymentType = this.getPaymentType(paymentTypeCode);
                        passengerStatus = this.getPassengerStatus(paymentTypeCode);
                        if (paymentType == null) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_paymentTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_paymentTypeCodeNotSupported, (Object[])new Object[]{paymentTypeCode}), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values2.length > 1) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(values2[1]);
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_PaymentSumNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_PaymentSumNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePaymentSum, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPaymentSum, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (paymentType != null && var14_24 != null) {
                    ExpressData.FOPDetails details = (ExpressData.FOPDetails)fopDetails.get(paymentType);
                    if (details == null) {
                        details = new ExpressData.FOPDetails();
                        fopDetails.put(paymentType, details);
                    }
                    details.setFare((BigDecimal)(details.getFare() != null ? details.getFare().add((BigDecimal)var14_24) : var14_24));
                    details.setPassengerStatus(passengerStatus);
                    totalFare = totalFare != null ? totalFare.add((BigDecimal)var14_24) : var14_24;
                }
            }
            expressData.getFopDetails().clear();
            expressData.getFopDetails().putAll(fopDetails);
            token = tokens[++tokenIndex].trim();
            String trainNumber = null;
            String slot = null;
            Date departureDate = null;
            String carriageNumber = null;
            CarriageType carriageType = null;
            String[] entries22 = token.split("\\s+");
            if (entries22.length > 0) {
                String string = entries22[0].trim();
                try {
                    trainNumber = String.valueOf(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    trainNumber = string;
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTrainNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTrainNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries22.length > 1) {
                slot = entries22[1].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSlot, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSlot, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries22.length > 3) {
                String string = entries22[2].trim();
                String timeString = entries22[3].trim();
                String date = string;
                String time = timeString;
                if (date != null && time != null) {
                    try {
                        String departureDateString = String.format("%s.%s.%s", Calendar.getInstance().get(1), date, time);
                        departureDate = new SimpleDateFormat("yyyy.dd.MM.HH.mm").parse(departureDateString);
                    }
                    catch (ParseException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDateDeparture, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataDateDeparture, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries22.length > 4) {
                String string = entries22[4].trim();
                try {
                    carriageNumber = String.valueOf(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    carriageNumber = string;
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries22.length > 5) {
                String string = entries22[5].trim();
                if (!TextUtil.isBlank((String)string)) {
                    carriageType = this.getCarriageType(string);
                    if (carriageType == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_CarriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_CarriageTypeCodeNotSupported, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCarriageType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCarriageType, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setTrainNumber(trainNumber);
            expressData.setSlot(slot);
            expressData.setDepartureDate(departureDate);
            expressData.setCarriageNumber(carriageNumber);
            expressData.setCarriageType(carriageType);
            token = tokens[++tokenIndex].trim();
            RailwayStationReference departureStation = null;
            RailwayStationReference arriveStation = null;
            ServiceClass serviceClass = null;
            String[] entries3 = token.split("[()]");
            if (entries3.length > 1) {
                Iterator iterator;
                String routeString = entries3[1].trim();
                String[] values3 = routeString.split("-");
                if (values3.length > 0) {
                    RailwayStation departureLocation;
                    String string = values3[0].trim();
                    Collection departureLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (departureLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_departureStationMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = departureLocation = (iterator = departureLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (departureLocation != null) {
                        departureStation = departureLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineDepartureStation, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
                if (values3.length > 1) {
                    RailwayStation arriveLocation;
                    String string = values3[1].trim();
                    Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant((String)string);
                    if (arriveLocations.size() > 1) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationMay, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_inDictionaryMoreOne, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                    RailwayStation railwayStation = arriveLocation = (iterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)iterator.next() : null;
                    if (arriveLocation != null) {
                        arriveStation = arriveLocation.toReference();
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_stationDestinationNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_stationNotFound, (Object[])new Object[]{string}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDestination, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStation, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineStationDD, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataStations, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries3.length > 2) {
                values = entries3[2].trim().split("\\s+");
                String serviceClassString = null;
                for (String value : values) {
                    if (Pattern.compile("^\u041a\u041b\\.\u041e\u0411\u0421\u041b\\.\\d{1}\\D{1}$").matcher(value.trim()).find()) {
                        serviceClassString = value.substring(8);
                        break;
                    }
                    if (!Pattern.compile("^\\d{1}\\D{1}$").matcher(value.trim()).find()) continue;
                    serviceClassString = value;
                    break;
                }
                if (serviceClassString != null) {
                    serviceClass = this.getServiceClass(serviceClassString);
                    if (serviceClass == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_classServiceNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_classServiceCodeNotSupported, (Object[])new Object[]{serviceClassString}), (Object[])new Object[0]));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineClassService, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataClassService, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
            expressData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
            expressData.setServiceClass(serviceClass);
            token = tokens[++tokenIndex].trim();
            ArrayList<Integer> places = new ArrayList<Integer>();
            CompartmentType compartmentType = null;
            entries2 = token.split("\\s+");
            int entryIndexOffset = 0;
            if (entries2.length > 1) {
                if (Pattern.compile("^\u0411\u0415\u0417$").matcher(entries2[0].trim()).find() && Pattern.compile("^\u041c\u0415\u0421\u0422$").matcher(entries2[1].trim()).find()) {
                    messages.add(MessageHelper.createMessage((String)Messages.ExpressExchangeProcessor_noPlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_ticketNoPlace, (Object[])new Object[0]), (Object[])new Object[0]));
                    entryIndexOffset = 1;
                } else if (Pattern.compile("^\\d+-\\d+$").matcher(entries2[1].trim()).find()) {
                    void var14_41;
                    values = entries2[1].trim().split("-");
                    Object startPlace = null;
                    Object var14_39 = null;
                    try {
                        startPlace = Integer.valueOf(values[0].trim());
                        Integer n = Integer.valueOf(values[1].trim());
                    }
                    catch (NumberFormatException e) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (startPlace != null && var14_41 != null && (Integer)startPlace <= var14_41.intValue()) {
                        for (int j = ((Integer)startPlace).intValue(); j <= var14_41.intValue(); ++j) {
                            places.add(j);
                        }
                    }
                } else {
                    values = entries2[1].trim().split(";");
                    for (String value : values) {
                        Integer place = null;
                        try {
                            place = Integer.valueOf(value.trim());
                        }
                        catch (NumberFormatException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_placeNumberNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_valueNan, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (place == null) continue;
                        places.add(place);
                    }
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePlaceNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPlaceNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries2.length > 2 + entryIndexOffset) {
                compartmentType = Pattern.compile("^/\u041c\u0423\u0416\u0421\u041a\u041e\u0415$").matcher(entries2[2 + entryIndexOffset].trim()).find() ? CompartmentType.MEN : (Pattern.compile("^/\u0416\u0415\u041d\u0421\u041a\u041e\u0415$").matcher(entries2[2 + entryIndexOffset].trim()).find() ? CompartmentType.WOMEN : CompartmentType.COMMON);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCoupe, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTypeCoupe, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.getPlaces().clear();
            expressData.getPlaces().addAll(places);
            expressData.setCompartmentType(compartmentType);
            token = tokens[++tokenIndex].trim();
            String systemNumber = null;
            String pnr = null;
            Date issueDate = null;
            String pccCode = null;
            StringBuilder stringBulder = new StringBuilder();
            stringBulder.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String string = tokens[i];
                if (Pattern.compile("^((.+/)*((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+/.+=.+/*)+$").matcher(string.trim()).find()) break;
                stringBulder.append(string);
                ++tokenIndex;
            }
            if ((entries = (token = stringBulder.toString().trim()).split("[\\s/]+")).length > 0) {
                systemNumber = entries[0].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineTicketNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataTicketNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 3) {
                pnr = entries[3].trim();
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePNR, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPNR, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 5) {
                try {
                    String string = String.format("%s.%s", entries[4].trim(), entries[5].trim());
                    issueDate = new SimpleDateFormat("ddMMyy.HHmm").parse(string);
                    Date departureDate2 = expressData.getDepartureDate();
                    if (departureDate2 != null) {
                        long differenceInHours;
                        Calendar departureCalendar = Calendar.getInstance();
                        Calendar issueCalendar = Calendar.getInstance();
                        departureCalendar.setTime(departureDate2);
                        issueCalendar.setTime(issueDate);
                        departureCalendar.set(1, issueCalendar.get(1));
                        if (departureCalendar.get(2) == 11 && departureCalendar.get(5) == 31 && issueCalendar.get(2) == 0 && issueCalendar.get(5) == 1) {
                            departureCalendar.add(1, -1);
                        }
                        if (issueDate.after(departureDate2 = departureCalendar.getTime()) && (differenceInHours = (issueCalendar.getTimeInMillis() - departureCalendar.getTimeInMillis()) / 3600000L) >= 12L) {
                            departureCalendar.add(1, 1);
                        }
                        departureDate2 = departureCalendar.getTime();
                        expressData.setDepartureDate(departureDate2);
                    }
                }
                catch (ParseException parseException) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateOperationNotDefined, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHaveWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_cantDefineDateOp, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            if (entries.length > 6) {
                String string = entries[6].trim();
                if (string.length() > 2) {
                    pccCode = string.substring(2);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineCodeConsole, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataCodeConsole, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            expressData.setSystemNumber(systemNumber);
            expressData.setPnr(pnr);
            expressData.setIssueDate(issueDate);
            expressData.setPccCode(pccCode);
            token = tokens[++tokenIndex].trim();
            ArrayList<Traveller> travellers = new ArrayList<Traveller>();
            String[] entries4 = token.split("[/]");
            String certificateNumber = null;
            Date certificateIssueDate = null;
            int startEntry = 0;
            int endEntry = 0;
            boolean bl = false;
            while (var14_48 < entries4.length) {
                if (!Pattern.compile("^(\u0421\u041f\u0420|\u0421\u041f\u0420\u0410\u0412\u041a\u0410.*)$").matcher(entries4[var14_48].trim()).find() && Pattern.compile("^((\u041f\u041d)|(\u0417\u041f)|(\u0421\u041f)|(\u0414\u041f)|(\u041f\u0421)|(\u0421\u0420)|(\u0412\u0411)|(\u0423\u0412)|(\u0417\u0417)|(\u0411\u0413)|(\u0412\u0416)|(\u0421\u0423)|(\u0421\u0412)|(\u041f\u041c)|(\u0421\u041e)|(\u041f\u0411)|(\u0417\u041c)|(\u041f\u0423)|(\u041f\u041a)|(\u041f\u0422)|(\u041f\u0417)|(\u0423\u041b)|(\u0418\u0418)).+$").matcher(entries4[var14_48].trim()).find() && var14_48 + true < entries4.length) {
                    String genderCode;
                    int entryIndexOffset2;
                    PassportType passportType = null;
                    String passportNumber = null;
                    String lastName = null;
                    String firstName = null;
                    String middleName = null;
                    Date birthday = null;
                    CountryReference citizenship = null;
                    Gender gender = null;
                    startEntry = endEntry;
                    endEntry = var14_48 + 2;
                    ++var14_48;
                    if (endEntry - startEntry == 4) {
                        certificateNumber = entries4[startEntry].trim();
                        String certificateDateString = entries4[startEntry + 1].trim();
                        certificateIssueDate = new SimpleDateFormat("ddMMyy").parse(certificateDateString);
                    }
                    if (entries4.length > (entryIndexOffset2 = Math.max(startEntry, endEntry - 2))) {
                        String passportString = entries4[entryIndexOffset2].trim();
                        if (passportString.length() > 1) {
                            String passportTypeCode = passportString.substring(0, 2);
                            passportType = this.getPassportType(passportTypeCode);
                            if (passportType == null) {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_passportTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_passportTypeCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportType, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportType, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (passportString.length() > 2) {
                            passportNumber = passportString.substring(2);
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportNumber, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassportNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassportData, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDatePassport, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                    if (entries4.length > entryIndexOffset2 + 1) {
                        String nameString = entries4[entryIndexOffset2 + 1].trim();
                        String[] values4 = nameString.split("[=]");
                        if (values4.length > 0) {
                            lastName = values4[0].trim().replaceAll("[\\d-]", "");
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineSurname, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataSurname, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (values4.length > 1) {
                            String firstNameString = values4[1].trim();
                            if (firstNameString.length() == 2 && values4.length == 2) {
                                String initialsString = firstNameString.replaceAll("[\\d-]", "");
                                if (initialsString.length() > 0) {
                                    firstName = initialsString.substring(0, 1);
                                    middleName = initialsString.substring(1);
                                }
                            } else {
                                firstName = firstNameString.replaceAll("[\\d-]", "");
                            }
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineName, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataName, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                        if (middleName == null) {
                            if (values4.length > 2) {
                                middleName = values4[2].trim().replaceAll("[\\d-]", "");
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefineMiddlename, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataMiddlename, (Object[])new Object[0]), (Object[])new Object[0]));
                            }
                        }
                    }
                    if (entries4.length > entryIndexOffset2 + 2 && Pattern.compile("^\\d{8}$").matcher(entries4[entryIndexOffset2 + 2].trim()).find()) {
                        String birthdayString = entries4[entryIndexOffset2 + 2].trim();
                        try {
                            birthday = new SimpleDateFormat("ddMMyyyy").parse(birthdayString);
                        }
                        catch (ParseException e) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_birthdayNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                        }
                    }
                    if (entries4.length > entryIndexOffset2 + 3 && Pattern.compile("^\\w{3}$").matcher(entries4[entryIndexOffset2 + 3].trim()).find()) {
                        Iterator iterator;
                        Country citizenshipCountry;
                        String citizenshipCodeString = entries4[entryIndexOffset2 + 3].trim();
                        Set citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO.name()});
                        if (citizenships.isEmpty()) {
                            citizenships = DictionaryCache.get().lookup(Country.class, citizenshipCodeString, new String[]{CodeSystem.ISO_ALPHA3.name()});
                        }
                        if (citizenships.size() > 1) {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipMayWrong, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_moreOneCountryFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                        Country country = citizenshipCountry = (iterator = citizenships.iterator()).hasNext() ? (Country)iterator.next() : null;
                        if (citizenshipCountry != null) {
                            citizenship = citizenshipCountry.toReference();
                        } else {
                            messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_citizenshipNotDefine, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_countryNotFound, (Object[])new Object[]{citizenshipCodeString}), (Object[])new Object[0]));
                        }
                    }
                    if (entries4.length > entryIndexOffset2 + 4 && Pattern.compile("^((\u041c)|(M)|(\u0416)|(F))$").matcher(entries4[entryIndexOffset2 + 4].trim()).find() && (gender = this.getGender(genderCode = entries4[entryIndexOffset2 + 4].trim())) == null) {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_genderNotSupported, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_genderCodeNotSupported, (Object[])new Object[]{genderCode}), (Object[])new Object[0]));
                    }
                    if (passportType != null || passportNumber != null || lastName != null || firstName != null || middleName != null || birthday != null || citizenship != null || gender != null) {
                        Traveller traveller = new Traveller();
                        Passport passport = new Passport();
                        passport.setType(passportType);
                        passport.setNumber(passportNumber);
                        passport.setLastName(lastName);
                        passport.setFirstName(firstName);
                        passport.setMiddleName(middleName);
                        passport.setBirthday(birthday);
                        passport.setCitizenship(citizenship);
                        passport.setGender(gender);
                        String fullName = TextUtil.buildFullName((PersonalName)passport);
                        traveller.setName(fullName);
                        traveller.setCyrillicName(TextUtil.translit((String)fullName, (boolean)false));
                        traveller.setBirthday(birthday);
                        traveller.setGender(gender);
                        traveller.setPassport(passport);
                        travellers.add(traveller);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)Messages.ExpressExchangeProcessor_cantDefinePassenger, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_noDataPassenger, (Object[])new Object[0]), (Object[])new Object[0]));
                    }
                }
                ++var14_48;
            }
            expressData.setCertificateNumber(certificateNumber);
            expressData.setCertificateIssueDate(certificateIssueDate);
            expressData.getTravellers().clear();
            expressData.getTravellers().addAll(travellers);
            token = tokens[++tokenIndex].trim();
            fareCalculationData = null;
            StringBuilder stringBulder2 = new StringBuilder();
            stringBulder2.append(tokens[tokenIndex]);
            for (int i = tokenIndex + 1; i < tokens.length; ++i) {
                String nextToken = tokens[i];
                stringBulder2.append(nextToken);
                ++tokenIndex;
            }
            token = stringBulder2.toString().trim();
            int index = token.indexOf("\u0412\u0420\u0415\u041c\u042f");
            if (index != -1) {
                token = token.substring(0, index).trim();
            }
            if ((index = token.indexOf("\u041f\u0420\u0418\u0411\u042b\u0422\u0418\u0415")) != -1) {
                token = token.substring(0, index).trim();
            }
        } else {
            throw new Exception("Corrupted record!");
        }
        fareCalculationData = token;
        expressData.setFareCalculationData(fareCalculationData);
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        TransactionType transactionType = TransactionType.CANCEL;
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    protected ExpressData createCorruptedData(String content, TransactionType transactionType, ObjectFactory<ExpressData> expressDataFactory) throws Exception {
        ExpressData expressData = null;
        if (content == null) {
            throw new Exception("Corrupted record!");
        }
        HashSet<Message> messages = new HashSet<Message>();
        messages.add(MessageHelper.createErrorMessage((String)Messages.ExpressExchangeProcessor_corruptedRecord, (String)L10nResourcesManager.getStr((String)Messages.ExpressExchangeProcessor_recordCropped, (Object[])new Object[0]), (Object[])new Object[0]));
        expressData = (ExpressData)expressDataFactory.createObject();
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(GdsName.EXPRESS);
        TicketType ticketType = TicketType.OWN;
        expressData.setContent(content);
        expressData.setCorrupted(true);
        expressData.setBlankTypeCode(blankTypeCode);
        expressData.setBlankOwnerCode(blankOwnerCode);
        expressData.setTransactionType(transactionType);
        expressData.setTicketType(ticketType);
        expressData.getMessages().clear();
        expressData.getMessages().addAll(messages);
        return expressData;
    }

    private CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    private ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    private PaymentType getPaymentType(String paymentTypeCode) {
        if (!TextUtil.isBlank((String)paymentTypeCode)) {
            if (paymentTypeCode.equals("\u041d")) {
                return PaymentType.CASH;
            }
            if (paymentTypeCode.equals("\u04121")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04123")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04125")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u04127")) {
                return PaymentType.MTD;
            }
            if (paymentTypeCode.equals("\u041213")) {
                return PaymentType.MTD;
            }
        }
        return null;
    }

    private PassengerStatus getPassengerStatus(String paymentTypeCode) {
        if (!TextUtil.isBlank((String)paymentTypeCode)) {
            if (paymentTypeCode.equals("\u04121")) {
                return PassengerStatus.VS_MO;
            }
            if (paymentTypeCode.equals("\u04123")) {
                return PassengerStatus.VS_MVD;
            }
            if (paymentTypeCode.equals("\u04125")) {
                return PassengerStatus.VS_MO;
            }
            if (paymentTypeCode.equals("\u04127")) {
                return PassengerStatus.VS_FSB;
            }
            if (paymentTypeCode.equals("\u041213")) {
                return PassengerStatus.MCHS;
            }
        }
        return null;
    }

    private PassportType getPassportType(String passportTypeCode) {
        if (!TextUtil.isBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0421\u041f")) {
                return PassportType.SERVICE_PASSPORT;
            }
            if (passportTypeCode.equals("\u0414\u041f")) {
                return PassportType.DIPLOMATIC;
            }
            if (passportTypeCode.equals("\u041f\u0421")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0412\u0411")) {
                return PassportType.MILITARYID;
            }
            if (passportTypeCode.equals("\u0423\u0412")) {
                return PassportType.MILITARYCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0411\u0413")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0412\u0416")) {
                return PassportType.RESIDENCEPERMIT;
            }
            if (passportTypeCode.equals("\u0421\u0423")) {
                return PassportType.PASSPORTLOSSCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0421\u0412")) {
                return PassportType.BACKTOUSSRCERTIFICATE;
            }
            if (passportTypeCode.equals("\u041f\u041c")) {
                return PassportType.SEAMANSID;
            }
            if (passportTypeCode.equals("\u0421\u041e")) {
                return PassportType.CERTIFICATEOFRELEASE;
            }
            if (passportTypeCode.equals("\u041f\u0411")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0417\u041c")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0423")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u041a")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0422")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0423\u041b")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0418\u0418")) {
                return PassportType.IDENTITYCARD;
            }
        }
        return null;
    }

    private Gender getGender(String genderCode) {
        if (!TextUtil.isBlank((String)genderCode)) {
            if (genderCode.equals("\u041c")) {
                return Gender.MALE;
            }
            if (genderCode.equals("M")) {
                return Gender.MALE;
            }
            if (genderCode.equals("\u0416")) {
                return Gender.FEMALE;
            }
            if (genderCode.equals("F")) {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFakeDocument(ObjectFactory<EntityContainer<ExpressExchangeDocument>> expressExchangeDocumentFactory, String user, ExchangeFile file, String key, Exception e, Object ... parameters) throws Exception {
        EntityContainer container = (EntityContainer)expressExchangeDocumentFactory.createObject();
        container.setCreatedBy(user);
        container.setModifiedBy(user);
        container.setCreated(new Date());
        container.setModified(new Date());
        ExpressExchangeDocument index = (ExpressExchangeDocument)container.getEntity();
        index.setCreated(file.getCreated());
        index.setCheckSum(null);
        index.setLocation(file.getLocation());
        index.setContent(file.getContent());
        index.setStatus(ExceptionUtil.isInterruptedError((Throwable)e) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
        index.setContentType(ContentType.TEXT);
        Message message = MessageHelper.createErrorMessage((String)key, (Object[])parameters);
        index.getMessages().add(message);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            message.setDetails(baos.toString("utf-8"));
        }
        EntityStorage.get().save(container, true);
        this.logErorMessage(message, file.getLocation());
    }

    void logErorMessage(Message message, String fileName) {
        String errorString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.error(String.format("File \"%s\" was processed with error:\n%s", fileName, errorString));
            return;
        }
        this.log.error(String.format("File \"%s\" was processed with error:\n%s\nDetails: %s", fileName, errorString, message.getDetails()));
    }

    protected void logWarning(Message message, String fileName) {
        String warningString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.warn(String.format("File \"%s\" was processed with warning:\n%s", fileName, warningString));
            return;
        }
        this.log.debug(String.format("File \"%s\" was processed with warning:\n%s\nDetails: %s", fileName, warningString, message.getDetails()));
    }

    private class UnexpectedRecoredEndException
    extends Exception {
        private static final long serialVersionUID = 6544484120792764777L;

        public UnexpectedRecoredEndException(String message) {
            super(message);
        }
    }

    private static enum RecordType {
        AGENT,
        SELL,
        REFUND,
        VOID,
        REFUSE,
        COUPON;

    }
}

