/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.sirena;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentType;
import com.gridnine.xtrip.common.parsers.model.TransactionType;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParserHelper;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.parsers.BaseExchangeProcessor;
import com.gridnine.xtrip.server.parsers.SirenaXmlExchangeDocumentProcessor;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.ibus.parsers.common.CommonRailwayParsersHelper;
import com.gridnine.xtrip.server.railway.model.helpers.RzdServiceConverter;
import com.gridnine.xtrip.server.railway.parsers.sirena.SirenaData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SirenaExchangeProcessor
extends BaseExchangeProcessor<SirenaXmlExchangeDocument>
implements SirenaXmlExchangeDocumentProcessor<SirenaXmlExchangeDocument> {
    public static final String EXCHANGE_FILE_ENCODING = "utf8";
    public static final String STORE_ENCODING = "utf8";
    public static final String BLANK_TYPE_CODE = "99A EMD";
    public static final String INSURANCE_TAX_CODE = "\u0421\u0422\u0420";
    public static final int PNR_DAYS_THRESHOLD = 14;
    private static final String PROVIDER_CODE = "\u04281";

    protected Class<? extends EntityIndex<SirenaXmlExchangeDocument>> getIndexClass() {
        return SirenaXmlExchangeDocumentIndex.class;
    }

    public String getType() {
        return "SIRENA";
    }

    public void processExchangeFile(SirenaXmlExchangeDocument document) throws Exception {
        this.log.debug(String.format("processing exchange file %s document", document.getLocation()));
        document.setStatus(ProcessingStatus.UNPROCESSED);
        document.getMessages().clear();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Element ticketElement = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(document.getContent()), (String)"utf8")).getDocumentElement();
        SirenaData data = this.createData(ticketElement);
        if (data != null) {
            SirenaData.ProductType productType = data.getProductType();
            if (productType == SirenaData.ProductType.TICKET) {
                ProductStatus status = data.getStatus();
                if (status == ProductStatus.SELL) {
                    this.updateTicketSellExchangeDocument(document, data);
                } else if (status == ProductStatus.REFUND) {
                    this.updateTicketRefundExchangeDocument(document, data);
                }
            } else if (productType == SirenaData.ProductType.EMD) {
                ProductStatus status = data.getStatus();
                if (status == ProductStatus.SELL) {
                    this.updateEmdSellExchangeDocument(document, data);
                } else if (status == ProductStatus.REFUND) {
                    this.updateEmdRefundExchangeDocument(document, data);
                }
            }
        }
    }

    private void updateTicketSellExchangeDocument(SirenaXmlExchangeDocument document, SirenaData data) throws Exception {
        ProductSearchContext productSearchContext = new ProductSearchContext();
        productSearchContext.setBlankOwner(data.getBlankOwner());
        productSearchContext.setGdsName(data.getGds());
        productSearchContext.setPnr(data.getPnr());
        productSearchContext.setIssueDate(data.getIssueDate());
        productSearchContext.setSystemNumber(data.getSystemNumber());
        productSearchContext.setPreviousSystemNumber(null);
        ProductSearchResult productSearchResult = RailwayProductParserHelper.searchProductSell((ProductSearchContext)productSearchContext);
        if (!productSearchResult.isExists()) {
            ProductSearchContext productSearchContext2 = new ProductSearchContext();
            productSearchContext2.setBlankOwner(data.getBlankOwner());
            productSearchContext2.setGdsName(data.getGds());
            productSearchContext2.setPnr(data.getPnr());
            productSearchContext2.setIssueDate(data.getIssueDate());
            productSearchContext2.setSystemNumber(data.getProviderSystemNumber());
            ProductSearchResult productSearchResult2 = RailwayProductParserHelper.searchProductSell((ProductSearchContext)productSearchContext2);
            if (productSearchResult2.isExists()) {
                productSearchResult = productSearchResult2;
            } else {
                ProductSearchContext productSearchContext3 = new ProductSearchContext();
                productSearchContext3.setBlankOwner(data.getProvider());
                productSearchContext3.setGdsName(data.getGds());
                productSearchContext3.setPnr(data.getPnr());
                productSearchContext3.setIssueDate(data.getIssueDate());
                productSearchContext3.setSystemNumber(data.getProviderSystemNumber());
                ProductSearchResult productSearchResult3 = RailwayProductParserHelper.searchProductSell((ProductSearchContext)productSearchContext3);
                if (productSearchResult3.isExists()) {
                    productSearchResult = productSearchResult3;
                }
            }
        }
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.updateBookingFile(product.getReservation().getBookingFile(), data);
        this.updateReservation(product.getReservation(), data);
        product.setBlankOwnerRef(data.getBlankOwner());
        product.setProvider(data.getProvider());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
        RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
        product.setSalesPoint(data.getSalesPoint());
        product.setCashier(data.getAgent());
        product.setStatus(data.getStatus());
        product.setBlankType(data.getBlankType());
        product.setSystemNumber(data.getSystemNumber());
        product.setProviderSystemNumber(data.getProviderSystemNumber());
        product.setIssueDate(data.getIssueDate());
        product.setCarrierNumber(data.getCarrierNumber());
        product.setCarrier(data.getCarrier());
        product.setTicketType(data.getTicketType());
        product.setValidatorCode(data.getValidatorCode());
        product.setPcc(data.getPccCode());
        product.setEquivalentFare(data.getTariffAmountAmount());
        product.setEquivalentVAT(data.getTariffVatAmount());
        product.setServiceFare(data.getServiceAmountAmount());
        product.setServiceVAT(data.getServiceVatAmount());
        product.setTotalEquivalentFare(data.getTotalAmountAmount());
        product.setTotalEquivalentVAT(data.getTotalVatAmount());
        product.setVendorVatDetalization(data.getVatDetalization());
        if (data.getTravellers().size() > 0) {
            product.getPassengers().clear();
            product.getPassengers().addAll(data.getTravellers());
            product.getPassengerTypes().clear();
        }
        product.getSegments().clear();
        product.getSegments().addAll(data.getSegments());
        product.getTaxes().clear();
        product.getTaxes().addAll(data.getTaxes());
        product.setChecked(false);
        product.setContractRulesApplied(false);
        RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        if (vendorContractRelation != null) {
            vendorContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                vendorContractRelation.getFops().add(vendorFop);
            }
        }
        if (subagentContractRelation != null) {
            subagentContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                subagentContractRelation.getFops().add(subagentFop);
            }
        }
        if (clientContractRelation != null) {
            clientContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                clientContractRelation.getFops().add(clientFop);
            }
        }
        this.saveBookingFile(productSearchResult);
        document.setOwner(productSearchResult.getBookingFile().toReference());
        if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.ERROR)) {
            document.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.WARNING)) {
            document.setStatus(ProcessingStatus.WARNING);
        } else {
            document.setStatus(ProcessingStatus.OK);
        }
        document.getMessages().clear();
        document.getMessages().addAll(data.getMessages());
    }

    private void updateTicketRefundExchangeDocument(SirenaXmlExchangeDocument document, SirenaData data) throws Exception {
        RailwayProduct previousProduct;
        ProductSearchContext productSearchContext = new ProductSearchContext();
        productSearchContext.setBlankOwner(data.getBlankOwner());
        productSearchContext.setGdsName(data.getGds());
        productSearchContext.setPnr(data.getPnr());
        productSearchContext.setIssueDate(data.getIssueDate());
        productSearchContext.setSystemNumber(data.getSystemNumber());
        productSearchContext.setPreviousSystemNumber(null);
        ProductSearchResult productSearchResult = RailwayProductParserHelper.searchProductRefund((ProductSearchContext)productSearchContext);
        if (!productSearchResult.isExists()) {
            ProductSearchContext productSearchContext2 = new ProductSearchContext();
            productSearchContext2.setBlankOwner(data.getProvider());
            productSearchContext2.setGdsName(data.getGds());
            productSearchContext2.setPnr(data.getPnr());
            productSearchContext2.setIssueDate(data.getIssueDate());
            productSearchContext2.setSystemNumber(data.getProviderSystemNumber());
            ProductSearchResult productSearchResult2 = RailwayProductParserHelper.searchProductRefund((ProductSearchContext)productSearchContext2);
            if (productSearchResult2.isExists()) {
                productSearchResult = productSearchResult2;
            } else {
                ProductSearchContext productSearchContext3 = new ProductSearchContext();
                productSearchContext3.setBlankOwner(data.getBlankOwner());
                productSearchContext3.setGdsName(data.getGds());
                productSearchContext3.setPnr(data.getPnr());
                productSearchContext3.setIssueDate(data.getIssueDate());
                productSearchContext3.setSystemNumber(data.getProviderSystemNumber());
                ProductSearchResult productSearchResult3 = RailwayProductParserHelper.searchProductRefund((ProductSearchContext)productSearchContext3);
                if (productSearchResult3.isExists()) {
                    productSearchResult = productSearchResult3;
                } else {
                    Object rp = (RailwayProduct)productSearchResult2.getProduct();
                    if (rp.getPreviousProduct() != null && rp.getPreviousProduct().getTicketType() != TicketType.FAKE) {
                        productSearchResult = productSearchResult2;
                    } else {
                        rp = (RailwayProduct)productSearchResult3.getProduct();
                        if (rp.getPreviousProduct() != null && rp.getPreviousProduct().getTicketType() != TicketType.FAKE) {
                            productSearchResult = productSearchResult3;
                        }
                    }
                }
            }
        }
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.updateBookingFile(product.getReservation().getBookingFile(), data);
        this.updateReservation(product.getReservation(), data);
        if (product.getPreviousProduct() != null && (previousProduct = product.getPreviousProduct()).getSystemNumber() == null) {
            previousProduct.setSystemNumber(data.getSystemNumber());
        }
        product.setBlankOwnerRef(data.getBlankOwner());
        product.setProvider(data.getProvider());
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
        RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
        product.setSalesPoint(data.getSalesPoint());
        product.setCashier(data.getAgent());
        product.setStatus(data.getStatus());
        product.setBlankType(data.getBlankType());
        product.setSystemNumber(data.getSystemNumber());
        product.setProviderSystemNumber(data.getProviderSystemNumber());
        product.setIssueDate(data.getIssueDate());
        product.setCarrierNumber(data.getCarrierNumber());
        product.setCarrier(data.getCarrier());
        product.setTicketType(data.getTicketType());
        product.setValidatorCode(data.getValidatorCode());
        product.setPcc(data.getPccCode());
        product.setEquivalentFare(data.getTariffAmountAmount());
        product.setEquivalentVAT(data.getTariffVatAmount());
        product.setServiceFare(data.getServiceAmountAmount());
        product.setServiceVAT(data.getServiceVatAmount());
        product.setPenalty(data.getPenaltyAmountAmount());
        product.setPenaltyVAT(data.getPenaltyVatAmount());
        product.setTotalEquivalentFare(data.getTotalAmountAmount());
        product.setTotalEquivalentVAT(data.getTotalVatAmount());
        product.setVendorVatDetalization(data.getVatDetalization());
        if (data.getTravellers().size() > 0) {
            product.getPassengers().clear();
            product.getPassengers().addAll(data.getTravellers());
            product.getPassengerTypes().clear();
        }
        product.getSegments().clear();
        product.getSegments().addAll(data.getSegments());
        product.getTaxes().clear();
        product.getTaxes().addAll(data.getTaxes());
        product.setChecked(false);
        product.setContractRulesApplied(false);
        RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        if (vendorContractRelation != null) {
            vendorContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                vendorContractRelation.getFops().add(vendorFop);
            }
        }
        if (subagentContractRelation != null) {
            subagentContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                subagentContractRelation.getFops().add(subagentFop);
            }
        }
        if (clientContractRelation != null) {
            clientContractRelation.getFops().clear();
            for (RailwayProductFop fop : data.getFops()) {
                RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                clientContractRelation.getFops().add(clientFop);
            }
        }
        if (!TextUtil.isBlank((String)product.getEndorsement()) && product.getPenalty() == null) {
            BigDecimal totalEquivanetFare = null;
            try {
                totalEquivanetFare = new BigDecimal(product.getEndorsement());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            product.setPenalty(MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTotalEquivalentFare(), MiscUtil.negate((BigDecimal)totalEquivanetFare)}));
            product.setTotalEquivalentFare(totalEquivanetFare);
            RailwayProductHelper.updateFops((RailwayProduct)product);
        }
        this.saveBookingFile(productSearchResult);
        document.setOwner(productSearchResult.getBookingFile().toReference());
        if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.ERROR)) {
            document.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.WARNING)) {
            document.setStatus(ProcessingStatus.WARNING);
        } else {
            document.setStatus(ProcessingStatus.OK);
        }
        document.getMessages().clear();
        document.getMessages().addAll(data.getMessages());
    }

    private void updateEmdSellExchangeDocument(SirenaXmlExchangeDocument document, SirenaData data) throws Exception {
        ProductSearchContext productSearchContext = new ProductSearchContext();
        productSearchContext.setBlankOwner(data.getBlankOwner());
        productSearchContext.setGdsName(data.getGds());
        productSearchContext.setPnr(data.getPnr());
        productSearchContext.setIssueDate(data.getIssueDate());
        productSearchContext.setSystemNumber(data.getSystemNumber());
        productSearchContext.setPreviousSystemNumber(null);
        ProductSearchResult productSearchResult = RailwayProductParserHelper.searchProductSell((ProductSearchContext)productSearchContext);
        if (!productSearchResult.isExists()) {
            RailwayProduct existingProduct;
            ProductSearchContext productSearchContext2 = new ProductSearchContext();
            productSearchContext2.setBlankOwner(data.getProvider());
            productSearchContext2.setGdsName(data.getGds());
            productSearchContext2.setPnr(data.getPnr());
            productSearchContext2.setIssueDate(data.getIssueDate());
            productSearchContext2.setSystemNumber(data.getProviderSystemNumber());
            ProductSearchResult productSearchResult2 = RailwayProductParserHelper.searchProductSell((ProductSearchContext)productSearchContext2);
            if (productSearchResult2.isExists()) {
                productSearchResult = productSearchResult2;
            } else if (data.getSystemNumber() != null && (existingProduct = (RailwayProduct)productSearchResult.getProduct().getReservation().getProducts().stream().filter(it -> it instanceof RailwayProduct).map(it -> (RailwayProduct)it).filter(it -> data.getSystemNumber().equals(it.getProviderSystemNumber())).findFirst().orElse(null)) != null) {
                productSearchResult.getProduct().getReservation().getProducts().remove(productSearchResult.getProduct());
                productSearchResult.setProduct((BaseProduct)existingProduct);
                productSearchResult.setExists(true);
            }
        }
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.updateBookingFile(product.getReservation().getBookingFile(), data);
        this.updateReservation(product.getReservation(), data);
        if (!productSearchResult.isExists()) {
            product.setBlankOwnerRef(data.getBlankOwner());
            product.setProvider(data.getProvider());
            RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
            RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
            RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
            product.setSalesPoint(data.getSalesPoint());
            product.setCashier(data.getAgent());
            if (data.getStatus() != ProductStatus.SELL || product.getStatus() != ProductStatus.VOID) {
                product.setStatus(data.getStatus());
            }
            product.setBlankType(data.getBlankType());
            if (data.getSystemNumber() == null) {
                product.setSystemNumber(data.getProviderSystemNumber());
            } else {
                product.setSystemNumber(data.getSystemNumber());
                product.setProviderSystemNumber(data.getProviderSystemNumber());
            }
            product.setIssueDate(data.getIssueDate());
            product.setCarrierNumber(data.getCarrierNumber());
            product.setTicketType(data.getTicketType());
            product.setValidatorCode(data.getValidatorCode());
            product.setPcc(data.getPccCode());
            product.setEquivalentFare(data.getTotalAmountAmount());
            product.setTotalEquivalentFare(data.getTotalAmountAmount());
            product.setChecked(false);
            product.setContractRulesApplied(false);
            RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
            RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
            RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
            if (vendorContractRelation != null) {
                vendorContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    vendorContractRelation.getFops().add(vendorFop);
                }
            }
            if (subagentContractRelation != null) {
                subagentContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    subagentContractRelation.getFops().add(subagentFop);
                }
            }
            if (clientContractRelation != null) {
                clientContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    clientContractRelation.getFops().add(clientFop);
                }
            }
        }
        if (data.getTravellers().size() > 0) {
            product.getPassengers().clear();
            product.getPassengers().addAll(data.getTravellers());
            product.getPassengerTypes().clear();
        }
        this.saveBookingFile(productSearchResult);
        document.setOwner(productSearchResult.getBookingFile().toReference());
        if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.ERROR)) {
            document.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.WARNING)) {
            document.setStatus(ProcessingStatus.WARNING);
        } else {
            document.setStatus(ProcessingStatus.OK);
        }
        document.getMessages().clear();
        document.getMessages().addAll(data.getMessages());
    }

    private void updateEmdRefundExchangeDocument(SirenaXmlExchangeDocument document, SirenaData data) throws Exception {
        ProductSearchContext productSearchContext = new ProductSearchContext();
        productSearchContext.setBlankOwner(data.getBlankOwner());
        productSearchContext.setGdsName(data.getGds());
        productSearchContext.setPnr(data.getPnr());
        productSearchContext.setIssueDate(data.getIssueDate());
        productSearchContext.setSystemNumber(data.getSystemNumber());
        productSearchContext.setPreviousSystemNumber(null);
        ProductSearchResult productSearchResult = RailwayProductParserHelper.searchProductRefund((ProductSearchContext)productSearchContext);
        if (!productSearchResult.isExists() && data.getSystemNumber() != null) {
            RailwayProduct previousProduct;
            RailwayProduct refundProduct = null;
            RailwayProduct sellProduct = null;
            block2: for (Reservation res : ((BookingFile)productSearchResult.getBookingFile().getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    if (!(bp instanceof RailwayProduct)) continue;
                    RailwayProduct rp = (RailwayProduct)bp;
                    if (!data.getSystemNumber().equals(rp.getProviderSystemNumber())) continue;
                    if (rp.getStatus() == ProductStatus.REFUND) {
                        refundProduct = rp;
                        break block2;
                    }
                    if (rp.getStatus() != ProductStatus.SELL) continue;
                    sellProduct = rp;
                }
            }
            if (refundProduct != null) {
                refundProduct.getReservation().getProducts().remove(productSearchResult.getProduct());
                previousProduct = ((RailwayProduct)productSearchResult.getProduct()).getPreviousProduct();
                if (previousProduct != null && previousProduct.getTicketType() == TicketType.FAKE) {
                    refundProduct.getReservation().getProducts().remove(previousProduct);
                }
                productSearchResult.setProduct(refundProduct);
                productSearchResult.setExists(true);
            } else if (sellProduct != null) {
                sellProduct.getReservation().getProducts().remove(productSearchResult.getProduct());
                previousProduct = ((RailwayProduct)productSearchResult.getProduct()).getPreviousProduct();
                if (previousProduct != null && previousProduct.getTicketType() == TicketType.FAKE) {
                    sellProduct.getReservation().getProducts().remove(previousProduct);
                }
                RailwayProduct rp = new RailwayProduct();
                sellProduct.getReservation().getProducts().add(rp);
                rp.setReservation(sellProduct.getReservation());
                rp.setSystemNumber(sellProduct.getSystemNumber());
                rp.setProviderSystemNumber(sellProduct.getProviderSystemNumber());
                rp.setIssueDate(productSearchContext.getIssueDate());
                rp.setBlankOwnerRef(sellProduct.getBlankOwnerRef());
                rp.setBlankOwnerRef(RailwayProductHelper.getSupplier((BaseProduct)sellProduct));
                RailwayProductHelper.setAgency((BaseTicketProduct)rp, (EntityReference)RailwayProductHelper.getAgency((RailwayProduct)sellProduct));
                RailwayProductHelper.setSubagency((BaseTicketProduct)rp, (EntityReference)RailwayProductHelper.getSubagency((RailwayProduct)sellProduct));
                rp.setStatus(ProductStatus.REFUND);
                rp.setPreviousProduct(sellProduct);
                sellProduct.setNextProduct(rp);
                productSearchResult.setProduct((BaseProduct)rp);
            }
        }
        RailwayProduct product = (RailwayProduct)productSearchResult.getProduct();
        this.updateBookingFile(product.getReservation().getBookingFile(), data);
        this.updateReservation(product.getReservation(), data);
        if (!productSearchResult.isExists()) {
            product.setBlankOwnerRef(data.getBlankOwner());
            product.setProvider(data.getProvider());
            RailwayProductHelper.setSupplier((BaseTicketProduct)product, data.getSupplier());
            RailwayProductHelper.setAgency((BaseTicketProduct)product, data.getAgency());
            RailwayProductHelper.setSubagency((BaseTicketProduct)product, data.getSubagency());
            product.setSalesPoint(data.getSalesPoint());
            product.setCashier(data.getAgent());
            if (data.getStatus() != ProductStatus.SELL || product.getStatus() != ProductStatus.VOID) {
                product.setStatus(data.getStatus());
            }
            product.setBlankType(data.getBlankType());
            product.setSystemNumber(data.getSystemNumber());
            product.setIssueDate(data.getIssueDate());
            product.setCarrierNumber(data.getCarrierNumber());
            product.setTicketType(data.getTicketType());
            product.setValidatorCode(data.getValidatorCode());
            product.setPcc(data.getPccCode());
            product.setEquivalentFare(data.getTotalAmountAmount());
            product.setTotalEquivalentFare(data.getTotalAmountAmount());
            if (data.getTotalAmountAmount() != null) {
                product.setEndorsement(data.getTotalAmountAmount().toPlainString());
            }
            product.setChecked(false);
            product.setContractRulesApplied(false);
            RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
            RailwayProductContractRelationData subagentContractRelation = RailwayProductHelper.getSubagentContractRelation((RailwayProduct)product, (boolean)false);
            RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
            if (vendorContractRelation != null) {
                vendorContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop vendorFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    vendorContractRelation.getFops().add(vendorFop);
                }
            }
            if (subagentContractRelation != null) {
                subagentContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop subagentFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    subagentContractRelation.getFops().add(subagentFop);
                }
            }
            if (clientContractRelation != null) {
                clientContractRelation.getFops().clear();
                for (RailwayProductFop fop : data.getFops()) {
                    RailwayProductFop clientFop = (RailwayProductFop)XCloneHelper.clone((XCloneable)fop, (boolean)true);
                    fop.setOperationDate(null);
                    fop.setAgent(null);
                    clientContractRelation.getFops().add(clientFop);
                }
            }
        } else {
            if (data.getTotalAmountAmount() != null) {
                product.setEndorsement(data.getTotalAmountAmount().toPlainString());
            }
            if (!TextUtil.isBlank((String)product.getEndorsement()) && product.getPenalty() == null) {
                BigDecimal totalEquivanetFare = null;
                try {
                    totalEquivanetFare = new BigDecimal(product.getEndorsement());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                product.setPenalty(MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTotalEquivalentFare(), product.getPenalty(), MiscUtil.negate((BigDecimal)totalEquivanetFare)}));
                product.setTotalEquivalentFare(totalEquivanetFare);
                RailwayProductHelper.updateFops((RailwayProduct)product);
            }
        }
        if (data.getTravellers().size() > 0) {
            product.getPassengers().clear();
            product.getPassengers().addAll(data.getTravellers());
            product.getPassengerTypes().clear();
        }
        this.saveBookingFile(productSearchResult);
        document.setOwner(productSearchResult.getBookingFile().toReference());
        if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.ERROR)) {
            document.setStatus(ProcessingStatus.ERROR);
        } else if (MessageHelper.hasMessages(data.getMessages(), (MessageType)MessageType.WARNING)) {
            document.setStatus(ProcessingStatus.WARNING);
        } else {
            document.setStatus(ProcessingStatus.OK);
        }
        document.getMessages().clear();
        document.getMessages().addAll(data.getMessages());
    }

    private void updateBookingFile(BookingFile bookingFile, SirenaData data) {
        if (bookingFile.getAgency() == null) {
            bookingFile.setAgency(data.getAgency());
        }
        if (bookingFile.getCreateDate() == null) {
            bookingFile.setCreateDate(data.getIssueDate());
        }
        ArrayList<Traveller> productTravellers = new ArrayList<Traveller>();
        for (Traveller traveller : data.getTravellers()) {
            Traveller bookingFileTraveller = (Traveller)CollectionUtil.find((Collection)bookingFile.getTravellers(), (Object)traveller, TravellerHelper::equals);
            if (bookingFileTraveller == null) {
                bookingFileTraveller = (Traveller)CollectionUtil.find((Collection)bookingFile.getTravellers(), (Object)traveller, TravellerHelper::equalsWithoutMiddleName);
            }
            if (bookingFileTraveller != null) {
                boolean bfcTravellerNameIsShorter = false;
                if (traveller.getName() != null) {
                    if (bookingFileTraveller.getName() == null) {
                        bookingFileTraveller.setName(traveller.getName());
                    } else if (traveller.getName().length() > bookingFileTraveller.getName().length()) {
                        bookingFileTraveller.setName(traveller.getName());
                        bfcTravellerNameIsShorter = true;
                        if (traveller.getCyrillicName() != null) {
                            bookingFileTraveller.setCyrillicName(traveller.getCyrillicName());
                        }
                    }
                }
                if (bookingFileTraveller.getCyrillicName() == null) {
                    bookingFileTraveller.setCyrillicName(traveller.getCyrillicName());
                }
                if (bookingFileTraveller.getBirthday() == null) {
                    bookingFileTraveller.setBirthday(traveller.getBirthday());
                }
                if (bookingFileTraveller.getPassport() != null) {
                    if (traveller.getPassport() != null) {
                        if (bookingFileTraveller.getPassport().getNumber() == null) {
                            bookingFileTraveller.getPassport().setNumber(traveller.getPassport().getNumber());
                        }
                        if (bookingFileTraveller.getPassport().getBirthday() == null) {
                            bookingFileTraveller.getPassport().setBirthday(traveller.getPassport().getBirthday());
                        }
                        if (bfcTravellerNameIsShorter && TextUtil.nonBlank((String)traveller.getPassport().getFirstName())) {
                            bookingFileTraveller.getPassport().setLastName(traveller.getPassport().getLastName());
                            bookingFileTraveller.getPassport().setFirstName(traveller.getPassport().getFirstName());
                            bookingFileTraveller.getPassport().setMiddleName(traveller.getPassport().getMiddleName());
                            bookingFileTraveller.getPassport().setSecondName(traveller.getPassport().getSecondName());
                        }
                    }
                } else {
                    bookingFileTraveller.setPassport(traveller.getPassport());
                }
                if (bookingFileTraveller.getCommunications().isEmpty()) {
                    bookingFileTraveller.getCommunications().addAll(traveller.getCommunications());
                }
                productTravellers.add(bookingFileTraveller);
                continue;
            }
            bookingFile.getTravellers().add(traveller);
            productTravellers.add(traveller);
        }
        data.getTravellers().clear();
        data.getTravellers().addAll(productTravellers);
    }

    private void updateReservation(Reservation reservation, SirenaData data) {
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)data.getGds(), (RecordLocatorType)(TextUtil.containsCyrillicLetter((String)data.getPnr()) ? RecordLocatorType.SIRENA_CYRILLIC : RecordLocatorType.SIRENA_LATIN), (String)data.getPnr());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)data.getGds(), (RecordLocatorType)(TextUtil.containsCyrillicLetter((String)data.getPnrLatin()) ? RecordLocatorType.SIRENA_CYRILLIC : RecordLocatorType.SIRENA_LATIN), (String)data.getPnrLatin());
        if (reservation.getSubagency() == null) {
            reservation.setSubagency(data.getSubagency());
        }
        if (reservation.getSalesPoint() == null) {
            reservation.setSalesPoint(data.getSalesPoint());
        }
        if (reservation.getBookingAgent() == null) {
            reservation.setBookingAgent(data.getAgent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile exchangeFile) throws Exception {
        if (exchangeFile == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        this.log.debug(String.format("registering exchange file %s", exchangeFile.getLocation()));
        List<SirenaData> sirenaDataList = this.createDataList(exchangeFile);
        if (sirenaDataList == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        LogicalSession managedSession = LogicalStorage.get().beginUnitOfWork();
        try {
            for (SirenaData sirenaData : sirenaDataList) {
                String checkSum = null;
                String user = LogicalStorage.get().getUser();
                String location = exchangeFile.getLocation();
                try {
                    byte[] content = exchangeFile.getContent();
                    if (content == null) {
                        this.log.error(String.format("content of file %s is empty", location));
                        this.addFakeDocument(user, exchangeFile, MessageHelper.createErrorMessage((String)Messages.SirenaExchangeProcessor_fileRegisterFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_exchangeFileContentEmpty, (Object[])new Object[0]), (Object[])new Object[0]), null);
                        continue;
                    }
                    checkSum = MiscUtil.getCheckSum((byte[])content);
                    EntityStorage entityStorage = EntityStorage.get();
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"checkSum", (Object)checkSum));
                    if (entityStorage.search(this.getIndexClass(), query).getData().size() > 0) {
                        this.log.error(String.format("file %s is already registered", location));
                        this.addFakeDocument(user, exchangeFile, MessageHelper.createErrorMessage((String)Messages.SirenaExchangeProcessor_fileRegisterFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_exchangeFileAlreadyRegistered, (Object[])new Object[0]), (Object[])new Object[0]), null);
                        continue;
                    }
                }
                catch (Exception e) {
                    this.log.error(String.format("failed registering file %s", location), (Throwable)e);
                    this.addFakeDocument(user, exchangeFile, MessageHelper.createErrorMessage((String)Messages.SirenaExchangeProcessor_fileRegisterFailed, (String)this.getStackTrace(e), (Object[])new Object[0]), e);
                }
                EntityContainer container = new EntityContainer(SirenaXmlExchangeDocument.class);
                container.setCreatedBy(user);
                container.setModifiedBy(user);
                container.setCreated(new Date());
                container.setModified(new Date());
                SirenaXmlExchangeDocument sirenaXmlExchangeDocument = (SirenaXmlExchangeDocument)container.getEntity();
                sirenaXmlExchangeDocument.setCreated(exchangeFile.getCreated());
                sirenaXmlExchangeDocument.setCheckSum(checkSum);
                sirenaXmlExchangeDocument.setTitle(location);
                sirenaXmlExchangeDocument.setName(location);
                sirenaXmlExchangeDocument.setLocation(location);
                sirenaXmlExchangeDocument.setContent(sirenaData.getContent().getBytes("utf8"));
                sirenaXmlExchangeDocument.setType(exchangeFile.getType());
                sirenaXmlExchangeDocument.setContentType(ContentType.XML);
                sirenaXmlExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
                sirenaXmlExchangeDocument.getMessages().clear();
                sirenaXmlExchangeDocument.getMessages().addAll(sirenaData.getMessages());
                this.updateDocumentData(sirenaXmlExchangeDocument, sirenaData);
                container.getVersionInfo().setDataSource("sirena-exchange-processor");
                EntityStorage.get().save(container, true);
            }
            LogicalStorage.get().endUnitOfWork(managedSession, true);
            ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult = ParsersHelper.createOkRegistrationResult();
            return exchangeDocumentRegistrationResult;
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(managedSession);
        }
    }

    private List<SirenaData> createDataList(ExchangeFile file) throws Exception {
        ArrayList<SirenaData> sirenaDataList = new ArrayList<SirenaData>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(XUtil.createSource((InputStream)new ByteArrayInputStream(file.getContent()), (String)"utf8"));
        NodeList ticketNodeList = document.getElementsByTagName("TICKET");
        for (int i = 0; i < ticketNodeList.getLength(); ++i) {
            Element ticketElement = (Element)ticketNodeList.item(i);
            SirenaData sirenaData = this.createData(ticketElement);
            if (sirenaData == null) continue;
            sirenaDataList.add(sirenaData);
        }
        return sirenaDataList;
    }

    private SirenaData createData(Element ticketElement) throws Exception {
        HashSet<Message> messages = new HashSet<Message>();
        String type = XHelper.readString((Element)ticketElement, (String)"TYPE");
        if (type != null) {
            String mcoType;
            if (type.contains("TRAIN_TICKET")) {
                return this.createTicketData(ticketElement);
            }
            if (type.contains("EMD") && (mcoType = XHelper.readString((Element)ticketElement, (String)"MCO_TYPE")).contains("RAILWAY")) {
                return this.createEmdData(ticketElement);
            }
        }
        messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_productUnsupported, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_productWithTypeNotSupported, (Object[])new Object[]{type}), (Object[])new Object[0]));
        return null;
    }

    private SirenaData createTicketData(Element ticketElement) throws Exception {
        GdsName gds;
        String blankOwnerCode;
        ParsersHelper.SalesContextData salesContextData;
        ArrayList<Message> messages = new ArrayList<Message>();
        Date issueDate = null;
        String issueDateString = XHelper.readString((Element)ticketElement, (String)"DEALDATE");
        if (!TextUtil.isBlank((String)issueDateString)) {
            String issueTimeString = XHelper.readString((Element)ticketElement, (String)"DEALTIME");
            try {
                issueDate = !TextUtil.isBlank((String)issueTimeString) ? RailwayProductParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.getDateTimeFormat(), (String)(issueDateString + issueTimeString)) : RailwayProductParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.getDateFormat(), (String)issueDateString);
            }
            catch (ParseException e2) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_issueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        TransactionType transactionType = null;
        String transactionTypeCode = XHelper.readString((Element)ticketElement, (String)"TRANS_TYPE");
        if (!TextUtil.isBlank((String)transactionTypeCode) && (transactionType = this.getTransactionType(transactionTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_transactionTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_transactionTypeWithCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
        }
        ProductStatus status = ParsersHelper.getStatus(transactionType);
        String carrierNumber = null;
        String systemNumber = XHelper.readString((Element)ticketElement, (String)"TICKNUM");
        String providerSystemNumber = XHelper.readString((Element)ticketElement, (String)"EMD_NUM");
        if (providerSystemNumber != null) {
            if (providerSystemNumber.length() > 2) {
                carrierNumber = providerSystemNumber.substring(0, 3);
            }
            if (providerSystemNumber.length() > 3) {
                providerSystemNumber = providerSystemNumber.substring(3);
            }
        }
        String pnr = XHelper.readString((Element)ticketElement, (String)"PNR");
        String pnrLatin = XHelper.readString((Element)ticketElement, (String)"PNR_LAT");
        BigDecimal totalAmountAmount = null;
        String totalAmountString = XHelper.readString((Element)ticketElement, (String)"TOTAL");
        if (!TextUtil.isBlank((String)totalAmountString)) {
            try {
                totalAmountAmount = new BigDecimal(totalAmountString);
            }
            catch (NumberFormatException e3) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_totalAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal tariffAmountAmount = null;
        BigDecimal tariffVatAmount = null;
        String tariffVatAmountString = XHelper.readString((Element)ticketElement, (String)"FARE@vat_amount");
        if (!TextUtil.isBlank((String)tariffVatAmountString)) {
            try {
                tariffVatAmount = new BigDecimal(tariffVatAmountString);
            }
            catch (NumberFormatException e4) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_tariffVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal tariffVatRate = null;
        tariffVatRate = BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.FARE, (Date)issueDate));
        BigDecimal insuranceAmount = null;
        String insuranceAmountString = XHelper.readString((Element)ticketElement, (String)"INSURANCE");
        if (!TextUtil.isBlank((String)insuranceAmountString)) {
            try {
                insuranceAmount = new BigDecimal(insuranceAmountString);
            }
            catch (NumberFormatException e5) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_insuranceAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        ArrayList<RailwayTax> taxes = new ArrayList<RailwayTax>();
        if (insuranceAmount != null && insuranceAmount.compareTo(BigDecimal.ZERO) > 0) {
            RailwayTax tax = new RailwayTax();
            tax.setCode(INSURANCE_TAX_CODE);
            Money insuranceTaxFare = new Money();
            insuranceTaxFare.setValue(insuranceAmount);
            insuranceTaxFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            tax.setFare(insuranceTaxFare);
            tax.setEquivalentFare(insuranceAmount);
            taxes.add(tax);
        }
        BigDecimal serviceAmountAmount = null;
        String serviceAmountAmountString = XHelper.readString((Element)ticketElement, (String)"SERVICES");
        if (!TextUtil.isBlank((String)serviceAmountAmountString)) {
            try {
                serviceAmountAmount = new BigDecimal(serviceAmountAmountString);
            }
            catch (NumberFormatException e6) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_serviceAmountAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal serviceVatAmount = null;
        String serviceVatAmountString = XHelper.readString((Element)ticketElement, (String)"SERVICES@vat_amount");
        if (!TextUtil.isBlank((String)serviceVatAmountString)) {
            try {
                serviceVatAmount = new BigDecimal(serviceVatAmountString);
            }
            catch (NumberFormatException e7) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_serviceVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal serviceVatRate = null;
        serviceVatRate = BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.SERVICE, (Date)issueDate));
        if (serviceVatAmount != null && serviceVatRate != null && serviceVatRate.compareTo(BigDecimal.ZERO) != 0) {
            serviceAmountAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(serviceVatAmount.doubleValue() / serviceVatRate.doubleValue() * (100.0 + serviceVatRate.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
        }
        if (status == ProductStatus.SELL) {
            tariffVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffVatAmount, MiscUtil.negate((BigDecimal)serviceVatAmount)});
        }
        BigDecimal penaltyVatAmount = null;
        String penaltyVatAmountString = XHelper.readString((Element)ticketElement, (String)"TOTAL@refund_tax_vat_amount");
        if (!TextUtil.isBlank((String)penaltyVatAmountString)) {
            try {
                penaltyVatAmount = new BigDecimal(penaltyVatAmountString);
            }
            catch (NumberFormatException e8) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_penaltyVatAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        BigDecimal penaltyVatRate = null;
        penaltyVatRate = BigDecimal.valueOf(RailwayProductHelper.getVatRate((VatBasisType)VatBasisType.PENALTY, (Date)issueDate));
        BigDecimal penaltyAmountAmount = null;
        if (penaltyVatAmount != null && penaltyVatRate != null && penaltyVatRate.compareTo(BigDecimal.ZERO) != 0) {
            penaltyAmountAmount = MiscUtil.scale((BigDecimal)MiscUtil.round((BigDecimal)BigDecimal.valueOf(penaltyVatAmount.doubleValue() / penaltyVatRate.doubleValue() * (100.0 + penaltyVatRate.doubleValue())), (RoundingMode)RoundingMode.HALF_UP, (BigDecimal)BigDecimal.valueOf(0.1)), (int)2, (RoundingMode)RoundingMode.HALF_UP);
        }
        tariffAmountAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmountAmount, MiscUtil.negate((BigDecimal)serviceAmountAmount), MiscUtil.negate((BigDecimal)RailwayProductHelper.calculateTaxesFare(taxes)), penaltyAmountAmount});
        BigDecimal totalVatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffVatAmount, serviceVatAmount, MiscUtil.negate((BigDecimal)penaltyVatAmount)});
        VatDetalization vatDetalization = new VatDetalization();
        if (!MiscUtil.isZero((BigDecimal)tariffAmountAmount, (boolean)true) && tariffVatAmount != null && tariffVatRate != null || !MiscUtil.isZero((BigDecimal)serviceAmountAmount, (boolean)true) && serviceVatAmount != null && serviceVatRate != null || !MiscUtil.isZero((BigDecimal)penaltyAmountAmount, (boolean)true) && penaltyVatAmount != null && penaltyVatRate != null) {
            VatComponent vatComponent;
            vatDetalization.setDetalized(true);
            vatDetalization.getComponents().clear();
            if (!MiscUtil.isZero((BigDecimal)tariffAmountAmount, (boolean)true) && tariffVatAmount != null && tariffVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(tariffAmountAmount);
                vatComponent.setSum(tariffVatAmount);
                vatComponent.setRate(Double.valueOf(tariffVatRate.doubleValue()));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.FARE);
                vatDetalization.getComponents().add(vatComponent);
            }
            if (!MiscUtil.isZero((BigDecimal)serviceAmountAmount, (boolean)true) && serviceVatAmount != null && serviceVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(serviceAmountAmount);
                vatComponent.setSum(serviceVatAmount);
                vatComponent.setRate(Double.valueOf(serviceVatRate.doubleValue()));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.SERVICE);
                vatDetalization.getComponents().add(vatComponent);
            }
            if (!MiscUtil.isZero((BigDecimal)penaltyAmountAmount, (boolean)true) && penaltyVatAmount != null && penaltyVatRate != null) {
                vatComponent = new VatComponent();
                vatComponent.setBasis(penaltyAmountAmount);
                vatComponent.setSum(penaltyVatAmount);
                vatComponent.setRate(Double.valueOf(penaltyVatRate.doubleValue()));
                vatComponent.getBasisTypes().clear();
                vatComponent.getBasisTypes().add(VatBasisType.PENALTY);
                vatDetalization.getComponents().add(vatComponent);
            }
        }
        String inn = XHelper.readString((Element)ticketElement, (String)"CARRIER_VAT_ID");
        MessageContext ctx = new MessageContext();
        DictionaryReference<Principal> carrier = CommonRailwayParsersHelper.getCarrier(inn, ctx);
        messages.addAll(ctx.getMessagesReadOnly());
        String agencyCode = XHelper.readString((Element)ticketElement, (String)"DEAL@agency");
        String validatorCode = XHelper.readString((Element)ticketElement, (String)"DEAL@stamp");
        String pccCode = XHelper.readString((Element)ticketElement, (String)"DEAL@tap");
        String agentCode = null;
        String agentCodeString = XHelper.readString((Element)ticketElement, (String)"DEAL@disp");
        String pattern = "^.*?(\\d+)$";
        Matcher matcher = Pattern.compile(pattern).matcher(agentCodeString);
        if (matcher.matches()) {
            agentCode = matcher.group(1);
        }
        if ((salesContextData = ParsersHelper.getSalesContextData((String)PROVIDER_CODE, (String)(blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(gds = GdsName.SIRENA)), (String)agencyCode, (String)agentCode, (String)validatorCode, (String)pccCode, (GdsName)gds, (Date)issueDate, messages)).getAgent() == null && TextUtil.nonBlank((String)agentCode) && agentCode.length() < 4) {
            agentCode = TextUtil.fillLeft((String)agentCode, (char)'0', (int)4);
            salesContextData = ParsersHelper.getSalesContextData((String)PROVIDER_CODE, (String)blankOwnerCode, (String)agencyCode, (String)agentCode, (String)validatorCode, (String)pccCode, (GdsName)gds, (Date)issueDate, messages);
        }
        EntityReference blankOwner = salesContextData.getProvider();
        EntityReference provider = salesContextData.getBlankOwner();
        EntityReference supplier = salesContextData.getSupplier();
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        DictionaryReference blankType = ParsersHelper.getBlankType((String)BLANK_TYPE_CODE);
        ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
        if (totalAmountAmount != null) {
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            Money amount = new Money();
            amount.setValue(totalAmountAmount);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop.setAmount(amount);
            fop.setOperationDate(issueDate);
            fop.setAgent(agent);
            fops.add(fop);
        }
        ArrayList<RailwaySegment> segments = new ArrayList<RailwaySegment>();
        int i = 0;
        for (Element segmentElement : XmlUtil.getElements((Element)ticketElement, (String)"SEGMENTS/SEGMENT")) {
            Iterator arriveStationsIterator;
            RailwayStation arriveLocation;
            Iterator departureStationsIterator;
            RailwayStation departureLocation;
            Date departureDate = null;
            String departureDateString = XHelper.readString((Element)segmentElement, (String)"DEPDATE");
            if (!TextUtil.isBlank((String)departureDateString)) {
                String departureTimeString = XHelper.readString((Element)segmentElement, (String)"DEPTIME");
                try {
                    departureDate = !TextUtil.isBlank((String)departureTimeString) ? this.getDateTimeFormat().parse(departureDateString + departureTimeString) : this.getDateFormat().parse(issueDateString);
                }
                catch (ParseException e9) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_departureDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            RailwayStationReference departureStation = null;
            String departureStationName = XHelper.readString((Element)segmentElement, (String)"DEPPORT");
            Collection departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationName);
            if (departureLocations.isEmpty() && departureStationName.contains("(")) {
                departureStationName = departureStationName.substring(0, departureStationName.indexOf("(")).trim();
                departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationName);
            }
            if (departureLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
            if (departureLocation != null) {
                departureStation = departureLocation.toReference();
            } else {
                departureLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)departureStationName);
                if (departureLocations.size() > 1) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_departureStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
                RailwayStation railwayStation2 = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
                if (departureLocation != null) {
                    departureStation = departureLocation.toReference();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_departureStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameNotFound, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
            }
            Date arriveDate = null;
            String arriveDateString = XHelper.readString((Element)segmentElement, (String)"ARRDATE");
            if (!TextUtil.isBlank((String)arriveDateString)) {
                String arriveTimeString = XHelper.readString((Element)segmentElement, (String)"ARRTIME");
                try {
                    arriveDate = !TextUtil.isBlank((String)arriveTimeString) ? this.getDateTimeFormat().parse(arriveDateString + arriveTimeString) : this.getDateFormat().parse(issueDateString);
                }
                catch (ParseException e10) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_arriveDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            RailwayStationReference arriveStation = null;
            String arriveStationName = XHelper.readString((Element)segmentElement, (String)"ARRPORT");
            Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationName);
            if (arriveLocations.isEmpty() && arriveStationName.contains("(")) {
                arriveStationName = arriveStationName.substring(0, arriveStationName.indexOf("(")).trim();
                arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationName);
            }
            if (arriveLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation3 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
            if (arriveLocation != null) {
                arriveStation = arriveLocation.toReference();
            } else {
                arriveLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)arriveStationName);
                if (arriveLocations.size() > 1) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_arriveStationDefineAmbiguous, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameMultipleFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                }
                RailwayStation railwayStation4 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
                if (arriveLocation != null) {
                    arriveStation = arriveLocation.toReference();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_arriveStationDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_stationWithNameNotFound, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                }
            }
            String trainData = XHelper.readString((Element)segmentElement, (String)"TRAIN");
            pattern = "^([\\d]+)([\\D]*)$";
            matcher = Pattern.compile(pattern).matcher(trainData);
            String trainNumber = null;
            String slot = null;
            if (matcher.matches()) {
                trainNumber = matcher.group(1);
                slot = matcher.group(2);
            } else {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_trainDataDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_dataHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            String carriageNumber = XHelper.readString((Element)segmentElement, (String)"COACH@num");
            CarriageType carriageType = null;
            String carriageTypeCode = XHelper.readString((Element)segmentElement, (String)"COACH@type");
            if (!TextUtil.isBlank((String)carriageTypeCode) && (carriageType = this.getCarriageType(carriageTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_carriageTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_carriageTypeWithCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
            }
            ServiceClass serviceClass = null;
            String serviceClassCode = XHelper.readString((Element)segmentElement, (String)"CLASS");
            if (!TextUtil.isBlank((String)serviceClassCode) && (serviceClass = this.getServiceClass(serviceClassCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_serviceClassDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_serviceClassWithCodeNotSupported, (Object[])new Object[]{serviceClassCode}), (Object[])new Object[0]));
            }
            List places = Arrays.stream(XmlUtil.getElements((Element)segmentElement, (String)"SEATS/SEAT")).map(e -> XHelper.readString((Element)e, (String)".")).filter(TextUtil::nonBlank).collect(Collectors.toList());
            RailwaySegment segment = new RailwaySegment();
            segment.setNumber(i + 1);
            segment.setDepartureDate(departureDate);
            segment.setDepartureStation((DictionaryReference)departureStation);
            segment.setArriveDate(arriveDate);
            segment.setArriveStation((DictionaryReference)arriveStation);
            segment.setTrainNumber(trainNumber);
            segment.setSlot(slot);
            segment.setCarriageNumber(carriageNumber);
            segment.setCarriageType(carriageType);
            segment.setServiceClass(serviceClass);
            if (i == 0) {
                Money segmentTariffAmount = null;
                if (tariffAmountAmount != null) {
                    segmentTariffAmount = new Money();
                    segmentTariffAmount.setValue(tariffAmountAmount);
                    segmentTariffAmount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
                }
                segment.setFare(segmentTariffAmount);
                segment.setEquivalentFare(tariffAmountAmount);
                segment.setEquivalentVAT(tariffVatAmount);
            }
            segment.getPlaces().clear();
            segment.getPlaces().addAll(places);
            segments.add(segment);
            ++i;
        }
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        for (Element passengerElement : XmlUtil.getElements((Element)ticketElement, (String)"PASSENGERS/PASSENGER")) {
            Date birthDate;
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            String name = XHelper.readString((Element)passengerElement, (String)"FIO");
            String surName = XHelper.readString((Element)passengerElement, (String)"SURNAME");
            String firstName = XHelper.readString((Element)passengerElement, (String)"NAME");
            String gender = XHelper.readString((Element)passengerElement, (String)"GENDER");
            String citizenship = XHelper.readString((Element)passengerElement, (String)"CITIZENSHIP");
            String birthDateString = XHelper.readString((Element)passengerElement, (String)"BIRTH_DATE");
            Date date = birthDate = TextUtil.isBlank((String)birthDateString) ? null : new SimpleDateFormat("ddMMyyyy").parse(birthDateString);
            if (!TextUtil.isBlank((String)name)) {
                name = name.replaceAll("[\\d-]", "");
            }
            PassportType passportType = null;
            String passportNumber = null;
            String passportString = XHelper.readString((Element)passengerElement, (String)"PASS");
            if (!TextUtil.isBlank((String)passportString)) {
                String passportTypeCode;
                if (passportString.length() > 1 && (passportType = this.getPassportType(passportTypeCode = passportString.substring(0, 2))) == null) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_travellerPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
                }
                if (passportString.length() > 2) {
                    passportNumber = passportString.substring(2);
                }
            }
            passport.setType(passportType);
            passport.setNumber(passportNumber);
            TextUtil.splitFullName((String)name, (PersonalName)passport);
            if (TextUtil.isBlank((String)passport.getLastName()) && !TextUtil.isBlank((String)surName)) {
                passport.setLastName(surName);
            }
            if (TextUtil.isBlank((String)passport.getFirstName()) && !TextUtil.isBlank((String)firstName)) {
                passport.setFirstName(firstName);
            }
            if (TextUtil.isBlank((String)passport.getMiddleName())) {
                passport.setMiddleName(null);
            }
            passport.setBirthday(birthDate);
            if (TextUtil.isBlank((String)name)) {
                name = surName + " " + firstName;
            }
            traveller.setName(name);
            traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
            traveller.setPassport(passport);
            traveller.setBirthday(birthDate);
            if ("M".equals(gender)) {
                traveller.setGender(Gender.MALE);
                passport.setGender(Gender.MALE);
            } else if ("F".equals(gender)) {
                traveller.setGender(Gender.FEMALE);
                passport.setGender(Gender.FEMALE);
            }
            if (!TextUtil.isBlank((String)citizenship)) {
                Set citizenships = DictHelper.findCountryByCode((String)citizenship);
                if (!citizenships.isEmpty()) {
                    passport.setCitizenship((DictionaryReference)((Country)citizenships.iterator().next()).toReference());
                } else {
                    DictionaryReference countryRef = DictHelper.findCountryByName((String)citizenship);
                    if (countryRef != null) {
                        passport.setCitizenship(countryRef);
                    }
                }
            }
            travellers.add(traveller);
        }
        if (!travellers.isEmpty()) {
            Traveller contactPerson = (Traveller)travellers.get(0);
            for (Element contactElement : XmlUtil.getElements((Element)ticketElement, (String)"CONTACTS")) {
                String contact = XHelper.readString((Element)contactElement, (String)"CONTACT");
                if (!TextUtil.nonBlank((String)contact)) continue;
                Communication communication = new Communication();
                if (TextUtil.isValidEmailAddress((String)contact)) {
                    communication.setType(CommunicationType.EMAIL);
                } else if (ValidationUtil.isValidPhoneNumber((String)contact)) {
                    communication.setType(CommunicationType.CELL);
                }
                communication.setSense(contact);
                contactPerson.getCommunications().add(communication);
            }
        }
        SirenaData.ProductType productType = SirenaData.ProductType.TICKET;
        TicketType ticketType = TicketType.OWN;
        SirenaData data = new SirenaData();
        data.setProductType(productType);
        data.setContent(XUtil.toString((Element)ticketElement, (String)"utf8"));
        data.setGds(gds);
        data.setPnr(pnr);
        data.setPnrLatin(pnrLatin);
        data.setBlankOwner((EntityReference<Organization>)blankOwner);
        data.setProvider((EntityReference<Organization>)provider);
        data.setSupplier((EntityReference<Organization>)supplier);
        data.setAgency((EntityReference<Organization>)agency);
        data.setSubagency((EntityReference<Organization>)subagency);
        data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
        data.setAgent((EntityReference<Person>)agent);
        data.setTransactionType(transactionType);
        data.setStatus(status);
        data.setBlankType((DictionaryReference<BlankType>)blankType);
        data.setSystemNumber(systemNumber);
        data.setProviderSystemNumber(providerSystemNumber);
        data.setIssueDate(issueDate);
        data.setCarrierNumber(carrierNumber);
        data.setCarrier(carrier);
        data.setTicketType(ticketType);
        data.setValidatorCode(validatorCode);
        data.setPccCode(pccCode);
        data.setTariffAmountAmount(tariffAmountAmount);
        data.setTariffVatAmount(tariffVatAmount);
        data.setTariffVatRate(tariffVatRate);
        data.setServiceAmountAmount(serviceAmountAmount);
        data.setServiceVatAmount(serviceVatAmount);
        data.setServiceVatRate(serviceVatRate);
        data.setPenaltyAmountAmount(penaltyAmountAmount);
        data.setPenaltyVatAmount(penaltyVatAmount);
        data.setPenaltyVatRate(penaltyVatRate);
        data.setTotalAmountAmount(totalAmountAmount);
        data.setTotalVatAmount(totalVatAmount);
        data.setVatDetalization(vatDetalization);
        data.getTravellers().clear();
        data.getTravellers().addAll(travellers);
        data.getSegments().clear();
        data.getSegments().addAll(segments);
        data.getTaxes().clear();
        data.getTaxes().addAll(taxes);
        data.getFops().clear();
        data.getFops().addAll(fops);
        data.getMessages().clear();
        data.getMessages().addAll(messages);
        return data;
    }

    private SirenaData createEmdData(Element ticketElement) throws Exception {
        GdsName gds;
        String blankOwnerCode;
        ParsersHelper.SalesContextData salesContextData;
        ArrayList<Message> messages = new ArrayList<Message>();
        Date issueDate = null;
        String issueDateString = XHelper.readString((Element)ticketElement, (String)"DEALDATE");
        if (!TextUtil.isBlank((String)issueDateString)) {
            String issueTimeString = XHelper.readString((Element)ticketElement, (String)"DEALTIME");
            try {
                issueDate = !TextUtil.isBlank((String)issueTimeString) ? RailwayProductParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.getDateTimeFormat(), (String)(issueDateString + issueTimeString)) : RailwayProductParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.getDateFormat(), (String)issueDateString);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_issueDateDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        TransactionType transactionType = null;
        String transactionTypeCode = XHelper.readString((Element)ticketElement, (String)"TRANS_TYPE");
        if (!TextUtil.isBlank((String)transactionTypeCode) && (transactionType = this.getTransactionType(transactionTypeCode)) == null) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_transactionTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_transactionTypeWithCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
        }
        ProductStatus status = ParsersHelper.getStatus(transactionType);
        String carrierNumber = null;
        String providerNumber = null;
        String providerNumberString = XHelper.readString((Element)ticketElement, (String)"BSONUM");
        if (providerNumberString != null) {
            if (providerNumberString.length() > 2) {
                carrierNumber = providerNumberString.substring(0, 3);
            }
            if (providerNumberString.length() > 3) {
                providerNumber = providerNumberString.substring(3);
            }
        }
        String pnr = XHelper.readString((Element)ticketElement, (String)"PNR");
        String pnrLatin = XHelper.readString((Element)ticketElement, (String)"PNR_LAT");
        String agencyCode = XHelper.readString((Element)ticketElement, (String)"DEAL@agency");
        String validatorCode = XHelper.readString((Element)ticketElement, (String)"DEAL@stamp");
        String pccCode = XHelper.readString((Element)ticketElement, (String)"DEAL@tap");
        String agentCode = null;
        String agentCodeString = XHelper.readString((Element)ticketElement, (String)"DEAL@disp");
        String pattern = "^.*?(\\d+)$";
        Matcher matcher = Pattern.compile(pattern).matcher(agentCodeString);
        if (matcher.matches()) {
            agentCode = matcher.group(1);
        }
        if ((salesContextData = ParsersHelper.getSalesContextData((String)PROVIDER_CODE, (String)(blankOwnerCode = CommonRailwayParsersHelper.getBlankOwnerCode(gds = GdsName.SIRENA)), (String)agencyCode, (String)agentCode, (String)validatorCode, (String)pccCode, (GdsName)gds, (Date)issueDate, messages)).getAgent() == null && TextUtil.nonBlank((String)agentCode) && agentCode.length() < 4) {
            agentCode = TextUtil.fillLeft((String)agentCode, (char)'0', (int)4);
            salesContextData = ParsersHelper.getSalesContextData((String)PROVIDER_CODE, (String)blankOwnerCode, (String)agencyCode, (String)agentCode, (String)validatorCode, (String)pccCode, (GdsName)gds, (Date)issueDate, messages);
        }
        EntityReference blankOwner = salesContextData.getProvider();
        EntityReference provider = salesContextData.getBlankOwner();
        EntityReference supplier = salesContextData.getSupplier();
        EntityReference agency = salesContextData.getAgency();
        EntityReference subagency = salesContextData.getSubagency();
        EntityReference salesPoint = salesContextData.getSalesPoint();
        EntityReference agent = salesContextData.getAgent();
        DictionaryReference blankType = ParsersHelper.getBlankType((String)BLANK_TYPE_CODE);
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        Traveller traveller = new Traveller();
        Passport passport = new Passport();
        String lastName = XHelper.readString((Element)ticketElement, (String)"SURNAME");
        String firstName = XHelper.readString((Element)ticketElement, (String)"NAME");
        if (!TextUtil.isBlank((String)lastName)) {
            lastName = lastName.replaceAll("[\\d-]", "");
        }
        if (TextUtil.isBlank((String)lastName)) {
            lastName = null;
        }
        if (!TextUtil.isBlank((String)firstName)) {
            firstName = firstName.replaceAll("[\\d-]", "");
        }
        if (TextUtil.isBlank((String)firstName)) {
            firstName = null;
        }
        PassportType passportType = null;
        String passportNumber = null;
        String passportString = XHelper.readString((Element)ticketElement, (String)"PASS");
        if (!TextUtil.isBlank((String)passportString)) {
            String passportTypeCode;
            if (passportString.length() > 1 && (passportType = this.getPassportType(passportTypeCode = passportString.substring(0, 2))) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_travellerPassportTypeDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_passportTypeWithCodeNotSupported, (Object[])new Object[]{passportTypeCode}), (Object[])new Object[0]));
            }
            if (passportString.length() > 2) {
                passportNumber = passportString.substring(2);
            }
        }
        String citizenshipString = XHelper.readString((Element)ticketElement, (String)"CITIZENSHIP");
        Object citizenship = null;
        if (!TextUtil.isBlank((String)citizenshipString)) {
            Set citizenships = DictHelper.findCountryByCode((String)citizenshipString);
            citizenship = !citizenships.isEmpty() ? ((Country)citizenships.iterator().next()).toReference() : DictHelper.findCountryByName((String)citizenshipString);
        }
        String genderString = XHelper.readString((Element)ticketElement, (String)"GENDER");
        Gender gender = null;
        if ("M".equals(genderString)) {
            gender = Gender.MALE;
        } else if ("F".equals(genderString)) {
            gender = Gender.FEMALE;
        }
        passport.setType(passportType);
        passport.setNumber(passportNumber);
        passport.setLastName(lastName);
        passport.setFirstName(firstName);
        passport.setCitizenship(citizenship);
        passport.setGender(gender);
        String name = TextUtil.join((String)" ", Arrays.asList(lastName, firstName), (boolean)true);
        traveller.setName(name);
        traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
        traveller.setGender(gender);
        traveller.setPassport(passport);
        travellers.add(traveller);
        BigDecimal totalAmount = null;
        for (Element fopElement : XmlUtil.getElements((Element)ticketElement, (String)"FOPS/FOP")) {
            String amountString = XHelper.readString((Element)fopElement, (String)"AMOUNT");
            if (TextUtil.isBlank((String)amountString)) continue;
            try {
                totalAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, new BigDecimal(amountString)});
            }
            catch (NumberFormatException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SirenaExchangeProcessor_totalAmountDefineFailed, (String)L10nResourcesManager.getStr((String)Messages.SirenaExchangeProcessor_amountNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
        ArrayList<RailwayProductFop> fops = new ArrayList<RailwayProductFop>();
        if (totalAmount != null) {
            RailwayProductFop fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            Money amount = new Money();
            amount.setValue(totalAmount);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop.setAmount(amount);
            fop.setOperationDate(issueDate);
            fop.setAgent(agent);
            fops.add(fop);
        }
        SirenaData.ProductType productType = SirenaData.ProductType.EMD;
        TicketType ticketType = TicketType.OWN;
        SirenaData data = new SirenaData();
        data.setProductType(productType);
        data.setContent(XUtil.toString((Element)ticketElement, (String)"utf8"));
        data.setGds(gds);
        data.setPnr(pnr);
        data.setPnrLatin(pnrLatin);
        data.setBlankOwner((EntityReference<Organization>)blankOwner);
        data.setProvider((EntityReference<Organization>)provider);
        data.setSupplier((EntityReference<Organization>)supplier);
        data.setAgency((EntityReference<Organization>)agency);
        data.setSubagency((EntityReference<Organization>)subagency);
        data.setSalesPoint((EntityReference<SalesPoint>)salesPoint);
        data.setAgent((EntityReference<Person>)agent);
        data.setTransactionType(transactionType);
        data.setStatus(status);
        data.setBlankType((DictionaryReference<BlankType>)blankType);
        data.setSystemNumber(providerNumber);
        data.setIssueDate(issueDate);
        data.setCarrierNumber(carrierNumber);
        data.setTicketType(ticketType);
        data.setValidatorCode(validatorCode);
        data.setPccCode(pccCode);
        data.setTotalAmountAmount(totalAmount);
        data.getTravellers().clear();
        data.getTravellers().addAll(travellers);
        data.getFops().clear();
        data.getFops().addAll(fops);
        data.getMessages().clear();
        data.getMessages().addAll(messages);
        return data;
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat("ddMMyyyy");
    }

    private DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("ddMMyyyyHHmm");
    }

    private void updateDocumentData(SirenaXmlExchangeDocument index, SirenaData sirenaData) {
        index.setPNR(sirenaData.getPnr());
        index.setLatinPNR(sirenaData.getPnrLatin());
        index.setTicketNumber(sirenaData.getSystemNumber() == null ? sirenaData.getProviderSystemNumber() : sirenaData.getSystemNumber());
        index.setTransactionType(sirenaData.getTransactionType());
        index.setOperationDate(sirenaData.getIssueDate());
        index.setDocumentType(SirenaXmlExchangeDocumentType.RAILWAY);
        StringBuilder travellerNames = new StringBuilder();
        for (Traveller traveller : sirenaData.getTravellers()) {
            if (travellerNames.length() > 0) {
                travellerNames.append(", ");
            }
            travellerNames.append(traveller.getName());
        }
        index.setTravellerName(travellerNames.toString());
    }

    private CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    private ServiceClass getServiceClass(String serviceClassCode) {
        if (!TextUtil.isBlank((String)serviceClassCode)) {
            return RzdServiceConverter.getServiceClassByName(serviceClassCode);
        }
        return null;
    }

    private TransactionType getTransactionType(String transactionTypeCode) {
        if (!TextUtil.isBlank((String)transactionTypeCode)) {
            if (transactionTypeCode.equals("SALE")) {
                return TransactionType.SELL;
            }
            if (transactionTypeCode.equals("REFUND")) {
                return TransactionType.REFUND;
            }
        }
        return null;
    }

    private PassportType getPassportType(String passportTypeCode) {
        if (!TextUtil.isBlank((String)passportTypeCode)) {
            if (passportTypeCode.equals("\u041f\u041d")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0417\u041f")) {
                return PassportType.FOREIGN;
            }
            if (passportTypeCode.equals("\u0421\u041f")) {
                return PassportType.SERVICE_PASSPORT;
            }
            if (passportTypeCode.equals("\u0414\u041f")) {
                return PassportType.DIPLOMATIC;
            }
            if (passportTypeCode.equals("\u041f\u0421")) {
                return PassportType.INTERNAL;
            }
            if (passportTypeCode.equals("\u0421\u0420")) {
                return PassportType.BIRTHDAY_NOTIFICATION;
            }
            if (passportTypeCode.equals("\u0412\u0411")) {
                return PassportType.MILITARYID;
            }
            if (passportTypeCode.equals("\u0423\u0412")) {
                return PassportType.MILITARYCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0417\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0411\u0413")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0412\u0416")) {
                return PassportType.RESIDENCEPERMIT;
            }
            if (passportTypeCode.equals("\u0421\u0423")) {
                return PassportType.PASSPORTLOSSCERTIFICATE;
            }
            if (passportTypeCode.equals("\u0421\u0412")) {
                return PassportType.BACKTOUSSRCERTIFICATE;
            }
            if (passportTypeCode.equals("\u041f\u041c")) {
                return PassportType.SEAMANSID;
            }
            if (passportTypeCode.equals("\u0421\u041e")) {
                return PassportType.CERTIFICATEOFRELEASE;
            }
            if (passportTypeCode.equals("\u041f\u0411")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0417\u041c")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0423")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u041a")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0422")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u041f\u0417")) {
                return PassportType.PASSPORT;
            }
            if (passportTypeCode.equals("\u0423\u041b")) {
                return PassportType.IDENTITYCARD;
            }
            if (passportTypeCode.equals("\u0418\u0418")) {
                return PassportType.IDENTITYCARD;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTrace(Exception e) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            String string = baos.toString("utf-8");
            return string;
        }
    }

    private void addFakeDocument(String user, ExchangeFile file, Message message, Exception e) {
        EntityContainer container = new EntityContainer(SirenaXmlExchangeDocument.class);
        container.setCreatedBy(user);
        container.setModifiedBy(user);
        container.setCreated(new Date());
        container.setModified(new Date());
        SirenaXmlExchangeDocument document = (SirenaXmlExchangeDocument)container.getEntity();
        document.setCreated(file.getCreated());
        document.setCheckSum(null);
        document.setLocation(file.getLocation());
        document.setContent(file.getContent());
        document.setType(file.getType());
        document.setStatus(ExceptionUtil.isInterruptedError((Throwable)e) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
        document.setContentType(ContentType.XML);
        document.getMessages().clear();
        document.getMessages().add(message);
        this.logErrorMessage(message, file.getLocation());
        EntityStorage.get().save(container, true);
    }

    private void logErrorMessage(Message message, String fileName) {
        String errorString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.error(String.format("File \"%s\" was processed with error:\n%s", fileName, errorString));
            return;
        }
        this.log.error(String.format("File \"%s\" was processed with error:\n%s\nDetails: %s", fileName, errorString, message.getDetails()));
    }

    private void logWarningMessage(Message message, String fileName) {
        String warningString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.warn(String.format("File \"%s\" was processed with warning:\n%s", fileName, warningString));
            return;
        }
        this.log.debug(String.format("File \"%s\" was processed with warning:\n%s\nDetails: %s", fileName, warningString, message.getDetails()));
    }

    private void saveBookingFile(ProductSearchResult result) {
        EntityContainer container = result.getBookingFile();
        container.getVersionInfo().setDataSource("sirena-exchange-processor");
        EntityStorage.get().save(container, true);
    }

    public SirenaXmlExchangeDocumentType getSirenaXmlExchangeDocumentType() {
        return SirenaXmlExchangeDocumentType.RAILWAY;
    }

    public double getPriority() {
        return 4.0;
    }
}

