/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.spgd;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dbf.DbfFile;
import com.gridnine.xtrip.common.model.dbf.DbfRow;
import com.gridnine.xtrip.common.model.dbf.DbfUtil;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.parsers.BaseExchangeProcessor;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.parsers.ssod.common.BaseTicketTransactionDataProcessor;
import com.gridnine.xtrip.server.railway.parsers.spgd.SPGDArchiveData;
import com.linuxense.javadbf.DBFField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class SPGDArchiveExchangeProcessor
extends BaseExchangeProcessor<SPGDArchiveExchangeDocument> {
    public static final String STORE_ENCODING = "utf8";
    private static final String SYSTEM_NUMBER = "coup_num";
    private static final String TRANSACTION_TYPE = "rec_type";
    private static final String AGENCY_CODE = "avs_code";
    private static final String VALIDATOR_CODE = "kass";
    private static final String ISSUE_DATE = "sale_date";
    private static final String CARRIER_CODE = "ak_code";
    private static final String EQUIVALENT_FARE = "tar";
    private static final String TCH_FEE = "tax_tch";

    protected Class<? extends EntityIndex<SPGDArchiveExchangeDocument>> getIndexClass() {
        return SPGDArchiveExchangeDocumentIndex.class;
    }

    public String getType() {
        return "SPGD_ARCHIVE";
    }

    public void processExchangeFile(SPGDArchiveExchangeDocument document) throws Exception {
    }

    public ExchangeDocumentRegistrationResult registerExchangeFile(final ExchangeFile exchangeFile) throws Exception {
        this.log.debug(String.format("registering exchange file %s", exchangeFile.getLocation()));
        ObjectFactory<SPGDArchiveData> spgdArchiveDataFactory = new ObjectFactory<SPGDArchiveData>(){

            public SPGDArchiveData createObject() {
                return new SPGDArchiveData();
            }
        };
        ObjectFactory<EntityContainer<SPGDArchiveExchangeDocument>> spgdExchangeDocumentFactory = new ObjectFactory<EntityContainer<SPGDArchiveExchangeDocument>>(){

            public EntityContainer<SPGDArchiveExchangeDocument> createObject() {
                EntityContainer result = new EntityContainer(SPGDArchiveExchangeDocument.class);
                ((SPGDArchiveExchangeDocument)result.getEntity()).setType(exchangeFile.getType());
                return result;
            }
        };
        return this.registerExchangeFile(exchangeFile, spgdArchiveDataFactory, spgdExchangeDocumentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile exchangeFile, ObjectFactory<SPGDArchiveData> spgdArchiveDataFactory, ObjectFactory<EntityContainer<SPGDArchiveExchangeDocument>> spgdArchiveExchangeDocumentFactory) throws Exception {
        ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult;
        if (exchangeFile == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        String user = LogicalStorage.get().getUser();
        String location = exchangeFile.getLocation();
        String checkSum = null;
        byte[] content = exchangeFile.getContent();
        if (content == null) {
            this.log.error(String.format("content of file %s is empty", location));
            this.addFakeDocument(spgdArchiveExchangeDocumentFactory, user, exchangeFile, "SsodParser_ContentIsEmpty", null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        checkSum = MiscUtil.getCheckSum((byte[])content);
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"checkSum", (Object)checkSum));
        if (entityStorage.search(this.getIndexClass(), query).getData().size() > 0) {
            this.log.error(String.format("file %s is already registered", location));
            this.addFakeDocument(spgdArchiveExchangeDocumentFactory, user, exchangeFile, "SsodParser_FileAlreadyRegistered", null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        List<SPGDArchiveData> spgdArchiveDataList = this.createDataList(exchangeFile, spgdArchiveDataFactory);
        if (spgdArchiveDataList == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        LogicalSession managedSession = LogicalStorage.get().beginUnitOfWork();
        try {
            for (SPGDArchiveData spgdArchiveData : spgdArchiveDataList) {
                EntityContainer container = (EntityContainer)spgdArchiveExchangeDocumentFactory.createObject();
                container.setCreatedBy(user);
                container.setModifiedBy(user);
                container.setCreated(new Date());
                container.setModified(new Date());
                SPGDArchiveExchangeDocument spgdArchiveExchangeDocument = (SPGDArchiveExchangeDocument)container.getEntity();
                spgdArchiveExchangeDocument.setCreated(exchangeFile.getCreated());
                spgdArchiveExchangeDocument.setCheckSum(checkSum);
                spgdArchiveExchangeDocument.setLocation(location);
                spgdArchiveExchangeDocument.setContent(spgdArchiveData.getContent().getBytes(STORE_ENCODING));
                spgdArchiveExchangeDocument.setContentType(ContentType.BINARY);
                spgdArchiveExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
                spgdArchiveExchangeDocument.getMessages().clear();
                spgdArchiveExchangeDocument.getMessages().addAll(spgdArchiveData.getMessages());
                this.updateDocumentData(spgdArchiveExchangeDocument, spgdArchiveData);
                EntityStorage.get().save(container, true);
            }
            LogicalStorage.get().endUnitOfWork(managedSession, true);
            exchangeDocumentRegistrationResult = ParsersHelper.createOkRegistrationResult();
        }
        catch (Throwable throwable) {
            try {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
                throw throwable;
            }
            catch (Exception e) {
                this.log.error(String.format("failed registering file %s", location), (Throwable)e);
                this.addFakeDocument(spgdArchiveExchangeDocumentFactory, user, exchangeFile, Messages.ExpressExchangeProcessor_errorRegFile, e, new Object[0]);
                return ParsersHelper.createOkRegistrationResult();
            }
        }
        LogicalStorage.get().cancelUnitOfWork(managedSession);
        return exchangeDocumentRegistrationResult;
    }

    protected void updateDocumentData(SPGDArchiveExchangeDocument document, SPGDArchiveData spgdData) {
        document.setSystemNumber(spgdData.getSystemNumber());
        document.setTransactionType(spgdData.getTransactionType());
        String agencyCode = spgdData.getAgencyCode();
        EntityReference agency = null;
        if (agencyCode != null) {
            try {
                agency = BaseTicketTransactionDataProcessor.findAgencyByTchCode((String)agencyCode, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (agency == null) {
            document.getMessages().add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noAgency, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_agencyWithTKPCode, (Object[])new Object[]{agencyCode}), new Object[0]));
        }
        document.setAgency(agency);
        document.setValidatorCode(spgdData.getValidatorCode());
        document.setIssueDate(spgdData.getIssued());
        document.setCarrierCode(spgdData.getCarrierCode());
        document.setEquivalentFare(spgdData.getEquivalentFare());
        document.setTchFee(spgdData.getTchFee());
        document.setStatus(spgdData.getMessages().isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
    }

    protected List<SPGDArchiveData> createDataList(ExchangeFile file, ObjectFactory<SPGDArchiveData> spgdArchiveDataFactory) throws Exception {
        ArrayList<SPGDArchiveData> spgdArchiveDataList = new ArrayList<SPGDArchiveData>();
        ByteArrayInputStream is = new ByteArrayInputStream(file.getContent());
        DbfFile dbfFile = DbfUtil.read((InputStream)is);
        List dbfRows = dbfFile.getRows();
        List dbfFields = dbfFile.getFields();
        for (DbfRow dbfRow : dbfRows) {
            SPGDArchiveData spgdArchiveData = this.createData(dbfRow, dbfFields, spgdArchiveDataFactory);
            if (spgdArchiveData == null) continue;
            spgdArchiveDataList.add(spgdArchiveData);
        }
        return spgdArchiveDataList;
    }

    protected SPGDArchiveData createData(DbfRow dbfRow, List<DBFField> dbfFields, ObjectFactory<SPGDArchiveData> spgdArchiveDataFactory) throws Exception {
        SPGDArchiveData spgdArchiveData = null;
        HashSet<Message> messages = new HashSet<Message>();
        String content = dbfRow.getContent().toString();
        String systemNumber = null;
        TransactionType transactionType = null;
        String agencyCode = null;
        String validatorCode = null;
        Date issueDate = null;
        String carrierCode = null;
        BigDecimal equivalentFare = null;
        BigDecimal tchFee = null;
        for (DBFField dbfField : dbfFields) {
            Object value = dbfRow.getValue(dbfField);
            String fieldName = dbfField.getName().toLowerCase().trim();
            if (SYSTEM_NUMBER.equals(fieldName)) {
                if (value != null) {
                    if (!TextUtil.isBlank((String)value.toString()) && value instanceof Number) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance();
                        numberFormat.setGroupingUsed(false);
                        numberFormat.setMaximumFractionDigits(0);
                        systemNumber = numberFormat.format(((Number)value).doubleValue());
                        continue;
                    }
                    systemNumber = value.toString();
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noSystemNumber, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_numberFieldNpData, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (TRANSACTION_TYPE.equals(fieldName)) {
                if (value == null) continue;
                if (!TextUtil.isBlank((String)value.toString())) {
                    if (value instanceof Number) {
                        int transactionTypeCode = ((Number)value).intValue();
                        switch (transactionTypeCode) {
                            case 1: {
                                transactionType = TransactionType.SELL;
                                break;
                            }
                            case 3: {
                                transactionType = TransactionType.REFUND;
                                break;
                            }
                            case 8: {
                                transactionType = TransactionType.REFERENCE;
                                break;
                            }
                            default: {
                                transactionType = TransactionType.UNSUPPORTED;
                                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noTransactionType, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_transactionTypeCode, (Object[])new Object[]{transactionTypeCode}), new Object[0]));
                                break;
                            }
                        }
                        continue;
                    }
                    messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noTransactionType, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_fieldTypeTransaction, (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                systemNumber = value.toString();
                continue;
            }
            if (AGENCY_CODE.equals(fieldName)) {
                if (value != null) {
                    if (value instanceof String) {
                        agencyCode = (String)value;
                        continue;
                    }
                    agencyCode = value.toString();
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_codeAgencyNotDefined, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_agencyCodeField, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (VALIDATOR_CODE.equals(fieldName)) {
                if (value != null) {
                    if (value instanceof String) {
                        validatorCode = (String)value;
                        continue;
                    }
                    validatorCode = value.toString();
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_numberValidatorNotDefined, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_numberFieldValidator, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (ISSUE_DATE.equals(fieldName)) {
                if (value == null || TextUtil.isBlank((String)value.toString())) continue;
                if (value instanceof Date) {
                    issueDate = (Date)value;
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_dateTaxNotDefined, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_dateFieldFormattedIncorrectly, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (CARRIER_CODE.equals(fieldName)) {
                if (value != null) {
                    if (value instanceof String) {
                        carrierCode = (String)value;
                        continue;
                    }
                    carrierCode = value.toString();
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_codeCarrierNotDefined, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_carrierCodeField, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (EQUIVALENT_FARE.equals(fieldName)) {
                if (value != null && !TextUtil.isBlank((String)value.toString())) {
                    if (value instanceof Number) {
                        equivalentFare = BigDecimal.valueOf(((Number)value).doubleValue());
                        continue;
                    }
                    messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noRate, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_fieldRateIncorrectFormat, (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noRate, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_RateFieldNoContainData, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            if (!TCH_FEE.equals(fieldName)) continue;
            if (value != null && !TextUtil.isBlank((String)value.toString())) {
                if (value instanceof Number) {
                    tchFee = BigDecimal.valueOf(((Number)value).doubleValue());
                    continue;
                }
                messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noTaxTKP, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_taxFieldTKPInvalidFormat, (Object[])new Object[0]), new Object[0]));
                continue;
            }
            messages.add(SPGDArchiveExchangeProcessor.createWarningMessage(Messages.SPGDArchiveExchangeProcessor_noTaxTKP, L10nResourcesManager.getStr((String)Messages.SPGDArchiveExchangeProcessor_taxFieldTKPnoContainData, (Object[])new Object[0]), new Object[0]));
        }
        spgdArchiveData = (SPGDArchiveData)spgdArchiveDataFactory.createObject();
        spgdArchiveData.setContent(content);
        spgdArchiveData.setSystemNumber(systemNumber);
        spgdArchiveData.setTransactionType(transactionType);
        spgdArchiveData.setAgencyCode(agencyCode);
        spgdArchiveData.setValidatorCode(validatorCode);
        spgdArchiveData.setIssued(issueDate);
        spgdArchiveData.setCarrierCode(carrierCode);
        spgdArchiveData.setEquivalentFare(equivalentFare);
        spgdArchiveData.setTchFee(tchFee);
        spgdArchiveData.getMessages().clear();
        spgdArchiveData.getMessages().addAll(messages);
        return spgdArchiveData;
    }

    private DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFakeDocument(ObjectFactory<EntityContainer<SPGDArchiveExchangeDocument>> spgdArchiveExchangeDocumentFactory, String user, ExchangeFile file, String key, Exception e, Object ... parameters) throws Exception {
        EntityContainer container = (EntityContainer)spgdArchiveExchangeDocumentFactory.createObject();
        container.setCreatedBy(user);
        container.setModifiedBy(user);
        container.setCreated(new Date());
        container.setModified(new Date());
        SPGDArchiveExchangeDocument index = (SPGDArchiveExchangeDocument)container.getEntity();
        index.setCreated(file.getCreated());
        index.setCheckSum(null);
        index.setLocation(file.getLocation());
        index.setContent(file.getContent());
        index.setStatus(ExceptionUtil.isInterruptedError((Throwable)e) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
        index.setContentType(ContentType.TEXT);
        Message message = SPGDArchiveExchangeProcessor.createErrorMessage(key, parameters);
        index.getMessages().add(message);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            message.setDetails(baos.toString("utf-8"));
        }
        EntityStorage.get().save(container, true);
        SPGDArchiveExchangeProcessor.logError((Message)message, (String)file.getLocation());
    }

    protected void logErorMessage(Message message, String fileName) {
        String errorString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.error(String.format("File \"%s\" was processed with error:\n%s", fileName, errorString));
            return;
        }
        this.log.error(String.format("File \"%s\" was processed with error:\n%s\nDetails: %s", fileName, errorString, message.getDetails()));
    }

    protected void logWarning(Message message, String fileName) {
        String warningString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.warn(String.format("File \"%s\" was processed with warning:\n%s", fileName, warningString));
            return;
        }
        this.log.debug(String.format("File \"%s\" was processed with warning:\n%s\nDetails: %s", fileName, warningString, message.getDetails()));
    }

    public static Message createMessage(String key, String details, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.MESSAGE, key, details, parameters);
    }

    public static Message createMessage(String key, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.MESSAGE, key, null, parameters);
    }

    public static Message createWarningMessage(String key, String details, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.WARNING, key, details, parameters);
    }

    public static Message createWarningMessage(String key, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.WARNING, key, null, parameters);
    }

    public static Message createErrorMessage(String key, String details, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.ERROR, key, details, parameters);
    }

    public static Message createErrorMessage(String key, Object ... parameters) {
        return SPGDArchiveExchangeProcessor.createMessage(MessageType.ERROR, key, null, parameters);
    }

    public static Message createMessage(MessageType type, String key, String details, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        message.setDetails(details);
        return message;
    }
}

