/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.railway.parsers.spgd;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.railway.l10n.Messages;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndex;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.parsers.BaseExchangeProcessor;
import com.gridnine.xtrip.server.parsers.helpers.ParsersHelper;
import com.gridnine.xtrip.server.railway.parsers.spgd.SPGDData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SPGDExchangeProcessor
extends BaseExchangeProcessor<SPGDExchangeDocument> {
    public static final String EXCHANGE_FILE_ENCODING = "cp1251";
    public static final String STORE_ENCODING = "utf8";
    private static final String RECORD_SEPARATOR = "\r\n";
    private static final String FIELD_SEPARATOR = ";";
    private static final int FIELDS_AMOUNT_MIN = 28;
    private static final int FIELDS_AMOUNT_MAX = 33;
    private static final String RAILWAY_PRODUCT_CODE = "81";
    private static final String BLANK_TYPE_CODE = "99A EMD";
    private static final String BLANK_OWNER_CODE = "\u04281";
    private static final String PROVIDER_CODE = "\u0423\u0424\u0421";
    private static final String CARRIER_NUMBER = "97A";
    private static final int PNR_DAYS_THRESHOLD = 14;

    protected Class<? extends EntityIndex<SPGDExchangeDocument>> getIndexClass() {
        return SPGDExchangeDocumentIndex.class;
    }

    public String getType() {
        return "SPGD";
    }

    public void processExchangeFile(SPGDExchangeDocument document) throws Exception {
        this.log.debug(String.format("processing exchange file %s document", document.getLocation()));
        document.setStatus(ProcessingStatus.UNPROCESSED);
        document.getMessages().clear();
        ObjectFactory<SPGDData> spgdDataFactory = new ObjectFactory<SPGDData>(){

            public SPGDData createObject() {
                return new SPGDData();
            }
        };
        this.processExchangeFile(document, spgdDataFactory);
    }

    protected void processExchangeFile(SPGDExchangeDocument document, ObjectFactory<SPGDData> spgdDataFactory) throws Exception {
        SPGDData spgdData = this.createData(new String(document.getContent(), STORE_ENCODING), spgdDataFactory);
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)spgdData.getTransactionType());
        if (status == ProductStatus.SELL) {
            this.processSellExchangeDocument(document, spgdData);
        } else if (status == ProductStatus.REFUND) {
            this.processRefundExchangeDocument(document, spgdData);
        }
    }

    private void processSellExchangeDocument(SPGDExchangeDocument document, SPGDData spgdData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)spgdData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.getBookingRecordLocatorSearchCriterion((String)spgdData.getPNR()));
            if (spgdData.getIssueDate() != null) {
                Date issueDateStart = new Date(spgdData.getIssueDate().getTime() - 1209600000L);
                Date issueDateEnd = new Date(spgdData.getIssueDate().getTime() + 1209600000L);
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateStart));
                query.getCriteria().getCriterions().add(SearchCriterion.le((String)BookingFileIndex.Property.issueDate.name(), (Object)issueDateEnd));
            }
            List bookingFileContainers = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(bf -> {
                Reservation res = BookingHelper.findReservation((BookingFile)((BookingFile)bf.getEntity()), (String)spgdData.getPNR());
                return res != null && (res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> ProductHandler.of((BaseProduct)p).getTicketType(p) != TicketType.CORRECTION));
            }).collect(Collectors.toList());
            EntityContainer bookingFileContainer = null;
            if (bookingFileContainers.size() == 0) {
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SPGD, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)spgdData.getPNR());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            } else {
                if (bookingFileContainers.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = (EntityContainer)bookingFileContainers.get(0);
            }
            RailwayProduct product = new RailwayProduct();
            this.updateProduct(product, spgdData, messages);
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, spgdData.getPNR(), messages);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(spgdData.getMessages());
            for (Message message : messages) {
                this.logWarning(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.SPGDExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_transactionImported, (Object[])new Object[]{spgdData.getTransactionType(), spgdData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            RailwayProductIndex index2 = (RailwayProductIndex)railwayProductIndexes.get(0);
            if (railwayProductIndexes.size() > 1) {
                // empty if block
            }
            if (index2.getStatus() == ProductStatus.SELL && index2.getTicketType() == TicketType.FAKE) {
                EntityContainer bookingFileContainer = EntityStorage.get().resolve(index2.getSource());
                RailwayProduct product = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index2.getSystemNumber(), ProductStatus.SELL);
                this.updateProduct(product, spgdData, messages);
                RailwayProduct refundProduct = product.getNextProduct();
                if (refundProduct != null && refundProduct.getStatus() == ProductStatus.REFUND) {
                    this.synchronizeSellAndRefundData(product, refundProduct);
                }
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, product, spgdData.getPNR(), messages);
                entityStorage.save(bookingFileContainer, true);
                messages.addAll(spgdData.getMessages());
                for (Message message : messages) {
                    this.logWarning(message, document.getLocation());
                }
                document.setOwner(bookingFileContainer.toReference());
                document.setRelatedBookingFile(bookingFileContainer.toReference());
                document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
                messages.add(MessageHelper.createMessage((String)Messages.SPGDExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_transactionImported, (Object[])new Object[]{spgdData.getTransactionType(), spgdData.getSystemNumber()}), (Object[])new Object[0]));
            } else {
                messages.add(MessageHelper.createErrorMessage((String)Messages.SPGDExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_ticketWithNumberExist, (Object[])new Object[]{spgdData.getSystemNumber()}), (Object[])new Object[0]));
                document.setStatus(ProcessingStatus.ERROR);
            }
        }
    }

    private void processRefundExchangeDocument(SPGDExchangeDocument document, SPGDData spgdData) throws Exception {
        List messages = document.getMessages();
        EntityStorage entityStorage = EntityStorage.get();
        document.setStatus(ProcessingStatus.UNPROCESSED);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)spgdData.getSystemNumber()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.REFUND), SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        List railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
        if (railwayProductIndexes.size() == 0) {
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.systemNumber.name(), (Object)spgdData.getSystemNumber()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)RailwayProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
            railwayProductIndexes = entityStorage.search(RailwayProductIndex.class, query).getData();
            EntityContainer bookingFileContainer = null;
            RailwayProduct sellProduct = null;
            if (railwayProductIndexes.size() > 0) {
                RailwayProductIndex index = (RailwayProductIndex)railwayProductIndexes.get(0);
                if (railwayProductIndexes.size() > 1) {
                    // empty if block
                }
                bookingFileContainer = EntityStorage.get().resolve(index.getSource());
                sellProduct = this.getProduct((EntityContainer<BookingFile>)bookingFileContainer, index.getSystemNumber(), ProductStatus.SELL);
                spgdData.setPNR(CommonReservationGdsNameInfoHelper.getRecordLocator((Reservation)sellProduct.getReservation(), (GdsName)GdsName.SPGD, (RecordLocatorType)RecordLocatorType.DEFAULT));
            }
            if (bookingFileContainer == null) {
                if (sellProduct == null) {
                    this.log.info(String.format("Refund ticket's PNR %s would be used for reservation because refund ticket was found before sell ticket", spgdData.getPNR()));
                }
                BookingFile bookingFile = new BookingFile();
                Reservation reservation = new Reservation();
                CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SPGD, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)spgdData.getPNR());
                reservation.setBookingFile(bookingFile);
                bookingFile.getReservations().add(reservation);
                bookingFileContainer = EntityContainer.create((BaseEntity)bookingFile);
            }
            RailwayProduct refundProduct = new RailwayProduct();
            this.updateProduct(refundProduct, spgdData, messages);
            if (sellProduct != null) {
                this.synchronizeSellAndRefundData(sellProduct, refundProduct);
            }
            this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, refundProduct, spgdData.getPNR(), messages);
            if (sellProduct == null) {
                sellProduct = new RailwayProduct();
                this.updateFakeProduct(sellProduct, spgdData, messages);
                this.updateBookingFile((EntityContainer<BookingFile>)bookingFileContainer, sellProduct, spgdData.getPNR(), messages);
            }
            refundProduct.setPreviousProduct(sellProduct);
            sellProduct.setNextProduct(refundProduct);
            entityStorage.save(bookingFileContainer, true);
            messages.addAll(spgdData.getMessages());
            for (Message message : messages) {
                this.logWarning(message, document.getLocation());
            }
            document.setOwner(bookingFileContainer.toReference());
            document.setRelatedBookingFile(bookingFileContainer.toReference());
            document.setStatus(messages.isEmpty() ? ProcessingStatus.OK : ProcessingStatus.WARNING);
            messages.add(MessageHelper.createMessage((String)Messages.SPGDExchangeProcessor_importCompleted, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_transactionImported, (Object[])new Object[]{spgdData.getTransactionType(), spgdData.getSystemNumber()}), (Object[])new Object[0]));
        } else {
            messages.add(MessageHelper.createErrorMessage((String)Messages.SPGDExchangeProcessor_importImpossible, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_ticketWithNumberExist, (Object[])new Object[]{spgdData.getSystemNumber()}), (Object[])new Object[0]));
            document.setStatus(ProcessingStatus.ERROR);
        }
    }

    private void synchronizeSellAndRefundData(RailwayProduct sellProduct, RailwayProduct refundProduct) throws Exception {
        int refundProductSegmentNumber;
        for (RailwaySegment sellProductSegment : sellProduct.getSegments()) {
            int sellProductSegmentNumber = sellProductSegment.getNumber();
            for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                int refundProductSegmentNumber2 = refundProductSegment.getNumber();
                if (refundProductSegmentNumber2 != sellProductSegmentNumber) continue;
                refundProductSegment.setFare(sellProductSegment.getFare());
                refundProductSegment.setEquivalentFare(sellProductSegment.getEquivalentFare());
                refundProductSegment.setEquivalentVAT(sellProductSegment.getEquivalentVAT());
            }
        }
        refundProduct.getReservedSeats().clear();
        for (ReservedSeat sellProductReservedSeat : sellProduct.getReservedSeats()) {
            ReservedSeat refundProductReservedSeat = (ReservedSeat)XCloneHelper.clone((XCloneable)sellProductReservedSeat);
            refundProductReservedSeat.setSegment(null);
            RailwaySegment sellProductReservedSeatSegment = sellProductReservedSeat.getSegment();
            if (sellProductReservedSeatSegment != null) {
                int sellProductReservedSeatSegmentNumber = sellProductReservedSeatSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductReservedSeatSegmentNumber) continue;
                    refundProductReservedSeat.setSegment(refundProductSegment);
                }
            }
            refundProduct.getReservedSeats().add(refundProductReservedSeat);
        }
        refundProduct.getTaxes().clear();
        for (RailwayTax sellProductTax : sellProduct.getTaxes()) {
            RailwayTax refundProductTax = (RailwayTax)XCloneHelper.clone((XCloneable)sellProductTax);
            refundProductTax.setSegment(null);
            RailwaySegment sellProductTaxSegment = sellProductTax.getSegment();
            if (sellProductTaxSegment != null) {
                int sellProductTaxSegmentNumber = sellProductTaxSegment.getNumber();
                for (RailwaySegment refundProductSegment : refundProduct.getSegments()) {
                    refundProductSegmentNumber = refundProductSegment.getNumber();
                    if (refundProductSegmentNumber != sellProductTaxSegmentNumber) continue;
                    refundProductTax.setSegment(refundProductSegment);
                }
            }
            refundProduct.getTaxes().add(refundProductTax);
        }
        refundProduct.setEquivalentFare(sellProduct.getEquivalentFare());
        refundProduct.setEquivalentVAT(sellProduct.getEquivalentVAT());
        refundProduct.setServiceFare(sellProduct.getServiceFare());
        refundProduct.setServiceVAT(sellProduct.getServiceVAT());
        BigDecimal sellTotalEquivalentFare = sellProduct.getTotalEquivalentFare();
        BigDecimal refundTotalEquivalentFare = refundProduct.getTotalEquivalentFare();
        BigDecimal penaltyFare = null;
        if (sellTotalEquivalentFare != null && refundTotalEquivalentFare != null) {
            penaltyFare = sellTotalEquivalentFare.subtract(refundTotalEquivalentFare);
        }
        BigDecimal penaltyVat = null;
        refundProduct.setPenalty(penaltyFare);
        refundProduct.setPenaltyVAT(penaltyVat);
        BigDecimal sellTotalEquivalentVat = sellProduct.getTotalEquivalentVAT();
        BigDecimal refundTotalEquivalentVat = null;
        if (sellTotalEquivalentVat != null) {
            refundTotalEquivalentVat = sellTotalEquivalentVat;
        }
        if (penaltyVat != null) {
            refundTotalEquivalentVat = refundTotalEquivalentVat == null ? penaltyVat.negate() : refundTotalEquivalentVat.subtract(penaltyVat);
        }
        refundProduct.setTotalEquivalentVAT(refundTotalEquivalentVat);
    }

    private void updateProduct(RailwayProduct product, SPGDData spgdData, List<Message> messages) throws Exception {
        RailwayProductFop fop;
        Money amount;
        RailwayProductFop fop2;
        Money amount2;
        ProductStatus status = RailwayProductParsersHelper.getStatus((TransactionType)spgdData.getTransactionType());
        String systemNumber = spgdData.getSystemNumber();
        String providerSystemNumber = spgdData.getProviderSystemNumber();
        Date issueDate = spgdData.getIssueDate();
        String validatorCode = spgdData.getValidatorCode();
        String agentCode = spgdData.getAgentCode();
        String pccCode = spgdData.getPccCode();
        String blankTypeCode = spgdData.getBlankTypeCode();
        String blankOwnerCode = spgdData.getBlankOwnerCode();
        String providerCode = spgdData.getProviderCode();
        String carrierNumber = spgdData.getCarrierNumber();
        TicketType ticketType = spgdData.getTicketType();
        List<Traveller> travellers = spgdData.getTravellers();
        DictionaryReference<BlankType> blankType = this.findBlankType(blankTypeCode);
        EntityReference blankOwner = null;
        OrganizationIndex blankOwnerIndex = this.findBlankOwner(blankOwnerCode, messages);
        if (blankOwnerIndex != null) {
            blankOwner = blankOwnerIndex.getSource();
        }
        EntityReference provider = null;
        OrganizationIndex providerIndex = this.findProvider(providerCode, messages);
        if (providerIndex != null) {
            provider = providerIndex.getSource();
        }
        EntityReference supplier = null;
        EntityReference agency = null;
        EntityReference subagency = null;
        EntityReference salesPoint = null;
        ValidatorIndex validatorIndex = this.findValidator(validatorCode, (EntityReference<Organization>)blankOwner, pccCode, issueDate, messages);
        if (validatorIndex != null) {
            supplier = validatorIndex.getSupplier();
            agency = validatorIndex.getAgency();
            subagency = validatorIndex.getSubagency();
            salesPoint = validatorIndex.getSource();
        }
        EntityReference agent = null;
        GdsReferenceIndex gdsReferenceIndex = this.findGdsReference(agentCode, issueDate, messages);
        if (gdsReferenceIndex != null) {
            agent = gdsReferenceIndex.getSource();
        }
        int number = 1;
        DictionaryReference<RailwayStation> departureStation = spgdData.getDepartureStation();
        DictionaryReference<RailwayStation> arriveStation = spgdData.getArriveStation();
        String trainNumber = spgdData.getTrainNumber();
        String slot = spgdData.getSlot();
        String carriageNumber = spgdData.getCarriageNumber();
        CarriageType carriageType = spgdData.getCarriageType();
        List<String> places = spgdData.getPlaces();
        Date departureDate = spgdData.getDepartureDate();
        BigDecimal equivalentSegmentFare = spgdData.getTariffFare();
        Money segmentFare = null;
        if (equivalentSegmentFare != null) {
            segmentFare = new Money();
            segmentFare.setValue(equivalentSegmentFare);
            segmentFare.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
        }
        RailwaySegment segment = new RailwaySegment();
        segment.setNumber(number);
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        segment.setTrainNumber(trainNumber);
        segment.setSlot(slot);
        segment.setCarriageNumber(carriageNumber);
        segment.setCarriageType(carriageType);
        segment.getPlaces().clear();
        segment.getPlaces().addAll(places);
        segment.setDepartureDate(departureDate);
        segment.setFare(segmentFare);
        segment.setEquivalentFare(equivalentSegmentFare);
        BigDecimal tariffFare = spgdData.getTariffFare();
        BigDecimal tariffVat = spgdData.getTariffVat();
        BigDecimal totalEquivalentFare = spgdData.getTariffFare();
        BigDecimal totalEquivalentVAT = spgdData.getTariffVat();
        BigDecimal tariffFareByCash = spgdData.getTariffFareByCash();
        BigDecimal tariffFareByCheck = spgdData.getTariffFareByCheck();
        BigDecimal totalFOPAmount = null;
        if (tariffFareByCash != null) {
            totalFOPAmount = tariffFareByCash;
        }
        if (tariffFareByCheck != null) {
            totalFOPAmount = totalFOPAmount != null ? totalFOPAmount.add(tariffFareByCheck) : tariffFareByCheck;
        }
        ArrayList<RailwayProductFop> vendorFOPs = new ArrayList<RailwayProductFop>();
        if (tariffFareByCash != null && (tariffFareByCash.compareTo(BigDecimal.ZERO) > 0 || tariffFareByCash.compareTo(BigDecimal.ZERO) == 0 && vendorFOPs.size() == 0 && (totalFOPAmount == null || totalFOPAmount.compareTo(BigDecimal.ZERO) == 0))) {
            amount2 = new Money();
            amount2.setValue(tariffFareByCash);
            amount2.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop2 = new RailwayProductFop();
            fop2.setType(PaymentType.CASH);
            fop2.setAmount(amount2);
            fop2.setOperationDate(null);
            fop2.setAgent(null);
            vendorFOPs.add(fop2);
        }
        if (tariffFareByCheck != null && (tariffFareByCheck.compareTo(BigDecimal.ZERO) > 0 || tariffFareByCheck.compareTo(BigDecimal.ZERO) == 0 && vendorFOPs.size() == 0 && (totalFOPAmount == null || totalFOPAmount.compareTo(BigDecimal.ZERO) == 0))) {
            amount2 = new Money();
            amount2.setValue(tariffFareByCheck);
            amount2.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop2 = new RailwayProductFop();
            fop2.setType(PaymentType.INVOICE);
            fop2.setAmount(amount2);
            fop2.setOperationDate(null);
            fop2.setAgent(null);
            vendorFOPs.add(fop2);
        }
        ArrayList<RailwayProductFop> clientFOPs = new ArrayList<RailwayProductFop>();
        if (tariffFareByCash != null && (tariffFareByCash.compareTo(BigDecimal.ZERO) > 0 || tariffFareByCash.compareTo(BigDecimal.ZERO) == 0 && clientFOPs.size() == 0 && (totalFOPAmount == null || totalFOPAmount.compareTo(BigDecimal.ZERO) == 0))) {
            amount = new Money();
            amount.setValue(tariffFareByCash);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop = new RailwayProductFop();
            fop.setType(PaymentType.CASH);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        if (tariffFareByCheck != null && (tariffFareByCheck.compareTo(BigDecimal.ZERO) > 0 || tariffFareByCheck.compareTo(BigDecimal.ZERO) == 0 && clientFOPs.size() == 0 && (totalFOPAmount == null || totalFOPAmount.compareTo(BigDecimal.ZERO) == 0))) {
            amount = new Money();
            amount.setValue(tariffFareByCheck);
            amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)"RUB"));
            fop = new RailwayProductFop();
            fop.setType(PaymentType.INVOICE);
            fop.setAmount(amount);
            fop.setOperationDate(null);
            fop.setAgent(null);
            clientFOPs.add(fop);
        }
        product.setStatus(status);
        product.setSystemNumber(systemNumber);
        product.setProviderSystemNumber(providerSystemNumber);
        product.setIssueDate(issueDate);
        product.setValidatorCode(validatorCode);
        SPGDExchangeProcessor.setValidatorRef(product, validatorCode);
        product.setPcc(pccCode);
        product.setEquivalentFare(tariffFare);
        product.setEquivalentVAT(tariffVat);
        product.setTotalEquivalentFare(totalEquivalentFare);
        product.setTotalEquivalentVAT(totalEquivalentVAT);
        product.getPassengers().clear();
        product.getPassengers().addAll(travellers);
        product.getPassengerTypes().clear();
        product.setBlankType(blankType);
        product.setBlankOwnerRef(blankOwner);
        product.setProvider(provider);
        product.setCarrierNumber(carrierNumber);
        product.getSegments().clear();
        product.getSegments().add(segment);
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        RailwayProductContractRelationData vendorContractRelation = RailwayProductHelper.getVendorContractRelation((RailwayProduct)product);
        vendorContractRelation.getFops().clear();
        vendorContractRelation.getFops().addAll(vendorFOPs);
        clientContractRelation.getFops().clear();
        clientContractRelation.getFops().addAll(clientFOPs);
        RailwayProductHelper.setSupplier((BaseTicketProduct)product, (EntityReference)supplier);
        RailwayProductHelper.setAgency((BaseTicketProduct)product, (EntityReference)agency);
        RailwayProductHelper.setSubagency((BaseTicketProduct)product, (EntityReference)subagency);
        product.setSalesPoint(salesPoint);
        product.setCashier(agent);
        product.setTicketType(ticketType);
    }

    private static void setValidatorRef(RailwayProduct product, String code) {
        if (TextUtil.isBlank((String)code)) {
            return;
        }
        ValidatorIndex validatorIndex = ValidatorHelper.getValidatorIndex((String)code, (EntityReference)product.getBlankOwnerRef(), (String)product.getPcc(), (Date)product.getIssueDate());
        if (validatorIndex != null) {
            product.setValidatorRef(new NestedEntityReference(validatorIndex.getSource(), validatorIndex.getNavigationKey(), Validator.class, null));
        }
    }

    private void updateFakeProduct(RailwayProduct product, SPGDData spgdData, List<Message> messages) {
        String systemNumber = spgdData.getSystemNumber();
        product.setSystemNumber(systemNumber);
        product.setStatus(ProductStatus.SELL);
        product.setTicketType(TicketType.FAKE);
    }

    private void updateBookingFile(EntityContainer<BookingFile> bookingFileContainer, RailwayProduct product, String pnr, List<Message> messages) throws Exception {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        boolean updatedProduct = false;
        block0: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!basePoduct.getUid().equals(product.getUid())) continue;
                updatedProduct = true;
                continue block0;
            }
        }
        boolean bookingFileContainsNonFakeSell = false;
        boolean bookingFileContainsNonFakeRefund = false;
        block2: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        bookingFileContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        bookingFileContainsNonFakeRefund = true;
                    }
                }
                if (!bookingFileContainsNonFakeSell || !bookingFileContainsNonFakeRefund) continue;
                continue block2;
            }
        }
        if (!bookingFileContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !bookingFileContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
            bookingFile.setAgency(RailwayProductHelper.getAgency((RailwayProduct)product));
            bookingFile.setCreateDate(product.getIssueDate());
        }
        for (Reservation reservation : bookingFile.getReservations()) {
            if (!CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)reservation, (String)pnr, (GdsName)GdsName.SPGD)) continue;
            boolean reservationContainsNonFakeSell = false;
            boolean reservationContainsNonFakeRefund = false;
            for (BaseProduct basePoduct : reservation.getProducts()) {
                if (!(basePoduct instanceof BaseTicketProduct)) continue;
                BaseTicketProduct baseTicketProduct = (BaseTicketProduct)basePoduct;
                if (!(baseTicketProduct.getTicketType() == TicketType.FAKE || updatedProduct && baseTicketProduct.getUid().equals(product.getUid()))) {
                    if (baseTicketProduct.getStatus() == ProductStatus.SELL) {
                        reservationContainsNonFakeSell = true;
                    } else if (baseTicketProduct.getStatus() == ProductStatus.REFUND) {
                        reservationContainsNonFakeRefund = true;
                    }
                }
                if (!reservationContainsNonFakeSell || !reservationContainsNonFakeRefund) continue;
                break;
            }
            if (!reservationContainsNonFakeSell && product.getTicketType() != TicketType.FAKE && (product.getStatus() == ProductStatus.SELL || !reservationContainsNonFakeRefund && product.getStatus() == ProductStatus.REFUND)) {
                reservation.setBookingAgent(product.getCashier());
                reservation.setSalesPoint(product.getSalesPoint());
                reservation.setSubagency(RailwayProductHelper.getSubagency((RailwayProduct)product));
                reservation.setResDate(product.getIssueDate());
            }
            List productTravellers = product.getPassengers();
            List bookingTravellers = bookingFile.getTravellers();
            ArrayList<Traveller> updatedProductTravellers = new ArrayList<Traveller>();
            for (Traveller productTraveller : productTravellers) {
                boolean contains = false;
                for (Traveller bookingTraveller : bookingTravellers) {
                    if (!this.compareTravellers(productTraveller, bookingTraveller)) continue;
                    contains = true;
                    updatedProductTravellers.add(bookingTraveller);
                    break;
                }
                if (contains) continue;
                updatedProductTravellers.add(productTraveller);
                bookingTravellers.add(productTraveller);
            }
            productTravellers.clear();
            productTravellers.addAll(updatedProductTravellers);
            if (updatedProduct) break;
            product.setReservation(reservation);
            reservation.getProducts().add(product);
            break;
        }
    }

    private RailwayProduct getProduct(EntityContainer<BookingFile> bookingFileContainer, String systemNumber, ProductStatus status) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayProduct product;
                if (!(baseProduct instanceof RailwayProduct) || !TextUtil.isSame((String)(product = (RailwayProduct)baseProduct).getSystemNumber(), (String)systemNumber) || product.getStatus() != status) continue;
                return product;
            }
        }
        return null;
    }

    protected boolean compareTravellers(Traveller traveller01, Traveller traveller02) {
        String fullName02;
        String fullName01;
        if (traveller01 == null && traveller02 == null) {
            return true;
        }
        if (traveller01 == null || traveller02 == null) {
            return false;
        }
        if (traveller01.getPassport() != null && traveller02.getPassport() != null) {
            fullName01 = TextUtil.buildFullName((PersonalName)traveller01.getPassport());
            fullName02 = TextUtil.buildFullName((PersonalName)traveller02.getPassport());
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        if (traveller01.getName() != null && traveller02.getName() != null) {
            fullName01 = traveller01.getName();
            fullName02 = traveller02.getName();
            if (!TextUtil.isBlank((String)fullName01) && !TextUtil.isBlank((String)fullName02)) {
                return TextUtil.isSame((String)fullName01, (String)fullName02, (boolean)true);
            }
        }
        return false;
    }

    private DictionaryReference<BlankType> findBlankType(String blankTypeCode) {
        BlankType blankType;
        if (Environment.isPublished(DictionaryCache.class) && (blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, blankTypeCode)) != null) {
            return blankType.toReference();
        }
        return null;
    }

    private OrganizationIndex findBlankOwner(String blankOwnerCode, List<Message> messages) throws Exception {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)blankOwnerCode));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        List blankOwnerIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (blankOwnerIndexes.size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_cantDefineBlankOwner, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_blankOwnerWithCode, (Object[])new Object[]{blankOwnerCode}), (Object[])new Object[0]));
            return null;
        }
        if (blankOwnerIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_blankOwnerMay, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_foundMoreOneBlankOwner, (Object[])new Object[]{blankOwnerCode}), (Object[])new Object[0]));
        }
        return (OrganizationIndex)blankOwnerIndexes.get(0);
    }

    private OrganizationIndex findProvider(String providerCode, List<Message> messages) throws Exception {
        if (TextUtil.isBlank((String)providerCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)providerCode));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()), SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name())}));
        List providerIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (providerIndexes.size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_cantDefineProvider, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_providerWithCode, (Object[])new Object[]{providerCode}), (Object[])new Object[0]));
            return null;
        }
        if (providerIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_providerMay, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_foundMoreOneProvider, (Object[])new Object[]{providerCode}), (Object[])new Object[0]));
        }
        return (OrganizationIndex)providerIndexes.get(0);
    }

    private ValidatorIndex findValidator(String validatorCode, EntityReference<Organization> blankOwner, String pccCode, Date date, List<Message> messages) throws Exception {
        List validatorIndexes = ValidatorHelper.getValidatorIndexes((String)validatorCode, blankOwner, (String)pccCode, (Date)date);
        if (validatorIndexes.size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_validatorNotDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_validatorWithnumber, (Object[])new Object[]{validatorCode, blankOwner, pccCode}), (Object[])new Object[0]));
            return null;
        }
        if (validatorIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_validatorMayDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_foundMoreOneValidator, (Object[])new Object[]{validatorCode, blankOwner, pccCode}), (Object[])new Object[0]));
        }
        return (ValidatorIndex)validatorIndexes.get(0);
    }

    private GdsReferenceIndex findGdsReference(String agentCode, Date date, List<Message> messages) throws Exception {
        List gdsReferenceIndexes;
        if (TextUtil.isBlank((String)agentCode)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)agentCode));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null)}));
        }
        if ((gdsReferenceIndexes = EntityStorage.get().search(GdsReferenceIndex.class, query).getData()).size() == 0) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_noAgent, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_noAgentWithReference, (Object[])new Object[]{agentCode}), (Object[])new Object[0]));
            return null;
        }
        if (gdsReferenceIndexes.size() > 1) {
            messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_agentMay, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_foundMoreOneAgent, (Object[])new Object[]{agentCode}), (Object[])new Object[0]));
        }
        return !gdsReferenceIndexes.isEmpty() ? (GdsReferenceIndex)gdsReferenceIndexes.get(0) : null;
    }

    public ExchangeDocumentRegistrationResult registerExchangeFile(final ExchangeFile exchangeFile) throws Exception {
        this.log.debug(String.format("registering exchange file %s", exchangeFile.getLocation()));
        ObjectFactory<SPGDData> spgdDataFactory = new ObjectFactory<SPGDData>(){

            public SPGDData createObject() {
                return new SPGDData();
            }
        };
        ObjectFactory<EntityContainer<SPGDExchangeDocument>> spgdExchangeDocumentFactory = new ObjectFactory<EntityContainer<SPGDExchangeDocument>>(){

            public EntityContainer<SPGDExchangeDocument> createObject() {
                EntityContainer result = new EntityContainer(SPGDExchangeDocument.class);
                ((SPGDExchangeDocument)result.getEntity()).setType(exchangeFile.getType());
                return result;
            }
        };
        return this.registerExchangeFile(exchangeFile, spgdDataFactory, spgdExchangeDocumentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile exchangeFile, ObjectFactory<SPGDData> spgdDataFactory, ObjectFactory<EntityContainer<SPGDExchangeDocument>> spgdExchangeDocumentFactory) throws Exception {
        ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult;
        if (exchangeFile == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        String user = LogicalStorage.get().getUser();
        String location = exchangeFile.getLocation();
        String checkSum = null;
        byte[] content = exchangeFile.getContent();
        if (content == null) {
            this.log.error(String.format("content of file %s is empty", location));
            this.addFakeDocument(spgdExchangeDocumentFactory, user, exchangeFile, "SsodParser_ContentIsEmpty", null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        checkSum = MiscUtil.getCheckSum((byte[])content);
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"checkSum", (Object)checkSum));
        if (entityStorage.search(this.getIndexClass(), query).getData().size() > 0) {
            this.log.error(String.format("file %s is already registered", location));
            this.addFakeDocument(spgdExchangeDocumentFactory, user, exchangeFile, "SsodParser_FileAlreadyRegistered", null, new Object[0]);
            return ParsersHelper.createOkRegistrationResult();
        }
        List<SPGDData> spgdDataList = this.createDataList(exchangeFile, spgdDataFactory);
        if (spgdDataList == null) {
            return ParsersHelper.createOkRegistrationResult();
        }
        LogicalSession managedSession = LogicalStorage.get().beginUnitOfWork();
        try {
            for (SPGDData spgdData : spgdDataList) {
                EntityContainer container = (EntityContainer)spgdExchangeDocumentFactory.createObject();
                container.setCreatedBy(user);
                container.setModifiedBy(user);
                container.setCreated(new Date());
                container.setModified(new Date());
                SPGDExchangeDocument spgdExchangeDocument = (SPGDExchangeDocument)container.getEntity();
                spgdExchangeDocument.setCreated(exchangeFile.getCreated());
                spgdExchangeDocument.setCheckSum(checkSum);
                spgdExchangeDocument.setTitle(location);
                spgdExchangeDocument.setLocation(location);
                spgdExchangeDocument.setContent(spgdData.getContent().getBytes(STORE_ENCODING));
                spgdExchangeDocument.setContentType(ContentType.TEXT);
                spgdExchangeDocument.setStatus(ProcessingStatus.UNPROCESSED);
                spgdExchangeDocument.getMessages().clear();
                spgdExchangeDocument.getMessages().addAll(spgdData.getMessages());
                this.updateDocumentData(spgdExchangeDocument, spgdData);
                EntityStorage.get().save(container, true);
            }
            LogicalStorage.get().endUnitOfWork(managedSession, true);
            exchangeDocumentRegistrationResult = ParsersHelper.createOkRegistrationResult();
        }
        catch (Throwable throwable) {
            try {
                LogicalStorage.get().cancelUnitOfWork(managedSession);
                throw throwable;
            }
            catch (Exception e) {
                this.log.error(String.format("failed registering file %s", location), (Throwable)e);
                this.addFakeDocument(spgdExchangeDocumentFactory, user, exchangeFile, Messages.SPGDExchangeProcessor_errorRegFile, e, new Object[0]);
                return ParsersHelper.createOkRegistrationResult();
            }
        }
        LogicalStorage.get().cancelUnitOfWork(managedSession);
        return exchangeDocumentRegistrationResult;
    }

    protected List<SPGDData> createDataList(ExchangeFile file, ObjectFactory<SPGDData> spgdDataFactory) throws Exception {
        String[] records;
        ArrayList<SPGDData> spgdDataList = new ArrayList<SPGDData>();
        String content = new String(file.getContent(), EXCHANGE_FILE_ENCODING);
        for (String record : records = content.split(RECORD_SEPARATOR)) {
            SPGDData spgdData = this.createData(record, spgdDataFactory);
            if (spgdData == null) continue;
            spgdDataList.add(spgdData);
        }
        return spgdDataList;
    }

    protected SPGDData createData(String content, ObjectFactory<SPGDData> spgdDataFactory) throws Exception {
        String providerSystemNumber;
        BigDecimal tariffVat;
        ArrayList<String> places;
        ArrayList<Traveller> travellers;
        BigDecimal tariffFareByCheck;
        BigDecimal tariffFareByCash;
        BigDecimal tariffFare;
        String systemNumber;
        CarriageType carriageType;
        String carriageNumber;
        Date arriveDate;
        Date departureDate;
        String slot;
        String trainNumber;
        RailwayStationReference arriveStation;
        RailwayStationReference departureStation;
        String pnr;
        String agentCode;
        Date issueDate;
        TransactionType transactionType;
        String pccCode;
        String validatorCode;
        HashSet<Message> messages;
        SPGDData spgdData = null;
        String[] fields = content.split(FIELD_SEPARATOR);
        if (fields.length >= 28 && fields.length <= 33) {
            Iterator arriveStationsIterator;
            RailwayStation arriveLocation;
            Iterator departureStationsIterator;
            RailwayStation departureLocation;
            if (fields.length > 32 && !TextUtil.isSame((String)fields[32], (String)RAILWAY_PRODUCT_CODE)) {
                return null;
            }
            messages = new HashSet<Message>();
            validatorCode = fields[0];
            pccCode = fields[1];
            transactionType = null;
            String transactionTypeCode = fields[2];
            if (!TextUtil.isBlank((String)transactionTypeCode)) {
                if (transactionTypeCode.equals("I")) {
                    transactionType = TransactionType.SELL;
                } else if (transactionTypeCode.equals("R")) {
                    transactionType = TransactionType.REFUND;
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_typeOperationNotSupported, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_typeOperationCodeNotSupported, (Object[])new Object[]{transactionTypeCode}), (Object[])new Object[0]));
                }
            }
            issueDate = null;
            try {
                issueDate = RailwayProductParsersHelper.parseIssueDateFromMoscowZone((DateFormat)this.getDateTimeFormat(), (String)fields[4]);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_dateTaxNotDefined, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            agentCode = fields[5];
            pnr = fields[6];
            String departureStationName = fields[14];
            departureStation = null;
            Collection departureLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)departureStationName);
            if (departureLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_departureStationMayWrong, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dictionaryMoreOne, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
            if (departureLocation != null) {
                departureStation = departureLocation.toReference();
            } else {
                departureLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)departureStationName);
                if (departureLocations.size() > 1) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_departureStationMayWrong, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dictionaryMoreOne, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
                RailwayStation railwayStation2 = departureLocation = (departureStationsIterator = departureLocations.iterator()).hasNext() ? (RailwayStation)departureStationsIterator.next() : null;
                if (departureLocation != null) {
                    departureStation = departureLocation.toReference();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_stationDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_stationWithAcronym, (Object[])new Object[]{departureStationName}), (Object[])new Object[0]));
                }
            }
            String arriveStationName = fields[15];
            arriveStation = null;
            Collection arriveLocations = RailwayProductDictionaryHelper.findStationsByShortName((String)arriveStationName);
            if (arriveLocations.size() > 1) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_destinationStationMay, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dictionaryMoreOne, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
            }
            RailwayStation railwayStation3 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
            if (arriveLocation != null) {
                arriveStation = arriveLocation.toReference();
            } else {
                arriveLocations = RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant((String)arriveStationName);
                if (arriveLocations.size() > 1) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_destinationStationMay, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dictionaryMoreOne, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                }
                RailwayStation railwayStation4 = arriveLocation = (arriveStationsIterator = arriveLocations.iterator()).hasNext() ? (RailwayStation)arriveStationsIterator.next() : null;
                if (arriveLocation != null) {
                    arriveStation = arriveLocation.toReference();
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_stationDestinationNotDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_stationWithAcronym, (Object[])new Object[]{arriveStationName}), (Object[])new Object[0]));
                }
            }
            String trainData = fields[16];
            trainNumber = trainData.substring(0, trainData.length() - 2);
            slot = trainData.substring(trainData.length() - 2, trainData.length());
            departureDate = null;
            try {
                departureDate = this.getDateTimeFormat().parse(fields[17]);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_dateDepartureNotDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            arriveDate = null;
            try {
                arriveDate = this.getDateTimeFormat().parse(fields[18]);
            }
            catch (ParseException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_dateArrivalNotDefine, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_dateHasWrongFormat, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            carriageNumber = fields[19];
            carriageType = null;
            String carriageTypeCode = fields[20];
            if (!TextUtil.isBlank((String)carriageTypeCode) && (carriageType = this.getCarriageType(carriageTypeCode)) == null) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_carriageTypeNotSupported, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_carriageTypeCodeNotSupported, (Object[])new Object[]{carriageTypeCode}), (Object[])new Object[0]));
            }
            systemNumber = fields[21];
            tariffFare = null;
            try {
                tariffFare = new BigDecimal(fields[22]);
            }
            catch (NumberFormatException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_priceCurrencyReport, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_costValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            tariffFareByCash = null;
            try {
                tariffFareByCash = new BigDecimal(fields[23]);
            }
            catch (NumberFormatException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_priceCurrencyPayment, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_costValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
            }
            tariffFareByCheck = null;
            try {
                tariffFareByCheck = new BigDecimal(fields[24]);
                if (tariffFareByCash != null) {
                    tariffFareByCash = tariffFareByCash.subtract(tariffFareByCheck);
                }
            }
            catch (NumberFormatException e) {
                messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_nonCashPortionPayment, (String)Messages.SPGDExchangeProcessor_costValueNotNumber, (Object[])new Object[0]));
            }
            travellers = new ArrayList<Traveller>();
            Traveller traveller = new Traveller();
            Passport passport = new Passport();
            String name = fields[26].replaceAll("[\\d-]", "");
            TextUtil.splitFullName((String)name, (PersonalName)passport);
            traveller.setName(name);
            traveller.setCyrillicName(TextUtil.translit((String)name, (boolean)false));
            traveller.setPassport(passport);
            travellers.add(traveller);
            places = new ArrayList<String>();
            String place = fields[27];
            if (place != null) {
                places.addAll(Arrays.asList(place.split(",")));
            }
            tariffVat = null;
            if (fields.length > 28) {
                try {
                    tariffVat = new BigDecimal(fields[28]);
                }
                catch (NumberFormatException e) {
                    messages.add(MessageHelper.createWarningMessage((String)Messages.SPGDExchangeProcessor_noNds, (String)L10nResourcesManager.getStr((String)Messages.SPGDExchangeProcessor_taxValueNotNumber, (Object[])new Object[0]), (Object[])new Object[0]));
                }
            }
            providerSystemNumber = null;
            if (fields.length > 29) {
                providerSystemNumber = fields[29];
            }
        } else {
            throw new Exception("Corrupted record!");
        }
        String blankTypeCode = BLANK_TYPE_CODE;
        String blankOwnerCode = BLANK_OWNER_CODE;
        String providerCode = PROVIDER_CODE;
        String carrierNumber = CARRIER_NUMBER;
        TicketType ticketType = TicketType.OWN;
        spgdData = (SPGDData)spgdDataFactory.createObject();
        spgdData.setContent(content);
        spgdData.setValidatorCode(validatorCode);
        spgdData.setPccCode(pccCode);
        spgdData.setTransactionType(transactionType);
        spgdData.setIssueDate(issueDate);
        spgdData.setAgentCode(agentCode);
        spgdData.setPNR(pnr);
        spgdData.setSystemNumber(systemNumber);
        spgdData.setTariffFareByCash(tariffFareByCash);
        spgdData.setTariffFareByCheck(tariffFareByCheck);
        spgdData.setDepartureStation((DictionaryReference<RailwayStation>)departureStation);
        spgdData.setArriveStation((DictionaryReference<RailwayStation>)arriveStation);
        spgdData.setTrainNumber(trainNumber);
        spgdData.setSlot(slot);
        spgdData.setDepartureDate(departureDate);
        spgdData.setArriveDate(arriveDate);
        spgdData.setCarriageNumber(carriageNumber);
        spgdData.setCarriageType(carriageType);
        spgdData.setProviderSystemNumber(providerSystemNumber);
        spgdData.setTariffFare(tariffFare);
        spgdData.setBlankTypeCode(blankTypeCode);
        spgdData.setBlankOwnerCode(blankOwnerCode);
        spgdData.setProviderCode(providerCode);
        spgdData.setCarrierNumber(carrierNumber);
        spgdData.setTicketType(ticketType);
        spgdData.getTravellers().clear();
        spgdData.getTravellers().addAll(travellers);
        spgdData.getPlaces().clear();
        spgdData.getPlaces().addAll(places);
        spgdData.setTariffVat(tariffVat);
        spgdData.getMessages().clear();
        spgdData.getMessages().addAll(messages);
        return spgdData;
    }

    private DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    protected void updateDocumentData(SPGDExchangeDocument index, SPGDData spgdData) {
        index.setSystemNumber(spgdData.getSystemNumber());
        index.setTransactionType(spgdData.getTransactionType());
        index.setIssued(spgdData.getIssueDate());
        index.getTravellers().clear();
        for (Traveller traveller : spgdData.getTravellers()) {
            index.getTravellers().add(traveller.getName());
        }
    }

    private CarriageType getCarriageType(String carriageTypeCode) {
        if (!TextUtil.isBlank((String)carriageTypeCode)) {
            if (carriageTypeCode.equals("\u041b")) {
                return CarriageType.L;
            }
            if (carriageTypeCode.equals("\u041c")) {
                return CarriageType.M;
            }
            if (carriageTypeCode.equals("\u041a")) {
                return CarriageType.K;
            }
            if (carriageTypeCode.equals("\u041f")) {
                return CarriageType.P;
            }
            if (carriageTypeCode.equals("\u0421")) {
                return CarriageType.S;
            }
            if (carriageTypeCode.equals("\u041e")) {
                return CarriageType.O;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFakeDocument(ObjectFactory<EntityContainer<SPGDExchangeDocument>> spgdExchangeDocumentFactory, String user, ExchangeFile file, String key, Exception e, Object ... parameters) throws Exception {
        EntityContainer container = (EntityContainer)spgdExchangeDocumentFactory.createObject();
        container.setCreatedBy(user);
        container.setModifiedBy(user);
        container.setCreated(new Date());
        container.setModified(new Date());
        SPGDExchangeDocument index = (SPGDExchangeDocument)container.getEntity();
        index.setCreated(file.getCreated());
        index.setCheckSum(null);
        index.setLocation(file.getLocation());
        index.setContent(file.getContent());
        index.setStatus(ExceptionUtil.isInterruptedError((Throwable)e) ? ProcessingStatus.UNPROCESSED : ProcessingStatus.ERROR);
        index.setContentType(ContentType.TEXT);
        Message message = MessageHelper.createErrorMessage((String)key, (Object[])parameters);
        index.getMessages().add(message);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream((OutputStream)baos, true, "utf-8"));
            message.setDetails(baos.toString("utf-8"));
        }
        EntityStorage.get().save(container, true);
        this.logErrorMessage(message, file.getLocation());
    }

    protected void logErrorMessage(Message message, String fileName) {
        String errorString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.error(String.format("File \"%s\" was processed with error:\n%s", fileName, errorString));
            return;
        }
        this.log.error(String.format("File \"%s\" was processed with error:\n%s\nDetails: %s", fileName, errorString, message.getDetails()));
    }

    protected void logWarning(Message message, String fileName) {
        String warningString = LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage(), Locale.ENGLISH);
        if (TextUtil.isBlank((String)message.getDetails())) {
            this.log.warn(String.format("File \"%s\" was processed with warning:\n%s", fileName, warningString));
            return;
        }
        this.log.debug(String.format("File \"%s\" was processed with warning:\n%s\nDetails: %s", fileName, warningString, message.getDetails()));
    }
}

